/*
 * Decompiled with CFR 0.152.
 */
package com.cra.pao.fvu;

import com.cra.common.util.CommonValidation;
import com.cra.pao.fvu.FvuConstants;
import com.cra.pao.fvu.SubContrFileFormatValidator;
import com.cra.pao.vo.PAOContrErrorFileVO;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileHeaderValidation {
    private String noOfBtchs = null;
    private String fhRecordHash = null;
    private String fvuVersion = null;
    private String fvuFileLevelHash = null;
    private String samVersion = null;
    private String samFileLevelHash = null;
    private String scmVersion = null;
    private String scmFileLevelHash = null;
    private String filler = null;
    private String prn = null;

    void fhFieldValidator(SubContrFileFormatValidator objReadFH, int lineCountP, String[] fhRecord, ArrayList<PAOContrErrorFileVO> listErrorVO, int utilityLevel) {
        if (fhRecord.length >= 3) {
            objReadFH.uploadBy = fhRecord[2];
        }
        if (objReadFH.uploadBy != null && objReadFH.uploadBy.equals("U")) {
            objReadFH.PAO_FH_FIELD_4 = FvuConstants.PAO_FH_FIELD[13];
            objReadFH.sectorCategory = "2";
        } else if (objReadFH.uploadBy != null && objReadFH.uploadBy.equals("P")) {
            objReadFH.PAO_FH_FIELD_4 = FvuConstants.PAO_FH_FIELD[4];
            objReadFH.sectorCategory = "0";
        } else if (objReadFH.uploadBy != null && objReadFH.uploadBy.equals("O")) {
            objReadFH.PAO_FH_FIELD_4 = FvuConstants.PAO_FH_FIELD[14];
            objReadFH.sectorCategory = "1";
        } else if (objReadFH.uploadBy != null && (objReadFH.uploadBy.equals("X") || objReadFH.uploadBy.equals("Y"))) {
            objReadFH.PAO_FH_FIELD_4 = FvuConstants.PAO_FH_FIELD[15];
            objReadFH.sectorCategory = "3";
        }
        if (!objReadFH.inValidFhCaretCount && objReadFH.uploadBy != null && (objReadFH.uploadBy.equals("U") || objReadFH.uploadBy.equals("P") || objReadFH.uploadBy.equals("O") || objReadFH.uploadBy.equals("X") || objReadFH.uploadBy.equals("Y"))) {
            objReadFH.lineNo = fhRecord[0];
            objReadFH.recType = fhRecord[1];
            objReadFH.uploadBy = fhRecord[2];
            objReadFH.uploaderId = fhRecord[3];
            this.noOfBtchs = fhRecord[4];
            this.fhRecordHash = fhRecord[5];
            this.fvuVersion = fhRecord[6];
            this.fvuFileLevelHash = fhRecord[7];
            this.filler = fhRecord[8];
            this.prn = fhRecord[9];
            this.samVersion = fhRecord[10];
            this.samFileLevelHash = fhRecord[11];
            if (objReadFH.lineNo == FvuConstants.FIELD_NULL) {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD[1], 201001, "-", "-", "-", "-", "-", "-"));
                objReadFH.lineNo = "-";
            } else if (objReadFH.lineNo.trim().length() > 9 || objReadFH.lineNo.length() > 9) {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD[1], 201005, "-", "-", "-", "-", objReadFH.lineNo, "-"));
            } else if (objReadFH.lineNo.length() <= 9) {
                String fhLineNum = CommonValidation.trimInnerSpaces(objReadFH.lineNo);
                if (CommonValidation.isInt(fhLineNum)) {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD[1], 201002, "-", "-", "-", "-", objReadFH.lineNo, "-"));
                } else if (!fhLineNum.equals(objReadFH.lineNo)) {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD[1], 201003, "-", "-", "-", "-", objReadFH.lineNo, "-"));
                } else if (Integer.parseInt(objReadFH.lineNo.trim()) != lineCountP) {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD[1], 201004, "-", "-", "-", "-", objReadFH.lineNo, "-"));
                }
            } else if (objReadFH.lineNo.trim().length() != objReadFH.lineNo.length()) {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD[1], 201003, "-", "-", "-", "-", objReadFH.lineNo, "-"));
            }
            if (objReadFH.recType == FvuConstants.FIELD_NULL) {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD[2], 201001, "File Header Record", "-", "-", "-", objReadFH.lineNo, "-"));
            } else if (!objReadFH.recType.equals("FH")) {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD[2], 201006, "File Header Record", "-", "-", "-", objReadFH.lineNo, "-"));
            }
            if (objReadFH.uploadBy == FvuConstants.FIELD_NULL) {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD[3], 201001, "File Header Record", "-", "-", "-", objReadFH.lineNo, "-"));
                objReadFH.controlSheetBuffer.append("-^");
            } else if (!(objReadFH.uploadBy.equals("P") || objReadFH.uploadBy.equals("U") || objReadFH.uploadBy.equals("O") || objReadFH.uploadBy.equals("X") || objReadFH.uploadBy.equals("Y"))) {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD[3], 201007, "File Header Record", "-", "-", "-", objReadFH.lineNo, "-"));
                objReadFH.controlSheetBuffer.append("-^");
            } else {
                objReadFH.controlSheetBuffer.append(String.valueOf(objReadFH.uploadBy) + "^");
            }
            if (objReadFH.uploaderId == FvuConstants.FIELD_NULL) {
                listErrorVO.add(new PAOContrErrorFileVO(objReadFH.PAO_FH_FIELD_4, 201001, "File Header Record", "-", "-", "-", objReadFH.lineNo, "-"));
                objReadFH.invalidAIN = true;
            } else if (objReadFH.uploaderId.trim().length() != objReadFH.uploaderId.length()) {
                listErrorVO.add(new PAOContrErrorFileVO(objReadFH.PAO_FH_FIELD_4, 201003, "File Header Record", "-", "-", "-", objReadFH.lineNo, "-"));
                objReadFH.invalidAIN = true;
            } else if (objReadFH.uploadBy != FvuConstants.FIELD_NULL && objReadFH.uploaderId != FvuConstants.FIELD_NULL) {
                if (objReadFH.uploaderId.trim().length() != 7 && objReadFH.uploaderId.length() != 7) {
                    listErrorVO.add(new PAOContrErrorFileVO(objReadFH.PAO_FH_FIELD_4, 201008, "File Header Record", "-", "-", "-", objReadFH.lineNo, "-"));
                    objReadFH.invalidAIN = true;
                } else if (CommonValidation.isInt(objReadFH.uploaderId)) {
                    listErrorVO.add(new PAOContrErrorFileVO(objReadFH.PAO_FH_FIELD_4, 201002, "File Header Record", "-", "-", "-", objReadFH.lineNo, "-"));
                    objReadFH.invalidAIN = true;
                } else if (objReadFH.uploaderId.startsWith("0")) {
                    listErrorVO.add(new PAOContrErrorFileVO(objReadFH.PAO_FH_FIELD_4, 201002, "File Header Record", "-", "-", "-", objReadFH.lineNo, "-"));
                    objReadFH.invalidAIN = true;
                } else if (CommonValidation.checkID(objReadFH.uploaderId)) {
                    listErrorVO.add(new PAOContrErrorFileVO(objReadFH.PAO_FH_FIELD_4, 201002, "File Header Record", "-", "-", "-", objReadFH.lineNo, "-"));
                    objReadFH.invalidAIN = true;
                }
            }
            if (this.noOfBtchs == FvuConstants.FIELD_NULL) {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD[5], 201001, "File Header Record", "-", "-", "-", objReadFH.lineNo, "-"));
                objReadFH.controlSheetBuffer.append("-^");
            } else if (this.noOfBtchs.length() > 9) {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD[5], 201005, "File Header Record", "-", "-", "-", objReadFH.lineNo, "-"));
                objReadFH.controlSheetBuffer.append("-^");
            } else if (this.noOfBtchs.length() <= 9) {
                String numOfBatches = CommonValidation.trimInnerSpaces(this.noOfBtchs);
                if (CommonValidation.isInt(numOfBatches)) {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD[5], 201002, "File Header Record", "-", "-", "-", objReadFH.lineNo, "-"));
                    objReadFH.controlSheetBuffer.append("-^");
                } else if (!numOfBatches.equals(this.noOfBtchs)) {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD[5], 201003, "File Header Record", "-", "-", "-", objReadFH.lineNo, "-"));
                    objReadFH.controlSheetBuffer.append("-^");
                } else if (Integer.parseInt(this.noOfBtchs.trim()) != 1) {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD[5], 201010, "File Header Record", "-", "-", "-", objReadFH.lineNo, "-"));
                    objReadFH.controlSheetBuffer.append("-^");
                } else if (this.noOfBtchs.trim().length() != this.noOfBtchs.length()) {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD[5], 201003, "File Header Record", "-", "-", "-", objReadFH.lineNo, "-"));
                    objReadFH.controlSheetBuffer.append("-^");
                } else {
                    objReadFH.controlSheetBuffer.append(String.valueOf(this.noOfBtchs) + "^");
                }
            }
            if (utilityLevel != 0) {
                if (this.fvuVersion == FvuConstants.FIELD_NULL) {
                    objReadFH.controlSheetBuffer.append("0^");
                } else {
                    objReadFH.controlSheetBuffer.append(String.valueOf(this.fvuVersion) + "^");
                }
            } else {
                objReadFH.controlSheetBuffer.append("-^");
            }
            if (utilityLevel == 4) {
                if (this.samVersion == FvuConstants.FIELD_NULL) {
                    objReadFH.controlSheetBuffer.append("0^");
                } else {
                    objReadFH.controlSheetBuffer.append(String.valueOf(this.samVersion) + "^");
                }
            } else {
                objReadFH.controlSheetBuffer.append("-^");
            }
            if (utilityLevel == 4) {
                if (this.prn == FvuConstants.FIELD_NULL) {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD[10], 201001, "File Header Record", "-", "-", "-", objReadFH.lineNo, "-"));
                    objReadFH.controlSheetBuffer.append("-^");
                } else if (this.prn.trim().length() != 15 || this.prn.length() != 15) {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD[10], 201020, "File Header Record", "-", "-", "-", objReadFH.lineNo, "-"));
                    objReadFH.controlSheetBuffer.append("-^");
                } else if (CommonValidation.checkTabSpaces(this.prn)) {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD[10], 201003, "File Header Record", "-", "-", "-", objReadFH.lineNo, "-"));
                    objReadFH.controlSheetBuffer.append("-^");
                } else if (CommonValidation.isInt(this.prn)) {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD[10], 201002, "File Header Record", "-", "-", "-", objReadFH.lineNo, "-"));
                    objReadFH.controlSheetBuffer.append("-^");
                } else {
                    objReadFH.controlSheetBuffer.append(String.valueOf(this.prn) + "^");
                }
            } else {
                objReadFH.controlSheetBuffer.append("-^");
            }
        }
    }
}

