/*
 * Decompiled with CFR 0.152.
 */
package com.cra.pao.fvu;

import com.cra.common.util.CommonValidation;
import com.cra.pao.fvu.FvuConstants;
import com.cra.pao.fvu.SubContrFileFormatValidator;
import com.cra.pao.vo.PAOContrErrorFileVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DDORecordValidation {
    private String tierTwoTotalSelfContributionOfSD = null;
    private int previousDDOSrNo = 0;
    public String totalCountOfSubscribers = null;
    public String totalGovtContributionAmount = null;
    public String totalSelfContributionAmount = null;
    private boolean invalidDecimalNumberAtDdo = false;
    public String ddoRecordHash = null;

    void ddoFieldValidator(SubContrFileFormatValidator objReadDH, int lineCountP, String ddoRecord, ArrayList<PAOContrErrorFileVO> listErrorVO, int utilityLevel) {
        boolean fieldFound = false;
        boolean carretFound = false;
        int caretCounter = 0;
        int localFieldCountDDO = 1;
        objReadDH.lineNo = "";
        objReadDH.recType = "";
        StringTokenizer StrTokenizerDDO = new StringTokenizer(ddoRecord, "^", true);
        while (StrTokenizerDDO.hasMoreTokens()) {
            String value = StrTokenizerDDO.nextToken();
            fieldFound = false;
            if (value.equals("^") && carretFound || value.trim().length() == 0) {
                fieldFound = true;
            }
            if (value.equals("^")) {
                carretFound = true;
                if (caretCounter == 0 && localFieldCountDDO == 1) {
                    objReadDH.lineNo = "";
                }
                ++caretCounter;
            } else {
                carretFound = false;
                fieldFound = true;
            }
            if (localFieldCountDDO > 10) break;
            if (!fieldFound) continue;
            switch (localFieldCountDDO) {
                case 1: {
                    objReadDH.lineNo = value;
                    break;
                }
                case 2: {
                    objReadDH.recType = value;
                    break;
                }
                case 3: {
                    objReadDH.batchNo = value;
                    break;
                }
                case 4: {
                    objReadDH.ddoSerialNo = value;
                    break;
                }
                case 5: {
                    objReadDH.ddoId = value;
                    break;
                }
                case 6: {
                    objReadDH.totalCountOfSD = value;
                    break;
                }
                case 7: {
                    this.totalGovtContributionAmount = value;
                    break;
                }
                case 8: {
                    this.totalSelfContributionAmount = value;
                    break;
                }
                case 9: {
                    this.tierTwoTotalSelfContributionOfSD = value;
                    break;
                }
                case 10: {
                    this.ddoRecordHash = value;
                }
            }
            ++localFieldCountDDO;
        }
        if (objReadDH.uploadBy.equals("U")) {
            objReadDH.RECTYPE_DDOREC = "POP-SP Header Record";
            objReadDH.PAO_DDO_FIELD_4 = FvuConstants.PAO_DDO_FIELD[11];
            objReadDH.PAO_DDO_FIELD_5 = FvuConstants.PAO_DDO_FIELD[12];
            objReadDH.PAO_DDO_FIELD_7 = FvuConstants.PAO_DDO_FIELD[13];
            objReadDH.PAO_DDO_FIELD_8 = FvuConstants.PAO_DDO_FIELD[14];
            objReadDH.PAO_DDO_FIELD_10 = FvuConstants.PAO_DDO_FIELD[15];
        } else if (objReadDH.uploadBy.equals("P")) {
            objReadDH.RECTYPE_DDOREC = "NL-CC Header Record";
            objReadDH.PAO_DDO_FIELD_4 = FvuConstants.PAO_DDO_FIELD[4];
            objReadDH.PAO_DDO_FIELD_5 = FvuConstants.PAO_DDO_FIELD[5];
            objReadDH.PAO_DDO_FIELD_7 = FvuConstants.PAO_DDO_FIELD[7];
            objReadDH.PAO_DDO_FIELD_8 = FvuConstants.PAO_DDO_FIELD[8];
            objReadDH.PAO_DDO_FIELD_10 = FvuConstants.PAO_DDO_FIELD[10];
        } else if (objReadDH.uploadBy.equals("O")) {
            objReadDH.RECTYPE_DDOREC = "DTO Header Record";
            objReadDH.PAO_DDO_FIELD_4 = FvuConstants.PAO_DDO_FIELD[16];
            objReadDH.PAO_DDO_FIELD_5 = FvuConstants.PAO_DDO_FIELD[17];
            objReadDH.PAO_DDO_FIELD_7 = FvuConstants.PAO_DDO_FIELD[7];
            objReadDH.PAO_DDO_FIELD_8 = FvuConstants.PAO_DDO_FIELD[8];
            objReadDH.PAO_DDO_FIELD_10 = FvuConstants.PAO_DDO_FIELD[18];
        } else if (objReadDH.uploadBy.equals("X") || objReadDH.uploadBy.equals("Y")) {
            objReadDH.RECTYPE_DDOREC = "NL-AO/NL-CC Header Record";
            objReadDH.PAO_DDO_FIELD_4 = FvuConstants.PAO_DDO_FIELD[4];
            objReadDH.PAO_DDO_FIELD_5 = FvuConstants.PAO_DDO_FIELD[5];
            objReadDH.PAO_DDO_FIELD_7 = FvuConstants.PAO_DDO_FIELD[7];
            objReadDH.PAO_DDO_FIELD_8 = FvuConstants.PAO_DDO_FIELD[14];
            objReadDH.PAO_DDO_FIELD_10 = FvuConstants.PAO_DDO_FIELD[10];
        }
        if (caretCounter != 9) {
            objReadDH.invalidDdoCaretCount = true;
            listErrorVO.add(new PAOContrErrorFileVO("-", Integer.parseInt(String.valueOf(objReadDH.sectorCategory) + 203000), objReadDH.RECTYPE_DDOREC, "-", "-", "-", String.valueOf(lineCountP), "-"));
        }
        if (!objReadDH.invalidDdoCaretCount) {
            if (objReadDH.lineNo.equals(FvuConstants.FIELD_NULL) || objReadDH.lineNo.equals("^")) {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[1], Integer.parseInt(String.valueOf(objReadDH.sectorCategory) + 203000), objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", "-", "-"));
                objReadDH.lineNo = "-";
            } else if (objReadDH.lineNo.trim().length() > 9 || objReadDH.lineNo.length() > 9) {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[1], 203005, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
            } else if (objReadDH.lineNo.length() <= 9) {
                String bhLineNum = CommonValidation.trimInnerSpaces(objReadDH.lineNo);
                if (CommonValidation.isInt(bhLineNum)) {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[1], 203002, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
                } else if (!bhLineNum.equals(objReadDH.lineNo)) {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[1], 203003, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
                } else if (Integer.parseInt(objReadDH.lineNo.trim()) != lineCountP) {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[1], 203004, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
                }
            } else if (objReadDH.lineNo.trim().length() != objReadDH.lineNo.length()) {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[1], 203003, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
            }
            if (objReadDH.recType.equals(FvuConstants.FIELD_NULL) || objReadDH.recType.equals("^")) {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[2], 203001, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
            } else if (!objReadDH.recType.equals("DH")) {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[2], 203006, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
            }
            if (objReadDH.batchNo.equals(FvuConstants.FIELD_NULL) || objReadDH.batchNo.equals("^")) {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[3], 203001, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
            } else if (objReadDH.batchNo.trim().length() > 9 || objReadDH.batchNo.length() > 9) {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[3], 203005, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
            } else if (objReadDH.batchNo.trim().length() != objReadDH.batchNo.length()) {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[3], 203002, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
            } else if (CommonValidation.checkTabSpaces(objReadDH.batchNo)) {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[3], 203002, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
            } else if (objReadDH.batchNo.length() <= 9) {
                String batchNumber = CommonValidation.trimInnerSpaces(objReadDH.batchNo);
                if (CommonValidation.isInt(batchNumber)) {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[3], 203002, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
                } else if (!batchNumber.equals(objReadDH.batchNo)) {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[3], 203003, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
                } else if (Integer.parseInt(objReadDH.batchNo.trim()) != 1) {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[3], 203007, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
                }
            } else if (objReadDH.batchNo.trim().length() != objReadDH.batchNo.length()) {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[3], 203003, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
            }
            if (objReadDH.ddoSerialNo.equals(FvuConstants.FIELD_NULL) || objReadDH.ddoSerialNo.equals("^")) {
                objReadDH.inValidfirstDDOSerialNo = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_4, 203001, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
                ++this.previousDDOSrNo;
            } else if (objReadDH.ddoSerialNo.trim().length() > 9 || objReadDH.ddoSerialNo.length() > 9) {
                objReadDH.inValidfirstDDOSerialNo = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_4, 203005, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
                ++this.previousDDOSrNo;
            } else if (objReadDH.ddoSerialNo.trim().length() != objReadDH.ddoSerialNo.length()) {
                objReadDH.inValidfirstDDOSerialNo = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_4, 203003, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
                ++this.previousDDOSrNo;
            } else if (!CommonValidation.trimInnerSpaces(objReadDH.ddoSerialNo).equals(objReadDH.ddoSerialNo)) {
                objReadDH.inValidfirstDDOSerialNo = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_4, 203003, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
                ++this.previousDDOSrNo;
            } else if (CommonValidation.checkTabSpaces(objReadDH.ddoSerialNo)) {
                objReadDH.inValidfirstDDOSerialNo = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_4, 203003, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
                ++this.previousDDOSrNo;
            } else if (CommonValidation.isInt(objReadDH.ddoSerialNo)) {
                objReadDH.inValidfirstDDOSerialNo = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_4, 203002, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
                ++this.previousDDOSrNo;
            } else if (Integer.parseInt(objReadDH.ddoSerialNo.trim()) < 1) {
                objReadDH.inValidfirstDDOSerialNo = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_4, 203008, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
            } else if (objReadDH.totalNoOfDDORead == 1) {
                if (Integer.parseInt(objReadDH.ddoSerialNo.trim()) != 1) {
                    objReadDH.inValidfirstDDOSerialNo = true;
                    listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_4, 203008, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
                } else {
                    this.previousDDOSrNo = Integer.parseInt(objReadDH.ddoSerialNo.trim());
                }
            } else if (objReadDH.totalNoOfDDORead > 1 && !objReadDH.inValidfirstDDOSerialNo && !objReadDH.invalidDdoCaretCount) {
                if (Integer.parseInt(objReadDH.ddoSerialNo.trim()) != this.previousDDOSrNo + 1) {
                    listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_4, 203004, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
                } else {
                    this.previousDDOSrNo = Integer.parseInt(objReadDH.ddoSerialNo.trim());
                }
            }
            if (objReadDH.ddoId.equals(FvuConstants.FIELD_NULL) || objReadDH.ddoId.equals("^")) {
                objReadDH.invalidTAN = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_5, 203001, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
            } else if (objReadDH.ddoId.trim().length() != objReadDH.ddoId.length()) {
                objReadDH.invalidTAN = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_5, 203003, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
            } else if (CommonValidation.checkTabSpaces(objReadDH.ddoId)) {
                objReadDH.invalidTAN = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_5, 203003, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
            } else if (!(!objReadDH.uploadBy.equals("Y") || objReadDH.ddoId.trim().length() == 10 && objReadDH.ddoId.length() == 10 || objReadDH.ddoId.trim().length() == 7 && objReadDH.ddoId.length() == 7)) {
                objReadDH.invalidTAN = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_5, 203009, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
            } else if (objReadDH.uploadBy.equals("X") && (objReadDH.ddoId.trim().length() != 7 || objReadDH.ddoId.length() != 7)) {
                objReadDH.invalidTAN = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_5, 201008, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
            } else if (objReadDH.ddoId.trim().length() == 10 || objReadDH.ddoId.length() == 10) {
                if (CommonValidation.isAlphaNum(objReadDH.ddoId) || CommonValidation.checkTan(objReadDH.ddoId)) {
                    objReadDH.invalidTAN = true;
                    listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_5, 203002, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
                }
            } else if (objReadDH.ddoId.trim().length() == 7 || objReadDH.ddoId.length() == 7) {
                if (CommonValidation.isInt(objReadDH.ddoId)) {
                    objReadDH.invalidTAN = true;
                    listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_5, 203002, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
                } else if (CommonValidation.checkID(objReadDH.ddoId)) {
                    objReadDH.invalidTAN = true;
                    listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_5, 203002, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
                }
            }
            if (objReadDH.totalCountOfSD.equals(FvuConstants.FIELD_NULL) || objReadDH.totalCountOfSD.equals("^")) {
                objReadDH.invalidSubCount = true;
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[6], 203001, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
            } else if (objReadDH.totalCountOfSD.length() > 9 && objReadDH.totalCountOfSD.trim().length() > 9) {
                objReadDH.invalidSubCount = true;
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[6], 203005, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
            } else if (objReadDH.totalCountOfSD.trim().length() != objReadDH.totalCountOfSD.length()) {
                objReadDH.invalidSubCount = true;
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[6], 203003, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
            } else if (CommonValidation.checkTabSpaces(objReadDH.totalCountOfSD)) {
                objReadDH.invalidSubCount = true;
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[6], 203003, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
            } else if (CommonValidation.isInt(objReadDH.totalCountOfSD)) {
                objReadDH.invalidSubCount = true;
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[6], 203002, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
            } else if (Integer.parseInt(objReadDH.totalCountOfSD.trim()) == 0) {
                objReadDH.invalidSubCount = true;
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[6], 203010, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
            } else {
                objReadDH.setTotalSubscriberCount(objReadDH.totalCountOfSD);
            }
            if (this.totalGovtContributionAmount.equals(FvuConstants.FIELD_NULL) || this.totalGovtContributionAmount.equals("^")) {
                objReadDH.invalidTotalContributionInDDO = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_7, 203001, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
            } else if (this.totalGovtContributionAmount.length() > 21) {
                objReadDH.invalidTotalContributionInDDO = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_7, 203005, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
            } else if (CommonValidation.checkTabSpaces(this.totalGovtContributionAmount)) {
                objReadDH.invalidTotalContributionInDDO = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_7, 203003, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
            } else if (CommonValidation.isDecimalNumber(this.totalGovtContributionAmount)) {
                objReadDH.invalidTotalContributionInDDO = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_7, 203002, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
            } else if (this.totalGovtContributionAmount.trim().length() != this.totalGovtContributionAmount.length()) {
                objReadDH.invalidTotalContributionInDDO = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_7, 203003, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
            } else if (!(utilityLevel == 5 || objReadDH.uploadBy.equals("U") || objReadDH.uploadBy.equals("X") || objReadDH.uploadBy.equals("Y") || Double.parseDouble(this.totalGovtContributionAmount) != 0.0)) {
                objReadDH.invalidTotalContributionInDDO = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_7, 202031, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
            } else {
                objReadDH.setDdoTierOneGovtContribution(this.totalGovtContributionAmount);
                if (objReadDH.totalTierOneGovtAmt != null) {
                    objReadDH.totalTierOneGovtAmt = objReadDH.totalTierOneGovtAmt.add(new BigDecimal(this.totalGovtContributionAmount.trim()));
                }
            }
            if (this.totalSelfContributionAmount.equals(FvuConstants.FIELD_NULL) || this.totalSelfContributionAmount.equals("^")) {
                objReadDH.invalidTotalContributionInDDO = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_8, 203001, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
            } else if (this.totalSelfContributionAmount.length() > 21) {
                objReadDH.invalidTotalContributionInDDO = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_8, 203005, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
            } else if (CommonValidation.checkTabSpaces(this.totalSelfContributionAmount)) {
                objReadDH.invalidTotalContributionInDDO = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_8, 203003, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
            } else if (CommonValidation.isDecimalNumber(this.totalSelfContributionAmount)) {
                objReadDH.invalidTotalContributionInDDO = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_8, 203002, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
            } else if (this.totalSelfContributionAmount.trim().length() != this.totalSelfContributionAmount.length()) {
                objReadDH.invalidTotalContributionInDDO = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_8, 203003, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
            } else if (utilityLevel != 5 && !objReadDH.uploadBy.equals("X") && !objReadDH.uploadBy.equals("Y") && Double.parseDouble(this.totalSelfContributionAmount) == 0.0) {
                objReadDH.invalidTotalContributionInDDO = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_8, 202031, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
            } else if (!(utilityLevel == 5 || objReadDH.uploadBy.equals("U") || objReadDH.uploadBy.equals("X") || objReadDH.uploadBy.equals("Y") || this.totalGovtContributionAmount.equals(this.totalSelfContributionAmount))) {
                objReadDH.invalidTotalContributionInDDO = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_8, 203012, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
            } else {
                objReadDH.setDdoTierOneSelfContribution(this.totalSelfContributionAmount);
                if (objReadDH.totalTierOneSelfAmt != null) {
                    objReadDH.totalTierOneSelfAmt = objReadDH.totalTierOneSelfAmt.add(new BigDecimal(this.totalSelfContributionAmount.trim()));
                }
            }
            if (this.tierTwoTotalSelfContributionOfSD != FvuConstants.FIELD_NULL && !this.tierTwoTotalSelfContributionOfSD.equals("^")) {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[9], 203017, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-", String.valueOf(objReadDH.lineNo), "-"));
            }
        }
    }
}

