/*
 * Decompiled with CFR 0.152.
 */
package com.cra.pao.fvu;

import com.cra.common.util.CommonValidation;
import com.cra.common.util.encrypt.LuhnsAlgorithm;
import com.cra.pao.fvu.FvuConstants;
import com.cra.pao.fvu.SubContrFileFormatValidator;
import com.cra.pao.vo.PAOContrErrorFileVO;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchValidation {
    private String AIN = null;
    private String fileCreationDate = null;
    private String batchID = null;
    private String transactionId = null;
    private String tierTwoTotalSelfContributionOfDDO = null;
    private boolean invalidBH_AIN = false;
    private String bhRecordHash = null;

    void bhFieldValidator(SubContrFileFormatValidator objReadBH, int lineCountP, String[] bhRecord, ArrayList<PAOContrErrorFileVO> listErrorVO, int utilityLevel) {
        if (!objReadBH.inValidBhCaretCount) {
            objReadBH.lineNo = bhRecord[0];
            objReadBH.recType = bhRecord[1];
            objReadBH.batchNo = bhRecord[2];
            objReadBH.typeOfUploadedFile = bhRecord[3];
            this.AIN = bhRecord[4];
            this.fileCreationDate = bhRecord[5];
            this.batchID = bhRecord[6];
            this.transactionId = bhRecord[7];
            objReadBH.totalCountOfDDO = bhRecord[8];
            objReadBH.totalCountOfSubscribers = bhRecord[9];
            objReadBH.batchTotalGovtContrbutionOfDDO = bhRecord[10];
            objReadBH.batchTotalSelfContrbutionOfDDO = bhRecord[11];
            this.tierTwoTotalSelfContributionOfDDO = bhRecord[12];
            objReadBH.totalOfTierOneTierTwo = bhRecord[13];
            this.bhRecordHash = bhRecord[14];
            if (objReadBH.uploadBy.equals("U")) {
                objReadBH.PAO_BH_FIELD_5 = FvuConstants.PAO_BH_FIELD[16];
                objReadBH.PAO_BH_FIELD_9 = FvuConstants.PAO_BH_FIELD[17];
                objReadBH.PAO_BH_FIELD_11 = FvuConstants.PAO_BH_FIELD[18];
                objReadBH.PAO_BH_FIELD_12 = FvuConstants.PAO_BH_FIELD[19];
            } else if (objReadBH.uploadBy.equals("P")) {
                objReadBH.PAO_BH_FIELD_5 = FvuConstants.PAO_BH_FIELD[5];
                objReadBH.PAO_BH_FIELD_9 = FvuConstants.PAO_BH_FIELD[9];
                objReadBH.PAO_BH_FIELD_11 = FvuConstants.PAO_BH_FIELD[11];
                objReadBH.PAO_BH_FIELD_12 = FvuConstants.PAO_BH_FIELD[12];
            } else if (objReadBH.uploadBy.equals("O")) {
                objReadBH.PAO_BH_FIELD_5 = FvuConstants.PAO_BH_FIELD[20];
                objReadBH.PAO_BH_FIELD_9 = FvuConstants.PAO_BH_FIELD[21];
                objReadBH.PAO_BH_FIELD_11 = FvuConstants.PAO_BH_FIELD[11];
                objReadBH.PAO_BH_FIELD_12 = FvuConstants.PAO_BH_FIELD[12];
            } else if (objReadBH.uploadBy.equals("X") || objReadBH.uploadBy.equals("Y")) {
                objReadBH.PAO_BH_FIELD_5 = FvuConstants.PAO_BH_FIELD[5];
                objReadBH.PAO_BH_FIELD_9 = FvuConstants.PAO_BH_FIELD[9];
                objReadBH.PAO_BH_FIELD_11 = FvuConstants.PAO_BH_FIELD[11];
                objReadBH.PAO_BH_FIELD_12 = FvuConstants.PAO_BH_FIELD[19];
            }
            if (objReadBH.lineNo == FvuConstants.FIELD_NULL) {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[1], 202001, "Batch Header Record", "-", "-", "-", "-", "-"));
                objReadBH.lineNo = "-";
            } else if (objReadBH.lineNo.trim().length() > 9 || objReadBH.lineNo.length() > 9) {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[1], 202005, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
            } else if (objReadBH.lineNo.length() <= 9) {
                String bhLineNum = CommonValidation.trimInnerSpaces(objReadBH.lineNo);
                if (CommonValidation.isInt(bhLineNum)) {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[1], 202003, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
                } else if (!bhLineNum.equals(objReadBH.lineNo)) {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[1], 202002, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
                } else if (Integer.parseInt(objReadBH.lineNo.trim()) != lineCountP) {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[1], 202004, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
                }
            } else if (CommonValidation.checkTabSpaces(objReadBH.lineNo)) {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[1], 202002, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
            } else if (objReadBH.lineNo.trim().length() != objReadBH.lineNo.length()) {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[1], 202002, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
            }
            if (objReadBH.recType == FvuConstants.FIELD_NULL || objReadBH.recType.equals("^")) {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[2], 202001, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
            } else if (!objReadBH.recType.equals("BH")) {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[2], 202006, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
            }
            if (objReadBH.batchNo == FvuConstants.FIELD_NULL) {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[3], 202001, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
            } else if (objReadBH.batchNo.trim().length() > 9 || objReadBH.batchNo.length() > 9) {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[3], 202005, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
            } else if (objReadBH.batchNo.length() <= 9) {
                String batchNumber = CommonValidation.trimInnerSpaces(objReadBH.batchNo);
                if (CommonValidation.isInt(batchNumber)) {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[3], 202003, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
                } else if (!batchNumber.equals(objReadBH.batchNo)) {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[3], 202002, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
                } else if (Integer.parseInt(objReadBH.batchNo.trim()) != 1) {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[3], 202007, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
                }
            } else if (objReadBH.batchNo.trim().length() != objReadBH.batchNo.length()) {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[3], 202002, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
            }
            boolean invalidContrFileType = false;
            if (objReadBH.typeOfUploadedFile == FvuConstants.FIELD_NULL) {
                invalidContrFileType = true;
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[4], 202001, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
                objReadBH.controlSheetBuffer.append("-^");
            } else if (!objReadBH.typeOfUploadedFile.equals("R") && !objReadBH.typeOfUploadedFile.equals("C")) {
                invalidContrFileType = true;
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[4], 202008, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
                objReadBH.controlSheetBuffer.append("-^");
            } else {
                objReadBH.controlSheetBuffer.append(String.valueOf(objReadBH.typeOfUploadedFile) + "^");
            }
            if (this.AIN == FvuConstants.FIELD_NULL) {
                listErrorVO.add(new PAOContrErrorFileVO(objReadBH.PAO_BH_FIELD_5, 202001, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
                objReadBH.controlSheetBuffer.append("0^");
                this.invalidBH_AIN = true;
            } else if (this.AIN.trim().length() != this.AIN.length()) {
                listErrorVO.add(new PAOContrErrorFileVO(objReadBH.PAO_BH_FIELD_5, 202002, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
                objReadBH.controlSheetBuffer.append("0^");
                this.invalidBH_AIN = true;
            } else if (CommonValidation.checkTabSpaces(this.AIN)) {
                listErrorVO.add(new PAOContrErrorFileVO(objReadBH.PAO_BH_FIELD_5, 202002, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
                objReadBH.controlSheetBuffer.append("0^");
                this.invalidBH_AIN = true;
            } else if (this.AIN.trim().length() != 7 || this.AIN.length() != 7) {
                listErrorVO.add(new PAOContrErrorFileVO(objReadBH.PAO_BH_FIELD_5, 201008, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
                objReadBH.controlSheetBuffer.append("0^");
                this.invalidBH_AIN = true;
            } else if (CommonValidation.isInt(this.AIN)) {
                listErrorVO.add(new PAOContrErrorFileVO(objReadBH.PAO_BH_FIELD_5, 202003, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
                objReadBH.controlSheetBuffer.append("0^");
                this.invalidBH_AIN = true;
            } else if (CommonValidation.checkID(this.AIN)) {
                listErrorVO.add(new PAOContrErrorFileVO(objReadBH.PAO_BH_FIELD_5, 202003, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
                objReadBH.controlSheetBuffer.append("0^");
                this.invalidBH_AIN = true;
            } else if (objReadBH.uploaderId == FvuConstants.FIELD_NULL || objReadBH.invalidAIN) {
                objReadBH.controlSheetBuffer.append("0^");
            } else if (!this.AIN.equals(objReadBH.uploaderId)) {
                listErrorVO.add(new PAOContrErrorFileVO(objReadBH.PAO_BH_FIELD_5, Integer.parseInt(String.valueOf(objReadBH.sectorCategory) + 202009), "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
                objReadBH.controlSheetBuffer.append("0^");
            } else {
                objReadBH.controlSheetBuffer.append(String.valueOf(this.AIN) + "^");
            }
            if (this.fileCreationDate == FvuConstants.FIELD_NULL) {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[6], 202001, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
            } else if (this.fileCreationDate.trim().length() != 8 || this.fileCreationDate.length() != 8) {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[6], 202019, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
            } else if (CommonValidation.checkTabSpaces(this.fileCreationDate)) {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[6], 202002, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
            } else if (CommonValidation.isInt(this.fileCreationDate)) {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[6], 202003, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
            } else if (CommonValidation.isDate(this.fileCreationDate)) {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[6], 202003, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
            } else {
                String year = this.fileCreationDate.substring(4, 8);
                if (Integer.parseInt(year) < 2004) {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[6], 202029, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
                } else {
                    SimpleDateFormat sdf = new SimpleDateFormat("ddMMyyyy");
                    Date dateFromFile = new Date();
                    Date sysDate = new Date();
                    try {
                        dateFromFile = sdf.parse(this.fileCreationDate);
                        if (dateFromFile.compareTo(sysDate) > 0) {
                            listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[6], 202028, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
                            this.fileCreationDate = "-";
                        }
                    }
                    catch (ParseException pe) {
                        System.out.println("Parse Exception while Parsing date: " + pe.toString());
                    }
                    objReadBH.controlSheetBuffer.append(String.valueOf(this.fileCreationDate) + "^");
                }
            }
            if (this.batchID == FvuConstants.FIELD_NULL) {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[7], 202001, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
            } else if (this.batchID.trim().length() != 20 || this.batchID.length() != 20) {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[7], 202024, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
            } else if (CommonValidation.checkTabSpaces(this.batchID)) {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[7], 202002, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
            } else if (this.AIN != null && !this.invalidBH_AIN && !this.batchID.substring(0, 7).equals(this.AIN)) {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[7], 202032, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
            } else {
                String firstSubString = this.batchID.substring(0, 10);
                String secondSubString = this.batchID.substring(10, 20);
                if (CommonValidation.isInt(firstSubString) || CommonValidation.isInt(secondSubString)) {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[7], 202003, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
                } else {
                    objReadBH.controlSheetBuffer.append(String.valueOf(this.batchID) + "^");
                }
            }
            if (!invalidContrFileType) {
                if (objReadBH.typeOfUploadedFile.equals("R")) {
                    if (this.transactionId != FvuConstants.FIELD_NULL) {
                        listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[8], 202018, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
                    } else {
                        objReadBH.controlSheetBuffer.append("-^");
                    }
                } else if (this.transactionId == FvuConstants.FIELD_NULL) {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[8], 202001, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
                } else if (this.transactionId.trim().length() != 13 || this.transactionId.length() != 13) {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[8], 202016, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
                } else if (CommonValidation.checkTabSpaces(this.transactionId)) {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[8], 202002, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
                } else if (CommonValidation.isInt(this.transactionId)) {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[8], 202003, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
                } else if (Long.parseLong(this.transactionId.trim()) == 0L) {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[8], 202003, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
                } else if (!LuhnsAlgorithm.isValidNumber(this.transactionId)) {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[8], 202003, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
                } else {
                    objReadBH.controlSheetBuffer.append(String.valueOf(this.transactionId) + "^");
                }
            }
            if (objReadBH.totalCountOfDDO == FvuConstants.FIELD_NULL) {
                objReadBH.invalidDDOCount = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadBH.PAO_BH_FIELD_9, 202001, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
            } else if (objReadBH.totalCountOfDDO.length() > 9) {
                objReadBH.invalidDDOCount = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadBH.PAO_BH_FIELD_9, 202005, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
            } else if (objReadBH.totalCountOfDDO.trim().length() != objReadBH.totalCountOfDDO.length()) {
                objReadBH.invalidDDOCount = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadBH.PAO_BH_FIELD_9, 202002, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
            } else if (CommonValidation.checkTabSpaces(objReadBH.totalCountOfDDO)) {
                objReadBH.invalidDDOCount = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadBH.PAO_BH_FIELD_9, 202002, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
            } else {
                String bhDdoCount = CommonValidation.trimInnerSpaces(objReadBH.totalCountOfDDO);
                if (CommonValidation.isInt(bhDdoCount)) {
                    objReadBH.invalidDDOCount = true;
                    listErrorVO.add(new PAOContrErrorFileVO(objReadBH.PAO_BH_FIELD_9, 202003, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
                } else if (!bhDdoCount.equals(objReadBH.totalCountOfDDO)) {
                    objReadBH.invalidDDOCount = true;
                    listErrorVO.add(new PAOContrErrorFileVO(objReadBH.PAO_BH_FIELD_9, 202002, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
                } else if (Integer.parseInt(objReadBH.totalCountOfDDO.trim()) == 0) {
                    objReadBH.invalidDDOCount = true;
                    listErrorVO.add(new PAOContrErrorFileVO(objReadBH.PAO_BH_FIELD_9, Integer.parseInt(String.valueOf(objReadBH.sectorCategory) + 202013), "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
                } else {
                    objReadBH.controlSheetBuffer.append(String.valueOf(objReadBH.totalCountOfDDO) + "^");
                }
            }
            if (objReadBH.totalCountOfSubscribers == FvuConstants.FIELD_NULL) {
                objReadBH.invalidSubCount = true;
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[10], 202001, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
            } else if (objReadBH.totalCountOfSubscribers.length() > 9) {
                objReadBH.invalidSubCount = true;
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[10], 202005, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
            } else if (objReadBH.totalCountOfSubscribers.trim().length() != objReadBH.totalCountOfSubscribers.length()) {
                objReadBH.invalidSubCount = true;
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[10], 202002, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
            } else if (CommonValidation.checkTabSpaces(objReadBH.totalCountOfSubscribers)) {
                objReadBH.invalidSubCount = true;
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[10], 202002, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
            } else {
                String bhSubCount = CommonValidation.trimInnerSpaces(objReadBH.totalCountOfSubscribers);
                if (CommonValidation.isInt(bhSubCount)) {
                    objReadBH.invalidSubCount = true;
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[10], 202003, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
                } else if (!bhSubCount.equals(objReadBH.totalCountOfSubscribers)) {
                    objReadBH.invalidSubCount = true;
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[10], 202002, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
                } else if (Integer.parseInt(objReadBH.totalCountOfSubscribers.trim()) == 0) {
                    objReadBH.invalidSubCount = true;
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[10], 202035, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
                } else {
                    objReadBH.controlSheetBuffer.append(String.valueOf(objReadBH.totalCountOfSubscribers) + "^");
                }
            }
            if (objReadBH.batchTotalGovtContrbutionOfDDO == FvuConstants.FIELD_NULL) {
                objReadBH.invalidTotalContributionInBatch = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadBH.PAO_BH_FIELD_11, 202001, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
            } else if (objReadBH.batchTotalGovtContrbutionOfDDO.length() > 21 || objReadBH.batchTotalGovtContrbutionOfDDO.trim().length() > 21) {
                objReadBH.invalidTotalContributionInBatch = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadBH.PAO_BH_FIELD_11, 202005, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
            } else if (CommonValidation.checkTabSpaces(objReadBH.batchTotalGovtContrbutionOfDDO)) {
                objReadBH.invalidTotalContributionInBatch = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadBH.PAO_BH_FIELD_11, 202002, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
            } else if (objReadBH.batchTotalGovtContrbutionOfDDO.trim().length() != objReadBH.batchTotalGovtContrbutionOfDDO.length()) {
                objReadBH.invalidTotalContributionInBatch = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadBH.PAO_BH_FIELD_11, 202002, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
            } else if (CommonValidation.isDecimalNumber(objReadBH.batchTotalGovtContrbutionOfDDO)) {
                objReadBH.invalidTotalContributionInBatch = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadBH.PAO_BH_FIELD_11, 202003, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
            } else if (!(utilityLevel == 5 || objReadBH.uploadBy.equals("U") || objReadBH.uploadBy.equals("X") || objReadBH.uploadBy.equals("Y") || Double.parseDouble(objReadBH.batchTotalGovtContrbutionOfDDO) != 0.0)) {
                objReadBH.invalidTotalContributionInBatch = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadBH.PAO_BH_FIELD_11, 202031, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
            } else {
                objReadBH.controlSheetBuffer.append(String.valueOf(objReadBH.batchTotalGovtContrbutionOfDDO) + "^");
            }
            if (objReadBH.batchTotalSelfContrbutionOfDDO == FvuConstants.FIELD_NULL) {
                objReadBH.invalidTotalContributionInBatch = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadBH.PAO_BH_FIELD_12, 202001, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
            } else if (objReadBH.batchTotalSelfContrbutionOfDDO.length() > 21 || objReadBH.batchTotalSelfContrbutionOfDDO.trim().length() > 21) {
                objReadBH.invalidTotalContributionInBatch = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadBH.PAO_BH_FIELD_12, 202005, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
            } else if (CommonValidation.checkTabSpaces(objReadBH.batchTotalSelfContrbutionOfDDO)) {
                objReadBH.invalidTotalContributionInBatch = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadBH.PAO_BH_FIELD_12, 202002, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
            } else if (objReadBH.batchTotalSelfContrbutionOfDDO.trim().length() != objReadBH.batchTotalSelfContrbutionOfDDO.length()) {
                objReadBH.invalidTotalContributionInBatch = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadBH.PAO_BH_FIELD_12, 202002, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
            } else if (CommonValidation.isDecimalNumber(objReadBH.batchTotalSelfContrbutionOfDDO)) {
                objReadBH.invalidTotalContributionInBatch = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadBH.PAO_BH_FIELD_12, 202003, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
            } else if (utilityLevel != 5 && !objReadBH.uploadBy.equals("X") && !objReadBH.uploadBy.equals("Y") && Double.parseDouble(objReadBH.batchTotalSelfContrbutionOfDDO) == 0.0) {
                objReadBH.invalidTotalContributionInBatch = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadBH.PAO_BH_FIELD_12, 202031, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
            } else if (!(utilityLevel == 5 || objReadBH.uploadBy.equals("U") || objReadBH.uploadBy.equals("X") || objReadBH.uploadBy.equals("Y") || objReadBH.invalidTotalContributionInBatch || objReadBH.batchTotalGovtContrbutionOfDDO.equals(objReadBH.batchTotalSelfContrbutionOfDDO))) {
                objReadBH.invalidTotalContributionInBatch = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadBH.PAO_BH_FIELD_12, 202014, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
            } else {
                objReadBH.controlSheetBuffer.append(String.valueOf(objReadBH.batchTotalSelfContrbutionOfDDO) + "^");
            }
            if (this.tierTwoTotalSelfContributionOfDDO != FvuConstants.FIELD_NULL) {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[13], 202027, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
            }
            BigDecimal amountOne = null;
            BigDecimal amountTwo = null;
            BigDecimal totalBankAmt = null;
            if (objReadBH.totalOfTierOneTierTwo == FvuConstants.FIELD_NULL) {
                objReadBH.invalidTotalContributionInBatch = true;
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[14], 202001, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
            } else if (objReadBH.totalOfTierOneTierTwo.length() > 21) {
                objReadBH.invalidTotalContributionInBatch = true;
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[14], 202005, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
            } else if (CommonValidation.checkTabSpaces(objReadBH.totalOfTierOneTierTwo)) {
                objReadBH.invalidTotalContributionInBatch = true;
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[14], 202002, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
            } else if (CommonValidation.isDecimalNumber(objReadBH.totalOfTierOneTierTwo)) {
                objReadBH.invalidTotalContributionInBatch = true;
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[14], 202003, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
            } else if (objReadBH.totalOfTierOneTierTwo.trim().length() != objReadBH.totalOfTierOneTierTwo.length()) {
                objReadBH.invalidTotalContributionInBatch = true;
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[14], 202002, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
            } else if (new BigDecimal(objReadBH.totalOfTierOneTierTwo).compareTo(new BigDecimal(0.0)) == 0) {
                objReadBH.invalidTotalContributionInBatch = true;
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[14], 202031, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
            } else if (!objReadBH.invalidTotalContributionInBatch) {
                BigDecimal totalAmt = new BigDecimal(objReadBH.totalOfTierOneTierTwo);
                amountOne = new BigDecimal(objReadBH.batchTotalGovtContrbutionOfDDO);
                amountTwo = new BigDecimal(objReadBH.batchTotalSelfContrbutionOfDDO);
                totalBankAmt = amountOne.add(amountTwo);
                if (!totalAmt.equals(totalBankAmt)) {
                    objReadBH.invalidTotalContributionInBatch = true;
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[14], 202026, "Batch Header Record", "-", "-", "-", objReadBH.lineNo, "-"));
                } else {
                    objReadBH.controlSheetBuffer.append(String.valueOf(objReadBH.totalOfTierOneTierTwo) + "^");
                }
            }
        }
    }
}

