/*
 * Decompiled with CFR 0.152.
 */
package com.cra.common.util.file;

import com.cra.common.util.CRALog;
import com.cra.common.util.file.CRAFileOperations;
import com.cra.common.util.file.CRAFileUtilConfig;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRAFileReader
extends CRAFileOperations {
    private BufferedReader bufferedReader;

    public CRAFileReader(String absolutefileName) throws FileNotFoundException {
        super(absolutefileName);
        this.bufferedReader = new BufferedReader(new FileReader(absolutefileName));
    }

    public String getLine() throws IOException {
        String lineContent = this.bufferedReader.readLine();
        if (lineContent == null) {
            this.bufferedReader.close();
            return null;
        }
        return lineContent;
    }

    public String[] getLineAsArray(String regExpDelimiter) throws IOException {
        String lineContent = this.getLine();
        if (lineContent == null) {
            return null;
        }
        String[] lineAsArray = CRAFileReader.getLineParsed(lineContent, regExpDelimiter);
        return lineAsArray;
    }

    public ArrayList<String[]> getAllLinesAsArrayInArrayList(String regExpDelimiter) throws IOException {
        String[] tempStrArray = null;
        ArrayList<String[]> retArray = new ArrayList<String[]>();
        while ((tempStrArray = this.getLineAsArray(regExpDelimiter)) != null) {
            retArray.add(tempStrArray);
        }
        return retArray;
    }

    public ArrayList<String> getAllLinesInArrayList() throws IOException {
        this.bufferedReader = new BufferedReader(new FileReader(this.file));
        ArrayList<String> retArray = new ArrayList<String>();
        String tempStr = null;
        while ((tempStr = this.bufferedReader.readLine()) != null) {
            retArray.add(tempStr);
        }
        return retArray;
    }

    public static String[] getLineParsed(String lineToBeParsed, String regExpDelimiter) {
        String[] tempStr = lineToBeParsed.split(regExpDelimiter, lineToBeParsed.length());
        String[] lineAsArray = new String[tempStr.length];
        int i = 0;
        while (i < tempStr.length) {
            lineAsArray[i] = tempStr[i].length() == 0 ? null : tempStr[i];
            ++i;
        }
        return lineAsArray;
    }

    public String getFileContent() throws IOException {
        CRALog.commonLog.info("Inside getFileContent()");
        long maximumBufferSize = CRAFileUtilConfig.getBUFFER_SIZE();
        CRALog.commonLog.info("maximumBufferSize: " + maximumBufferSize);
        CRALog.commonLog.info("file.length(): " + this.file.length());
        long BufferSize = this.file.length() > maximumBufferSize ? maximumBufferSize : this.file.length();
        CRALog.commonLog.info("BufferSize: " + BufferSize);
        StringBuilder fileContent = new StringBuilder();
        BufferedInputStream buffStream = new BufferedInputStream(new FileInputStream(this.file), (int)BufferSize);
        byte[] temp = new byte[(int)BufferSize];
        int numLinesRead = -1;
        while ((numLinesRead = buffStream.read(temp)) != -1) {
            fileContent.append(new String(temp, 0, numLinesRead));
        }
        try {
            buffStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        CRALog.commonLog.info("End of getFileContent()");
        return fileContent.toString();
    }

    public byte[] getFileContentInBytes() throws IOException {
        long BufferSize = this.file.length();
        BufferedInputStream buffStream = new BufferedInputStream(new FileInputStream(this.file), (int)BufferSize);
        byte[] temp = new byte[(int)BufferSize];
        buffStream.read(temp);
        buffStream.close();
        return temp;
    }

    public static void main(String[] a) {
        try {
            CRAFileReader r = new CRAFileReader("C:/test.txt");
            String[] content = null;
            int line = 0;
            while ((content = r.getLineAsArray("\\^")) != null) {
                System.out.println("*************************************" + ++line + "**************************");
                int i = 0;
                while (i < content.length) {
                    System.out.println(content[i]);
                    ++i;
                }
                System.out.println("*************************************" + line + "**************************");
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

