/*
 * Decompiled with CFR 0.152.
 */
package com.cra.common.util.file;

import com.cra.common.util.file.CRAFileOperations;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;

public class CRABasicFileWriter
extends CRAFileOperations {
    public CRABasicFileWriter(String absoluteFileName) {
        super(absoluteFileName);
    }

    public static void writeFileLocal(String absoluteFileNameLocal, StringBuffer fileContent) throws IOException {
        File destFile = new File(absoluteFileNameLocal);
        if (!destFile.getParentFile().exists()) {
            destFile.getParentFile().mkdirs();
        }
        BufferedWriter buffWriter = null;
        try {
            if (!destFile.exists()) {
                destFile.createNewFile();
            }
            buffWriter = new BufferedWriter(new FileWriter(destFile));
            buffWriter.write(fileContent.toString());
        }
        finally {
            if (buffWriter != null) {
                buffWriter.flush();
                buffWriter.close();
            }
        }
    }

    public static void writeFileLocal(String absoluteFileNameLocal, byte[] fileContent) throws IOException {
        File destFile = new File(absoluteFileNameLocal);
        if (!destFile.getParentFile().exists()) {
            destFile.getParentFile().mkdirs();
        }
        BufferedWriter buffWriter = null;
        try {
            if (!destFile.exists()) {
                destFile.createNewFile();
            }
            buffWriter = new BufferedWriter(new FileWriter(destFile));
            buffWriter.write(fileContent.toString());
        }
        finally {
            if (buffWriter != null) {
                buffWriter.flush();
                buffWriter.close();
            }
        }
    }

    public static void writeFileLocal_OutputStream(String absoluteFileNameLocal, byte[] fileContent) throws IOException {
        File destFile = new File(absoluteFileNameLocal);
        if (!destFile.getParentFile().exists()) {
            destFile.getParentFile().mkdirs();
        }
        BufferedOutputStream buffOpStream = null;
        try {
            if (!destFile.exists()) {
                destFile.createNewFile();
            }
            buffOpStream = new BufferedOutputStream(new FileOutputStream(destFile));
            buffOpStream.write(fileContent);
        }
        finally {
            if (buffOpStream != null) {
                buffOpStream.flush();
                buffOpStream.close();
            }
        }
    }

    public static void writeFileLocal_append(String absoluteFileNameLocal, String fileContent) throws IOException {
        File destFile = new File(absoluteFileNameLocal);
        if (!destFile.getParentFile().exists()) {
            destFile.getParentFile().mkdirs();
        }
        boolean append = true;
        BufferedWriter buffWriter = null;
        try {
            if (!destFile.exists()) {
                destFile.createNewFile();
            }
            buffWriter = new BufferedWriter(new FileWriter(destFile, append));
            buffWriter.write(fileContent.toString());
            buffWriter.newLine();
        }
        finally {
            if (buffWriter != null) {
                buffWriter.flush();
                buffWriter.close();
            }
        }
    }
}

