/*
 * Decompiled with CFR 0.152.
 */
package com.cra.common.util.encrypt;

public class LuhnsAlgorithm {
    public static boolean isValidNumber(String number) {
        int sum = LuhnsAlgorithm.calculateSum(number, false);
        return sum % 10 == 0;
    }

    public static String getNumberAppendedWithCheckDigit(String number) {
        int sum = LuhnsAlgorithm.calculateSum(number, true);
        int sumMod10 = sum % 10;
        if (sumMod10 != 0) {
            sumMod10 = 10 - sum % 10;
        }
        String checkDigit = String.valueOf(number) + sumMod10;
        return checkDigit;
    }

    private static int calculateSum(String numStr, boolean generate) {
        int sum = 0;
        boolean alternate = generate;
        int i = numStr.length() - 1;
        while (i >= 0) {
            int n = Integer.parseInt(numStr.substring(i, i + 1));
            if (alternate && (n *= 2) > 9) {
                n = n % 10 + 1;
            }
            sum += n;
            alternate = !alternate;
            --i;
        }
        return sum;
    }

    public static void main(String[] d) {
        int inputNumber1 = 44666765;
        int outputNumber1 = Integer.parseInt(LuhnsAlgorithm.getNumberAppendedWithCheckDigit("" + inputNumber1));
        System.out.println("inputNumber1:" + inputNumber1 + ":result:" + LuhnsAlgorithm.isValidNumber("" + outputNumber1));
        System.out.println("outputNumber1:" + outputNumber1);
        long inputNumber2 = 4477470310678009567L;
        long outputNumber2 = Long.parseLong(LuhnsAlgorithm.getNumberAppendedWithCheckDigit("" + inputNumber2));
        System.out.println("inputNumber2:" + inputNumber2 + ":result:" + LuhnsAlgorithm.isValidNumber("" + outputNumber2));
        System.out.println("outputNumber2:" + outputNumber2);
    }
}

