/*
 * Decompiled with CFR 0.152.
 */
package com.cra.common.util;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;

public class CRAConfigReader {
    private static Logger log = Logger.getLogger("CommonLogging");
    private static final String PROPERTIES_SWITCH = "/resources/cra-switch.properties";
    private static final String PROPERTIES_GENERAL = "/resources/general-config.properties";
    private static final String PROPERTIES_ERRORCODES = "/resources/ApplicationResources.properties";
    private static final String CRA_CONFIG_COMMON = "/resources/cra-config.properties";
    private static final String NPSCAN_CONFIG_COMMON = "/resources/npscan-config.properties";
    private static final String CRALITE_CONFIG_COMMON = "/resources/cralite-config.properties";
    private static final String CRA_CONFIG = "/resources/cra-config-";
    private static final String NPSCAN_CONFIG = "/resources/npscan-config-";
    private static final String CRALITE_CONFIG = "/resources/cralite-config-";
    private static final String CRA_CLIENT = "/resources/cra-client-";
    private static final String NPSCAN_CLIENT = "/resources/npscan-client-";
    private static final String CRALITE_CLIENT = "/resources/cralite-client-";
    public static HashMap<String, String> configPropMap = new HashMap();
    public static HashMap<String, String> errorCodePropMap = new HashMap();
    private static String currentDeployment = "dev";

    static {
        log.info("starting to Load CRAConfig PROPERTIES..");
        Properties prop = new Properties();
        try {
            try {
                String key;
                prop.load(CRAConfigReader.class.getResourceAsStream(PROPERTIES_SWITCH));
                log.info("loaded SWITCH properties ../resources/cra-switch.properties");
                Enumeration<Object> enumSwtich = prop.keys();
                while (enumSwtich.hasMoreElements()) {
                    String key2 = (String)enumSwtich.nextElement();
                    if (key2.equals("cra.current.deployment")) {
                        currentDeployment = (String)prop.get(key2);
                    }
                    configPropMap.put(key2, (String)prop.get(key2));
                }
                log.info("cra.current.deployment=" + currentDeployment);
                Enumeration<Object> ee = null;
                try {
                    prop.load(CRAConfigReader.class.getResourceAsStream(PROPERTIES_GENERAL));
                    ee = prop.keys();
                    while (ee.hasMoreElements()) {
                        String key3 = (String)ee.nextElement();
                        configPropMap.put(key3, (String)prop.get(key3));
                    }
                }
                catch (Exception e) {
                    log.error("Exception occured while trying to load GENERAL PROPERTIES. Continuing with loading further properties", e);
                }
                String systemName = configPropMap.get("SYNC.SYSTEM_NAME");
                log.info("in CRAConfigReader.. systemName=" + systemName);
                try {
                    if (systemName != null && systemName.equals("NPSCAN")) {
                        prop.load(CRAConfigReader.class.getResourceAsStream(NPSCAN_CONFIG_COMMON));
                    } else if (systemName != null && systemName.equals("CRALITE")) {
                        prop.load(CRAConfigReader.class.getResourceAsStream(CRALITE_CONFIG_COMMON));
                    } else {
                        prop.load(CRAConfigReader.class.getResourceAsStream(CRA_CONFIG_COMMON));
                    }
                    log.info("loaded the SYSTEM specific properties..");
                    ee = prop.keys();
                    while (ee.hasMoreElements()) {
                        key = (String)ee.nextElement();
                        configPropMap.put(key, (String)prop.get(key));
                    }
                }
                catch (Exception e) {
                    log.error("Exception occured while trying to load CONFIG PROPERTIES. Continuing with loading further properties", e);
                }
                try {
                    if (systemName != null && systemName.equals("NPSCAN")) {
                        prop.load(CRAConfigReader.class.getResourceAsStream(NPSCAN_CONFIG + currentDeployment + ".properties"));
                    } else if (systemName != null && systemName.equals("CRALITE")) {
                        prop.load(CRAConfigReader.class.getResourceAsStream(CRALITE_CONFIG + currentDeployment + ".properties"));
                    } else {
                        prop.load(CRAConfigReader.class.getResourceAsStream(CRA_CONFIG + currentDeployment + ".properties"));
                    }
                    log.info("loaded the environment specific properties..");
                    ee = prop.keys();
                    while (ee.hasMoreElements()) {
                        key = (String)ee.nextElement();
                        configPropMap.put(key, (String)prop.get(key));
                    }
                }
                catch (Exception e) {
                    log.error("Exception occured while trying to load EVIRONMENT SPECIFIC CONFIG PROPERTIES. Continuing with loading further properties", e);
                }
                try {
                    if (systemName != null && systemName.equals("NPSCAN")) {
                        prop.load(CRAConfigReader.class.getResourceAsStream(NPSCAN_CLIENT + currentDeployment + ".properties"));
                    } else if (systemName != null && systemName.equals("CRALITE")) {
                        prop.load(CRAConfigReader.class.getResourceAsStream(CRALITE_CLIENT + currentDeployment + ".properties"));
                    } else {
                        prop.load(CRAConfigReader.class.getResourceAsStream(CRA_CLIENT + currentDeployment + ".properties"));
                    }
                    log.info("loaded the environment specific CLIENT properties..");
                    ee = prop.keys();
                    while (ee.hasMoreElements()) {
                        key = (String)ee.nextElement();
                        configPropMap.put(key, (String)prop.get(key));
                    }
                }
                catch (Exception e) {
                    log.error("Exception occured while trying to load ENV-SPECIFIC CLIENT PROPERTIES. Continuing with loading further properties", e);
                }
                try {
                    log.info("loading General ErrorCodes properties ..");
                    prop.load(CRAConfigReader.class.getResourceAsStream(PROPERTIES_ERRORCODES));
                    ee = prop.keys();
                    while (ee.hasMoreElements()) {
                        key = (String)ee.nextElement();
                        errorCodePropMap.put(key, (String)prop.get(key));
                    }
                }
                catch (Exception e) {
                    log.error("Exception occured while trying to load ERROR PROPERTIES.", e);
                }
                log.info("Completed loading CRA configuration properties..");
            }
            catch (IOException e) {
                log.error("IOException: Failure in loading CRA configuration properties: ", e);
                prop.clear();
            }
        }
        finally {
            prop.clear();
        }
    }

    public static HashMap getFTMConfigMap(String fileType) {
        HashMap<String, String> fHM = new HashMap<String, String>();
        Set<String> set = configPropMap.keySet();
        Iterator<String> iter = set.iterator();
        String moduleKey = "FTM." + fileType;
        while (iter.hasNext()) {
            String key = iter.next();
            if (!key.startsWith(moduleKey)) continue;
            String val = configPropMap.get(key);
            try {
                if (val == null) continue;
                fHM.put(key.substring(moduleKey.length() + 1), val);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return fHM;
    }

    public static String getConfigVal(String key) {
        return configPropMap.get(key);
    }

    public static String getErrorDescription(String errorCode) {
        return errorCodePropMap.get(errorCode);
    }
}

