/*
 * Decompiled with CFR 0.152.
 */
package com.cra.sim.validator;

import com.cra.common.reg.util.CRAConfigReader;
import com.cra.framework.reg.exception.SystemException;
import com.cra.framework.reg.vo.SessionVO;
import com.cra.sim.util.SubsRegConst;
import com.cra.sim.util.SubsRegRespGenerator;
import com.cra.sim.vo.MsfSchVO;
import com.cra.sim.vo.NomVO;
import com.cra.sim.vo.SchVO;
import com.cra.sim.vo.SubsDtlsVO;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;

public abstract class BaseValidator {
    protected SessionVO sessVO = null;
    public SubsRegConst pcon = new SubsRegConst();
    public SubsRegRespGenerator respgen = new SubsRegRespGenerator(this.sessVO);
    public static SubsDtlsVO objSubsDtls = new SubsDtlsVO();
    public String strColumnName = "";
    public String strStateCode = "";
    public String strCountCode = "";
    int i;
    int c;
    public String strAck = "";
    public String strPhoto = "";
    public String strSig = "";
    public String hexVal = "";
    public boolean isUnorganizedSector = false;
    final String[] strArrCountCodes = new String[]{"AF", "AR", "AU", "AT", "BH", "BD", "BB", "BY", "BE", "BM", "BT", "BW", "BR", "BN", "BG", "KH", "CA", "CV", "KY", "CN", "CU", "CY", "DK", "EG", "SV", "ER", "EE", "ET", "FJ", "FI", "FR", "GE", "DE", "GH", "GR", "GY", "HK", "HU", "IS", "IN", "ID", "IR", "IQ", "IE", "IL", "IT", "JP", "JO", "KE", "KP", "KW", "LV", "LU", "MO", "MW", "MY", "MV", "MU", "MX", "MN", "MA", "NA", "NR", "NP", "NL", "NZ", "NE", "NG", "NO", "OM", "PK", "PA", "PG", "PH", "PL", "PT", "QA", "RO", "RU", "RW", "SA", "SN", "SG", "ZA", "ES", "LK", "SD", "SE", "CH", "TW", "TZ", "TH", "TN", "TR", "UG", "UA", "AE", "GB", "US", "UY", "VN", "YE", "ZR", "ZW", "ZM", "MZ", "AO", "LY", "KR", "TL", "AX", "AL", "DZ", "AS", "AD", "AI", "AQ", "AG", "AM", "AW", "AZ", "BS", "BZ", "BJ", "BO", "BQ", "BA", "BV", "IO", "BF", "BI", "CM", "CF", "TD", "CL", "CX", "CC", "CO", "KM", "CG", "CD", "CK", "CR", "HR", "CW", "CZ", "DJ", "DM", "DO", "EC", "GQ", "FK", "FO", "GF", "PF", "TF", "GA", "GM", "GI", "GL", "GD", "GP", "GU", "GT", "GG", "GN", "GW", "HT", "HM", "VA", "HN", "IM", "JM", "JE", "KZ", "KI", "KG", "LB", "LS", "LR", "LI", "LT", "MK", "MG", "ML", "MT", "MH", "MQ", "MR", "YT", "FM", "MD", "MC", "ME", "MS", "MM", "NC", "NI", "NU", "NF", "MP", "PW", "PS", "PY", "PE", "PN", "PR", "RE", "BL", "SH", "KN", "LC", "MF", "PM", "VC", "WS", "SM", "ST", "RS", "SC", "SL", "SX", "SK", "SI", "SB", "SO", "GS", "SS", "SR", "SJ", "SZ", "SY", "TJ", "TG", "TK", "TO", "TT", "TM", "TC", "TV", "UM", "UZ", "VU", "VE", "VG", "VI", "WF", "EH", "LA", "CI"};
    protected final String[] strArrCountCodesISO = new String[]{"AF", "AX", "AL", "DZ", "AS", "AD", "AO", "AI", "AQ", "AG", "AR", "AM", "AW", "AU", "AT", "AZ", "BS", "BH", "BD", "BB", "BY", "BE", "BZ", "BJ", "BM", "BT", "BO", "BQ", "BA", "BW", "BV", "BR", "IO", "BN", "BG", "BF", "BI", "CV", "KH", "CM", "CA", "KY", "CF", "TD", "CL", "CN", "CX", "CC", "CO", "KM", "CG", "CD", "CK", "CR", "CI", "HR", "CU", "CW", "CY", "CZ", "DK", "DJ", "DM", "DO", "EC", "EG", "SV", "GQ", "ER", "EE", "ET", "FK", "FO", "FJ", "FI", "FR", "GF", "PF", "TF", "GA", "GM", "GE", "DE", "GH", "GI", "GR", "GL", "GD", "GP", "GU", "GT", "GG", "GN", "GW", "GY", "HT", "HM", "VA", "HN", "HK", "HU", "IS", "IN", "ID", "IR", "IQ", "IE", "IM", "IL", "IT", "JM", "JP", "JE", "JO", "KZ", "KE", "KI", "KP", "KR", "KW", "KG", "LA", "LV", "LB", "LS", "LR", "LY", "LI", "LT", "LU", "MO", "MK", "MG", "MW", "MY", "MV", "ML", "MT", "MH", "MQ", "MR", "MU", "YT", "MX", "FM", "MD", "MC", "MN", "ME", "MS", "MA", "MZ", "MM", "NA", "NR", "NP", "NL", "NC", "NZ", "NI", "NE", "NG", "NU", "NF", "MP", "NO", "OM", "PK", "PW", "PS", "PA", "PG", "PY", "PE", "PH", "PN", "PL", "PT", "PR", "QA", "RE", "RO", "RU", "RW", "BL", "SH", "KN", "LC", "MF", "PM", "VC", "WS", "SM", "ST", "SA", "SN", "RS", "SC", "SL", "SG", "SX", "SK", "SI", "SB", "SO", "ZA", "GS", "SS", "ES", "LK", "SD", "SR", "SJ", "SZ", "SE", "CH", "SY", "TW", "TJ", "TZ", "TH", "TL", "TG", "TK", "TO", "TT", "TN", "TR", "TM", "TC", "TV", "UG", "UA", "AE", "GB", "US", "UM", "UY", "UZ", "VU", "VE", "VN", "VG", "VI", "WF", "EH", "YE", "ZM", "ZW", "XX"};
    final String EMPTY_STRING = "";
    public final String[] ERROR_LIST = new String[]{"SUB_REG_UPLD_NNNNY", "SUB_REG_UPLD_NNNYN", "SUB_REG_UPLD_NNNYY", "SUB_REG_UPLD_ONNXN", "SUB_REG_UPLD_ONYXN", "SUB_REG_UPLD_OYYXN", "SUB_OL_REG_NNNNY", "SUB_OL_REG_NNNYN", "SUB_OL_REG_NNNYY", "SUB_OL_REG_ONNXN", "SUB_OL_REG_ONYXN", "SUB_OL_REG_OYYXN", "SUB_MOD_NNNN", "SUB_MOD_NNNY", "SUB_MOD_NNYN", "SUB_MOD_NNYY", "SUB_MOD_YNNN", "SUB_MOD_YNNN"};
    public final int[] ERROR_CODE_LIST = new int[]{109245, 109245, 109245, 109247, 109247, 109247, 109245, 109245, 109245, 109247, 109247, 109247, 109245, 109245, 109245, 109245, 109245, 109245};
    boolean isNRI = false;
    boolean isOCI = false;
    boolean isRI = false;

    public BaseValidator(SessionVO sessVO) {
        this.sessVO = sessVO;
    }

    public boolean valFieldBasics(String fieldStr, int intLen, int intOptFlag, String strfieldName, int intColumnNum) {
        String strErrCode;
        block4: {
            try {
                strErrCode = this.getErrorCode(intColumnNum);
                this.pcon.setOptManFlag(intOptFlag);
                if (intOptFlag != 1 || !fieldStr.equals("")) break block4;
                System.out.println("intOptFlag::" + intOptFlag);
                this.respgen.genHTML(this.pcon, strfieldName, fieldStr, String.valueOf(strErrCode) + "1");
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        if (fieldStr.length() > intLen) {
            this.respgen.genHTML(this.pcon, strfieldName, fieldStr, String.valueOf(strErrCode) + "2");
            return false;
        }
        return true;
    }

    public int compDate(String d1, String d2) {
        int flag = 0;
        try {
            String year = d1.substring(4, 8);
            String mon = d1.substring(0, 2);
            String day = d1.substring(2, 4);
            Date date1 = Date.valueOf(String.valueOf(year) + "-" + mon + "-" + day);
            year = d2.substring(4, 8);
            mon = d2.substring(2, 4);
            day = d2.substring(0, 2);
            Date date2 = Date.valueOf(String.valueOf(year) + "-" + mon + "-" + day);
            flag = date1.compareTo(date2);
            return flag;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public boolean valLineNumber(String fieldStr, String strColumnName, int intColumnNum) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnNum);
        try {
            boolTemp = this.valFieldBasics(fieldStr.trim(), 6, SubsRegConst.getMandatoryValue(), strColumnName, intColumnNum);
            if (!this.isNumber(fieldStr)) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "3");
                return boolTemp;
            }
            if (Integer.parseInt(fieldStr) != this.pcon.getLineCntr()) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "4");
                return boolTemp;
            }
            if (Integer.parseInt(fieldStr) == 0) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "5");
                return boolTemp;
            }
            if (fieldStr.length() < 6) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "6");
                return boolTemp;
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public void setNRIFlagForVal(String NRIFlg) {
        if ("Y".equalsIgnoreCase(NRIFlg)) {
            this.isNRI = true;
        } else if ("O".equalsIgnoreCase(NRIFlg)) {
            this.isOCI = true;
        } else if ("N".equalsIgnoreCase(NRIFlg)) {
            this.isRI = true;
        }
    }

    public boolean valAddress1(String fieldStr, String strColumnName, int intColumnNum) {
        boolean boolTemp = true;
        try {
            boolTemp = intColumnNum == 19 ? (this.isOCI || this.isNRI ? this.valFieldBasics(fieldStr, 60, SubsRegConst.getMandatoryValue(), strColumnName, intColumnNum) : this.valFieldBasics(fieldStr, 60, SubsRegConst.getOptionalValue(), strColumnName, intColumnNum)) : this.valFieldBasics(fieldStr, 60, SubsRegConst.getMandatoryValue(), strColumnName, intColumnNum);
            System.out.println("objSubsDtlsgetCurAddressCountry::" + objSubsDtls.getCurAddressCountry());
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valAddress2(String fieldStr, String strColumnName, int intColumnNum) {
        boolean boolTemp = true;
        try {
            boolTemp = this.valFieldBasics(fieldStr, 60, SubsRegConst.getOptionalValue(), strColumnName, intColumnNum);
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valAddress3(String fieldStr, String strColumnName, int intColumnNum) {
        boolean boolTemp = true;
        try {
            boolTemp = intColumnNum == 23 || intColumnNum == 24 || intColumnNum == 32 || intColumnNum == 33 ? this.valFieldBasics(fieldStr, 60, SubsRegConst.getOptionalValue(), strColumnName, intColumnNum) : this.valFieldBasics(fieldStr, 60, SubsRegConst.getOptionalValue(), strColumnName, intColumnNum);
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valAddress4(String fieldStr, String strColumnName, int intColumnNum, String permadd1) {
        boolean boolTemp = true;
        try {
            if (intColumnNum == 31) {
                boolTemp = this.valFieldBasics(fieldStr, 60, SubsRegConst.getMandatoryValue(), strColumnName, intColumnNum);
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valPin(String strState, String fieldStr, String strColumnName, int intColumnNum, String permadd1) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnNum);
        try {
            boolTemp = intColumnNum == 27 ? (this.isOCI || this.isNRI ? this.valFieldBasics(fieldStr, 10, SubsRegConst.getMandatoryValue(), strColumnName, intColumnNum) : this.valFieldBasics(fieldStr, 10, SubsRegConst.getOptionalValue(), strColumnName, intColumnNum)) : this.valFieldBasics(fieldStr, 10, SubsRegConst.getMandatoryValue(), strColumnName, intColumnNum);
            if (this.isNRI && intColumnNum == 27 && fieldStr != null && !"".equalsIgnoreCase(fieldStr) && fieldStr.length() > 10) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "9");
                return boolTemp;
            }
            if (fieldStr != null && !"".equalsIgnoreCase(fieldStr) && intColumnNum == 36 && this.isOCI && fieldStr.length() > 10) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "9");
                return boolTemp;
            }
            if (!(fieldStr == null || "".equalsIgnoreCase(fieldStr) || this.isNRI || this.isOCI || intColumnNum != 27)) {
                if (fieldStr.length() != 6) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "3");
                    return boolTemp;
                }
                if (!this.isNumber(fieldStr)) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "6");
                    return boolTemp;
                }
            }
            if (boolTemp && fieldStr != null && !"".equalsIgnoreCase(fieldStr)) {
                if (!this.isNRI && !this.isOCI) {
                    if (fieldStr.startsWith("0")) {
                        boolTemp = false;
                        this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "8");
                        return boolTemp;
                    }
                    if (Integer.parseInt("0" + strState) != 99 && fieldStr.equals("999999")) {
                        boolTemp = false;
                        this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "4");
                        return boolTemp;
                    }
                    if (Integer.parseInt("0" + strState) == 99 && !fieldStr.equals("999999")) {
                        boolTemp = false;
                        this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "5");
                        return boolTemp;
                    }
                    if (Integer.parseInt("0" + strState) != 88 && fieldStr.equals("888888")) {
                        boolTemp = false;
                        this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "7");
                        return boolTemp;
                    }
                    if (Integer.parseInt("0" + strState) == 88 && !fieldStr.equals("888888")) {
                        boolTemp = false;
                        this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "7");
                        return boolTemp;
                    }
                }
                if (fieldStr != null && !"".equalsIgnoreCase(fieldStr)) {
                    if (intColumnNum == 36 && !this.isNRI && !this.isOCI) {
                        if (!this.isNumber(fieldStr)) {
                            boolTemp = false;
                            this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "6");
                            return boolTemp;
                        }
                        if (fieldStr.length() != 6) {
                            boolTemp = false;
                            this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "3");
                            return boolTemp;
                        }
                    }
                    if ((this.isNRI || this.isOCI) && (fieldStr.equals("888888") || fieldStr.equals("999999")) && intColumnNum == 36) {
                        boolTemp = false;
                        this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "11");
                        return boolTemp;
                    }
                    if (this.isOCI && fieldStr.equals("999999") && intColumnNum == 27) {
                        boolTemp = false;
                        this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "12");
                        return boolTemp;
                    }
                }
            }
            if (fieldStr != null && !"".equalsIgnoreCase(fieldStr) && this.isNumber(fieldStr) && Long.parseLong(fieldStr) == 0L) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "10");
                return boolTemp;
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public String getErrorCode(int intColumnNum) {
        String strErrCode = "";
        strErrCode = Integer.toString(intColumnNum).length() == 1 ? String.valueOf(this.getErrorForm()) + "0" + Integer.toString(intColumnNum) : String.valueOf(this.getErrorForm()) + Integer.toString(intColumnNum);
        return strErrCode;
    }

    public boolean valFirstName(String strFirstName, String strColumnName, int intColumnNum) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnNum);
        int cnt = 0;
        try {
            boolTemp = intColumnNum == 8 ? this.valFieldBasics(strFirstName.trim(), 90, SubsRegConst.getMandatoryValue(), strColumnName, intColumnNum) : this.valFieldBasics(strFirstName.trim(), 30, SubsRegConst.getMandatoryValue(), strColumnName, intColumnNum);
            if (strFirstName.toUpperCase().charAt(0) != '\'' && (strFirstName.toUpperCase().charAt(0) < 'A' || strFirstName.toUpperCase().charAt(0) > 'Z')) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strFirstName, String.valueOf(strErrCode) + "3");
                return boolTemp;
            }
            cnt = 1;
            while (cnt < strFirstName.length()) {
                if (strFirstName.charAt(cnt) != ' ' && strFirstName.charAt(cnt) != '&' && strFirstName.charAt(cnt) != '\'' && strFirstName.charAt(cnt) != '.' && strFirstName.charAt(cnt) != '(' && strFirstName.charAt(cnt) != ')' && strFirstName.charAt(cnt) != ',' && strFirstName.charAt(cnt) != '-' && strFirstName.charAt(cnt) != '.' && strFirstName.charAt(cnt) != '/' && strFirstName.charAt(cnt) != '\\' && strFirstName.charAt(cnt) != '~' && strFirstName.charAt(cnt) != '!' && strFirstName.charAt(cnt) != '@' && strFirstName.charAt(cnt) != '#' && strFirstName.charAt(cnt) != '$' && strFirstName.charAt(cnt) != '%' && strFirstName.charAt(cnt) != '-' && strFirstName.charAt(cnt) != ';' && strFirstName.charAt(cnt) != '*' && strFirstName.charAt(cnt) != '_' && strFirstName.charAt(cnt) != '+' && strFirstName.charAt(cnt) != '=' && strFirstName.charAt(cnt) != '{' && strFirstName.charAt(cnt) != '}' && strFirstName.charAt(cnt) != '[' && strFirstName.charAt(cnt) != ']' && strFirstName.charAt(cnt) != '|' && strFirstName.charAt(cnt) != '?' && strFirstName.charAt(cnt) != ':' && strFirstName.charAt(cnt) != 'Y' && (strFirstName.toUpperCase().charAt(cnt) < 'A' || strFirstName.toUpperCase().charAt(cnt) > 'Z')) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, strFirstName, String.valueOf(strErrCode) + "4");
                    return boolTemp;
                }
                ++cnt;
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valLastName(String strLastName, String strColumnName, int intColumnNum) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnNum);
        int cnt = 0;
        try {
            boolTemp = this.valFieldBasics(strLastName.trim(), 30, SubsRegConst.getOptionalValue(), strColumnName, intColumnNum);
            if (strLastName != null && !"".equalsIgnoreCase(strLastName)) {
                if (strLastName.toUpperCase().charAt(0) != '\'' && (strLastName.toUpperCase().charAt(0) < 'A' || strLastName.toUpperCase().charAt(0) > 'Z')) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, strLastName, String.valueOf(strErrCode) + "3");
                    return boolTemp;
                }
                cnt = 1;
                while (cnt < strLastName.length()) {
                    if (strLastName.charAt(cnt) != ' ' && strLastName.charAt(cnt) != '&' && strLastName.charAt(cnt) != '\'' && strLastName.charAt(cnt) != '.' && strLastName.charAt(cnt) != '(' && strLastName.charAt(cnt) != ')' && strLastName.charAt(cnt) != ',' && strLastName.charAt(cnt) != '-' && strLastName.charAt(cnt) != '.' && strLastName.charAt(cnt) != '/' && strLastName.charAt(cnt) != '\\' && strLastName.charAt(cnt) != '~' && strLastName.charAt(cnt) != '!' && strLastName.charAt(cnt) != '@' && strLastName.charAt(cnt) != '#' && strLastName.charAt(cnt) != '$' && strLastName.charAt(cnt) != '%' && strLastName.charAt(cnt) != '-' && strLastName.charAt(cnt) != ';' && strLastName.charAt(cnt) != '*' && strLastName.charAt(cnt) != '_' && strLastName.charAt(cnt) != '+' && strLastName.charAt(cnt) != '=' && strLastName.charAt(cnt) != '{' && strLastName.charAt(cnt) != '}' && strLastName.charAt(cnt) != '[' && strLastName.charAt(cnt) != ']' && strLastName.charAt(cnt) != '|' && strLastName.charAt(cnt) != '?' && strLastName.charAt(cnt) != ':' && strLastName.charAt(cnt) != 'Y' && (strLastName.toUpperCase().charAt(cnt) < 'A' || strLastName.toUpperCase().charAt(cnt) > 'Z')) {
                        boolTemp = false;
                        this.respgen.genHTML(this.pcon, strColumnName, strLastName, String.valueOf(strErrCode) + "4");
                        return boolTemp;
                    }
                    ++cnt;
                }
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valMiddleName(String strMiddleName, String strColumnName, int intColumnNum) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnNum);
        int cnt = 0;
        try {
            boolTemp = this.valFieldBasics(strMiddleName.trim(), 30, SubsRegConst.getOptionalValue(), strColumnName, intColumnNum);
            if (!strMiddleName.trim().trim().equals("")) {
                if (strMiddleName.toUpperCase().charAt(0) != '\'' && (strMiddleName.toUpperCase().charAt(0) < 'A' || strMiddleName.toUpperCase().charAt(0) > 'Z')) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, strMiddleName, String.valueOf(strErrCode) + "3");
                    return boolTemp;
                }
                cnt = 1;
                while (cnt < strMiddleName.length()) {
                    if (strMiddleName.charAt(cnt) != ' ' && strMiddleName.charAt(cnt) != '&' && strMiddleName.charAt(cnt) != '\'' && strMiddleName.charAt(cnt) != '.' && strMiddleName.charAt(cnt) != '(' && strMiddleName.charAt(cnt) != ')' && strMiddleName.charAt(cnt) != ',' && strMiddleName.charAt(cnt) != '-' && strMiddleName.charAt(cnt) != '.' && strMiddleName.charAt(cnt) != '/' && strMiddleName.charAt(cnt) != '\\' && strMiddleName.charAt(cnt) != '~' && strMiddleName.charAt(cnt) != '!' && strMiddleName.charAt(cnt) != '@' && strMiddleName.charAt(cnt) != '#' && strMiddleName.charAt(cnt) != '$' && strMiddleName.charAt(cnt) != '%' && strMiddleName.charAt(cnt) != '-' && strMiddleName.charAt(cnt) != ';' && strMiddleName.charAt(cnt) != '*' && strMiddleName.charAt(cnt) != '_' && strMiddleName.charAt(cnt) != '+' && strMiddleName.charAt(cnt) != '=' && strMiddleName.charAt(cnt) != '{' && strMiddleName.charAt(cnt) != '}' && strMiddleName.charAt(cnt) != '[' && strMiddleName.charAt(cnt) != ']' && strMiddleName.charAt(cnt) != '|' && strMiddleName.charAt(cnt) != '?' && strMiddleName.charAt(cnt) != ':' && strMiddleName.charAt(cnt) != 'Y' && (strMiddleName.toUpperCase().charAt(cnt) < 'A' || strMiddleName.toUpperCase().charAt(cnt) > 'Z')) {
                        boolTemp = false;
                        this.respgen.genHTML(this.pcon, strColumnName, strMiddleName, String.valueOf(strErrCode) + "4");
                        return boolTemp;
                    }
                    ++cnt;
                }
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    protected boolean addPhotoSig() {
        boolean boolTemp = true;
        boolean boolPhoto = true;
        boolean boolSig = true;
        try {
            String strRec = this.pcon.getFileLine();
            if (CRAConfigReader.getConfigVal("CRACENTRAL.FVU.SubsReg.PhotoSigMandatory").equalsIgnoreCase("Y")) {
                File filePhoto = new File(this.getPhotoFileName());
                File fileSig = new File(this.getSigFileName());
                boolPhoto = this.getPhotoHex(filePhoto);
                strRec = String.valueOf(strRec) + "^" + this.strPhoto.toUpperCase();
                boolSig = this.getSigHex(fileSig);
                fileSig = new File(this.getSigFileName());
                strRec = String.valueOf(strRec) + "^" + this.strSig.toUpperCase();
            } else {
                strRec = String.valueOf(strRec) + "^" + "FECDBA987654321";
                strRec = String.valueOf(strRec) + "^" + "123456789ABDCEF";
            }
            this.pcon.setFileLine(strRec);
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolPhoto && boolSig;
    }

    protected boolean addPhotoSigUOS() {
        boolean boolTemp = true;
        boolean boolPhoto = true;
        boolean boolSig = true;
        try {
            String strRec = this.pcon.getFileLine();
            File filePhoto = new File(this.getPhotoFileName());
            boolPhoto = this.getPhotoHex(filePhoto);
            strRec = String.valueOf(strRec) + "^" + this.strPhoto.toUpperCase();
            strRec = String.valueOf(strRec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
            this.pcon.setFileLine(strRec);
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolPhoto && boolSig;
    }

    protected String getPhotoFileName() {
        String str = this.pcon.getFileName();
        str = str.substring(0, str.lastIndexOf("."));
        String strFileName = String.valueOf(str) + "_photo" + File.separator + this.strAck + "_photo.jpg";
        return strFileName;
    }

    protected String getSigFileName() {
        String str = this.pcon.getFileName();
        str = str.substring(0, str.lastIndexOf("."));
        String strFileName = String.valueOf(str) + "_sig" + File.separator + this.strAck + "_sig.jpg";
        return strFileName;
    }

    protected boolean getPhotoHex(File file) {
        boolean boolTemp = true;
        this.strPhoto = "";
        if (!file.exists() || file.length() == 0L) {
            boolTemp = false;
            this.respgen.genHTML(this.pcon, "Photo", "", "1021591");
        }
        if ((double)file.length() / 1024.0 > 12.0) {
            boolTemp = false;
            this.respgen.genHTML(this.pcon, "Photo", "", "1021592");
        }
        if (boolTemp) {
            try {
                FileInputStream fileIpStrm = new FileInputStream(file);
                int i = 0;
                while ((i = fileIpStrm.read()) != -1) {
                    String s = Integer.toHexString(i).trim();
                    if (s.length() == 1) {
                        s = "0" + s;
                    }
                    this.strPhoto = String.valueOf(this.strPhoto) + s;
                }
                fileIpStrm.close();
            }
            catch (IOException e) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, "Photo", "", "1021594");
                return boolTemp;
            }
            catch (Exception e) {
                boolTemp = false;
                return boolTemp;
            }
        }
        return boolTemp;
    }

    protected boolean getSigHex(File file) {
        boolean boolTemp = true;
        this.strSig = "";
        if (!file.exists() || file.length() == 0L) {
            boolTemp = false;
            this.respgen.genHTML(this.pcon, "Signature", "", "1021871");
        }
        if ((double)file.length() / 1024.0 > 12.0) {
            boolTemp = false;
            this.respgen.genHTML(this.pcon, "Signature", "", "1021872");
        }
        if (boolTemp) {
            try {
                FileInputStream fileIpStrm = new FileInputStream(file);
                int i = 0;
                while ((i = fileIpStrm.read()) != -1) {
                    String s = Integer.toHexString(i).trim();
                    if (s.length() == 1) {
                        s = "0" + s;
                    }
                    this.strSig = String.valueOf(this.strSig) + s;
                }
                fileIpStrm.close();
            }
            catch (IOException e) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, "Signature", "", "1021874");
                return boolTemp;
            }
            catch (Exception e) {
                boolTemp = false;
                return boolTemp;
            }
        }
        return boolTemp;
    }

    public boolean addHash(String strRec) {
        boolean boolTemp = true;
        try {
            long valHash = 0L;
            strRec = String.valueOf(strRec) + "^";
            int i = 1;
            while (i <= strRec.length()) {
                valHash += (long)(i * strRec.charAt(i - 1));
                ++i;
            }
            strRec = String.valueOf(strRec) + valHash;
            this.pcon.setFileLine(strRec);
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean isNumber(String str) {
        this.i = 0;
        while (this.i < str.length()) {
            this.c = str.charAt(this.i);
            if (!Character.isDigit(this.c)) {
                return false;
            }
            ++this.i;
        }
        return true;
    }

    public boolean isAlphaNumeric(String str) {
        this.i = 0;
        while (this.i < str.length()) {
            this.c = str.charAt(this.i);
            if (!Character.isLetterOrDigit(this.c)) {
                return false;
            }
            ++this.i;
        }
        return true;
    }

    public boolean isAlpha(String str) {
        this.i = 0;
        while (this.i < str.length()) {
            this.c = str.charAt(this.i);
            if (!Character.isLetter(this.c)) {
                return false;
            }
            ++this.i;
        }
        return true;
    }

    public boolean isDate(String tval) {
        String data = new String();
        String dd = new String();
        String mm = new String();
        String yyyy = new String();
        String newdata = new String();
        boolean flag = true;
        try {
            data = tval;
            if (data.length() == 8) {
                dd = data.substring(2, 4);
                mm = data.substring(0, 2);
                yyyy = data.substring(4, 8);
                newdata = String.valueOf(yyyy) + "-" + mm + "-" + dd;
                int day = Integer.parseInt(dd);
                int month = Integer.parseInt(mm);
                int year = Integer.parseInt(yyyy);
                if (month < 1 || month > 12) {
                    flag = false;
                }
                if (day < 1 || day > 31) {
                    flag = false;
                }
                if ((month == 4 || month == 6 || month == 9 || month == 11) && day == 31) {
                    flag = false;
                }
                if (month == 2) {
                    boolean leap;
                    boolean bl = leap = year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
                    if (day > 29 || day == 29 && !leap) {
                        flag = false;
                    }
                }
                if (year == 0) {
                    flag = false;
                }
            } else {
                flag = false;
            }
            return flag;
        }
        catch (NumberFormatException e) {
            flag = false;
            return flag;
        }
    }

    public int compDate(String d1) {
        int flag = 0;
        try {
            String year = d1.substring(4, 8);
            String mon = d1.substring(2, 4);
            String day = d1.substring(0, 2);
            int yyyy = Integer.parseInt(year);
            int mm = Integer.parseInt(mon);
            int dd = Integer.parseInt(day);
            Date date1 = Date.valueOf(String.valueOf(year) + "-" + mon + "-" + day);
            Calendar cal = Calendar.getInstance();
            mm = cal.get(2);
            dd = cal.get(5);
            yyyy = cal.get(1);
            Date date2 = Date.valueOf(String.valueOf(yyyy) + "-" + ++mm + "-" + dd);
            flag = date1.compareTo(date2);
            return flag;
        }
        catch (Exception e) {
            flag = -1000;
            return flag;
        }
    }

    /*
     * Exception decompiling
     */
    public boolean isEmailId(String tval) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int valFieldBasics(String fieldStr, int intLen, int intOptFlag) {
        int intErrorCode = 0;
        try {
            if (intOptFlag == 1 && fieldStr.equals("")) {
                intErrorCode = 1;
            }
            if (fieldStr.length() > intLen) {
                intErrorCode = 2;
            }
            return intErrorCode;
        }
        catch (Exception e) {
            return 3;
        }
    }

    public int ageInYear(int year, int month, int day) {
        Calendar now = Calendar.getInstance();
        Calendar dob = Calendar.getInstance();
        dob.set(year, --month, day);
        int ageYears = now.get(1) - dob.get(1);
        if (dob.get(2) == now.get(2)) {
            if (dob.get(5) > now.get(5)) {
                --ageYears;
            }
        } else if (dob.get(2) > now.get(2)) {
            --ageYears;
        }
        return ageYears;
    }

    public boolean isAlphanumeric(String dataStr) {
        boolean boolTemp = true;
        char[] characters = dataStr.toCharArray();
        int count = characters.length;
        int i = 0;
        while (i < count) {
            if (!Character.isLetterOrDigit(characters[i])) {
                boolTemp = false;
                return boolTemp;
            }
            ++i;
        }
        return boolTemp;
    }

    public boolean isSpecialCharacter(String dataStr, String strColumnName, int intColumnNum) {
        boolean boolTemp1 = true;
        String strErrCode = this.getErrorCode(intColumnNum);
        try {
            int stringLength = 0;
            if (dataStr != null) {
                stringLength = dataStr.length();
            }
            System.out.println("Name: " + dataStr);
            System.out.println("Length: " + stringLength);
            int count = 0;
            int countSpaces = 0;
            int countSpecialChar = 0;
            if (stringLength != 0) {
                int x = 0;
                while (x < stringLength) {
                    char ch = dataStr.charAt(x);
                    char ch1 = ch;
                    if (ch1 >= 'A' && ch1 <= 'Z' || ch1 >= 'a' && ch1 <= 'z' || ch1 == ' ' || ch1 > '/' && ch1 < ':') {
                        ++count;
                        if (ch1 == ' ') {
                            ++countSpaces;
                        }
                    } else {
                        ++countSpecialChar;
                    }
                    ++x;
                }
                System.out.println("count: " + count);
                System.out.println("countSpaces: " + countSpaces);
                System.out.println("countSpecialChar: " + countSpecialChar);
                if (countSpecialChar == stringLength) {
                    boolTemp1 = false;
                    this.respgen.genHTML(this.pcon, strColumnName, dataStr, String.valueOf(strErrCode) + "6");
                    return boolTemp1;
                }
            }
        }
        catch (Exception e) {
            boolTemp1 = false;
            return boolTemp1;
        }
        return boolTemp1;
    }

    public java.util.Date getYearBrithDay(java.util.Date SubDob, int Year) {
        java.util.Date currentBirthDate = null;
        GregorianCalendar calendarYear = new GregorianCalendar();
        calendarYear.setTime(SubDob);
        calendarYear.set(1, Year);
        currentBirthDate = calendarYear.getTime();
        return currentBirthDate;
    }

    public abstract String getErrorForm();

    public String getNextDOBforAgeWiseSchemeChange(String subDateofBirth) throws SystemException {
        SimpleDateFormat dateFormat1 = new SimpleDateFormat("MMddyyyy");
        java.util.Date subDob = null;
        GregorianCalendar currentDtCal = new GregorianCalendar();
        java.util.Date nextCycleDate = null;
        String nextCycleDateMMDDYYYY = null;
        try {
            subDob = dateFormat1.parse(subDateofBirth);
            java.util.Date dateNextYear = this.getYearBrithDay(subDob, currentDtCal.get(1));
            java.util.Date currentDt = currentDtCal.getTime();
            if (dateNextYear.before(currentDt) || dateNextYear.compareTo(currentDt) == 0) {
                nextCycleDate = this.getYearBrithDay(subDob, currentDtCal.get(1) + 1);
            } else if (dateNextYear.after(currentDt)) {
                nextCycleDate = this.getYearBrithDay(subDob, currentDtCal.get(1));
            }
            nextCycleDateMMDDYYYY = dateFormat1.format(nextCycleDate);
        }
        catch (ParseException e) {
            throw new SystemException("While processing next scheme change date error occur ");
        }
        return nextCycleDateMMDDYYYY;
    }

    public boolean isValidHindiName(String name, String strColumnName, int intColumnNum, String errCode1, String errCode2) {
        boolean validName = true;
        if (name != null && !name.trim().equals("")) {
            validName = this.isvalidHindiNameCharSeq(name);
            if (!validName) {
                this.respgen.genHTML(this.pcon, strColumnName, name, errCode1);
            }
            if (validName && !(validName = this.validateHindiHexaDecCode(name))) {
                this.respgen.genHTML(this.pcon, strColumnName, name, errCode2);
            }
        }
        return validName;
    }

    public boolean isvalidHindiNameCharSeq(String t) {
        boolean invalidName;
        block5: {
            invalidName = true;
            try {
                String[] a = t.split(";", 180);
                if (a != null && a.length > 0) {
                    int i = 0;
                    while (i < a.length) {
                        if (a[i].length() != 4) {
                            invalidName = false;
                            return invalidName;
                        }
                        ++i;
                    }
                    break block5;
                }
                invalidName = false;
                return invalidName;
            }
            catch (Exception e) {
                invalidName = false;
                return invalidName;
            }
        }
        return invalidName;
    }

    public boolean validateHindiHexaDecCode(String t) {
        boolean invalidName = true;
        try {
            String[] a = t.split(";");
            int i = 0;
            while (i < a.length) {
                int hexChar = Integer.parseInt(a[i], 16);
                if ((hexChar < 2304 || hexChar > 2431) && hexChar != 32 && hexChar != 44 && hexChar != 46) {
                    invalidName = false;
                    return invalidName;
                }
                ++i;
            }
        }
        catch (Exception e) {
            invalidName = false;
            return invalidName;
        }
        return invalidName;
    }

    public boolean validatePRNFromat(String strAck, boolean oldFormat) {
        long prn = 0L;
        int end_digit = 0;
        end_digit = oldFormat ? 15 : 14;
        long prnPerfix = 0L;
        boolean validPRN = true;
        try {
            prn = Long.parseLong(strAck.substring(0, end_digit));
            prnPerfix = Long.parseLong(("" + prn).substring(0, end_digit - 1));
            long prnCheckDigit = prnPerfix % 7L;
            String prnStr = "" + prnPerfix + prnCheckDigit;
            long prnDerived = Long.valueOf(prnStr);
            if (prn != prnDerived) {
                validPRN = false;
            }
        }
        catch (Exception e) {
            validPRN = false;
        }
        return validPRN;
    }

    public boolean valFieldBasicsWithErrorCode(String fieldStr, int intLen, int intOptFlag, String strfieldName, String errorCode1, String errorCode2) {
        block4: {
            try {
                this.pcon.setOptManFlag(intOptFlag);
                if (intOptFlag != 1 || !fieldStr.equals("")) break block4;
                this.respgen.genHTML(this.pcon, strfieldName, fieldStr, errorCode1);
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        if (fieldStr.length() > intLen) {
            this.respgen.genHTML(this.pcon, strfieldName, fieldStr, errorCode2);
            return false;
        }
        return true;
    }

    public String nomineeSEFCodes(ArrayList<NomVO> subNomList, SubsRegRespGenerator objRespGen) {
        int nomLen = 0;
        String nomineeSEFCodes = "";
        nomLen = subNomList.size();
        String errorcode = "";
        int i = 0;
        while (i < nomLen) {
            errorcode = subNomList.get(i).getErrorFlagCode();
            if (!errorcode.equalsIgnoreCase("N") && errorcode.startsWith("SEF")) {
                errorcode = objRespGen.mapDigError(errorcode);
                nomineeSEFCodes = String.valueOf(nomineeSEFCodes) + errorcode + "*";
            }
            ++i;
        }
        return nomineeSEFCodes;
    }

    public String schSEFCodes(ArrayList<SchVO> subSchList, SubsRegRespGenerator objRespGen) {
        int schLen = 0;
        String schSEFCodes = "";
        schLen = subSchList.size();
        String errorcode = "";
        int i = 0;
        while (i < schLen) {
            errorcode = subSchList.get(i).getErrorFlagCode();
            if (!errorcode.equalsIgnoreCase("N") && errorcode.startsWith("SEF")) {
                errorcode = objRespGen.mapDigError(errorcode);
                schSEFCodes = String.valueOf(schSEFCodes) + errorcode + "*";
            }
            ++i;
        }
        return schSEFCodes;
    }

    public String MsfschSEFCodes(ArrayList<MsfSchVO> subSchList, SubsRegRespGenerator objRespGen) {
        int schLen = 0;
        String schSEFCodes = "";
        schLen = subSchList.size();
        String errorcode = "";
        int i = 0;
        while (i < schLen) {
            errorcode = subSchList.get(i).getErrorFlagCode();
            System.out.println("Error code in Msfschbizvalidator: " + errorcode);
            if (!errorcode.equalsIgnoreCase("N") && errorcode.startsWith("SEF")) {
                errorcode = objRespGen.mapDigError(errorcode);
                schSEFCodes = String.valueOf(schSEFCodes) + errorcode + "*";
            }
            ++i;
        }
        return schSEFCodes;
    }

    public boolean fileExists(File file) {
        boolean exists = true;
        if (!file.exists() || file.length() == 0L) {
            exists = false;
        }
        return exists;
    }

    public String isValidBankDetails(String functionality, String formType, boolean isBankDtlsFilled, String incompBnkDtls, String ifscMicrFlag, boolean isIfscMicrFilled) {
        String errorCode = "";
        String value = "";
        value = value.concat(this.isNull(formType) ? "" : incompBnkDtls);
        value = value.concat(isBankDtlsFilled ? "Y" : "N");
        value = value.concat(this.isNull(incompBnkDtls) ? "" : incompBnkDtls);
        value = value.concat(this.isNull(ifscMicrFlag) ? "" : ifscMicrFlag);
        value = value.concat(isIfscMicrFilled ? "Y" : "N");
        System.out.println("Validating Bank details for value :: " + functionality + "_" + value);
        if (this.isListConstainsValue(this.ERROR_LIST, String.valueOf(functionality) + "_" + value)) {
            errorCode = String.valueOf(this.ERROR_CODE_LIST[Arrays.asList(this.ERROR_LIST).indexOf(String.valueOf(functionality) + "_" + value)]);
        }
        return errorCode;
    }

    public boolean isListConstainsValue(String[] valuesSet, String value) {
        List<String> list = Arrays.asList(valuesSet);
        return list != null && list.contains(value);
    }

    public boolean isListConstainsValue(Integer[] valuesSet, int value) {
        List<Integer> list = Arrays.asList(valuesSet);
        return list != null && list.contains(value);
    }

    public boolean isIfscMicrProvided(String bankIfscCode, String bankMicrCode) {
        return !this.isNull(bankIfscCode) || !this.isNull(bankMicrCode);
    }

    public boolean isBankDetailsProvided(String bankAccType, String bankAccNo, String bankName, String bankBranch, String bankAddress, String bankPin) {
        return !this.isNull(bankAccType) && !this.isNull(bankAccNo) && !this.isNull(bankName) && !this.isNull(bankBranch) && !this.isNull(bankAddress) && !this.isNull(bankPin);
    }

    public boolean isNull(String value) {
        return value == null || "".equalsIgnoreCase(value.trim());
    }

    public boolean isFillerField(String fieldStr, int intColumnCode) {
        boolean boolTemp = true;
        if (fieldStr != null && !fieldStr.trim().equals("")) {
            boolTemp = false;
            this.respgen.genHTML(this.pcon, intColumnCode + "_Filler Field", fieldStr, "109126");
        }
        return boolTemp;
    }

    public boolean valDateOfIssue(String fieldStr, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnCode);
        try {
            boolTemp = this.valFieldBasics(fieldStr, 8, SubsRegConst.getMandatoryValue(), strColumnName, intColumnCode);
            if (!this.isDate(fieldStr)) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "3");
                return boolTemp;
            }
            java.util.Date currentDate = new java.util.Date();
            java.util.Date dateOfIssue = new java.util.Date();
            SimpleDateFormat date_formatter = new SimpleDateFormat("MMddyyyy");
            dateOfIssue = date_formatter.parse(fieldStr);
            if (!dateOfIssue.before(currentDate)) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "4");
                return boolTemp;
            }
            if (dateOfIssue.getDate() == currentDate.getDate() && dateOfIssue.getMonth() == currentDate.getMonth() && dateOfIssue.getYear() == currentDate.getYear()) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "4");
                return boolTemp;
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valDateOfExpiry(String fieldStr, String strColumnName, int intColumnCode, String othDtlFlag, String idproof) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnCode);
        try {
            if (intColumnCode == 123 && !this.isOCI && !this.isNRI) {
                System.out.println("OCI sub" + fieldStr);
                boolTemp = this.valFieldBasics(fieldStr, 8, SubsRegConst.getOptionalValue(), strColumnName, intColumnCode);
            } else if (intColumnCode == 123 && this.isNRI) {
                System.out.println("NRI sub" + fieldStr);
                boolTemp = this.valFieldBasics(fieldStr, 8, SubsRegConst.getMandatoryValue(), strColumnName, intColumnCode);
            } else if (intColumnCode == 118 && (idproof.equalsIgnoreCase("103") || idproof.equalsIgnoreCase("104"))) {
                boolTemp = this.valFieldBasics(fieldStr, 8, SubsRegConst.getMandatoryValue(), strColumnName, intColumnCode);
            } else if (intColumnCode == 102 && (othDtlFlag.equalsIgnoreCase("103") || othDtlFlag.equalsIgnoreCase("104"))) {
                boolTemp = this.valFieldBasics(fieldStr, 8, SubsRegConst.getMandatoryValue(), strColumnName, intColumnCode);
            } else if (fieldStr != null && !"".equalsIgnoreCase(fieldStr)) {
                System.out.println("fieldStr 2" + fieldStr);
                boolTemp = this.valFieldBasics(fieldStr, 8, SubsRegConst.getOptionalValue(), strColumnName, intColumnCode);
            }
            if (!(intColumnCode != 163 && intColumnCode != 165 || othDtlFlag == null || "".equalsIgnoreCase(othDtlFlag) || fieldStr != null && !"".equalsIgnoreCase(fieldStr))) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "5");
                return boolTemp;
            }
            if (fieldStr != null && !"".equalsIgnoreCase(fieldStr)) {
                System.out.println("fieldStr 3" + fieldStr);
                if (!this.isDate(fieldStr)) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "3");
                    return boolTemp;
                }
                java.util.Date currentDate = new java.util.Date();
                java.util.Date dateOfIssue = new java.util.Date();
                SimpleDateFormat date_formatter = new SimpleDateFormat("MMddyyyy");
                dateOfIssue = date_formatter.parse(fieldStr);
                if (!dateOfIssue.after(currentDate)) {
                    System.out.println("fieldStr 4" + fieldStr);
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "4");
                    return boolTemp;
                }
                if (dateOfIssue.getDate() == currentDate.getDate() && dateOfIssue.getMonth() == currentDate.getMonth() && dateOfIssue.getYear() == currentDate.getYear()) {
                    System.out.println("fieldStr 5" + fieldStr);
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "4");
                    return boolTemp;
                }
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valPlaceOfIssue(String fieldStr, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        boolean cnt = false;
        String strErrCode = this.getErrorCode(intColumnCode);
        try {
            boolTemp = intColumnCode == 124 ? this.valFieldBasics(fieldStr, 40, SubsRegConst.getMandatoryValue(), strColumnName, intColumnCode) : (this.isOCI ? this.valFieldBasics(fieldStr, 40, SubsRegConst.getMandatoryValue(), strColumnName, intColumnCode) : this.valFieldBasics(fieldStr, 40, SubsRegConst.getOptionalValue(), strColumnName, intColumnCode));
            if (!this.isAlphanumeric(fieldStr)) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "3");
                return boolTemp;
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valCountry(String fieldStr, String strColumnName, int intColumnNum, boolean isT2, String CurrState) {
        boolean boolTemp = true;
        boolean boolCountCodeFound = false;
        String strErrCode = this.getErrorCode(intColumnNum);
        this.strCountCode = fieldStr;
        try {
            boolTemp = intColumnNum == 26 ? (this.isOCI || this.isNRI ? this.valFieldBasics(fieldStr, 2, SubsRegConst.getMandatoryValue(), strColumnName, intColumnNum) : this.valFieldBasics(fieldStr, 2, SubsRegConst.getOptionalValue(), strColumnName, intColumnNum)) : this.valFieldBasics(fieldStr, 2, SubsRegConst.getMandatoryValue(), strColumnName, intColumnNum);
            if (fieldStr != null && !"".equalsIgnoreCase(fieldStr) && fieldStr.length() < 2) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "2");
            }
            if (boolTemp) {
                if (fieldStr != null && !"".equalsIgnoreCase(fieldStr)) {
                    int i = 0;
                    while (i < this.strArrCountCodes.length) {
                        if (fieldStr.equals(this.strArrCountCodes[i])) {
                            boolCountCodeFound = true;
                        }
                        ++i;
                    }
                    if (!boolCountCodeFound) {
                        this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "3");
                    }
                }
                if (this.isNRI && intColumnNum == 26 && fieldStr != null && !"".equalsIgnoreCase(fieldStr) && "IN".equalsIgnoreCase(fieldStr)) {
                    System.out.println("The country is::" + fieldStr);
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "5");
                }
                if (this.isNRI && intColumnNum == 59 && !isT2 && fieldStr != null && !"".equalsIgnoreCase(fieldStr) && !"IN".equalsIgnoreCase(fieldStr)) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "6");
                }
                if (this.isNRI && intColumnNum == 35 && fieldStr != null && !"".equalsIgnoreCase(fieldStr) && !"IN".equalsIgnoreCase(fieldStr)) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "4");
                }
                if (this.isOCI && intColumnNum == 35 && fieldStr != null && !"".equalsIgnoreCase(fieldStr) && "IN".equalsIgnoreCase(fieldStr)) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "5");
                }
                if (fieldStr != null && !"".equalsIgnoreCase(fieldStr)) {
                    if (this.isOCI && "99".equalsIgnoreCase(CurrState) && "IN".equalsIgnoreCase(fieldStr) && intColumnNum == 26) {
                        boolTemp = false;
                        this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "6");
                    }
                    if (this.isOCI && !"IN".equalsIgnoreCase(fieldStr) && intColumnNum == 26) {
                        boolTemp = false;
                        this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "7");
                    }
                }
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valState(String fieldStr, String strColumnName, int intColumnNum, String Permaddress1) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnNum);
        this.strStateCode = fieldStr;
        try {
            boolTemp = intColumnNum == 25 ? (this.isOCI || this.isNRI ? this.valFieldBasics(fieldStr, 2, SubsRegConst.getMandatoryValue(), strColumnName, intColumnNum) : this.valFieldBasics(fieldStr, 2, SubsRegConst.getOptionalValue(), strColumnName, intColumnNum)) : this.valFieldBasics(fieldStr, 2, SubsRegConst.getMandatoryValue(), strColumnName, intColumnNum);
            if (fieldStr != null && !"".equalsIgnoreCase(fieldStr) && fieldStr.length() < 2) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "2");
                System.out.println("boolTemp2: " + boolTemp);
                return boolTemp;
            }
            System.out.println("boolTemp: " + boolTemp);
            int stateCode = 0;
            if (boolTemp && fieldStr != null && !"".equalsIgnoreCase(fieldStr)) {
                if (!this.isNumber(fieldStr)) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "3");
                    System.out.println("boolTemp1: " + boolTemp);
                    return boolTemp;
                }
                System.out.println("isNumber(fieldStr)::" + this.isNumber(fieldStr));
                if (this.isNumber(fieldStr)) {
                    stateCode = Integer.parseInt(fieldStr);
                    if (!this.isNRI && !this.isOCI || intColumnNum == 34 || intColumnNum == 58 || intColumnNum == 25) {
                        if ((stateCode <= 0 || stateCode > 37) && stateCode != 99 && stateCode != 88) {
                            boolTemp = false;
                            this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "4");
                            System.out.println("boolTemp3: " + boolTemp);
                            return boolTemp;
                        }
                        if ("08".equalsIgnoreCase(fieldStr)) {
                            boolTemp = false;
                            this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "4");
                            System.out.println("boolTemp3: " + boolTemp);
                            return boolTemp;
                        }
                    }
                    if (this.isNRI && intColumnNum == 25 && stateCode != 99) {
                        boolTemp = false;
                        this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "4");
                        return boolTemp;
                    }
                    if (this.isNRI && intColumnNum == 34) {
                        if (stateCode == 99 || stateCode == 88) {
                            boolTemp = false;
                            this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "5");
                            return boolTemp;
                        }
                    } else if (this.isOCI && intColumnNum == 34 && stateCode != 99) {
                        boolTemp = false;
                        this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "6");
                        return boolTemp;
                    }
                    if (this.isOCI && stateCode == 99 && intColumnNum == 25) {
                        boolTemp = false;
                        this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "5");
                        return boolTemp;
                    }
                }
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valSpecialChar(String fieldStr, String strColumnName, int intColumnNum) {
        boolean boolTemp1 = true;
        String strErrCode = this.getErrorCode(intColumnNum);
        try {
            int stringLength = 0;
            if (fieldStr != null) {
                stringLength = fieldStr.length();
            }
            System.out.println("Name: " + fieldStr);
            System.out.println("Length: " + stringLength);
            int count = 0;
            int countSpaces = 0;
            int countSpecialChar = 0;
            if (stringLength != 0) {
                int x = 0;
                while (x < stringLength) {
                    char ch = fieldStr.charAt(x);
                    char ch1 = ch;
                    if (ch1 >= 'A' && ch1 <= 'Z' || ch1 >= 'a' && ch1 <= 'z' || ch1 == ' ' || ch1 > '/' && ch1 < ':') {
                        ++count;
                        if (ch1 == ' ') {
                            ++countSpaces;
                        }
                    } else {
                        ++countSpecialChar;
                    }
                    ++x;
                }
                System.out.println("count: " + count);
                System.out.println("countSpaces: " + countSpaces);
                System.out.println("countSpecialChar: " + countSpecialChar);
                if (countSpecialChar > 0) {
                    boolTemp1 = false;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "7");
                    return boolTemp1;
                }
                if (countSpaces == stringLength) {
                    boolTemp1 = false;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "8");
                    return boolTemp1;
                }
                if (stringLength == count) {
                    boolTemp1 = true;
                }
            }
        }
        catch (Exception e) {
            boolTemp1 = false;
            return boolTemp1;
        }
        return boolTemp1;
    }

    public boolean valFatherFirstName(String strFirstName, String strColumnName, int intColumnNum, String mothername, String OrphanFlg) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnNum);
        int cnt = 0;
        try {
            boolTemp = "Y".equalsIgnoreCase(OrphanFlg) ? this.valFieldBasics(strFirstName.trim(), 30, SubsRegConst.getOptionalValue(), strColumnName, intColumnNum) : (!"".equalsIgnoreCase(mothername) && mothername != null ? this.valFieldBasics(strFirstName.trim(), 30, SubsRegConst.getOptionalValue(), strColumnName, intColumnNum) : (!"".equalsIgnoreCase(strFirstName) && strFirstName != null ? this.valFieldBasics(strFirstName.trim(), 30, SubsRegConst.getOptionalValue(), strColumnName, intColumnNum) : this.valFieldBasics(strFirstName.trim(), 30, SubsRegConst.getOptionalValue(), strColumnName, intColumnNum)));
            System.out.println("EXP");
            System.out.println(!(!"N".equalsIgnoreCase(OrphanFlg) || !"".equalsIgnoreCase(strFirstName) && strFirstName != null || !"".equalsIgnoreCase(mothername) && mothername != null));
            if ("N".equalsIgnoreCase(OrphanFlg) && ("".equalsIgnoreCase(strFirstName) || strFirstName == null) && ("".equalsIgnoreCase(mothername) || mothername == null)) {
                System.out.println("false1");
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strFirstName, String.valueOf(strErrCode) + "7");
            }
            if ("Y".equalsIgnoreCase(OrphanFlg) && !"".equalsIgnoreCase(strFirstName) && strFirstName != null) {
                System.out.println("false2");
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strFirstName, String.valueOf(strErrCode) + "8");
            }
            if (!"".equalsIgnoreCase(strFirstName) && strFirstName != null) {
                System.out.println("inside not null");
                if (strFirstName.toUpperCase().charAt(0) != '\'' && (strFirstName.toUpperCase().charAt(0) < 'A' || strFirstName.toUpperCase().charAt(0) > 'Z')) {
                    System.out.println("false3");
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, strFirstName, String.valueOf(strErrCode) + "3");
                    return boolTemp;
                }
                cnt = 1;
                while (cnt < strFirstName.length()) {
                    if (strFirstName.charAt(cnt) != ' ' && strFirstName.charAt(cnt) != '&' && strFirstName.charAt(cnt) != '\'' && strFirstName.charAt(cnt) != '.' && strFirstName.charAt(cnt) != '(' && strFirstName.charAt(cnt) != ')' && strFirstName.charAt(cnt) != ',' && strFirstName.charAt(cnt) != '-' && strFirstName.charAt(cnt) != '.' && strFirstName.charAt(cnt) != '/' && strFirstName.charAt(cnt) != '\\' && strFirstName.charAt(cnt) != '~' && strFirstName.charAt(cnt) != '!' && strFirstName.charAt(cnt) != '@' && strFirstName.charAt(cnt) != '#' && strFirstName.charAt(cnt) != '$' && strFirstName.charAt(cnt) != '%' && strFirstName.charAt(cnt) != '-' && strFirstName.charAt(cnt) != ';' && strFirstName.charAt(cnt) != '*' && strFirstName.charAt(cnt) != '_' && strFirstName.charAt(cnt) != '+' && strFirstName.charAt(cnt) != '=' && strFirstName.charAt(cnt) != '{' && strFirstName.charAt(cnt) != '}' && strFirstName.charAt(cnt) != '[' && strFirstName.charAt(cnt) != ']' && strFirstName.charAt(cnt) != '|' && strFirstName.charAt(cnt) != '?' && strFirstName.charAt(cnt) != ':' && strFirstName.charAt(cnt) != 'Y' && (strFirstName.toUpperCase().charAt(cnt) < 'A' || strFirstName.toUpperCase().charAt(cnt) > 'Z')) {
                        System.out.println("false4");
                        boolTemp = false;
                        this.respgen.genHTML(this.pcon, strColumnName, strFirstName, String.valueOf(strErrCode) + "4");
                        return boolTemp;
                    }
                    ++cnt;
                }
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valFatherFirstNameForMinor(String strFirstName, String LastName, String strColumnName, int intColumnNum) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnNum);
        int cnt = 0;
        try {
            if (!"".equalsIgnoreCase(strFirstName) || strFirstName != null) {
                System.out.println("if mother's name given then father's name should be blank");
                boolTemp = this.valFieldBasics(strFirstName.trim(), 30, SubsRegConst.getOptionalValue(), strColumnName, intColumnNum);
            }
            if (LastName != null && !"".equalsIgnoreCase(LastName) && (strFirstName == null || "".equalsIgnoreCase(strFirstName))) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strFirstName, String.valueOf(strErrCode) + "3");
                return boolTemp;
            }
            if (!"".equalsIgnoreCase(strFirstName) && strFirstName != null) {
                System.out.println("inside not null");
                if (strFirstName.toUpperCase().charAt(0) != '\'' && (strFirstName.toUpperCase().charAt(0) < 'A' || strFirstName.toUpperCase().charAt(0) > 'Z')) {
                    System.out.println("false3");
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, strFirstName, String.valueOf(strErrCode) + "3");
                    return boolTemp;
                }
                cnt = 1;
                while (cnt < strFirstName.length()) {
                    if (strFirstName.charAt(cnt) != ' ' && strFirstName.charAt(cnt) != '&' && strFirstName.charAt(cnt) != '\'' && strFirstName.charAt(cnt) != '.' && strFirstName.charAt(cnt) != '(' && strFirstName.charAt(cnt) != ')' && strFirstName.charAt(cnt) != ',' && strFirstName.charAt(cnt) != '-' && strFirstName.charAt(cnt) != '.' && strFirstName.charAt(cnt) != '/' && strFirstName.charAt(cnt) != '\\' && strFirstName.charAt(cnt) != '~' && strFirstName.charAt(cnt) != '!' && strFirstName.charAt(cnt) != '@' && strFirstName.charAt(cnt) != '#' && strFirstName.charAt(cnt) != '$' && strFirstName.charAt(cnt) != '%' && strFirstName.charAt(cnt) != '-' && strFirstName.charAt(cnt) != ';' && strFirstName.charAt(cnt) != '*' && strFirstName.charAt(cnt) != '_' && strFirstName.charAt(cnt) != '+' && strFirstName.charAt(cnt) != '=' && strFirstName.charAt(cnt) != '{' && strFirstName.charAt(cnt) != '}' && strFirstName.charAt(cnt) != '[' && strFirstName.charAt(cnt) != ']' && strFirstName.charAt(cnt) != '|' && strFirstName.charAt(cnt) != '?' && strFirstName.charAt(cnt) != ':' && strFirstName.charAt(cnt) != 'Y' && (strFirstName.toUpperCase().charAt(cnt) < 'A' || strFirstName.toUpperCase().charAt(cnt) > 'Z')) {
                        System.out.println("false4");
                        boolTemp = false;
                        this.respgen.genHTML(this.pcon, strColumnName, strFirstName, String.valueOf(strErrCode) + "4");
                        return boolTemp;
                    }
                    ++cnt;
                }
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valFatherLastName(String strLastName, String strColumnName, int intColumnNum, String OrphanFlg, String isUSPerson) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnNum);
        int cnt = 0;
        try {
            boolTemp = this.valFieldBasics(strLastName.trim(), 30, SubsRegConst.getOptionalValue(), strColumnName, intColumnNum);
            if ("Y".equalsIgnoreCase(OrphanFlg) && !"".equalsIgnoreCase(strLastName) && strLastName != null) {
                System.out.println("false2");
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strLastName, String.valueOf(strErrCode) + "8");
            }
            if (strLastName != null && !"".equalsIgnoreCase(strLastName)) {
                if (strLastName.toUpperCase().charAt(0) != '\'' && (strLastName.toUpperCase().charAt(0) < 'A' || strLastName.toUpperCase().charAt(0) > 'Z')) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, strLastName, String.valueOf(strErrCode) + "3");
                    return boolTemp;
                }
                cnt = 1;
                while (cnt < strLastName.length()) {
                    if (strLastName.charAt(cnt) != ' ' && strLastName.charAt(cnt) != '&' && strLastName.charAt(cnt) != '\'' && strLastName.charAt(cnt) != '.' && strLastName.charAt(cnt) != '(' && strLastName.charAt(cnt) != ')' && strLastName.charAt(cnt) != ',' && strLastName.charAt(cnt) != '-' && strLastName.charAt(cnt) != '.' && strLastName.charAt(cnt) != '/' && strLastName.charAt(cnt) != '\\' && strLastName.charAt(cnt) != '~' && strLastName.charAt(cnt) != '!' && strLastName.charAt(cnt) != '@' && strLastName.charAt(cnt) != '#' && strLastName.charAt(cnt) != '$' && strLastName.charAt(cnt) != '%' && strLastName.charAt(cnt) != '-' && strLastName.charAt(cnt) != ';' && strLastName.charAt(cnt) != '*' && strLastName.charAt(cnt) != '_' && strLastName.charAt(cnt) != '+' && strLastName.charAt(cnt) != '=' && strLastName.charAt(cnt) != '{' && strLastName.charAt(cnt) != '}' && strLastName.charAt(cnt) != '[' && strLastName.charAt(cnt) != ']' && strLastName.charAt(cnt) != '|' && strLastName.charAt(cnt) != '?' && strLastName.charAt(cnt) != ':' && strLastName.charAt(cnt) != 'Y' && (strLastName.toUpperCase().charAt(cnt) < 'A' || strLastName.toUpperCase().charAt(cnt) > 'Z')) {
                        boolTemp = false;
                        this.respgen.genHTML(this.pcon, strColumnName, strLastName, String.valueOf(strErrCode) + "4");
                        return boolTemp;
                    }
                    ++cnt;
                }
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valFatherLastNameForMinor(String strLastName, String Firstname, String strColumnName, int intColumnNum) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnNum);
        int cnt = 0;
        try {
            boolTemp = this.valFieldBasics(strLastName.trim(), 30, SubsRegConst.getOptionalValue(), strColumnName, intColumnNum);
            if (Firstname != null && !"".equalsIgnoreCase(Firstname) && (strLastName == null || "".equalsIgnoreCase(strLastName))) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strLastName, String.valueOf(strErrCode) + "3");
                return boolTemp;
            }
            if (strLastName != null && !"".equalsIgnoreCase(strLastName)) {
                if (strLastName.toUpperCase().charAt(0) != '\'' && (strLastName.toUpperCase().charAt(0) < 'A' || strLastName.toUpperCase().charAt(0) > 'Z')) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, strLastName, String.valueOf(strErrCode) + "3");
                    return boolTemp;
                }
                cnt = 1;
                while (cnt < strLastName.length()) {
                    if (strLastName.charAt(cnt) != ' ' && strLastName.charAt(cnt) != '&' && strLastName.charAt(cnt) != '\'' && strLastName.charAt(cnt) != '.' && strLastName.charAt(cnt) != '(' && strLastName.charAt(cnt) != ')' && strLastName.charAt(cnt) != ',' && strLastName.charAt(cnt) != '-' && strLastName.charAt(cnt) != '.' && strLastName.charAt(cnt) != '/' && strLastName.charAt(cnt) != '\\' && strLastName.charAt(cnt) != '~' && strLastName.charAt(cnt) != '!' && strLastName.charAt(cnt) != '@' && strLastName.charAt(cnt) != '#' && strLastName.charAt(cnt) != '$' && strLastName.charAt(cnt) != '%' && strLastName.charAt(cnt) != '-' && strLastName.charAt(cnt) != ';' && strLastName.charAt(cnt) != '*' && strLastName.charAt(cnt) != '_' && strLastName.charAt(cnt) != '+' && strLastName.charAt(cnt) != '=' && strLastName.charAt(cnt) != '{' && strLastName.charAt(cnt) != '}' && strLastName.charAt(cnt) != '[' && strLastName.charAt(cnt) != ']' && strLastName.charAt(cnt) != '|' && strLastName.charAt(cnt) != '?' && strLastName.charAt(cnt) != ':' && strLastName.charAt(cnt) != 'Y' && (strLastName.toUpperCase().charAt(cnt) < 'A' || strLastName.toUpperCase().charAt(cnt) > 'Z')) {
                        boolTemp = false;
                        this.respgen.genHTML(this.pcon, strColumnName, strLastName, String.valueOf(strErrCode) + "4");
                        return boolTemp;
                    }
                    ++cnt;
                }
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valFatherMiddleName(String strMiddleName, String strColumnName, int intColumnNum, String OrphanFlg, String isUSPerson) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnNum);
        int cnt = 0;
        try {
            boolTemp = this.valFieldBasics(strMiddleName.trim(), 30, SubsRegConst.getOptionalValue(), strColumnName, intColumnNum);
            if ("Y".equalsIgnoreCase(OrphanFlg) && !"".equalsIgnoreCase(strMiddleName) && strMiddleName != null) {
                System.out.println("false2");
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strMiddleName, String.valueOf(strErrCode) + "8");
            }
            if (!strMiddleName.trim().trim().equals("")) {
                if (strMiddleName.toUpperCase().charAt(0) != '\'' && (strMiddleName.toUpperCase().charAt(0) < 'A' || strMiddleName.toUpperCase().charAt(0) > 'Z')) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, strMiddleName, String.valueOf(strErrCode) + "3");
                    return boolTemp;
                }
                cnt = 1;
                while (cnt < strMiddleName.length()) {
                    if (strMiddleName.charAt(cnt) != ' ' && strMiddleName.charAt(cnt) != '&' && strMiddleName.charAt(cnt) != '\'' && strMiddleName.charAt(cnt) != '.' && strMiddleName.charAt(cnt) != '(' && strMiddleName.charAt(cnt) != ')' && strMiddleName.charAt(cnt) != ',' && strMiddleName.charAt(cnt) != '-' && strMiddleName.charAt(cnt) != '.' && strMiddleName.charAt(cnt) != '/' && strMiddleName.charAt(cnt) != '\\' && strMiddleName.charAt(cnt) != '~' && strMiddleName.charAt(cnt) != '!' && strMiddleName.charAt(cnt) != '@' && strMiddleName.charAt(cnt) != '#' && strMiddleName.charAt(cnt) != '$' && strMiddleName.charAt(cnt) != '%' && strMiddleName.charAt(cnt) != '-' && strMiddleName.charAt(cnt) != ';' && strMiddleName.charAt(cnt) != '*' && strMiddleName.charAt(cnt) != '_' && strMiddleName.charAt(cnt) != '+' && strMiddleName.charAt(cnt) != '=' && strMiddleName.charAt(cnt) != '{' && strMiddleName.charAt(cnt) != '}' && strMiddleName.charAt(cnt) != '[' && strMiddleName.charAt(cnt) != ']' && strMiddleName.charAt(cnt) != '|' && strMiddleName.charAt(cnt) != '?' && strMiddleName.charAt(cnt) != ':' && strMiddleName.charAt(cnt) != 'Y' && (strMiddleName.toUpperCase().charAt(cnt) < 'A' || strMiddleName.toUpperCase().charAt(cnt) > 'Z')) {
                        boolTemp = false;
                        this.respgen.genHTML(this.pcon, strColumnName, strMiddleName, String.valueOf(strErrCode) + "4");
                        return boolTemp;
                    }
                    ++cnt;
                }
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valFatherMiddleNameForMinor(String strMiddleName, String strColumnName, int intColumnNum) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnNum);
        int cnt = 0;
        try {
            boolTemp = this.valFieldBasics(strMiddleName.trim(), 30, SubsRegConst.getOptionalValue(), strColumnName, intColumnNum);
            if (!strMiddleName.trim().trim().equals("")) {
                if (strMiddleName.toUpperCase().charAt(0) != '\'' && (strMiddleName.toUpperCase().charAt(0) < 'A' || strMiddleName.toUpperCase().charAt(0) > 'Z')) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, strMiddleName, String.valueOf(strErrCode) + "3");
                    return boolTemp;
                }
                cnt = 1;
                while (cnt < strMiddleName.length()) {
                    if (strMiddleName.charAt(cnt) != ' ' && strMiddleName.charAt(cnt) != '&' && strMiddleName.charAt(cnt) != '\'' && strMiddleName.charAt(cnt) != '.' && strMiddleName.charAt(cnt) != '(' && strMiddleName.charAt(cnt) != ')' && strMiddleName.charAt(cnt) != ',' && strMiddleName.charAt(cnt) != '-' && strMiddleName.charAt(cnt) != '.' && strMiddleName.charAt(cnt) != '/' && strMiddleName.charAt(cnt) != '\\' && strMiddleName.charAt(cnt) != '~' && strMiddleName.charAt(cnt) != '!' && strMiddleName.charAt(cnt) != '@' && strMiddleName.charAt(cnt) != '#' && strMiddleName.charAt(cnt) != '$' && strMiddleName.charAt(cnt) != '%' && strMiddleName.charAt(cnt) != '-' && strMiddleName.charAt(cnt) != ';' && strMiddleName.charAt(cnt) != '*' && strMiddleName.charAt(cnt) != '_' && strMiddleName.charAt(cnt) != '+' && strMiddleName.charAt(cnt) != '=' && strMiddleName.charAt(cnt) != '{' && strMiddleName.charAt(cnt) != '}' && strMiddleName.charAt(cnt) != '[' && strMiddleName.charAt(cnt) != ']' && strMiddleName.charAt(cnt) != '|' && strMiddleName.charAt(cnt) != '?' && strMiddleName.charAt(cnt) != ':' && strMiddleName.charAt(cnt) != 'Y' && (strMiddleName.toUpperCase().charAt(cnt) < 'A' || strMiddleName.toUpperCase().charAt(cnt) > 'Z')) {
                        boolTemp = false;
                        this.respgen.genHTML(this.pcon, strColumnName, strMiddleName, String.valueOf(strErrCode) + "4");
                        return boolTemp;
                    }
                    ++cnt;
                }
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valMotherFirstName(String strFirstName, String strColumnName, int intColumnNum, String fathername, String Orphanflag) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnNum);
        int cnt = 0;
        try {
            if ("Y".equalsIgnoreCase(Orphanflag)) {
                System.out.println("Orphan flag Y");
                boolTemp = this.valFieldBasics(strFirstName.trim(), 30, SubsRegConst.getOptionalValue(), strColumnName, intColumnNum);
            } else {
                boolTemp = !"".equalsIgnoreCase(fathername) && fathername != null ? this.valFieldBasics(strFirstName.trim(), 30, SubsRegConst.getOptionalValue(), strColumnName, intColumnNum) : (!"".equalsIgnoreCase(strFirstName) && strFirstName != null ? this.valFieldBasics(strFirstName.trim(), 30, SubsRegConst.getOptionalValue(), strColumnName, intColumnNum) : this.valFieldBasics(strFirstName.trim(), 30, SubsRegConst.getOptionalValue(), strColumnName, intColumnNum));
            }
            if ("N".equalsIgnoreCase(Orphanflag) && ("".equalsIgnoreCase(strFirstName) || strFirstName == null) && ("".equalsIgnoreCase(fathername) || fathername == null)) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strFirstName, String.valueOf(strErrCode) + "7");
                return boolTemp;
            }
            if ("Y".equalsIgnoreCase(Orphanflag) && !"".equalsIgnoreCase(strFirstName) && strFirstName != null) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strFirstName, String.valueOf(strErrCode) + "8");
                return boolTemp;
            }
            if (!"".equalsIgnoreCase(strFirstName) && strFirstName != null) {
                if (strFirstName.toUpperCase().charAt(0) != '\'' && (strFirstName.toUpperCase().charAt(0) < 'A' || strFirstName.toUpperCase().charAt(0) > 'Z')) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, strFirstName, String.valueOf(strErrCode) + "3");
                    return boolTemp;
                }
                cnt = 1;
                while (cnt < strFirstName.length()) {
                    if (strFirstName.charAt(cnt) != ' ' && strFirstName.charAt(cnt) != '&' && strFirstName.charAt(cnt) != '\'' && strFirstName.charAt(cnt) != '.' && strFirstName.charAt(cnt) != '(' && strFirstName.charAt(cnt) != ')' && strFirstName.charAt(cnt) != ',' && strFirstName.charAt(cnt) != '-' && strFirstName.charAt(cnt) != '.' && strFirstName.charAt(cnt) != '/' && strFirstName.charAt(cnt) != '\\' && strFirstName.charAt(cnt) != '~' && strFirstName.charAt(cnt) != '!' && strFirstName.charAt(cnt) != '@' && strFirstName.charAt(cnt) != '#' && strFirstName.charAt(cnt) != '$' && strFirstName.charAt(cnt) != '%' && strFirstName.charAt(cnt) != '-' && strFirstName.charAt(cnt) != ';' && strFirstName.charAt(cnt) != '*' && strFirstName.charAt(cnt) != '_' && strFirstName.charAt(cnt) != '+' && strFirstName.charAt(cnt) != '=' && strFirstName.charAt(cnt) != '{' && strFirstName.charAt(cnt) != '}' && strFirstName.charAt(cnt) != '[' && strFirstName.charAt(cnt) != ']' && strFirstName.charAt(cnt) != '|' && strFirstName.charAt(cnt) != '?' && strFirstName.charAt(cnt) != ':' && strFirstName.charAt(cnt) != 'Y' && (strFirstName.toUpperCase().charAt(cnt) < 'A' || strFirstName.toUpperCase().charAt(cnt) > 'Z')) {
                        boolTemp = false;
                        this.respgen.genHTML(this.pcon, strColumnName, strFirstName, String.valueOf(strErrCode) + "4");
                        return boolTemp;
                    }
                    ++cnt;
                }
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valMotherFirstNameForMinor(String strFirstName, String strColumnName, int intColumnNum) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnNum);
        int cnt = 0;
        try {
            boolTemp = this.valFieldBasics(strFirstName.trim(), 30, SubsRegConst.getOptionalValue(), strColumnName, intColumnNum);
            if (!"".equalsIgnoreCase(strFirstName) && strFirstName != null) {
                if (strFirstName.toUpperCase().charAt(0) != '\'' && (strFirstName.toUpperCase().charAt(0) < 'A' || strFirstName.toUpperCase().charAt(0) > 'Z')) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, strFirstName, String.valueOf(strErrCode) + "3");
                    return boolTemp;
                }
                cnt = 1;
                while (cnt < strFirstName.length()) {
                    if (strFirstName.charAt(cnt) != ' ' && strFirstName.charAt(cnt) != '&' && strFirstName.charAt(cnt) != '\'' && strFirstName.charAt(cnt) != '.' && strFirstName.charAt(cnt) != '(' && strFirstName.charAt(cnt) != ')' && strFirstName.charAt(cnt) != ',' && strFirstName.charAt(cnt) != '-' && strFirstName.charAt(cnt) != '.' && strFirstName.charAt(cnt) != '/' && strFirstName.charAt(cnt) != '\\' && strFirstName.charAt(cnt) != '~' && strFirstName.charAt(cnt) != '!' && strFirstName.charAt(cnt) != '@' && strFirstName.charAt(cnt) != '#' && strFirstName.charAt(cnt) != '$' && strFirstName.charAt(cnt) != '%' && strFirstName.charAt(cnt) != '-' && strFirstName.charAt(cnt) != ';' && strFirstName.charAt(cnt) != '*' && strFirstName.charAt(cnt) != '_' && strFirstName.charAt(cnt) != '+' && strFirstName.charAt(cnt) != '=' && strFirstName.charAt(cnt) != '{' && strFirstName.charAt(cnt) != '}' && strFirstName.charAt(cnt) != '[' && strFirstName.charAt(cnt) != ']' && strFirstName.charAt(cnt) != '|' && strFirstName.charAt(cnt) != '?' && strFirstName.charAt(cnt) != ':' && strFirstName.charAt(cnt) != 'Y' && (strFirstName.toUpperCase().charAt(cnt) < 'A' || strFirstName.toUpperCase().charAt(cnt) > 'Z')) {
                        boolTemp = false;
                        this.respgen.genHTML(this.pcon, strColumnName, strFirstName, String.valueOf(strErrCode) + "4");
                        return boolTemp;
                    }
                    ++cnt;
                }
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valMotherLastName(String strLastName, String strColumnName, int intColumnNum, String OrphanFlg) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnNum);
        int cnt = 0;
        try {
            boolTemp = this.valFieldBasics(strLastName.trim(), 30, SubsRegConst.getOptionalValue(), strColumnName, intColumnNum);
            if ("Y".equalsIgnoreCase(OrphanFlg) && !"".equalsIgnoreCase(strLastName) && strLastName != null) {
                System.out.println("false2");
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strLastName, String.valueOf(strErrCode) + "8");
                return boolTemp;
            }
            if (strLastName != null && !"".equalsIgnoreCase(strLastName)) {
                if (strLastName.toUpperCase().charAt(0) != '\'' && (strLastName.toUpperCase().charAt(0) < 'A' || strLastName.toUpperCase().charAt(0) > 'Z')) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, strLastName, String.valueOf(strErrCode) + "3");
                    return boolTemp;
                }
                cnt = 1;
                while (cnt < strLastName.length()) {
                    if (strLastName.charAt(cnt) != ' ' && strLastName.charAt(cnt) != '&' && strLastName.charAt(cnt) != '\'' && strLastName.charAt(cnt) != '.' && strLastName.charAt(cnt) != '(' && strLastName.charAt(cnt) != ')' && strLastName.charAt(cnt) != ',' && strLastName.charAt(cnt) != '-' && strLastName.charAt(cnt) != '.' && strLastName.charAt(cnt) != '/' && strLastName.charAt(cnt) != '\\' && strLastName.charAt(cnt) != '~' && strLastName.charAt(cnt) != '!' && strLastName.charAt(cnt) != '@' && strLastName.charAt(cnt) != '#' && strLastName.charAt(cnt) != '$' && strLastName.charAt(cnt) != '%' && strLastName.charAt(cnt) != '-' && strLastName.charAt(cnt) != ';' && strLastName.charAt(cnt) != '*' && strLastName.charAt(cnt) != '_' && strLastName.charAt(cnt) != '+' && strLastName.charAt(cnt) != '=' && strLastName.charAt(cnt) != '{' && strLastName.charAt(cnt) != '}' && strLastName.charAt(cnt) != '[' && strLastName.charAt(cnt) != ']' && strLastName.charAt(cnt) != '|' && strLastName.charAt(cnt) != '?' && strLastName.charAt(cnt) != ':' && strLastName.charAt(cnt) != 'Y' && (strLastName.toUpperCase().charAt(cnt) < 'A' || strLastName.toUpperCase().charAt(cnt) > 'Z')) {
                        boolTemp = false;
                        this.respgen.genHTML(this.pcon, strColumnName, strLastName, String.valueOf(strErrCode) + "4");
                        return boolTemp;
                    }
                    ++cnt;
                }
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valMotherMiddleName(String strMiddleName, String strColumnName, int intColumnNum, String OrphanFlg) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnNum);
        int cnt = 0;
        try {
            boolTemp = this.valFieldBasics(strMiddleName.trim(), 30, SubsRegConst.getOptionalValue(), strColumnName, intColumnNum);
            if ("Y".equalsIgnoreCase(OrphanFlg) && !"".equalsIgnoreCase(strMiddleName) && strMiddleName != null) {
                System.out.println("false2");
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strMiddleName, String.valueOf(strErrCode) + "8");
                return boolTemp;
            }
            if (!strMiddleName.trim().trim().equals("")) {
                if (strMiddleName.toUpperCase().charAt(0) != '\'' && (strMiddleName.toUpperCase().charAt(0) < 'A' || strMiddleName.toUpperCase().charAt(0) > 'Z')) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, strMiddleName, String.valueOf(strErrCode) + "3");
                    return boolTemp;
                }
                cnt = 1;
                while (cnt < strMiddleName.length()) {
                    if (strMiddleName.charAt(cnt) != ' ' && strMiddleName.charAt(cnt) != '&' && strMiddleName.charAt(cnt) != '\'' && strMiddleName.charAt(cnt) != '.' && strMiddleName.charAt(cnt) != '(' && strMiddleName.charAt(cnt) != ')' && strMiddleName.charAt(cnt) != ',' && strMiddleName.charAt(cnt) != '-' && strMiddleName.charAt(cnt) != '.' && strMiddleName.charAt(cnt) != '/' && strMiddleName.charAt(cnt) != '\\' && strMiddleName.charAt(cnt) != '~' && strMiddleName.charAt(cnt) != '!' && strMiddleName.charAt(cnt) != '@' && strMiddleName.charAt(cnt) != '#' && strMiddleName.charAt(cnt) != '$' && strMiddleName.charAt(cnt) != '%' && strMiddleName.charAt(cnt) != '-' && strMiddleName.charAt(cnt) != ';' && strMiddleName.charAt(cnt) != '*' && strMiddleName.charAt(cnt) != '_' && strMiddleName.charAt(cnt) != '+' && strMiddleName.charAt(cnt) != '=' && strMiddleName.charAt(cnt) != '{' && strMiddleName.charAt(cnt) != '}' && strMiddleName.charAt(cnt) != '[' && strMiddleName.charAt(cnt) != ']' && strMiddleName.charAt(cnt) != '|' && strMiddleName.charAt(cnt) != '?' && strMiddleName.charAt(cnt) != ':' && strMiddleName.charAt(cnt) != 'Y' && (strMiddleName.toUpperCase().charAt(cnt) < 'A' || strMiddleName.toUpperCase().charAt(cnt) > 'Z')) {
                        boolTemp = false;
                        this.respgen.genHTML(this.pcon, strColumnName, strMiddleName, String.valueOf(strErrCode) + "4");
                        return boolTemp;
                    }
                    ++cnt;
                }
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    protected String addForm60Doc(String form60flg1) {
        String form60DocHex = "";
        boolean getform60 = true;
        try {
            File filePhoto = new File(this.getForm60FileName());
            System.out.println("getForm60FileName:::" + this.getForm60FileName());
            System.out.println("filePhotofilePhoto::" + filePhoto.exists());
            if (filePhoto.exists() && "N".equalsIgnoreCase(form60flg1)) {
                form60DocHex = "WRONGHEX";
                this.respgen.genHTML(this.pcon, "Form60 Doc", "", "1021937");
            }
            if (form60flg1.equalsIgnoreCase("Y")) {
                getform60 = this.getForm60DocHex(filePhoto, form60flg1);
                System.out.println("getform60::" + getform60);
                if (getform60) {
                    System.out.println("hexVal::" + this.hexVal);
                    form60DocHex = this.hexVal.toUpperCase();
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error in adding form 60n document hash");
        }
        return form60DocHex;
    }

    protected String getForm60FileName() {
        String str = this.pcon.getFileName();
        System.out.println("str: " + str);
        str = str.substring(0, str.lastIndexOf("."));
        String strFileName = String.valueOf(str) + "_Form60photo" + File.separator + this.strAck + "_Form60photo.jpg";
        System.out.println("strFileName: " + strFileName);
        return strFileName;
    }

    protected boolean getForm60DocHex(File file, String form60flg1) {
        this.hexVal = "";
        boolean boolTemp = true;
        System.out.println(this.sessVO + "Photo abs path " + file.getAbsolutePath() + "file.length()::" + file.length());
        if (!file.exists() || file.length() == 0L) {
            this.hexVal = "";
            boolTemp = false;
            this.respgen.genHTML(this.pcon, "Form60 Doc", "", "1021931");
        }
        if ((double)file.length() / 1024.0 > 12.0) {
            this.hexVal = "";
            boolTemp = false;
            this.respgen.genHTML(this.pcon, "Form60 Doc", "", "1021932");
        }
        if (boolTemp) {
            try {
                FileInputStream fileIpStrm = new FileInputStream(file);
                int i = 0;
                while ((i = fileIpStrm.read()) != -1) {
                    String s = Integer.toHexString(i).trim();
                    if (s.length() == 1) {
                        s = "0" + s;
                    }
                    this.hexVal = String.valueOf(this.hexVal) + s;
                }
                fileIpStrm.close();
            }
            catch (IOException e) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, "Form60 Doc", "", "1021934");
                return boolTemp;
            }
            catch (Exception e) {
                this.hexVal = "";
                return boolTemp;
            }
        }
        return boolTemp;
    }

    public boolean getForm60DocExist(File file) {
        boolean hexVal = true;
        boolean boolTemp = true;
        System.out.println("ddddddddd::" + file.getAbsoluteFile());
        System.out.println(this.sessVO + "Photo abs path " + file.getAbsolutePath() + "file.exists()::" + file.exists());
        try {
            if (!file.exists() || file.length() == 0L) {
                hexVal = false;
                boolTemp = false;
                this.respgen.genHTML(this.pcon, "Photo", "", "1021931");
            }
            System.out.println("aaaaaaaaa::" + hexVal);
        }
        catch (Exception e) {
            hexVal = false;
            boolTemp = false;
            System.out.println("aaaaaaaaa::" + hexVal + "ssssssss" + e);
            return boolTemp;
        }
        return boolTemp;
    }

    protected String addOrphandoc(String Orphanflg) {
        String orphanDocHex = "";
        boolean getorphandoc = true;
        try {
            File filePhoto = new File(this.getOrphanFileName());
            System.out.println("getOrphanFileName:::" + this.getOrphanFileName());
            System.out.println("filePhotofilePhoto::" + filePhoto.exists());
            if (filePhoto.exists() && "N".equalsIgnoreCase(Orphanflg)) {
                orphanDocHex = "WRONGHEX";
                this.respgen.genHTML(this.pcon, "Orphan Doc", "", "1021947");
            }
            if (Orphanflg.equalsIgnoreCase("Y")) {
                getorphandoc = this.getOrphanDocHex(filePhoto, Orphanflg);
                System.out.println("getorphanflg::" + Orphanflg);
                if (getorphandoc) {
                    System.out.println("hexVal::" + this.hexVal);
                    orphanDocHex = this.hexVal.toUpperCase();
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error in adding form 60n document hash");
        }
        return orphanDocHex;
    }

    protected String addDobdoc(String minorFlag) {
        String dobDocHex = "";
        boolean getdobdoc = true;
        try {
            File filePhoto = new File(this.getDobFileName());
            System.out.println("getDobFileName:::" + this.getDobFileName());
            System.out.println("filePhotofilePhoto::" + filePhoto.exists());
            if (minorFlag.equalsIgnoreCase("M")) {
                getdobdoc = this.getDobDocHex(filePhoto, minorFlag);
                System.out.println("minorFlag::" + minorFlag);
                if (getdobdoc) {
                    System.out.println("hexVal::" + this.hexVal);
                    dobDocHex = this.hexVal.toUpperCase();
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error in adding form 60n document hash");
        }
        return dobDocHex;
    }

    protected String getDobFileName() {
        String str = this.pcon.getFileName();
        System.out.println("str: " + str);
        str = str.substring(0, str.lastIndexOf("."));
        String strFileName = String.valueOf(str) + "_Dobphoto" + File.separator + this.strAck + "_Dobphoto.jpg";
        System.out.println("strFileName: " + strFileName);
        return strFileName;
    }

    protected boolean getDobDocHex(File file, String MinorFlag) {
        this.hexVal = "";
        boolean boolTemp = true;
        System.out.println(this.sessVO + "Photo abs path " + file.getAbsolutePath() + "file.exists()::" + file.exists());
        if (!file.exists() || file.length() == 0L) {
            this.hexVal = "";
            boolTemp = false;
            this.respgen.genHTML(this.pcon, "DOB Doc", "", "1021941");
        }
        if ((double)file.length() / 1024.0 > 12.0) {
            this.hexVal = "";
            boolTemp = false;
            this.respgen.genHTML(this.pcon, "DOB Doc", "", "1021942");
        }
        if (boolTemp) {
            try {
                FileInputStream fileIpStrm = new FileInputStream(file);
                int i = 0;
                while ((i = fileIpStrm.read()) != -1) {
                    String s = Integer.toHexString(i).trim();
                    if (s.length() == 1) {
                        s = "0" + s;
                    }
                    this.hexVal = String.valueOf(this.hexVal) + s;
                }
                fileIpStrm.close();
            }
            catch (IOException e) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, "DOB Doc", "", "1021944");
                return boolTemp;
            }
            catch (Exception e) {
                this.hexVal = "";
                return boolTemp;
            }
        }
        return boolTemp;
    }

    public boolean getDobDocExist(File file) {
        boolean hexVal = true;
        boolean boolTemp = true;
        System.out.println("ddddddddd::" + file.getAbsoluteFile());
        System.out.println(this.sessVO + "Photo abs path " + file.getAbsolutePath() + "file.exists()::" + file.exists());
        try {
            if (!file.exists() || file.length() == 0L) {
                hexVal = false;
                boolTemp = false;
                this.respgen.genHTML(this.pcon, "Photo", "", "1021941");
            }
            System.out.println("aaaaaaaaa::" + hexVal);
        }
        catch (Exception e) {
            hexVal = false;
            boolTemp = false;
            System.out.println("aaaaaaaaa::" + hexVal + "ssssssss" + e);
            return boolTemp;
        }
        return boolTemp;
    }

    protected String getOrphanFileName() {
        String str = this.pcon.getFileName();
        System.out.println("str: " + str);
        str = str.substring(0, str.lastIndexOf("."));
        String strFileName = String.valueOf(str) + "_orphandocphoto" + File.separator + this.strAck + "_orphandocphoto.jpg";
        System.out.println("strFileName: " + strFileName);
        return strFileName;
    }

    protected boolean getOrphanDocHex(File file, String Orphanflg) {
        this.hexVal = "";
        boolean boolTemp = true;
        System.out.println(this.sessVO + "Photo abs path " + file.getAbsolutePath() + "file.exists()::" + file.exists());
        if (!file.exists() || file.length() == 0L) {
            this.hexVal = "";
            boolTemp = false;
            this.respgen.genHTML(this.pcon, "Orphan Doc", "", "1021941");
        }
        if ((double)file.length() / 1024.0 > 12.0) {
            this.hexVal = "";
            boolTemp = false;
            this.respgen.genHTML(this.pcon, "Orphan Doc", "", "1021942");
        }
        if (boolTemp) {
            try {
                FileInputStream fileIpStrm = new FileInputStream(file);
                int i = 0;
                while ((i = fileIpStrm.read()) != -1) {
                    String s = Integer.toHexString(i).trim();
                    if (s.length() == 1) {
                        s = "0" + s;
                    }
                    this.hexVal = String.valueOf(this.hexVal) + s;
                }
                fileIpStrm.close();
            }
            catch (IOException e) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, "Orphan Doc", "", "1021944");
                return boolTemp;
            }
            catch (Exception e) {
                this.hexVal = "";
                return boolTemp;
            }
        }
        return boolTemp;
    }

    public boolean getOrphanDocExist(File file) {
        boolean hexVal = true;
        boolean boolTemp = true;
        System.out.println("ddddddddd::" + file.getAbsoluteFile());
        System.out.println(this.sessVO + "Photo abs path " + file.getAbsolutePath() + "file.exists()::" + file.exists());
        try {
            if (!file.exists() || file.length() == 0L) {
                hexVal = false;
                boolTemp = false;
                this.respgen.genHTML(this.pcon, "Photo", "", "1021941");
            }
            System.out.println("aaaaaaaaa::" + hexVal);
        }
        catch (Exception e) {
            hexVal = false;
            boolTemp = false;
            System.out.println("aaaaaaaaa::" + hexVal + "ssssssss" + e);
            return boolTemp;
        }
        return boolTemp;
    }

    protected String addCitizendoc(String Docevidenceflg) {
        String citizenDocHex = "";
        boolean getcitizendoc = true;
        try {
            File filePhoto = new File(this.getCitizendocName());
            System.out.println("getCitizendocName:::" + this.getCitizendocName());
            System.out.println("filePhotofilePhoto::" + filePhoto.exists());
            if (filePhoto.exists() && "N".equalsIgnoreCase(Docevidenceflg)) {
                citizenDocHex = "WRONGHEX";
                this.respgen.genHTML(this.pcon, "Citizen Doc", "", "1021957");
            }
            if (Docevidenceflg.equalsIgnoreCase("Y")) {
                getcitizendoc = this.getCitizenDocHex(filePhoto, Docevidenceflg);
                System.out.println("Docevidenceflg::" + Docevidenceflg);
                if (getcitizendoc) {
                    System.out.println("hexVal::" + this.hexVal);
                    citizenDocHex = this.hexVal.toUpperCase();
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error in adding citizen document hash");
        }
        return citizenDocHex;
    }

    protected String getCitizendocName() {
        String str = this.pcon.getFileName();
        System.out.println("str: " + str);
        str = str.substring(0, str.lastIndexOf("."));
        String strFileName = String.valueOf(str) + "_citizendocphoto" + File.separator + this.strAck + "_citizendocphoto.jpg";
        System.out.println("strFileName: " + strFileName);
        return strFileName;
    }

    protected boolean getCitizenDocHex(File file, String citizenflg) {
        this.hexVal = "";
        boolean boolTemp = true;
        System.out.println(this.sessVO + "Photo abs path " + file.getAbsolutePath() + "file.exists()::" + file.exists());
        if (!file.exists() || file.length() == 0L) {
            this.hexVal = "";
            boolTemp = false;
            this.respgen.genHTML(this.pcon, "citizen Doc", "", "1021951");
        }
        if ((double)file.length() / 1024.0 > 12.0) {
            this.hexVal = "";
            boolTemp = false;
            this.respgen.genHTML(this.pcon, "citizen Doc", "", "1021952");
        }
        if (boolTemp) {
            try {
                FileInputStream fileIpStrm = new FileInputStream(file);
                int i = 0;
                while ((i = fileIpStrm.read()) != -1) {
                    String s = Integer.toHexString(i).trim();
                    if (s.length() == 1) {
                        s = "0" + s;
                    }
                    this.hexVal = String.valueOf(this.hexVal) + s;
                }
                fileIpStrm.close();
            }
            catch (IOException e) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, "citizen Doc", "", "1021954");
                return boolTemp;
            }
            catch (Exception e) {
                this.hexVal = "";
                return boolTemp;
            }
        }
        return boolTemp;
    }

    public boolean getCitizenDocExist(File file) {
        boolean hexVal = true;
        boolean boolTemp = true;
        System.out.println("ddddddddd::" + file.getAbsoluteFile());
        System.out.println(this.sessVO + "Photo abs path " + file.getAbsolutePath() + "file.exists()::" + file.exists());
        try {
            if (!file.exists() || file.length() == 0L) {
                hexVal = false;
                boolTemp = false;
                this.respgen.genHTML(this.pcon, "Photo", "", "1021951");
            }
            System.out.println("aaaaaaaaa::" + hexVal);
        }
        catch (Exception e) {
            hexVal = false;
            boolTemp = false;
            System.out.println("aaaaaaaaa::" + hexVal + "ssssssss" + e);
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valFatherFirstNameUPS(String strFirstName, String strColumnName, int intColumnNum, String mothername, String OrphanFlg) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnNum);
        int cnt = 0;
        try {
            if ("N".equalsIgnoreCase(OrphanFlg)) {
                if (!"".equalsIgnoreCase(mothername) || mothername != null) {
                    System.out.println("if mother's name given then father's name should be blank");
                    boolTemp = this.valFieldBasics(strFirstName.trim(), 30, SubsRegConst.getOptionalValue(), strColumnName, intColumnNum);
                } else if ("".equalsIgnoreCase(mothername) || mothername == null) {
                    System.out.println("else if mother's nsame given then father's name should be blank");
                    boolTemp = this.valFieldBasics(strFirstName.trim(), 30, SubsRegConst.getMandatoryValue(), strColumnName, intColumnNum);
                }
            } else if (strFirstName != null && !"".equalsIgnoreCase(strFirstName.trim())) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strFirstName, String.valueOf(strErrCode) + "8");
            }
            System.out.println(!(!"N".equalsIgnoreCase(OrphanFlg) || !"".equalsIgnoreCase(strFirstName) && strFirstName != null || !"".equalsIgnoreCase(mothername) && mothername != null));
            if (!"".equalsIgnoreCase(strFirstName) && strFirstName != null) {
                System.out.println("inside not null");
                if (strFirstName.toUpperCase().charAt(0) != '\'' && (strFirstName.toUpperCase().charAt(0) < 'A' || strFirstName.toUpperCase().charAt(0) > 'Z')) {
                    System.out.println("false3");
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, strFirstName, String.valueOf(strErrCode) + "3");
                    return boolTemp;
                }
                cnt = 1;
                while (cnt < strFirstName.length()) {
                    if (strFirstName.charAt(cnt) != ' ' && strFirstName.charAt(cnt) != '&' && strFirstName.charAt(cnt) != '\'' && strFirstName.charAt(cnt) != '.' && strFirstName.charAt(cnt) != '(' && strFirstName.charAt(cnt) != ')' && strFirstName.charAt(cnt) != ',' && strFirstName.charAt(cnt) != '-' && strFirstName.charAt(cnt) != '.' && strFirstName.charAt(cnt) != '/' && strFirstName.charAt(cnt) != '\\' && strFirstName.charAt(cnt) != '~' && strFirstName.charAt(cnt) != '!' && strFirstName.charAt(cnt) != '@' && strFirstName.charAt(cnt) != '#' && strFirstName.charAt(cnt) != '$' && strFirstName.charAt(cnt) != '%' && strFirstName.charAt(cnt) != '-' && strFirstName.charAt(cnt) != ';' && strFirstName.charAt(cnt) != '*' && strFirstName.charAt(cnt) != '_' && strFirstName.charAt(cnt) != '+' && strFirstName.charAt(cnt) != '=' && strFirstName.charAt(cnt) != '{' && strFirstName.charAt(cnt) != '}' && strFirstName.charAt(cnt) != '[' && strFirstName.charAt(cnt) != ']' && strFirstName.charAt(cnt) != '|' && strFirstName.charAt(cnt) != '?' && strFirstName.charAt(cnt) != ':' && strFirstName.charAt(cnt) != 'Y' && (strFirstName.toUpperCase().charAt(cnt) < 'A' || strFirstName.toUpperCase().charAt(cnt) > 'Z')) {
                        System.out.println("false4");
                        boolTemp = false;
                        this.respgen.genHTML(this.pcon, strColumnName, strFirstName, String.valueOf(strErrCode) + "4");
                        return boolTemp;
                    }
                    ++cnt;
                }
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valFatherFirstNameNew(String strFirstName, String strColumnName, int intColumnNum, String mothername) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnNum);
        int cnt = 0;
        try {
            boolTemp = !"".equalsIgnoreCase(mothername) && mothername != null ? this.valFieldBasics(strFirstName.trim(), 30, SubsRegConst.getOptionalValue(), strColumnName, intColumnNum) : (!"".equalsIgnoreCase(strFirstName) && strFirstName != null ? this.valFieldBasics(strFirstName.trim(), 30, SubsRegConst.getOptionalValue(), strColumnName, intColumnNum) : this.valFieldBasics(strFirstName.trim(), 30, SubsRegConst.getOptionalValue(), strColumnName, intColumnNum));
            System.out.println("EXP");
            System.out.println(!(!"".equalsIgnoreCase(strFirstName) && strFirstName != null || !"".equalsIgnoreCase(mothername) && mothername != null));
            if (("".equalsIgnoreCase(strFirstName) || strFirstName == null) && ("".equalsIgnoreCase(mothername) || mothername == null)) {
                System.out.println("false1");
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strFirstName, String.valueOf(strErrCode) + "7");
            }
            if (!"".equalsIgnoreCase(strFirstName) && strFirstName != null) {
                System.out.println("inside not null");
                if (strFirstName.toUpperCase().charAt(0) != '\'' && (strFirstName.toUpperCase().charAt(0) < 'A' || strFirstName.toUpperCase().charAt(0) > 'Z')) {
                    System.out.println("false3");
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, strFirstName, String.valueOf(strErrCode) + "3");
                    return boolTemp;
                }
                cnt = 1;
                while (cnt < strFirstName.length()) {
                    if (strFirstName.charAt(cnt) != ' ' && strFirstName.charAt(cnt) != '&' && strFirstName.charAt(cnt) != '\'' && strFirstName.charAt(cnt) != '.' && strFirstName.charAt(cnt) != '(' && strFirstName.charAt(cnt) != ')' && strFirstName.charAt(cnt) != ',' && strFirstName.charAt(cnt) != '-' && strFirstName.charAt(cnt) != '.' && strFirstName.charAt(cnt) != '/' && strFirstName.charAt(cnt) != '\\' && strFirstName.charAt(cnt) != '~' && strFirstName.charAt(cnt) != '!' && strFirstName.charAt(cnt) != '@' && strFirstName.charAt(cnt) != '#' && strFirstName.charAt(cnt) != '$' && strFirstName.charAt(cnt) != '%' && strFirstName.charAt(cnt) != '-' && strFirstName.charAt(cnt) != ';' && strFirstName.charAt(cnt) != '*' && strFirstName.charAt(cnt) != '_' && strFirstName.charAt(cnt) != '+' && strFirstName.charAt(cnt) != '=' && strFirstName.charAt(cnt) != '{' && strFirstName.charAt(cnt) != '}' && strFirstName.charAt(cnt) != '[' && strFirstName.charAt(cnt) != ']' && strFirstName.charAt(cnt) != '|' && strFirstName.charAt(cnt) != '?' && strFirstName.charAt(cnt) != ':' && strFirstName.charAt(cnt) != 'Y' && (strFirstName.toUpperCase().charAt(cnt) < 'A' || strFirstName.toUpperCase().charAt(cnt) > 'Z')) {
                        System.out.println("false4");
                        boolTemp = false;
                        this.respgen.genHTML(this.pcon, strColumnName, strFirstName, String.valueOf(strErrCode) + "4");
                        return boolTemp;
                    }
                    ++cnt;
                }
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valMotherFirstNameNew(String strFirstName, String strColumnName, int intColumnNum, String fathername) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnNum);
        int cnt = 0;
        try {
            boolTemp = !"".equalsIgnoreCase(fathername) && fathername != null ? this.valFieldBasics(strFirstName.trim(), 30, SubsRegConst.getOptionalValue(), strColumnName, intColumnNum) : (!"".equalsIgnoreCase(strFirstName) && strFirstName != null ? this.valFieldBasics(strFirstName.trim(), 30, SubsRegConst.getOptionalValue(), strColumnName, intColumnNum) : this.valFieldBasics(strFirstName.trim(), 30, SubsRegConst.getOptionalValue(), strColumnName, intColumnNum));
            if (("".equalsIgnoreCase(strFirstName) || strFirstName == null) && ("".equalsIgnoreCase(fathername) || fathername == null)) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strFirstName, String.valueOf(strErrCode) + "7");
                return boolTemp;
            }
            if (!"".equalsIgnoreCase(strFirstName) && strFirstName != null) {
                if (strFirstName.toUpperCase().charAt(0) != '\'' && (strFirstName.toUpperCase().charAt(0) < 'A' || strFirstName.toUpperCase().charAt(0) > 'Z')) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, strFirstName, String.valueOf(strErrCode) + "3");
                    return boolTemp;
                }
                cnt = 1;
                while (cnt < strFirstName.length()) {
                    if (strFirstName.charAt(cnt) != ' ' && strFirstName.charAt(cnt) != '&' && strFirstName.charAt(cnt) != '\'' && strFirstName.charAt(cnt) != '.' && strFirstName.charAt(cnt) != '(' && strFirstName.charAt(cnt) != ')' && strFirstName.charAt(cnt) != ',' && strFirstName.charAt(cnt) != '-' && strFirstName.charAt(cnt) != '.' && strFirstName.charAt(cnt) != '/' && strFirstName.charAt(cnt) != '\\' && strFirstName.charAt(cnt) != '~' && strFirstName.charAt(cnt) != '!' && strFirstName.charAt(cnt) != '@' && strFirstName.charAt(cnt) != '#' && strFirstName.charAt(cnt) != '$' && strFirstName.charAt(cnt) != '%' && strFirstName.charAt(cnt) != '-' && strFirstName.charAt(cnt) != ';' && strFirstName.charAt(cnt) != '*' && strFirstName.charAt(cnt) != '_' && strFirstName.charAt(cnt) != '+' && strFirstName.charAt(cnt) != '=' && strFirstName.charAt(cnt) != '{' && strFirstName.charAt(cnt) != '}' && strFirstName.charAt(cnt) != '[' && strFirstName.charAt(cnt) != ']' && strFirstName.charAt(cnt) != '|' && strFirstName.charAt(cnt) != '?' && strFirstName.charAt(cnt) != ':' && strFirstName.charAt(cnt) != 'Y' && (strFirstName.toUpperCase().charAt(cnt) < 'A' || strFirstName.toUpperCase().charAt(cnt) > 'Z')) {
                        boolTemp = false;
                        this.respgen.genHTML(this.pcon, strColumnName, strFirstName, String.valueOf(strErrCode) + "4");
                        return boolTemp;
                    }
                    ++cnt;
                }
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }
}

