/*
 * Decompiled with CFR 0.152.
 */
package com.cra.common.util;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class CRAConfigReader {
    private static final String PROPERTIES_SWITCH = "/resources/cra-switch.properties";
    private static final String PROPERTIES_GENERAL = "/resources/general-config.properties";
    private static final String PROPERTIES_ERRORCODES = "/resources/ApplicationResources.properties";
    private static final String CRA_CONFIG_COMMON = "/resources/cra-config.properties";
    private static final String NPSCAN_CONFIG_COMMON = "/resources/npscan-config.properties";
    private static final String CRA_CONFIG = "/resources/cra-config-";
    private static final String NPSCAN_CONFIG = "/resources/npscan-config-";
    private static final String CRA_CLIENT = "/resources/cra-client-";
    private static final String NPSCAN_CLIENT = "/resources/npscan-client-";
    public static HashMap<String, String> configPropMap = new HashMap();
    public static HashMap<String, String> errorCodePropMap = new HashMap();
    private static String currentDeployment = "dev";

    static {
        Properties prop = new Properties();
        try {
            try {
                String key4;
                prop.load(CRAConfigReader.class.getResourceAsStream(PROPERTIES_SWITCH));
                Enumeration<Object> enumSwtich = prop.keys();
                while (enumSwtich.hasMoreElements()) {
                    String key2 = (String)enumSwtich.nextElement();
                    if (key2.equals("cra.current.deployment")) {
                        currentDeployment = (String)prop.get(key2);
                    }
                    configPropMap.put(key2, (String)prop.get(key2));
                }
                Enumeration<Object> ee = null;
                try {
                    prop.load(CRAConfigReader.class.getResourceAsStream(PROPERTIES_GENERAL));
                    ee = prop.keys();
                    while (ee.hasMoreElements()) {
                        String key3 = (String)ee.nextElement();
                        configPropMap.put(key3, (String)prop.get(key3));
                    }
                }
                catch (Exception key3) {
                    // empty catch block
                }
                String systemName = configPropMap.get("SYNC.SYSTEM_NAME");
                try {
                    if (systemName != null && systemName.equals("NPSCAN")) {
                        prop.load(CRAConfigReader.class.getResourceAsStream(NPSCAN_CONFIG_COMMON));
                    } else {
                        prop.load(CRAConfigReader.class.getResourceAsStream(CRA_CONFIG_COMMON));
                    }
                    ee = prop.keys();
                    while (ee.hasMoreElements()) {
                        key4 = (String)ee.nextElement();
                        configPropMap.put(key4, (String)prop.get(key4));
                    }
                }
                catch (Exception key4) {
                    // empty catch block
                }
                try {
                    if (systemName != null && systemName.equals("NPSCAN")) {
                        prop.load(CRAConfigReader.class.getResourceAsStream(NPSCAN_CONFIG + currentDeployment + ".properties"));
                    } else {
                        prop.load(CRAConfigReader.class.getResourceAsStream(CRA_CONFIG + currentDeployment + ".properties"));
                    }
                    ee = prop.keys();
                    while (ee.hasMoreElements()) {
                        key4 = (String)ee.nextElement();
                        configPropMap.put(key4, (String)prop.get(key4));
                    }
                }
                catch (Exception key5) {
                    // empty catch block
                }
                try {
                    if (systemName != null && systemName.equals("NPSCAN")) {
                        prop.load(CRAConfigReader.class.getResourceAsStream(NPSCAN_CLIENT + currentDeployment + ".properties"));
                    } else {
                        prop.load(CRAConfigReader.class.getResourceAsStream(CRA_CLIENT + currentDeployment + ".properties"));
                    }
                    ee = prop.keys();
                    while (ee.hasMoreElements()) {
                        key4 = (String)ee.nextElement();
                        configPropMap.put(key4, (String)prop.get(key4));
                    }
                }
                catch (Exception key6) {
                    // empty catch block
                }
                try {
                    prop.load(CRAConfigReader.class.getResourceAsStream(PROPERTIES_ERRORCODES));
                    ee = prop.keys();
                    while (ee.hasMoreElements()) {
                        key4 = (String)ee.nextElement();
                        errorCodePropMap.put(key4, (String)prop.get(key4));
                    }
                }
                catch (Exception exception) {
                }
            }
            catch (IOException iOException) {
                prop.clear();
            }
        }
        finally {
            prop.clear();
        }
    }

    public static HashMap getFTMConfigMap(String fileType) {
        HashMap<String, String> fHM = new HashMap<String, String>();
        Set<String> set = configPropMap.keySet();
        Iterator<String> iter = set.iterator();
        String moduleKey = "FTM." + fileType;
        while (iter.hasNext()) {
            String key = iter.next();
            if (!key.startsWith(moduleKey)) continue;
            String val = configPropMap.get(key);
            try {
                if (val == null) continue;
                fHM.put(key.substring(moduleKey.length() + 1), val);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return fHM;
    }

    public static String getConfigVal(String key) {
        return configPropMap.get(key);
    }

    public static String getErrorDescription(String errorCode) {
        return errorCodePropMap.get(errorCode);
    }
}

