package com.cra.sim.util;

/*File Name   : UnorganizedSubscriberRecordMaker.java
 *Created on  : 29th December 2008
 *Created for : Unorganized Sector
 *Created By  : Arun Selvam
 *CMS No.	  : 2088
 *Description : This new class will be called only if the File Transaction Type is 'U'.
 				For Organized sector(with File Transaction Type 'R') SubscriberRecordMaker 
 				class will be called.
 *Note		  : This file is created only for UNORGANIZED SECTOR. */

import com.cra.sim.vo.RecordVO;
import com.cra.sim.vo.SubscriberVO;

public class UnorganizedSubscriberRecordMaker extends RecordMaker {
	 private String rec;
	 private SubscriberVO recDtl = null;
	 private int currPos;
	
	public  RecordVO prepareRecord(String record) {
		// TODO Auto-generated method stub
		
		recDtl = new SubscriberVO();
		rec = record;
		currPos = 0;
		int count=1;
		
		while(rec.substring(currPos).indexOf("^")>=0){
			String data = extractColoumn();
			setColoumn(count,data);
			count++;
		}
		
		String data = rec.substring(currPos).trim();
		setColoumn(count,data);
		
		return recDtl;
	
	}
	
	private String extractColoumn(){
		String coloumn = "";
		int end = rec.indexOf("^",currPos);
		coloumn = rec.substring(currPos,end).trim();
		currPos = end + 1;
		return coloumn;
	}
	
	private void setColoumn(int coloumnNum , String coloumn){
		try{
			switch(coloumnNum){
		    case 1 : // recDtl.setLineSeqNum(Long.parseLong(coloumn));
		    		  	break;
			case 2 : // recDtl.setFileSectionType(coloumn);
					  	break;
			case 3 :    recDtl.setErrorCode(coloumn) ;
						break;
			case 4 :   	recDtl.setRecordNum(coloumn);
				       	break;
			case 5 :    recDtl.setAckNo(coloumn);
						recDtl.setAckPart1(recDtl.getAckNo().substring(0,11));
						recDtl.setAckPart2(recDtl.getAckNo().substring(11,17));
						break;
			
			case 7 :	recDtl.setFirstName(coloumn);
						break;
				
			
			case 6 :	//String title = Codes.getValue("TITLE "+coloumn);
						recDtl.setTitle(coloumn);
			      		break;
			case 8  :   recDtl.setLastName(coloumn);	
						break; 		 	
			case 9 :  	recDtl.setMiddleName(coloumn);
						break;
			case 10 :	recDtl.setFthrFstNm(coloumn);
			      		break;
			case 11 :	recDtl.setFthrLstNm(coloumn);
			      		break;
			case 12 :	recDtl.setFthrMdlNml(coloumn);
			      		break;
			case 13	:   recDtl.setPaoId(coloumn);
						break;
			case 14 :	recDtl.setDdoId(coloumn);
      					break;
			case 15 :	String sex = VUSubsRegPropertiesReader.getValue("SEX "+coloumn);
						recDtl.setGender(sex);
			      		break;
			case 16 :	//Changing MMDDYYYY to DD-MM-YYYY
						String dob = coloumn.substring(2,4)+"-"+coloumn.substring(0,2)+"-"+coloumn.substring(4);
						recDtl.setDob(dob);	
			      		break;
			case 17 :	recDtl.setPan(coloumn);
			      		break;	
			case 18 :	recDtl.setCurrAddr1(coloumn);
			      		break;
			case 19 :   recDtl.setCurrAddr2(coloumn);
			      		break;
			case 20 :	recDtl.setCurrAddr3(coloumn);
			      		break;
			case 21 :  	recDtl.setCurrAddr4(coloumn);
			      		break;
			case 22 :	String state = VUSubsRegPropertiesReader.getValue("STATE "+coloumn);
						recDtl.setCurrState(state);
			      		break;
			case 23 :	String cntry = VUSubsRegPropertiesReader.getValue("COUNTRY "+coloumn);
						recDtl.setCurrCountry(cntry);
			      		break;
			case 24 :	recDtl.setCurrPin(coloumn);
			      		break;
			case 25 :	recDtl.setPermanentAddr1(coloumn);
				      	break;
			case 26 :	recDtl.setPermanentAddr2(coloumn);
				      	break;
			case 27 :	recDtl.setPermanentAddr3(coloumn);	
				      	break;
			case 28 :	recDtl.setPermanentAddr4(coloumn);
				      	break;
			case 29 :	String permState = VUSubsRegPropertiesReader.getValue("STATE "+coloumn);
						recDtl.setPermanentAddrState(permState);
				      	break;
			case 30 :   String permCntry = VUSubsRegPropertiesReader.getValue("COUNTRY "+coloumn);
						recDtl.setPermanentAddrCountry(permCntry);
						break;
			case 31 :   recDtl.setPermanentAddrPin(coloumn);
						break;
			case 32	:   recDtl.setLandlineNum(coloumn);
						break;
			case 33	:   recDtl.setMobNum(coloumn);
						break;
			case 34	:   recDtl.setFaxNum(coloumn);
						break;			
			case 35	:   recDtl.setEmail(coloumn);
						break;
			//case 34	:   recDtl.setAddrCommunicationFlag(coloumn);
			//			break;
			case 36	:   recDtl.setSmsSubscrbFlag(coloumn);
						break;
			case 37	:   recDtl.setEmailSubscrbFlag(coloumn);
			  			break;
			case 38	:   //Changing MMDDYYYY to DD-MM-YYYY
						if((coloumn != null) && !(coloumn.equalsIgnoreCase(""))){
						String doj = coloumn.substring(2,4)+"-"+coloumn.substring(0,2)+"-"+coloumn.substring(4);
						recDtl.setDoj(doj);
						}
						break;
			case 39	:   //Changing MMDDYYYY to DD-MM-YYYY
						if((coloumn != null) && !(coloumn.equalsIgnoreCase(""))){
						String dor = coloumn.substring(2,4)+"-"+coloumn.substring(0,2)+"-"+coloumn.substring(4);
						recDtl.setDateOfRetirement(dor);
						}
						break;			
			//case 40	:   recDtl.setDesignation(coloumn);
			//			break;			
			case 40	:   recDtl.setEmpClass(coloumn);
						break;			
			case 41	:   recDtl.setDep(coloumn);
						break;			
			case 42	:   recDtl.setMinistry(coloumn);
						break;
			case 43 :   recDtl.setDdoOffice(coloumn);
						break;
			case 44	:   recDtl.setPayScale(coloumn);
						break;			
			case 45	:   recDtl.setBasicSal(coloumn);
						break;			
			//case 45	:   recDtl.setNonPracAllowance(coloumn);
			//			break;	
			//case 46	:   recDtl.setDearnessPay(coloumn);
			//			break;			
			//case 47	:   recDtl.setDearnessAllowance(coloumn);
			//			break;			
			case 46	:   recDtl.setPpanNum(coloumn);
						break;	
			case 47	:	recDtl.setInCompBankFlag(coloumn);
						break;
			case 48	:   recDtl.setBankAcctType(coloumn);
						break;			
			case 49	:   recDtl.setBankAccnt(coloumn);
						break;			
			case 50	:   recDtl.setBankName(coloumn);
						break;			
			case 51	:   recDtl.setBankBranch(coloumn);
						break;			
			case 52	:   recDtl.setBankAddr(coloumn);
						break;			
			case 53	:   recDtl.setBankAddrPin(coloumn);
						break;			
			case 54	:   recDtl.setBankMICR(coloumn);
						break;	
			case 55 :   recDtl.setNumOfNominees(coloumn);
          				break;
			case 56 :  	recDtl.setNumOfSchemes(coloumn);
						break;	
			case 57 :	String subOccupation = VUSubsRegPropertiesReader.getValue("OCCUPATION "+coloumn);
						recDtl.setSubscriberOccupation(subOccupation);
						break;
			case 58 :	recDtl.setKycVerfFlag(coloumn);
						break;
			case 59 :	recDtl.setPanVerfFlag(coloumn);
						break;
			case 60 :	recDtl.setSipFlag(coloumn);
						break;
			case 61	:	recDtl.setFcPrvsnlAckNum(coloumn);
						break;
			case 62	:	recDtl.setMotherFstName(coloumn);
						break;
			case 63	:	recDtl.setMotherLstName(coloumn);
						break;
			case 64	:	recDtl.setMotherMdlName(coloumn);
						break;
			case 65 :   break;
			case 66 :	break;
			case 67 :	break;
			case 68 :	break;
			case 69 :	break;
			case 70 : 	break;
			case 71	:	break;
			case 72 :	recDtl.setBankIFSCode(coloumn);						
						VULogger.FvuLog.info("recDTL.getIFSC:"+recDtl.getBankIFSCode());
						break;
			case 73 :	break;
			case 74 :	break;
			case 75	:   recDtl.setPhoto(coloumn);
						break;			
			case 76	:   recDtl.setSig(coloumn);
						break;			
			case 77	:   recDtl.setFvuRecLevelHash(coloumn);
						break;	
			default : 	VULogger.FvuLog.info("Subscriber Record Invalid");
			}
		}catch(Exception e){
			VULogger.FvuLog.info("Subscriber Record Invalid" + e);
		}
	}


}
