package com.cra.sim.gui;

/*File Name   : UnorganizedRecordVerifier.java
 *Created on  : 29th December 2008
 *Created for : Unorganized Sector
 *Created By  : Arun Selvam
 *CMS No.	  : 2088
 *Description : This new class will be called only if the File Transaction Type is 'U'.
 				For Organized sector(with File Transaction Type 'R') RecordVerifier
 				class will be called.
 *Note		  : This file is created only for UNORGANIZED SECTOR. */


import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JOptionPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

import com.cra.sim.gui.RecordVerifier.ackVerifier;
import com.cra.sim.util.DocumentSizeFilter;
import com.cra.sim.util.FileProcessor;
import com.cra.sim.util.VULogger;
import com.cra.sim.util.PranRecordMaker;
import com.cra.sim.util.VUSubsRegPropertiesReader;
import com.cra.sim.vo.FileVO;
import com.cra.sim.vo.PranRecordVO;

public class UnorganizedRecordVerifier extends JFrame{


    public final static int MAXPRANRECORDS=50;
	private FileVO fileDtl;
	private String ackPart2Val= "";
	private ImageIcon photoIcon = null;
	private PranRecordMaker recMaker = null;
	private PranRecordVO pranRecords[] = new PranRecordVO[MAXPRANRECORDS];
	private ImageIcon sigIcon = null;
	private Verifier prevFrame = null;
	private int pranRecIndex=0; 
    private final static int ACKPART2SZIE =6;
  
    //class to verify length of Text of act part two
    class ackVerifier extends InputVerifier{
		public boolean verify(JComponent input) {
			JTextField jtf = (JTextField) input;
			String ack2 = jtf.getText().trim();
			if(ack2.length()== ACKPART2SZIE){
				return true;
			}
			//System.out.println("ack2 length : "+ ack2.length());
			//jtf.setText("");
		return false;
		}
    	
    }
//Main Outer Panel
	private JPanel          jPanelMain  = null;
	private JPanel 			jPanelOuter = null;
	private JScrollPane     jScrollPaneOuter =null;
	private JLabel 			jLabelRecNum = null;
	private JLabel 			jLabelRecNumVal = null;
//	File Details Panel labels,text etc
	private JPanel 			jPanelfileDetails = null;
	private JLabel 			jLabelfileName = null;
	private JTextField 		jtfFileNm = null;
	private JLabel 			jLabelFileType = null;
	private JTextField 		jtfFileType = null;
	private JLabel 			jLabelDateOfCrt = null;
	private JTextField 		jtfCreatnDate = null;
	private JLabel 			jLabelVerRec = null;
	private JTextField 		jtfVerRec = null;
	private JLabel 			jLabelTranType = null;
	private JTextField 		jtfTranType = null;
	private JLabel 			jLabelFvuVer = null;
	private JTextField 		jtfFvuVer = null;
	private JLabel 			jLabelNumOfPranRec = null;
	private JTextField 		jtfNumPranRec = null;
	private JLabel 			jLabelToBeVerRec = null;
	private JTextField 		jtfToBeVerRec = null;
	private JLabel 			jLabelRecStatus = null;
	private JTextField 		jtfRecStatus = null;
	
	//Subscriber Details Main Outer Panel
	private JPanel jPanelSubscrDetails = null;
	
	//Subcriber Record Ack Details Panel and Labels , Texts
	private JPanel 		jPanelAckDetails = null;
	private JLabel 		jLabelAckNum = null;
	private JLabel 		jLabelAckPart1 = null;
	private JFormattedTextField	jtfAckPart2 = null;
	private JLabel 		jLabelDdoId = null;
	private JLabel 		jLabelPaoId = null;
	private JTextField 	jtfPaoId = null;
	
	//Subscriber Photo and Signature Display Panel	
	private javax.swing.JButton jButtonZoom = null;
	private javax.swing.JSplitPane jSplitPanePhotoSign = null;
	private JLabel jLabelPhoto = null;
	private JLabel jLabelSign = null;
	

	//Subscriber Personal Details Labels Texts
	private JPanel jPanelSubsPersnlDetails = null;
	private JLabel 		jLabelTitle = null;
	private JTextField 	jtfTitle = null;
	private JLabel 		jLabelLastName = null;
	private JTextField 	jtfLastName = null;
	private JLabel 		jLabelFirstName = null;
	private JTextField 	jtfFirstName = null;
	private JLabel 		jLabelMdlName = null;
	private JTextField 	jtfMdlName = null;
	private JLabel 		jLabelDob = null;
	private JTextField 	jtfDob = null;
	private JLabel 		jLabelSex = null;
	private JTextField 	jtfSex = null;
	private JLabel 		jLabelPan = null;
	private JTextField 	jtfPan = null;
	
	//Subscriber Father Details Panel
	private JPanel 		jPanelFatherDetails = null;
	private JLabel 		jLabelFthrLstNm = null;
	private JTextField 	jtfFthrLstNm = null;
	private JLabel 		jLabelFthrFstNm = null;
	private JTextField 	jtfFthrFstNm = null;
	private JLabel 		jLabelFthrMdNm = null;
	private JTextField 	jtfFthrMdlNm = null;
	
	//Subscriber Correspondence Address Panel
	private JPanel 		jPanelCorrsAddr = null;
	private JLabel 		jLabelAddrLn1 = null;
	private JTextField 	jtfAddrLn1 = null;
	private JLabel 		jLabelAddrLn2 = null;
	private JTextField 	jtfAddrLn2 = null;
	private JLabel 		jLabelAddrLn3 = null;
	private JTextField 	jtfAddrLn3 = null;
	private JLabel 		jLabelAddrLn4 = null;
	private JTextField 	jtfAddrLn4 = null;
	private JLabel 		jLabelState = null;
	private JTextField 	jtfState = null;
	private JLabel 		jLabelCountry = null;
	private JTextField 	jtfCountry = null;
	private JLabel 		jLabelPin = null;
	private JTextField 	jtfPin = null;
	
	//Subcriber Employment Details Panel
	private JPanel		jPanelOtherDetails;
	private JLabel 		jLabelSubOccptn = null;
	private JTextField 	jtfSubOccptn = null;
	private JLabel 		jLabelKYCVerfFlag = null;
	private JTextField 	jtfKYCVerfFlag = null;
	private JLabel 		jLabelPANVerfFlag = null;
	private JTextField 	jtfPANVerfFlag = null;
	private JLabel 		jLabelSIPFlag = null;
	private JTextField 	jtfSIPFlag = null;

	// Subcriber Bank Details  Panel
	private JPanel		jPanelBankDtls;
	private JLabel 		jLabelAcctNum = null;
	private JTextField 	jtfAcctNum = null;
	private JLabel 		jLabelAcctType = null;
	private JTextField 	jtfAcctType = null;
	private JLabel 		jLabelBankMICR = null;
	private JTextField 	jtfBankMICR = null;
	private JLabel 		jLabelBankIFS = null;
	private JTextField	jtfBankIFS = null;
	private JLabel 		jLabelBankNm = null;
	private JTextField 	jtfBankNm = null;
	private JLabel 		jLabelBankBrch = null;
	private JTextField 	jtfBankBrch= null;
	private JLabel 		jLabelBankAddr = null;
	private JTextField 	jtfBankAddr = null;
	private JLabel 		jLabelBankPin = null;
	private JTextField 	jtfBankPin = null;

	// Subcriber Nominee Details Pop up Button
	private javax.swing.JButton jButtonNomineePopUp = null;
	
	
	// Subscriber Scheme Details Panel
	private JPanel 		jPanelSchDtls = null;
	private JLabel 		jLabelPfmid = null;
	private JTextField 	jtfPfmid = null;
	private JLabel 		jLabelSchId = null;
	private JTextField 	jtfSchId = null;
	private JLabel 		jLabelSchPrnt = null;
	private JTextField 	jtfSchIdPrnt = null;
	private javax.swing.JButton jButtonNextSch = null;
	private javax.swing.JButton jButtonPreviousSch = null;
	
	// Navigation Panel
	private JPanel jPanelNavigation = null;
	private javax.swing.JButton jButtonVerify = null;
	private javax.swing.JButton jButtonNext = null;
	private javax.swing.JButton jButtonPrevious = null;
	private javax.swing.JButton jButtonExit = null;
	
	
	
	/**
	 * This is the default constructor which will be initiated from Verifier.java when the file
	 * transaction type is 'U'.
	 */
	public UnorganizedRecordVerifier(FileVO fdl,Verifier verf,GraphicsConfiguration gc) {
		super(gc);
		if(fdl != null)
			fileDtl = fdl;
		if(verf != null)
			prevFrame = verf;
		String fileType = fileDtl.getFileType();

				if(fileType.equalsIgnoreCase("PRAN")){
					//Populate All Pran records in Array
					for(int index=0;index<fileDtl.getNumOfPranApplication();index++ ){
					recMaker = new PranRecordMaker(fdl);
					setPranRecords(index,(PranRecordVO)recMaker.prepareRecord(fileDtl.getRecord()));
					}
				}
					initialize();

	}
	/**
	 * This method initializes this
	 */
	private void initialize() {
		getJPanelMain();
		getJScrollPaneOuter();
		jPanelMain.setPreferredSize(new Dimension(1125,825));
		jPanelMain.setLayout(new BorderLayout());
		jPanelMain.add(jScrollPaneOuter,BorderLayout.CENTER);
		this.setContentPane(jPanelMain);;
		this.setSize(1125, 750);
		this.setLocation(10,10);
		this.setTitle("Pran Record Displayer "+VUSubsRegPropertiesReader.getValue("VERSION "+"VER"));
		this.setDefaultCloseOperation(javax.swing.JFrame.EXIT_ON_CLOSE);
		startProcess();
		//jtfAckPart2.requestFocus();
		this.setVisible(true);
	}
	private void startProcess()
	{
		setFileDtls();
		setRecDtls(getPranRecIndex());

	}
	private JPanel getJPanelMain() {
		if(jPanelMain == null){
			jPanelMain = new JPanel();
		}
		return jPanelMain;
	}
	/**
	 * This method initializes jContentPane
	 *
	 * @return JPanel
	 */
	
	private JPanel getJPanelOuter() {
		if (jPanelOuter == null) {
			jPanelOuter = new JPanel();
			jPanelOuter.setLayout(null);
			jPanelOuter.add(getJPanelfileDetails(), null);
			jPanelOuter.add(getJPanelSubscrDetails(), null);
			jPanelOuter.add(getJPanelNavigation(), null);
			jPanelOuter.add(getJLabelRecNum(), null);
			jPanelOuter.add(getJLabelRecNumVal(), null);
			jPanelOuter.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, null, null));
			jPanelOuter.setPreferredSize( new Dimension(1125,800));
		}
		return jPanelOuter;
	}
	/**
	 * This method initializes jPanel
	 *
	 * @return JPanel
	 */
		private JPanel getJPanelfileDetails() {
		if(jPanelfileDetails == null) {
			jPanelfileDetails = new JPanel();
			
			jPanelfileDetails.setLayout(null);
			
			jPanelfileDetails.add(getJLabelfileName(), null);
			//JScrollPane jScrollPane1 = new JScrollPane(getJtaFileNm(),JScrollPane.VERTICAL_SCROLLBAR_NEVER,JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
			//jScrollPane1.setBounds(78,19,224,35);
			jPanelfileDetails.add(getJtfFileNm(), null);
			
			jPanelfileDetails.add(getJLabelFileType(), null);
			jPanelfileDetails.add(getJtfFileType(), null);
			
			jPanelfileDetails.add(getJLabelDateOfCrt(), null);
			jPanelfileDetails.add(getJtfCreatnDt(), null);
			
			//jPanelfileDetails.add(getJLabelAgentId(), null);
			//jPanelfileDetails.add(getJtfAgentID(), null);
			
			jPanelfileDetails.add(getJLabelVerRec(), null);
			jPanelfileDetails.add(getJtfVerRec(), null);
			
			jPanelfileDetails.add(getJLabelTranType(), null);
			jPanelfileDetails.add(getTranType(), null);
			
			//jPanelfileDetails.add(getJLabelPRN(),null);
			//jPanelfileDetails.add(getJtfPRN(),null);
			
			jPanelfileDetails.add(getJLabelFvuVer(), null);
			jPanelfileDetails.add(getJtfFvuVer(), null);
			
			jPanelfileDetails.add(getJLabelNumOfPranRec(), null);
			jPanelfileDetails.add(getJtfNumPranRec(), null);

			jPanelfileDetails.add(getJLabelToBeVerRec(), null);
			jPanelfileDetails.add(getJtfToBeVerRec(), null);
		
			jPanelfileDetails.add(getJLabelRecStatus(), null);
			jPanelfileDetails.add(getJtfRecStatus(), null);
			
			jPanelfileDetails.setBounds(9, 24,1100 , 84);
			jPanelfileDetails.setName("fileDtlPanel");
			jPanelfileDetails.setBorder(javax.swing.BorderFactory.createTitledBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.LOWERED), "File Details", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.TOP, new java.awt.Font("Dialog", java.awt.Font.BOLD, 12), new java.awt.Color(102,102,153)));
		
		}
		return jPanelfileDetails;
	}
	/**
	 * This method initializes jLabel
	 *
	 * @return JLabel
	 */
	private JLabel getJLabelfileName() {
		if(jLabelfileName == null) {
			jLabelfileName = new JLabel();
			jLabelfileName.setBounds(18, 19, 60, 21);
			jLabelfileName.setText("FileName");
		}
		return jLabelfileName;
	}
	/**
	 * This method initializes jtfFileNm
	 *
	 * @return JTextField
	 */
/*
	private JTextArea getJtaFileNm() {
		if(jtaFileNm == null) {
			jtaFileNm = new JTextArea(1,50);
			jtaFileNm.setSize(224, 15);
			jtaFileNm.setName("fileName");
			jtaFileNm.setLocation(78, 19);
			jtaFileNm.setEditable(false);
			jtaFileNm.setAlignmentY(JTextArea.LEFT_ALIGNMENT);
			jtaFileNm.setAutoscrolls(true);
			jtaFileNm.setWrapStyleWord(true);
		//jtaFileNm.add(new JScrollBar(JScrollBar.HORIZONTAL));
		}
		return jtaFileNm;
	}*/
	
	private JTextField getJtfFileNm() {
		if(jtfFileNm == null) {
			jtfFileNm = new JTextField();
			jtfFileNm.setSize(224, 21);
			jtfFileNm.setName("fileName");
			jtfFileNm.setLocation(78, 19);
			jtfFileNm.setEditable(false);
			jtfFileNm.setAlignmentY(JTextField.LEFT_ALIGNMENT);
			//jtfFileNm.setAutoscrolls(true);
			//jtfFileNm.setWrapStyleWord(true);
		//jtaFileNm.add(new JScrollBar(JScrollBar.HORIZONTAL));
		}
		return jtfFileNm;
	}
	
	/**
	 * This method initializes jLabel1
	 *
	 * @return JLabel
	 */
	private JLabel getJLabelFileType() {
		if(jLabelFileType == null) {
			jLabelFileType = new JLabel();
			jLabelFileType.setSize(52, 21);
			jLabelFileType.setText("FileType");
			jLabelFileType.setLocation(321, 19);
		}
		return jLabelFileType;
	}
	/**
	 * This method initializes jtfFileType
	 *
	 * @return JTextField
	 */
	private JTextField getJtfFileType() {
		if(jtfFileType == null) {
			jtfFileType = new JTextField();
			jtfFileType.setSize(80, 21);
			jtfFileType.setName("fileType");
			jtfFileType.setLocation(372, 19);
			jtfFileType.setPreferredSize(new java.awt.Dimension(4,19));
			jtfFileType.setEditable(false);
		}
		return jtfFileType;
	}
	/**
	 * This method initializes jLabel2
	 *
	 * @return JLabel
	 */
	private JLabel getJLabelDateOfCrt() {
		if(jLabelDateOfCrt == null) {
			jLabelDateOfCrt = new JLabel();
			jLabelDateOfCrt.setSize(107, 21);
			jLabelDateOfCrt.setText("Date of Creation");
			jLabelDateOfCrt.setLocation(470, 19);
		}
		return jLabelDateOfCrt;
	}
	/**
	 * This method initializes jtfCreatnDate
	 *
	 * @return JTextField
	 */
	private JTextField getJtfCreatnDt() {
		if(jtfCreatnDate == null) {
			jtfCreatnDate = new JTextField();
			jtfCreatnDate.setSize(111, 21);
			jtfCreatnDate.setLocation(580, 19);
			jtfCreatnDate.setEditable(false);
			jtfCreatnDate.setName("creatnDt");
		}
		return jtfCreatnDate;
	}
	
	/**
	 * This method initializes jLabel7
	 *
	 * @return JLabel
	 */
	private JLabel getJLabelVerRec() {
		if(jLabelVerRec == null) {
			jLabelVerRec = new JLabel();
			jLabelVerRec.setSize(109, 21);
			jLabelVerRec.setText("Records Verified");
			jLabelVerRec.setLocation(470, 50);
		}
		return jLabelVerRec;
	}
	
	/**
	 * This method initializes jtfVerRec
	 *
	 * @return JTextField
	 */
	private JTextField getJtfVerRec() {
		if(jtfVerRec == null) {
			jtfVerRec = new JTextField();
			jtfVerRec.setSize(42, 21);
			jtfVerRec.setLocation(580, 50);
			jtfVerRec.setEditable(false);
			jtfVerRec.setName("verRec");
		}
		return jtfVerRec;
	}

	/**
	 * This method initializes jLabel4
	 *
	 * @return JLabel
	 */
	private JLabel getJLabelTranType() {
		if(jLabelTranType == null) {
			jLabelTranType = new JLabel();
			jLabelTranType.setSize(60, 21);
			jLabelTranType.setText("TranType");
			jLabelTranType.setLocation(715, 19);
			//jLabelTranType.setLocation(18, 50);
		}
		return jLabelTranType;
	}
	
	/**
	 * This method initializes jtfUploadType
	 *
	 * @return JTextField
	 */
	private JTextField getTranType() {
		if(jtfTranType == null) {
			jtfTranType = new JTextField();
			jtfTranType.setSize(100, 21);
			//jtfTranType.setLocation(78, 50);
			jtfTranType.setLocation(780, 19);
			jtfTranType.setName("TranType");
			jtfTranType.setEditable(false);
		}
		return jtfTranType;
	}
	
		
	/**
	 * This method initializes jLabel5
	 *
	 * @return JLabel
	 */
	private JLabel getJLabelFvuVer() {
		if(jLabelFvuVer == null) {
			jLabelFvuVer = new JLabel();
			jLabelFvuVer.setSize(79, 21);
			jLabelFvuVer.setText("FVU Version");
			jLabelFvuVer.setLocation(900, 19);
		}
		return jLabelFvuVer;
	}
	
	/**
	 * This method initializes jtfFvuVer
	 *
	 * @return JTextField
	 */
	private JTextField getJtfFvuVer() {
		if(jtfFvuVer == null) {
			jtfFvuVer = new JTextField();
			jtfFvuVer.setSize(45, 21);
			jtfFvuVer.setLocation(990, 19);
			jtfFvuVer.setName("Fvuversion");
			jtfFvuVer.setEditable(false);
		}
		return jtfFvuVer;
	}
	
	/**
	 * This method initializes jLabel6
	 *
	 * @return JLabel
	 */
	private JLabel getJLabelNumOfPranRec() {
		if(jLabelNumOfPranRec == null) {
			jLabelNumOfPranRec = new JLabel();
			jLabelNumOfPranRec.setSize(120, 21);
			jLabelNumOfPranRec.setText("Number Of Records");
			jLabelNumOfPranRec.setLocation(18, 50);
		}
		return jLabelNumOfPranRec;
	}
	
	/**
	 * This method initializes sex
	 *
	 * @return JTextField
	 */
	private JTextField getJtfNumPranRec() {
		if(jtfNumPranRec == null) {
			jtfNumPranRec = new JTextField();
			jtfNumPranRec.setSize(41, 21);
			
			//jtfNumPranRec.setLocation(640, 50);
			jtfNumPranRec.setLocation(150, 50);
			jtfNumPranRec.setEditable(false);
			jtfNumPranRec.setName("numOfPranRec");
		}
		return jtfNumPranRec;
	}

	/**
	 * This method initializes jLabel8
	 *
	 * @return JLabel
	 */
	private JLabel getJLabelToBeVerRec() {
		if(jLabelToBeVerRec == null) {
			jLabelToBeVerRec = new JLabel();
			jLabelToBeVerRec.setBounds(240, 50, 137, 20);
			jLabelToBeVerRec.setText("Records To Be Verified");
		}
		return jLabelToBeVerRec;
	}
	
	/**
	 * This method initializes jtfToBeVerRec
	 *
	 * @return JTextField
	 */
	private JTextField getJtfToBeVerRec() {
		if(jtfToBeVerRec == null) {
			jtfToBeVerRec = new JTextField();
			//jtfToBeVerRec.setBounds(850, 51, 41, 20);
			jtfToBeVerRec.setBounds(372, 50, 41, 20);
			jtfToBeVerRec.setEditable(false);
		}
		return jtfToBeVerRec;
	}
	
	/**
	 * This method initializes jPanel1
	 *
	 * @return JPanel
	 */
	private JPanel getJPanelSubscrDetails() {
		if(jPanelSubscrDetails == null) {
			jPanelSubscrDetails = new JPanel();
			jPanelSubscrDetails.setLayout(null);
			jPanelSubscrDetails.add(getJPanelAckDetails(), null);
			jPanelSubscrDetails.add(getJButtonZoom(), null);
			jPanelSubscrDetails.add(getJSplitPanePhotoSign(), null);
			jPanelSubscrDetails.add(getJPanelSubsPersnlDetails(), null);
			jPanelSubscrDetails.add(getJPanelCorrsAddr(), null);
			jPanelSubscrDetails.add(getJPanelOtherDetails(),null);
			jPanelSubscrDetails.add(getJPanelBankDtls(),null);
			jPanelSubscrDetails.add(getJButtonNomineePopUp(),null);
			jPanelSubscrDetails.add(getJPanelSchDtls(), null);
			jPanelSubscrDetails.setBounds(11, 113, 1100, 640);
			jPanelSubscrDetails.setBorder(javax.swing.BorderFactory.createTitledBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.LOWERED), "Subscriber Details", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", java.awt.Font.BOLD, 12), new java.awt.Color(102,102,153)));
		}
		return jPanelSubscrDetails;
	}
	
	/**
	 * This method initializes jPanelAckDetails
	 *
	 * @return JPanel
	 */
	private JPanel getJPanelAckDetails() {
		if(jPanelAckDetails == null) {
			jPanelAckDetails = new JPanel();
			jPanelAckDetails.setLayout(null);
			jPanelAckDetails.add(getJLabelAckNum(), null);
			jPanelAckDetails.add(getJLabelAckPart1(), null);
			jPanelAckDetails.add(getJtfAckPart2(), null);
			jPanelAckDetails.add(getJLabelPaoId(), null);
			jPanelAckDetails.add(getJtfPaoId(), null);
			jPanelAckDetails.setBounds(15, 22, 700, 40);
		}
		return jPanelAckDetails;
	}
	
	private JLabel getJLabelAckNum() {
		if(jLabelAckNum == null)
		 {
			jLabelAckNum = new JLabel();
			jLabelAckNum.setBounds(14, 13, 88, 21);
			jLabelAckNum.setText("Ack Number");
		}
		return jLabelAckNum;
	}
	
	/**
	 * This method initializes ackPart1
	 *
	 * @return JLabel
	 */
	private JLabel getJLabelAckPart1() {
		if(jLabelAckPart1 == null) {
			jLabelAckPart1 = new JLabel();
			jLabelAckPart1.setBounds(93, 13, 88, 21);
			jLabelAckPart1.setText("");
		}
		return jLabelAckPart1;
	}
	
	/**
	 * This method initializes ackPart2
	 *
	 * @return JTextField
	 */
	private JFormattedTextField getJtfAckPart2() {
		if(jtfAckPart2 == null) {
			jtfAckPart2 = new JFormattedTextField();
			jtfAckPart2.setSize(45, 21);
			jtfAckPart2.setLocation(185, 13);
			jtfAckPart2.setEditable(true);
			jtfAckPart2.setVerifyInputWhenFocusTarget(true);
			jtfAckPart2.setInputVerifier(new ackVerifier());
			DefaultStyledDocument doc = new DefaultStyledDocument();
			doc.setDocumentFilter(new DocumentSizeFilter(ACKPART2SZIE));
			jtfAckPart2.setDocument(doc);
			jtfAckPart2.setToolTipText("Enter last 6-digits of Acknowledgement no of current PRAN application");
			jtfAckPart2.requestFocus();
		}
		return jtfAckPart2;
	}
	
	/**
	 * This method initializes jLabel10
	 *
	 * @return JLabel
	 */
	private JLabel getJLabelDdoId() {
		if(jLabelDdoId == null) {
			jLabelDdoId = new JLabel();
			jLabelDdoId.setSize(80, 21);
			jLabelDdoId.setText("DDO Reg. No.");
			jLabelDdoId.setLocation(260, 13);
		}
		return jLabelDdoId;
	}

	
	/*
	 * This method initialises the JLabel for PaoId
	 * @return JLabel
	 * 
	 * */
	private JLabel getJLabelPaoId() {
		if(jLabelPaoId == null) {
			jLabelPaoId = new JLabel();
			jLabelPaoId.setSize(100, 21);
			jLabelPaoId.setText("POP-SP Reg. No.");
			jLabelPaoId.setLocation(450, 13);
		}
		return jLabelPaoId;
	}

	/**
	 * This method initializes pan
	 *
	 * @return JTextField
	 */
	private JTextField getJtfPaoId() {
		if(jtfPaoId == null) {
			jtfPaoId = new JTextField();
			jtfPaoId.setSize(132, 21);
			jtfPaoId.setLocation(561, 13);
			jtfPaoId.setEditable(false);
		}
		return jtfPaoId;
	}
	
	/**
	 * This method initializes jLabel14
	 *
	 * @return JLabel
	 */
	private JLabel getJLabelRecStatus() {
		if(jLabelRecStatus == null) {
			jLabelRecStatus = new JLabel();
			jLabelRecStatus.setSize(140, 21);
			jLabelRecStatus.setText("Current Record Status");
			jLabelRecStatus.setLocation(715, 51);
		}
		return jLabelRecStatus;
	}
	
	/**
	 * This method initializes recStatus
	 *
	 * @return JTextField
	 */
	private JTextField getJtfRecStatus() {
		if(jtfRecStatus == null) {
			jtfRecStatus = new JTextField();
			jtfRecStatus.setSize(97, 21);
			jtfRecStatus.setLocation(850, 51);
			jtfRecStatus.setEditable(false);
			
		}
		return jtfRecStatus;
	}
	
	/**
	 * This method initializes jButton
	 *
	 * @return javax.swing.JButton
	 */
	private javax.swing.JButton getJButtonZoom() {
		if(jButtonZoom == null) {
			jButtonZoom = new javax.swing.JButton();
			jButtonZoom.setBounds(850, 23, 236, 20);
			jButtonZoom.setText("ZOOM");
			jButtonZoom.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					
					PhotoSig photoSig = new PhotoSig();
					photoSig.enableInputMethods(true);
					photoSig.showPhotoSig(photoIcon,sigIcon);

				}
			});
		}
		return jButtonZoom;
	}	
	
	/**
	 * This method initializes jSplitPane
	 *
	 * @return javax.swing.JSplitPane
	 */
	private javax.swing.JSplitPane getJSplitPanePhotoSign() {
		if(jSplitPanePhotoSign == null) {
			jSplitPanePhotoSign = new javax.swing.JSplitPane();
			jSplitPanePhotoSign.setTopComponent(getJLabelPhoto());
			jSplitPanePhotoSign.setBottomComponent(getJLabelSign());
			jSplitPanePhotoSign.setBounds(850, 43, 238, 310);
			jSplitPanePhotoSign.setComponentOrientation(java.awt.ComponentOrientation.LEFT_TO_RIGHT);
			jSplitPanePhotoSign.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);
			jSplitPanePhotoSign.setDividerLocation(220);
			jSplitPanePhotoSign.setDividerSize(7);
		}
		return jSplitPanePhotoSign;
	}
	
	/**
	 * This method initializes photoLabel
	 *
	 * @return JLabel
	 */
	private JLabel getJLabelPhoto() {
		if(jLabelPhoto == null) {
			jLabelPhoto = new JLabel();
			jLabelPhoto.setText("");
		}
		return jLabelPhoto;
	}
	
	/**
	 * This method initializes sigLabel
	 *
	 * @return JLabel
	 */
	private JLabel getJLabelSign() {
		if(jLabelSign == null) {
			jLabelSign = new JLabel();
			jLabelSign.setText("");
		}
		return jLabelSign;
	}

	
	/**
	 * This method initializes jPanel3
	 *
	 * @return JPanel
	 */
	private JPanel getJPanelSubsPersnlDetails() {
		if(jPanelSubsPersnlDetails == null) {
			jPanelSubsPersnlDetails = new JPanel();
			jPanelSubsPersnlDetails.setLayout(null);
			jPanelSubsPersnlDetails.add(getJLabelTitle(), null);
			jPanelSubsPersnlDetails.add(getJtfTitle(),null);
			jPanelSubsPersnlDetails.add(getJLabelLastName(), null);
			jPanelSubsPersnlDetails.add(getJtfLastName(), null);
			jPanelSubsPersnlDetails.add(getJLabelFirstName(), null);
			jPanelSubsPersnlDetails.add(getJtfFirstName(), null);
			jPanelSubsPersnlDetails.add(getJLabelMdlName(), null);
			jPanelSubsPersnlDetails.add(getJtfMdlName(), null);
			jPanelSubsPersnlDetails.add(getJLabelDob(),null);
			jPanelSubsPersnlDetails.add(getJtfDob(),null);
			jPanelSubsPersnlDetails.add(getJLabelSex(),null);
			jPanelSubsPersnlDetails.add(getJtfSex(),null);
			jPanelSubsPersnlDetails.add(getJLabelPan(),null);
			jPanelSubsPersnlDetails.add(getJtfPan(),null);
			jPanelSubsPersnlDetails.add(getJPanelFatherDetails(),null);
			jPanelSubsPersnlDetails.setBounds(14, 60, 825, 150);
			jPanelSubsPersnlDetails.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Personal Details", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION,new java.awt.Font("Dialog", java.awt.Font.BOLD, 12), new java.awt.Color(102,102,153)));
		}
		return jPanelSubsPersnlDetails;
	}	
	
	/**
	 * This method initializes jLabel11
	 *
	 * @return JLabel
	 */
	private JLabel getJLabelTitle() {
		if(jLabelTitle == null) {
			jLabelTitle = new JLabel();
			jLabelTitle.setSize(36, 21);
			jLabelTitle.setText("Title");
			jLabelTitle.setLocation(10, 24);
		}
		return jLabelTitle;
	}
	
	/**
	 * This method initializes title
	 *
	 * @return JTextField
	 */
	private JTextField getJtfTitle() {
		if(jtfTitle == null) {
			jtfTitle = new JTextField();
			jtfTitle.setSize(72, 21);
			jtfTitle.setLocation(46, 24);
			jtfTitle.setEditable(false);
		}
		return jtfTitle;
	}
	
	/**
	 * This method initializes jLabel16
	 *
	 * @return JLabel
	 */
	private JLabel getJLabelLastName() {
		if(jLabelLastName == null) {
			jLabelLastName = new JLabel();
			jLabelLastName.setSize(64, 21);
			jLabelLastName.setText("Last Name");
			jLabelLastName.setLocation(140, 24);
		}
		return jLabelLastName;
	}
	
	/**
	 * This method initializes lstNm
	 *
	 * @return JTextField
	 */
	private JTextField getJtfLastName() {
		if(jtfLastName == null) {
			jtfLastName = new JTextField();
			jtfLastName.setSize(150, 21);
			jtfLastName.setLocation(210, 24);
			jtfLastName.setEditable(false);
		}
		return jtfLastName;
	}
	
	/**
	 * This method initializes jLabel17
	 *
	 * @return JLabel
	 */
	private JLabel getJLabelFirstName() {
		if(jLabelFirstName == null) {
			jLabelFirstName = new JLabel();
			jLabelFirstName.setSize(72, 21);
			jLabelFirstName.setText("First Name");
			jLabelFirstName.setLocation(380, 24);
		}
		return jLabelFirstName;
	}
	
	/**
	 * This method initializes fstNm
	 *
	 * @return JTextField
	 */
	private JTextField getJtfFirstName() {
		if(jtfFirstName == null) {
			jtfFirstName = new JTextField();
			jtfFirstName.setSize(133, 21);
			jtfFirstName.setLocation(470, 24);
			jtfFirstName.setEditable(false);
		}
		return jtfFirstName;
	}

	/**
	 * This method initializes jLabel18
	 *
	 * @return JLabel
	 */
	private JLabel getJLabelMdlName() {
		if(jLabelMdlName == null) {
			jLabelMdlName = new JLabel();
			jLabelMdlName.setSize(80, 21);
			jLabelMdlName.setText("Middle Name");
			jLabelMdlName.setLocation(620, 24);
		}
		return jLabelMdlName;
	}

	/**
	 * This method initializes mdlNm
	 *
	 * @return JTextField
	 */
	private JTextField getJtfMdlName() {
		if(jtfMdlName == null) {
			jtfMdlName = new JTextField();
			jtfMdlName.setSize(117, 21);
			jtfMdlName.setLocation(700, 24);
			jtfMdlName.setEditable(false);
		}
		return jtfMdlName;
	}
	
	private JLabel getJLabelDob() {
		if(jLabelDob == null) {
			jLabelDob = new JLabel();
			jLabelDob = new JLabel();
			jLabelDob.setSize(89, 21);
			jLabelDob.setText("Date of Birth");
			jLabelDob.setLocation(10, 54);
		}
		return jLabelDob;
	}
	
	 
	private JTextField getJtfDob() {
		if(jtfDob == null) {
			jtfDob = new JTextField();
			jtfDob.setSize(114, 21);
			jtfDob.setLocation(100, 54);
			jtfDob.setEditable(false);
		}
		return jtfDob;
	}

	private JLabel getJLabelSex() {
		if(jLabelSex == null) {
			jLabelSex = new JLabel();
			jLabelSex.setSize(48, 21);
			jLabelSex.setText("Sex");
			jLabelSex.setLocation(380, 54);
		}
		return jLabelSex;
	}
	
	private JTextField getJtfSex() {
		if(jtfSex == null) {
			jtfSex = new JTextField();
			jtfSex.setSize(90, 21);
			jtfSex.setLocation(460, 54);
			jtfSex.setEditable(false);
		}
		return jtfSex;
	}
	private JLabel getJLabelPan() {
		if(jLabelPan == null) {
			jLabelPan = new JLabel();
			jLabelPan.setSize(48, 21);
			jLabelPan.setText("Pan");
			jLabelPan.setLocation(620, 54);
		}
		return jLabelPan;
	}
	
	private JTextField getJtfPan() {
		if(jtfPan == null) {
			jtfPan = new JTextField();
			jtfPan.setSize(117, 21);
			jtfPan.setLocation(700, 54);
			jtfPan.setEditable(false);
		}
		return jtfPan;
	}
	
	/**
	 * This method initializes jPanel2
	 *
	 * @return JPanel
	 */
	private JPanel getJPanelFatherDetails() {
		if(jPanelFatherDetails == null) {
			jPanelFatherDetails = new JPanel();
			jPanelFatherDetails.setLayout(null);
			jPanelFatherDetails.add(getJLabelFthrLstNm(), null);
			jPanelFatherDetails.add(getJtfFthrLstNm(), null);
			jPanelFatherDetails.add(getJLabelFthrFstNm(), null);
			jPanelFatherDetails.add(getJtfFthrFstNm(), null);
			jPanelFatherDetails.add(getJLabelFthrMdNm(), null);
			jPanelFatherDetails.add(getJTextField122(), null);
			jPanelFatherDetails.setBounds(20,85, 665, 49);
			jPanelFatherDetails.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Father's Name", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, null, null));
		}
		return jPanelFatherDetails;
	}
	
	/**
	 * This method initializes jLabel20
	 *
	 * @return JLabel
	 */
	private JLabel getJLabelFthrLstNm() {
		if(jLabelFthrLstNm == null) {
			jLabelFthrLstNm = new JLabel();
			jLabelFthrLstNm.setSize(72, 21);
			jLabelFthrLstNm.setText("Last Name");
			jLabelFthrLstNm.setLocation(13, 19);
		}
		return jLabelFthrLstNm;
	}
	
	/**
	 * This method initializes fthrLstNm
	 *
	 * @return JTextField
	 */
	private JTextField getJtfFthrLstNm() {
		if(jtfFthrLstNm == null) {
			jtfFthrLstNm = new JTextField();
			jtfFthrLstNm.setSize(117, 21);
			jtfFthrLstNm.setLocation(86, 20);
			jtfFthrLstNm.setEditable(false);
		}
		return jtfFthrLstNm;
	}
	
	/**
	 * This method initializes jLabel21
	 *
	 * @return JLabel
	 */
	private JLabel getJLabelFthrFstNm() {
		if(jLabelFthrFstNm == null) {
			jLabelFthrFstNm = new JLabel();
			jLabelFthrFstNm.setSize(69, 21);
			jLabelFthrFstNm.setText("First Name");
			jLabelFthrFstNm.setLocation(219, 19);
		}
		return jLabelFthrFstNm;
	}
	
	/**
	 * This method initializes fthrFstNm
	 *
	 * @return JTextField
	 */
	private JTextField getJtfFthrFstNm() {
		if(jtfFthrFstNm == null) {
			jtfFthrFstNm = new JTextField();
			jtfFthrFstNm.setSize(136, 21);
			jtfFthrFstNm.setLocation(289, 19);
			jtfFthrFstNm.setEditable(false);
		}
		return jtfFthrFstNm;
	}
	
	/**
	 * This method initializes jLabel22
	 *
	 * @return JLabel
	 */
	private JLabel getJLabelFthrMdNm() {
		if(jLabelFthrMdNm == null) {
			jLabelFthrMdNm = new JLabel();
			jLabelFthrMdNm.setSize(79, 21);
			jLabelFthrMdNm.setText("Middle Name");
			jLabelFthrMdNm.setLocation(458, 20);
		}
		return jLabelFthrMdNm;
	}
	
	/**
	 * This method initializes fthrMdlNm
	 *
	 * @return JTextField
	 */
	private JTextField getJTextField122() {
		if(jtfFthrMdlNm == null) {
			jtfFthrMdlNm = new JTextField();
			jtfFthrMdlNm.setSize(107, 21);
			jtfFthrMdlNm.setLocation(537, 19);
			jtfFthrMdlNm.setEditable(false);
		}
		return jtfFthrMdlNm;
	}
	
	/**
	 * This method initializes jPanel4
	 *
	 * @return JPanel
	 */
	private JPanel getJPanelCorrsAddr() {
		if(jPanelCorrsAddr == null) {
			jPanelCorrsAddr = new JPanel();
			jPanelCorrsAddr.setLayout(null);
			jPanelCorrsAddr.add(getJLabelAddrLn1(), null);
			jPanelCorrsAddr.add(getJtfAddrLn1(), null);
			jPanelCorrsAddr.add(getJLabelAddrLn2(), null);
			jPanelCorrsAddr.add(getJtfAddrLn2(), null);
			jPanelCorrsAddr.add(getJLabelAddrLn3(), null);
			jPanelCorrsAddr.add(getJtfAddrLn3(), null);
			jPanelCorrsAddr.add(getJLabelAddrLn4(), null);
			jPanelCorrsAddr.add(getJtfAddrLn4(), null);
			jPanelCorrsAddr.add(getJLabelCountry(), null);
			jPanelCorrsAddr.add(getJtfCountry(), null);
			jPanelCorrsAddr.add(getJLabelState(), null);
			jPanelCorrsAddr.add(getTextFieldState(), null);
			jPanelCorrsAddr.add(getJLabelPin(), null);
			jPanelCorrsAddr.add(getJtfPin(), null);
			jPanelCorrsAddr.setBounds(11, 210, 825, 150);
			jPanelCorrsAddr.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Present address", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", java.awt.Font.BOLD, 12), new java.awt.Color(102,102,153)));
		}
		return jPanelCorrsAddr;
	}
	
	/**
	 * This method initializes jLabel24
	 *
	 * @return JLabel
	 */
	private JLabel getJLabelAddrLn1() {
		if(jLabelAddrLn1 == null) {
			jLabelAddrLn1 = new JLabel();
			jLabelAddrLn1.setSize(80, 21);
			jLabelAddrLn1.setText("Address 1");
			jLabelAddrLn1.setLocation(19, 24);
		}
		return jLabelAddrLn1;
	}
	
	/**
	 * This method initializes addr1
	 *
	 * @return JTextField
	 */
	private JTextField getJtfAddrLn1() {
		if(jtfAddrLn1 == null) {
			jtfAddrLn1 = new JTextField();
			jtfAddrLn1.setSize(300, 21);
			jtfAddrLn1.setLocation(101, 24);
			jtfAddrLn1.setEditable(false);
		}
		return jtfAddrLn1;
	}
	
	/**
	 * This method initializes jLabel25
	 *
	 * @return JLabel
	 */
	private JLabel getJLabelAddrLn2() {
		if(jLabelAddrLn2 == null) {
			jLabelAddrLn2 = new JLabel();
			jLabelAddrLn2.setSize(76, 21);
			jLabelAddrLn2.setText("Address 2");
			jLabelAddrLn2.setLocation(420, 24);
		}
		return jLabelAddrLn2;
	}
	
	/**
	 * This method initializes addr2
	 *
	 * @return JTextField
	 */
	private JTextField getJtfAddrLn2() {
		if(jtfAddrLn2 == null) {
			jtfAddrLn2 = new JTextField();
			jtfAddrLn2.setSize(300, 21);
			jtfAddrLn2.setLocation(490, 24);
			jtfAddrLn2.setEditable(false);
		}
		return jtfAddrLn2;
	}
	
	/**
	 * This method initializes jLabel26
	 *
	 * @return JLabel
	 */
	private JLabel getJLabelAddrLn3() {
		if(jLabelAddrLn3 == null) {
			jLabelAddrLn3 = new JLabel();
			jLabelAddrLn3.setSize(77, 21);
			jLabelAddrLn3.setText("Address 3");
			jLabelAddrLn3.setLocation(19, 51);
		}
		return jLabelAddrLn3;
	}
	
	/**
	 * This method initializes addr3
	 *
	 * @return JTextField
	 */
	private JTextField getJtfAddrLn3() {
		if(jtfAddrLn3 == null) {
			jtfAddrLn3 = new JTextField();
			jtfAddrLn3.setSize(300, 21);
			jtfAddrLn3.setLocation(101, 51);
			jtfAddrLn3.setEditable(false);
		}
		return jtfAddrLn3;
	}
	
	/**
	 * This method initializes jLabel27
	 *
	 * @return JLabel
	 */
	private JLabel getJLabelAddrLn4() {
		if(jLabelAddrLn4 == null) {
			jLabelAddrLn4 = new JLabel();
			jLabelAddrLn4.setSize(73, 21);
			jLabelAddrLn4.setText("Address 4");
			jLabelAddrLn4.setLocation(420, 51);
		}
		return jLabelAddrLn4;
	}
	
	/**
	 * This method initializes addr4
	 *
	 * @return JTextField
	 */
	private JTextField getJtfAddrLn4() {
		if(jtfAddrLn4 == null) {
			jtfAddrLn4 = new JTextField();
			jtfAddrLn4.setSize(300, 21);
			jtfAddrLn4.setLocation(490, 51);
			jtfAddrLn4.setEditable(false);
		}
		return jtfAddrLn4;
	}
	
	/**
	 * This method initializes jLabel29
	 *
	 * @return JLabel
	 */
	private JLabel getJLabelState() {
		if(jLabelState == null) {
			jLabelState = new JLabel();
			jLabelState.setSize(130, 21);
			jLabelState.setText("State / Union Territory");
			jLabelState.setLocation(19, 80);
		}
		return jLabelState;
	}

	private JTextField getTextFieldState() {
			if(jtfState == null) {
				jtfState = new JTextField();
				jtfState.setSize(239, 21);
				jtfState.setLocation(162, 80);
				jtfState.setEditable(false);
			}
			return jtfState;

		}
	
	/**
	 * This method initializes jLabel28
	 *
	 * @return JLabel
	 */
	private JLabel getJLabelCountry() {
		if(jLabelCountry == null) {
			jLabelCountry = new JLabel();
			jLabelCountry.setSize(72, 21);
			jLabelCountry.setText("Country");
			jLabelCountry.setLocation(19, 108);
		}
		return jLabelCountry;
	}
	
	/**
	 * This method initializes addr5
	 *
	 * @return JTextField
	 */
	private JTextField getJtfCountry() {
		if(jtfCountry == null) {
			jtfCountry = new JTextField();
			jtfCountry.setSize(239, 21);
			jtfCountry.setLocation(101, 108);
			jtfCountry.setEditable(false);
		}
		return jtfCountry;
	}
	
	private JLabel getJLabelPin() {
		if(jLabelPin == null) {
			jLabelPin = new JLabel();
			jLabelPin.setSize(72, 21);
			jLabelPin.setText("Pin Code");
			jLabelPin.setLocation(420, 108);
		}
		return jLabelPin;
	}
	
	/**
	 * This method initializes pin
	 *
	 * @return JTextField
	 */
	private JTextField getJtfPin() {
		if(jtfPin == null) {
			jtfPin = new JTextField();
			jtfPin.setSize(182, 21);
			jtfPin.setLocation(480, 108);
			jtfPin.setEditable(false);
		}
		return jtfPin;
	}
	
	private JPanel getJPanelOtherDetails() {
		if(jPanelOtherDetails == null) {
			jPanelOtherDetails = new JPanel();
			jPanelOtherDetails.setLayout(null);
			jPanelOtherDetails.add(getJLabelSubscriberOccupation(), null);
			jPanelOtherDetails.add(getJtfSubscriberOccupation(),null);
			jPanelOtherDetails.add(getJLabelKYCVerfFlag(), null);
			jPanelOtherDetails.add(getJtfKYCVerfFlag(), null);
			jPanelOtherDetails.add(getJLabelPANVerfFlag(), null);
			jPanelOtherDetails.add(getJtfPANVerfFlag(), null);
			jPanelOtherDetails.add(getJLabelSIPFlag(), null);
			jPanelOtherDetails.add(getJtfSIPFlag(), null);
			jPanelOtherDetails.setBounds(11,375, 825, 80);
			jPanelOtherDetails.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Other Details", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION,new java.awt.Font("Dialog", java.awt.Font.BOLD, 12), new java.awt.Color(102,102,153)));
		}
		return jPanelOtherDetails;
	}
	
	private JLabel getJLabelSubscriberOccupation() {
		if(jLabelSubOccptn == null) {
			jLabelSubOccptn = new JLabel();
			jLabelSubOccptn.setSize(100, 21);
			jLabelSubOccptn.setText("Occupation");
			jLabelSubOccptn.setLocation(10, 24);
		}
		return jLabelSubOccptn;
	}
	
	private JTextField getJtfSubscriberOccupation() {
		if(jtfSubOccptn== null) {
			jtfSubOccptn = new JTextField();
			//jtfSubOccptn.setSize(52, 21);  //Commented for changes in Subscriber Occupation - UOS - CMS 2088 - VU Version 1.4
			//jtfSubOccptn.setSize(100, 21); //Commented for changes in Subscriber Occupation - UOS - CMS 3336 - VU Version 1.5
			jtfSubOccptn.setSize(135, 21);
			jtfSubOccptn.setLocation(120, 24);
			jtfSubOccptn.setEditable(false);
		}
		return jtfSubOccptn;
	}
	
		
	private JLabel getJLabelKYCVerfFlag() {
		if(jLabelKYCVerfFlag == null) {
			jLabelKYCVerfFlag = new JLabel();
			jLabelKYCVerfFlag.setSize(100, 21);
			jLabelKYCVerfFlag.setText("KYC Flag");
			jLabelKYCVerfFlag.setLocation(460, 24);
		}
		return jLabelKYCVerfFlag;
	}
	
	private JTextField getJtfKYCVerfFlag() {
		if(jtfKYCVerfFlag== null) {
			jtfKYCVerfFlag = new JTextField();
			jtfKYCVerfFlag.setSize(52, 21);
			jtfKYCVerfFlag.setLocation(530, 24);
			jtfKYCVerfFlag.setEditable(false);
		}
		return jtfKYCVerfFlag;
	}
	
	private JLabel getJLabelPANVerfFlag() {
		if(jLabelPANVerfFlag == null) {
			jLabelPANVerfFlag = new JLabel();
			jLabelPANVerfFlag.setSize(60, 21);
			jLabelPANVerfFlag.setText("PAN Flag");
			jLabelPANVerfFlag.setLocation(10, 51);
		}
		return jLabelPANVerfFlag;
	}
	
	private JTextField getJtfPANVerfFlag() {
		if(jtfPANVerfFlag== null) {
			jtfPANVerfFlag = new JTextField();
			jtfPANVerfFlag.setSize(52, 21);
			jtfPANVerfFlag.setLocation(120, 51);
			jtfPANVerfFlag.setEditable(false);
		}
		return jtfPANVerfFlag;
	}
	
			
	private JLabel getJLabelSIPFlag() {
		if(jLabelSIPFlag == null) {
			jLabelSIPFlag = new JLabel();
			jLabelSIPFlag.setSize(100, 21);
			jLabelSIPFlag.setText("SIP Flag");
			jLabelSIPFlag.setLocation(460, 51);
		}
		return jLabelSIPFlag;
	}
	
	private JTextField getJtfSIPFlag() {
		if(jtfSIPFlag== null) {
			jtfSIPFlag = new JTextField();
			jtfSIPFlag.setSize(52, 21);
			jtfSIPFlag.setLocation(530, 51);
			jtfSIPFlag.setEditable(false);
		}
		return jtfSIPFlag;
	}
	

	private JPanel getJPanelBankDtls() {
		if(jPanelBankDtls == null) {
			jPanelBankDtls = new JPanel();
			jPanelBankDtls.setLayout(null);
			jPanelBankDtls.add(getJLabelAcctNum(), null);
			jPanelBankDtls.add(getJtfAcctNum(),null);
			jPanelBankDtls.add(getJLabelAcctType(), null);
			jPanelBankDtls.add(getJtfAcctType(),null);
			jPanelBankDtls.add(getJLabelBankMICR(), null);
			jPanelBankDtls.add(getJtfBankMICR(),null);
			jPanelBankDtls.add(getJLabelBankIFS(), null);
			jPanelBankDtls.add(getJtfBankIFS(),null);	
			jPanelBankDtls.add(getJLabelBankNm(), null);
			jPanelBankDtls.add(getJtfBankNm(),null);
			jPanelBankDtls.add(getJLabelBankBrch(), null);
			jPanelBankDtls.add(getJtfBankBrch(),null);
			jPanelBankDtls.add(getJLabelBankAddr(), null);
			jPanelBankDtls.add(getJtfBankAddr(),null);
			jPanelBankDtls.add(getJLabelBankPin(), null);
			jPanelBankDtls.add(getJtfBankPin(),null);
			jPanelBankDtls.setBounds(14,470 , 825, 155);
			jPanelBankDtls.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Bank Details", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION,new java.awt.Font("Dialog", java.awt.Font.BOLD, 12), new java.awt.Color(102,102,153)));
		}
		return jPanelBankDtls;
	}
	
	private JLabel getJLabelAcctNum() {
		if(jLabelAcctNum == null) {
			jLabelAcctNum = new JLabel();
			jLabelAcctNum.setSize(80, 21);
			jLabelAcctNum.setText("Bank A/C");
			jLabelAcctNum.setLocation(10, 24);
			jLabelAcctNum.setHorizontalAlignment(SwingConstants.LEFT);
		}
		return jLabelAcctNum;
	}
	
	private JTextField getJtfAcctNum() {
		if(jtfAcctNum== null) {
			jtfAcctNum = new JTextField();
			jtfAcctNum.setSize(180, 21);
			jtfAcctNum.setLocation(120, 24);
			jtfAcctNum.setEditable(false);
		}
		return jtfAcctNum;
	}
	
	private JLabel getJLabelAcctType() {
		if(jLabelAcctType == null) {
			jLabelAcctType = new JLabel();
			jLabelAcctType.setSize(110, 21);
			jLabelAcctType.setText("Bank A/C Type");
			jLabelAcctType.setLocation(470, 24);
		}
		return jLabelAcctType;
	}
	
	private JTextField getJtfAcctType() {
		if(jtfAcctType== null) {
			jtfAcctType = new JTextField();
			jtfAcctType.setSize(100, 21);
			jtfAcctType.setLocation(580, 24);
			jtfAcctType.setEditable(false);
		}
		return jtfAcctType;
	}
	
	private JLabel getJLabelBankMICR() {
		
		if(jLabelBankMICR == null) {
			
			jLabelBankMICR = new JLabel();
			jLabelBankMICR.setSize(75, 21);
			jLabelBankMICR.setText("MICR Code");			
			//jLabelBankMICR.setLocation(590, 24);
			jLabelBankMICR.setLocation(10, 57);
		}
		return jLabelBankMICR;
	}
	
	
	
	private JTextField getJtfBankMICR() {
		if(jtfBankMICR== null) {
			jtfBankMICR = new JTextField();
			jtfBankMICR.setSize(80, 21);
			//jtfBankMICR.setLocation(680, 24);
			jtfBankMICR.setLocation(120, 57);
			jtfBankMICR.setEditable(false);
		}
		return jtfBankMICR;
	}
	
	private JLabel getJLabelBankIFS() {
		if(jLabelBankIFS == null) {
			jLabelBankIFS = new JLabel();
			jLabelBankIFS.setSize(75, 21);
			jLabelBankIFS.setText("IFS Code");
			jLabelBankIFS.setLocation(470, 57);
		}
		return jLabelBankIFS;
	}
	
	private JTextField getJtfBankIFS() {
		if(jtfBankIFS== null) {
			jtfBankIFS = new JTextField();
			jtfBankIFS.setSize(200, 21);			
			//jtfBankIFS.setLocation(120, 37);
			jtfBankIFS.setLocation(580, 57);
			jtfBankIFS.setEditable(false);
		}
		return jtfBankIFS;
	}
	
	private JLabel getJLabelBankNm() {
		if(jLabelBankNm == null) {
			jLabelBankNm = new JLabel();
			jLabelBankNm.setSize(100, 21);
			jLabelBankNm.setText("Bank Name");
			jLabelBankNm.setLocation(10, 91);
		}
		return jLabelBankNm;
	}
	
	private JTextField getJtfBankNm() {
		if(jtfBankNm== null) {
			jtfBankNm = new JTextField();
			jtfBankNm.setSize(300, 21);
			jtfBankNm.setLocation(120, 91);
			jtfBankNm.setEditable(false);
		}
		return jtfBankNm;
	}
	
	private JLabel getJLabelBankBrch() {
		if(jLabelBankBrch == null) {
			jLabelBankBrch = new JLabel();
			jLabelBankBrch.setSize(100, 21);
			jLabelBankBrch.setText("Branch");
			jLabelBankBrch.setLocation(470, 91);
		}
		return jLabelBankBrch;
	}
	
	private JTextField getJtfBankBrch() {
		if(jtfBankBrch== null) {
			jtfBankBrch = new JTextField();
			jtfBankBrch.setSize(200, 21);
			jtfBankBrch.setLocation(580, 91);
			jtfBankBrch.setEditable(false);
		}
		return jtfBankBrch;
	}
	
	private JLabel getJLabelBankAddr() {
		if(jLabelBankAddr == null) {
			jLabelBankAddr = new JLabel();
			jLabelBankAddr.setSize(120, 21);
			jLabelBankAddr.setText("Address");
			jLabelBankAddr.setLocation(10, 125);
		}
		return jLabelBankAddr;
	}

	private JTextField getJtfBankAddr() {
		if(jtfBankAddr== null) {
			jtfBankAddr = new JTextField();
			jtfBankAddr.setSize(300, 21);
			jtfBankAddr.setLocation(120, 125);
			jtfBankAddr.setEditable(false);
		}
		return jtfBankAddr;
	}
	
	private JLabel getJLabelBankPin() {
		if(jLabelBankPin == null) {
			jLabelBankPin = new JLabel();
			jLabelBankPin.setSize(70, 21);
			jLabelBankPin.setText("Pin Code");
			jLabelBankPin.setLocation(470, 125);
		}
		return jLabelBankPin;
	}
	
	private JTextField getJtfBankPin() {
		if(jtfBankPin== null) {
			jtfBankPin = new JTextField();
			jtfBankPin.setSize(100, 21);
			jtfBankPin.setLocation(580, 125);
			jtfBankPin.setEditable(false);
		}
		return jtfBankPin;
	}
	
	private javax.swing.JButton getJButtonNomineePopUp() {
		if(jButtonNomineePopUp== null) {
			jButtonNomineePopUp = new javax.swing.JButton();
			jButtonNomineePopUp.setBounds(850,360, 236, 30);
			jButtonNomineePopUp.setText("Nominee Details");
			jButtonNomineePopUp.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					
					PranRecordVO recDtl = getPranRecords(getPranRecIndex());
					if(recDtl != null){
						NomineePopUp nomPop= new NomineePopUp();
						nomPop.showNomineeDtls(recDtl.getNominee(),recDtl.getSubsRec().getNumOfNominees());
					}
					
				}
			});
		}
		
		return jButtonNomineePopUp;
	}
	
	/**
	 * This method initializes jPanel5
	 *
	 * @return JPanel
	 */
	private JPanel getJPanelSchDtls() {
		if(jPanelSchDtls == null) {
			jPanelSchDtls = new JPanel();
			jPanelSchDtls.setLayout(null);
			jPanelSchDtls.add(getJLabelPfmid(), null);
			jPanelSchDtls.add(getJtfPfmid(), null);
			jPanelSchDtls.add(getJLabelSchId(), null);
			jPanelSchDtls.add(getJtfSchId(),null);
			jPanelSchDtls.add(getJLabelSchPrnt(),null);
			jPanelSchDtls.add(getJtfSchIdPrnt(),null);
			jPanelSchDtls.add(getJButtonPreviousSch(),null);
			jPanelSchDtls.add(getJButtonNextSch(),null);
			jPanelSchDtls.setBounds(850, 390, 235, 200);
			jPanelSchDtls.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Scheme Details", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", java.awt.Font.BOLD, 12), new java.awt.Color(102,102,153)));
		}
		return jPanelSchDtls;
	}
	
	/**
	 * This method initializes jLabel31
	 *
	 * @return JLabel
	 */
	private JLabel getJLabelPfmid() {
		if(jLabelPfmid == null) {
			jLabelPfmid = new JLabel();
			jLabelPfmid.setBounds(14, 16, 120, 20);
			jLabelPfmid.setText("PFM Id");
		}
		return jLabelPfmid;
	}
	
	/**
	 * This method initializes mdFlag
	 *
	 * @return JTextField
	 */
	private JTextField getJtfPfmid() {
		if(jtfPfmid == null) {
			jtfPfmid = new JTextField();
			jtfPfmid.setSize(192, 21);
			jtfPfmid.setLocation(14, 41);
			jtfPfmid.setEditable(false);
		}
		return jtfPfmid;
	}
	
	/**
	 * This method initializes jLabel32
	 *
	 * @return JLabel
	 */
	private JLabel getJLabelSchId() {
		if(jLabelSchId == null) {
			jLabelSchId = new JLabel();
			jLabelSchId.setBounds(16, 66, 90, 21);
			jLabelSchId.setText("Scheme Id");
		}
		return jLabelSchId;
	}
	
	/**
	 * This method initializes proof
	 *
	 * @return JTextField
	 */
	private JTextField getJtfSchId() {
		if(jtfSchId == null) {
			jtfSchId = new JTextField();
			jtfSchId.setSize(190, 21);
			jtfSchId.setEditable(false);
			jtfSchId.setLocation(16, 91);
		}
		return jtfSchId;
	}
	
	private JLabel getJLabelSchPrnt() {
		if(jLabelSchPrnt == null) {
			jLabelSchPrnt = new JLabel();
			jLabelSchPrnt.setSize(90, 21);
			jLabelSchPrnt.setText("Scheme %");
			jLabelSchPrnt.setLocation(16, 116);
		}
		return jLabelSchPrnt;
	}
	
	private JTextField getJtfSchIdPrnt() {
		if(jtfSchIdPrnt== null) {
			jtfSchIdPrnt = new JTextField();
			jtfSchIdPrnt.setSize(192, 21);
			jtfSchIdPrnt.setLocation(16, 141);
			jtfSchIdPrnt.setEditable(false);
		}
		return jtfSchIdPrnt;
	}
	
	private javax.swing.JButton getJButtonPreviousSch() {
		if(jButtonPreviousSch == null) {
			jButtonPreviousSch = new javax.swing.JButton();
			jButtonPreviousSch.setSize(90, 24);
			jButtonPreviousSch.setText("Previous");
			jButtonPreviousSch.setLocation(16, 166);
			jButtonPreviousSch.setEnabled(false);

			jButtonPreviousSch.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					//	for Scheme navigation
					int PranNum = getPranRecIndex();
					PranRecordVO recDtl = getPranRecords(PranNum);
					if(recDtl != null){
						int recNum = recDtl.getCurrSchRecIndex();
						recNum--;
						setSchemeDtls(recNum);
						if(recNum == 0)
							jButtonPreviousSch.setEnabled(false);
						if(recNum == recDtl.getSubsRec().getNumOfSchemes()-2)
							jButtonNextSch.setEnabled(true);
					}
				}
			});
		}
		
		return jButtonPreviousSch;
	}
	
	private javax.swing.JButton getJButtonNextSch() {
		if(jButtonNextSch == null) {
			jButtonNextSch = new javax.swing.JButton();
			jButtonNextSch.setSize(80, 24);
			jButtonNextSch.setText("Next");
			
			int PranNum = getPranRecIndex();
			PranRecordVO recDtl = getPranRecords(PranNum);
			
			if(recDtl !=null && (recDtl.getSubsRec().getNumOfSchemes() == 1 || recDtl.getSubsRec().getNumOfSchemes() == 0))
				jButtonNextSch.setEnabled(false);
			
			jButtonNextSch.setLocation(120,166);
			jButtonNextSch.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					//	for Scheme navigation
					int PranNum = getPranRecIndex();
					PranRecordVO recDtl = getPranRecords(PranNum);
					if(recDtl != null){
						int recNum = recDtl.getCurrSchRecIndex();
						recNum++;
					
						setSchemeDtls(recNum);

						if(recNum == recDtl.getSubsRec().getNumOfSchemes()-1)
							jButtonNextSch.setEnabled(false);
						if(recNum == 1)
							jButtonPreviousSch.setEnabled(true);
					}
				}
			});
		}
		
		return jButtonNextSch;
	}
	
	/**
	 * This method initializes jPanel7
	 *
	 * @return JPanel
	 */
	private JPanel getJPanelNavigation() {
		if(jPanelNavigation == null) {
			jPanelNavigation = new JPanel();
			jPanelNavigation.setLayout(null);
			jPanelNavigation.add(getJButtonVerify(), null);
			jPanelNavigation.add(getJButtonNext(), null);
			jPanelNavigation.add(getJButtonPrevious(), null);
			jPanelNavigation.add(getJButtonExit(), null);
			jPanelNavigation.setBounds(11, 758, 1100, 30);
			jPanelNavigation.setBorder(javax.swing.BorderFactory.createCompoundBorder(javax.swing.BorderFactory.createEtchedBorder(javax.swing.border.EtchedBorder.RAISED), javax.swing.BorderFactory.createEtchedBorder(javax.swing.border.EtchedBorder.LOWERED)));
		}
		return jPanelNavigation;
	}
	
	/**
	 * This method initializes jButtonVerify
	 *
	 * @return javax.swing.JButton
	 */
	private javax.swing.JButton getJButtonVerify() {
		if(jButtonVerify == null) {
			jButtonVerify = new javax.swing.JButton();
			jButtonVerify.setSize(106, 24);
			jButtonVerify.setText("Verify");
			jButtonVerify.setLocation(755, 3);
			if((jtfRecStatus.getText()).equalsIgnoreCase("Verified"))
				jButtonVerify.setEnabled(false);

			jButtonVerify.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
						actionVerify();
				}
			});
		}
		return jButtonVerify;
	}
	
	/**
	 * This method initializes jButtonNext
	 *
	 * @return javax.swing.JButton
	 */
	private javax.swing.JButton getJButtonNext() {
		if(jButtonNext == null) {
			jButtonNext = new javax.swing.JButton();
			jButtonNext.setSize(106, 24);
			jButtonNext.setText("Next");
			
			if(fileDtl.getNumOfPranApplication() == 1)
				jButtonNext.setEnabled(false);
			
			jButtonNext.setLocation(505, 3);
			jButtonNext.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					
					 	// for Subscriber navigation
					int recNum = getPranRecIndex();
					recNum++;
					setPranRecIndex(recNum);
					setRecDtls(recNum);

					if(recNum == fileDtl.getNumOfPranApplication()-1)
						jButtonNext.setEnabled(false);
					if(recNum == 1)
						jButtonPrevious.setEnabled(true);
					jtfAckPart2.requestFocus();
				}
			});
		}
		return jButtonNext;
	}
	
	/**
	 * This method initializes jButtonPrevious
	 *
	 * @return javax.swing.JButton
	 */
	private javax.swing.JButton getJButtonPrevious() {
		if(jButtonPrevious == null) {
			jButtonPrevious = new javax.swing.JButton();
			jButtonPrevious.setSize(106, 24);
			jButtonPrevious.setText("Previous");
			jButtonPrevious.setLocation(279, 3);
			jButtonPrevious.setEnabled(false);

			jButtonPrevious.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					
					int recNum = getPranRecIndex();
					recNum--;
					//fileDtl.setCurrRecordNum(recNum);
					setPranRecIndex(recNum);
					setRecDtls(recNum);

					if(recNum == 0)
						jButtonPrevious.setEnabled(false);
					if(recNum == fileDtl.getNumOfPranApplication()-2)
						jButtonNext.setEnabled(true);
					jtfAckPart2.requestFocus();
				}
			});
		}
		return jButtonPrevious;
	}
	
	/**
	 * This method initializes jButtonExit
	 *
	 * @return javax.swing.JButton
	 */
	private javax.swing.JButton getJButtonExit() {
		if(jButtonExit == null) {
			jButtonExit = new javax.swing.JButton();
			jButtonExit.setBounds(80, 3, 106, 24);
			jButtonExit.setText("Exit");
			jButtonExit.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					actionExit();
				}
			});
		}
		return jButtonExit;
	}
	
	/**
	 * This method initializes proof
	 *
	 * @return JTextField
	 */


	private void setFileDtls()
	{
		
		jtfCreatnDate.setText(fileDtl.getCreationDate());
 		jtfFileNm.setText(fileDtl.getFileName());
		jtfFileType.setText(fileDtl.getFileTypeDetailed());
		jtfTranType.setText(fileDtl.getTranType());
		jtfFvuVer.setText(fileDtl.getFvuVer());
		jtfNumPranRec.setText(""+fileDtl.getNumOfPranApplication());
		jtfVerRec.setText(""+fileDtl.getNumOfVerifiedPranApplications());
		int toBeVer = fileDtl.getNumOfPranApplication() - fileDtl.getNumOfVerifiedPranApplications();
		jtfToBeVerRec.setText(""+toBeVer);
	}

	private void setRecDtls(int recNum)
	{
		PranRecordVO recDtl = getPranRecords(recNum);
		if(recDtl != null){
			fileDtl.setCurrPranRecNum(recNum+1);
			jLabelAckPart1.setText(recDtl.getSubsRec().getAckPart1());
			jtfPaoId.setText(recDtl.getSubsRec().getPaoId());
			jtfRecStatus.setText(recDtl.getSubsRec().getRecStatus());
			jtfTitle.setText(recDtl.getSubsRec().getTitle());
			jtfLastName.setText(recDtl.getSubsRec().getLastName());
			jtfFirstName.setText(recDtl.getSubsRec().getFirstName());
			jtfMdlName.setText(recDtl.getSubsRec().getMiddleName());
			jtfDob.setText(recDtl.getSubsRec().getDob());
			
			jtfSex.setText(recDtl.getSubsRec().getGender());
			jtfPan.setText(recDtl.getSubsRec().getPan());
			jtfFthrLstNm.setText(recDtl.getSubsRec().getFthrLstNm());
			jtfFthrFstNm.setText(recDtl.getSubsRec().getFthrFstNm());
			jtfFthrMdlNm.setText(recDtl.getSubsRec().getFthrMdlNml());
		
		//	if(recDtl.getSubsRec().getAddrCommunicationFlag().equals("C")){
				jtfAddrLn1.setText(recDtl.getSubsRec().getCurrAddr1());
				jtfAddrLn2.setText(recDtl.getSubsRec().getCurrAddr2());
				jtfAddrLn3.setText(recDtl.getSubsRec().getCurrAddr3());
				jtfAddrLn4.setText(recDtl.getSubsRec().getCurrAddr4());
				jtfState.setText(recDtl.getSubsRec().getCurrState());
				jtfCountry.setText(recDtl.getSubsRec().getCurrCountry());
				jtfPin.setText(recDtl.getSubsRec().getCurrPin());
		//	}else{
			/*
				jtfAddrLn1.setText(recDtl.getSubsRec().getPermanentAddr1());
				jtfAddrLn2.setText(recDtl.getSubsRec().getPermanentAddr2());
				jtfAddrLn3.setText(recDtl.getSubsRec().getPermanentAddr3());
				jtfAddrLn4.setText(recDtl.getSubsRec().getPermanentAddr4());
				jtfState.setText(recDtl.getSubsRec().getPermanentAddrState());
				jtfCountry.setText(recDtl.getSubsRec().getPermanentAddrCountry());
				jtfPin.setText(recDtl.getSubsRec().getPermanentAddrPin());
			
			}
		*/
				
			jtfSubOccptn.setText(recDtl.getSubsRec().getSubscriberOccupation());
			jtfKYCVerfFlag.setText(recDtl.getSubsRec().getKycVerfFlag());
			jtfPANVerfFlag.setText(recDtl.getSubsRec().getPanVerfFlag());
			jtfSIPFlag.setText(recDtl.getSubsRec().getSipFlag());
			jtfAcctNum.setText(recDtl.getSubsRec().getBankAccnt());
			jtfAcctType.setText(recDtl.getSubsRec().getBankAcctType());
			jtfBankMICR.setText(recDtl.getSubsRec().getBankMICR());
			
			
			jtfBankIFS.setText(recDtl.getSubsRec().getBankIFSCode());
			
			jtfBankNm.setText(recDtl.getSubsRec().getBankName());
			jtfBankBrch.setText(recDtl.getSubsRec().getBankBranch());
			jtfBankAddr.setText(recDtl.getSubsRec().getBankAddr());
			jtfBankPin.setText(recDtl.getSubsRec().getBankAddrPin());
		
	   
			setSchemeDtls(0);
		


			if(!(recDtl.getSubsRec().getPhoto().equals("")))
			{
				byte[] photo = convertToBytes(recDtl.getSubsRec().getPhoto());
				photoIcon = new ImageIcon(photo);
				jLabelPhoto.setIcon(photoIcon);
				jLabelPhoto.setHorizontalAlignment(SwingConstants.CENTER);
			}

			if(!recDtl.getSubsRec().getSig().equals("")){
				byte[] sig = convertToBytes(recDtl.getSubsRec().getSig());
				sigIcon = new ImageIcon(sig);
				jLabelSign.setIcon(sigIcon);
				jLabelSign.setHorizontalAlignment(SwingConstants.CENTER);

			}




		//Get record number from FileDetails fileDtl
			jLabelRecNumVal.setText(""+(getPranRecIndex()+1));

		//Get record status from FileDetails fileDtl
		//Set ack part2 if file is already verified
			if(fileDtl.isCurrRecVerified()){
				jtfRecStatus.setText("Verified");
				jtfAckPart2.setText(recDtl.getSubsRec().getAckPart2());
				jtfAckPart2.setEditable(false);
			}else{
				jtfRecStatus.setText("Not Verified");
				jtfAckPart2.setText("");
				jtfAckPart2.setEditable(true);
			}
			ackPart2Val = recDtl.getSubsRec().getAckPart2();
		}
	}

private void setSchemeDtls(int rNum){
		PranRecordVO recDtl = getPranRecords(getPranRecIndex());
		if(recDtl != null){
			if(recDtl.getSubsRec().getNumOfSchemes()>0){
					recDtl.setCurrSchRecIndex(rNum);
					if(recDtl.getScheme()!=null){
						//jtfPfmid.setText(recDtl.getScheme().getRecordNum());
						jtfPfmid.setText(recDtl.getScheme().getPfmId());
						jtfSchId.setText(recDtl.getScheme().getSchemeId());
						jtfSchIdPrnt.setText(String.valueOf(recDtl.getScheme().getPercentageOfInvestment()));
					}
					if(rNum == 0){
							jButtonNextSch.setEnabled(true);
							if(recDtl.getSubsRec().getNumOfSchemes() == 1)
									jButtonNextSch.setEnabled(false);
							jButtonPreviousSch.setEnabled(false);
					}
			}else{
				// NO Schemes
				jtfPfmid.setText("");
				jtfSchId.setText("");
				jtfSchIdPrnt.setText("");
				jButtonNextSch.setEnabled(false);
				jButtonPreviousSch.setEnabled(false);
			}
		}
	}
	private byte[] convertToBytes(String str)
	{
		byte res[] = new byte[str.length()/2+1];
		int i;
		String str1 = "" ;
		int cnt = 0;
		for(i=0;i<str.length();i=i+2)
		{
				if(i+1<str.length())
				str1 = str.substring(i,i+2).trim();
				else
				str1 = str.substring(i);
				Integer val = new Integer(Integer.parseInt(str1,16));
				res[cnt] = val.byteValue();
				cnt++;
		}

		return res;
	}

	

	/**
	 * This method initializes jLabel9
	 *
	 * @return JLabel
	 */
	private JLabel getJLabelRecNum() {
		if(jLabelRecNum == null) {
			jLabelRecNum = new JLabel();
			jLabelRecNum.setBounds(12, 3, 103, 18);
			jLabelRecNum.setText("Record Number");
		}
		return jLabelRecNum;
	}
	/**
	 * This method initializes recNumLabel
	 *
	 * @return JLabel
	 */
	private JLabel getJLabelRecNumVal() {
		if(jLabelRecNumVal == null) {
			jLabelRecNumVal = new JLabel();
			jLabelRecNumVal.setSize(40, 18);
			jLabelRecNumVal.setText("JLabel");
			jLabelRecNumVal.setLocation(113, 4);
		}
		return jLabelRecNumVal;
	}


	private void actionExit()
	{
		if(fileDtl.isFileVerified())
		{

				int i = JOptionPane.showConfirmDialog(this,"Records in the file are verified \n Do you want to prepare verified file","Confirm Exit",JOptionPane.YES_NO_OPTION);
				if(i==JOptionPane.YES_OPTION)
				{
					FileProcessor fp  = new FileProcessor();
				
					long hash = fileDtl.getFileHash();
					if(fp.saveFile(fileDtl.getAbsoluteFileName(),hash)){
						JOptionPane.showMessageDialog(this, "Verified File Prepared successfully","File",JOptionPane.INFORMATION_MESSAGE);
						VULogger.FvuLog.info("File Verified and Saved ");
					}else{
						JOptionPane.showMessageDialog(this,"Errors while preparing file","File",JOptionPane.ERROR_MESSAGE);
						VULogger.FvuLog.info("Error while Saving verified file ");
					}	
				}
				prevFrame.setVisible(true);
				prevFrame.setEnabled(true);
				dispose();
		}

		else
		{
			//confirm "exit without verification"
			int i = JOptionPane.showConfirmDialog(this,"Some of the Records in the file are not yet verified \n Do you want to exit","Confirm",JOptionPane.YES_NO_OPTION);
			if(i==JOptionPane.YES_OPTION)
			{
				VULogger.FvuLog.info("Exit Without Completing Verification");
				prevFrame.setVisible(true);
				prevFrame.setEnabled(true);
				dispose();
			}

		}

	}


	private void actionVerify()
	{
		String ackToVerify = jtfAckPart2.getText().trim();

		if(ackToVerify.equals(""))
		{
			JOptionPane.showMessageDialog(this,"Please enter last 6-digits of the 17-digit Acknowledgement Number for this record","Warning",JOptionPane.INFORMATION_MESSAGE);
			return;
		}
		if(ackToVerify.length()!=6)
		{
			JOptionPane.showMessageDialog(this,"Max digits to be entered is last 6-digits of the 17-digit Acknowledgement Number for this record","Error",JOptionPane.ERROR_MESSAGE);
			jtfAckPart2.setText("");
			return;
		}
		if(ackToVerify.equals(ackPart2Val))
		{
			if(!fileDtl.isCurrRecVerified())
			{
				fileDtl.setRecVerified();
				int noOfVerRec = Integer.parseInt(jtfVerRec.getText());
				noOfVerRec++;
				jtfVerRec.setText(""+noOfVerRec);
				int toBeVer = Integer.parseInt(jtfToBeVerRec.getText());
				toBeVer--;
				jtfToBeVerRec.setText(""+toBeVer);
				jtfRecStatus.setText("Verified");
				int pranNum = getPranRecIndex();
				VULogger.FvuLog.info("Record: "+pranNum+"Verified");
				jtfAckPart2.setEditable(false);
				JOptionPane.showMessageDialog(this,"Record Verified","Message",JOptionPane.INFORMATION_MESSAGE);
				
				if(toBeVer == 0)
				{
					jButtonVerify.setEnabled(false);

					int i = JOptionPane.showConfirmDialog(this,"Records in the file are verified \n Do you want to prepare verified file","Confirm Exit",JOptionPane.YES_NO_OPTION);
					if(i==JOptionPane.YES_OPTION)
					{
						FileProcessor fp  = new FileProcessor();
						
						long hash = fileDtl.getFileHash();
						if(fp.saveFile(fileDtl.getAbsoluteFileName(),hash))
							JOptionPane.showMessageDialog(this, "Verified File Prepared successfully","File",JOptionPane.INFORMATION_MESSAGE);
						else
							JOptionPane.showMessageDialog(this,"Errors while preparing file","File",JOptionPane.ERROR_MESSAGE);
							
						prevFrame.setVisible(true);
						prevFrame.setEnabled(true);
						dispose();
					}
				}
			}
		}
		else{
			JOptionPane.showMessageDialog(this,"Please enter the correct last 6-digits of Acknowledgement Number for this record","Invalid Ack Number",JOptionPane.INFORMATION_MESSAGE);
			int pranNum = getPranRecIndex();
			VULogger.FvuLog.info("For Record :"+pranNum+" Incorrect Ack Num entered");
			
		}	
	}
	/**
	 * @param pranRecCount The pranRecCount to set.
	 */
	private void setPranRecIndex(int pranRecIndex) {
		this.pranRecIndex = pranRecIndex;
	}
	/**
	 * @return Returns the pranRecCount.
	 */
	private int getPranRecIndex() {
		return pranRecIndex;
	}
	/**
	 * @param pranRecords The pranRecords to set.
	 */
	private void setPranRecords(int index,PranRecordVO pranRecords) {
		this.pranRecords[index] = pranRecords;
	}
	/**
	 * @return Returns the pranRecords.
	 */
	private PranRecordVO getPranRecords(int index) {
		return pranRecords[index];
	}
	private JScrollPane getJScrollPaneOuter() {
		if(jScrollPaneOuter == null){
			jScrollPaneOuter = new JScrollPane(getJPanelOuter());
		}
			return jScrollPaneOuter;
		
	}


}
