/*
 * Decompiled with CFR 0.152.
 */
package com.cra.sim.validator.regn.format;

import com.cra.framework.reg.vo.SessionVO;
import com.cra.sim.util.SIMConstants;
import com.cra.sim.util.SubsRegConst;
import com.cra.sim.util.WriteRecord;
import com.cra.sim.validator.BaseValidator;
import com.cra.sim.vo.TtsDtlsVO;
import java.math.BigDecimal;
import java.util.regex.Pattern;

public class TtsDtlsFormatValidator
extends BaseValidator
implements SIMConstants {
    boolean boolErrCodeFound = false;
    boolean boolBankAccNo = true;
    boolean boolBankName = true;
    private String sectorType;
    private boolean isCORP = false;
    private boolean isOS = false;
    TtsDtlsVO objTtsDtlsVO = new TtsDtlsVO();
    boolean errorRepeat = false;
    String strFileType = "";
    WriteRecord objWRecord = new WriteRecord();

    public TtsDtlsFormatValidator(SessionVO sessVO) {
        super(sessVO);
    }

    public TtsDtlsFormatValidator(SessionVO sessVO, String sectorValue) {
        super(sessVO);
        this.sectorType = sectorValue;
        if (this.sectorType.equalsIgnoreCase("U")) {
            this.isUnorganizedSector = true;
        }
        if (this.sectorType.equalsIgnoreCase("C")) {
            this.isCORP = true;
        }
        if (this.sectorType.equalsIgnoreCase("R")) {
            this.isOS = true;
        }
    }

    @Override
    public String getErrorForm() {
        return "107";
    }

    public TtsDtlsVO validateTtsDtlsFormat(SubsRegConst pcon) {
        this.pcon = pcon;
        int intcarotcnt = 0;
        boolean boolRecFlag = true;
        pcon.setStrErrInRecord("");
        pcon.setIntTtsSchRecNum(0);
        pcon.setIntTtsNomRecNum(0);
        pcon.setIntTtsSchRemain(Integer.parseInt("1"));
        pcon.setIntTtstotSch(Integer.parseInt("1"));
        try {
            int intFieldIndex = 0;
            int intLineStart = 0;
            int intLineEnd = 0;
            this.strFileType = pcon.getFileType();
            while ((intLineEnd = pcon.getFileLine().substring(intLineStart).indexOf("^")) >= 0) {
                ++intcarotcnt;
                intLineStart = intLineStart + intLineEnd + 1;
            }
            int TTS_CARAT_COUNT = 10;
            if (this.isUnorganizedSector) {
                TTS_CARAT_COUNT = 12;
            }
            if (intcarotcnt != TTS_CARAT_COUNT) {
                System.out.println("ERROR:TT carat count error found" + TTS_CARAT_COUNT);
                this.respgen.genHTML(pcon, "Carat Count", "" + intcarotcnt, "107001");
                boolRecFlag = false;
                this.objTtsDtlsVO.setTtsErrorFlag(true);
                return this.objTtsDtlsVO;
            }
            String fieldStr = "";
            boolean boolTempFlag = true;
            intLineEnd = 0;
            intLineStart = 0;
            intFieldIndex = 1;
            boolean boolErrorCodeStopProcess = false;
            while (intLineEnd != -1 && !boolErrorCodeStopProcess) {
                intLineEnd = pcon.getFileLine().substring(intLineStart).indexOf("^");
                if (intLineEnd == -1) {
                    fieldStr = pcon.getFileLine().substring(intLineStart).trim();
                } else {
                    fieldStr = pcon.getFileLine().substring(intLineStart, intLineStart + intLineEnd).trim();
                    intLineStart = intLineStart + intLineEnd + 1;
                }
                switch (intFieldIndex) {
                    case 1: {
                        boolTempFlag = this.valLineNumber(fieldStr, "Line Number", 1);
                        if (!boolTempFlag) {
                            this.objTtsDtlsVO.setLineNum("0");
                            boolRecFlag = false;
                            pcon.setIntSubsLineNum(0);
                            System.out.println("Tts line number error");
                        } else {
                            System.out.println("Tts line number validated");
                            this.objTtsDtlsVO.setLineNum(fieldStr);
                            pcon.setIntSubsLineNum(Integer.parseInt(fieldStr));
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 2: {
                        boolTempFlag = this.valFileSectType(fieldStr, "File Section Type", 2);
                        this.objTtsDtlsVO.setFileSectType(fieldStr);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                            System.out.println("Tts section type error");
                        } else {
                            System.out.println("Tts section type validated");
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 3: {
                        System.out.println("case 3 value = " + fieldStr);
                        String[] sEFErrorCodeArray = new String[4];
                        String[] errorCodeTemp = fieldStr.split("\\,");
                        System.out.println(errorCodeTemp.length);
                        int countOfCommas = fieldStr.length() - fieldStr.replaceAll(",", "").length();
                        if (countOfCommas > 3) {
                            this.respgen.genHTML(pcon, "Error Flag/Code", fieldStr, "107036");
                            boolRecFlag = false;
                            this.boolErrCodeFound = true;
                        } else {
                            System.arraycopy(errorCodeTemp, 0, sEFErrorCodeArray, 0, errorCodeTemp.length);
                            int i = 0;
                            while (i < sEFErrorCodeArray.length) {
                                System.out.println("sEFErrorCodeArray[i]::" + sEFErrorCodeArray[i]);
                                if (sEFErrorCodeArray[i] != null) {
                                    boolTempFlag = this.valErrorFlgCd(sEFErrorCodeArray[i], "Error Flag/Code", 3);
                                }
                                System.out.println("boolTempFlag::" + boolTempFlag);
                                if (!boolTempFlag) {
                                    System.out.println("boolTempFlag1:" + boolTempFlag);
                                    boolRecFlag = false;
                                    this.boolErrCodeFound = true;
                                }
                                ++i;
                            }
                            if (errorCodeTemp.length == 1 && "N".equalsIgnoreCase(errorCodeTemp[0])) {
                                this.objTtsDtlsVO.setErrorFlagCode(sEFErrorCodeArray[0]);
                            } else if (errorCodeTemp.length != 1 || sEFErrorCodeArray[0].startsWith("SEF")) {
                                i = 0;
                                while (i < sEFErrorCodeArray.length) {
                                    System.out.println("sEFErrorCodeArrayi[" + i + "]::" + sEFErrorCodeArray[i]);
                                    int k = i + 1;
                                    while (k < sEFErrorCodeArray.length - 1) {
                                        System.out.println("sEFErrorCodeArrayk[" + k + "]::" + sEFErrorCodeArray[k]);
                                        System.out.println("sEFErrorCodeArrayk[" + i + "]::" + sEFErrorCodeArray[i]);
                                        if (sEFErrorCodeArray[i] != null && sEFErrorCodeArray[k] != null && sEFErrorCodeArray[i].trim().equalsIgnoreCase(sEFErrorCodeArray[k].trim())) {
                                            this.errorRepeat = true;
                                            boolRecFlag = false;
                                            this.boolErrCodeFound = true;
                                            System.out.println("errorRepeat::" + this.errorRepeat);
                                        }
                                        ++k;
                                    }
                                    ++i;
                                }
                                System.out.println("errorRepeat::" + this.errorRepeat);
                                if (this.errorRepeat) {
                                    System.out.println("hello");
                                    this.respgen.genHTML(pcon, "Error Flag/Code", fieldStr, "107037");
                                } else if (!this.errorRepeat) {
                                    if (sEFErrorCodeArray[0] != null && !"".equalsIgnoreCase(sEFErrorCodeArray[0])) {
                                        this.objTtsDtlsVO.setErrorFlagCode1(sEFErrorCodeArray[0].trim());
                                    }
                                    if (sEFErrorCodeArray[1] != null && !"".equalsIgnoreCase(sEFErrorCodeArray[1])) {
                                        this.objTtsDtlsVO.setErrorFlagCode2(sEFErrorCodeArray[1].trim());
                                    }
                                    if (sEFErrorCodeArray[2] != null && !"".equalsIgnoreCase(sEFErrorCodeArray[2])) {
                                        this.objTtsDtlsVO.setErrorFlagCode3(sEFErrorCodeArray[2].trim());
                                    }
                                    if (sEFErrorCodeArray[3] != null && !"".equalsIgnoreCase(sEFErrorCodeArray[3])) {
                                        this.objTtsDtlsVO.setErrorFlagCode4(sEFErrorCodeArray[3].trim());
                                    }
                                }
                                if (fieldStr.length() > 1 && !this.errorRepeat) {
                                    if (sEFErrorCodeArray[0] != null && !"".equalsIgnoreCase(sEFErrorCodeArray[0])) {
                                        String errorCode = sEFErrorCodeArray[0].trim().replace("SEF", "11");
                                        System.out.println("errorCode1--" + errorCode);
                                        System.out.println(sEFErrorCodeArray[0]);
                                        this.respgen.genHTML(pcon, "Error Flag/Code", sEFErrorCodeArray[0].trim(), errorCode);
                                        this.boolErrCodeFound = true;
                                    }
                                    if (sEFErrorCodeArray[1] != null && !"".equalsIgnoreCase(sEFErrorCodeArray[1])) {
                                        String errorCode = sEFErrorCodeArray[1].trim().replace("SEF", "11");
                                        System.out.println("errorCode2--" + errorCode);
                                        this.respgen.genHTML(pcon, "Error Flag/Code", sEFErrorCodeArray[1].trim(), errorCode);
                                        this.boolErrCodeFound = true;
                                    }
                                    if (sEFErrorCodeArray[2] != null && !"".equalsIgnoreCase(sEFErrorCodeArray[2])) {
                                        String errorCode = sEFErrorCodeArray[2].trim().replace("SEF", "11");
                                        System.out.println("errorCode3--" + errorCode);
                                        this.respgen.genHTML(pcon, "Error Flag/Code", sEFErrorCodeArray[2].trim(), errorCode);
                                        this.boolErrCodeFound = true;
                                    }
                                    if (sEFErrorCodeArray[3] != null && !"".equalsIgnoreCase(sEFErrorCodeArray[3])) {
                                        String errorCode = sEFErrorCodeArray[3].trim().replace("SEF", "11");
                                        System.out.println("errorCode4" + errorCode);
                                        this.respgen.genHTML(pcon, "Error Flag/Code", sEFErrorCodeArray[3].trim(), errorCode);
                                        this.boolErrCodeFound = true;
                                    }
                                }
                            }
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 4: {
                        boolTempFlag = this.valTtsRecordNumber(fieldStr, "Record Number", 4);
                        this.objTtsDtlsVO.setRecordNumber(fieldStr);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                            System.out.println("Tts record number error");
                        } else {
                            System.out.println("Tts record number validated");
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 5: {
                        boolTempFlag = this.valBankAccountType(fieldStr, "Bank Account Type", 5);
                        this.objTtsDtlsVO.setBankAcctType(fieldStr);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                            System.out.println("Tts bank account error");
                        } else {
                            System.out.println("Tts bank account validated");
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 6: {
                        boolTempFlag = this.valBankAccNo(fieldStr, "Bank Account Number", 6);
                        this.objTtsDtlsVO.setBankAcctNum(fieldStr);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                            System.out.println("Tts bank acc number error");
                        } else {
                            System.out.println("Tts bank acc number validated");
                        }
                        if (fieldStr.equals("")) {
                            this.boolBankAccNo = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 7: {
                        boolTempFlag = this.valBankName(fieldStr, "Bank Name", 7);
                        this.objTtsDtlsVO.setBankName(fieldStr);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                            System.out.println("Tts bank name error");
                        } else {
                            System.out.println("Tts bank name validated");
                        }
                        if (fieldStr.equals("")) {
                            this.boolBankName = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 8: {
                        this.objTtsDtlsVO.setBankIFScode(fieldStr);
                        boolTempFlag = this.valBankIFSCode(fieldStr, "Bank IFS code", 8);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                            System.out.println("Tts bank IFS code error");
                        } else {
                            System.out.println("Tts bank IFS code validated");
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 9: {
                        boolTempFlag = this.valNumOfNom(fieldStr, "Number Of Nominees", 9);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                            this.objTtsDtlsVO.setNomineeCount(0);
                            pcon.setIntTtsNomRemain(0);
                            pcon.setIntTtsTotNom(0);
                            System.out.println("Tts number of nominee error");
                            System.out.println("objTtsDtlsVO.getNomineeCount = " + this.objTtsDtlsVO.getNomineeCount());
                            System.out.println("pcon.getIntTtsNomRemain = " + pcon.getIntTtsNomRemain());
                            System.out.println("pcon.getIntTtsTotNom = " + pcon.getIntTtsTotNom());
                        } else {
                            this.objTtsDtlsVO.setNomineeCount(Integer.parseInt(fieldStr));
                            pcon.setIntTtsNomRemain(Integer.parseInt(fieldStr));
                            pcon.setIntTtsTotNom(Integer.parseInt(fieldStr));
                            System.out.println("Tts number of nominee validated ");
                            System.out.println("objTtsDtlsVO.getNomineeCount = " + this.objTtsDtlsVO.getNomineeCount());
                            System.out.println("pcon.getIntTtsNomRemain = " + pcon.getIntTtsNomRemain());
                            System.out.println("pcon.getIntTtsTotNom = " + pcon.getIntTtsTotNom());
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 10: {
                        boolTempFlag = this.valCancelChequeFlag(fieldStr, "Cancelled Cheque Flag", 10);
                        this.objTtsDtlsVO.setCancelChequeFlag(fieldStr);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 11: {
                        boolTempFlag = this.valPOPSPReg(fieldStr, "POP-SP Reg. No.", 11);
                        this.objTtsDtlsVO.setPopSPReg(fieldStr);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    default: {
                        boolRecFlag = false;
                    }
                }
            }
            if (SubsRegConst.getUtilityLevel() == 1) {
                if (boolRecFlag) {
                    if (this.addHash(pcon.getFileLine())) {
                        this.objWRecord.writeRecord(pcon.getFileLine(), pcon.getStrFilePath(), pcon.getStrUploadDirPath());
                        this.objTtsDtlsVO.setTtsErrorFlag(false);
                        return this.objTtsDtlsVO;
                    }
                    System.out.println("ERROR:Hash value error");
                    this.objTtsDtlsVO.setTtsErrorFlag(true);
                    return this.objTtsDtlsVO;
                }
                System.out.println("ERROR:boolRecFlag error");
                this.objTtsDtlsVO.setTtsErrorFlag(true);
                return this.objTtsDtlsVO;
            }
        }
        catch (Exception e) {
            System.out.println("ERROR:Exception in Tts format val");
            this.objTtsDtlsVO.setTtsErrorFlag(true);
            return this.objTtsDtlsVO;
        }
        return this.objTtsDtlsVO;
    }

    public boolean valTtsRecordNumber(String fieldStr, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnCode);
        try {
            boolTemp = this.valFieldBasics(fieldStr, 6, SubsRegConst.getMandatoryValue(), strColumnName, intColumnCode);
            if (!this.isNumber(fieldStr)) {
                System.out.println("in isNumber() error");
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "3");
                return boolTemp;
            }
            if (Integer.parseInt(fieldStr) == 0) {
                System.out.println("==0 error");
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "4");
                return boolTemp;
            }
            if (fieldStr.length() < 6) {
                System.out.println("length less then 6 error");
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "2");
                return boolTemp;
            }
            if (!fieldStr.equalsIgnoreCase("000001")) {
                System.out.println("fieldString must be equal to 000001");
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "4");
                return boolTemp;
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valFileSectType(String fieldStr, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        try {
            if (!fieldStr.equals("TT") && !fieldStr.equals("tt")) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "107021");
                return boolTemp;
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valErrorFlgCd(String fieldStr, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnCode);
        try {
            boolTemp = this.valFieldBasics(fieldStr.trim(), 7, SubsRegConst.getMandatoryValue(), strColumnName, intColumnCode);
            if (fieldStr.trim().length() != 1 && fieldStr.trim().length() != 7) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "3");
            } else if (fieldStr.trim().length() == 7) {
                if (!fieldStr.trim().substring(0, 3).equals("SEF") || !this.isNumber(fieldStr.trim().substring(3, 7))) {
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "5");
                    boolTemp = false;
                }
            } else if (fieldStr.length() == 1 && !fieldStr.trim().equals("N")) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr.trim(), String.valueOf(strErrCode) + "5");
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valBankAccountType(String fieldStr, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        try {
            boolTemp = this.valFieldBasics(fieldStr, 20, SubsRegConst.getMandatoryValue(), strColumnName, intColumnCode);
            if (!this.pcon.isNRI) {
                if (!(fieldStr.toUpperCase().equals("SAVINGS") || fieldStr.toUpperCase().equals("CURRENT") || fieldStr.toUpperCase().equals("OTHERS"))) {
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "107053");
                    boolTemp = false;
                }
            } else {
                if (fieldStr == null || "".equalsIgnoreCase(fieldStr)) {
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "107055");
                    boolTemp = false;
                }
                if (!(fieldStr == null || "".equalsIgnoreCase(fieldStr) || "NRE".equalsIgnoreCase(fieldStr) || "NRO".equalsIgnoreCase(fieldStr))) {
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "107054");
                    boolTemp = false;
                }
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valBankAccNo(String fieldStr, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        try {
            boolTemp = this.valFieldBasics(fieldStr, 30, SubsRegConst.getOptionalValue(), strColumnName, intColumnCode);
            if (this.pcon.isNRI && (fieldStr == null || "".equalsIgnoreCase(fieldStr))) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "107065");
                return boolTemp;
            }
            if (!this.isAlphanumeric(fieldStr)) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "107063");
                return boolTemp;
            }
            if (this.isAlpha(fieldStr)) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "107063");
                return boolTemp;
            }
            if (this.isNumber(fieldStr) && new BigDecimal(fieldStr).compareTo(BigDecimal.ZERO) == 0) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "107064");
                return boolTemp;
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valBankName(String fieldStr, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        try {
            boolTemp = this.valFieldBasics(fieldStr, 75, SubsRegConst.getOptionalValue(), strColumnName, intColumnCode);
            if (this.pcon.isNRI && (fieldStr == null || "".equalsIgnoreCase(fieldStr))) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "107073");
                return boolTemp;
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valBankIFSCode(String strFieldVal, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        boolTemp = this.valFieldBasics(strFieldVal, 11, SubsRegConst.getMandatoryValue(), strColumnName, intColumnCode);
        if (!strFieldVal.equalsIgnoreCase("")) {
            if (!this.isAlphanumeric(strFieldVal)) {
                System.out.println("IFS not alphanumeric");
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strFieldVal, "107083");
                return boolTemp;
            }
            if (strFieldVal.length() < 11) {
                System.out.println("IFS length less then 11");
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strFieldVal, "107082");
                return boolTemp;
            }
            if (this.isNumber(strFieldVal) && Long.parseLong(strFieldVal) == 0L) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strFieldVal, "107083");
                return boolTemp;
            }
            if (Pattern.matches("[a-zA-Z]+", strFieldVal)) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strFieldVal, "107083");
                return boolTemp;
            }
            if (Pattern.matches("[0-9]+", strFieldVal)) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strFieldVal, "107083");
                return boolTemp;
            }
        }
        return boolTemp;
    }

    public boolean valNumOfNom(String fieldStr, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        try {
            if (fieldStr.equals("")) {
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "107091");
            }
            if (!(fieldStr.equals("1") || fieldStr.equals("2") || fieldStr.equals("3"))) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "107092");
                return boolTemp;
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valNumOfPFM(String fieldStr, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        boolTemp = this.valFieldBasics(fieldStr, 3, SubsRegConst.getMandatoryValue(), strColumnName, intColumnCode);
        try {
            if ((fieldStr != null || !"".equalsIgnoreCase(fieldStr)) && this.isNumber(fieldStr)) {
                if (Integer.parseInt(fieldStr) <= 0 || Integer.parseInt(fieldStr) > 3) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "107144");
                    return boolTemp;
                }
                if (!this.isNumber(fieldStr)) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "107143");
                    return boolTemp;
                }
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valCancelChequeFlag(String fieldStr, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        boolTemp = this.valFieldBasics(fieldStr, 1, SubsRegConst.getMandatoryValue(), strColumnName, intColumnCode);
        if (!this.isUnorganizedSector) {
            if (!"Y".equalsIgnoreCase(fieldStr)) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "107105");
                return boolTemp;
            }
        } else if (boolTemp && !"Y".equalsIgnoreCase(fieldStr) && !"N".equalsIgnoreCase(fieldStr)) {
            boolTemp = false;
            this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "107103");
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valPOPSPReg(String fieldStr, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        boolTemp = this.valFieldBasics(fieldStr, 7, SubsRegConst.getMandatoryValue(), strColumnName, intColumnCode);
        if (!this.isNumber(fieldStr)) {
            boolTemp = false;
            this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "107113");
            return boolTemp;
        }
        if (fieldStr.length() < 7) {
            boolTemp = false;
            this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "107112");
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valPennyDropVerify(String fieldStr, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        boolTemp = this.valFieldBasics(fieldStr, 1, SubsRegConst.getMandatoryValue(), strColumnName, intColumnCode);
        if (boolTemp && !"Y".equalsIgnoreCase(fieldStr) && !"N".equalsIgnoreCase(fieldStr)) {
            boolTemp = false;
            this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "107123");
            return boolTemp;
        }
        if ("N".equalsIgnoreCase(fieldStr) && !this.objTtsDtlsVO.getCancelChequeFlag().equalsIgnoreCase("Y")) {
            boolTemp = false;
            this.respgen.genHTML(this.pcon, "Cancel Cheque flag", this.objTtsDtlsVO.getCancelChequeFlag(), "107104");
            return boolTemp;
        }
        return boolTemp;
    }
}

