/*
 * Decompiled with CFR 0.152.
 */
package com.cra.sim.validator.regn.format;

import com.cra.common.reg.util.CommonValidation;
import com.cra.framework.reg.vo.SessionVO;
import com.cra.sim.util.SIMConstants;
import com.cra.sim.util.SubsRegConst;
import com.cra.sim.util.WriteRecord;
import com.cra.sim.validator.BaseValidator;
import com.cra.sim.vo.Tier2DtlsVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class Tier2DtlsFormatValidator
extends BaseValidator
implements SIMConstants {
    String strFileType = "";
    boolean boolErrCodeFound = false;
    boolean boolBankAccNo = true;
    boolean boolBankName = true;
    boolean boolBankBranch = true;
    boolean boolBankAddress = true;
    boolean boolBankPin = true;
    boolean boolBankMICR = true;
    boolean boolBankState = true;
    boolean boolBankCountry = true;
    boolean boolBankIFSC = true;
    String strT2BankaddrState = "";
    WriteRecord objWRecord = new WriteRecord();
    Tier2DtlsVO objTier2DtlsVO = new Tier2DtlsVO();
    private String sectorType;
    boolean isCORP = false;
    boolean isOS = false;

    public Tier2DtlsFormatValidator(SessionVO sessVO) {
        super(sessVO);
    }

    public Tier2DtlsFormatValidator(SessionVO sessVO, String sectorValue) {
        super(sessVO);
        this.sectorType = sectorValue;
        if (this.sectorType.equalsIgnoreCase("U")) {
            this.isUnorganizedSector = true;
        }
        if (this.sectorType.equalsIgnoreCase("C")) {
            this.isCORP = true;
        }
        if (this.sectorType.equalsIgnoreCase("R")) {
            this.isOS = true;
        }
    }

    @Override
    public String getErrorForm() {
        return "106";
    }

    public Tier2DtlsVO validateT2DtlsFormat(SubsRegConst pcon) {
        this.pcon = pcon;
        int intcarotcnt = 0;
        boolean boolRecFlag = true;
        pcon.setStrErrInRecord("");
        pcon.setIntT2SchRecNum(0);
        pcon.setIntT2NomRecNum(0);
        try {
            int intFieldIndex = 0;
            int intLineStart = 0;
            int intLineEnd = 0;
            this.strFileType = pcon.getFileType();
            while ((intLineEnd = pcon.getFileLine().substring(intLineStart).indexOf("^")) >= 0) {
                ++intcarotcnt;
                intLineStart = intLineStart + intLineEnd + 1;
            }
            int CORP_REG_CARAT_COUNT = 19;
            if (this.isUnorganizedSector) {
                CORP_REG_CARAT_COUNT = 20;
            }
            if (pcon.isCombinedFormFlag() && pcon.isCorpSector() && pcon.isUOSSector()) {
                CORP_REG_CARAT_COUNT = 20;
            }
            if (intcarotcnt != CORP_REG_CARAT_COUNT) {
                System.out.println("ERROR:TD carat count error found" + CORP_REG_CARAT_COUNT);
                this.respgen.genHTML(pcon, "Carat Count", "" + intcarotcnt, "106001");
                boolRecFlag = false;
                this.objTier2DtlsVO.setT2ErrorFlag(true);
                return this.objTier2DtlsVO;
            }
            String fieldStr = "";
            boolean boolTempFlag = true;
            intLineEnd = 0;
            intLineStart = 0;
            intFieldIndex = 1;
            boolean boolErrorCodeStopProcess = false;
            while (intLineEnd != -1 && !boolErrorCodeStopProcess) {
                intLineEnd = pcon.getFileLine().substring(intLineStart).indexOf("^");
                if (intLineEnd == -1) {
                    fieldStr = pcon.getFileLine().substring(intLineStart).trim();
                } else {
                    fieldStr = pcon.getFileLine().substring(intLineStart, intLineStart + intLineEnd).trim();
                    intLineStart = intLineStart + intLineEnd + 1;
                }
                switch (intFieldIndex) {
                    case 1: {
                        boolTempFlag = this.valLineNumber(fieldStr, "Line Number", 1);
                        if (!boolTempFlag) {
                            this.objTier2DtlsVO.setLineNum("0");
                            boolRecFlag = false;
                            pcon.setIntSubsLineNum(0);
                            System.out.println("T2 line number error");
                        } else {
                            System.out.println("T2 line number validated");
                            this.objTier2DtlsVO.setLineNum(fieldStr);
                            pcon.setIntSubsLineNum(Integer.parseInt(fieldStr));
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 2: {
                        boolTempFlag = this.valFileSectType(fieldStr, "File Section Type", 2);
                        this.objTier2DtlsVO.setFileSectType(fieldStr);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                            System.out.println("T2 section type error");
                        } else {
                            System.out.println("T2 section type validated");
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 3: {
                        boolTempFlag = this.valErrorFlgCd(fieldStr, "Error Flag/Code", 3);
                        this.objTier2DtlsVO.setErrorFlagCode(fieldStr);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                            System.out.println("T2 error flag error");
                            break;
                        }
                        System.out.println("T2 error flag validated");
                        if (fieldStr.length() == 7) {
                            System.out.println("Error code found");
                            this.respgen.genHTML(pcon, "Error Flag/Code", fieldStr, "106034");
                            this.boolErrCodeFound = true;
                            boolErrorCodeStopProcess = true;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 4: {
                        boolTempFlag = this.valT2RecordNumber(fieldStr, "Record Number", 4);
                        this.objTier2DtlsVO.setRecordNumber(fieldStr);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                            System.out.println("T2 record number error");
                        } else {
                            System.out.println("T2 record number validated");
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 5: {
                        boolTempFlag = this.valBankAccountType(fieldStr, "Bank Account Type", 5);
                        this.objTier2DtlsVO.setBankAcctType(fieldStr);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                            System.out.println("T2 bank account error");
                        } else {
                            System.out.println("T2 bank account validated");
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 6: {
                        boolTempFlag = this.valBankAccNo(fieldStr, "Bank Account Number", 6);
                        this.objTier2DtlsVO.setBankAcctNum(fieldStr);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                            System.out.println("T2 bank acc number error");
                        } else {
                            System.out.println("T2 bank acc number validated");
                        }
                        if (fieldStr.equals("")) {
                            this.boolBankAccNo = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 7: {
                        boolTempFlag = this.valBankName(fieldStr, "Bank Name", 7);
                        this.objTier2DtlsVO.setBankName(fieldStr);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                            System.out.println("T2 bank name error");
                        } else {
                            System.out.println("T2 bank name validated");
                        }
                        if (fieldStr.equals("")) {
                            this.boolBankName = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 8: {
                        boolTempFlag = this.isFillerField(fieldStr, 8);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 9: {
                        boolTempFlag = this.isFillerField(fieldStr, 9);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 10: {
                        boolTempFlag = this.isFillerField(fieldStr, 10);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 11: {
                        boolTempFlag = this.isFillerField(fieldStr, 11);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 12: {
                        this.objTier2DtlsVO.setBankIFScode(fieldStr);
                        boolTempFlag = this.valBankIFSCode(fieldStr, "Bank IFS code", 12);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                            System.out.println("T2 bank IFS code error");
                        } else {
                            System.out.println("T2 bank IFS code validated");
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 13: {
                        boolTempFlag = this.valNumOfNom(fieldStr, "Number Of Nominees", 15);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                            this.objTier2DtlsVO.setNomineeCount(0);
                            pcon.setIntT2NomRemain(0);
                            pcon.setIntT2TotNom(0);
                            System.out.println("T2 number of nominee error");
                            System.out.println("objTier2DtlsVO.getNomineeCount = " + this.objTier2DtlsVO.getNomineeCount());
                            System.out.println("pcon.getIntT2NomRemain = " + pcon.getIntT2NomRemain());
                            System.out.println("pcon.getIntT2TotNom = " + pcon.getIntT2TotNom());
                        } else {
                            this.objTier2DtlsVO.setNomineeCount(Integer.parseInt(fieldStr));
                            pcon.setIntT2NomRemain(Integer.parseInt(fieldStr));
                            pcon.setIntT2TotNom(Integer.parseInt(fieldStr));
                            System.out.println("T2 number of nominee validated ");
                            System.out.println("objTier2DtlsVO.getNomineeCount = " + this.objTier2DtlsVO.getNomineeCount());
                            System.out.println("pcon.getIntT2NomRemain = " + pcon.getIntT2NomRemain());
                            System.out.println("pcon.getIntT2TotNom = " + pcon.getIntT2TotNom());
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 14: {
                        boolTempFlag = this.valNumOfSchemes(fieldStr, "Number Of Schemes", 16);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                            this.objTier2DtlsVO.setSchemeCount(0);
                            pcon.setIntT2SchRemain(0);
                            pcon.setIntT2TotSch(0);
                            System.out.println("T2 number of schemes error");
                            System.out.println("objTier2DtlsVO.getSchemeCount = " + this.objTier2DtlsVO.getSchemeCount());
                            System.out.println("pcon.getIntT2SchRemain = " + pcon.getIntT2SchRemain());
                            System.out.println("pcon.getIntT2TotSch = " + pcon.getIntT2TotSch());
                        } else {
                            this.objTier2DtlsVO.setSchemeCount(Integer.parseInt(fieldStr));
                            pcon.setIntT2SchRemain(Integer.parseInt(fieldStr));
                            pcon.setIntT2TotSch(Integer.parseInt(fieldStr));
                            System.out.println("T2 number of schemes validated ");
                            System.out.println("objTier2DtlsVO.getSchemeCount = " + this.objTier2DtlsVO.getSchemeCount());
                            System.out.println("pcon.getIntT2SchRemain = " + pcon.getIntT2SchRemain());
                            System.out.println("pcon.getIntT2TotSch = " + pcon.getIntT2TotSch());
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 15: {
                        boolTempFlag = this.valSchPrefOpt(fieldStr, "Scheme Type", 90);
                        this.objTier2DtlsVO.setT2schPrefOpt(fieldStr);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 16: {
                        boolTempFlag = this.valPAOAIN(fieldStr, "POP-SP Reg. No.", 13);
                        this.objTier2DtlsVO.setAIN(fieldStr);
                        pcon.setstrT2AIN(fieldStr);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 17: {
                        boolTempFlag = this.valCancelChequeFlag(fieldStr, "Cancel Cheque flag", 22);
                        this.objTier2DtlsVO.setCancelChequeFlag(fieldStr);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 18: {
                        boolTempFlag = this.isFillerField(fieldStr, 18);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 19: {
                        boolTempFlag = this.isFillerField(fieldStr, 19);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 20: {
                        System.out.println("value" + this.isUnorganizedSector);
                        if (!this.isUnorganizedSector) {
                            boolTempFlag = this.isFillerField(fieldStr, 20);
                            if (!boolTempFlag) {
                                boolRecFlag = false;
                            }
                        } else {
                            System.out.println("ReReg" + fieldStr);
                            boolTempFlag = this.valRetrmentAdRegNo(fieldStr, "Retirement Advisor Reg No.", 20);
                            this.objTier2DtlsVO.setRetAdvisorRegNo(fieldStr);
                            if (!boolTempFlag) {
                                boolRecFlag = false;
                            }
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 21: {
                        System.out.println("Enter in case 21 T2");
                        boolTempFlag = this.valPennyDropVerify(fieldStr, "Penny Drop Verification by POP", 21);
                        this.objTier2DtlsVO.setPennyDropVerifByPOP(fieldStr);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    default: {
                        boolRecFlag = false;
                    }
                }
            }
            if (SubsRegConst.getUtilityLevel() == 1) {
                if (boolRecFlag) {
                    if (this.addHash(pcon.getFileLine())) {
                        this.objWRecord.writeRecord(pcon.getFileLine(), pcon.getStrFilePath(), pcon.getStrUploadDirPath());
                        this.objTier2DtlsVO.setT2ErrorFlag(false);
                        return this.objTier2DtlsVO;
                    }
                    System.out.println("ERROR:Hash value error");
                    this.objTier2DtlsVO.setT2ErrorFlag(true);
                    return this.objTier2DtlsVO;
                }
                System.out.println("ERROR:boolRecFlag error");
                this.objTier2DtlsVO.setT2ErrorFlag(true);
                return this.objTier2DtlsVO;
            }
        }
        catch (Exception e) {
            System.out.println("ERROR:Exception in T2 biz val");
            this.objTier2DtlsVO.setT2ErrorFlag(true);
            return this.objTier2DtlsVO;
        }
        return this.objTier2DtlsVO;
    }

    public boolean valT2RecordNumber(String fieldStr, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnCode);
        try {
            boolTemp = this.valFieldBasics(fieldStr, 6, SubsRegConst.getMandatoryValue(), strColumnName, intColumnCode);
            if (!this.isNumber(fieldStr)) {
                System.out.println("in isNumber() error");
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "3");
                return boolTemp;
            }
            if (Integer.parseInt(fieldStr) == 0) {
                System.out.println("==0 error");
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "4");
                return boolTemp;
            }
            if (fieldStr.length() < 6) {
                System.out.println("length less then 6 error");
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "2");
                return boolTemp;
            }
            if (!fieldStr.equalsIgnoreCase("000001")) {
                System.out.println("fieldString must be equal to 000001");
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "4");
                return boolTemp;
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valFileSectType(String fieldStr, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        try {
            if (!fieldStr.equals("TD")) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "106021");
                return boolTemp;
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valErrorFlgCd(String fieldStr, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        try {
            boolTemp = this.valFieldBasics(fieldStr, 7, SubsRegConst.getMandatoryValue(), strColumnName, intColumnCode);
            if (fieldStr.length() != 1 && fieldStr.length() != 7) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "106033");
            } else if (fieldStr.length() == 7) {
                if (!fieldStr.substring(0, 3).equals("SEF") || !this.isNumber(fieldStr.substring(3, 7))) {
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "106035");
                    boolTemp = false;
                } else {
                    boolean valid = this.respgen.checkValidErrorCode(fieldStr);
                    if (!valid) {
                        this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "106035");
                        boolTemp = false;
                    }
                }
            } else if (fieldStr.length() == 1 && !fieldStr.trim().equals("N")) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "106035");
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valBankAccountType(String fieldStr, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        try {
            boolTemp = this.valFieldBasics(fieldStr, 20, SubsRegConst.getMandatoryValue(), strColumnName, intColumnCode);
            if (!this.pcon.isNRI) {
                if (!(fieldStr.toUpperCase().equals("SAVINGS") || fieldStr.toUpperCase().equals("CURRENT") || fieldStr.toUpperCase().equals("OTHERS"))) {
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "106053");
                    boolTemp = false;
                }
            } else {
                if (fieldStr == null || "".equalsIgnoreCase(fieldStr)) {
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "106055");
                    boolTemp = false;
                }
                if (!(fieldStr == null || "".equalsIgnoreCase(fieldStr) || "NRE".equalsIgnoreCase(fieldStr) || "NRO".equalsIgnoreCase(fieldStr))) {
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "106054");
                    boolTemp = false;
                }
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valBankAccNo(String fieldStr, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        try {
            boolTemp = this.valFieldBasics(fieldStr, 30, SubsRegConst.getMandatoryValue(), strColumnName, intColumnCode);
            if (this.pcon.isNRI && (fieldStr == null || "".equalsIgnoreCase(fieldStr))) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "106065");
                return boolTemp;
            }
            if (fieldStr != null && !"".equalsIgnoreCase(fieldStr)) {
                System.out.println("Entered here");
                if (!this.isAlphanumeric(fieldStr)) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "106063");
                    return boolTemp;
                }
                if (this.isAlpha(fieldStr)) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "106063");
                    return boolTemp;
                }
                if (this.isNumber(fieldStr) && new BigDecimal(fieldStr).compareTo(BigDecimal.ZERO) == 0) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "106064");
                    return boolTemp;
                }
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valBankName(String fieldStr, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        try {
            boolTemp = this.valFieldBasics(fieldStr, 75, SubsRegConst.getMandatoryValue(), strColumnName, intColumnCode);
            if (this.pcon.isNRI && (fieldStr == null || "".equalsIgnoreCase(fieldStr))) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "106073");
                return boolTemp;
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valBankBranch(String fieldStr, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        try {
            boolTemp = this.valFieldBasics(fieldStr, 30, SubsRegConst.getOptionalValue(), strColumnName, intColumnCode);
            if (this.pcon.isNRI && (fieldStr == null || "".equalsIgnoreCase(fieldStr))) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "106083");
                return boolTemp;
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    private boolean valBankAddress(String fieldStr, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        try {
            boolTemp = this.valFieldBasics(fieldStr, 50, SubsRegConst.getOptionalValue(), strColumnName, intColumnCode);
            if (this.pcon.isNRI && (fieldStr == null || "".equalsIgnoreCase(fieldStr))) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "106093");
                return boolTemp;
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valBankPin(String fieldStr, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        try {
            boolTemp = this.valFieldBasics(fieldStr, 6, SubsRegConst.getOptionalValue(), strColumnName, intColumnCode);
            if (this.pcon.isNRI && (fieldStr == null || "".equalsIgnoreCase(fieldStr))) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "106106");
                return boolTemp;
            }
            if (!this.isNumber(fieldStr)) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "106103");
                return boolTemp;
            }
            if (fieldStr.startsWith("0")) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "106104");
                return boolTemp;
            }
            if (fieldStr.length() < 6) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "106105");
                return boolTemp;
            }
            if (fieldStr != null && !"".equalsIgnoreCase(fieldStr) && this.isNumber(fieldStr) && Long.parseLong(fieldStr) == 0L) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "106107");
                return boolTemp;
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valBankMICR(String fieldStr, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        try {
            boolTemp = this.valFieldBasics(fieldStr, 9, SubsRegConst.getOptionalValue(), strColumnName, intColumnCode);
            if (!this.isNumber(fieldStr)) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "106113");
                return boolTemp;
            }
            if (!fieldStr.equals("") && Long.parseLong(fieldStr) == 0L) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "106114");
                return boolTemp;
            }
            if (fieldStr != null && !fieldStr.equals("") && fieldStr.length() < 9) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "106112");
                return boolTemp;
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valBankIFSCode(String strFieldVal, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        boolTemp = this.valFieldBasics(strFieldVal, 11, SubsRegConst.getMandatoryValue(), strColumnName, intColumnCode);
        if (!strFieldVal.equalsIgnoreCase("")) {
            System.out.println("IFS not alphanumeric");
            if (!this.isAlphanumeric(strFieldVal)) {
                System.out.println("IFS not alphanumeric");
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strFieldVal, "106123");
                return boolTemp;
            }
            if (strFieldVal.length() < 11) {
                System.out.println("IFS length less then 11");
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strFieldVal, "106122");
                return boolTemp;
            }
            if (this.isNumber(strFieldVal) && Long.parseLong(strFieldVal) == 0L) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strFieldVal, "106123");
                return boolTemp;
            }
            if (Pattern.matches("[a-zA-Z]+", strFieldVal)) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strFieldVal, "106123");
                return boolTemp;
            }
            if (Pattern.matches("[0-9]+", strFieldVal)) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strFieldVal, "106123");
                return boolTemp;
            }
        }
        return boolTemp;
    }

    public boolean valBankMand() {
        if (!this.pcon.isNRI && this.boolBankAccNo && this.boolBankName && this.boolBankBranch && this.boolBankAddress && this.boolBankPin && this.boolBankState && this.boolBankCountry && this.boolBankIFSC) {
            return true;
        }
        if (this.pcon.isNRI && this.boolBankAccNo && this.boolBankName && this.boolBankBranch && this.boolBankAddress && this.boolBankPin && this.boolBankState && this.boolBankCountry && this.boolBankIFSC) {
            return true;
        }
        if (!this.pcon.isNRI) {
            if (!this.boolBankAccNo) {
                this.respgen.genHTML(this.pcon, "Bank Account Number", "", "106061");
            }
            if (!this.boolBankName) {
                this.respgen.genHTML(this.pcon, "Bank Name", "", "106071");
            }
            if (!this.boolBankBranch) {
                this.respgen.genHTML(this.pcon, "Bank Branch", "", "106081");
            }
            if (!this.boolBankAddress) {
                this.respgen.genHTML(this.pcon, "Bank Address", "", "106091");
            }
            if (!this.boolBankPin) {
                this.respgen.genHTML(this.pcon, "Bank Pin", "", "106101");
            }
            if (!this.boolBankState) {
                this.respgen.genHTML(this.pcon, "Bank State", "", "106581");
            }
            if (!this.boolBankCountry) {
                this.respgen.genHTML(this.pcon, "Bank Country", "", "106591");
            }
        } else {
            if (!this.boolBankAccNo) {
                this.respgen.genHTML(this.pcon, "Bank Account Number", "", "106061");
            }
            if (!this.boolBankName) {
                this.respgen.genHTML(this.pcon, "Bank Name", "", "106071");
            }
            if (!this.boolBankBranch) {
                this.respgen.genHTML(this.pcon, "Bank Branch", "", "106081");
            }
            if (!this.boolBankAddress) {
                this.respgen.genHTML(this.pcon, "Bank Address", "", "106091");
            }
            if (!this.boolBankPin) {
                this.respgen.genHTML(this.pcon, "Bank Pin", "", "106101");
            }
            if (!this.boolBankState) {
                this.respgen.genHTML(this.pcon, "Bank State", "", "106581");
            }
            if (!this.boolBankCountry) {
                this.respgen.genHTML(this.pcon, "Bank Country", "", "106591");
            }
        }
        return false;
    }

    public boolean valNumOfNom(String fieldStr, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        try {
            if (fieldStr.equals("")) {
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "106151");
            }
            if (!(fieldStr.equals("0") || fieldStr.equals("1") || fieldStr.equals("2") || fieldStr.equals("3"))) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "106152");
                return boolTemp;
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valNumOfSchemes(String fieldStr, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        try {
            if (fieldStr.equals("")) {
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "106161");
            }
            if (!this.isNumber(fieldStr)) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "106162");
                return boolTemp;
            }
            if (Integer.parseInt(fieldStr) > 100) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "106163");
                return boolTemp;
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valSchPrefOpt(String strFieldVal, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        boolTemp = this.valFieldBasics(strFieldVal, 1, SubsRegConst.getMandatoryValue(), strColumnName, intColumnCode);
        this.pcon.setT2StandardSchPrefOpt(false);
        if (strFieldVal != null && !"".equalsIgnoreCase(strFieldVal)) {
            if (!this.isUnorganizedSector) {
                if (!(strFieldVal.equalsIgnoreCase("A") || strFieldVal.equalsIgnoreCase("V") || strFieldVal.equalsIgnoreCase("H") || strFieldVal.equalsIgnoreCase("L") || strFieldVal.equalsIgnoreCase("C") || strFieldVal.equalsIgnoreCase("S") || strFieldVal.equalsIgnoreCase("B"))) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, strFieldVal, "102903");
                    return boolTemp;
                }
                if ((strFieldVal.equalsIgnoreCase("A") || strFieldVal.equalsIgnoreCase("V") || strFieldVal.equalsIgnoreCase("H") || strFieldVal.equalsIgnoreCase("L") || strFieldVal.equalsIgnoreCase("B")) && this.objTier2DtlsVO.getSchemeCount() == 0) {
                    System.out.println("T2 Scheme count is 0 for pref type A or V");
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, strFieldVal, "102905");
                    return boolTemp;
                }
                if (strFieldVal.equalsIgnoreCase("S")) {
                    this.pcon.setT2StandardSchPrefOpt(true);
                    this.respgen.genHTML(this.pcon, strColumnName, strFieldVal, "102906");
                    System.out.println("pcon.setT2StandardSchPrefOpt() : " + this.pcon.isT2StandardSchPrefOpt());
                }
            }
            if (this.isUnorganizedSector) {
                if (!(strFieldVal.equalsIgnoreCase("A") || strFieldVal.equalsIgnoreCase("V") || strFieldVal.equalsIgnoreCase("H") || strFieldVal.equalsIgnoreCase("L") || strFieldVal.equalsIgnoreCase("B"))) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, strFieldVal, "102904");
                    return boolTemp;
                }
                if ((strFieldVal.equalsIgnoreCase("A") || strFieldVal.equalsIgnoreCase("V") || strFieldVal.equalsIgnoreCase("H") || strFieldVal.equalsIgnoreCase("L") || strFieldVal.equalsIgnoreCase("B")) && this.objTier2DtlsVO.getSchemeCount() == 0) {
                    System.out.println("T2 Scheme count is 0 for pref type A or V");
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, strFieldVal, "102905");
                    return boolTemp;
                }
                if (strFieldVal.equalsIgnoreCase("S")) {
                    this.pcon.setT2StandardSchPrefOpt(true);
                    System.out.println("pcon.setT2StandardSchPrefOpt() : " + this.pcon.isT2StandardSchPrefOpt());
                }
            }
        }
        return boolTemp;
    }

    public boolean valPAOAIN(String fieldStr, String strColumnName, int intColumnCode) {
        boolean boolTemp;
        block7: {
            ArrayList<String> errorList;
            block8: {
                boolTemp = true;
                errorList = new ArrayList<String>();
                try {
                    if (this.isUnorganizedSector) {
                        strColumnName = "POP-SP / CBO Reg. No.";
                        errorList.add(0, "102145");
                        errorList.add(1, "102146");
                        errorList.add(2, "102147");
                        errorList.add(3, "102148");
                    } else {
                        errorList.add(0, "102141");
                        errorList.add(1, "102142");
                        errorList.add(2, "102143");
                        errorList.add(3, "102144");
                    }
                    if (fieldStr == null || "".equalsIgnoreCase(fieldStr)) break block7;
                    if (fieldStr.length() == 7) break block8;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, ((String)errorList.get(1)).toString());
                    return false;
                }
                catch (Exception e) {
                    boolTemp = false;
                    return boolTemp;
                }
            }
            if (!this.isNumber(fieldStr)) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, ((String)errorList.get(2)).toString());
            }
            if (boolTemp && CommonValidation.checkID(fieldStr)) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, ((String)errorList.get(3)).toString());
            }
        }
        return boolTemp;
    }

    public boolean valCancelChequeFlag(String fieldStr, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        boolTemp = this.valFieldBasics(fieldStr, 1, SubsRegConst.getMandatoryValue(), strColumnName, intColumnCode);
        if (!this.isUnorganizedSector) {
            if (boolTemp && !"Y".equalsIgnoreCase(fieldStr)) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "106223");
                return boolTemp;
            }
        } else if (boolTemp && !"Y".equalsIgnoreCase(fieldStr) && !"N".equalsIgnoreCase(fieldStr)) {
            boolTemp = false;
            this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "106226");
            return boolTemp;
        }
        return boolTemp;
    }

    boolean valBankStateCountrymap(String strColumnName, String strStateCode, String strCountryCode) {
        boolean boolTemp = true;
        if (strCountryCode.equalsIgnoreCase("IN") && strStateCode.equals("99")) {
            boolTemp = false;
            this.respgen.genHTML(this.pcon, strColumnName, String.valueOf(strStateCode) + "/" + strCountryCode, "106595");
            return boolTemp;
        }
        if (!strCountryCode.equalsIgnoreCase("IN") && !strStateCode.equals("99")) {
            boolTemp = false;
            this.respgen.genHTML(this.pcon, strColumnName, String.valueOf(strStateCode) + "/" + strCountryCode, "106595");
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valRetrmentAdRegNo(String retAdvsrRegNo, String strColumnName, int intColumnCode) {
        System.out.println("enter in val RR");
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnCode);
        try {
            boolTemp = this.valFieldBasics(retAdvsrRegNo.trim(), 12, SubsRegConst.getOptionalValue(), strColumnName, intColumnCode);
            if (retAdvsrRegNo != null && !retAdvsrRegNo.trim().equals("")) {
                if (retAdvsrRegNo.length() < 12) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, retAdvsrRegNo, String.valueOf(strErrCode) + "2");
                    return boolTemp;
                }
                if (Pattern.matches("[A-Z]+", retAdvsrRegNo)) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, retAdvsrRegNo, String.valueOf(strErrCode) + "4");
                    return boolTemp;
                }
                if (!this.isAlphanumeric(retAdvsrRegNo)) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, retAdvsrRegNo, String.valueOf(strErrCode) + "6");
                    return boolTemp;
                }
                if (this.isNumber(retAdvsrRegNo) && Long.parseLong(retAdvsrRegNo) == 0L) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, retAdvsrRegNo, String.valueOf(strErrCode) + "3");
                    return boolTemp;
                }
                if (Pattern.matches("[0-9]+", retAdvsrRegNo)) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, retAdvsrRegNo, String.valueOf(strErrCode) + "5");
                    return boolTemp;
                }
            }
        }
        catch (Exception e) {
            boolTemp = false;
            System.out.println("General Exception  in valRetrmentAdRegNo " + e);
            return boolTemp;
        }
        return boolTemp;
    }

    private boolean ValpopSEcode(String fieldStr, String strColumnName, int intColumnCode) {
        System.out.println("Entering in valpopSE::*******************************");
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnCode);
        try {
            boolTemp = this.valFieldBasics(fieldStr.trim(), 13, SubsRegConst.getOptionalValue(), strColumnName, intColumnCode);
            if (fieldStr.trim() != null && !"".equalsIgnoreCase(fieldStr.trim())) {
                if (!this.isAlphanumeric(fieldStr)) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "1021604");
                    return boolTemp;
                }
                if (this.isNumber(fieldStr) && Long.parseLong(fieldStr) == 0L) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "1021606");
                    return boolTemp;
                }
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valPOPSEAgentName(String strFirstName, String strColumnName, int intColumnNum) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnNum);
        int cnt = 0;
        try {
            boolTemp = !this.objTier2DtlsVO.getPopSEcode().equalsIgnoreCase("") ? this.valFieldBasics(strFirstName.trim(), 90, SubsRegConst.getMandatoryValue(), strColumnName, intColumnNum) : this.valFieldBasics(strFirstName.trim(), 90, SubsRegConst.getOptionalValue(), strColumnName, intColumnNum);
            if (strFirstName.trim() != null && !"".equalsIgnoreCase(strFirstName.trim()) && this.objTier2DtlsVO.getPopSEcode().equalsIgnoreCase("")) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, "POP SE Code", this.objTier2DtlsVO.getPopSEcode(), "106255");
                return boolTemp;
            }
            cnt = 0;
            while (cnt < strFirstName.length()) {
                if (strFirstName.charAt(cnt) != ' ' && strFirstName.charAt(cnt) != '\'' && strFirstName.charAt(cnt) != '.' && (strFirstName.toUpperCase().charAt(cnt) < 'A' || strFirstName.toUpperCase().charAt(cnt) > 'Z')) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, strFirstName, String.valueOf(strErrCode) + "3");
                    return boolTemp;
                }
                ++cnt;
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valPOPSEempId(String strFieldVal, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnCode);
        try {
            boolTemp = this.valFieldBasics(strFieldVal, 16, SubsRegConst.getOptionalValue(), strColumnName, intColumnCode);
            if (strFieldVal != null && !"".equalsIgnoreCase(strFieldVal.trim())) {
                if (this.isNumber(strFieldVal)) {
                    boolean bl = boolTemp = Long.parseLong(strFieldVal) != 0L;
                    if (!boolTemp) {
                        this.respgen.genHTML(this.pcon, strColumnName, strFieldVal, String.valueOf(strErrCode) + "5");
                        return boolTemp;
                    }
                }
                if (strFieldVal.trim() != null && !"".equalsIgnoreCase(strFieldVal.trim())) {
                    if (this.objTier2DtlsVO.getPopSEcode().equalsIgnoreCase("")) {
                        boolTemp = false;
                        this.respgen.genHTML(this.pcon, "POP SE Code", this.objTier2DtlsVO.getPopSEcode(), "106256");
                    }
                    if (this.objTier2DtlsVO.getPopSEAgentName().equalsIgnoreCase("")) {
                        boolTemp = false;
                        this.respgen.genHTML(this.pcon, "POP SE Agent Name", this.objTier2DtlsVO.getPopSEAgentName(), "106274");
                    }
                }
            } else if (!this.objTier2DtlsVO.getPopSEcode().equalsIgnoreCase("") || !this.objTier2DtlsVO.getPopSEAgentName().equalsIgnoreCase("")) {
                if (!this.objTier2DtlsVO.getPopSEcode().equalsIgnoreCase("")) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, strFieldVal, "106284");
                }
                if (!this.objTier2DtlsVO.getPopSEAgentName().equalsIgnoreCase("")) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, strFieldVal, "106285");
                }
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valPennyDropVerify(String fieldStr, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        boolTemp = this.valFieldBasics(fieldStr, 1, SubsRegConst.getMandatoryValue(), strColumnName, intColumnCode);
        if (boolTemp && !"Y".equalsIgnoreCase(fieldStr) && !"N".equalsIgnoreCase(fieldStr)) {
            boolTemp = false;
            this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "106243");
            return boolTemp;
        }
        if ("N".equalsIgnoreCase(fieldStr) && !this.objTier2DtlsVO.getCancelChequeFlag().equalsIgnoreCase("Y")) {
            boolTemp = false;
            this.respgen.genHTML(this.pcon, "Cancelled Cheque flag", this.objTier2DtlsVO.getCancelChequeFlag(), "106225");
            return boolTemp;
        }
        return boolTemp;
    }
}

