/*
 * Decompiled with CFR 0.152.
 */
package com.cra.sim.validator.regn.format;

import com.cra.common.reg.util.CRAConfigReader;
import com.cra.common.reg.util.CommonValidation;
import com.cra.common.reg.util.encrypt.NCRMod11Algorithm;
import com.cra.framework.reg.vo.SessionVO;
import com.cra.sim.util.ReadRecord;
import com.cra.sim.util.SIMConstants;
import com.cra.sim.util.SubsRegConst;
import com.cra.sim.util.WriteRecord;
import com.cra.sim.validator.BaseValidator;
import com.cra.sim.validator.regn.format.NomFormatValidator;
import com.cra.sim.validator.regn.format.SchFormatValidator;
import com.cra.sim.vo.SubsDtlsVO;
import com.cra.sim.vo.SubsRegFileVO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;

public class SubsDtlsLegacyFormatValidator
extends BaseValidator
implements SIMConstants {
    NomFormatValidator objNomVal;
    SchFormatValidator objSchVal;
    WriteRecord objWRecord;
    ReadRecord objRRecord;
    boolean boolErrCodeFound;
    String strFileType;
    String strPaddrState;
    String strCaddrState;
    String strColumnName;
    boolean boolMobFlag;
    boolean boolEmailFlag;
    boolean boolBankAccNo;
    boolean boolBankName;
    boolean boolBankBranch;
    boolean boolBankAddress;
    boolean boolBankPin;
    boolean boolBankMICR;
    boolean boolBankIFSC;
    boolean boolInvBankFlgFound;
    SubsDtlsVO objSUB;
    String sectorType;
    String subSectorType;
    boolean hindiSubFlag;
    String[] subOccupation;
    String oldNewFormFlag;
    String bankIFSCMICRMandatoryFlag;

    public SubsDtlsLegacyFormatValidator(SessionVO sessVO) {
        super(sessVO);
        this.objNomVal = new NomFormatValidator(this.sessVO);
        this.objSchVal = new SchFormatValidator(this.sessVO);
        this.objWRecord = new WriteRecord();
        this.objRRecord = null;
        this.boolErrCodeFound = false;
        this.strFileType = "";
        this.strPaddrState = "";
        this.strCaddrState = "";
        this.strColumnName = "";
        this.boolMobFlag = true;
        this.boolEmailFlag = true;
        this.boolBankAccNo = true;
        this.boolBankName = true;
        this.boolBankBranch = true;
        this.boolBankAddress = true;
        this.boolBankPin = true;
        this.boolBankMICR = true;
        this.boolBankIFSC = true;
        this.boolInvBankFlgFound = false;
        this.objSUB = new SubsDtlsVO();
        this.sectorType = null;
        this.subSectorType = "";
        this.hindiSubFlag = false;
        this.subOccupation = new String[]{"00", "01", "02", "03", "04", "06", "99", "07", "08", "09", "10", "11"};
        this.oldNewFormFlag = "";
        this.bankIFSCMICRMandatoryFlag = "";
        this.objRRecord = new ReadRecord(sessVO);
    }

    public SubsDtlsLegacyFormatValidator(SessionVO sessVO, String sectorValue) {
        super(sessVO);
        this.objNomVal = new NomFormatValidator(this.sessVO);
        this.objSchVal = new SchFormatValidator(this.sessVO);
        this.objWRecord = new WriteRecord();
        this.objRRecord = null;
        this.boolErrCodeFound = false;
        this.strFileType = "";
        this.strPaddrState = "";
        this.strCaddrState = "";
        this.strColumnName = "";
        this.boolMobFlag = true;
        this.boolEmailFlag = true;
        this.boolBankAccNo = true;
        this.boolBankName = true;
        this.boolBankBranch = true;
        this.boolBankAddress = true;
        this.boolBankPin = true;
        this.boolBankMICR = true;
        this.boolBankIFSC = true;
        this.boolInvBankFlgFound = false;
        this.objSUB = new SubsDtlsVO();
        this.sectorType = null;
        this.subSectorType = "";
        this.hindiSubFlag = false;
        this.subOccupation = new String[]{"00", "01", "02", "03", "04", "06", "99", "07", "08", "09", "10", "11"};
        this.oldNewFormFlag = "";
        this.bankIFSCMICRMandatoryFlag = "";
        this.sectorType = sectorValue;
        if (this.sectorType.equalsIgnoreCase("U")) {
            this.isUnorganizedSector = true;
        }
    }

    public SubsDtlsVO validateSubsDtlsFormat(SubsRegConst pcon) {
        this.pcon = pcon;
        int intcarotcnt = 0;
        boolean boolRecFlag = true;
        pcon.setStrErrInRecord("");
        pcon.setIntSchRecNum(0);
        pcon.setIntNomRecNum(0);
        try {
            int index;
            int intFieldIndex = 0;
            int intLineStart = 0;
            int intLineEnd = 0;
            this.strFileType = pcon.getFileType();
            while ((intLineEnd = pcon.getFileLine().substring(intLineStart).indexOf("^")) >= 0) {
                ++intcarotcnt;
                intLineStart = intLineStart + intLineEnd + 1;
            }
            System.out.println("carat count" + intcarotcnt);
            if (intcarotcnt != 17) {
                this.respgen.genHTML(pcon, "Carat Count", "" + intcarotcnt, "101501");
                boolRecFlag = false;
                this.objSUB.setSubsDtlsErrorFlg(true);
                return this.objSUB;
            }
            Object[] parray = null;
            parray = this.isUnorganizedSector ? new String[195] : new String[168];
            String fieldStr = "";
            boolean boolTempFlag = true;
            intLineEnd = 0;
            intLineStart = 0;
            intFieldIndex = 1;
            boolean minUpld = false;
            boolean boolErrorCodeStopProcess = false;
            String[] sEFCodeDataArray = null;
            while (intLineEnd != -1 && !boolErrorCodeStopProcess) {
                intLineEnd = pcon.getFileLine().substring(intLineStart).indexOf("^");
                if (intLineEnd == -1) {
                    fieldStr = pcon.getFileLine().substring(intLineStart).trim();
                } else {
                    fieldStr = pcon.getFileLine().substring(intLineStart, intLineStart + intLineEnd).trim();
                    intLineStart = intLineStart + intLineEnd + 1;
                }
                switch (intFieldIndex) {
                    case 1: {
                        System.out.println("case 1= " + fieldStr);
                        sEFCodeDataArray = pcon.getFileLine().split("\\^");
                        int length = sEFCodeDataArray.length;
                        if (sEFCodeDataArray.length == length) {
                            this.subSectorType = sEFCodeDataArray[14];
                            if ("C".equalsIgnoreCase(this.subSectorType)) {
                                pcon.setCorpSector(true);
                            }
                        }
                        String preGenFlag = sEFCodeDataArray[16];
                        String minUploadInd = sEFCodeDataArray[17];
                        if ("I".equalsIgnoreCase(preGenFlag) && "0".equalsIgnoreCase(minUploadInd)) {
                            minUpld = true;
                        }
                        if (this.isUnorganizedSector) {
                            pcon.setAck(sEFCodeDataArray[13]);
                        } else {
                            pcon.setAck(sEFCodeDataArray[5]);
                        }
                        boolTempFlag = this.valLineNumber(fieldStr, "Line Number", 1);
                        if (!boolTempFlag) {
                            this.objSUB.setLineNum("0");
                            boolRecFlag = false;
                            pcon.setIntSubsLineNum(0);
                        } else {
                            this.objSUB.setLineNum(fieldStr);
                            pcon.setIntSubsLineNum(Integer.parseInt(fieldStr));
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 2: {
                        System.out.println("case 2 value = " + fieldStr);
                        boolTempFlag = this.valFileSectType(fieldStr, "File Section Type", 2);
                        this.objSUB.setFileSectType(fieldStr);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 3: {
                        System.out.println("case 3 value = " + fieldStr);
                        boolTempFlag = this.valErrorFlgCd(fieldStr, "Error Flag/Code", 3);
                        this.objSUB.setErrorFlagCode(fieldStr);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        } else if (fieldStr.length() == 7) {
                            this.respgen.genHTML(pcon, "Error Flag/Code", fieldStr, "102034");
                            this.boolErrCodeFound = true;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 4: {
                        System.out.println("case 4 value = " + fieldStr);
                        boolTempFlag = this.valRecordNumber(fieldStr, "Record Number", 4);
                        this.objSUB.setRecordNumber(fieldStr);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        } else {
                            pcon.setIntSubsRecNum(Integer.parseInt(fieldStr));
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 5: {
                        boolTempFlag = this.valPreGenPran(fieldStr, "Pre Generated PRAN", 5);
                        this.objSUB.setPreGenPran(fieldStr);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 6: {
                        if (this.isUnorganizedSector) {
                            this.objSUB.setRecptNo(fieldStr);
                        }
                        boolTempFlag = this.valSectorTypeFlag(this.subSectorType, "Sector Type", 89);
                        this.objSUB.setSectorType(this.subSectorType);
                        if (!boolTempFlag) {
                            this.boolErrCodeFound = true;
                        }
                        if (boolTempFlag) {
                            boolTempFlag = this.valAck(fieldStr, pcon.getFieldNameAckOrRecipt(), 6);
                        }
                        this.objSUB.setAck(fieldStr);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 7: {
                        boolTempFlag = this.valFirstName(fieldStr, "First Name", 8);
                        this.objSUB.setFname(fieldStr);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 8: {
                        boolTempFlag = this.valFirstName(fieldStr, "Father's First Name", 11);
                        this.objSUB.setFatherFName(fieldStr);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 9: {
                        boolTempFlag = this.valPAOAIN(fieldStr, "PAO's Reg. No./POP-SP Reg. No.", 14);
                        this.objSUB.setAIN(fieldStr);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 10: {
                        boolTempFlag = this.valDDOTAN(fieldStr, "DDO Reg. No.", 15);
                        this.objSUB.setTAN(fieldStr);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 11: {
                        boolTempFlag = this.valSex(fieldStr, "SEX", 16);
                        this.objSUB.setGender(fieldStr);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 12: {
                        boolTempFlag = this.valDob(fieldStr, "Subscriber Date of Birth", 17);
                        this.objSUB.setDateOfBirth(fieldStr);
                        if (boolTempFlag) {
                            int subAge = this.ageInYear(Integer.parseInt(this.objSUB.getDateOfBirth().substring(4, 8)), Integer.parseInt(this.objSUB.getDateOfBirth().substring(0, 2)), Integer.parseInt(this.objSUB.getDateOfBirth().substring(2, 4)));
                            this.objSUB.setSubAge(subAge);
                        }
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 13: {
                        System.out.println("case 13 value = " + fieldStr);
                        boolTempFlag = this.valNumOfSchemes(fieldStr, "Number Of Schemes", 63);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                            this.objSUB.setSchemeCount(0);
                            pcon.setIntSchRemain(0);
                            pcon.setIntTotSch(0);
                        } else {
                            this.objSUB.setSchemeCount(Integer.parseInt(fieldStr));
                            pcon.setIntSchRemain(Integer.parseInt(fieldStr));
                            pcon.setIntTotSch(Integer.parseInt(fieldStr));
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 14: {
                        if (this.isUnorganizedSector) {
                            if (SubsRegConst.getUtilityLevel() == 1) {
                                if (CRAConfigReader.getConfigVal("CRACENTRAL.FVU.SubsReg.PhotoSigMandatory").equalsIgnoreCase("Y")) {
                                    boolTempFlag = this.valFcProvisionalAck(fieldStr, "FC Provisional Ack No", 68);
                                }
                            } else if (SubsRegConst.getUtilityLevel() == 2 && pcon.getPhotoSigPresent().equalsIgnoreCase("Y")) {
                                boolTempFlag = this.valFcProvisionalAck(fieldStr, "FC Provisional Ack No", 68);
                            }
                            this.objSUB.setFCProvisionalAck(fieldStr);
                            this.strAck = fieldStr;
                        } else {
                            boolTempFlag = this.isFillerField(fieldStr, 14);
                        }
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        } else if (fieldStr != null && !"".equalsIgnoreCase(fieldStr) && this.isUnorganizedSector && this.objSUB.getPRN() == null) {
                            this.objSUB.setPRN(fieldStr.substring(0, 14));
                        }
                        if (this.boolErrCodeFound) {
                            boolErrorCodeStopProcess = true;
                            sEFCodeDataArray = null;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 15: {
                        boolTempFlag = this.valSectorTypeFlag(this.subSectorType, "Sector Type", 89);
                        this.objSUB.setSectorType(fieldStr);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 16: {
                        boolTempFlag = this.valSchPrefOpt("".equalsIgnoreCase(fieldStr) ? "" : fieldStr, "Scheme Type", 90);
                        this.objSUB.setSchPrefOpt(fieldStr);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 17: {
                        boolTempFlag = this.valPreGenPranFlag(fieldStr, "Pre Generated PRAN Flag", 93);
                        this.objSUB.setPreGenPranFlag(fieldStr);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 18: {
                        boolTempFlag = this.valMinUploadInd(fieldStr, "Minimum Upload Indicator", 94);
                        this.objSUB.setMinUploadInd(fieldStr);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    default: {
                        boolRecFlag = false;
                    }
                }
            }
            if (this.isUnorganizedSector) {
                index = 1;
                while (index < 195) {
                    switch (index) {
                        case 1: {
                            parray[index] = String.valueOf(String.valueOf(this.objSUB.getLineNum())) + "^";
                            break;
                        }
                        case 2: {
                            parray[index] = String.valueOf(this.objSUB.getFileSectType()) + "^";
                            break;
                        }
                        case 3: {
                            parray[index] = String.valueOf(this.objSUB.getErrorFlagCode()) + "^";
                            break;
                        }
                        case 4: {
                            parray[index] = String.valueOf(this.objSUB.getRecordNumber()) + "^";
                            break;
                        }
                        case 5: {
                            parray[index] = String.valueOf(this.objSUB.getPreGenPran()) + "^";
                            break;
                        }
                        case 6: {
                            parray[index] = String.valueOf(this.objSUB.getAck()) + "^";
                            break;
                        }
                        case 7: {
                            parray[index] = "TITLE^";
                            break;
                        }
                        case 8: {
                            parray[index] = String.valueOf(this.objSUB.getFname()) + "^";
                            break;
                        }
                        case 11: {
                            parray[index] = String.valueOf(this.objSUB.getFatherFName()) + "^";
                            break;
                        }
                        case 12: {
                            parray[index] = "FATHER LAST NAME^";
                            break;
                        }
                        case 13: {
                            parray[index] = "FATHER MIDDLE NAME^";
                            break;
                        }
                        case 14: {
                            parray[index] = String.valueOf(this.objSUB.getAIN()) + "^";
                            break;
                        }
                        case 15: {
                            parray[index] = String.valueOf(this.objSUB.getTAN()) + "^";
                            break;
                        }
                        case 16: {
                            parray[index] = String.valueOf(this.objSUB.getGender()) + "^";
                            break;
                        }
                        case 17: {
                            parray[index] = String.valueOf(this.objSUB.getDateOfBirth()) + "^";
                            break;
                        }
                        case 19: {
                            parray[index] = "CORR ADDR^";
                            break;
                        }
                        case 22: {
                            parray[index] = "CORR ADDR  CITY^";
                            break;
                        }
                        case 25: {
                            parray[index] = "88^";
                            break;
                        }
                        case 26: {
                            parray[index] = "IN^";
                            break;
                        }
                        case 27: {
                            parray[index] = "888888^";
                            break;
                        }
                        case 28: {
                            parray[index] = "PER ADDR^";
                            break;
                        }
                        case 29: {
                            parray[index] = "PER ADDR2^";
                            break;
                        }
                        case 30: {
                            parray[index] = "PER ADDR3^";
                            break;
                        }
                        case 31: {
                            parray[index] = "PER ADDR  CITY^";
                            break;
                        }
                        case 34: {
                            parray[index] = "88^";
                            break;
                        }
                        case 35: {
                            parray[index] = "IN^";
                            break;
                        }
                        case 36: {
                            parray[index] = "888888^";
                            break;
                        }
                        case 40: {
                            parray[index] = "^";
                            break;
                        }
                        case 41: {
                            parray[index] = "Y^";
                            break;
                        }
                        case 42: {
                            parray[index] = "Y^";
                            break;
                        }
                        case 43: {
                            parray[index] = "^";
                            break;
                        }
                        case 44: {
                            parray[index] = "01012064^";
                            break;
                        }
                        case 45: {
                            if (this.isUnorganizedSector) {
                                parray[index] = "^";
                                break;
                            }
                            System.out.println("LEGACY_SUB_EMP_CLASS Z");
                            parray[index] = "Z^";
                            break;
                        }
                        case 46: {
                            if (this.isUnorganizedSector) {
                                parray[index] = "^";
                                break;
                            }
                            parray[index] = "DEPT^";
                            break;
                        }
                        case 47: {
                            if (this.isUnorganizedSector) {
                                parray[index] = "^";
                                break;
                            }
                            parray[index] = "MINISTRY^";
                            break;
                        }
                        case 48: {
                            if (this.isUnorganizedSector) {
                                parray[index] = "^";
                                break;
                            }
                            parray[index] = "DDO OFFICE^";
                            break;
                        }
                        case 49: {
                            if (this.isUnorganizedSector) {
                                parray[index] = "^";
                                break;
                            }
                            parray[index] = "0^";
                            break;
                        }
                        case 50: {
                            if (this.isUnorganizedSector) {
                                parray[index] = "^";
                                break;
                            }
                            parray[index] = "0^";
                            break;
                        }
                        case 51: {
                            if (this.isUnorganizedSector) {
                                parray[index] = "^";
                                break;
                            }
                            parray[index] = "9999999999999999^";
                            break;
                        }
                        case 52: {
                            parray[index] = "X^";
                            break;
                        }
                        case 53: {
                            parray[index] = "SAVINGS^";
                            break;
                        }
                        case 54: {
                            parray[index] = "123456789^";
                            break;
                        }
                        case 55: {
                            parray[index] = "BANKNAME^";
                            break;
                        }
                        case 62: {
                            parray[index] = "0^";
                            break;
                        }
                        case 63: {
                            parray[index] = String.valueOf(String.valueOf(this.objSUB.getSchemeCount())) + "^";
                            break;
                        }
                        case 64: {
                            if (this.isUnorganizedSector) {
                                parray[index] = "99^";
                                break;
                            }
                            parray[index] = "^";
                            break;
                        }
                        case 65: {
                            parray[index] = "Y^";
                            break;
                        }
                        case 66: {
                            if (this.isUnorganizedSector) {
                                parray[index] = "N^";
                                break;
                            }
                            parray[index] = "^";
                            break;
                        }
                        case 68: {
                            parray[index] = String.valueOf(this.objSUB.getFCProvisionalAck()) + "^";
                            break;
                        }
                        case 69: {
                            parray[index] = "^";
                            break;
                        }
                        case 70: {
                            parray[index] = String.valueOf(this.objSUB.getMotherLName()) + "^";
                            break;
                        }
                        case 71: {
                            parray[index] = String.valueOf(this.objSUB.getMotherMName()) + "^";
                            break;
                        }
                        case 72: {
                            parray[index] = "N^";
                            break;
                        }
                        case 79: {
                            parray[index] = "IFSC0001111^";
                            break;
                        }
                        case 80: {
                            if (this.isUnorganizedSector) {
                                parray[index] = "N^";
                                break;
                            }
                            parray[index] = "^";
                            break;
                        }
                        case 82: {
                            if (this.isUnorganizedSector) {
                                parray[index] = "N^";
                                break;
                            }
                            parray[index] = "^";
                            break;
                        }
                        case 83: {
                            if ("C".equalsIgnoreCase(this.subSectorType)) {
                                parray[index] = "1111111111^";
                                break;
                            }
                            parray[index] = "^";
                            break;
                        }
                        case 89: {
                            parray[index] = String.valueOf(this.objSUB.getSectorType()) + "^";
                            break;
                        }
                        case 90: {
                            parray[index] = String.valueOf(this.objSUB.getSchPrefOpt()) + "^";
                            break;
                        }
                        case 91: {
                            if (this.isUnorganizedSector) {
                                parray[index] = "^";
                                break;
                            }
                            parray[index] = "Z^";
                            break;
                        }
                        case 92: {
                            if (this.isUnorganizedSector) {
                                parray[index] = "^";
                                break;
                            }
                            parray[index] = "^";
                            break;
                        }
                        case 93: {
                            parray[index] = String.valueOf(this.objSUB.getPreGenPranFlag()) + "^";
                            break;
                        }
                        case 94: {
                            parray[index] = String.valueOf(this.objSUB.getMinUploadInd()) + "^";
                            break;
                        }
                        case 95: {
                            parray[index] = "F^";
                            break;
                        }
                        case 96: {
                            parray[index] = "^";
                            break;
                        }
                        case 97: {
                            parray[index] = "^";
                            break;
                        }
                        case 98: {
                            parray[index] = "N^";
                            break;
                        }
                        case 99: {
                            parray[index] = "N^";
                            break;
                        }
                        case 100: {
                            parray[index] = "A^";
                            break;
                        }
                        case 113: {
                            parray[index] = "000^";
                            break;
                        }
                        case 120: {
                            parray[index] = "N^";
                            break;
                        }
                        case 121: {
                            parray[index] = "^";
                            break;
                        }
                        case 131: {
                            parray[index] = "^";
                            break;
                        }
                        case 132: {
                            parray[index] = "A^";
                            break;
                        }
                        case 138: {
                            parray[index] = "XXX^";
                            break;
                        }
                        case 139: {
                            parray[index] = "XX^";
                            break;
                        }
                        case 140: {
                            parray[index] = "^";
                            break;
                        }
                        case 141: {
                            parray[index] = "^";
                            break;
                        }
                        case 143: {
                            parray[index] = "X^";
                            break;
                        }
                        case 144: {
                            parray[index] = "XX^";
                            break;
                        }
                        case 145: {
                            parray[index] = "^";
                            break;
                        }
                        case 146: {
                            parray[index] = "0^";
                            break;
                        }
                        case 147: {
                            parray[index] = "NA^";
                            break;
                        }
                        case 148: {
                            parray[index] = "Y^";
                            break;
                        }
                        case 149: {
                            parray[index] = "Y^";
                            break;
                        }
                        case 150: {
                            parray[index] = "^";
                            break;
                        }
                        case 151: {
                            parray[index] = "^";
                            break;
                        }
                        case 152: {
                            parray[index] = "^";
                            break;
                        }
                        case 153: {
                            parray[index] = "^";
                            break;
                        }
                        case 154: {
                            parray[index] = "^";
                            break;
                        }
                        case 155: {
                            parray[index] = "^";
                            break;
                        }
                        case 157: {
                            parray[index] = "X^";
                            break;
                        }
                        case 158: {
                            parray[index] = "X^";
                            break;
                        }
                        case 159: {
                            parray[index] = "^";
                            break;
                        }
                        case 160: {
                            parray[index] = "^";
                            break;
                        }
                        case 161: {
                            parray[index] = "^";
                            break;
                        }
                        case 162: {
                            parray[index] = "^";
                            break;
                        }
                        case 163: {
                            parray[index] = "^";
                            break;
                        }
                        case 164: {
                            parray[index] = "^";
                            break;
                        }
                        case 165: {
                            parray[index] = "^";
                            break;
                        }
                        case 166: {
                            parray[index] = "^";
                            break;
                        }
                        case 167: {
                            parray[index] = "0^";
                            break;
                        }
                        case 168: {
                            parray[index] = "XX^";
                            break;
                        }
                        case 169: {
                            parray[index] = "^";
                            break;
                        }
                        case 170: {
                            parray[index] = "^";
                            break;
                        }
                        case 171: {
                            parray[index] = "X^";
                            break;
                        }
                        case 172: {
                            parray[index] = "X^";
                            break;
                        }
                        case 173: {
                            parray[index] = "X^";
                            break;
                        }
                        case 174: {
                            parray[index] = "^";
                            break;
                        }
                        case 175: {
                            parray[index] = "^";
                            break;
                        }
                        case 176: {
                            parray[index] = "X^";
                            break;
                        }
                        case 177: {
                            parray[index] = "^";
                            break;
                        }
                        case 178: {
                            parray[index] = "^";
                            break;
                        }
                        case 179: {
                            parray[index] = "X^";
                            break;
                        }
                        case 180: {
                            parray[index] = "X^";
                            break;
                        }
                        case 181: {
                            parray[index] = "^";
                            break;
                        }
                        case 182: {
                            parray[index] = "^";
                            break;
                        }
                        case 183: {
                            parray[index] = "^";
                            break;
                        }
                        case 184: {
                            parray[index] = "^";
                            break;
                        }
                        case 185: {
                            parray[index] = "^";
                            break;
                        }
                        case 186: {
                            parray[index] = "X^";
                            break;
                        }
                        case 187: {
                            parray[index] = "^";
                            break;
                        }
                        case 188: {
                            parray[index] = "^";
                            break;
                        }
                        case 189: {
                            parray[index] = "^";
                            break;
                        }
                        case 190: {
                            parray[index] = "^";
                            break;
                        }
                        case 191: {
                            parray[index] = "^";
                            break;
                        }
                        case 192: {
                            parray[index] = "^";
                            break;
                        }
                        case 193: {
                            parray[index] = "^";
                            break;
                        }
                        case 194: {
                            parray[index] = "^";
                            break;
                        }
                        default: {
                            parray[index] = "^";
                        }
                    }
                    ++index;
                }
            } else {
                index = 1;
                while (index < 168) {
                    switch (index) {
                        case 1: {
                            parray[index] = String.valueOf(String.valueOf(this.objSUB.getLineNum())) + "^";
                            break;
                        }
                        case 2: {
                            parray[index] = String.valueOf(this.objSUB.getFileSectType()) + "^";
                            break;
                        }
                        case 3: {
                            parray[index] = String.valueOf(this.objSUB.getErrorFlagCode()) + "^";
                            break;
                        }
                        case 4: {
                            parray[index] = String.valueOf(this.objSUB.getRecordNumber()) + "^";
                            break;
                        }
                        case 5: {
                            parray[index] = String.valueOf(this.objSUB.getPreGenPran()) + "^";
                            break;
                        }
                        case 6: {
                            parray[index] = String.valueOf(this.objSUB.getAck()) + "^";
                            break;
                        }
                        case 7: {
                            parray[index] = "TITLE^";
                            break;
                        }
                        case 8: {
                            parray[index] = String.valueOf(this.objSUB.getFname()) + "^";
                            break;
                        }
                        case 11: {
                            parray[index] = String.valueOf(this.objSUB.getFatherFName()) + "^";
                            break;
                        }
                        case 12: {
                            parray[index] = "FATHER LAST NAME^";
                            break;
                        }
                        case 13: {
                            parray[index] = "FATHER MIDDLE NAME^";
                            break;
                        }
                        case 14: {
                            parray[index] = String.valueOf(this.objSUB.getAIN()) + "^";
                            break;
                        }
                        case 15: {
                            parray[index] = String.valueOf(this.objSUB.getTAN()) + "^";
                            break;
                        }
                        case 16: {
                            parray[index] = String.valueOf(this.objSUB.getGender()) + "^";
                            break;
                        }
                        case 17: {
                            parray[index] = String.valueOf(this.objSUB.getDateOfBirth()) + "^";
                            break;
                        }
                        case 19: {
                            parray[index] = "^";
                            break;
                        }
                        case 22: {
                            parray[index] = "^";
                            break;
                        }
                        case 25: {
                            parray[index] = "^";
                            break;
                        }
                        case 26: {
                            parray[index] = "^";
                            break;
                        }
                        case 27: {
                            parray[index] = "^";
                            break;
                        }
                        case 28: {
                            parray[index] = "PER ADDR^";
                            break;
                        }
                        case 29: {
                            parray[index] = "PER ADDR2^";
                            break;
                        }
                        case 30: {
                            parray[index] = "PER ADDR3^";
                            break;
                        }
                        case 31: {
                            parray[index] = "PER ADDR  CITY^";
                            break;
                        }
                        case 34: {
                            parray[index] = "88^";
                            break;
                        }
                        case 35: {
                            parray[index] = "IN^";
                            break;
                        }
                        case 36: {
                            parray[index] = "888888^";
                            break;
                        }
                        case 40: {
                            parray[index] = "^";
                            break;
                        }
                        case 41: {
                            parray[index] = "Y^";
                            break;
                        }
                        case 42: {
                            parray[index] = "Y^";
                            break;
                        }
                        case 43: {
                            parray[index] = "01012004^";
                            break;
                        }
                        case 44: {
                            parray[index] = "01012064^";
                            break;
                        }
                        case 45: {
                            parray[index] = "^";
                            break;
                        }
                        case 46: {
                            if (this.isUnorganizedSector) {
                                parray[index] = "^";
                                break;
                            }
                            parray[index] = "DEPT^";
                            break;
                        }
                        case 47: {
                            if (this.isUnorganizedSector) {
                                parray[index] = "^";
                                break;
                            }
                            parray[index] = "MINISTRY^";
                            break;
                        }
                        case 48: {
                            if (this.isUnorganizedSector) {
                                parray[index] = "^";
                                break;
                            }
                            parray[index] = "DDO OFFICE^";
                            break;
                        }
                        case 49: {
                            parray[index] = "^";
                            break;
                        }
                        case 50: {
                            parray[index] = "^";
                            break;
                        }
                        case 51: {
                            if (this.isUnorganizedSector) {
                                parray[index] = "^";
                                break;
                            }
                            parray[index] = "9999999999999999^";
                            break;
                        }
                        case 52: {
                            parray[index] = "X^";
                            break;
                        }
                        case 53: {
                            parray[index] = "SAVINGS^";
                            break;
                        }
                        case 54: {
                            parray[index] = "123456789^";
                            break;
                        }
                        case 55: {
                            parray[index] = "BANKNAME^";
                            break;
                        }
                        case 62: {
                            parray[index] = "0^";
                            break;
                        }
                        case 63: {
                            parray[index] = String.valueOf(String.valueOf(this.objSUB.getSchemeCount())) + "^";
                            break;
                        }
                        case 64: {
                            if (this.isUnorganizedSector) {
                                parray[index] = "99^";
                                break;
                            }
                            parray[index] = "^";
                            break;
                        }
                        case 65: {
                            if (this.isUnorganizedSector) {
                                parray[index] = "Y^";
                                break;
                            }
                            parray[index] = "^";
                            break;
                        }
                        case 66: {
                            if (this.isUnorganizedSector) {
                                parray[index] = "N^";
                                break;
                            }
                            parray[index] = "^";
                            break;
                        }
                        case 68: {
                            parray[index] = String.valueOf(this.objSUB.getFCProvisionalAck()) + "^";
                            break;
                        }
                        case 69: {
                            parray[index] = "^";
                            break;
                        }
                        case 70: {
                            parray[index] = String.valueOf(this.objSUB.getMotherLName()) + "^";
                            break;
                        }
                        case 71: {
                            parray[index] = String.valueOf(this.objSUB.getMotherMName()) + "^";
                            break;
                        }
                        case 72: {
                            parray[index] = "N^";
                            break;
                        }
                        case 79: {
                            parray[index] = "IFSC0001111^";
                            break;
                        }
                        case 80: {
                            parray[index] = "N^";
                            break;
                        }
                        case 82: {
                            parray[index] = "^";
                            break;
                        }
                        case 83: {
                            if ("C".equalsIgnoreCase(this.subSectorType)) {
                                parray[index] = "1111111111^";
                                break;
                            }
                            parray[index] = "^";
                            break;
                        }
                        case 89: {
                            parray[index] = "^";
                            break;
                        }
                        case 90: {
                            parray[index] = String.valueOf(this.objSUB.getSchPrefOpt()) + "^";
                            break;
                        }
                        case 92: {
                            if (this.isUnorganizedSector) {
                                parray[index] = "^";
                                break;
                            }
                            parray[index] = "^";
                            break;
                        }
                        case 93: {
                            parray[index] = String.valueOf(this.objSUB.getPreGenPranFlag()) + "^";
                            break;
                        }
                        case 94: {
                            parray[index] = String.valueOf(this.objSUB.getMinUploadInd()) + "^";
                            break;
                        }
                        case 95: {
                            parray[index] = "F^";
                            break;
                        }
                        case 96: {
                            parray[index] = "^";
                            break;
                        }
                        case 97: {
                            parray[index] = "^";
                            break;
                        }
                        case 99: {
                            parray[index] = "N^";
                            break;
                        }
                        case 100: {
                            parray[index] = "A^";
                            break;
                        }
                        case 103: {
                            parray[index] = "555^";
                            break;
                        }
                        case 113: {
                            parray[index] = "000^";
                            break;
                        }
                        case 117: {
                            parray[index] = "^";
                            break;
                        }
                        case 118: {
                            parray[index] = "^";
                            break;
                        }
                        case 119: {
                            parray[index] = "A^";
                            break;
                        }
                        case 120: {
                            if (this.isUnorganizedSector) {
                                parray[index] = "N^";
                                break;
                            }
                            parray[index] = "^";
                            break;
                        }
                        case 121: {
                            parray[index] = "Y^";
                            break;
                        }
                        case 122: {
                            parray[index] = "NA^";
                            break;
                        }
                        case 125: {
                            parray[index] = "XXX^";
                            break;
                        }
                        case 126: {
                            parray[index] = "XX^";
                            break;
                        }
                        case 127: {
                            parray[index] = "^";
                            break;
                        }
                        case 128: {
                            parray[index] = "^";
                            break;
                        }
                        case 130: {
                            parray[index] = "X^";
                            break;
                        }
                        case 131: {
                            parray[index] = "XX^";
                            break;
                        }
                        case 132: {
                            parray[index] = "0^";
                            break;
                        }
                        case 133: {
                            parray[index] = "Y^";
                            break;
                        }
                        case 135: {
                            parray[index] = "X^";
                            break;
                        }
                        case 136: {
                            parray[index] = "X^";
                            break;
                        }
                        case 137: {
                            parray[index] = "^";
                            break;
                        }
                        case 138: {
                            parray[index] = "^";
                            break;
                        }
                        case 139: {
                            parray[index] = "^";
                            break;
                        }
                        case 140: {
                            parray[index] = "^";
                            break;
                        }
                        case 141: {
                            parray[index] = "^";
                            break;
                        }
                        case 142: {
                            parray[index] = "^";
                            break;
                        }
                        case 143: {
                            parray[index] = "XX^";
                            break;
                        }
                        case 144: {
                            parray[index] = "^";
                            break;
                        }
                        case 145: {
                            parray[index] = "^";
                            break;
                        }
                        case 146: {
                            parray[index] = "X^";
                            break;
                        }
                        case 147: {
                            parray[index] = "X^";
                            break;
                        }
                        case 148: {
                            parray[index] = "^";
                            break;
                        }
                        case 149: {
                            parray[index] = "X^";
                            break;
                        }
                        case 150: {
                            parray[index] = "^";
                            break;
                        }
                        case 151: {
                            parray[index] = "X^";
                            break;
                        }
                        case 152: {
                            parray[index] = "^";
                            break;
                        }
                        case 153: {
                            parray[index] = "^";
                            break;
                        }
                        case 154: {
                            parray[index] = "^";
                            break;
                        }
                        case 155: {
                            parray[index] = "X^";
                            break;
                        }
                        case 156: {
                            parray[index] = "^";
                            break;
                        }
                        case 157: {
                            parray[index] = "^";
                            break;
                        }
                        case 158: {
                            parray[index] = "^";
                            break;
                        }
                        case 159: {
                            parray[index] = "^";
                            break;
                        }
                        case 160: {
                            parray[index] = "^";
                            break;
                        }
                        case 161: {
                            parray[index] = "^";
                            break;
                        }
                        case 162: {
                            parray[index] = "XX^";
                            break;
                        }
                        case 163: {
                            parray[index] = "^";
                            break;
                        }
                        case 164: {
                            parray[index] = "^";
                            break;
                        }
                        case 165: {
                            parray[index] = "^";
                            break;
                        }
                        case 166: {
                            parray[index] = "^";
                            break;
                        }
                        case 167: {
                            parray[index] = "^";
                            break;
                        }
                        default: {
                            parray[index] = "^";
                        }
                    }
                    ++index;
                }
            }
            String str = Arrays.toString(parray);
            str = str.substring(1, str.length() - 1);
            str = str.replaceAll("(?i)null", "");
            str = str.toString().replaceAll(", ", "");
            pcon.setFileLine("");
            pcon.setFileLine(str);
            if (SubsRegConst.getUtilityLevel() == 1) {
                if (boolRecFlag) {
                    String strRec;
                    if (CRAConfigReader.getConfigVal("CRACENTRAL.FVU.SubsReg.PhotoSigMandatory").equalsIgnoreCase("Y")) {
                        strRec = pcon.getFileLine();
                        strRec = String.valueOf(strRec) + "FECDBA987654321" + "^" + "FECDBA987654321" + "^" + "FECDBA987654321" + "^" + "Y";
                        pcon.setFileLine(strRec);
                    } else {
                        strRec = pcon.getFileLine();
                        strRec = String.valueOf(strRec) + "FECDBA987654321" + "^" + "FECDBA987654321" + "^" + "FECDBA987654321" + "^" + "N";
                        pcon.setFileLine(strRec);
                    }
                    if (this.addPhotoSig()) {
                        if (this.addHash(pcon.getFileLine())) {
                            this.objWRecord.writeRecord(pcon.getFileLine(), pcon.getStrFilePath(), pcon.getStrUploadDirPath());
                            this.objSUB.setSubsDtlsErrorFlg(false);
                            return this.objSUB;
                        }
                        this.objSUB.setSubsDtlsErrorFlg(true);
                        return this.objSUB;
                    }
                    this.objSUB.setSubsDtlsErrorFlg(true);
                    return this.objSUB;
                }
                this.objSUB.setSubsDtlsErrorFlg(!boolRecFlag);
                return this.objSUB;
            }
            this.objSUB.setSubsDtlsErrorFlg(!boolRecFlag);
            return this.objSUB;
        }
        catch (Exception e) {
            this.objSUB.setSubsDtlsErrorFlg(true);
            return this.objSUB;
        }
    }

    public boolean valFileSectType(String fieldStr, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        try {
            if (!fieldStr.equals("FD")) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "102021");
                return boolTemp;
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valSex(String fieldStr, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnCode);
        try {
            if (!(fieldStr.equals("M") || fieldStr.equals("F") || fieldStr.equals("T"))) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "1");
                return boolTemp;
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valRecordNumber(String fieldStr, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnCode);
        try {
            boolTemp = this.valFieldBasics(fieldStr, 6, SubsRegConst.getMandatoryValue(), strColumnName, intColumnCode);
            if (!this.isNumber(fieldStr)) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "3");
                return boolTemp;
            }
            if (Integer.parseInt(fieldStr) == 0) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "4");
                return boolTemp;
            }
            if (Integer.parseInt(fieldStr) != this.pcon.getIntSubsRecNum() + 1) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "5");
                return boolTemp;
            }
            if (fieldStr.length() < 6) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "6");
                return boolTemp;
            }
            if (Integer.parseInt(fieldStr) > Integer.parseInt(this.pcon.getBatchCnt())) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "7");
                return boolTemp;
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valPAOAIN(String fieldStr, String strColumnName, int intColumnCode) {
        ArrayList<String> errorList;
        boolean boolTemp;
        block9: {
            block8: {
                boolTemp = true;
                errorList = new ArrayList<String>();
                try {
                    if (this.isUnorganizedSector) {
                        strColumnName = "POP-SP / CBO Reg. No.";
                        errorList.add(0, "102145");
                        errorList.add(1, "102146");
                        errorList.add(2, "102147");
                        errorList.add(3, "102148");
                    } else {
                        errorList.add(0, "102141");
                        errorList.add(1, "102142");
                        errorList.add(2, "102143");
                        errorList.add(3, "102144");
                    }
                    if (!fieldStr.equals("")) break block8;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, ((String)errorList.get(0)).toString());
                    return false;
                }
                catch (Exception e) {
                    boolTemp = false;
                    return boolTemp;
                }
            }
            if (fieldStr.length() == 7) break block9;
            this.respgen.genHTML(this.pcon, strColumnName, fieldStr, ((String)errorList.get(1)).toString());
            return false;
        }
        if (!this.isNumber(fieldStr)) {
            boolTemp = false;
            this.respgen.genHTML(this.pcon, strColumnName, fieldStr, ((String)errorList.get(2)).toString());
        }
        if (boolTemp && CommonValidation.checkID(fieldStr)) {
            boolTemp = false;
            this.respgen.genHTML(this.pcon, strColumnName, fieldStr, ((String)errorList.get(3)).toString());
        }
        return boolTemp;
    }

    public boolean valAck(String strAck, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        boolean oldFormat = false;
        String strErrCode = this.getErrorCode(intColumnCode);
        try {
            if (!this.subSectorType.equalsIgnoreCase("C") || !strAck.equalsIgnoreCase("")) {
                boolTemp = this.valFieldBasics(strAck.trim(), 17, SubsRegConst.getMandatoryValue(), strColumnName, intColumnCode);
                if (!this.isNumber(strAck)) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, strAck, String.valueOf(strErrCode) + "3");
                    return boolTemp;
                }
                if (Long.parseLong(strAck) == 0L) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, strAck, String.valueOf(strErrCode) + "4");
                    return boolTemp;
                }
                if (strAck.length() < 17) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, strAck, String.valueOf(strErrCode) + "2");
                    return boolTemp;
                }
                if (strAck.substring(5, 6).equals("0")) {
                    oldFormat = true;
                }
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valBankMICR(String fieldStr, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnCode);
        try {
            boolTemp = this.valFieldBasics(fieldStr, 9, SubsRegConst.getOptionalValue(), strColumnName, intColumnCode);
            if (!this.isNumber(fieldStr)) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "3");
                return boolTemp;
            }
            if (!fieldStr.equals("") && Long.parseLong(fieldStr) == 0L) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "4");
                return boolTemp;
            }
            if (fieldStr != null && !fieldStr.equals("") && fieldStr.length() < 9) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "2");
                return boolTemp;
            }
        }
        catch (Exception e) {
            boolTemp = false;
            this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "4");
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valNumOfNom(String fieldStr, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnCode);
        try {
            if (fieldStr.equals("")) {
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "1");
            }
            if (!(fieldStr.equals("0") || fieldStr.equals("1") || fieldStr.equals("2") || fieldStr.equals("3"))) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "2");
                return boolTemp;
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valNumOfSchemes(String fieldStr, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnCode);
        try {
            if (fieldStr.equals("")) {
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "1");
            }
            if (!this.isNumber(fieldStr)) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "5");
                return boolTemp;
            }
            if (Integer.parseInt(fieldStr) > 100) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "2");
                return boolTemp;
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valPAOId(String strField, String strColumnName, int intColumnCode) {
        boolean boolFlag = true;
        try {
            if (strField.length() != 7) {
                boolFlag = false;
                this.respgen.genHTML(this.pcon, strColumnName, strField, String.valueOf(this.strFileType) + "102092");
                return boolFlag;
            }
            long longField = Long.parseLong(strField);
            if (longField <= 0L) {
                boolFlag = false;
                this.respgen.genHTML(this.pcon, strColumnName, strField, String.valueOf(this.strFileType) + "102093");
                return boolFlag;
            }
        }
        catch (NumberFormatException nfe) {
            boolFlag = false;
            this.respgen.genHTML(this.pcon, strColumnName, strField, String.valueOf(this.strFileType) + "102091");
            return boolFlag;
        }
        catch (Exception e) {
            boolFlag = false;
            return boolFlag;
        }
        return boolFlag;
    }

    public boolean valErrorFlgCd(String fieldStr, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnCode);
        try {
            boolTemp = this.valFieldBasics(fieldStr, 7, SubsRegConst.getMandatoryValue(), strColumnName, intColumnCode);
            if (fieldStr.length() != 1 && fieldStr.length() != 7) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "3");
            } else if (fieldStr.length() == 7) {
                if (!fieldStr.substring(0, 3).equals("SEF") || !this.isNumber(fieldStr.substring(3, 7))) {
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "5");
                    boolTemp = false;
                } else {
                    boolean valid = this.respgen.checkValidErrorCodeForSub(fieldStr);
                    if (!valid) {
                        this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "5");
                        boolTemp = false;
                    }
                }
            } else if (fieldStr.length() == 1 && !fieldStr.trim().equals("N")) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "5");
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public SubsRegFileVO valDupACKInFile(SubsRegFileVO fileVO, SubsRegConst pcon) {
        ArrayList<Object> arlSubList = new ArrayList();
        arlSubList = fileVO.getSubList();
        String errorCode = "";
        int i = 0;
        while (i < arlSubList.size()) {
            String prevAck = ((SubsDtlsVO)arlSubList.get(i)).getAck();
            pcon.setLineCntr(Integer.parseInt(((SubsDtlsVO)arlSubList.get(i)).getLineNum()));
            if (fileVO.getTransType().equalsIgnoreCase("R")) {
                pcon.setAck(prevAck);
                errorCode = "109102";
            } else {
                pcon.setAck(((SubsDtlsVO)arlSubList.get(i)).getFCProvisionalAck());
                errorCode = "105055";
            }
            int j = 0;
            while (j < i) {
                String currAck = ((SubsDtlsVO)arlSubList.get(j)).getAck();
                if (!currAck.equalsIgnoreCase("") && currAck.equalsIgnoreCase(prevAck)) {
                    ((SubsDtlsVO)arlSubList.get(i)).setBoolDupAckExists(true);
                    fileVO.setSubsRegFileErrorFlg(true);
                    fileVO.setSubsRegErrorCode(errorCode);
                    this.respgen.genHTML(pcon, pcon.getFieldNameAckOrRecipt(), currAck, errorCode);
                    break;
                }
                ++j;
            }
            ++i;
        }
        fileVO.setSubList(arlSubList);
        return fileVO;
    }

    @Override
    public String getErrorForm() {
        return "102";
    }

    @Override
    public boolean isFillerField(String fieldStr, int intColumnCode) {
        boolean boolTemp = true;
        if (fieldStr != null && !fieldStr.trim().equals("")) {
            boolTemp = false;
            this.respgen.genHTML(this.pcon, intColumnCode + "_Filler Field", fieldStr, "109126");
        }
        return boolTemp;
    }

    private boolean valFcProvisionalAck(String strAck, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnCode);
        try {
            boolTemp = this.valFieldBasics(strAck.trim(), 17, SubsRegConst.getMandatoryValue(), strColumnName, intColumnCode);
            if (!this.isNumber(strAck)) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strAck, String.valueOf(strErrCode) + "3");
                return boolTemp;
            }
            if (Long.parseLong(strAck) == 0L) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strAck, String.valueOf(strErrCode) + "4");
                return boolTemp;
            }
            if (strAck.length() < 17) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strAck, String.valueOf(strErrCode) + "2");
                return boolTemp;
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public SubsRegFileVO valDupPANInFile(SubsRegFileVO fileVO) {
        ArrayList<Object> arlSubList = new ArrayList();
        arlSubList = fileVO.getSubList();
        HashSet<String> panSubHS = new HashSet<String>();
        int i = 0;
        while (i < arlSubList.size()) {
            String subPAN = ((SubsDtlsVO)arlSubList.get(i)).getPAN();
            this.pcon.setLineCntr(Integer.parseInt(((SubsDtlsVO)arlSubList.get(i)).getLineNum()));
            if (subPAN != null && !subPAN.trim().equals("") && !panSubHS.add(subPAN)) {
                ((SubsDtlsVO)arlSubList.get(i)).setBoolDupPANExists(true);
            }
            ++i;
        }
        fileVO.setSubList(arlSubList);
        return fileVO;
    }

    public SubsRegFileVO valDupFCProvisnalAck(SubsRegFileVO fileVO, SubsRegConst pcon) {
        ArrayList<Object> arlSubList = new ArrayList();
        arlSubList = fileVO.getSubList();
        HashSet<String> fcAckSubHS = new HashSet<String>();
        int i = 0;
        while (i < arlSubList.size()) {
            String subFCProvAck = ((SubsDtlsVO)arlSubList.get(i)).getFCProvisionalAck();
            pcon.setLineCntr(Integer.parseInt(((SubsDtlsVO)arlSubList.get(i)).getLineNum()));
            pcon.setAck(subFCProvAck);
            if (subFCProvAck != null && !subFCProvAck.trim().equals("") && !fcAckSubHS.add(subFCProvAck)) {
                fileVO.setSubsRegFileErrorFlg(true);
                fileVO.setSubsRegErrorCode("102686");
                this.respgen.genHTML(pcon, "FC Provisional Ack No", subFCProvAck, "102686");
            }
            ++i;
        }
        fileVO.setSubList(arlSubList);
        return fileVO;
    }

    public boolean valCombinedFormFlagMinData(String strFieldVal, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        try {
            if (!strFieldVal.equalsIgnoreCase("N") && this.isUnorganizedSector) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strFieldVal, "102745");
                return boolTemp;
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valSectorTypeFlag(String strFieldVal, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnCode);
        if (strFieldVal.equals("")) {
            boolTemp = false;
            this.respgen.genHTML(this.pcon, strColumnName, strFieldVal, String.valueOf(strErrCode) + "1");
            return boolTemp;
        }
        if (this.isUnorganizedSector) {
            if (!strFieldVal.equalsIgnoreCase("U") && !strFieldVal.equalsIgnoreCase("C")) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strFieldVal, String.valueOf(strErrCode) + "2");
                return boolTemp;
            }
        } else if (!strFieldVal.equalsIgnoreCase("O")) {
            boolTemp = false;
            this.respgen.genHTML(this.pcon, strColumnName, strFieldVal, String.valueOf(strErrCode) + "3");
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valSchPrefOpt(String strFieldVal, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnCode);
        boolTemp = this.valFieldBasics(strFieldVal, 1, SubsRegConst.getMandatoryValue(), strColumnName, intColumnCode);
        if (boolTemp && !this.isListConstainsValue(VALID_VALUES_SCH_PREF_OPTION, strFieldVal)) {
            this.respgen.genHTML(this.pcon, strColumnName, strFieldVal, String.valueOf(strErrCode) + "3");
            boolTemp = false;
        }
        this.pcon.isStandardSchPrefOpt = "S".equalsIgnoreCase(strFieldVal) || "C".equalsIgnoreCase(strFieldVal) || "".equalsIgnoreCase(strFieldVal);
        System.out.println("Standard Sch Pref :: " + this.pcon.isStandardSchPrefOpt);
        if (boolTemp && this.pcon.isStandardSchPrefOpt && !"".equalsIgnoreCase(strFieldVal)) {
            this.respgen.genHTML(this.pcon, strColumnName, strFieldVal, String.valueOf(strErrCode) + "6");
        } else if (boolTemp && "".equalsIgnoreCase(strFieldVal)) {
            this.respgen.genHTML(this.pcon, strColumnName, "", String.valueOf(strErrCode) + "7");
        }
        if (boolTemp && ("A".equalsIgnoreCase(strFieldVal) || "V".equalsIgnoreCase(strFieldVal) || "H".equalsIgnoreCase(strFieldVal) || "L".equalsIgnoreCase(strFieldVal) || "B".equalsIgnoreCase(strFieldVal)) && this.objSUB.getSchemeCount() == 0) {
            boolTemp = false;
            this.respgen.genHTML(this.pcon, strColumnName, strFieldVal, String.valueOf(strErrCode) + "5");
        }
        return boolTemp;
    }

    public boolean valPreGenPranFlag(String strFieldVal, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnCode);
        boolTemp = this.valFieldBasics(String.valueOf(strFieldVal), 1, SubsRegConst.getMandatoryValue(), strColumnName, intColumnCode);
        if (!this.isListConstainsValue(VALID_VALUES_PRE_GEN_FLAG, strFieldVal)) {
            boolTemp = false;
            this.respgen.genHTML(this.pcon, strColumnName, strFieldVal, String.valueOf(strErrCode) + "3");
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valPreGenPran(String strFieldVal, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnCode);
        if (!this.isNumber(strFieldVal)) {
            boolTemp = false;
            this.respgen.genHTML(this.pcon, strColumnName, strFieldVal, String.valueOf(strErrCode) + "4");
            return boolTemp;
        }
        if (strFieldVal != null && !"".equalsIgnoreCase(strFieldVal) && Long.parseLong(strFieldVal) == 0L) {
            boolTemp = false;
            this.respgen.genHTML(this.pcon, strColumnName, strFieldVal, String.valueOf(strErrCode) + "3");
            return boolTemp;
        }
        if (strFieldVal != null && !"".equalsIgnoreCase(strFieldVal) && strFieldVal.length() != 12) {
            boolTemp = false;
            this.respgen.genHTML(this.pcon, strColumnName, strFieldVal, String.valueOf(strErrCode) + "2");
            return boolTemp;
        }
        if (!(strFieldVal == null || "".equalsIgnoreCase(strFieldVal) || NCRMod11Algorithm.isValidNumber(strFieldVal) || CommonValidation.isInt(strFieldVal))) {
            boolTemp = false;
            this.respgen.genHTML(this.pcon, strColumnName, strFieldVal, String.valueOf(strErrCode) + "3");
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valMinUploadInd(String strFieldVal, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnCode);
        boolTemp = this.valFieldBasics(strFieldVal, 1, SubsRegConst.getMandatoryValue(), strColumnName, intColumnCode);
        if (!this.isListConstainsValue(VALID_VALUES_MIN_UPLD_INDICATOR, strFieldVal)) {
            boolTemp = false;
            this.respgen.genHTML(this.pcon, strColumnName, String.valueOf(strFieldVal), String.valueOf(strErrCode) + "3");
            return boolTemp;
        }
        return boolTemp;
    }

    public SubsRegFileVO valDupPRANInFile(SubsRegFileVO fileVO, SubsRegConst pcon) {
        ArrayList<Object> arlSubList = new ArrayList();
        arlSubList = fileVO.getSubList();
        String errorCode = "";
        int i = 0;
        while (i < arlSubList.size()) {
            String prevPRAN = ((SubsDtlsVO)arlSubList.get(i)).getPreGenPran();
            pcon.setLineCntr(Integer.parseInt(((SubsDtlsVO)arlSubList.get(i)).getLineNum()));
            if (fileVO.getTransType().equalsIgnoreCase("U") || fileVO.getTransType().equalsIgnoreCase("R")) {
                pcon.setAck(prevPRAN);
                errorCode = "105124";
            }
            int j = 0;
            while (j < i) {
                String currPRAN = ((SubsDtlsVO)arlSubList.get(j)).getPreGenPran();
                if (!currPRAN.equalsIgnoreCase("") && currPRAN.equalsIgnoreCase(prevPRAN)) {
                    ((SubsDtlsVO)arlSubList.get(i)).setBoolDupAckExists(true);
                    fileVO.setSubsRegFileErrorFlg(true);
                    fileVO.setSubsRegErrorCode(errorCode);
                    this.respgen.genHTML(pcon, "PRE-GEN PRAN", currPRAN, errorCode);
                    break;
                }
                ++j;
            }
            ++i;
        }
        fileVO.setSubList(arlSubList);
        return fileVO;
    }

    public boolean valDDOTAN(String fieldStr, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnCode);
        try {
            if (this.isUnorganizedSector) {
                boolTemp = this.isFillerField(fieldStr, intColumnCode);
            } else {
                boolTemp = this.valFieldBasics(fieldStr, 10, SubsRegConst.getMandatoryValue(), strColumnName, intColumnCode);
                if (boolTemp) {
                    if (fieldStr.length() < 10) {
                        boolTemp = false;
                        this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "3");
                        return boolTemp;
                    }
                    if (boolTemp && CommonValidation.checkTan(fieldStr)) {
                        boolTemp = false;
                        this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "3");
                        return boolTemp;
                    }
                }
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public SubsRegFileVO valDupUIDInFile(SubsRegFileVO fileVO, SubsRegConst pcon) {
        ArrayList<SubsDtlsVO> arlSubList = new ArrayList();
        arlSubList = fileVO.getSubList();
        String errorCode = "";
        fileVO.setSubList(arlSubList);
        return fileVO;
    }

    public boolean valDob(String strDob, String strColumnName, int intColumnNum) {
        boolean boolTemp;
        block7: {
            boolTemp = true;
            Date curDate = new Date();
            SimpleDateFormat dformat = new SimpleDateFormat("MMddyyyy");
            Date dtDOB = null;
            String strErrCode = this.getErrorCode(intColumnNum);
            boolTemp = intColumnNum == 136 && ("C".equalsIgnoreCase(this.subSectorType) || "U".equalsIgnoreCase(this.subSectorType)) ? this.valFieldBasics(strDob.trim(), 8, SubsRegConst.getMandatoryValue(), strColumnName, intColumnNum) : (intColumnNum == 136 && "R".equalsIgnoreCase(this.subSectorType) ? this.valFieldBasics(strDob.trim(), 8, SubsRegConst.getOptionalValue(), strColumnName, intColumnNum) : this.valFieldBasics(strDob.trim(), 8, SubsRegConst.getMandatoryValue(), strColumnName, intColumnNum));
            try {
                if (!boolTemp) break block7;
                try {
                    dtDOB = dformat.parse(strDob);
                }
                catch (Exception e) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, strDob, String.valueOf(strErrCode) + "3");
                    return boolTemp;
                }
                if (strDob.length() < 8) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, strDob, String.valueOf(strErrCode) + "2");
                    return boolTemp;
                }
                if (!this.isDate(strDob)) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, strDob, String.valueOf(strErrCode) + "3");
                    return boolTemp;
                }
                if (curDate.before(dtDOB)) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, strDob, String.valueOf(strErrCode) + "4");
                    return boolTemp;
                }
            }
            catch (Exception e) {
                boolTemp = false;
                return boolTemp;
            }
        }
        return boolTemp;
    }
}

