/*
 * Decompiled with CFR 0.152.
 */
package com.cra.sim.validator.photoSigMod.format;

import com.cra.common.reg.util.CRAConfigReader;
import com.cra.common.reg.util.encrypt.NCRMod11Algorithm;
import com.cra.framework.reg.vo.SessionVO;
import com.cra.sim.util.ReadRecord;
import com.cra.sim.util.SubsRegConst;
import com.cra.sim.util.WriteRecord;
import com.cra.sim.validator.regn.format.SubsDtlsFormatValidator;
import com.cra.sim.vo.PhotoSigModDtlsVO;
import com.cra.sim.vo.SubsRegFileVO;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;

public class PhotoSigModFormatValidator
extends SubsDtlsFormatValidator {
    WriteRecord objWRecord = new WriteRecord();
    ReadRecord objRRecord = null;
    String strFileType = "";
    String strTypeOfChange = "";
    String subSectorType = "";

    public PhotoSigModFormatValidator(SessionVO sessVO) {
        super(sessVO);
        this.objRRecord = new ReadRecord(sessVO);
    }

    public PhotoSigModFormatValidator(SessionVO sessVO, String transType) {
        super(sessVO, transType);
        if (transType.equalsIgnoreCase("U")) {
            this.isUnorganizedSector = true;
        }
        this.objRRecord = new ReadRecord(sessVO);
    }

    public PhotoSigModDtlsVO validatePSModFormat(SubsRegConst pcon) {
        this.pcon = pcon;
        int intcarotcnt = 0;
        boolean boolRecFlag = true;
        boolean boolErrorCodeStopProcess = false;
        boolean boolErrCodeFound = false;
        PhotoSigModDtlsVO objPSModDtls = new PhotoSigModDtlsVO();
        pcon.setStrErrInRecord("");
        try {
            int intFieldIndex = 0;
            int intLineStart = 0;
            int intLineEnd = 0;
            this.strFileType = pcon.getFileType();
            while ((intLineEnd = pcon.getFileLine().substring(intLineStart).indexOf("^")) >= 0) {
                ++intcarotcnt;
                intLineStart = intLineStart + intLineEnd + 1;
            }
            if (!this.isUnorganizedSector && intcarotcnt != 14) {
                this.respgen.genHTML(pcon, "Carat Count", "" + intcarotcnt, "101509");
                boolRecFlag = false;
                objPSModDtls.setPSModDtlsErrorFlg(true);
                return objPSModDtls;
            }
            if (this.isUnorganizedSector && intcarotcnt != 16) {
                System.out.println("carat count invalid");
                this.respgen.genHTML(pcon, "Carat Count", "" + intcarotcnt, "101509");
                boolRecFlag = false;
                objPSModDtls.setPSModDtlsErrorFlg(true);
                return objPSModDtls;
            }
            String fieldStr = "";
            boolean boolTempFlag = true;
            String[] sEFCodeDataArray = null;
            intLineEnd = 0;
            intLineStart = 0;
            intFieldIndex = 1;
            block22: while (intLineEnd != -1 && !boolErrorCodeStopProcess) {
                intLineEnd = pcon.getFileLine().substring(intLineStart).indexOf("^");
                if (intLineEnd == -1) {
                    fieldStr = pcon.getFileLine().substring(intLineStart).trim();
                } else {
                    fieldStr = pcon.getFileLine().substring(intLineStart, intLineStart + intLineEnd).trim();
                    intLineStart = intLineStart + intLineEnd + 1;
                }
                switch (intFieldIndex) {
                    case 1: {
                        System.out.println("case 1");
                        sEFCodeDataArray = pcon.getFileLine().split("\\^");
                        if (sEFCodeDataArray.length == 17) {
                            System.out.println("sEFCodeDataArray[sEFCodeDataArray.length] = " + sEFCodeDataArray.length);
                            this.subSectorType = sEFCodeDataArray[16];
                        }
                        if (this.isUnorganizedSector) {
                            pcon.setAck(sEFCodeDataArray[15]);
                        } else {
                            pcon.setAck(sEFCodeDataArray[4]);
                        }
                        boolTempFlag = this.valLineNumber(fieldStr, "Line Number", 1);
                        if (!boolTempFlag) {
                            objPSModDtls.setLineNum("0");
                            boolRecFlag = false;
                            pcon.setIntSubsLineNum(0);
                        } else {
                            objPSModDtls.setLineNum(fieldStr);
                            pcon.setIntSubsLineNum(Integer.parseInt(fieldStr));
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 2: {
                        System.out.println("case 2");
                        boolTempFlag = this.valFileSectType(fieldStr, "File Section Type", 2);
                        objPSModDtls.setFileSectType(fieldStr);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 3: {
                        System.out.println("case 3");
                        boolTempFlag = this.valErrorFlgCd(fieldStr, "Error Flag/Code", 3);
                        objPSModDtls.setErrorFlagCode(fieldStr);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        } else if (fieldStr.length() == 7) {
                            this.respgen.genHTML(pcon, "Error Flag/Code", fieldStr, "102034");
                            boolErrCodeFound = true;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 4: {
                        System.out.println("case 4");
                        boolTempFlag = this.valRecordNumber(fieldStr, "Record Number", 4);
                        objPSModDtls.setRecordNumber(fieldStr);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        } else {
                            pcon.setIntSubsRecNum(Integer.parseInt(fieldStr));
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 5: {
                        System.out.println("in case 5" + fieldStr);
                        if (this.isUnorganizedSector) {
                            objPSModDtls.setReceiptNumber(fieldStr);
                            boolTempFlag = this.valSectorTypeFlag(this.subSectorType, "Sector Type");
                            if (!boolTempFlag) {
                                boolErrCodeFound = true;
                            }
                        } else {
                            objPSModDtls.setFcProvAck(fieldStr);
                            this.strAck = fieldStr;
                        }
                        if (boolTempFlag) {
                            boolTempFlag = this.valAck(fieldStr, pcon.getFieldNameAckOrRecipt(), 5);
                        }
                        objPSModDtls.setSectorType(this.subSectorType);
                        objPSModDtls.setAck(fieldStr);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 6: {
                        boolTempFlag = this.valTitle(fieldStr, "Title", 6);
                        objPSModDtls.setTitle(fieldStr);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 7: {
                        boolTempFlag = this.valFirstName(fieldStr, "First Name", 7);
                        objPSModDtls.setFname(fieldStr);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 8: {
                        boolTempFlag = this.valLastName(fieldStr, "Last Name", 8);
                        objPSModDtls.setLname(fieldStr);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 9: {
                        boolTempFlag = this.valMiddleName(fieldStr, "Middle Name", 9);
                        objPSModDtls.setMname(fieldStr);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        if (boolErrCodeFound && !this.isUnorganizedSector) {
                            boolErrorCodeStopProcess = true;
                        }
                        if (!boolErrCodeFound || !this.isUnorganizedSector) continue block22;
                        if (sEFCodeDataArray != null && sEFCodeDataArray.length < 16) {
                            this.respgen.genHTML(pcon, "Carat Count", "" + intcarotcnt, "101509");
                            boolRecFlag = false;
                            objPSModDtls.setPSModDtlsErrorFlg(true);
                            return objPSModDtls;
                        }
                        intFieldIndex = 16;
                        break;
                    }
                    case 10: {
                        boolTempFlag = this.valPAOAIN(fieldStr, "PAO's Reg. No.", 10);
                        objPSModDtls.setAIN(fieldStr);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 11: {
                        boolTempFlag = this.valDDOTAN(fieldStr, "DDO Reg. No.", 11);
                        objPSModDtls.setTAN(fieldStr);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 12: {
                        boolTempFlag = this.valPRAN(fieldStr, "PRAN", 12);
                        objPSModDtls.setPRAN(fieldStr);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 13: {
                        boolTempFlag = this.valTypeOfChange(fieldStr, "Type Of Change", 13);
                        objPSModDtls.setTypeOfChange(fieldStr);
                        this.strTypeOfChange = fieldStr.toUpperCase();
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 14: {
                        boolTempFlag = this.valReasonForChangeInPhoto(fieldStr, "Reason For Change in Photo", 14);
                        objPSModDtls.setReasonOfChangePhoto(fieldStr);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 15: {
                        boolTempFlag = this.valReasonForChangeInSig(fieldStr, "Reason For Change in Signature", 15);
                        objPSModDtls.setReasonOfChangeSig(fieldStr);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 16: {
                        if (boolErrCodeFound && sEFCodeDataArray != null) {
                            fieldStr = sEFCodeDataArray[15];
                        }
                        if (SubsRegConst.getUtilityLevel() == 1 && CRAConfigReader.getConfigVal("CRACENTRAL.FVU.SubsReg.PhotoSigMandatory").equalsIgnoreCase("N") || SubsRegConst.getUtilityLevel() == 2 && pcon.getPhotoSigPresent().equalsIgnoreCase("N")) {
                            boolTempFlag = this.valAck(fieldStr, pcon.getFieldNameAckOrRecipt(), 5);
                            objPSModDtls.setFcProvAck(fieldStr);
                        } else {
                            boolTempFlag = this.valUOSProvAck(fieldStr, "FC Provisional Ack Number", 16);
                            objPSModDtls.setFcProvAck(fieldStr);
                        }
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        if (boolErrCodeFound) {
                            boolErrorCodeStopProcess = true;
                            objPSModDtls.setBoolErrorCodeStopProcess(boolErrorCodeStopProcess);
                            sEFCodeDataArray = null;
                        }
                        this.strAck = fieldStr;
                        break;
                    }
                    case 17: {
                        ++intFieldIndex;
                        break;
                    }
                    default: {
                        boolRecFlag = false;
                    }
                }
            }
            if (SubsRegConst.getUtilityLevel() == 1) {
                if (boolRecFlag) {
                    if (this.isUnorganizedSector) {
                        if (CRAConfigReader.getConfigVal("CRACENTRAL.FVU.SubsReg.PhotoSigMandatory").equalsIgnoreCase("Y")) {
                            String strRec = pcon.getFileLine();
                            strRec = String.valueOf(strRec) + "^" + "Y";
                            pcon.setFileLine(strRec);
                        } else {
                            String strRec = pcon.getFileLine();
                            strRec = String.valueOf(strRec) + "^" + "N";
                            pcon.setFileLine(strRec);
                        }
                    }
                    if (this.addPhotoSig()) {
                        if (this.addHash(pcon.getFileLine())) {
                            this.objWRecord.writeRecord(pcon.getFileLine(), pcon.getStrFilePath(), pcon.getStrUploadDirPath());
                            objPSModDtls.setPSModDtlsErrorFlg(false);
                            return objPSModDtls;
                        }
                        objPSModDtls.setPSModDtlsErrorFlg(true);
                        return objPSModDtls;
                    }
                    objPSModDtls.setPSModDtlsErrorFlg(true);
                    return objPSModDtls;
                }
                objPSModDtls.setPSModDtlsErrorFlg(!boolRecFlag);
                return objPSModDtls;
            }
            objPSModDtls.setPSModDtlsErrorFlg(!boolRecFlag);
            return objPSModDtls;
        }
        catch (Exception exception) {
            return objPSModDtls;
        }
    }

    public boolean valSectorTypeFlag(String strFieldVal, String strColumnName) {
        boolean boolTemp = true;
        if (strFieldVal.equals("")) {
            boolTemp = false;
            this.respgen.genHTML(this.pcon, strColumnName, strFieldVal, "102891");
            return boolTemp;
        }
        if (!strFieldVal.equalsIgnoreCase("U") && !strFieldVal.equalsIgnoreCase("C")) {
            boolTemp = false;
            this.respgen.genHTML(this.pcon, strColumnName, strFieldVal, "102892");
            return boolTemp;
        }
        return boolTemp;
    }

    @Override
    public boolean valFileSectType(String fieldStr, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        try {
            if (!fieldStr.equals("CD")) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "105021");
                return boolTemp;
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    boolean valPRAN(String fieldStr, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        try {
            boolTemp = NCRMod11Algorithm.isValidNumber(fieldStr);
            if (!boolTemp) {
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "105123");
            }
        }
        catch (Exception e) {
            boolTemp = false;
            this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "105123");
            return boolTemp;
        }
        return boolTemp;
    }

    boolean valTypeOfChange(String strField, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        try {
            boolTemp = this.valFieldBasics(strField, 100, SubsRegConst.getMandatoryValue(), strColumnName, intColumnCode);
            if (!(strField.equals("A") || strField.equals("B") || strField.equals("C"))) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strField, "105133");
                return boolTemp;
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    boolean valReasonForChangeInPhoto(String strField, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        try {
            boolTemp = this.valFieldBasics(strField, 100, SubsRegConst.getOptionalValue(), strColumnName, intColumnCode);
            if (!this.strTypeOfChange.equalsIgnoreCase("B") && strField.equals("")) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strField, "105143");
            }
            if (this.strTypeOfChange.equals("B") && !strField.equals("")) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strField, "105144");
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    boolean valReasonForChangeInSig(String strField, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        try {
            boolTemp = this.valFieldBasics(strField, 100, SubsRegConst.getOptionalValue(), strColumnName, intColumnCode);
            if (!this.strTypeOfChange.equalsIgnoreCase("A") && strField.equals("")) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strField, "105153");
            }
            if (this.strTypeOfChange.equals("A") && !strField.equals("")) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strField, "105154");
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    boolean valUOSProvAck(String strField, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        boolean oldFormat = false;
        try {
            boolTemp = this.valFieldBasicsWithErrorCode(strField.trim(), 17, SubsRegConst.getMandatoryValue(), strColumnName, "102611", "102612");
            if (!this.isNumber(strField)) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strField, "102683");
                return boolTemp;
            }
            if (Long.parseLong(strField) == 0L) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strField, "102684");
                return boolTemp;
            }
            if (strField.length() < 17) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strField, "102682");
                return boolTemp;
            }
            if (strField.substring(5, 6).equals("0")) {
                oldFormat = true;
            }
            int ackseq = 0;
            if (oldFormat && strField.substring(15, 17).equals("00")) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strField, "102685");
                return boolTemp;
            }
            if (!oldFormat && strField.substring(14, 17).equals("000")) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strField, "102981");
                return boolTemp;
            }
            if (oldFormat) {
                ackseq = Integer.parseInt(strField.substring(15, 17));
            } else if (!oldFormat) {
                ackseq = Integer.parseInt(strField.substring(14, 17));
            }
            if (oldFormat && ackseq > 50) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strField, "102687");
                return boolTemp;
            }
            if (!oldFormat && ackseq > 999) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strField, "102982");
                return boolTemp;
            }
            if (!this.validatePRNFromat(strField, oldFormat)) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strField, "102688");
                return boolTemp;
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    @Override
    protected boolean addPhotoSig() {
        boolean boolTemp = true;
        boolean boolPhoto = true;
        boolean boolSig = true;
        try {
            String strRec = this.pcon.getFileLine();
            if (this.strTypeOfChange.equals("A")) {
                File filePhoto = new File(this.getPhotoFileName());
                boolPhoto = this.getPhotoHex(filePhoto);
                strRec = String.valueOf(strRec) + "^" + this.strPhoto.toUpperCase() + "^";
            } else if (this.strTypeOfChange.equals("B")) {
                File fileSig = new File(this.getSigFileName());
                boolSig = this.getSigHex(fileSig);
                strRec = String.valueOf(strRec) + "^^" + this.strSig.toUpperCase();
            } else {
                File filePhoto = new File(this.getPhotoFileName());
                boolPhoto = this.getPhotoHex(filePhoto);
                strRec = String.valueOf(strRec) + "^" + this.strPhoto.toUpperCase();
                File fileSig = new File(this.getSigFileName());
                boolSig = this.getSigHex(fileSig);
                strRec = String.valueOf(strRec) + "^" + this.strSig.toUpperCase();
            }
            this.pcon.setFileLine(strRec);
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolPhoto && boolSig;
    }

    @Override
    public SubsRegFileVO valDupACKInFile(SubsRegFileVO fileVO, SubsRegConst pcon) {
        String currAck;
        int j;
        String prevAck;
        this.pcon = pcon;
        ArrayList<Object> arlPSModList = new ArrayList();
        arlPSModList = fileVO.getPhotoSigModDtlsList();
        int i = 0;
        while (i < arlPSModList.size()) {
            prevAck = ((PhotoSigModDtlsVO)arlPSModList.get(i)).getAck();
            j = 0;
            while (j < i) {
                currAck = ((PhotoSigModDtlsVO)arlPSModList.get(j)).getAck();
                if (!currAck.equalsIgnoreCase("") && currAck.equalsIgnoreCase(prevAck)) {
                    String errorCode;
                    ((PhotoSigModDtlsVO)arlPSModList.get(i)).setDupAckExists(true);
                    fileVO.setSubsRegFileErrorFlg(true);
                    if (!this.isUnorganizedSector) {
                        errorCode = "109102";
                        pcon.setFieldNameAckOrRecipt("Ack No");
                    } else {
                        pcon.setFieldNameAckOrRecipt("Receipt No");
                        errorCode = "105055";
                    }
                    fileVO.setSubsRegErrorCode(errorCode);
                    this.respgen.genHTML(pcon, pcon.getFieldNameAckOrRecipt(), currAck, errorCode);
                }
                ++j;
            }
            ++i;
        }
        if (this.isUnorganizedSector) {
            i = 0;
            while (i < arlPSModList.size()) {
                prevAck = ((PhotoSigModDtlsVO)arlPSModList.get(i)).getFcProvAck();
                j = 0;
                while (j < i) {
                    currAck = ((PhotoSigModDtlsVO)arlPSModList.get(j)).getFcProvAck();
                    if (currAck.equalsIgnoreCase(prevAck)) {
                        ((PhotoSigModDtlsVO)arlPSModList.get(i)).setDupAckExists(true);
                        fileVO.setSubsRegFileErrorFlg(true);
                        fileVO.setSubsRegErrorCode("102616");
                        this.respgen.genHTML(pcon, "FC Provisional Ack No", currAck, "102616");
                    }
                    ++j;
                }
                ++i;
            }
        }
        fileVO.setPhotoSigModDtlsList(arlPSModList);
        return fileVO;
    }

    @Override
    public SubsRegFileVO valDupPRANInFile(SubsRegFileVO fileVO, SubsRegConst pcon) {
        this.pcon = pcon;
        ArrayList<Object> arlPSModArrayList = new ArrayList();
        arlPSModArrayList = fileVO.getPhotoSigModDtlsList();
        HashSet<String> pranSet = new HashSet<String>();
        int i = 0;
        while (i < arlPSModArrayList.size()) {
            String strPRAN = ((PhotoSigModDtlsVO)arlPSModArrayList.get(i)).getPRAN();
            if (strPRAN != null && !strPRAN.equals("") && !pranSet.add(strPRAN)) {
                pcon.setLineCntr(Integer.parseInt(((PhotoSigModDtlsVO)arlPSModArrayList.get(i)).getLineNum()));
                fileVO.setSubsRegFileErrorFlg(true);
                fileVO.setSubsRegErrorCode("105124");
                this.respgen.genHTML(pcon, pcon.getFieldNameAckOrRecipt(), strPRAN, "105124");
            }
            ++i;
        }
        fileVO.setPhotoSigModDtlsList(arlPSModArrayList);
        return fileVO;
    }

    public boolean validatePSModBiz(SubsRegConst pcon, PhotoSigModDtlsVO objPSModVO) {
        boolean bizValFlag = true;
        String popSP = objPSModVO.getAIN();
        String ack = objPSModVO.getAck();
        try {
            if (ack != null) {
                String ackPopSpReg = ack.substring(2, 9);
                String corpCheck = ack.substring(9, 10);
                if (corpCheck != null && (!ack.startsWith("24") || "4".equalsIgnoreCase(corpCheck) && ackPopSpReg.equalsIgnoreCase(popSP) || !"4".equalsIgnoreCase(corpCheck) && !ackPopSpReg.equalsIgnoreCase(popSP))) {
                    bizValFlag = false;
                    this.respgen.genHTML(pcon, pcon.getFieldNameAckOrRecipt(), ack, "102069");
                }
                if (SubsRegConst.getUtilityLevel() == 1 && CRAConfigReader.getConfigVal("CRACENTRAL.FVU.SubsReg.PhotoSigMandatory").equalsIgnoreCase("N")) {
                    if (!this.isFCAckEqualToReceiptNo(pcon, objPSModVO.getAck(), objPSModVO.getFcProvAck())) {
                        objPSModVO.setPSModDtlsErrorFlg(true);
                    }
                } else if (SubsRegConst.getUtilityLevel() == 2 && pcon.getPhotoSigPresent().equalsIgnoreCase("N") && !this.isFCAckEqualToReceiptNo(pcon, objPSModVO.getAck(), objPSModVO.getFcProvAck())) {
                    objPSModVO.setPSModDtlsErrorFlg(true);
                }
            }
        }
        catch (Exception e) {
            this.respgen.genHTML(pcon, pcon.getFieldNameAckOrRecipt(), ack, "102059");
        }
        return bizValFlag;
    }

    @Override
    public String getErrorForm() {
        return "105";
    }

    @Override
    public boolean valAck(String strAck, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        boolean oldFormat = false;
        try {
            if (!this.subSectorType.equalsIgnoreCase("C") || !strAck.equalsIgnoreCase("")) {
                boolTemp = this.valFieldBasics(strAck.trim(), 17, SubsRegConst.getMandatoryValue(), strColumnName, intColumnCode);
                if (!this.isNumber(strAck)) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, strAck, "102063");
                    return boolTemp;
                }
                if (Long.parseLong(strAck) == 0L) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, strAck, "102064");
                    return boolTemp;
                }
                if (strAck.length() != 17) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, strAck, "102062");
                    return boolTemp;
                }
                if (strAck.substring(5, 6).equals("0")) {
                    oldFormat = true;
                }
                if (boolTemp && !this.isUnorganizedSector) {
                    int ackseq = 0;
                    if (oldFormat && strAck.substring(15, 17).equals("00")) {
                        boolTemp = false;
                        this.respgen.genHTML(this.pcon, strColumnName, strAck, "102065");
                        return boolTemp;
                    }
                    if (!oldFormat && strAck.substring(14, 17).equals("000")) {
                        boolTemp = false;
                        this.respgen.genHTML(this.pcon, strColumnName, strAck, "102073");
                        return boolTemp;
                    }
                    if (oldFormat) {
                        ackseq = Integer.parseInt(strAck.substring(15, 17));
                    } else if (!oldFormat) {
                        ackseq = Integer.parseInt(strAck.substring(14, 17));
                    }
                    if (oldFormat && ackseq > 50) {
                        boolTemp = false;
                        this.respgen.genHTML(this.pcon, strColumnName, strAck, "102067");
                        return boolTemp;
                    }
                    if (!oldFormat && ackseq > 999) {
                        boolTemp = false;
                        this.respgen.genHTML(this.pcon, strColumnName, strAck, "102060");
                        return boolTemp;
                    }
                    if (!this.validatePRNFromat(strAck, oldFormat)) {
                        boolTemp = false;
                        this.respgen.genHTML(this.pcon, strColumnName, strAck, "102068");
                        return boolTemp;
                    }
                }
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    @Override
    public boolean valErrorFlgCd(String fieldStr, String strColumnName, int intColumnCode) {
        boolean boolTemp = true;
        try {
            boolTemp = this.valFieldBasics(fieldStr, 7, SubsRegConst.getMandatoryValue(), strColumnName, intColumnCode);
            if (fieldStr.length() != 1 && fieldStr.length() != 7) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "102033");
            } else if (fieldStr.length() == 7) {
                if (!fieldStr.substring(0, 3).equals("SEF") || !this.isNumber(fieldStr.substring(3, 7))) {
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "102035");
                    boolTemp = false;
                } else {
                    boolean valid = this.respgen.checkValidErrorCode(fieldStr);
                    if (!valid) {
                        this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "102035");
                        boolTemp = false;
                    }
                }
            } else if (fieldStr.length() == 1 && !fieldStr.trim().equals("N")) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "102035");
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    private boolean isFCAckEqualToReceiptNo(SubsRegConst pcon, String receiptNum, String fcProvisionalAck) {
        boolean boolTemp = false;
        try {
            if (fcProvisionalAck.equalsIgnoreCase(receiptNum)) {
                boolTemp = true;
            } else {
                boolTemp = false;
                this.respgen.genHTML(pcon, "FC Provisional Ack", fcProvisionalAck, "102619");
            }
        }
        catch (Exception e) {
            boolTemp = false;
            this.respgen.genHTML(pcon, "FC Provisional Ack", fcProvisionalAck, "102619");
        }
        return boolTemp;
    }
}

