/** 
 *  Class: SubContrOutputFileGenerator.java      
 */

package cra.standalone.paosubcontr.util;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import com.cra.pao.vo.PAOFileStatisticsVO;
import com.cra.pao.fvu.SubContrFileFormatValidator;
import com.cra.pao.fvu.FvuConstants;
import com.cra.contr.common.util.CRAConfigReader;
import com.cra.contr.common.util.file.CRABasicFileWriter;
/**
 * This class contains methods for creating error files and FVU control sheet report.
 * The class is called from the main class PAOFvu.java and the corresponding generate files method 
 * are invoked based on the validations.
 * 
 * @author TCS
 *
 */

public class SubContrOutputFileGenerator 
{
	Calendar cal = new GregorianCalendar();
	String tab = "^";	
	
	/**
	 * Method for generating PAO Control Sheet Report. This method is called
	 * from PAOFvu.java. This method gets the value of all the fields which are
	 * appended in a StringBuffer contolSheetReport which is stored in an
	 * ArrayList with '^' as a seperator. The ArrayList is again converted to an
	 * array of string in which the data from the text file is stored.
	 * 
	 * @param obj_FrmValidator-> object of PAOFormatValidator class
	 * @param controlSheetFileName -> Name of the Control Sheet Report file to be generated including file path
	 * @param fileName -> Name of the input file including file patjh
	 * @param FVUVersion -> Version Number of the File Validation Utility
	 */
	public void generateControlSheetReport(SubContrFileFormatValidator obj_FrmValidator, String controlSheetFileName, String fileName, String FVUVersion, String batchId)
	{
		try
		{
			//CRALog.paoLog.info("Inside generateStatisticFile Method ");
			ArrayList statisticDataList = parseString(obj_FrmValidator.getControlSheetBuffer().toString(), "\n");
            Object statisticDataArray[] = statisticDataList.toArray();
			obj_FrmValidator.setControlSheetBuffer(new StringBuffer());
            PAOFileStatisticsVO fStatistics = new PAOFileStatisticsVO();
			fStatistics = getStatisticFileDetail((String) statisticDataArray[0], "^", fStatistics, batchId);
			createStatisticFile(obj_FrmValidator, fStatistics, controlSheetFileName, fileName, FVUVersion);
		}
		catch (Exception e)
		{
			//CRALog.paoLog.error("generateStatisticFile Method : " + e.toString());
		}
	}

	private ArrayList parseString(String toParse, String Seperator)
	{
		ArrayList<Object> aList = new ArrayList<Object>();
		StringTokenizer parsed = new StringTokenizer(toParse, Seperator);
        while (parsed.hasMoreTokens())
		{
			aList.add(parsed.nextElement());
		}
		return aList;
	}

	/**
	 * Method to parse string to get data for Control Sheet Report
	 */
	private PAOFileStatisticsVO getStatisticFileDetail(String StringToParse, String Seperator, PAOFileStatisticsVO fStatistics, String batchId)
	{
		//CRALog.paoLog.info("SubContrOutputFileGenerator.java getStatisticaFileDetail() method Called");
		//System.out.println("CSS ::"+StringToParse);
		StringTokenizer batch = new StringTokenizer(StringToParse, Seperator);
		int counter = 0;
		while (batch.hasMoreTokens())
		{
			String token = batch.nextToken();
			System.out.println("inside getStatisticFileDetail of class"+token+"counter"+counter);
            if (counter == 0) // Number of batches
            {
                fStatistics.setUploadedBy(token.trim());   
            }
            else if (counter == 1) // Number of batches
            {
                fStatistics.setNumberOfBatches(token.trim());   
            }
            else if (counter == 2) // FVU Version
            {
                token = CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion");
                fStatistics.setFvuVersion(token.trim());
            }
            else if (counter == 5) // Type of Uploaded File
            {
                fStatistics.setTypeOfUploadedFile(token.trim());
            }
            else if (counter == 6) // PAO Reg. No.
            {
                fStatistics.setAIN(token.trim());
            }
            else if (counter == 7) // File Creation Date
            {
                fStatistics.setFpuFileCreatedDate(token.trim());
            }
            else if (counter == 8) // Batch ID
            {
                fStatistics.setBatchId(batchId);
            }
            else if (counter == 9) // Transaction ID
            {
                fStatistics.setTransactionId(token.trim());
            }
            else if (counter == 10) // Count of DDO Records
            {
                fStatistics.setCountOfDDORecords(token.trim());
            }
            else if (counter == 11) // Count of Subscriber Detail Records
            {
                fStatistics.setCountOfSubDetailRecords(token.trim());
            }
            else if (counter == 12) // Total Government Contribution in Batch
            {
                fStatistics.setTierOneTotalGovtContribution(token);
            }
            else if (counter == 13) // Total Self Contribution in Batch
            {
                fStatistics.setTierOneTotalSelfContribution(token);
            }
            else if (counter == 14) // Total Self Contribution in Batch
            {
                fStatistics.setTotalAmountDepositedInBank(token);
            }
            else if (counter == 15) // Total Self Contribution in Batch
            {
                fStatistics.setTotalRegularContr(token);
            }
            else if (counter == 16) // Total Self Contribution in Batch
            {
                fStatistics.setTotalArrearContr(token);
            }
            else if (counter == 17) // Total Self Contribution in Batch
            {
                fStatistics.setTotalMiscContr(token);
            }
            else if (counter == 18) // Total Self Contribution in Batch
            {
                fStatistics.setTotalT1Contr(token);
            }
            else if (counter == 19) // Total Self Contribution in Batch
            {
                fStatistics.setTotalT2Contr(token);
            }
            else if (counter == 20) // Total Self Contribution in Batch
            {
                fStatistics.setTotalUM1Contr(token);
            }
            else if (counter == 21) // Total Self Contribution in Batch
            {
                fStatistics.setTotalUM2Contr(token);
            }
            else if (counter == 22) // Total Self Contribution in Batch
            {
                fStatistics.setTotalUT1Contr(token);
            }
            else if (counter == 23) // Total Self Contribution in Batch
            {
                fStatistics.setTotalUT2Contr(token);
            }
            else if (counter == 24) // Total Self Contribution in Batch
            {
                fStatistics.setTotalVPFContr(token);
            }
            else if (counter == 25) // Total Self Contribution in Batch
            {
                fStatistics.setTotalVPFUPSContr(token);
            }
            else if (counter == 26) // Total Self Contribution in Batch
            {
                fStatistics.setWarnings(token);
            }
            else if (counter == 27) // Total Self Contribution in Batch
            {
                fStatistics.setUniqueCount(token);
            }
            else if (counter == 28) // Total Self Contribution in Batch
            {
                fStatistics.setLineNumber(token);
            }
            else if (counter == 29) // Total Self Contribution in Batch
            {
                fStatistics.setTotalTTSContr(token);
            }
            
            counter++;
        } // while () inner While
		return fStatistics;
	}

	private void createStatisticFile(SubContrFileFormatValidator obj_FrmValidator, PAOFileStatisticsVO fStatistics, String ctrlSheetFileName, String fileName, String FVUVersion)
	{
		try
		{
			StringBuilder toReturn = new StringBuilder();
			toReturn.append("<HTML>");
			toReturn.append("<HEAD>");
			toReturn.append("<TITLE>SUBSCRIBER CONTRIBUTION FILE</TITLE>");
			toReturn.append("</HEAD>");
			toReturn.append("<STYLE>p.dotted {border-width:1; border-style:dashed;border-bottom-style:none;border-right-style:none;border-left-style:none}</STYLE>");
			toReturn.append("<BODY>");
			toReturn.append("<CENTER>");
			toReturn.append("<TABLE BORDER=1 WIDTH=75% BORDERCOLOR=\"000000\" CELLSPACING=0 CELLPADDING=0 " + "style='border-collapse: collapse; border: none; mso-border-alt: solid windowtext .5pt; mso-padding-alt: 0in 5.4pt 0in 5.4pt'>");
			toReturn.append("<TR><TD ALIGN=CENTER>");
			toReturn.append("<CENTER>");
			toReturn.append("<TABLE BORDER=0 WIDTH=100% BORDERCOLOR=\"000000\" CELLSPACING=0 CELLPADDING=0 " + "style='border-collapse: collapse; border: none; mso-border-alt: solid windowtext .5pt; mso-padding-alt: 0in 5.4pt 0in 5.4pt'>");
			toReturn.append("<TR><TD ALIGN=CENTER>");
			toReturn.append("<CENTER>");
			toReturn.append("<TABLE ALIGN=CENTER BORDER=0 WIDTH=100% BORDERCOLOR=\"000000\" CELLSPACING=0 CELLPADDING=0 " + "style='border-collapse: collapse; border: none; mso-border-alt: solid windowtext .5pt; mso-padding-alt: 0in 5.4pt 0in 5.4pt'>");
			toReturn.append("<TR><TD ALIGN=CENTER>");
			toReturn.append("<H2>SUBSCRIBER CONTRIBUTION FILE CONTROL SHEET*</H2>");
			toReturn.append("</TD></TR>");
			toReturn.append("</TABLE>");
			toReturn.append("</CENTER>");
			toReturn.append("</TD></TR>");
			toReturn.append("<TR><TD>");
			//toReturn.append("<CENTER>");
			toReturn.append("<TABLE BORDER=0 WIDTH=100% BORDERCOLOR=\"000000\" CELLSPACING=0 CELLPADDING=0 " + "style='border-collapse: collapse; border: none; mso-border-alt: solid windowtext .5pt; mso-padding-alt: 0in 5.4pt 0in 5.4pt'>");
			toReturn.append("<TR><TD WIDTH=55%>");
			toReturn.append("<TABLE BORDER=0 WIDTH=100% BORDERCOLOR=\"000000\" CELLSPACING=0 CELLPADDING=3 " + "style='border-collapse: collapse; border: none; mso-border-alt: solid windowtext .5pt; mso-padding-alt: 0in 5.4pt 0in 5.4pt'>");
			toReturn.append("<TR><TD ALIGN=LEFT WIDTH=50%>&nbsp; &nbsp; Batch ID : </TD><TD ALIGN=LEFT>&nbsp;&nbsp;" + fStatistics.getBatchId() + "</TD></TR>");
			toReturn.append("<TR>");
			//Modified For CR-58405
			if (fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_AO) || fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_KA) || fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_AOV)|| fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_AOV_TTS) || fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_AO_UPS))//Modified for TTS CG\SG cr-34025
			{
				toReturn.append("<TD ALIGN=LEFT>&nbsp; &nbsp; PAO/DTO Reg. No. : </TD>");
			}
			//Modified For CR-58405
			else if(fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_PRAO)|| fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_PRAOV)|| fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_PRAOV_TTS) || fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_PRAO_UPS))//Modified for TTS CG\SG cr-34025
			{
				toReturn.append("<TD ALIGN=LEFT>&nbsp; &nbsp; DTA Reg. No. : </TD>");
			}
			else if (fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_CORP)) 
			{
				toReturn.append("<TD ALIGN=LEFT>&nbsp; &nbsp; CHO/CBO Reg. No. : </TD>");
			}
			else 
			{
				toReturn.append("<TD ALIGN=LEFT>&nbsp; &nbsp; POP/POP-SP Reg. No. : </TD>");
			}
			toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;" + fStatistics.getAIN() + "</TD></TR>");
			toReturn.append("<TR>");
			//Modified For CR-58405
			if (fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_AO) || fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_KA) || fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_AOV) || fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_AOV_TTS) || fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_AO_UPS))//Modified for TTS CG\SG cr-34025
			{
			       toReturn.append("<TD ALIGN=LEFT>&nbsp; &nbsp; Number of DDO's :</TD>");
			}
			//Modified For CR-58405
			else if(fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_PRAO) || fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_PRAOV)|| fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_PRAOV_TTS) || fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_PRAO_UPS))//Modified for TTS CG\SG cr-34025
			{
				   toReturn.append("<TD ALIGN=LEFT>&nbsp; &nbsp; Number of DTO's :</TD>");
			}
			else if(fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_CORP))
			{
				   toReturn.append("<TD ALIGN=LEFT>&nbsp; &nbsp; Number of CBO's :</TD>");
			}
			else
			{
			       toReturn.append("<TD ALIGN=LEFT>&nbsp; &nbsp; Number of POP-SP's :</TD>");
			}
			toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;" + fStatistics.getCountOfDDORecords() + "</TD>");
			toReturn.append("</TR>");
			toReturn.append("</TABLE>");
			toReturn.append("</TD>");
			toReturn.append("<TD ALIGN=LEFT WIDTH=45%>");
			toReturn.append("<TABLE BORDER=0 WIDTH=100% BORDERCOLOR=\"000000\" CELLSPACING=0 CELLPADDING=3 " + "style='border-collapse: collapse; border: none; mso-border-alt: solid windowtext .5pt; mso-padding-alt: 0in 5.4pt 0in 5.4pt'>");
			toReturn.append("<TR><TD WIDTH=55%>");
			toReturn.append("<TR><TD WIDTH=55%>");
			toReturn.append("<TR><TD WIDTH=55%>");
			toReturn.append("<TR><TD ALIGN=LEFT WIDTH=50%>Contribution File Type : </TD>");
			if (fStatistics.getTypeOfUploadedFile().equals(FvuConstants.REG_CONTRIBUTION_FILE))
			{
				toReturn.append("<TD ALIGN=LEFT WIDTH=50%>" + FvuConstants.REGULAR_FILE + "</TD>");
			}
			else
			{
				toReturn.append("<TD ALIGN=LEFT WIDTH=50%>" + FvuConstants.CORRECTION_FILE + "</TD>");
			}
			toReturn.append("</TR>");
			toReturn.append("<TR><TD ALIGN=LEFT WIDTH=50%>Transaction ID : </TD><TD ALIGN=LEFT WIDTH=50%>" + fStatistics.getTransactionId() + "</TD>");
			toReturn.append("</TR>");
			toReturn.append("<TR><TD ALIGN=LEFT WIDTH=50%>Subscriber record count : </TD><TD ALIGN=LEFT WIDTH=50%>" + fStatistics.getCountOfSubDetailRecords() + "</TD>");
			toReturn.append("</TR>");
			//added for CR -16365 
			toReturn.append("<TR><TD ALIGN=LEFT WIDTH=50%>Count of unique subscribers : </TD><TD ALIGN=LEFT WIDTH=50%>" + fStatistics.getUniqueCount() + "</TD>");
			
			toReturn.append("</TABLE>");
			toReturn.append("</TD>");
			toReturn.append("</TR>");
			toReturn.append("</TABLE>");
			//toReturn.append("</CENTER>");
			toReturn.append("</TD></TR>");
			toReturn.append("<TR><TD></TD></TR>");
			toReturn.append("<TR><TD>");
			toReturn.append("<TABLE BORDER=0 WIDTH=55% BORDERCOLOR=\"000000\" CELLSPACING=0 CELLPADDING=3 " + "style='border-collapse: collapse; border: none; mso-border-alt: solid windowtext .5pt; mso-padding-alt: 0in 5.4pt 0in 5.4pt'>");
			toReturn.append("<TR><TD ALIGN=LEFT WIDTH=48%><B>&nbsp; &nbsp; Contribution Types</B></TD><TD ALIGN=LEFT><B>Records</B></TD><TD ALIGN=LEFT><B>&nbsp; &nbsp; Total Amount</B></TD>");
			//Modified For CR-58405
			if(fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_AO) || fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_KA) || fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_PRAO) || fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_AO_UPS) || fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_PRAO_UPS) )
			{
				toReturn.append("<TR><TD ALIGN=LEFT WIDTH=48%>&nbsp; &nbsp; Regular Contribution :</TD>");
				toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;"+ obj_FrmValidator.getRecord_C()+"</TD>");//added for CR -16365 
				toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;"+ fStatistics.getTotalRegularContr()+"</TD>");
				toReturn.append("</TR>");
				toReturn.append("<TR><TD ALIGN=LEFT WIDTH=48%>&nbsp; &nbsp; Arrears Contribution :</TD>");
				toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;"+ obj_FrmValidator.getRecord_A()+"</TD>");//added for CR -16365 
				toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;"+ fStatistics.getTotalArrearContr()+"</TD>");
				toReturn.append("</TR>");
			}
			//Added for VPF/T2 contr OS
			if(fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_AOV) || fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_PRAOV))
			{		
				toReturn.append("<TR><TD ALIGN=LEFT WIDTH=48%>&nbsp; &nbsp; Voluntary Contribution :</TD>");
				toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;"+ obj_FrmValidator.getRecord_VPF()+"</TD>"); 
				toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;"+ fStatistics.getTotalVPFContr()+"</TD>");
				toReturn.append("</TR>");
				toReturn.append("<TR><TD ALIGN=LEFT WIDTH=48%>&nbsp; &nbsp; Tier-2 Contribution :</TD>");
				toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;"+ obj_FrmValidator.getRecord_T2()+"</TD>");
				toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;"+ fStatistics.getTotalT2Contr()+"</TD>");
				toReturn.append("</TR>");
			}
			//Added For TTS CG\SG of CR-34025.START
			if(fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_AOV_TTS) || fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_PRAOV_TTS))
			{		
				toReturn.append("<TR><TD ALIGN=LEFT WIDTH=48%>&nbsp; &nbsp; TTS Contribution :</TD>");
				toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;"+ obj_FrmValidator.getRecord_TTS()+"</TD>"); 
				toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;"+ fStatistics.getTotalTTSContr()+"</TD>");
				toReturn.append("</TR>");
			}
			//Added For TTS CG\SG of CR-34025.END
			//end
			else if(fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_CORP)){
				toReturn.append("<TR><TD ALIGN=LEFT WIDTH=48%>&nbsp; &nbsp; Regular Contribution :</TD>");
				toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;"+ obj_FrmValidator.getRecord_C()+"</TD>");//added for CR -16365 
				toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;"+ fStatistics.getTotalRegularContr()+"</TD>");
				toReturn.append("</TR>");
				toReturn.append("<TR><TD ALIGN=LEFT WIDTH=48%>&nbsp; &nbsp; Arrears Contribution :</TD>");
				toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;"+ obj_FrmValidator.getRecord_A()+"</TD>");//added for CR -16365 
				toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;"+ fStatistics.getTotalArrearContr()+"</TD>");
				toReturn.append("</TR>");
				toReturn.append("<TR><TD ALIGN=LEFT WIDTH=48%>&nbsp; &nbsp; Misc. Contribution :</TD>");
				toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;"+ obj_FrmValidator.getRecord_0()+"</TD>");//added for CR -16365 
				toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;"+ fStatistics.getTotalMiscContr()+"</TD>");
				toReturn.append("</TR>");
				toReturn.append("<TR><TD ALIGN=LEFT WIDTH=48%>&nbsp; &nbsp; Unfreeze Yearly Tier1 :</TD>");
				toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;"+ obj_FrmValidator.getRecord_UT1()+"</TD>");//added for FTR -17397 
				toReturn.append("<TD ALIGN='LEFT'>&nbsp;&nbsp;&nbsp;&nbsp;"+ fStatistics.getTotalUT1Contr()+"</TD>");
				toReturn.append("</TR>");
				toReturn.append("<TR><TD ALIGN=LEFT WIDTH=48%>&nbsp; &nbsp; Unfreeze Yearly Tier2 :</TD>");
				toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;"+ obj_FrmValidator.getRecord_UT2()+"</TD>");//added for FTR -17397 
				toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;"+ fStatistics.getTotalUT2Contr()+"</TD>");
				toReturn.append("</TR>");
				//Added for CR - VPF-T2 Contribution for Corp
				toReturn.append("<TR><TD ALIGN=LEFT WIDTH=48%>&nbsp; &nbsp; Voluntary Contribution :</TD>");
				toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;"+ obj_FrmValidator.getRecord_VPF()+"</TD>"); 
				toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;"+ fStatistics.getTotalVPFContr()+"</TD>");
				toReturn.append("</TR>");
				toReturn.append("<TR><TD ALIGN=LEFT WIDTH=48%>&nbsp; &nbsp; Tier-2 Contribution :</TD>");
				toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;"+ obj_FrmValidator.getRecord_T2()+"</TD>");
				toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;"+ fStatistics.getTotalT2Contr()+"</TD>");
				toReturn.append("</TR>");
			}
			else if(fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_UOS)){
				toReturn.append("<TR><TD ALIGN=LEFT WIDTH=48%>&nbsp; &nbsp; Tier1 :</TD>");
				toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;"+ obj_FrmValidator.getRecord_T1()+"</TD>");//added for CR -16365 
				toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;"+ fStatistics.getTotalT1Contr()+"</TD>");
				toReturn.append("</TR>");
				toReturn.append("<TR><TD ALIGN=LEFT WIDTH=48%>&nbsp; &nbsp; Tier2 :</TD>");
				toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;"+ obj_FrmValidator.getRecord_T2()+"</TD>");//added for CR -16365 
				toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;"+ fStatistics.getTotalT2Contr()+"</TD>");
				toReturn.append("</TR>");
				toReturn.append("<TR><TD ALIGN=LEFT WIDTH=48%>&nbsp; &nbsp; Unfreeze Monthly Tier1 :</TD>");
				toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;"+ obj_FrmValidator.getRecord_M1()+"</TD>");//added for CR -16365 
				toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;"+ fStatistics.getTotalUM1Contr()+"</TD>");
				toReturn.append("</TR>");
				toReturn.append("<TR><TD ALIGN=LEFT WIDTH=48%>&nbsp; &nbsp; Unfreeze Monthly Tier2 :</TD>");
				toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;"+ obj_FrmValidator.getRecord_M2()+"</TD>");//added for CR -16365 
				toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;"+ fStatistics.getTotalUM2Contr()+"</TD>");
				toReturn.append("</TR>");
				toReturn.append("<TR><TD ALIGN=LEFT WIDTH=48%>&nbsp; &nbsp; Unfreeze Yearly Tier1 :</TD>");
				toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;"+ obj_FrmValidator.getRecord_UT1()+"</TD>");//added for CR -16365 
				toReturn.append("<TD ALIGN='LEFT'>&nbsp;&nbsp;&nbsp;&nbsp;"+ fStatistics.getTotalUT1Contr()+"</TD>");
				toReturn.append("</TR>");
				toReturn.append("<TR><TD ALIGN=LEFT WIDTH=48%>&nbsp; &nbsp; Unfreeze Yearly Tier2 :</TD>");
				toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;"+ obj_FrmValidator.getRecord_UT2()+"</TD>");//added for CR -16365 
				toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;"+ fStatistics.getTotalUT2Contr()+"</TD>");
				toReturn.append("</TR>");
				toReturn.append("<TR><TD ALIGN=LEFT WIDTH=48%>&nbsp; &nbsp; NPS Voluntary Contribution :</TD>");
				toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;"+ obj_FrmValidator.getRecord_VPF()+"</TD>");//added for VPF
				toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;"+ fStatistics.getTotalVPFContr()+"</TD>");
				//start CR 60237
				toReturn.append("<TR><TD ALIGN=LEFT WIDTH=48%>&nbsp; &nbsp; UPS Voluntary Contribution :</TD>");
				toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;"+ obj_FrmValidator.getRecord_VPFUPS()+"</TD>");//added for VPF
				toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;"+ fStatistics.getTotalVPFUPSContr()+"</TD>");
				//end CR 60237
			}
			else if(fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_UOS_TTS))
			{
				//toReturn.append("<TR><TD ALIGN=LEFT WIDTH=48%>&nbsp; &nbsp; TTS :</TD>");
				toReturn.append("<TR><TD ALIGN=LEFT WIDTH=48%>&nbsp; &nbsp; MSF :</TD>");
				toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;"+ obj_FrmValidator.getRecord_TTS()+"</TD>");//added for TTS
				toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;"+ obj_FrmValidator.getTotalContrAmtTTS()+"</TD>");
				toReturn.append("</TR>");
			}
			toReturn.append("</TABLE>");
			toReturn.append("</TD></TR>");
			toReturn.append("<TR><TD></TD></TR>");
			toReturn.append("<TR><TD ALIGN=CENTER>");
			toReturn.append("<CENTER>");
			toReturn.append("<TABLE BORDER=1 WIDTH=80% BORDERCOLOR=\"000000\" CELLSPACING=0 CELLPADDING=5 " + "style='border-collapse: collapse; border: none; mso-border-alt: solid windowtext .5pt; mso-padding-alt: 0in 5.4pt 0in 5.4pt'>");
			toReturn.append("<TR>");
			toReturn.append("<TH WIDTH=70%>Contribution Source</TH><TH WIDTH=30%>Amount</TH> ");
			toReturn.append("</TR><TR>");
			if (fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_AO) || fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_KA) || fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_PRAO) || fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_AO_UPS)  || fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_PRAO_UPS))
			{
				toReturn.append("<TD>Total Government Contribution</TD>");
			}
			else{
				toReturn.append("<TD>Total Employer's Contribution</TD>");
			}
			toReturn.append("<TD>" + fStatistics.getTierOneTotalGovtContribution() + "</TD></TR>");
			toReturn.append("<TR>");
			if (fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_AO) || fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_KA) || fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_AO_UPS))
			{
				toReturn.append("<TD>Total Subscriber Mandatory Contribution</TD>");
			}
			else{
				toReturn.append("<TD>Total Subscriber Contribution</TD>");
			}
			toReturn.append("<TD>" + fStatistics.getTierOneTotalSelfContribution() + "</TD></TR>");
			toReturn.append("<TR><TD><B>Total Contribution</B></TD><TD>" + fStatistics.getTotalAmountInBank() + "</TD></TR>");
			toReturn.append("</TABLE>");
			toReturn.append("</CENTER>");
			toReturn.append("</TD></TR>");
			toReturn.append("<TR><TD>&nbsp;</TD></TR>");
			if(!fStatistics.getWarnings().equals("-")){
			toReturn.append("<TR><TD>");
			toReturn.append("&nbsp;&nbsp; &nbsp;Warning : " + fStatistics.getWarnings());
			toReturn.append("</TD></TR>");
			}
			toReturn.append("<TR><TD height=20>");
			toReturn.append("<p class=dotted>");
			toReturn.append("<TABLE BORDER=0 WIDTH=100% BORDERCOLOR=\"000000\" CELLSPACING=0 CELLPADDING=0 " + "style='border-collapse: collapse; border: none; mso-border-alt: solid windowtext .5pt; mso-padding-alt: 0in 5.4pt 0in 5.4pt'>");
			toReturn.append("<TR height=8%><TD width=60%></TD><TD width=40%></TD></TR>");
			toReturn.append("<TR><TD width=60%>");
			toReturn.append("<TABLE BORDER=0 WIDTH=100% BORDERCOLOR=\"000000\" CELLSPACING=0 CELLPADDING=0 " + "style='border-collapse: collapse; border: none; mso-border-alt: solid windowtext .5pt; mso-padding-alt: 0in 5.4pt 0in 5.4pt'>");
			toReturn.append("<TR><TD width=37%>");
			toReturn.append("<FONT size=2>&nbsp; &nbsp; &nbsp; Date of File Generation :</FONT>");
			String dateFromFile = fStatistics.getFpuFileCreatedDate();
            Date dateFmt = new SimpleDateFormat("ddMMyyy").parse(dateFromFile);
            String displayDate = new SimpleDateFormat("dd-MMM-yyyy").format(dateFmt);
			toReturn.append("</TD><TD><FONT size=2>"+ displayDate + "</FONT></TD></TR>");
			toReturn.append("<TR><TD width=37% height=20 align='top'>");
			toReturn.append("<FONT size=2>&nbsp; &nbsp; &nbsp; Input File Path :</FONT>");
			toReturn.append("</TD>");
			toReturn.append("<TD><FONT size=2>"+ fileName +"</FONT></TD></TR>");
			toReturn.append("<TR><TD width=37% height=20>");
			toReturn.append("<FONT size=2>&nbsp; &nbsp; &nbsp; FVU Version :</FONT>");
			toReturn.append("</TD>");
			toReturn.append("<TD><FONT size=2>"+ FVUVersion +"</FONT></TD></TR>");
			toReturn.append("<TR><TD  colspan=2 height=20>");
			toReturn.append("<FONT size=2>&nbsp; &nbsp; &nbsp; <I><U>Note</U>: Transaction ID will be available for correction file only.</I></FONT>");
			toReturn.append("</TD></TR>");
			toReturn.append("</TABLE>");
			toReturn.append("</TD><TD WIDTH=40%>");
			toReturn.append("<TABLE BORDER=0 WIDTH=100% BORDERCOLOR=\"000000\" CELLSPACING=4 CELLPADDING=4 " + "style='border-collapse: collapse; border: none; mso-border-alt: solid windowtext .5pt; mso-padding-alt: 0in 5.4pt 0in 5.4pt'>");
			toReturn.append("<TR><TD align=right valign=bottom>");
			toReturn.append("<TABLE BORDER=1 WIDTH=100% BORDERCOLOR=\"000000\" CELLSPACING=0 CELLPADDING=2 " + "style='border-collapse: collapse; border: none; mso-border-alt: solid windowtext .5pt; mso-padding-alt: 0in 5.4pt 0in 5.4pt'>");
			toReturn.append("<TR><TD><FONT size=2>* CONTROL SHEET helps in reconciling the subscriber data contained in the Contribution file. Please check the Control Totals to reconcile the contribution data to be uploaded.</FONT>");
			
			toReturn.append("</TD></TR></TABLE> </TD></TR> </TABLE> </TD></TR> </TABLE> </p> </TD></TR> </TABLE> </CENTER> </TD></TR> </TABLE> </CENTER> </BODY> </HTML>");
			/*toReturn.append("</TABLE>");
			toReturn.append("</TD></TR>");
			toReturn.append("</TABLE>");
			toReturn.append("</TD></TR>");
			toReturn.append("</TABLE>");
			toReturn.append("</p>");
			toReturn.append("</TD></TR>");
			toReturn.append("</TABLE>");
			toReturn.append("</CENTER>");
			toReturn.append("</TD></TR>");
			toReturn.append("</TABLE>");
			toReturn.append("</CENTER>");
			toReturn.append("</BODY>");
			toReturn.append("</HTML>");*/
			//writeToFile(ctrlSheetFileName, toReturn.toString(), 0);            
            CRABasicFileWriter.writeFileLocal(ctrlSheetFileName,new StringBuffer(toReturn.toString()));
            toReturn = new StringBuilder();
            }
		catch (Exception e)
		{
			e.printStackTrace();
			//CRALog.paoLog.debug("EXCEPTION in SubContrOutputFileGenerator.java createStatisticFileString() : " + e.getMessage());
		}
	}
} // END OF CLASS SubContrOutputFileGenerator.java

