package cra.standalone.paosubcontr;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

import com.cra.contr.common.util.CRAConfigReader;
import com.cra.contr.common.util.HtmlFileGenerator;
import com.cra.contr.common.util.encrypt.Hash;
import com.cra.pao.fvu.FvuConstants;
import com.cra.pao.fvu.SubContrFileFormatValidator;
import com.cra.pao.vo.PAOContrErrorFileVO;

import cra.standalone.paosubcontr.util.SubContrOutputFileGenerator;

public class SubContrFVU {
	
	public void generateFVU(String inputFilePath)
    throws IOException
{
		   boolean outputStatus = true;
           System.out.println("Begining mainSTP(arg) Method");
           if(inputFilePath != null && inputFilePath.length() != 0 && !inputFilePath.equalsIgnoreCase(""))
	        {	       
	            String inputFPUFilePath = inputFilePath;
	            System.out.println((new StringBuilder("The input file name is : ")).append(inputFPUFilePath).toString());
	            String inFileNameSAM = inputFPUFilePath;
	            String fileSeparator = System.getProperty("file.separator");	            
	            String errorFileNameSAM = inputFPUFilePath.substring(0, inputFPUFilePath.length() - 4).concat("err.html");	            
	            String outFileNameSAM = inputFPUFilePath.substring(0, inputFPUFilePath.length() - 3).concat("fvu");	            
	            SubContrFileFormatValidator obj_FormValidator = new SubContrFileFormatValidator();
	            HtmlFileGenerator obj_FileGenerator = new HtmlFileGenerator();
	            String inFileName = inputFPUFilePath.trim();	            
	            String errorFileName;
	           // if(!fileSeparator.equalsIgnoreCase("/"))
	            errorFileName = inFileName.substring(0, inFileName.lastIndexOf("\\"));
	          //  else
	          //  errorFileName=inFileName.substring(0, inFileName.lastIndexOf("/"));	
	            String hashFileName = null;
	            String controlSheetFileName = null;
	            String htmlErrorFileName = null;
	            File addrFile = new File(inFileName);
	            String filePath = addrFile.getAbsolutePath();
	            String fileName = addrFile.getName();
	           
	            ArrayList listErrorVO = new ArrayList();
	            int errorCode = checkFileFolderName(fileName);
	            File errorDir = new File(errorFileName);
	            if(errorFileName.length() == 0)
	                errorCode = 8;
	            if(errorCode == 0)
	            {
	                int i;
	                for(i = inFileName.length() - 1; i > -1; i--)
	                {
	                    char ch;
	                    if((ch = inFileName.charAt(i)) == '.')
	                        break;
	                }

	                if(i > 0)
	                {
	                    int j;
	                    for(j = i; j > -1; j--)
	                        if((new StringBuilder(String.valueOf(inFileName.charAt(j)))).toString().equals(fileSeparator))
	                            break;

	                    hashFileName = (new StringBuilder(String.valueOf(errorFileName))).append(fileSeparator).append(inFileName.substring(j + 1, i)).append(".fvu").toString();
	                    htmlErrorFileName = (new StringBuilder(String.valueOf(errorFileName))).append(fileSeparator).append(inFileName.substring(j + 1, i)).append("err.html").toString();
	                    controlSheetFileName = (new StringBuilder(String.valueOf(errorFileName))).append(fileSeparator).append(inFileName.substring(j + 1, i)).append(".html").toString();
	                } else
	                {
	                    int j;
	                    for(j = inFileName.length() - 1; j > -1; j--)
	                        if((new StringBuilder(String.valueOf(inFileName.charAt(j)))).toString().equals(fileSeparator))
	                            break;
	                    hashFileName = (new StringBuilder(String.valueOf(errorFileName))).append(fileSeparator).append(inFileName.substring(j + 1, inFileName.length())).append(".fvu").toString();
	                    htmlErrorFileName = (new StringBuilder(String.valueOf(errorFileName))).append(fileSeparator).append(inFileName.substring(j + 1, inFileName.length())).append("err.html").toString();
	                    controlSheetFileName = (new StringBuilder(String.valueOf(errorFileName))).append(fileSeparator).append(inFileName.substring(j + 1, inFileName.length())).append(".html").toString();
	                }
	                if(errorDir.isDirectory())
	                    if(addrFile.exists() && addrFile.length() > 0L)
	                    {
	                        obj_FormValidator.readFile(inFileName, listErrorVO, 0);
	                        if(listErrorVO.size() == 0)
	                        {
	                            Hash hash = new Hash();	                            
	                            int hashError = hash.startProcessing(inFileName, hashFileName, 0, 5);
	                            if(hashError == 0)
	                            {
	                                SubContrOutputFileGenerator obj_FileGeneratorRep = new SubContrOutputFileGenerator();
	                                String hashFileLocation = hashFileName.substring(0, hashFileName.lastIndexOf(fileSeparator));
	                                obj_FileGeneratorRep.generateControlSheetReport(obj_FormValidator, controlSheetFileName, filePath, CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion"),"");
	                                System.out.println((new StringBuilder("File Validation Successful.\r\nUpload File,Control Sheet Report generated at \r\n")).append(hashFileLocation).toString());
	                            } else
	                            if(hashError != 0)
	                            {
	                                outputStatus = false;
	                                int lineNumber = hash.getRecordNumber();
	                                if (hashError == 3)
									{
                                        listErrorVO.add(new PAOContrErrorFileVO("-", FvuConstants.PEF_1012,FvuConstants.RECTYPE_FHREC, "-", "-","-", "1", "-"));
									}
									else if (hashError == 4)
									{
                                        listErrorVO.add(new PAOContrErrorFileVO("-", FvuConstants.PEF_1013,FvuConstants.RECTYPE_FHREC, "-", "-","-", "1", "-"));
									}
									else if (hashError == 5)
									{
                                        listErrorVO.add(new PAOContrErrorFileVO("-", FvuConstants.PEF_1014,FvuConstants.RECTYPE_FHREC, "-", "-","-", "1", "-"));
									}
									else if (hashError == 9)
									{
                                        listErrorVO.add(new PAOContrErrorFileVO("-", FvuConstants.PEF_1015,FvuConstants.RECTYPE_FHREC, "-", "-","-", "1", "-"));
									}
									else if (hashError == 10)
									{
                                        listErrorVO.add(new PAOContrErrorFileVO("-", FvuConstants.PEF_1016,FvuConstants.RECTYPE_FHREC, "-", "-","-", "1", "-"));
									}
									else if (hashError == 11)
									{
                                        listErrorVO.add(new PAOContrErrorFileVO("-", FvuConstants.PEF_1017,FvuConstants.RECTYPE_FHREC, "-", "-","-", "1", "-"));
									}
									else
									{
                                        listErrorVO.add(new PAOContrErrorFileVO("-", FvuConstants.PEF_1018,"-", "-", "-","-", lineNumber+"", "-"));
									}
									if(obj_FormValidator.uploadBy!= null && obj_FormValidator.uploadBy.equals(FvuConstants.UPLOADED_BY_UOS))
									{
										obj_FileGenerator.generateHtmlErrorFile(listErrorVO, "", "SUBSCRIBER CONTRIBUTION ERROR FILE", "<TR class=tdColumnDetails><TD WIDTH=70 VALIGN=top ><B>Line No</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Record Type</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Field Name & No.*</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>POP-SP Serial No.</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>    Subscriber Contribution Serial No.   </B></CENTER></TD> <TD WIDTH=85 VALIGN=top><B> PRAN </B></CENTER></TD> <TD WIDTH=130 VALIGN=top><B>    Error Code   </B></CENTER></TD><TD WIDTH=450 VALIGN=top><B>Error Description</B></CENTER></TD><TD WIDTH=130 VALIGN=top><B>Error / Warning</B></CENTER></TD></TR>", "<TABLE class=text><TR><TD>* Field Name & No. is as per the file format</TD></TR><TR><TD>FVU Version : " + CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion") + "</TD></TR><TR><TD> Input File Name : " + inFileName + "</TD></TR></TABLE>", htmlErrorFileName);
									}
									else if(obj_FormValidator.uploadBy!= null  && ( obj_FormValidator.uploadBy.equals(FvuConstants.UPLOADED_BY_AO) || obj_FormValidator.uploadBy.equals(FvuConstants.UPLOADED_BY_KA) || obj_FormValidator.uploadBy.equals(FvuConstants.UPLOADED_BY_AO_UPS)))
									{
										obj_FileGenerator.generateHtmlErrorFile(listErrorVO, "", "SUBSCRIBER CONTRIBUTION ERROR FILE", "<TR class=tdColumnDetails><TD WIDTH=70 VALIGN=top ><B>Line No</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Record Type</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Field Name & No.*</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>DDO Serial No.</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>    Subscriber Contribution Serial No.   </B></CENTER></TD> <TD WIDTH=85 VALIGN=top><B> PRAN </B></CENTER></TD> <TD WIDTH=130 VALIGN=top><B>    Error Code   </B></CENTER></TD><TD WIDTH=450 VALIGN=top><B>Error Description</B></CENTER></TD><TD WIDTH=130 VALIGN=top><B>Error / Warning</B></CENTER></TD></TR>", "<TABLE class=text><TR><TD>* Field Name & No. is as per the file format</TD></TR><TR><TD>FVU Version : " + CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion") + "</TD></TR><TR><TD> Input File Name : " + inFileName + "</TD></TR></TABLE>", htmlErrorFileName);
									}
									else if(obj_FormValidator.uploadBy!= null && ( obj_FormValidator.uploadBy.equals(FvuConstants.UPLOADED_BY_PRAO) || obj_FormValidator.uploadBy.equals(FvuConstants.UPLOADED_BY_PRAO_UPS)))
									{
										obj_FileGenerator.generateHtmlErrorFile(listErrorVO, "", "SUBSCRIBER CONTRIBUTION ERROR FILE", "<TR class=tdColumnDetails><TD WIDTH=70 VALIGN=top ><B>Line No</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Record Type</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Field Name & No.*</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>DTO Serial No.</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>    Subscriber Contribution Serial No.   </B></CENTER></TD> <TD WIDTH=85 VALIGN=top><B> PRAN </B></CENTER></TD> <TD WIDTH=130 VALIGN=top><B>    Error Code   </B></CENTER></TD><TD WIDTH=450 VALIGN=top><B>Error Description</B></CENTER></TD><TD WIDTH=130 VALIGN=top><B>Error / Warning</B></CENTER></TD></TR>", "<TABLE class=text><TR><TD>* Field Name & No. is as per the file format</TD></TR><TR><TD>FVU Version : " + CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion") + "</TD></TR><TR><TD> Input File Name : " + inFileName + "</TD></TR></TABLE>", htmlErrorFileName);
									}
									else if(obj_FormValidator.uploadBy!= null && obj_FormValidator.uploadBy.equals(FvuConstants.UPLOADED_BY_CORP))
									{
										obj_FileGenerator.generateHtmlErrorFile(listErrorVO, "", "SUBSCRIBER CONTRIBUTION ERROR FILE", "<TR class=tdColumnDetails><TD WIDTH=70 VALIGN=top ><B>Line No</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Record Type</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Field Name & No.*</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>CBO Serial No.</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>    Subscriber Contribution Serial No.   </B></CENTER></TD> <TD WIDTH=85 VALIGN=top><B> PRAN </B></CENTER></TD> <TD WIDTH=130 VALIGN=top><B>    Error Code   </B></CENTER></TD><TD WIDTH=450 VALIGN=top><B>Error Description</B></CENTER></TD><TD WIDTH=130 VALIGN=top><B>Error / Warning</B></CENTER></TD></TR>", "<TABLE class=text><TR><TD>* Field Name & No. is as per the file format</TD></TR><TR><TD>FVU Version : " + CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion") + "</TD></TR><TR><TD> Input File Name : " + inFileName + "</TD></TR></TABLE>", htmlErrorFileName);
									}
									else 
									{
										obj_FileGenerator.generateHtmlErrorFile(listErrorVO, "", "SUBSCRIBER CONTRIBUTION ERROR FILE", "<TR class=tdColumnDetails><TD WIDTH=70 VALIGN=top ><B>Line No</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Record Type</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Field Name & No.*</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>DDO/POP-SP/DTO/CBO Serial No.</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>    Subscriber Contribution Serial No.   </B></CENTER></TD> <TD WIDTH=85 VALIGN=top><B> PRAN </B></CENTER></TD> <TD WIDTH=130 VALIGN=top><B>    Error Code   </B></CENTER></TD><TD WIDTH=450 VALIGN=top><B>Error Description</B></CENTER></TD><TD WIDTH=130 VALIGN=top><B>Error / Warning</B></CENTER></TD></TR>", "<TABLE class=text><TR><TD>* Field Name & No. is as per the file format</TD></TR><TR><TD>FVU Version : " + CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion") + "</TD></TR><TR><TD> Input File Name : " + inFileName + "</TD></TR></TABLE>", htmlErrorFileName);
									}
									System.out.println((new StringBuilder("Errors Found during Validation.\r\nHTML Error File Generated\r\nOpen ")).append(htmlErrorFileName).append(" for details").toString());
	                            }
	                        } else
	                        {
	                            outputStatus = false;
	                            if(obj_FormValidator.uploadBy != null && obj_FormValidator.uploadBy.equals("U"))
	                                obj_FileGenerator.generateHtmlErrorFile(listErrorVO, "", "SUBSCRIBER CONTRIBUTION ERROR FILE", "<TR class=tdColumnDetails><TD WIDTH=70 VALIGN=top ><B>Line No</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Record Type</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Field Name & No.*</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>POP-SP Serial No.</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>    Subscriber Contribution Serial No.   </B></CENTER></TD> <TD WIDTH=85 VALIGN=top><B> PRAN </B></CENTER></TD> <TD WIDTH=130 VALIGN=top><B>    Error Code   </B></CENTER></TD><TD WIDTH=450 VALIGN=top><B>Error Description</B></CENTER></TD><TD WIDTH=130 VALIGN=top><B>Error / Warning</B></CENTER></TD></TR>", (new StringBuilder("<TABLE class=text><TR><TD>* Field Name & No. is as per the file format</TD></TR><TR><TD>FVU Version : ")).append(CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion")).append("</TD></TR><TR><TD> Input File Name : ").append(inFileName).append("</TD></TR></TABLE>").toString(), htmlErrorFileName);
	                            else
	                            if(obj_FormValidator.uploadBy != null && (obj_FormValidator.uploadBy.equals("P") || obj_FormValidator.uploadBy.equals("K") || obj_FormValidator.uploadBy.equals("PD")))
	                                obj_FileGenerator.generateHtmlErrorFile(listErrorVO, "", "SUBSCRIBER CONTRIBUTION ERROR FILE", "<TR class=tdColumnDetails><TD WIDTH=70 VALIGN=top ><B>Line No</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Record Type</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Field Name & No.*</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>DDO Serial No.</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>    Subscriber Contribution Serial No.   </B></CENTER></TD> <TD WIDTH=85 VALIGN=top><B> PRAN </B></CENTER></TD> <TD WIDTH=130 VALIGN=top><B>    Error Code   </B></CENTER></TD><TD WIDTH=450 VALIGN=top><B>Error Description</B></CENTER></TD><TD WIDTH=130 VALIGN=top><B>Error / Warning</B></CENTER></TD></TR>", (new StringBuilder("<TABLE class=text><TR><TD>* Field Name & No. is as per the file format</TD></TR><TR><TD>FVU Version : ")).append(CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion")).append("</TD></TR><TR><TD> Input File Name : ").append(inFileName).append("</TD></TR></TABLE>").toString(), htmlErrorFileName);
	                            else
	                            if(obj_FormValidator.uploadBy != null && obj_FormValidator.uploadBy.equals("O")  || obj_FormValidator.uploadBy.equals("OD"))
	                                obj_FileGenerator.generateHtmlErrorFile(listErrorVO, "", "SUBSCRIBER CONTRIBUTION ERROR FILE", "<TR class=tdColumnDetails><TD WIDTH=70 VALIGN=top ><B>Line No</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Record Type</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Field Name & No.*</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>DTO Serial No.</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>    Subscriber Contribution Serial No.   </B></CENTER></TD> <TD WIDTH=85 VALIGN=top><B> PRAN </B></CENTER></TD> <TD WIDTH=130 VALIGN=top><B>    Error Code   </B></CENTER></TD><TD WIDTH=450 VALIGN=top><B>Error Description</B></CENTER></TD><TD WIDTH=130 VALIGN=top><B>Error / Warning</B></CENTER></TD></TR>", (new StringBuilder("<TABLE class=text><TR><TD>* Field Name & No. is as per the file format</TD></TR><TR><TD>FVU Version : ")).append(CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion")).append("</TD></TR><TR><TD> Input File Name : ").append(inFileName).append("</TD></TR></TABLE>").toString(), htmlErrorFileName);
	                            else
	                            if(obj_FormValidator.uploadBy != null && obj_FormValidator.uploadBy.equals("Z"))
	                                obj_FileGenerator.generateHtmlErrorFile(listErrorVO, "", "SUBSCRIBER CONTRIBUTION ERROR FILE", "<TR class=tdColumnDetails><TD WIDTH=70 VALIGN=top ><B>Line No</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Record Type</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Field Name & No.*</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>CBO Serial No.</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>    Subscriber Contribution Serial No.   </B></CENTER></TD> <TD WIDTH=85 VALIGN=top><B> PRAN </B></CENTER></TD> <TD WIDTH=130 VALIGN=top><B>    Error Code   </B></CENTER></TD><TD WIDTH=450 VALIGN=top><B>Error Description</B></CENTER></TD><TD WIDTH=130 VALIGN=top><B>Error / Warning</B></CENTER></TD></TR>", (new StringBuilder("<TABLE class=text><TR><TD>* Field Name & No. is as per the file format</TD></TR><TR><TD>FVU Version : ")).append(CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion")).append("</TD></TR><TR><TD> Input File Name : ").append(inFileName).append("</TD></TR></TABLE>").toString(), htmlErrorFileName);
	                            else
	                                obj_FileGenerator.generateHtmlErrorFile(listErrorVO, "", "SUBSCRIBER CONTRIBUTION ERROR FILE", "<TR class=tdColumnDetails><TD WIDTH=70 VALIGN=top ><B>Line No</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Record Type</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Field Name & No.*</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>DDO/POP-SP/DTO/CBO Serial No.</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>    Subscriber Contribution Serial No.   </B></CENTER></TD> <TD WIDTH=85 VALIGN=top><B> PRAN </B></CENTER></TD> <TD WIDTH=130 VALIGN=top><B>    Error Code   </B></CENTER></TD><TD WIDTH=450 VALIGN=top><B>Error Description</B></CENTER></TD><TD WIDTH=130 VALIGN=top><B>Error / Warning</B></CENTER></TD></TR>", (new StringBuilder("<TABLE class=text><TR><TD>* Field Name & No. is as per the file format</TD></TR><TR><TD>FVU Version : ")).append(CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion")).append("</TD></TR><TR><TD> Input File Name : ").append(inFileName).append("</TD></TR></TABLE>").toString(), htmlErrorFileName);
	                            System.out.println((new StringBuilder("Errors Found during Validation.\r\nHTML Error File Generated\r\nOpen ")).append(htmlErrorFileName).append(" for details").toString());
	                        }
	                    } else
	                    {
	                    	listErrorVO.add(new PAOContrErrorFileVO("-", FvuConstants.PEF_1011,FvuConstants.RECTYPE_FHREC, "-", "-","-", "1", "-"));
							obj_FileGenerator.generateHtmlErrorFile(listErrorVO, "", "SUBSCRIBER CONTRIBUTION ERROR FILE", "<TR class=tdColumnDetails><TD WIDTH=70 VALIGN=top ><B>Line No</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Record Type</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Field Name & No.*</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>DDO/POP-SP/DTO Serial No.</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>    Subscriber Contribution Serial No.   </B></CENTER></TD> <TD WIDTH=85 VALIGN=top><B> PRAN </B></CENTER></TD> <TD WIDTH=130 VALIGN=top><B>    Error Code   </B></CENTER></TD><TD WIDTH=450 VALIGN=top><B>Error Description</B></CENTER></TD><TD WIDTH=130 VALIGN=top><B>Error / Warning</B></CENTER></TD></TR>", "<TABLE class=text><TR><TD>* Field Name & No. is as per the file format</TD></TR><TR><TD>FVU Version : " + CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion") + "</TD></TR><TR><TD> Input File Name : " + inFileName + "</TD></TR></TABLE>", htmlErrorFileName);
							   System.out.println((new StringBuilder("Errors Found during Validation.\r\nHTML Error File Generated\r\nOpen ")).append(htmlErrorFileName).append(" for details").toString());
	                    }
	            } else
	            if(errorCode == 1 || errorCode == 8)
	                System.out.println("Input File Name with Path or \n Error/Upload and Control Sheet Report File Path not chosen");
	            else
	            if(errorCode == 2)
	                System.out.println("Invalid Input File Name. Length of Input File Name cannot be more than 12 characters (including extension).");
	            else
	            if(errorCode == 3)
	                System.out.println("Invalid Input File Name");
	            else
	            if(errorCode == 5)
	                System.out.println("Invalid File Name.\n  :  /  ?  >  <  *  \"  |  \\  ^  _ or Space, not allowed in File Name.");
	            else
	            if(errorCode == 6)
	                System.out.println("Invalid Input File extension. File extension should be '.txt'");
	        }
									
	        		 
}
	
	private int checkFileFolderName(String testName)
	{
		if (testName.length() == 0)
			return 1;
		if (testName.length() <= 3)
			return 3;
		if (testName.length() > 12)
			return 2;
		if (testName.trim().length() >= 5)
		{
			String subName = testName.substring(0, 4);
			//	check if the file name contains  'COM1.' , 'COM2.' , 'LTP1.' , 'LTP2.' , 'NUL.' , 'CON.'     
			if (subName.equalsIgnoreCase("COM1.")
				|| subName.equalsIgnoreCase("COM2.")
				|| subName.equalsIgnoreCase("COM3.")
				|| subName.equalsIgnoreCase("COM4.")
				|| subName.equalsIgnoreCase("COM5.")
				|| subName.equalsIgnoreCase("COM6.")
				|| subName.equalsIgnoreCase("COM7.")
				|| subName.equalsIgnoreCase("COM8.")
				|| subName.equalsIgnoreCase("COM9.")
				|| subName.equalsIgnoreCase("LTP1.")
				|| subName.equalsIgnoreCase("LTP2.")
				|| subName.equalsIgnoreCase("LTP3.")
				|| subName.equalsIgnoreCase("LTP4.")
				|| subName.equalsIgnoreCase("LTP5.")
				|| subName.equalsIgnoreCase("LTP6.")
				|| subName.equalsIgnoreCase("LTP7.")
				|| subName.equalsIgnoreCase("LTP8.")
				|| subName.equalsIgnoreCase("LTP9."))
				return 3;
		}
		if (testName.trim().length() >= 4)
		{
			if (testName.substring(0, 3).equalsIgnoreCase("NUL.") || testName.substring(0, 3).equalsIgnoreCase("CON."))
				return 3;
		}
		//	check if the file name contains  '/' , ':' , '?', '>', '<', '*', '"', '|', '\', '^', Under score or Space
        for (int localI = 0; localI < testName.length(); localI++)
		{
			if (testName.charAt(localI) == '/'
				|| testName.charAt(localI) == ':'
				|| testName.charAt(localI) == '*'
				|| testName.charAt(localI) == '?'
				|| testName.charAt(localI) == '"'
				|| testName.charAt(localI) == '<'
				|| testName.charAt(localI) == '>'
				|| testName.charAt(localI) == '|'
				|| testName.charAt(localI) == '\\'
				|| testName.charAt(localI) == ' '
				|| testName.charAt(localI) == '_'
				|| testName.charAt(localI) == '^')
				return 5;
		}
		int alphaDigit = 3;
		for (int localY = 0; localY < testName.length(); localY++)
		{
			if (Character.isLetterOrDigit(testName.charAt(localY)))
			{
				alphaDigit = 0;
				break;
			}
		}
		if (alphaDigit == 3)
		{
			return 3;
		}

		if (!testName.trim().endsWith(".txt") && !testName.trim().endsWith(".TXT"))
		{
			return 6;
		}
		return 0;
	}



}
