/**	
 *	Class: PAOFvu.java		
 */
package cra.standalone.paosubcontr;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;

import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.filechooser.FileFilter;

import com.cra.contr.common.util.CRAConfigReader;
import com.cra.contr.common.util.HtmlFileGenerator;
import com.cra.contr.common.util.file.CRABasicFileWriter;
import com.cra.contr.common.util.encrypt.Hash;


import com.cra.pao.fvu.SubContrFileFormatValidator;
import com.cra.pao.fvu.FvuConstants;
import com.cra.pao.vo.PAOContrErrorFileVO;
import cra.standalone.paosubcontr.util.SubContrOutputFileGenerator;
import cra.standalone.paosubcontr.util.SubContrOutputFileGeneratorUPS;

import com.cra.pao.ups.fvu.*;
/**
 *	This class contains the main() method. This will create the FVU user interface
 *	which will contain all the buttons for selecting the input file name and the path for generating
 *	the output filename and valdation button. 
 *
 * 	@author TCS
 */
public class PAOFvu extends JFrame
{
	private static final long serialVersionUID = "cra.standalone.paosubcontr.PAOFvu".hashCode();
    public final int utilityLevel = 0; // Specifies the Level of Utility. '0' Signifies Standalone FVU.
	final static int fhFieldCount = 5; // Number of Fields in File Header Record 
	final static int fhFieldCount_GOVT = 9; // Number of Fields in File Header Record of CG/SG
	private javax.swing.JPanel jContentPane = null;
	private javax.swing.JLabel jLabel = null;
	private javax.swing.JLabel jLabel1 = null;
	private javax.swing.JTextField txtInputFileName = null;
	private javax.swing.JTextField txtErrorFilePath = null;
	private javax.swing.JButton btnValidate = null;
	private javax.swing.JButton btnExit = null;
	private javax.swing.JButton btnHelp = null;
	private javax.swing.JButton btnbrowseInputFileName = null;
	private javax.swing.JButton btnbrowseErrorFilePath = null;
	private javax.swing.JTextPane jHelpTextPane = null;
    public String file;
    
	private String previousSorurceFileFolder = "";
	// Store the path of Previous Input Folder opened by File Chooser
	private String previousOutputFileFolder = "";
	// Store the path of Previous Output (To Save Error File ) Folder opened by File Chooser
	final String errorMsg_01 = "Input File Name with Path or \n Error/Upload and Control Sheet Report File Path not chosen";
	final String errorMsg_02 = "Invalid Input File Name. Length of Input File Name cannot be more than 24 characters (including extension).";
	final String errorMsg_03 = "Invalid Input File Name";
	final String errorMsg_04 = "Invalid File Name.\n  :  /  ?  >  <  *  \"  |  \\  ^  _ or Space, not allowed in File Name.";
	final String errorMsg_05 = "Error/Upload and Control Sheet Report File Path does not exist or \n File Name specified along with path.";
	final String errorMsg_06 = "Invalid Input File extension. File extension should be '.txt'";
	public static String unequalFlag;
	public static String OSEqualFlag;//Added For FTR-39795
	public static String batchId;
	 //CR-59184
    public static String OSUPSFlag;
    
	static{
		String unequalFlagg = CRAConfigReader.getConfigVal("unequal.flag");
    	unequalFlag = unequalFlagg;
    	//Added For FTR-39795 .START
    	String OSEqualFlagg = CRAConfigReader.getConfigVal("OS.equal.14.flag");
    	OSEqualFlag = OSEqualFlagg;
    	//Added For FTR-39795 .END
    	//CR-59184
    	String OSUPSFlags = CRAConfigReader.getConfigVal("OS.UPS.Flag");
    	OSUPSFlag = OSUPSFlags;
    	
    }
	
	public static void main(String[] args)
	{
		System.out.println("start Time :: "+System.currentTimeMillis());
		if (args.length == 5)
		{
			//CRALog.paoLog.info("SAM SCM called");
			String inFileNameSAM = args[0]; //Getting the input file name with path
			String errorFileNameSAM = args[1]; //Generating the name of the error file
			String outFileNameSAM = args[2]; // Name of Generated HASH File
			String utilityLevelSamScm = args[3]; //Gives whether the function is being called by FVU,SAM,SCM,STM
			String samScmFvuVersion = args[4]; //FVU version passed as a input parameter
			
			/*String inFileNameSAM = "C:/Documents and Settings/tcs_siddheshl.NSDLC966/Desktop/bds.fvu";
			String errorFileNameSAM = "C:/Documents and Settings/tcs_siddheshl.NSDLC966/Desktop/bds.err";
			String outFileNameSAM = "C:/Documents and Settings/tcs_siddheshl.NSDLC966/Desktop/output files/bds.fvu";
			String utilityLevelSamScm = "1"; //Gives whether the function is being called by FVU,SAM,SCM,STM
			String samScmFvuVersion = "1.09"; //FVU version passed as a input parameter
           */
			File f1 = new File(inFileNameSAM);
			File f2 = new File(outFileNameSAM);
			
			
			
			int utilityLevelInt = Integer.parseInt(utilityLevelSamScm.trim());
			
			//FileGenerator obj_FileGenerator = new FileGenerator();
           //HtmlFileGenerator obj_FileGenerator = new HtmlFileGenerator();
			
			StringBuffer FH_obj_StringBuffer = new StringBuffer();
			ArrayList<PAOContrErrorFileVO> listErrorVO = new ArrayList<PAOContrErrorFileVO>();

			//utility level check added for jar check in case of SAM,SCM
			//in case of FVU,CRA Cenntral System this jar check is not performed
			if (utilityLevelInt == 1 || utilityLevelInt == 2)
			{
				if (!samScmFvuVersion.equals(CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion")))
				{
                    listErrorVO.add(new PAOContrErrorFileVO("-", FvuConstants.PEF_1019,FvuConstants.RECTYPE_FHREC,"-", "-","-", "1", "-"));
                    FH_obj_StringBuffer = convertArrayListtoBuffer(listErrorVO);
                    
					try
					{
						//obj_FileGenerator.writeToFile(errorFileNameSAM, FH_obj_StringBuffer.toString(), 0);
						CRABasicFileWriter.writeFileLocal(errorFileNameSAM, FH_obj_StringBuffer);
                        //obj_FileGenerator.generateHtmlErrorFile(listErrorVO, "", "PAO CONTRIBUTION ERROR FILE", "<TR class=tdColumnDetails><TD WIDTH=70 VALIGN=top ><B>Line No</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Record Type</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Field Name & No.*</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>DDO Serial No.</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>    Subscriber Contribution Serial No.   </B></CENTER></TD><TD WIDTH=130 VALIGN=top><B>    Error Code   </B></CENTER></TD><TD WIDTH=450 VALIGN=top><B>Error Description</B></CENTER></TD><TD WIDTH=130 VALIGN=top><B>Error / Warning</B></CENTER></TD></TR>", "<TABLE class=text><TR><TD>* Field Name & No. is as per the file format</TD></TR><TR><TD>FVU Version : "+CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion")+"</TD></TR><TR><TD> Input File Name : " +inFileNameSAM+"</TD></TR></TABLE>", errorFileNameSAM);
					}
					catch (IOException e)
					{
						e.printStackTrace();
					}
					System.exit(0); //if jar does not match exit
				}
			}
			/*
			 * Temp add
			 */
			SubContrFileFormatValidator obj_FormValidator = new SubContrFileFormatValidator();
			//CR-59184
			com.cra.pao.ups.fvu.SubContrFileFormatValidator formValidatorUPS = new com.cra.pao.ups.fvu.SubContrFileFormatValidator();
			try
			{
                //CRALog.paoLog.info("SAM SCM readFile() called ");
				//CR-59184
				if(PAOFvu.OSUPSFlag.equalsIgnoreCase("Y"))
					formValidatorUPS.readFile(inFileNameSAM, listErrorVO, utilityLevelInt);
				else
					obj_FormValidator.readFile(inFileNameSAM, listErrorVO, utilityLevelInt);
                //CRALog.paoLog.info("SAM SCM RETURN From freadFile()");
			}
			catch (Exception e1)
			{
                //CRALog.paoLog.error(e1);
				e1.printStackTrace();
			}
			if (listErrorVO.size() == 0)
			{
				/**	
				 *	Hash validation called in hash.java. It returns appropriate error code and 0 on successful 
				 *	hash validation. Description of error codes given at the start of Hash.java
				 */
				Hash hashObj = new Hash();
				System.out.println("Start Hash");
				int hashCode = hashObj.startProcessing(inFileNameSAM, outFileNameSAM, utilityLevelInt, fhFieldCount);
	            //CRALog.paoLog.info("SAM SCM called hashCode : " + hashCode);
	            if (hashCode != 0)
				{
	                
					//	Write appropriate error message in the files as per the error code returned
					int lineNumber = hashObj.getRecordNumber();
	                if (hashCode == 3)
	                {
	                    listErrorVO.add(new PAOContrErrorFileVO("-", FvuConstants.PEF_1012,FvuConstants.RECTYPE_FHREC, "-", "-","-", "1", "-"));
	                    
	                }
	                else if (hashCode == 4)
	                {
	                   listErrorVO.add(new PAOContrErrorFileVO("-", FvuConstants.PEF_1013,FvuConstants.RECTYPE_FHREC, "-", "-","-", "1", "-"));
	                	
	                }
	                else if (hashCode == 5)
	                {
	                    listErrorVO.add(new PAOContrErrorFileVO("-", FvuConstants.PEF_1014,FvuConstants.RECTYPE_FHREC, "-", "-","-", "1", "-"));
	                	
	                }
	                else if (hashCode == 9)
	                {
	                    listErrorVO.add(new PAOContrErrorFileVO("-", FvuConstants.PEF_1015,FvuConstants.RECTYPE_FHREC, "-", "-","-", "1", "-"));
	                	
	                }
	                else if (hashCode == 10)
	                {
	                    listErrorVO.add(new PAOContrErrorFileVO("-", FvuConstants.PEF_1016,FvuConstants.RECTYPE_FHREC, "-", "-","-", "1", "-"));
	                	
	                }
	                else if (hashCode == 11)
	                {
	                    listErrorVO.add(new PAOContrErrorFileVO("-", FvuConstants.PEF_1017,FvuConstants.RECTYPE_FHREC, "-", "-","-", "1", "-"));
	                	
	                }
	                else
	                {
	                    listErrorVO.add(new PAOContrErrorFileVO("-", FvuConstants.PEF_1018,"-", "-", "-","-", lineNumber+"", "-"));
	                	
	                }

					try
					{
						//obj_FileGenerator.writeToFile(errorFileNameSAM, FH_obj_StringBuffer.toString(), 0);
	                   // obj_FileGenerator.generateHtmlErrorFile(listErrorVO, "", "PAO CONTRIBUTION ERROR FILE", "<TR class=tdColumnDetails><TD WIDTH=70 VALIGN=top ><B>Line No</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Record Type</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Field Name & No.*</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>DDO Serial No.</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>    Subscriber Contribution Serial No.   </B></CENTER></TD><TD WIDTH=130 VALIGN=top><B>    Error Code   </B></CENTER></TD><TD WIDTH=450 VALIGN=top><B>Error Description</B></CENTER></TD><TD WIDTH=130 VALIGN=top><B>Error / Warning</B></CENTER></TD></TR>", "<TABLE class=text><TR><TD>* Field Name & No. is as per the file format</TD></TR><TR><TD>FVU Version : PAOFVUVersion</TD></TR><TR><TD> Input File Name : " + "inputFileName.txt</TD></TR></TABLE>", errorFileNameSAM);
						FH_obj_StringBuffer = convertArrayListtoBuffer(listErrorVO);
	                    CRABasicFileWriter.writeFileLocal(errorFileNameSAM, FH_obj_StringBuffer);
					}
					catch (IOException e)
					{
						e.printStackTrace();
					}
				}
	            else if (hashCode == 0)
				{
	            	/**	
					 *	Prepare FVU file 
					 */
					try
					{
						String dataRecord = null;
	
						// Write Data that will be used by SAM / SCM in File
						String samScmString = obj_FormValidator.getControlSheetBuffer().toString();
						StringBuffer samScmStringBuffer =getRAWData(samScmString,"^");
						//StringBuffer samScmStringBuffer = obj_FormValidator.getControlSheetBuffer();
						
						String samScmDataFlNm = outFileNameSAM + ".raw";
						//obj_FileGenerator.writeToFile(samScmDataFlNm, samScmString, 0, false);
						 CRABasicFileWriter.writeFileLocal(samScmDataFlNm, samScmStringBuffer);
	                   
						// Write Data that will be used by SAM / SCM in File
						/*BufferedReader brRead = new BufferedReader(new FileReader(inFileNameSAM));
						PrintWriter outWrite = new PrintWriter(new BufferedWriter(new FileWriter(outFileNameSAM, true)));
						while ((dataRecord = brRead.readLine()) != null)
						{
							outWrite.println(dataRecord);
						}
						outWrite.flush();
						outWrite.close();
						brRead.close();*/
						 /* CR 32010 */
							try{
								SubContrOutputFileGenerator obj_FileGeneratorRep = new SubContrOutputFileGenerator();
								 if (inFileNameSAM != null && !inFileNameSAM.equals("")&& inFileNameSAM.indexOf(".") > 0)
								 {
									 String controlSheetReportPath = inFileNameSAM.substring(0, inFileNameSAM.lastIndexOf("."));
									 controlSheetReportPath=controlSheetReportPath + ".html";
									 obj_FileGeneratorRep.generateControlSheetReport(obj_FormValidator, controlSheetReportPath, inFileNameSAM, CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion"),batchId);	
 
								 }								 
							}catch (Exception e)
							{
								e.printStackTrace();
							}
						 /* END CR 32010 */
					}
					catch (Exception e)
					{
	                    //CRALog.paoLog.error(e);
						e.printStackTrace();
					}
				}
				//f1.renameTo(f2);
			}
			else
			{
                //CRALog.paoLog.info("Errors Found during Validation.\r\nOpen " + errorFileNameSAM + " for details");
				try
				{
					//obj_FileGenerator.writeToFile(errorFileNameSAM, obj_FormValidator.errStrBuff.errorBufferString.toString(), 0);
					FH_obj_StringBuffer = convertArrayListtoBuffer(listErrorVO);
					CRABasicFileWriter.writeFileLocal(errorFileNameSAM, FH_obj_StringBuffer);
					//obj_FileGenerator.generateHtmlErrorFile(listErrorVO, "", "PAO CONTRIBUTION ERROR FILE", "<TR class=tdColumnDetails><TD WIDTH=70 VALIGN=top ><B>Line No</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Record Type</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Field Name & No.*</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>DDO Serial No.</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>    Subscriber Contribution Serial No.   </B></CENTER></TD><TD WIDTH=130 VALIGN=top><B>    Error Code   </B></CENTER></TD><TD WIDTH=450 VALIGN=top><B>Error Description</B></CENTER></TD><TD WIDTH=130 VALIGN=top><B>Error / Warning</B></CENTER></TD></TR>", "<TABLE class=text><TR><TD>* Field Name & No. is as per the file format</TD></TR><TR><TD>FVU Version : PAOFVUVersion</TD></TR><TR><TD> Input File Name : " + "inputFileName.txt</TD></TR></TABLE>", errorFileNameSAM);
				}
				catch (IOException e)
				{
					e.printStackTrace();
				}
			}
			//end temp add
			
			
		}
		else if (args.length == 0)
		{
			System.out.println("Arg zero");
            //CRALog.paoLog.info("Standalone FVU InterFace called");
			PAOFvu f = new PAOFvu();
			f.setVisible(true);
		}
		else
        {
            //CRALog.paoLog.error("Exception : Invalid Number of arguments passed in Main() : ");
        }
		
	}
	/**
	 * This is the default constructor
	 */
	public PAOFvu()
	{
		super();
		initialize();
	}
	private static StringBuffer getRAWData(String StringToParse, String Seperator)
	{
		StringBuilder rawDataBuffer = new StringBuilder();
		StringTokenizer rawData = new StringTokenizer(StringToParse, Seperator);
		//System.out.println("Tokenizing the String : " + StringToParse);
		int counter = 0;
		while (rawData.hasMoreTokens())
		{
			String token = rawData.nextToken();
			if (counter == 0) // Upload By
            {
				rawDataBuffer.append(token.trim() + FvuConstants.FIELD_SEPERATOR);   
            }
            else if (counter == 1) // Number of batches
			{
            	rawDataBuffer.append(token.trim() + FvuConstants.FIELD_SEPERATOR);   
			}
			else if (counter == 5) // Type of Uploaded File
			{
				rawDataBuffer.append(token.trim() + FvuConstants.FIELD_SEPERATOR);   
			}
			else if (counter == 6) // PAO AIN
			{
				rawDataBuffer.append(token.trim() + FvuConstants.FIELD_SEPERATOR);   
			}
			else if (counter == 7) // File Creation Date
			{
				rawDataBuffer.append(token.trim() + FvuConstants.FIELD_SEPERATOR);   
			}
            else if (counter == 8) // Batch ID
			{
            	rawDataBuffer.append(token.trim() + FvuConstants.FIELD_SEPERATOR);   
			}
			else if (counter == 9) // Transaction ID
			{
				rawDataBuffer.append(token.trim() + FvuConstants.FIELD_SEPERATOR);   
			}
			else if (counter == 10) // Count of DDO Records
			{
				rawDataBuffer.append(token.trim() + FvuConstants.FIELD_SEPERATOR);   
			}
			else if (counter == 11) // Count of Subscriber Detail Records
			{
				rawDataBuffer.append(token.trim() + FvuConstants.FIELD_SEPERATOR);   
			}
			else if (counter == 12) // Total Government Contribution in Batch
			{
				rawDataBuffer.append(token.trim() + FvuConstants.FIELD_SEPERATOR);   
			}
			else if (counter == 13) // Total Self Contribution in Batch
			{
				rawDataBuffer.append(token.trim() + FvuConstants.FIELD_SEPERATOR);   
			}
            else if (counter == 14) // Total Self Contribution in Batch
            {
            	rawDataBuffer.append(token.trim() + FvuConstants.FIELD_SEPERATOR);   
            }
            
			counter++;
		}
		return new StringBuffer(rawDataBuffer.toString());
	}

	private static  StringBuffer convertArrayListtoBuffer(ArrayList<PAOContrErrorFileVO> listErrorVO)
	{
		StringBuffer errorBuffer=new StringBuffer();
		
		String tagName = null;
		String errorCode;
		String ErrorDescription = null;
		String recordType = null;
		String serialNumberInDDO = null;
		String serialNumber = null;
		String lineNumber = null;
		//String responseType = null;
		//System.out.println("listErrorVO.size()::::::::"+listErrorVO.size());
		for(int i=0 ; i< listErrorVO.size() ; i++)
		{
			tagName = listErrorVO.get(i).getTagName();
			errorCode = new Integer(listErrorVO.get(i).getErrorCode()).toString();
			ErrorDescription = listErrorVO.get(i).getErrorDescription();
			recordType = listErrorVO.get(i).getRecordType();
			serialNumberInDDO = listErrorVO.get(i).getSerialNumberInDDO();
			serialNumber = listErrorVO.get(i).getSerialNumber();
			lineNumber = listErrorVO.get(i).getLineNumber();
			//responseType = listErrorVO.get(i).getResponseType();
			
			//errorBuffer.append(tagName +"^" +errorCode +"^" + ErrorDescription + "^" + recordType +"^"+ serialNumberInDDO +"^" + serialNumber +"^" + lineNumber +"^"+ responseType);
			errorBuffer.append(tagName +"^" +errorCode +"^" + ErrorDescription + "^" + recordType +"^"+ serialNumberInDDO +"^" + serialNumber +"^" + lineNumber);
			errorBuffer.append("\n");
			//System.out.println("errorCode::::::::"+errorCode);
			//System.out.println("lineNumber::::::::"+lineNumber);
		}
		return errorBuffer;
		
	}
	/**
	 *	This method initializes the components sucha as button, dialog box,  
	 *	text field etc., for the FVU interface
	 *	@param	No parameters are specified 
	 *	@return	void
	 */
	private void initialize()
	{
		this.setSize(600, 180);
		this.setLocation(250, 250);
		this.setContentPane(getJContentPane());
		this.setTitle("Subscriber Contribution File Validation Utility - Version " + CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion"));
		this.setResizable(false);
		btnValidate.setEnabled(false);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		this.setIconImage(java.awt.Toolkit.getDefaultToolkit().getImage(getClass().getResource("/cra/standalone/paosubcontr/nsdl-logo.jpg")));
		this.addWindowListener(new WindowAdapter()
		{
			public void windowClosing(WindowEvent e)
			{
				System.exit(0);
			}
		});
	}
	/**
	 * This method initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	private javax.swing.JPanel getJContentPane()
	{
		if (jContentPane == null)
		{
			jContentPane = new javax.swing.JPanel();
			java.awt.GridBagConstraints consGridBagConstraints14 = new java.awt.GridBagConstraints();
			java.awt.GridBagConstraints consGridBagConstraints15 = new java.awt.GridBagConstraints();
			java.awt.GridBagConstraints consGridBagConstraints16 = new java.awt.GridBagConstraints();
			java.awt.GridBagConstraints consGridBagConstraints12 = new java.awt.GridBagConstraints();
			java.awt.GridBagConstraints consGridBagConstraints17 = new java.awt.GridBagConstraints();
			java.awt.GridBagConstraints consGridBagConstraints38 = new java.awt.GridBagConstraints();
			java.awt.GridBagConstraints consGridBagConstraints18 = new java.awt.GridBagConstraints();
			java.awt.GridBagConstraints consGridBagConstraints39 = new java.awt.GridBagConstraints();
			java.awt.GridBagConstraints consGridBagConstraints40 = new java.awt.GridBagConstraints();
			java.awt.GridBagConstraints consGridBagConstraints41 = new java.awt.GridBagConstraints();
			java.awt.GridBagConstraints consGridBagConstraints42 = new java.awt.GridBagConstraints();
			java.awt.GridBagConstraints consGridBagConstraints43 = new java.awt.GridBagConstraints();
			java.awt.GridBagConstraints consGridBagConstraints45 = new java.awt.GridBagConstraints();
			java.awt.GridBagConstraints consGridBagConstraints44 = new java.awt.GridBagConstraints();
			java.awt.GridBagConstraints consGridBagConstraints1 = new java.awt.GridBagConstraints();
			consGridBagConstraints1.gridy = 2;
			consGridBagConstraints1.gridx = 3;
			consGridBagConstraints1.gridwidth = 1;
			consGridBagConstraints1.insets = new java.awt.Insets(6, 7, 10, 10);
			consGridBagConstraints45.insets = new java.awt.Insets(6, 5, 10, 100);
			consGridBagConstraints45.gridy = 2;
			consGridBagConstraints45.gridx = 2;
			consGridBagConstraints17.gridy = 8;
			consGridBagConstraints17.gridx = 0;
			consGridBagConstraints17.gridheight = 2;
			consGridBagConstraints14.gridy = 2;
			consGridBagConstraints14.gridx = 0;
			consGridBagConstraints18.gridy = 8;
			consGridBagConstraints18.gridx = 1;
			consGridBagConstraints15.fill = java.awt.GridBagConstraints.BOTH;
			consGridBagConstraints15.weightx = 1.0;
			consGridBagConstraints15.gridy = 1;
			consGridBagConstraints15.gridx = 1;
			consGridBagConstraints16.fill = java.awt.GridBagConstraints.BOTH;
			consGridBagConstraints16.weightx = 1.0;
			consGridBagConstraints16.gridy = 2;
			consGridBagConstraints16.gridx = 1;
			consGridBagConstraints43.insets = new java.awt.Insets(8, 7, 4, 10);
			consGridBagConstraints43.gridy = 1;
			consGridBagConstraints43.gridx = 3;
			consGridBagConstraints43.anchor = java.awt.GridBagConstraints.EAST;
			consGridBagConstraints12.gridy = 1;
			consGridBagConstraints12.gridx = 0;
			consGridBagConstraints12.anchor = java.awt.GridBagConstraints.NORTH;
			consGridBagConstraints12.fill = java.awt.GridBagConstraints.BOTH;
			consGridBagConstraints14.fill = java.awt.GridBagConstraints.BOTH;
			consGridBagConstraints42.insets = new java.awt.Insets(11, 7, 7, 3);
			consGridBagConstraints42.fill = java.awt.GridBagConstraints.HORIZONTAL;
			consGridBagConstraints42.weightx = 1.0;
			consGridBagConstraints42.gridwidth = 2;
			consGridBagConstraints42.gridy = 1;
			consGridBagConstraints42.gridx = 1;
			consGridBagConstraints39.insets = new java.awt.Insets(11, 7, 7, 3);
			consGridBagConstraints39.fill = java.awt.GridBagConstraints.HORIZONTAL;
			consGridBagConstraints39.weightx = 1.0;
			consGridBagConstraints39.gridwidth = 2;
			consGridBagConstraints39.gridy = 0;
			consGridBagConstraints39.gridx = 1;
			consGridBagConstraints40.insets = new java.awt.Insets(8, 7, 4, 10);
			consGridBagConstraints40.gridy = 0;
			consGridBagConstraints40.gridx = 3;
			consGridBagConstraints40.anchor = java.awt.GridBagConstraints.EAST;
			consGridBagConstraints38.insets = new java.awt.Insets(13, 10, 9, 3);
			consGridBagConstraints38.gridy = 0;
			consGridBagConstraints38.gridx = 0;
			consGridBagConstraints38.anchor = java.awt.GridBagConstraints.WEST;
			consGridBagConstraints38.fill = java.awt.GridBagConstraints.NONE;
			consGridBagConstraints45.gridwidth = 2;
			consGridBagConstraints44.insets = new java.awt.Insets(6, 121, 12, 5);
			consGridBagConstraints44.gridwidth = 2;
			consGridBagConstraints44.gridy = 2;
			consGridBagConstraints44.gridx = 0;
			consGridBagConstraints41.insets = new java.awt.Insets(13, 10, 9, 3);
			consGridBagConstraints41.gridy = 1;
			consGridBagConstraints41.gridx = 0;
			consGridBagConstraints41.anchor = java.awt.GridBagConstraints.WEST;
			consGridBagConstraints41.fill = java.awt.GridBagConstraints.NONE;
			jContentPane.setLayout(new java.awt.GridBagLayout());
			jContentPane.add(getJLabel(), consGridBagConstraints38);
			jContentPane.add(getTxtInputFileName(), consGridBagConstraints39);
			jContentPane.add(getBtnbrowseInputFileName(), consGridBagConstraints40);
			jContentPane.add(getJLabel1(), consGridBagConstraints41);
			jContentPane.add(getTxtErrorFilePath(), consGridBagConstraints42);
			jContentPane.add(getBtnbrowseErrorFilePath(), consGridBagConstraints43);
			jContentPane.add(getBtnValidate(), consGridBagConstraints45);    
			jContentPane.add(getBtnExit(), consGridBagConstraints1);     
			jContentPane.add(getBtnHelp(), consGridBagConstraints44);   
		}
		return jContentPane;
	}
	/**
	 * This method initializes jLabel
	 * 
	 * @return javax.swing.JLabel
	 */
	private javax.swing.JLabel getJLabel()
	{
		if (jLabel == null)
		{
			jLabel = new javax.swing.JLabel();
			jLabel.setText("Input File Name with Path");
		}
		return jLabel;
	}
	/**
	 * This method initializes jLabel1
	 * 
	 * @return javax.swing.JLabel
	 */
	private javax.swing.JLabel getJLabel1()
	{
		if (jLabel1 == null)
		{
			jLabel1 = new javax.swing.JLabel();
			jLabel1.setText("Error/Upload & Control Sheet Report File Path");
		}
		return jLabel1;
	}
	/**
	 * This method initializes txtInputFileName
	 * 
	 * @return javax.swing.JTextField
	 */
	private javax.swing.JTextField getTxtInputFileName()
	{
		if (txtInputFileName == null)
		{
			txtInputFileName = new javax.swing.JTextField();
			txtInputFileName.setPreferredSize(new java.awt.Dimension(150, 19));
			txtInputFileName.addFocusListener(new FocusListener()
			{
				public void focusGained(FocusEvent arg0)
				{
				}
				public void focusLost(FocusEvent arg0)
				{
					String inputFilePath = txtInputFileName.getText().trim();
					String errorFilePath = txtErrorFilePath.getText().trim();
					if (inputFilePath.length() != 0 && errorFilePath.length() != 0)
					{
						btnValidate.setEnabled(true);
					}
				}
			});
		}
		return txtInputFileName;
	}
	/**
	 * This method initializes txtErrorFilePath
	 * 
	 * @return javax.swing.JTextField
	 */
	private javax.swing.JTextField getTxtErrorFilePath()
	{
		if (txtErrorFilePath == null)
		{
			txtErrorFilePath = new javax.swing.JTextField();
			txtErrorFilePath.setPreferredSize(new java.awt.Dimension(150, 19));
			txtErrorFilePath.addFocusListener(new FocusListener()
			{
				public void focusGained(FocusEvent arg0)
				{
				}
				public void focusLost(FocusEvent arg0)
				{
					String inputFilePath = txtInputFileName.getText().trim();
					String errorFilePath = txtErrorFilePath.getText().trim();
					if (errorFilePath.length() != 0 && inputFilePath.length() != 0)
					{
						btnValidate.setEnabled(true);
					}
				}
			});
		}
		return txtErrorFilePath;
	}
	/**
	 * This method initializes btnValidate
	 * 
	 * @return javax.swing.JButton
	 */
	private javax.swing.JButton getBtnValidate()
	{
		if (btnValidate == null)
		{
			btnValidate = new javax.swing.JButton();
			btnValidate.setText("Validate");
			btnValidate.setToolTipText("VALIDATE FILE");
			btnValidate.setPreferredSize(new java.awt.Dimension(84, 25));
			btnValidate.addActionListener(new java.awt.event.ActionListener()
			{
				public void actionPerformed(java.awt.event.ActionEvent e)
				{
					try
					{
                        int i;
                        int j;
                        char ch;
                        // Object obj = ((JButton) e.getSource()).getParent().getParent().getParent().getParent();
						//	Creating the object of the FormValidatior class
                        SubContrFileFormatValidator obj_FormValidator = new SubContrFileFormatValidator();
                        //CR-59184
                        com.cra.pao.ups.fvu.SubContrFileFormatValidator formValidatorUPS = new com.cra.pao.ups.fvu.SubContrFileFormatValidator();
                        HtmlFileGenerator obj_FileGenerator = new HtmlFileGenerator();
						String inFileName = txtInputFileName.getText().trim(); // Input file name with path
						String errorFileName = txtErrorFilePath.getText().trim(); // Error file path
						String hashFileName = null;	// Name of the ".fvu" file
						String controlSheetFileName = null;	// Name of the control sheet report ".html" 
						String htmlErrorFileName = null;	// Name of the error file "err.html"
						File addrFile = new File(inFileName);
                        String filePath = addrFile.getAbsolutePath();
						String fileName = addrFile.getName();	// Input file name, ".txt" file name 
                        String fileSeparator = System.getProperty("file.separator");
                        ArrayList<PAOContrErrorFileVO> listErrorVO = new ArrayList<PAOContrErrorFileVO>();
                        // Error code returned from the checkFileFolderName method
                        int errorCode = checkFileFolderName(fileName);
						File errorDir = new File(errorFileName);
						if (errorFileName.length() == 0)
							errorCode = 8;
						if (errorCode == 0)
						{
							for (i = inFileName.length() - 1; i > -1; i--)
							{
								if ((ch = inFileName.charAt(i)) == '.')
								{
									break;
								}
							}
							if (i > 0)
							{
								for (j = i; j > -1; j--)
								{
                                    if ((inFileName.charAt(j) + "").equals(fileSeparator)) 
									{
										break;
									}
								}
								
								hashFileName = errorFileName + fileSeparator + inFileName.substring(j + 1, i) + ".fvu";
								htmlErrorFileName = errorFileName + fileSeparator + inFileName.substring(j + 1, i) + "err.html";
								controlSheetFileName = errorFileName + fileSeparator + inFileName.substring(j + 1, i) + ".html";
							}
							else
							{
								for (j = (inFileName.length() - 1); j > -1; j--)
								{
                                    if ((inFileName.charAt(j) + "").equals(fileSeparator)) 
									{
										break;
									}
								}
								
								hashFileName = errorFileName + fileSeparator + inFileName.substring(j + 1, inFileName.length()) + ".fvu";
								htmlErrorFileName = errorFileName + fileSeparator + inFileName.substring(j + 1, inFileName.length()) + "err.html";
								controlSheetFileName = errorFileName + fileSeparator + inFileName.substring(j + 1, inFileName.length()) + ".html";
                               // System.out.println("htmlErrorFileName" + htmlErrorFileName);
							}
							if (!(errorDir.isDirectory()))
							{
								JOptionPane.showMessageDialog(jContentPane, errorMsg_05);
								txtErrorFilePath.setText("");
							}
							else
							{
								if (addrFile.exists() && addrFile.length() > 0)
								{
									//	Calling readFile method in the program TBAFFormatValidator.java
									//CR-59184
									if(PAOFvu.OSUPSFlag.equalsIgnoreCase("Y")){
										System.out.println("inside UPS flow");
										formValidatorUPS.readFile(inFileName, listErrorVO, utilityLevel);
									}
									else{					
										System.out.println("inside NPS flow");
										obj_FormValidator.readFile(inFileName, listErrorVO, utilityLevel);
									}
									
									if (listErrorVO.size() == 0)
									{
										Hash hash = new Hash();
										//	Calling startProcessing method in the program Hash.java 
										
										int hashError = hash.startProcessing(inFileName, hashFileName, utilityLevel, fhFieldCount);
										
										if (hashError == 0)
										{
											SubContrOutputFileGenerator obj_FileGeneratorRep = null;
											SubContrOutputFileGeneratorUPS obj_FileGeneratorRepUPS = null;
											
											//CR-59184
											if(PAOFvu.OSUPSFlag.equalsIgnoreCase("Y"))
												obj_FileGeneratorRepUPS = new SubContrOutputFileGeneratorUPS();
											else
												obj_FileGeneratorRep = new SubContrOutputFileGenerator();
											//	Output path for the hash file (".fvu") generated
											String hashFileLocation = hashFileName.substring(0, hashFileName.lastIndexOf(fileSeparator));
											//	Method for generating PAO Control Sheet Report
											//CR-59184
											if(PAOFvu.OSUPSFlag.equalsIgnoreCase("Y"))
												obj_FileGeneratorRepUPS.generateControlSheetReport(formValidatorUPS, controlSheetFileName, filePath, CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion"),batchId);
											else
												 obj_FileGeneratorRep.generateControlSheetReport(obj_FormValidator, controlSheetFileName, filePath, CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion"),batchId);
											JOptionPane.showMessageDialog(jContentPane, "File Validation Successful.\r" 
                                                                          + "\nUpload File,Control Sheet " 
                                                                          + "Report generated " 
                                                                          + "at \r\n" + hashFileLocation);
											System.out.println("End time : "+System.currentTimeMillis());

										}
										else if (hashError != 0)
										{
											
											//StringBuffer FH_obj_StringBuffer = new StringBuffer();
											int lineNumber = hash.getRecordNumber();
                                           /*
											ErrorVal	Remarks
											------------------------
											0		Success (no errors)
											1		Input File not found
											2		Invalid Input File 
													(
														i. Empty record found 
														ii. At FVU file is having SAM/SCM info
														iii. At CRA Central System uploadedby is not FC and file is having SAM/SCM info
													)
											3		FVU Version is either Incorrect or NULL
											4		SAM Version is either Incorrect or NULL
											5		SCM Version is either Incorrect or NULL
											6		File Header Record Hash Code mismatch
											7		Record Level Hash Code mismatch
											8		Input File format Error (also if mismatch of number of in the input file.
													For a new file the last char in a record should be '^', 
													and for a file that is already hashed the last character should not be '^')
											9		Mismatch of FVU File Level HashCode
											10		Mismatch of SAM File Level HashCode
											11		Mismatch of SCM File Level HashCode
											12		Unknown Error. Exception occured
											*/
											if (hashError == 3)
											{
                                                listErrorVO.add(new PAOContrErrorFileVO("-", FvuConstants.PEF_1012,FvuConstants.RECTYPE_FHREC, "-", "-","-", "1", "-"));
											}
											else if (hashError == 4)
											{
                                                listErrorVO.add(new PAOContrErrorFileVO("-", FvuConstants.PEF_1013,FvuConstants.RECTYPE_FHREC, "-", "-","-", "1", "-"));
											}
											else if (hashError == 5)
											{
                                                listErrorVO.add(new PAOContrErrorFileVO("-", FvuConstants.PEF_1014,FvuConstants.RECTYPE_FHREC, "-", "-","-", "1", "-"));
											}
											else if (hashError == 9)
											{
                                                listErrorVO.add(new PAOContrErrorFileVO("-", FvuConstants.PEF_1015,FvuConstants.RECTYPE_FHREC, "-", "-","-", "1", "-"));
											}
											else if (hashError == 10)
											{
                                                listErrorVO.add(new PAOContrErrorFileVO("-", FvuConstants.PEF_1016,FvuConstants.RECTYPE_FHREC, "-", "-","-", "1", "-"));
											}
											else if (hashError == 11)
											{
                                                listErrorVO.add(new PAOContrErrorFileVO("-", FvuConstants.PEF_1017,FvuConstants.RECTYPE_FHREC, "-", "-","-", "1", "-"));
											}
											else
											{
                                                listErrorVO.add(new PAOContrErrorFileVO("-", FvuConstants.PEF_1018,"-", "-", "-","-", lineNumber+"", "-"));
											}
											if(obj_FormValidator.uploadBy!= null && obj_FormValidator.uploadBy.equals(FvuConstants.UPLOADED_BY_UOS))
											{
												obj_FileGenerator.generateHtmlErrorFile(listErrorVO, "", "SUBSCRIBER CONTRIBUTION ERROR FILE", "<TR class=tdColumnDetails><TD WIDTH=70 VALIGN=top ><B>Line No</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Record Type</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Field Name & No.*</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>POP-SP Serial No.</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>    Subscriber Contribution Serial No.   </B></CENTER></TD> <TD WIDTH=85 VALIGN=top><B> PRAN </B></CENTER></TD> <TD WIDTH=130 VALIGN=top><B>    Error Code   </B></CENTER></TD><TD WIDTH=450 VALIGN=top><B>Error Description</B></CENTER></TD><TD WIDTH=130 VALIGN=top><B>Error / Warning</B></CENTER></TD></TR>", "<TABLE class=text><TR><TD>* Field Name & No. is as per the file format</TD></TR><TR><TD>FVU Version : " + CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion") + "</TD></TR><TR><TD> Input File Name : " + inFileName + "</TD></TR></TABLE>", htmlErrorFileName);
											}
											else if(obj_FormValidator.uploadBy!= null  && ( obj_FormValidator.uploadBy.equals(FvuConstants.UPLOADED_BY_AO) || obj_FormValidator.uploadBy.equals(FvuConstants.UPLOADED_BY_KA) || obj_FormValidator.uploadBy.equals(FvuConstants.UPLOADED_BY_AO_UPS)))
											{
												obj_FileGenerator.generateHtmlErrorFile(listErrorVO, "", "SUBSCRIBER CONTRIBUTION ERROR FILE", "<TR class=tdColumnDetails><TD WIDTH=70 VALIGN=top ><B>Line No</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Record Type</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Field Name & No.*</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>DDO Serial No.</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>    Subscriber Contribution Serial No.   </B></CENTER></TD> <TD WIDTH=85 VALIGN=top><B> PRAN </B></CENTER></TD> <TD WIDTH=130 VALIGN=top><B>    Error Code   </B></CENTER></TD><TD WIDTH=450 VALIGN=top><B>Error Description</B></CENTER></TD><TD WIDTH=130 VALIGN=top><B>Error / Warning</B></CENTER></TD></TR>", "<TABLE class=text><TR><TD>* Field Name & No. is as per the file format</TD></TR><TR><TD>FVU Version : " + CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion") + "</TD></TR><TR><TD> Input File Name : " + inFileName + "</TD></TR></TABLE>", htmlErrorFileName);
											}
											else if(obj_FormValidator.uploadBy!= null && ( obj_FormValidator.uploadBy.equals(FvuConstants.UPLOADED_BY_PRAO) || obj_FormValidator.uploadBy.equals(FvuConstants.UPLOADED_BY_PRAO_UPS)))
											{
												obj_FileGenerator.generateHtmlErrorFile(listErrorVO, "", "SUBSCRIBER CONTRIBUTION ERROR FILE", "<TR class=tdColumnDetails><TD WIDTH=70 VALIGN=top ><B>Line No</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Record Type</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Field Name & No.*</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>DTO Serial No.</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>    Subscriber Contribution Serial No.   </B></CENTER></TD> <TD WIDTH=85 VALIGN=top><B> PRAN </B></CENTER></TD> <TD WIDTH=130 VALIGN=top><B>    Error Code   </B></CENTER></TD><TD WIDTH=450 VALIGN=top><B>Error Description</B></CENTER></TD><TD WIDTH=130 VALIGN=top><B>Error / Warning</B></CENTER></TD></TR>", "<TABLE class=text><TR><TD>* Field Name & No. is as per the file format</TD></TR><TR><TD>FVU Version : " + CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion") + "</TD></TR><TR><TD> Input File Name : " + inFileName + "</TD></TR></TABLE>", htmlErrorFileName);
											}
											else if(obj_FormValidator.uploadBy!= null && obj_FormValidator.uploadBy.equals(FvuConstants.UPLOADED_BY_CORP))
											{
												obj_FileGenerator.generateHtmlErrorFile(listErrorVO, "", "SUBSCRIBER CONTRIBUTION ERROR FILE", "<TR class=tdColumnDetails><TD WIDTH=70 VALIGN=top ><B>Line No</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Record Type</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Field Name & No.*</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>CBO Serial No.</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>    Subscriber Contribution Serial No.   </B></CENTER></TD> <TD WIDTH=85 VALIGN=top><B> PRAN </B></CENTER></TD> <TD WIDTH=130 VALIGN=top><B>    Error Code   </B></CENTER></TD><TD WIDTH=450 VALIGN=top><B>Error Description</B></CENTER></TD><TD WIDTH=130 VALIGN=top><B>Error / Warning</B></CENTER></TD></TR>", "<TABLE class=text><TR><TD>* Field Name & No. is as per the file format</TD></TR><TR><TD>FVU Version : " + CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion") + "</TD></TR><TR><TD> Input File Name : " + inFileName + "</TD></TR></TABLE>", htmlErrorFileName);
											}
											else 
											{
												obj_FileGenerator.generateHtmlErrorFile(listErrorVO, "", "SUBSCRIBER CONTRIBUTION ERROR FILE", "<TR class=tdColumnDetails><TD WIDTH=70 VALIGN=top ><B>Line No</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Record Type</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Field Name & No.*</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>DDO/POP-SP/DTO/CBO Serial No.</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>    Subscriber Contribution Serial No.   </B></CENTER></TD> <TD WIDTH=85 VALIGN=top><B> PRAN </B></CENTER></TD> <TD WIDTH=130 VALIGN=top><B>    Error Code   </B></CENTER></TD><TD WIDTH=450 VALIGN=top><B>Error Description</B></CENTER></TD><TD WIDTH=130 VALIGN=top><B>Error / Warning</B></CENTER></TD></TR>", "<TABLE class=text><TR><TD>* Field Name & No. is as per the file format</TD></TR><TR><TD>FVU Version : " + CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion") + "</TD></TR><TR><TD> Input File Name : " + inFileName + "</TD></TR></TABLE>", htmlErrorFileName);
											}
											JOptionPane.showMessageDialog(jContentPane, "Errors Found during " +
                                                                          "Validation.\r\nHTML Error File " +
                                                                          "Generated\r\nOpen " + htmlErrorFileName 
                                                                          + " for details");
										}
									}
									else
									{ 
										if(obj_FormValidator.uploadBy!= null && obj_FormValidator.uploadBy.equals(FvuConstants.UPLOADED_BY_UOS))
										{
											obj_FileGenerator.generateHtmlErrorFile(listErrorVO, "", "SUBSCRIBER CONTRIBUTION ERROR FILE", "<TR class=tdColumnDetails><TD WIDTH=70 VALIGN=top ><B>Line No</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Record Type</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Field Name & No.*</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>POP-SP Serial No.</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>    Subscriber Contribution Serial No.   </B></CENTER></TD> <TD WIDTH=85 VALIGN=top><B> PRAN </B></CENTER></TD> <TD WIDTH=130 VALIGN=top><B>    Error Code   </B></CENTER></TD><TD WIDTH=450 VALIGN=top><B>Error Description</B></CENTER></TD><TD WIDTH=130 VALIGN=top><B>Error / Warning</B></CENTER></TD></TR>", "<TABLE class=text><TR><TD>* Field Name & No. is as per the file format</TD></TR><TR><TD>FVU Version : " + CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion") + "</TD></TR><TR><TD> Input File Name : " + inFileName + "</TD></TR></TABLE>", htmlErrorFileName);
										}
										else if(obj_FormValidator.uploadBy!= null && ( obj_FormValidator.uploadBy.equals(FvuConstants.UPLOADED_BY_AO) || obj_FormValidator.uploadBy.equals(FvuConstants.UPLOADED_BY_KA)))
										{
											obj_FileGenerator.generateHtmlErrorFile(listErrorVO, "", "SUBSCRIBER CONTRIBUTION ERROR FILE", "<TR class=tdColumnDetails><TD WIDTH=70 VALIGN=top ><B>Line No</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Record Type</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Field Name & No.*</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>DDO Serial No.</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>    Subscriber Contribution Serial No.   </B></CENTER></TD> <TD WIDTH=85 VALIGN=top><B> PRAN </B></CENTER></TD> <TD WIDTH=130 VALIGN=top><B>    Error Code   </B></CENTER></TD><TD WIDTH=450 VALIGN=top><B>Error Description</B></CENTER></TD><TD WIDTH=130 VALIGN=top><B>Error / Warning</B></CENTER></TD></TR>", "<TABLE class=text><TR><TD>* Field Name & No. is as per the file format</TD></TR><TR><TD>FVU Version : " + CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion") + "</TD></TR><TR><TD> Input File Name : " + inFileName + "</TD></TR></TABLE>", htmlErrorFileName);
										}
										else if(obj_FormValidator.uploadBy!= null && obj_FormValidator.uploadBy.equals(FvuConstants.UPLOADED_BY_PRAO))
										{
											obj_FileGenerator.generateHtmlErrorFile(listErrorVO, "", "SUBSCRIBER CONTRIBUTION ERROR FILE", "<TR class=tdColumnDetails><TD WIDTH=70 VALIGN=top ><B>Line No</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Record Type</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Field Name & No.*</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>DTO Serial No.</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>    Subscriber Contribution Serial No.   </B></CENTER></TD> <TD WIDTH=85 VALIGN=top><B> PRAN </B></CENTER></TD> <TD WIDTH=130 VALIGN=top><B>    Error Code   </B></CENTER></TD><TD WIDTH=450 VALIGN=top><B>Error Description</B></CENTER></TD><TD WIDTH=130 VALIGN=top><B>Error / Warning</B></CENTER></TD></TR>", "<TABLE class=text><TR><TD>* Field Name & No. is as per the file format</TD></TR><TR><TD>FVU Version : " + CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion") + "</TD></TR><TR><TD> Input File Name : " + inFileName + "</TD></TR></TABLE>", htmlErrorFileName);
										}
										else if(obj_FormValidator.uploadBy!= null && obj_FormValidator.uploadBy.equals(FvuConstants.UPLOADED_BY_CORP))
										{
											obj_FileGenerator.generateHtmlErrorFile(listErrorVO, "", "SUBSCRIBER CONTRIBUTION ERROR FILE", "<TR class=tdColumnDetails><TD WIDTH=70 VALIGN=top ><B>Line No</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Record Type</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Field Name & No.*</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>CBO Serial No.</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>    Subscriber Contribution Serial No.   </B></CENTER></TD> <TD WIDTH=85 VALIGN=top><B> PRAN </B></CENTER></TD> <TD WIDTH=130 VALIGN=top><B>    Error Code   </B></CENTER></TD><TD WIDTH=450 VALIGN=top><B>Error Description</B></CENTER></TD><TD WIDTH=130 VALIGN=top><B>Error / Warning</B></CENTER></TD></TR>", "<TABLE class=text><TR><TD>* Field Name & No. is as per the file format</TD></TR><TR><TD>FVU Version : " + CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion") + "</TD></TR><TR><TD> Input File Name : " + inFileName + "</TD></TR></TABLE>", htmlErrorFileName);
										}
										else 
										{
											obj_FileGenerator.generateHtmlErrorFile(listErrorVO, "", "SUBSCRIBER CONTRIBUTION ERROR FILE", "<TR class=tdColumnDetails><TD WIDTH=70 VALIGN=top ><B>Line No</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Record Type</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Field Name & No.*</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>DDO/POP-SP/DTO/CBO Serial No.</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>    Subscriber Contribution Serial No.   </B></CENTER></TD> <TD WIDTH=85 VALIGN=top><B> PRAN </B></CENTER></TD> <TD WIDTH=130 VALIGN=top><B>    Error Code   </B></CENTER></TD><TD WIDTH=450 VALIGN=top><B>Error Description</B></CENTER></TD><TD WIDTH=130 VALIGN=top><B>Error / Warning</B></CENTER></TD></TR>", "<TABLE class=text><TR><TD>* Field Name & No. is as per the file format</TD></TR><TR><TD>FVU Version : " + CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion") + "</TD></TR><TR><TD> Input File Name : " + inFileName + "</TD></TR></TABLE>", htmlErrorFileName);
										}
										JOptionPane.showMessageDialog(jContentPane,
											"Errors Found during Validation.\r\nHTML Error File Generated\r\nOpen " + htmlErrorFileName + " for details");
									}
									txtInputFileName.setText("");
									txtErrorFilePath.setText("");
									btnValidate.setEnabled(false);
								} //END  if (addrFile.exists() && addrFile.length()>0)
								else
								{
									listErrorVO.add(new PAOContrErrorFileVO("-", FvuConstants.PEF_1011,FvuConstants.RECTYPE_FHREC, "-", "-","-", "1", "-"));
									obj_FileGenerator.generateHtmlErrorFile(listErrorVO, "", "SUBSCRIBER CONTRIBUTION ERROR FILE", "<TR class=tdColumnDetails><TD WIDTH=70 VALIGN=top ><B>Line No</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Record Type</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Field Name & No.*</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>DDO/POP-SP/DTO Serial No.</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>    Subscriber Contribution Serial No.   </B></CENTER></TD> <TD WIDTH=85 VALIGN=top><B> PRAN </B></CENTER></TD> <TD WIDTH=130 VALIGN=top><B>    Error Code   </B></CENTER></TD><TD WIDTH=450 VALIGN=top><B>Error Description</B></CENTER></TD><TD WIDTH=130 VALIGN=top><B>Error / Warning</B></CENTER></TD></TR>", "<TABLE class=text><TR><TD>* Field Name & No. is as per the file format</TD></TR><TR><TD>FVU Version : " + CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion") + "</TD></TR><TR><TD> Input File Name : " + inFileName + "</TD></TR></TABLE>", htmlErrorFileName);
									JOptionPane.showMessageDialog(
										jContentPane,
										"Errors Found during Validation.\r\nHTML Error File Generated\r\nOpen " + htmlErrorFileName + " for details");
									txtInputFileName.setText("");
									txtErrorFilePath.setText("");
									btnValidate.setEnabled(false);
								}
							}
						}
						else
						{
							if (errorCode == 1 || errorCode == 8)
								JOptionPane.showMessageDialog(jContentPane, errorMsg_01);
							else if (errorCode == 2)
								JOptionPane.showMessageDialog(jContentPane, errorMsg_02);
							else if (errorCode == 3)
								JOptionPane.showMessageDialog(jContentPane, errorMsg_03);
							else if (errorCode == 5)
								JOptionPane.showMessageDialog(jContentPane, errorMsg_04);
							else if (errorCode == 6)
								JOptionPane.showMessageDialog(jContentPane, errorMsg_06);
							txtInputFileName.setText("");
							txtErrorFilePath.setText("");
							btnValidate.setEnabled(false);
						}
					}
					catch (Exception o)
					{
						o.printStackTrace();
                        //CRALog.paoLog.error("Exception in  actionPerformed method  : " + o);
					}
				}
			});
		}
		return btnValidate;
	}
	/**
	 *	This method initializes btnExit
	 * 
	 *	@return javax.swing.JButton
	 */
	private javax.swing.JButton getBtnExit()
	{
		if (btnExit == null)
		{
			btnExit = new javax.swing.JButton();
			btnExit.setText("Exit");
			btnExit.setToolTipText("CLOSE THE PROGRAM");
			btnExit.setPreferredSize(new java.awt.Dimension(84, 25));
			btnExit.addActionListener(new java.awt.event.ActionListener()
			{
				public void actionPerformed(java.awt.event.ActionEvent e)
				{
					System.exit(0);
				}
			});
		}
		return btnExit;
	}
    
    class TextFileFilter extends FileFilter
    {
        public boolean accept(File file)
        {
            String filename = file.getName();
            return filename.endsWith(".txt");
        }
        
        public String getDescription()
        {
            return "*.txt";
        }
    }
    
	/**
	 * This method initializes btnbrowseInputFileName
	 * 
	 * @return javax.swing.JButton
	 * 
	 */
	private javax.swing.JButton getBtnbrowseInputFileName()
	{
		if (btnbrowseInputFileName == null)
		{
			btnbrowseInputFileName = new javax.swing.JButton();
			btnbrowseInputFileName.setText("Browse");
			btnbrowseInputFileName.setToolTipText("CHOOSE A FILE FOR VALIDATION");
			btnbrowseInputFileName.setPreferredSize(new java.awt.Dimension(84, 25));
			try
			{
				btnbrowseInputFileName.addActionListener(new java.awt.event.ActionListener()
				{
					public void actionPerformed(java.awt.event.ActionEvent e)
					{
						JFileChooser jf = new JFileChooser();
                        jf.addChoosableFileFilter(new TextFileFilter());
                    	if (previousSorurceFileFolder.trim().length() == 0)
						{
						    jf.setCurrentDirectory(jf.getCurrentDirectory());
                        }
						else
						{
							File currentFile = new File(previousSorurceFileFolder.trim());
							jf.setCurrentDirectory(currentFile);
						}
						jf.setDialogTitle("Open Input File Name");
						int result = jf.showOpenDialog(((JButton) e.getSource()).getParent().getParent().getParent().getParent());
                        if (result == JFileChooser.CANCEL_OPTION)
						{
							// No Statement
						}
						else if (result == JFileChooser.ERROR_OPTION)
						{
							// No Statement
						}
						else
						{
							txtInputFileName.setText(jf.getSelectedFile().getPath());
							file = jf.getSelectedFile().getPath();
							previousSorurceFileFolder = jf.getSelectedFile().getPath();
							//	Enable the validate button after selecting the I/P file name and Error file name
							if (txtErrorFilePath.getText().length() != 0 && txtInputFileName.getText().length() != 0)
								btnValidate.setEnabled(true);
						}
					}
				});
			}
			catch (Exception e)
			{
				e.printStackTrace();
                //CRALog.paoLog.error("Exception in  getBtnbrowseInputFileName method  : " + e);
			}
		}
		return btnbrowseInputFileName;
	}
    
    /**
	 * This method initializes btnbrowseErrorFilePath
	 * 
	 * @return javax.swing.JButton
	 */
	private javax.swing.JButton getBtnbrowseErrorFilePath()
	{
		if (btnbrowseErrorFilePath == null)
		{
			btnbrowseErrorFilePath = new javax.swing.JButton();
			btnbrowseErrorFilePath.setText("Browse");
			btnbrowseErrorFilePath.setToolTipText("CHOOSE A FOLDER TO SAVE OUTPUT FILE");
			btnbrowseErrorFilePath.setPreferredSize(new java.awt.Dimension(84, 25));
			btnbrowseErrorFilePath.addActionListener(new java.awt.event.ActionListener()
			{
				public void actionPerformed(java.awt.event.ActionEvent e)
				{
					JFileChooser jf = new JFileChooser();
                    jf.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
					if (previousOutputFileFolder.trim().length() == 0)
					{
						jf.setCurrentDirectory(jf.getCurrentDirectory());
					}
					else
					{
						File currentFile = new File(previousOutputFileFolder.trim());
						jf.setCurrentDirectory(currentFile);
					}
					jf.setDialogTitle("Select Folder to save Output File");
					jf.setApproveButtonToolTipText("CHOOSE A FOLDER TO SAVE OUTPUT FILE");
					int result = jf.showOpenDialog(((JButton) e.getSource()).getParent().getParent().getParent().getParent());
					if (result == JFileChooser.CANCEL_OPTION)
					{
						// No Statement
					}
					else if (result == JFileChooser.ERROR_OPTION)
					{
						// No Statement
					}
					else
					{
						txtErrorFilePath.setText(jf.getSelectedFile().getPath());
						previousOutputFileFolder = jf.getSelectedFile().getPath();
						if (txtErrorFilePath.getText().length() != 0 && txtInputFileName.getText().length() != 0)
							btnValidate.setEnabled(true);
					}
				}
			});
		}
		return btnbrowseErrorFilePath;
	}
	/**
	 *	This method is used to check the file name specified in the input file name  
	 * 	path of the FVU interface. The fileName is given as parameter and the method checks
	 *	that the file name does not contain the reserved file names used by the 
	 *	operating system  	
	 * 
	 *	@param testName
	 *	@return error code
	 */
	private int checkFileFolderName(String testName)
	{
		if (testName.length() == 0)
			return 1;
		if (testName.length() <= 3)
			return 3;
		if (testName.length() > 24)
			return 2;
		if (testName.trim().length() >= 5)
		{
			String subName = testName.substring(0, 4);
			//	check if the file name contains  'COM1.' , 'COM2.' , 'LTP1.' , 'LTP2.' , 'NUL.' , 'CON.'     
			if (subName.equalsIgnoreCase("COM1.")
				|| subName.equalsIgnoreCase("COM2.")
				|| subName.equalsIgnoreCase("COM3.")
				|| subName.equalsIgnoreCase("COM4.")
				|| subName.equalsIgnoreCase("COM5.")
				|| subName.equalsIgnoreCase("COM6.")
				|| subName.equalsIgnoreCase("COM7.")
				|| subName.equalsIgnoreCase("COM8.")
				|| subName.equalsIgnoreCase("COM9.")
				|| subName.equalsIgnoreCase("LTP1.")
				|| subName.equalsIgnoreCase("LTP2.")
				|| subName.equalsIgnoreCase("LTP3.")
				|| subName.equalsIgnoreCase("LTP4.")
				|| subName.equalsIgnoreCase("LTP5.")
				|| subName.equalsIgnoreCase("LTP6.")
				|| subName.equalsIgnoreCase("LTP7.")
				|| subName.equalsIgnoreCase("LTP8.")
				|| subName.equalsIgnoreCase("LTP9."))
				return 3;
		}
		if (testName.trim().length() >= 4)
		{
			if (testName.substring(0, 3).equalsIgnoreCase("NUL.") || testName.substring(0, 3).equalsIgnoreCase("CON."))
				return 3;
		}
		//	check if the file name contains  '/' , ':' , '?', '>', '<', '*', '"', '|', '\', '^', Under score or Space
        for (int localI = 0; localI < testName.length(); localI++)
		{
			if (testName.charAt(localI) == '/'
				|| testName.charAt(localI) == ':'
				|| testName.charAt(localI) == '*'
				|| testName.charAt(localI) == '?'
				|| testName.charAt(localI) == '"'
				|| testName.charAt(localI) == '<'
				|| testName.charAt(localI) == '>'
				|| testName.charAt(localI) == '|'
				|| testName.charAt(localI) == '\\'
				|| testName.charAt(localI) == ' '
				|| testName.charAt(localI) == '_'
				|| testName.charAt(localI) == '^')
				return 5;
		}
		int alphaDigit = 3;
		for (int localY = 0; localY < testName.length(); localY++)
		{
			if (Character.isLetterOrDigit(testName.charAt(localY)))
			{
				alphaDigit = 0;
				break;
			}
		}
		if (alphaDigit == 3)
		{
			return 3;
		}

		if (!testName.trim().endsWith(".txt") && !testName.trim().endsWith(".TXT"))
		{
			return 6;
		}
		return 0;
	}
	/**
	 * This method initializes jButton
	 * 
	 * @return javax.swing.JButton
	 */
	private javax.swing.JButton getBtnHelp()
	{
		if (btnHelp == null)
		{
			btnHelp = new javax.swing.JButton();
			btnHelp.setPreferredSize(new java.awt.Dimension(84, 25));
			btnHelp.setActionCommand("Help");
			btnHelp.setText("Help");
			btnHelp.setToolTipText("OPEN HELP FILE");
			btnHelp.addActionListener(new java.awt.event.ActionListener()
			{
				public void actionPerformed(java.awt.event.ActionEvent e)
				{
					btnHelp.setEnabled(false);
					jHelpTextPane = new JTextPane();
					jHelpTextPane.setEditable(false);
					try
					{
						jHelpTextPane.setPage(getClass().getResource("/cra/standalone/paosubcontr/help.txt"));
					}
					catch (IOException e1)
					{
						e1.printStackTrace();
					}
					JScrollPane objScrollPane = new JScrollPane(jHelpTextPane, JScrollPane.VERTICAL_SCROLLBAR_ALWAYS, JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
					jHelpTextPane.setVisible(true);
					String title = "FVU - Help";
					Frame helpFrame = new Frame(title);
					// Create java.awt.Component of type JScrollPane
					Component comp = new JScrollPane(); 
					// Add the component to the frame; by default, the frame has a border layout
					helpFrame.add(comp, BorderLayout.CENTER);
					// Show the frame
					int width = 600;
					int height = 350;
					helpFrame.setSize(width, height);
					helpFrame.add(objScrollPane); // Add Scroll Pane to the Frame
					helpFrame.setLocation(0, 0);
					helpFrame.setVisible(true);
					helpFrame.setIconImage(java.awt.Toolkit.getDefaultToolkit().getImage(getClass().getResource("/cra/standalone/paosubcontr/nsdl-logo.jpg")));
					helpFrame.addWindowListener(new WindowAdapter()
					{
						public void windowClosing(WindowEvent evt)
						{
							Frame helpFrame = (Frame) evt.getSource();
							helpFrame.setVisible(false);
							helpFrame.dispose();
							btnHelp.setEnabled(true);
						}
					});
				}
			});
		}
		return btnHelp;
	}	
} 
