/**
 * Class: PAOFileStatisticsVO.java
 */

package com.cra.pao.vo;

import java.util.ArrayList;

import com.cra.contr.framework.vo.BaseVO;

/**
 * This class contains getters and setters for storing and retrieving the values
 * to be displayed in the error html and FVU control sheet report. This class
 * implements Serializable interface.
 * 
 * @author TCS
 */

public class PAOFileStatisticsVO extends BaseVO
{
	private static final long serialVersionUID = "com.cra.pao.vo".hashCode();
	private String AIN = "-"; // AIN in Batch Record
	private String typeOfUploadedFile = "-"; // Uploaded File Type
	private String serialNumberInDDO = "-"; // DDO Serial Number
	private String countOfDDORecords = "-"; // Count of DDO Records
	private String countOfSubDetailRecords = "-"; // Count of Subscriber
													// Detail Records
	private String batchId = "-"; // Unique Batch ID for a file
	private String transactionId = "-"; // Unique Transaction ID
	private String tierOneTotalGovtContribution = "-"; // Total Govt. Contribution Amount
	private String tierOneTotalSelfContribution = "-"; // Total Self Contribution Amount
    private String totalAmountInBank = "-"; // Total amount to be deposited in bank
	private String noOfLines = "-"; // Number of Lines in the '.txt' file
	private String fvuVersion = "-"; // FVU version
	private String uploadedBy = "-"; // Uploader Type present in FH record(PAO or FC)
	private String samVersion = "-"; // SAM Version
	private String scmVersion = "-"; // SCM version
	private String fpuFileCreatedDate = "-"; // File Creation Date
	private String numberOfBatches = "-"; // Number of Batches
	private String responseType = "-"; // Response type

	// Error File Fields
	private String lineNumber = "-"; // Line Number
	private String recordType = "-"; // Record Type
	private String batchNumber = "-"; // Batch Number
	private String serialNumber = "-"; // Subscriber Detail Number
	private String errorCode = "-"; // Error Code
	private String errorDescription = "-"; // Error Description
    private String prn="-";
    //Added for Revamp CR
    private String warnings = null; 
    private String uniqueCount = null;
    private String totalRegularContr = "-";
    private String totalArrearContr = "-";
    private String totalMiscContr = "-";
    private String totalT1Contr = "-";
    private String totalT2Contr = "-";
    private String totalUM1Contr = "-";
    private String totalUM2Contr = "-";
    private String totalUT1Contr = "-";
    private String totalUT2Contr = "-";
    private String totalVPFContr = "-";
    private String totalVPFUPSContr = "-";//Cr 60237
    private String totalTTSContr = "-";//Added for TTS
	// Getter Methods for Control Sheet Report

	public String getPrn() {
		return prn;
	}

	public void setPrn(String prn) {
		this.prn = prn;
	}

	public String getAIN()
	{
		return AIN;
	}

	public String getTypeOfUploadedFile()
	{
		return typeOfUploadedFile;
	}

	public String getSerialNumberInDDO()
	{
		return serialNumberInDDO;
	}

	public String getCountOfDDORecords()
	{
		return countOfDDORecords;
	}

	public String getCountOfSubDetailRecords()
	{
		return countOfSubDetailRecords;
	}

	public String getBatchId()
	{
		return batchId;
	}

	public String getTransactionId()
	{
		return transactionId;
	}

	public String getTierOneTotalGovtContribution()
	{
		return tierOneTotalGovtContribution;
	}

	public String getTierOneTotalSelfContribution()
	{
		return tierOneTotalSelfContribution;
	}

	public String getNoOfLines()
	{
		return noOfLines;
	}

	public String getFvuVersion()
	{
		return fvuVersion;
	}

	public String getUploadedBy()
	{
		return uploadedBy;
	}

	public String getSamVersion()
	{
		return samVersion;
	}

	public String getScmVersion()
	{
		return scmVersion;
	}

	public String getFpuFileCreatedDate()
	{
		return fpuFileCreatedDate;
	}

	public String getNumberOfBatches()
	{
		return numberOfBatches;
	}
    
    public String getTotalAmountInBank()
    {
        return totalAmountInBank;
    }
    

	// Setter Methods for Control Sheet Report

	public void setAIN(String string)
	{
		AIN = string;
	}

	public void setTypeOfUploadedFile(String string)
	{
		typeOfUploadedFile = string;
	}

	public void setSerialNumberInDDO(String string)
	{
		serialNumberInDDO = string;
	}

	public void setCountOfDDORecords(String string)
	{
		countOfDDORecords = string;
	}

	public void setCountOfSubDetailRecords(String string)
	{
		countOfSubDetailRecords = string;
	}

	public void setTransactionId(String string)
	{
		transactionId = string;
	}

	public void setBatchId(String string)
	{
		batchId = string;
	}

	public void setTierOneTotalGovtContribution(String string)
	{
		tierOneTotalGovtContribution = string;
	}

	public void setTierOneTotalSelfContribution(String string)
	{
		tierOneTotalSelfContribution = string;
	}

	public void setNoOfLines(String string)
	{
		noOfLines = string;
	}

	public void setFvuVersion(String string)
	{
		fvuVersion = string;
	}

	public void setUploadedBy(String string)
	{
		uploadedBy = string;
	}

	public void setSamVersion(String string)
	{
		samVersion = string;
	}

	public void setScmversion(String string)
	{
		scmVersion = string;
	}

	public void setFpuFileCreatedDate(String string)
	{
		fpuFileCreatedDate = string;
	}
    
    public void setTotalAmountDepositedInBank(String string)
    {
        totalAmountInBank = string;
    }
    
    

	// Getter Methods for Error HTML Report.
	public String getLineNumber()
	{
		return lineNumber;
	}

	public String getRecordType()
	{
		return recordType;
	}

	public String getBatchNumber()
	{
		return batchNumber;
	}

	public String getSerialNumber()
	{
		return serialNumber;
	}

	public String getErrorCode()
	{
		return errorCode;
	}

	public String getErrorDescription()
	{
		return errorDescription;
	}
	
	public String getResponseType()
	{
		return responseType;
	}

	// Setter Methods for Error HTML Report.
	public void setLineNumber(String string)
	{
		lineNumber = string;
	}

	public void setRecordType(String string)
	{
		recordType = string;
	}

	public void setBatchNumber(String string)
	{
		batchNumber = string;
	}

	public void setSerialNumber(String string)
	{
		serialNumber = string;
	}

	public void setErrorCode(String string)
	{
		errorCode = string;
	}

	public void setErrorDescription(String string)
	{
		errorDescription = string;
	}
	
	public void setNumberOfBatches(String string)
	{
		numberOfBatches = string;
	}
	
	public void setResponseType(String responseType)
	{
		this.responseType = responseType;
	}

	public String getTotalArrearContr() {
		return totalArrearContr;
	}

	public void setTotalArrearContr(String totalArrearContr) {
		this.totalArrearContr = totalArrearContr;
	}

	public String getTotalRegularContr() {
		return totalRegularContr;
	}

	public void setTotalRegularContr(String totalRegularContr) {
		this.totalRegularContr = totalRegularContr;
	}

	public String getTotalMiscContr() {
		return totalMiscContr;
	}

	public void setTotalMiscContr(String totalMiscContr) {
		this.totalMiscContr = totalMiscContr;
	}

	public String getTotalT1Contr() {
		return totalT1Contr;
	}

	public void setTotalT1Contr(String totalT1Contr) {
		this.totalT1Contr = totalT1Contr;
	}

	public String getTotalT2Contr() {
		return totalT2Contr;
	}

	public void setTotalT2Contr(String totalT2Contr) {
		this.totalT2Contr = totalT2Contr;
	}

	public String getTotalUM1Contr() {
		return totalUM1Contr;
	}

	public void setTotalUM1Contr(String totalUM1Contr) {
		this.totalUM1Contr = totalUM1Contr;
	}

	public String getTotalUM2Contr() {
		return totalUM2Contr;
	}

	public void setTotalUM2Contr(String totalUM2Contr) {
		this.totalUM2Contr = totalUM2Contr;
	}

	public String getTotalUT1Contr() {
		return totalUT1Contr;
	}

	public void setTotalUT1Contr(String totalUT1Contr) {
		this.totalUT1Contr = totalUT1Contr;
	}

	public String getTotalUT2Contr() {
		return totalUT2Contr;
	}

	public void setTotalUT2Contr(String totalUT2Contr) {
		this.totalUT2Contr = totalUT2Contr;
	}
	
	public String getTotalVPFContr() {
		return totalVPFContr;
	}

	public void setTotalVPFContr(String totalVPFContr) {
		this.totalVPFContr = totalVPFContr;
	}
	
	public String getTotalVPFUPSContr() {
		return totalVPFUPSContr;
	}

	public void setTotalVPFUPSContr(String totalVPFUPSContr) {
		this.totalVPFUPSContr = totalVPFUPSContr;
	}
	public String getWarnings() {
		return warnings;
	}

	public void setWarnings(String warnings) {
		this.warnings = warnings;
	}
	public String getUniqueCount() {
		return uniqueCount;
	}

	public void setUniqueCount(String uniqueCount) {
		this.uniqueCount = uniqueCount;
	}
	//Added For TTS
	public String getTotalTTSContr() {
		return totalTTSContr;
	}

	public void setTotalTTSContr(String totalTTSContr) {
		this.totalTTSContr = totalTTSContr;
	}
	//Added For TTS
}
