package com.cra.pao.vo;

import java.text.MessageFormat;

//import org.apache.log4j.Logger;

//import com.cra.common.util.CRALog;
import com.cra.contr.framework.vo.BaseErrorFileVO;


public class PAOContrErrorFileVO extends BaseErrorFileVO 
{
	// Error File Fields
	//protected Logger log= CRALog.paoLog ;
	private String serialNumberInDDO = "-"; // DDO Serial Number
	private String serialNumber = "-"; // Subscriber Detail Number
	private String pran = "-"; // PRAN
	private String lineNumber = "-"; // Line Number
	private String responseType = "-";// Response type 
	private String errorCodeStr = "-";

	private final String errorEntrySkeleton = "<TR class=tabledetails>" 
		+ "<TD ALIGN=RIGHT WIDTH=70>{0}</TD>" 
		+ "<TD ALIGN=LEFT WIDTH=85>{1}</TD>" 
		+ "<TD ALIGN=LEFT WIDTH=50>{2}</TD>" 
		+ "<TD ALIGN=LEFT WIDTH=85>{3}</TD>" 
		+ "<TD ALIGN=LEFT WIDTH=85>{4}</TD>" 
		+ "<TD ALIGN=LEFT WIDTH=85>{5}</TD>" 
		+ "<TD ALIGN=LEFT WIDTH=130>{6}</TD>" 
		+ "<TD ALIGN=LEFT WIDTH=450>{7}</TD>" 
		+ "<TD ALIGN=LEFT WIDTH=130>{8}</TD></TR>";

	public PAOContrErrorFileVO(String tagName, int errorCode,String recordType, String serialNumberInDDO, String serialNumber, String pran, String lineNumber, String responseType)
	{
		super(tagName, errorCode,recordType);
		//log.debug("errorCodeStr = "+errorCodeStr);
		this.serialNumberInDDO = serialNumberInDDO;
		this.serialNumber = serialNumber;
		this.pran = pran;
		this.lineNumber = lineNumber;		
		this.responseType = responseType;
		this.errorCodeStr = "";
		
	}

	public String toHtml()
	{
		//log.debug("errorCodeStr toHtml() = "+errorCodeStr);
		return MessageFormat.format(errorEntrySkeleton, new Object[] { lineNumber, recordType, tagName, serialNumberInDDO, serialNumber, pran,""+errorCode, getErrorDescription()+errorCodeStr, responseType });
	}

	public String getSerialNumber()
	{
		return serialNumber;
	}

	public void setSerialNumber(String serialNumber)
	{
		this.serialNumber = serialNumber;
	}

	public String getSerialNumberInDDO()
	{
		return serialNumberInDDO;
	}

	public void setSerialNumberInDDO(String serialNumberInDDO)
	{
		this.serialNumberInDDO = serialNumberInDDO;
	}

	public String getLineNumber()
	{
		return lineNumber;
	}

	public void setLineNumber(String lineNumber)
	{
		this.lineNumber = lineNumber;
	}

	public String getResponseType()
	{
		return responseType;
	}

	public void setResponseType(String responseType)
	{
		this.responseType = responseType;
	}
	
	public String getPran() {
		return pran;
	}

	public void setPran(String pran) {
		this.pran = pran;
	}
/*public static void main(String[] args)
{
	ArrayList<PAOContrErrorFileVO> list = new ArrayList<PAOContrErrorFileVO>();
	list.add(getLineParsed("File Header Rec^" + "1" + "^" + "-" + "^^^" + "PEF-1016 " + " Mismatch of SAM File Level HashCode"));
	try
	{
		new ErrorFileGenerator().generateHtmlErrorFile(list, "", "PAO CONTRIBUTION ERROR FILE", "<TR class=tdColumnDetails><TD WIDTH=70 VALIGN=top ><B>Line No</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Record Type</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Field Name & No.*</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>DDO Serial No.</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>    Subscriber Contribution Detail No.   </B></CENTER></TD><TD WIDTH=130 VALIGN=top><B>    Error Code   </B></CENTER></TD><TD WIDTH=450 VALIGN=top><B>Error Description</B></CENTER></TD><TD WIDTH=130 VALIGN=top><B>Error / Warning</B></CENTER></TD></TR>", "<TABLE class=text><TR><TD>* Field Name & No. is as per the file format</TD></TR><TR><TD>FVU Version : PAOFVUVersion</TD></TR><TR><TD> Input File Name : " + "inputFileName.txt</TD></TR></TABLE>", "C:/test.html");
	}
	catch (IOException e)
	{
		// TODO Auto-generated catch block
		e.printStackTrace();
	}
	
	//System.out.println(getLineParsed("File Header Rec^" + "1" + "^" + "-" + "^^^" + "PEF-1016 " + " Mismatch of SAM File Level HashCode"));
}
	public static PAOContrErrorFileVO getLineParsed(String inputString)
	{
		String splitLine[] = CRAFileReader.getLineParsed(inputString, "\\^");
		System.out.println(inputString);
		CRALog.paoLog.info("splitLine.length"+splitLine.length);		
		for(int i=0;i<splitLine.length;i++)
		{
			if(splitLine[i] == null)
			{
				splitLine[i] = "-";
			}
		}
//		String token = splitLine[5];
//	(String tagName, int errorCode,String recordType, String serialNumberInDDO, String serialNumber, String lineNumber, String responseType)
		
//		int firstIndex = token.indexOf(" ");
//		String errorCode = token.substring(0, firstIndex);
//		String errorDesc = token.substring(firstIndex, token.length());
		String recordType = splitLine[0];		
		String lineNumber = splitLine[1];
		String tagName = splitLine[2];
		String serialNumberInDDO = splitLine[3];
		String serialNumber = splitLine[4];
		String errCode = splitLine[5];
		int errorCode = Integer.parseInt(errCode);
		String responseType = "-";
		if(splitLine.length>6){
			responseType = splitLine[6];
		}
		
		return new PAOContrErrorFileVO(tagName, errorCode,recordType, serialNumberInDDO, serialNumber, lineNumber, responseType);
		
	}
	*/

	public String getErrorCodeStr() {
		return errorCodeStr;
	}

	public void setErrorCodeStr(String errorCodeStr) {
		this.errorCodeStr = errorCodeStr;
	}

	
}
