/** 
 *  Class: SubContrOutputFileGenerator.java      
 */

package com.cra.pao.util;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import com.cra.pao.vo.PAOFileStatisticsVO;
import com.cra.pao.fvu.SubContrFileFormatValidator;
import com.cra.pao.fvu.FvuConstants;
import com.cra.contr.common.util.CRAConfigReader;
import com.cra.contr.common.util.file.CRABasicFileWriter;
/**
 * This class contains methods for creating error files and FVU control sheet report.
 * The class is called from the main class PAOFvu.java and the corresponding generate files method 
 * are invoked based on the validations.
 * 
 * @author TCS
 *
 */

public class SubContrOutputFileGenerator 
{
	Calendar cal = new GregorianCalendar();
	String tab = "^";	
	
	/**
	 * Method for generating PAO Control Sheet Report. This method is called
	 * from PAOFvu.java. This method gets the value of all the fields which are
	 * appended in a StringBuffer contolSheetReport which is stored in an
	 * ArrayList with '^' as a seperator. The ArrayList is again converted to an
	 * array of string in which the data from the text file is stored.
	 * 
	 * @param obj_FrmValidator-> object of PAOFormatValidator class
	 * @param controlSheetFileName -> Name of the Control Sheet Report file to be generated including file path
	 * @param fileName -> Name of the input file including file patjh
	 * @param FVUVersion -> Version Number of the File Validation Utility
	 */
	public void generateControlSheetReport(SubContrFileFormatValidator obj_FrmValidator, String controlSheetFileName, String fileName, String FVUVersion)
	{
		try
		{
			//CRALog.paoLog.info("Inside generateStatisticFile Method ");
			ArrayList statisticDataList = parseString(obj_FrmValidator.getControlSheetBuffer().toString(), "\n");
            Object statisticDataArray[] = statisticDataList.toArray();
			obj_FrmValidator.setControlSheetBuffer(new StringBuffer());
            PAOFileStatisticsVO fStatistics = new PAOFileStatisticsVO();
			fStatistics = getStatisticFileDetail((String) statisticDataArray[0], "^", fStatistics);
			createStatisticFile(obj_FrmValidator, fStatistics, controlSheetFileName, fileName, FVUVersion);
		}
		catch (Exception e)
		{
			//CRALog.paoLog.error("generateStatisticFile Method : " + e.toString());
		}
	}

	private ArrayList parseString(String toParse, String Seperator)
	{
		ArrayList<Object> aList = new ArrayList<Object>();
		StringTokenizer parsed = new StringTokenizer(toParse, Seperator);
        while (parsed.hasMoreTokens())
		{
			aList.add(parsed.nextElement());
		}
		return aList;
	}

	/**
	 * Method to parse string to get data for Control Sheet Report
	 */
	private PAOFileStatisticsVO getStatisticFileDetail(String StringToParse, String Seperator, PAOFileStatisticsVO fStatistics)
	{
		//CRALog.paoLog.info("SubContrOutputFileGenerator.java getStatisticaFileDetail() method Called");
		StringTokenizer batch = new StringTokenizer(StringToParse, Seperator);
		int counter = 0;
		while (batch.hasMoreTokens())
		{
            String token = batch.nextToken();
            if (counter == 0) // Number of batches
            {
                fStatistics.setUploadedBy(token.trim());   
            }
            else if (counter == 1) // Number of batches
            {
                fStatistics.setNumberOfBatches(token.trim());   
            }
            else if (counter == 2) // FVU Version
            {
                token = CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion");
                fStatistics.setFvuVersion(token.trim());
            }
            else if (counter == 5) // Type of Uploaded File
            {
                fStatistics.setTypeOfUploadedFile(token.trim());
            }
            else if (counter == 6) // PAO Reg. No.
            {
                fStatistics.setAIN(token.trim());
            }
            else if (counter == 7) // File Creation Date
            {
                fStatistics.setFpuFileCreatedDate(token.trim());
            }
            else if (counter == 8) // Batch ID
            {
                fStatistics.setBatchId(token.trim());
            }
            else if (counter == 9) // Transaction ID
            {
                fStatistics.setTransactionId(token.trim());
            }
            else if (counter == 10) // Count of DDO Records
            {
                fStatistics.setCountOfDDORecords(token.trim());
            }
            else if (counter == 11) // Count of Subscriber Detail Records
            {
                fStatistics.setCountOfSubDetailRecords(token.trim());
            }
            else if (counter == 12) // Total Government Contribution in Batch
            {
                fStatistics.setTierOneTotalGovtContribution(token);
            }
            else if (counter == 13) // Total Self Contribution in Batch
            {
                fStatistics.setTierOneTotalSelfContribution(token);
            }
            else if (counter == 14) // Total Self Contribution in Batch
            {
                fStatistics.setTotalAmountDepositedInBank(token);
            }
            
            counter++;
        } // while () inner While
		//CRALog.paoLog.info("SubContrOutputFileGenerator.java getStatisticaFileDetail() method is returning ");
		return fStatistics;
	}

	private void createStatisticFile(SubContrFileFormatValidator obj_FrmValidator, PAOFileStatisticsVO fStatistics, String ctrlSheetFileName, String fileName, String FVUVersion)
	{
		try
		{
			StringBuffer toReturn = new StringBuffer();
			//CRALog.paoLog.info("SubContrOutputFileGenerator.java createStatisticFileString() method is called");
			toReturn.append("<HTML>");
			toReturn.append("<HEAD>");
			toReturn.append("<TITLE>SUBSCRIBER FVU CONTROL SHEET</TITLE>");
			toReturn.append("</HEAD>");
			toReturn.append("<BODY>");
			toReturn.append("<CENTER>");
			toReturn.append("<TABLE BORDER=1 WIDTH=80% BORDERCOLOR=\"000000\" CELLSPACING=0 CELLPADDING=0 " + "style='border-collapse: collapse; border: none; mso-border-alt: solid windowtext .5pt; mso-padding-alt: 0in 5.4pt 0in 5.4pt'>");
			toReturn.append("<TR>");
			toReturn.append("<TD>");
			toReturn.append("<CENTER>");
			toReturn.append("<TABLE BORDER=0 WIDTH=80% BORDERCOLOR=\"000000\" CELLSPACING=0 CELLPADDING=0 " + "style='border-collapse: collapse; border: none; mso-border-alt: solid windowtext .5pt; mso-padding-alt: 0in 5.4pt 0in 5.4pt'>");
			toReturn.append("<TR>");
			toReturn.append("<TD ALIGN=CENTER>");
			toReturn.append("<H2>SUBSCRIBER FVU - CONTROL SHEET</H2>");
			toReturn.append("</TD>");
			toReturn.append("</TR>");
			toReturn.append("</TABLE>");
			toReturn.append("</CENTER>");
			toReturn.append("<BR>");
			toReturn.append("<TABLE BORDER=1 WIDTH=100% BORDERCOLOR=\"000000\" CELLSPACING=0 CELLPADDING=0 " + "style='border-collapse: collapse; border: none; mso-border-alt: solid windowtext .5pt; mso-padding-alt: 0in 5.4pt 0in 5.4pt'>");
			toReturn.append("<TR>");
			//Modified For CR-58405
			if (fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_AO) || fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_AO_UPS))
			{
				toReturn.append("<TD WIDTH=300 VALIGN=TOP><B> PAO Reg. No. </B></CENTER></TD>");
			}
			//Modified For CR-58405
			else if(fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_PRAO) || fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_PRAO_UPS))
			{
				toReturn.append("<TD WIDTH=300 VALIGN=TOP><B> DTA Reg. No. </B></CENTER></TD>");
			}
			else
			{
				toReturn.append("<TD WIDTH=300 VALIGN=TOP><B> POP/POP-SP Reg. No. </B></CENTER></TD>");
			}
			toReturn.append("<TD WIDTH=300 VALIGN=BOTTOM>" + fStatistics.getAIN() + "</TD>");
			toReturn.append("</TR>");
			toReturn.append("</TABLE>");
			toReturn.append("<BR>");
			toReturn.append("<TABLE BORDER=1 WIDTH=100% CELLSPACING=0 CELLPADDING=0 BORDERCOLOR=BLACK " + "style='border-collapse: collapse; border: none; mso-border-alt: solid windowtext .5pt; mso-padding-alt: 0in 5.4pt 0in 5.4pt'>");
			toReturn.append("<TR>");
			toReturn.append("<TD WIDTH=300 VALIGN=TOP><B>Contribution File Type</B></TD>");
			if (fStatistics.getTypeOfUploadedFile().equals(FvuConstants.REG_CONTRIBUTION_FILE))
			{
				toReturn.append("<TD WIDTH=300>" + FvuConstants.REGULAR_FILE + "</TD>");
			}
			else
			{
				toReturn.append("<TD WIDTH=300>" + FvuConstants.CORRECTION_FILE + "</TD>");
			}
			toReturn.append("</TR>");
			toReturn.append("</TABLE>");
            toReturn.append("<BR>");
            toReturn.append("<TABLE BORDER=1 WIDTH=100% CELLSPACING=0 CELLPADDING=0 BORDERCOLOR=BLACK " + "style='border-collapse: collapse; border: none; mso-border-alt: solid windowtext .5pt; mso-padding-alt: 0in 5.4pt 0in 5.4pt'>");
            toReturn.append("<TR>");
            toReturn.append("<TD WIDTH=300 VALIGN=TOP><B> Date of File Generation </B></TD>");
            String dateFromFile = fStatistics.getFpuFileCreatedDate();
            Date dateFmt = new SimpleDateFormat("ddMMyyy").parse(dateFromFile);
            String displayDate = new SimpleDateFormat("dd-MMM-yyyy").format(dateFmt);
            toReturn.append("<TD WIDTH=300 VALIGN=TOP>" + displayDate + "</TD>"); 
            toReturn.append("</TR>");
            toReturn.append("</TABLE>");
			toReturn.append("<BR>");
			toReturn.append("<TABLE BORDER=1 WIDTH=100% CELLSPACING=0 CELLPADDING=0 BORDERCOLOR=BLACK " + "style='border-collapse: collapse; border: none; mso-border-alt: solid windowtext .5pt; mso-padding-alt: 0in 5.4pt 0in 5.4pt'>");
			toReturn.append("<TR>");
			toReturn.append("<TD WIDTH=300 VALIGN=TOP><B> Batch Id </B></TD>");
			toReturn.append("<TD WIDTH=300>" + fStatistics.getBatchId() + "</TD>");
			toReturn.append("</TR>");
			toReturn.append("</TABLE>");
			toReturn.append("<BR>");
			toReturn.append("<TABLE BORDER=1 WIDTH=100% CELLSPACING=0 CELLPADDING=0 BORDERCOLOR=BLACK " + "style='border-collapse: collapse; border: none; mso-border-alt: solid windowtext .5pt; mso-padding-alt: 0in 5.4pt 0in 5.4pt'>");
			toReturn.append("<TR>");
			toReturn.append("<TD WIDTH=300 VALIGN=TOP><B> Transaction Id </B></TD>");
			toReturn.append("<TD WIDTH=300>" + fStatistics.getTransactionId() + "</TD>");
			toReturn.append("</TR>");
			toReturn.append("</TABLE>");
			toReturn.append("<BR>");
			toReturn.append("<TABLE BORDER=1 WIDTH=100% CELLSPACING=0 CELLPADDING=0 BORDERCOLOR=BLACK " + "style='border-collapse: collapse; border: none; mso-border-alt: solid windowtext .5pt; mso-padding-alt: 0in 5.4pt 0in 5.4pt'>");
			toReturn.append("<TR>");
			//Modified For CR-58405
			if (fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_AO) || fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_AO_UPS))
			{
			       toReturn.append("<TD VALIGN=TOP WIDTH=300><B>Number of DDO's present in the file</B></TD>");
			}
			//Modified For CR-58405
			else if(fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_PRAO) || fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_PRAO_UPS))
			{
				   toReturn.append("<TD VALIGN=TOP WIDTH=300><B>Number of DTO's present in the file</B></TD>");
			}
			else
			{
			       toReturn.append("<TD VALIGN=TOP WIDTH=300><B>Number of POP-SP's present in the file</B></TD>");
			}
            toReturn.append("<TD WIDTH=300>" + fStatistics.getCountOfDDORecords() + "</TD>");
			toReturn.append("</TR>");
			toReturn.append("</TABLE>");
			toReturn.append("<BR>");
			toReturn.append("<TABLE BORDER=1 WIDTH=100% CELLSPACING=0 CELLPADDING=0 BORDERCOLOR=BLACK " + "style='border-collapse: collapse; border: none; mso-border-alt: solid windowtext .5pt; mso-padding-alt: 0in 5.4pt 0in 5.4pt'>");
			toReturn.append("<TR>");
            toReturn.append("<TD WIDTH=300 VALIGN=TOP><B>No. Of Subscriber contribution records in the file</B></TD>");
            toReturn.append("<TD WIDTH=300>" + fStatistics.getCountOfSubDetailRecords() + "</TD>");
			toReturn.append("</TR>");
			toReturn.append("</TABLE>");
			toReturn.append("<TABLE BORDER=1 WIDTH=100% CELLSPACING=0 CELLPADDING=0 BORDERCOLOR=BLACK " + "style='border-collapse: collapse; border: none; mso-border-alt: solid windowtext .5pt; mso-padding-alt: 0in 5.4pt 0in 5.4pt'>");
			toReturn.append("<TR>");
			//Modified for CR - 58405
			if (fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_AO) || fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_AO_UPS))
			{
				toReturn.append("<TD VALIGN=TOP WIDTH=300><B>Control total for Government Contribution</B></TD>");
			}
			else
			{
				toReturn.append("<TD VALIGN=TOP WIDTH=300><B>Control total for Employers Contribution</B></TD>");
			}
			toReturn.append("<TD WIDTH=300>" + fStatistics.getTierOneTotalGovtContribution() + "</TD>");
			toReturn.append("</TR>");
			toReturn.append("<BR>");
			toReturn.append("<TR>");
			//Modified for CR - 58405
			if (fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_AO) || fStatistics.getUploadedBy().equals(FvuConstants.UPLOADED_BY_AO_UPS))
			{
				toReturn.append("<TD VALIGN=TOP WIDTH=300><B>Control total for Subscribers Mandatory Contribution</B></TD>");
			}
			else
			{
				toReturn.append("<TD VALIGN=TOP WIDTH=300><B>Control total for Subscribers Contribution</B></TD>");
			}
			toReturn.append("<TD WIDTH=300>" + fStatistics.getTierOneTotalSelfContribution() + "</TD>");
			toReturn.append("</TR>");
			toReturn.append("</TABLE>");
			toReturn.append("<BR>");
			toReturn.append("&nbsp;<B>FVU Version : </B>" + FVUVersion);
			toReturn.append("<BR>");
			toReturn.append("&nbsp;<B>Input File Name :</B> " + fileName + " <BR>");
			toReturn.append("</TR>");
			toReturn.append("</TABLE>");
			toReturn.append("<CENTER>");
			toReturn.append("</BODY>");
			toReturn.append("</HTML>");
			//writeToFile(ctrlSheetFileName, toReturn.toString(), 0);            
            CRABasicFileWriter.writeFileLocal(ctrlSheetFileName,toReturn);
			toReturn = new StringBuffer();
		}
		catch (Exception e)
		{
			e.printStackTrace();
			//CRALog.paoLog.debug("EXCEPTION in SubContrOutputFileGenerator.java createStatisticFileString() : " + e.getMessage());
		}
	}
} // END OF CLASS SubContrOutputFileGenerator.java

