package com.cra.pao.ups.fvu;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

import com.cra.contr.common.util.CommonValidation;
import com.cra.contr.common.util.encrypt.NCRMod11Algorithm;
import com.cra.pao.vo.PAOContrErrorFileVO;
import com.cra.pao.vo.PAOSubDetailVO;

import cra.standalone.paosubcontr.PAOFvu;
/**
 * This class contains methods that will validate the fields of Subscriber Detail Record. It implemnts
 * FvuConstantsInterface for getting error descriptions for the corresponding error codes and for other constant values.
 * 
 * @author TCS
 */

public class SubContrRecordValidator
{
    private String ddoSerialNumberInSD = null; // Serial Number of DDO in SD Records
    private String subscriberPRAN = null; // PRAN of the subscriber
    private String contributionType = null; // Regular amount
    private String contributionmonth = null; // Month Of Contribution
    private String contributionPFM = null; //PFM Contribution For  TTS  
    private String contributionYear = null; // Year Of Contribution
    private String remarks = null; // Remarks for Arrear Conribution
    private String sdRecordHash = null; // Subscriber Contribution Detail Record Hash
    private String sdSerialNo = null; // Serial Number
    private String tierTwoSelfContributionOfSD = null; // Individual Self Contribution Amount (Tier-2)
    private String totalOfContributionsInSD = null; // Total of all Contributions in SD (Govt + Self)
    private int firstSDSrNo = 0; // Initialize Serial Number counter of First SD Record
    private int previousSDSrNo = 0; // Initialize Serial No. of the previous SD Record in the same file
    private boolean inValidfirstSerialNo = false; // Used to check the first SD record has a valid Serial Number
    private HashSet<String> ddoIdPranContribMonthYearType = new HashSet<String>();
    private HashSet<String> ackIdPranTierType = new HashSet<String>();
    private HashSet<String> PranTiertypePFMID = new HashSet<String>();
    private Map<String, Integer> countPRANForPFM = new HashMap();
// Added for Acc unfreezing
    private HashSet<String> pranContrType = new HashSet<String>();
    private HashMap<String,String> pranListT1 = new HashMap<String,String>();
    private HashMap<String,String> pranListT2 = new HashMap<String,String>();
    private HashMap<String,String> pranListFreezeT1 = new HashMap<String,String>();
    private HashMap<String,String> pranListFreezeT2 = new HashMap<String,String>();
    private HashMap<String,String> pranListFreezeMon1 = new HashMap<String,String>();
    private HashMap<String,String> pranListFreezeMon2 = new HashMap<String,String>();
    private HashMap<String,String> pranListVoluntary = new HashMap<String,String>();
//  Ended for Acc unfreezing    
//  Added for Unfreeze UT1/UT2 Dir/Indir Corp Pran
    private HashMap<String,String> pranListReg = new HashMap<String,String>();
    private HashMap<String,String> pranListArr = new HashMap<String,String>();
    private HashMap<String,String> pranListAdhoc = new HashMap<String,String>();
// Added for Revamp CR    
    private ArrayList<String> contrTypeList = new ArrayList<String>();
    private ArrayList<String> totalContrAmt = new ArrayList<String>();
    //private HashMap<String,String> pranList1 = new HashMap<String, String>();
    private ArrayList<String> pranList1 = new ArrayList<String>();
// Ended for Revamp CR
    private boolean invalidDecimalAtSD = false;
    private boolean invalidMonth = false;
    private boolean PFMinvalid = false;//Addeed To TTS 
    private boolean totGovtContrFlag=false;
    private boolean tier1SelfContFlag=false;
    private boolean arrRegFlag=false;
    private boolean arrRegAdhFlag=false;
    private boolean arrRegAdhUT1UT2Flag=false;
    private boolean uosTier2Flag=false;
    private boolean PFMForTTSFlag =false;//Addeed To TTS 
    private boolean monYearFlag=false;
    private boolean remarksFlag=false;
    
    int uniquePranCount  =0;
    
    
    /** *******************************SUBSCRIBER DETAIL RECORD VALIDATION STARTS******************************* */
    /**
     * sdFieldValidator method is called from SubContrFileFormatValidator.java to validate the DDO Transaction Details
     * Records.
     * 
     * @param objReadSD (Reference of SubContrFileFormatValidator class)
     * @param lineCountP (Logical line number for each line in the file)
     * @param sdRecord (Each SD Record is taken as a String from the file)
     * @param errStrBuff (Reference of ErrorStringBuffer class. A string buffer in which the errors are appended)
     * @param CommonValidation (Reference for using validation methods in CommonValidation class)
     * @param objPaoSubDtlbean (Reference of PAOSubDetailVO, used for setting values in the bean)
     * 
     * @return void
     */
    BigDecimal totalContrAmtRegAmt = new BigDecimal(0.00);
    BigDecimal totalContrAmtArrAmt = new BigDecimal(0.00);
    BigDecimal totalContrAmtMiscAmt = new BigDecimal(0.00);
    BigDecimal totalContrAmtT1Amt = new BigDecimal(0.00);
    BigDecimal totalContrAmtT2Amt = new BigDecimal(0.00);
    BigDecimal totalContrAmtUM1Amt = new BigDecimal(0.00);
    BigDecimal totalContrAmtUM2Amt = new BigDecimal(0.00);
    BigDecimal totalContrAmtUT1Amt = new BigDecimal(0.00);
    BigDecimal totalContrAmtUT2Amt = new BigDecimal(0.00);
    BigDecimal totalContrAmtVPFAmt = new BigDecimal(0.00);
    BigDecimal totalContrAmtTTSAmt = new BigDecimal(0.00);//Added For TTS
    private String amt = null; 
    private String pran = null;
    ArrayList<String> combo = new ArrayList<String>();
    //amrita
    int recordCountC = 0;
    int recordCount0 = 0;
    int recordCountA = 0;
    int recordCountT1 = 0;
    int recordCountT2 = 0;
    int recordCountUT1 = 0;
    int recordCountUT2 = 0;
    int recordCountUM1 = 0;
    int recordCountUM2 = 0;
    int recordCountVPF = 0;
    int recordCountTTS = 0;//Added For TTS

    void sdFieldValidator(SubContrFileFormatValidator objReadSD, int lineCountP, String sdRecord, ArrayList<PAOContrErrorFileVO> listErrorVO, PAOSubDetailVO objPaoSubDtlbean ,int utilityLevel) throws Exception
    {
    	boolean fieldFound = false;
        boolean carretFound = false;
        int caretCounter = 0;
        int localFieldCountSD = 1;
        objReadSD.lineNo = "";
        objReadSD.recType = "";
        ArrayList<String> warnings = new ArrayList<String>();
        int duplicateCount = 0;
        
        /**
         * Tokenizing the Subscriber Contribution Detail Record. Seperate the fields and '^' in the record '^' is the
         * field seperator
         */
        StringTokenizer StrTokenizerSD = new StringTokenizer(sdRecord, FvuConstants.FIELD_SEPERATOR, true);
        try {
			while (StrTokenizerSD.hasMoreTokens())
			{
			    String value = StrTokenizerSD.nextToken();
			    fieldFound = false;
			    if ((value.equals(FvuConstants.FIELD_SEPERATOR) && carretFound) || value.trim().length() == 0)
			    {
			        fieldFound = true;
			    }
			    if (value.equals(FvuConstants.FIELD_SEPERATOR))
			    {
			        carretFound = true;
			        if (caretCounter == 0 && localFieldCountSD == 1)
			        {
			            objReadSD.lineNo = "";
			        }
			        caretCounter++;
			    }
			    else
			    {
			        carretFound = false;
			        fieldFound = true;
			    }
			    if (localFieldCountSD > 15+3)
			    {
			        break;
			    }
			    if (fieldFound == true)
			    {
			        switch (localFieldCountSD)
			        {
			            case 1: 
			                objReadSD.lineNo = value;
			                break;
			            case 2:
			                objReadSD.recType = value;
			                break;
			            case 3:
			                objReadSD.batchNo = value;
			                break;
			            case 4:
			                ddoSerialNumberInSD = value;
			                break;
			            case 5:
			                sdSerialNo = value;
			                break;
			            case 6:
			            	subscriberPRAN = value;
			                pranList1.add(subscriberPRAN);
			                pran = subscriberPRAN;
			                break;
			            //CR-59184
			            case 7:
			                objReadSD.basicSalary = value;
			                break;
			            case 8:
			                objReadSD.dearnessAllow = value;
			                break;
			            case 9:
			            	 objReadSD.salaryDate = value;
				             break;
			            case 7+3:
			                objReadSD.tierOneGovtContribution = value;
			                break;
			            case 8+3:
			                objReadSD.tierOneSelfContribution = value;
			                break;
			            case 9+3:
			            	if(objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_AOV_TTS)||objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_PRAOV_TTS))
		            		{System.out.println(">>>>>>>>>>hi>>>"+contributionPFM);
		            		contributionPFM = value;
		            		}
			            	else
			            	{
			                tierTwoSelfContributionOfSD = value;
			            	}
			                break;
			            case 10+3:
			                totalOfContributionsInSD = value;
			                totalContrAmt.add(totalOfContributionsInSD);
			                amt = totalOfContributionsInSD;
			                break;
			            case 11+3:
			            	contributionType = value;
			            	combo.add(pran+"^"+contributionType);
			            	contrTypeList.add(contributionType);
			              	BigDecimal amount = new BigDecimal(amt);
			            	if(contributionType.equalsIgnoreCase(FvuConstants.CONTRIBUTION_TYPE_REGULAR)){
			            		totalContrAmtRegAmt = totalContrAmtRegAmt.add(amount);
			            		recordCountC++;
			            	}else if(contributionType.equalsIgnoreCase(FvuConstants.CONTRIBUTION_TYPE_ARREAR)){
			            		totalContrAmtArrAmt = totalContrAmtArrAmt.add(amount);
			            		recordCountA++;
			            	}else if(contributionType.equalsIgnoreCase(FvuConstants.CONTRIBUTION_TYPE_ADHOC)){
			            		totalContrAmtMiscAmt = totalContrAmtMiscAmt.add(amount);
			            		recordCount0++;
			            	}else if(contributionType.equalsIgnoreCase(FvuConstants.CONTRIBUTION_TYPE_UOS)){
			            		totalContrAmtT1Amt = totalContrAmtT1Amt.add(amount);
			            		recordCountT1++;
			            	}else if(contributionType.equalsIgnoreCase(FvuConstants.CONTRIBUTION_TYPE_TIER2)){
			            		totalContrAmtT2Amt = totalContrAmtT2Amt.add(amount);
			            		recordCountT2++;
			            	}else if(contributionType.equalsIgnoreCase(FvuConstants.CONTR_TYPE_MONTHLY1_UNFREEZE)){
			            		totalContrAmtUM1Amt = totalContrAmtUM1Amt.add(amount);
			            		recordCountUM1++;
			            	}else if(contributionType.equalsIgnoreCase(FvuConstants.CONTR_TYPE_MONTHLY2_UNFREEZE)){
			            		totalContrAmtUM2Amt = totalContrAmtUM2Amt.add(amount);
			            		recordCountUM2++;
			            	}else if(contributionType.equalsIgnoreCase(FvuConstants.CONTR_TYPE_TIER1_YRLY_UNFREEZE)){
			            		totalContrAmtUT1Amt = totalContrAmtUT1Amt.add(amount);
			            		recordCountUT1++;
			            	}else if(contributionType.equalsIgnoreCase(FvuConstants.CONTR_TYPE_TIER2_YRLY_UNFREEZE)){
			            		totalContrAmtUT2Amt = totalContrAmtUT2Amt.add(amount);
			            		recordCountUT2++;
			            	}else if(contributionType.equalsIgnoreCase(FvuConstants.CONTR_TYPE_VOLUNTARY)){
			            		totalContrAmtVPFAmt = totalContrAmtVPFAmt.add(amount);
			            		recordCountVPF++;
			            	}else if(contributionType.equalsIgnoreCase(FvuConstants.CONTRIBUTION_TYPE_UOS_TTS)){
			            		totalContrAmtTTSAmt = totalContrAmtTTSAmt.add(amount);
			            		recordCountTTS++;
			            	}
			            	//objReadSD.contributionType = value; //To display Tier-2 Contr Amt as seperate in O/P file
			                break;
			            case 12+3:
			            	//Added To TTS
			            	if(contributionType.equalsIgnoreCase(FvuConstants.CONTRIBUTION_TYPE_UOS_TTS)&& objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_UOS_TTS))
			            		contributionPFM = value;
			            	else
			                contributionmonth = value;
			                break;
			            case 13+3:
			                contributionYear = value;
			                break;
			            case 14+3:
			                remarks = value;
			                break;
			            case 15+3:
			                sdRecordHash = value;
			                break;
			        } // end of switch
			        localFieldCountSD++;
			    }
			}
		} catch (Exception e) {
			throw new Exception();
			
		}
		
//     Decide How the field name will be displayed on the basis of Upload By P / U
        if(objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_UOS))
        {
        	
        	objReadSD.PAO_SD_FIELD_4 = FvuConstants.PAO_SD_FIELD[16];        	
        	objReadSD.PAO_SD_FIELD_8 = FvuConstants.PAO_SD_FIELD[18];
        	objReadSD.PAO_SD_FIELD_12 = FvuConstants.PAO_SD_FIELD[19];
        	objReadSD.PAO_SD_FIELD_13 = FvuConstants.PAO_SD_FIELD[20];
        
        	if(contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_SWAVALAMBAN))
        	{
        		objReadSD.PAO_SD_FIELD_7 = FvuConstants.PAO_SD_FIELD[7];
        		objReadSD.PAO_SD_FIELD_14 = FvuConstants.PAO_SD_FIELD[14]; 
        		totGovtContrFlag=true;
        		monYearFlag=true;
            	remarksFlag=true;
            	
        	}
        	else
        	{
        		objReadSD.PAO_SD_FIELD_7 = FvuConstants.PAO_SD_FIELD[17];
        		objReadSD.PAO_SD_FIELD_14 = FvuConstants.PAO_SD_FIELD[21]; 
        	}
        	tier1SelfContFlag=true;      
        	uosTier2Flag=true;
        	
        	
        }//Added To TTS CR-34025 .START
        else if (objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_UOS_TTS))
        {

        	
        	objReadSD.PAO_SD_FIELD_4 = FvuConstants.PAO_SD_FIELD[16];        	
        	objReadSD.PAO_SD_FIELD_8 = FvuConstants.PAO_SD_FIELD[18];
        	objReadSD.PAO_SD_FIELD_12 = FvuConstants.PAO_SD_FIELD[19];
        	objReadSD.PAO_SD_FIELD_13 = FvuConstants.PAO_SD_FIELD[20];
        	objReadSD.PAO_SD_FIELD_7 = FvuConstants.PAO_SD_FIELD[17];
        	objReadSD.PAO_SD_FIELD_14 = FvuConstants.PAO_SD_FIELD[21]; 
        	tier1SelfContFlag=true;      
        	uosTier2Flag=true;
        	PFMForTTSFlag=true;
        	
        
        }
        //Added To TTS CR-34025 .END
        //Modified For CR-58405
        else if(objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_AO) || objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_AO_UPS))
        {
        	
        	objReadSD.PAO_SD_FIELD_4 = FvuConstants.PAO_SD_FIELD[4];
        	objReadSD.PAO_SD_FIELD_7 = FvuConstants.PAO_SD_FIELD[7];
        	objReadSD.PAO_SD_FIELD_8 = FvuConstants.PAO_SD_FIELD[8];
        	objReadSD.PAO_SD_FIELD_12 = FvuConstants.PAO_SD_FIELD[12];
        	objReadSD.PAO_SD_FIELD_13 = FvuConstants.PAO_SD_FIELD[13];
        	objReadSD.PAO_SD_FIELD_14 = FvuConstants.PAO_SD_FIELD[14];
        	totGovtContrFlag=true;
        	tier1SelfContFlag=true;
        	arrRegFlag=true;
        	monYearFlag=true;
        	remarksFlag=true;
        }
        else if (objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_KA))
        {
        	
        	objReadSD.PAO_SD_FIELD_4 = FvuConstants.PAO_SD_FIELD[4];
        	objReadSD.PAO_SD_FIELD_7 = FvuConstants.PAO_SD_FIELD[7];
        	objReadSD.PAO_SD_FIELD_8 = FvuConstants.PAO_SD_FIELD[8];
        	objReadSD.PAO_SD_FIELD_12 = FvuConstants.PAO_SD_FIELD[12];
        	objReadSD.PAO_SD_FIELD_13 = FvuConstants.PAO_SD_FIELD[13];
        	objReadSD.PAO_SD_FIELD_14 = FvuConstants.PAO_SD_FIELD[14];        	
        	arrRegFlag=true;
        	monYearFlag=true;
        	remarksFlag=true;
        }
        //Modified For CR-58405
        else if(objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_PRAO) || objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_PRAO_UPS))
        {
        	
        	objReadSD.PAO_SD_FIELD_4 = FvuConstants.PAO_SD_FIELD[22];
        	objReadSD.PAO_SD_FIELD_7 = FvuConstants.PAO_SD_FIELD[7];
        	objReadSD.PAO_SD_FIELD_8 = FvuConstants.PAO_SD_FIELD[8];
        	objReadSD.PAO_SD_FIELD_12 = FvuConstants.PAO_SD_FIELD[12];
        	objReadSD.PAO_SD_FIELD_13 = FvuConstants.PAO_SD_FIELD[13];
        	objReadSD.PAO_SD_FIELD_14 = FvuConstants.PAO_SD_FIELD[14];
        	totGovtContrFlag=true;
        	tier1SelfContFlag=true;
        	arrRegFlag=true;
        	monYearFlag=true;
        	remarksFlag=true;
        }
        else if(objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_CORP))
        {
        	
        	objReadSD.PAO_SD_FIELD_4 = FvuConstants.PAO_SD_FIELD[23];
        	objReadSD.PAO_SD_FIELD_7 = FvuConstants.PAO_SD_FIELD[17];
        	objReadSD.PAO_SD_FIELD_8 = FvuConstants.PAO_SD_FIELD[18];
        	objReadSD.PAO_SD_FIELD_12 = FvuConstants.PAO_SD_FIELD[12];
        	objReadSD.PAO_SD_FIELD_13 = FvuConstants.PAO_SD_FIELD[13];
        	objReadSD.PAO_SD_FIELD_14 = FvuConstants.PAO_SD_FIELD[14];
        	arrRegAdhUT1UT2Flag=true;
        	monYearFlag=true;
        	remarksFlag=true;
        	
        }
        // Number of carets in the Subscriber Contribution Detail Record must be exactly equal to 17.
        if (caretCounter != 14+3)
        {
            objReadSD.invalidSdCaretCount = true;
            listErrorVO.add(new PAOContrErrorFileVO("-", FvuConstants.PEF_4000, FvuConstants.RECTYPE_SDREC, objReadSD.ddoSerialNo, "-", "-",objReadSD.lineNo + "", "-"));
            //return;
        }

        if (objReadSD.invalidSdCaretCount == false)
        {
            /**
             * VALIDATING LINE NUMBER(Field No.1 of Subscriber Contribution Detail Record)
             * 
             * Line Number should not be NULL. Line Number should be of length less than or equal to 9 digits. Line
             * Number should not have leading and trailing spaces. Line Number should not have spaces in between the
             * number. Line Number should always be in sequence.
             */
            if (objReadSD.lineNo.equals(FvuConstants.FIELD_NULL) || objReadSD.lineNo.equals(FvuConstants.FIELD_SEPERATOR))
            {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[1], FvuConstants.PEF_4001, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
                objReadSD.lineNo = "-";
            }
            else if (objReadSD.lineNo.trim().length() > 9 || objReadSD.lineNo.length() > 9)
            {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[1], FvuConstants.PEF_4005, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            }
            else if (objReadSD.lineNo.length() <= 9)
            {
                String sdLineNum = CommonValidation.trimInnerSpaces(objReadSD.lineNo);
                if (CommonValidation.isInt(sdLineNum))
                {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[1], FvuConstants.PEF_4002, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
                }
                else if (!sdLineNum.equals(objReadSD.lineNo))
                {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[1], FvuConstants.PEF_4003, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
                }
                else if (Integer.parseInt(objReadSD.lineNo.trim()) != lineCountP)
                {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[1], FvuConstants.PEF_4004, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
                }
            }
            else if (objReadSD.lineNo.trim().length() != objReadSD.lineNo.length())
            {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[1], FvuConstants.PEF_4003, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            } // End of LINE NUMBER Validation

            /**
             * Validation of RECORD TYPE(Field No.2 of Subscriber Contribution Detail Record)
             * 
             * Record Type should not be NULL. Record Type should be "SD" for Subscriber Contribution Detail Record.
             * Values other than "SD" are invalid.
             */
            if (objReadSD.recType.equals(FvuConstants.FIELD_NULL) || objReadSD.recType.equals(FvuConstants.FIELD_SEPERATOR))
            {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[2], FvuConstants.PEF_4001, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            }
            else if (!objReadSD.recType.equals(FvuConstants.SD_REC))
            {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[2], FvuConstants.PEF_4006, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            } // End of RECORD TYPE Validation

            /**
             * Validation of BATCH NUMBER(Field No.3 of Subscriber Contribution Detail Record)
             * 
             * Batch Number should not be NULL. Batch Number should be of length less than or equal to 9 digits. Batch
             * Number should not have leading and trailing spaces. Batch Number should not have spaces in between the
             * number. Batch Number should always have the value as '1'.
             */
            if (objReadSD.batchNo.equals(FvuConstants.FIELD_NULL) || objReadSD.batchNo.equals(FvuConstants.FIELD_SEPERATOR))
            {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[3], FvuConstants.PEF_4001, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            }
            else if (objReadSD.batchNo.trim().length() > 9 || objReadSD.batchNo.length() > 9)
            {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[3], FvuConstants.PEF_4005, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            }
            else if (objReadSD.batchNo.length() <= 9)
            {
                String sdBatchNumber = CommonValidation.trimInnerSpaces(objReadSD.batchNo);
                if (CommonValidation.isInt(sdBatchNumber))
                {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[3], FvuConstants.PEF_4002, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
                }
                else if (!sdBatchNumber.equals(objReadSD.batchNo))
                {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[3], FvuConstants.PEF_4003, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
                }
                else if (Integer.parseInt(objReadSD.batchNo.trim()) != 1)
                {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[3], FvuConstants.PEF_4007, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
                }
            }
            else if (objReadSD.batchNo.trim().length() != objReadSD.batchNo.length())
            {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[3], FvuConstants.PEF_4003, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            } // End of BATCH NUMBER Validation

            /**
             * Validation of DDO SERIAL NUMBER NUMBER(Field No.4 of Subscriber Contribution Detail Record)
             * 
             * Serial Number should not be NULL. Serial Number should be of length less than or equal to 9 digits.
             * Serial Number should not have leading and trailing spaces. Serial Number should not have spaces in
             * between the number. Serial Number should always be in sequence.
             */

            if (objReadSD.inValidfirstDDOSerialNo == false)
            {
                if (ddoSerialNumberInSD.equals(FvuConstants.FIELD_NULL) || ddoSerialNumberInSD.equals(FvuConstants.FIELD_SEPERATOR))
                {
                    listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_4, FvuConstants.PEF_4001, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
                }
                else if (ddoSerialNumberInSD.trim().length() > 9 || ddoSerialNumberInSD.length() > 9)
                {
                    listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_4, FvuConstants.PEF_4005, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
                }
                String ddoSerialNumInSd = CommonValidation.trimInnerSpaces(ddoSerialNumberInSD);
                if (CommonValidation.isInt(ddoSerialNumInSd))
                {
                    listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_4, FvuConstants.PEF_4002, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
                }
                else if (!ddoSerialNumInSd.equals(ddoSerialNumberInSD))
                {
                    listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_4, FvuConstants.PEF_4003, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
                }
                else if (ddoSerialNumberInSD.trim().length() != ddoSerialNumberInSD.length())
                {
                    listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_4, FvuConstants.PEF_4003, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
                }
                else if (!objReadSD.invalidDdoCaretCount && (Integer.parseInt(ddoSerialNumInSd.trim()) != Integer.parseInt(objReadSD.ddoSerialNo.trim())))
                {
                    listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_4, Integer.parseInt(objReadSD.sectorCategory +FvuConstants.PEF_4018), FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
                }
            }
            // End of DDO SERIAL NUMBER Validation
            /**
             * Validation of SUBSCRIBER RECORD SERIAL NUMBER(Field No. 5 of Subscriber Contribution Detail Record)
             * 
             * Serial Number is MANDATORY irrespective of the Statement Type. Serial number should be a numeric value of
             * length less than or equal to 9 digits. Serial Number should not be "0" (Zero). Serial Number should not
             * have negative or decimal values Serial Number must be in sequence. No leading and trailing spaces should
             * be specified.
             */
            if (sdSerialNo.equals(FvuConstants.FIELD_NULL) || sdSerialNo.equals(FvuConstants.FIELD_SEPERATOR))
            {
            	inValidfirstSerialNo = true;
            	listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[5], FvuConstants.PEF_4001, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
                previousSDSrNo++;
            }
            else if (sdSerialNo.trim().length() > 9 || sdSerialNo.length() > 9)
            {
            	inValidfirstSerialNo = true;
            	listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[5], FvuConstants.PEF_4005, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
                previousSDSrNo++;
            }
            else if (CommonValidation.isInt(sdSerialNo))
            {
            	inValidfirstSerialNo = true;
            	listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[5], FvuConstants.PEF_4002, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
                previousSDSrNo++;
            }
            else if (sdSerialNo.trim().length() != sdSerialNo.length())
            {
            	inValidfirstSerialNo = true;
            	listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[5], FvuConstants.PEF_4003, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
                previousSDSrNo++;
            }
            else if (Integer.parseInt(sdSerialNo.trim()) < 1)
            {
                inValidfirstSerialNo = true;
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[5], FvuConstants.PEF_4008, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            }
            else if (objReadSD.totalNoOfSDRead == 1)
            {
                // To check the serial number is not "0" (Zero).
                firstSDSrNo = Integer.parseInt(sdSerialNo.trim());
                if (firstSDSrNo != 1)
                {
                    inValidfirstSerialNo = true;
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[5], FvuConstants.PEF_4008, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
                }
                else
                {
                    previousSDSrNo = Integer.parseInt(sdSerialNo.trim());
                }
            }
            else if (objReadSD.totalNoOfSDRead > 1 && inValidfirstSerialNo == false && objReadSD.invalidSdCaretCount == false)
            {
                // To check the serial numbers are in sequence.

                if (Integer.parseInt(sdSerialNo.trim()) != (previousSDSrNo + 1))
                {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[5], FvuConstants.PEF_4004, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
                }
                else
                {
                    previousSDSrNo = Integer.parseInt(sdSerialNo.trim());
                }
            }// End of SERIAL NUMBER Validation

            /**
             * Validation of Subscriber PRAN(Field No. 6 Of Subscriber Contribution Detail Record) Permanent Retirement
             * Account Number
             */
            if (subscriberPRAN.equals(FvuConstants.FIELD_NULL) || subscriberPRAN.equals(FvuConstants.FIELD_SEPERATOR))
            {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[6], FvuConstants.PEF_4001, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            }
            else if (subscriberPRAN.trim().length() != 12 || subscriberPRAN.length() != 12)
            {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[6], FvuConstants.PEF_4013, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            }
            else if (CommonValidation.isInt(subscriberPRAN))
            {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[6], FvuConstants.PEF_4002, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            }
            else if (Long.parseLong(subscriberPRAN) == 0)
            {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[6], FvuConstants.PEF_4002, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            }
            else if (!NCRMod11Algorithm.isValidNumber(subscriberPRAN))
            {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[6], FvuConstants.PEF_4002, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            }

            /**
             * Validation of TIER-1 GOVERNMENT CONTRIBUTION(Field No. 7 Of Subscriber Contribution Detail Record)
             * This field is MANDATORY. Contibution Amount should be a decimal number of length less than or equal to 21 digits.
             * Amount should not be Negative. Amount should be greater than  0.00 if Upload By 'P'.
             */

            if (objReadSD.tierOneGovtContribution.equals(FvuConstants.FIELD_NULL) || objReadSD.tierOneGovtContribution.equals(FvuConstants.FIELD_SEPERATOR))
            {
                objReadSD.inValidContributionAmt = true;
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[20], FvuConstants.PEF_4001, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            }
            else if (objReadSD.tierOneGovtContribution.trim().length() > 21 || objReadSD.tierOneGovtContribution.length() > 21)
            {
                objReadSD.inValidContributionAmt = true;
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[20], FvuConstants.PEF_4005, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            }
            else if (CommonValidation.checkTabSpaces(objReadSD.tierOneGovtContribution))
            {
                objReadSD.inValidContributionAmt = true;
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[20], FvuConstants.PEF_4003, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            }
            else if (CommonValidation.isDecimalNumber(objReadSD.tierOneGovtContribution))
            {
                objReadSD.inValidContributionAmt = true;
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[20], FvuConstants.PEF_4002, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            }
            else if (objReadSD.tierOneGovtContribution.trim().length() != objReadSD.tierOneGovtContribution.length())
            {
            	objReadSD.inValidContributionAmt = true;
            	listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[20], FvuConstants.PEF_4003,  FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            }
            //Added For TTS -34025
            //System.out.println(objReadSD.tierOneGovtContribution);
            else if((objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_PRAOV_TTS)||objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_AOV_TTS)) && (objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_AOV_TTS)||objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_PRAOV_TTS)) && Double.parseDouble(objReadSD.tierOneGovtContribution) != 0.00)
                {
            	objReadSD.inValidContributionAmt = true;
            	listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[17], FvuConstants.PEF_4025,  FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
                
            }
           /* else if (utilityLevel != 5 && totGovtContrFlag && Double.parseDouble(objReadSD.tierOneGovtContribution) == 0.00)
            {
            	objReadSD.inValidContributionAmt = true;
            	listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_7, FvuConstants.PEF_2031, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            }*/
            //Added To  TTS CR-34025 START
            else if(objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_UOS_TTS) && contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_UOS_TTS) && Double.parseDouble(objReadSD.tierOneGovtContribution) != 0.00)
            {
            	objReadSD.inValidContributionAmt = true;
            	//CHANGE Error Message 
            	listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_7, FvuConstants.PEF_4025, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            }
          //Added To  TTS CR-34025 END
            else if(objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_UOS) && contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_TIER2) && Double.parseDouble(objReadSD.tierOneGovtContribution) != 0.00)
            {
            	objReadSD.inValidContributionAmt = true;
            	//CHANGE Error Message 
            	listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_7, FvuConstants.PEF_4025, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            }
            // Added FTR : 19553
            else if(objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_UOS) && contributionType.equals(FvuConstants.CONTR_TYPE_VOLUNTARY) && Double.parseDouble(objReadSD.tierOneGovtContribution) != 0.00)
            {
            	objReadSD.inValidContributionAmt = true;
            	listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_7, FvuConstants.PEF_4074, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            }
            else if(objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_UOS) && totGovtContrFlag && Double.parseDouble(objReadSD.tierOneGovtContribution) == 0.00)
            {
            	objReadSD.inValidContributionAmt = true;
            	//CHANGE Error Message 
            	listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_7, FvuConstants.PEF_4025, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            }
            else
            {
            	// Add the individual contribution amounts of each SD Record.
            	objPaoSubDtlbean.setTierOneGovtContribution(objReadSD.tierOneGovtContribution.trim());
            	
            } // END OF CONTRIBUTION AMOUNT VALIDATION
            
            /** Validation of TIER-1 SELF CONTRIBUTION(Field No. 8 Of Subscriber Contribution Detail Record)
             * This field is MANDATORY. Contibution Amount should be a decimal number of length less than or equal to 21 digits.
             * Amount should not be Negative. Amount should be greater than  0.00.
             */
            //Added For 14% FTR-39795 .START
            
             if("Y".equalsIgnoreCase(PAOFvu.OSEqualFlag)&&"N".equalsIgnoreCase(PAOFvu.unequalFlag))
            {
            	System.out.println("Gov contribution["+objReadSD.tierOneGovtContribution+"sub conntribution"+objReadSD.tierOneSelfContribution);
				
            	 if (!CommonValidation.isDecimalNumber(objReadSD.tierOneGovtContribution)&&!CommonValidation.isDecimalNumber(objReadSD.tierOneSelfContribution))
                {
            		 System.out.println("Gov contribution["+objReadSD.tierOneGovtContribution.trim()+"sub conntribution"+Double.parseDouble(objReadSD.tierOneSelfContribution));
						Object govAmt=objReadSD.tierOneGovtContribution;
						Object SubAmt=objReadSD.tierOneSelfContribution;
						BigDecimal amt1=new BigDecimal(govAmt.toString());
						BigDecimal amt2=new BigDecimal(SubAmt.toString());
						System.out.println("Gov contribution["+amt1+"sub conntribution"+amt2);
						if(amt1.compareTo(amt2)!=0)
						{
							//CR 40859
							DecimalFormat df = new DecimalFormat("###.##");
							double  amt3=Double.parseDouble(SubAmt.toString()) * (1.40);
							BigDecimal gAmtCalculate=new BigDecimal(df.format(amt3)); 
							System.out.println("gAmtCalculate :- " + gAmtCalculate);
							Integer Intamt=gAmtCalculate.intValue(); 
							System.out.println("Intamt :- " + Intamt);
							Integer IntamtMinus =Intamt - 1;  
							Integer IntamtPlus =Intamt + 1;  
							System.out.println("IntamtMinus :- " + IntamtMinus + " IntamtPlus :-"+IntamtPlus);
							BigDecimal BdecicmalMinus=new BigDecimal(IntamtMinus);
							BigDecimal BdecicmalPlus=new BigDecimal(IntamtPlus);
							System.out.println("BdecicmalMinus :- " + BdecicmalMinus +" BdecicmalPlus:- " + BdecicmalPlus );
							boolean minusRange=false;
							boolean plusRange=false;
							if(amt1.compareTo(BdecicmalMinus) == -1){
							minusRange=true;
							System.out.println ("minusRange "+minusRange);
							}
							if(amt1.compareTo(BdecicmalPlus) == 1){
							plusRange=true;
							System.out.println ("plusRange"+plusRange);
							}
							if(minusRange || plusRange){
							System.out.println("inValid ContributionAmt");
								objReadSD.inValidContributionAmt = true;
				            	listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_8, FvuConstants.PEF_5015, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
				            }
							//CR End 40859
						}
					
                }
            	
            }
            //Added For 14% FTR-39795.END
            if (objReadSD.tierOneSelfContribution.equals(FvuConstants.FIELD_NULL) || objReadSD.tierOneSelfContribution.equals(FvuConstants.FIELD_SEPERATOR))
            {
                objReadSD.inValidContributionAmt = true;
               // listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_8, FvuConstants.PEF_4001, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[21], FvuConstants.PEF_4001, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            } 
            else if (objReadSD.tierOneSelfContribution.trim().length() > 21 || objReadSD.tierOneSelfContribution.length() > 21)
            {
                objReadSD.inValidContributionAmt = true;
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[21], FvuConstants.PEF_4005, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            } 
            else if (CommonValidation.checkTabSpaces(objReadSD.tierOneSelfContribution))
            {
                objReadSD.inValidContributionAmt = true;
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[21], FvuConstants.PEF_4003, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            }
            else if (CommonValidation.isDecimalNumber(objReadSD.tierOneSelfContribution))
            {
                objReadSD.inValidContributionAmt = true;
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[21], FvuConstants.PEF_4002, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            }
            else if (objReadSD.tierOneSelfContribution.trim().length() != objReadSD.tierOneSelfContribution.length())
            {
            	objReadSD.inValidContributionAmt = true;
            	listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[21], FvuConstants.PEF_4003,  FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            }
           /* else if (utilityLevel != 5 && tier1SelfContFlag && !contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_SWAVALAMBAN)&& Double.parseDouble(objReadSD.tierOneSelfContribution) == 0.00)
            {
            	objReadSD.inValidContributionAmt = true;
            	listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_8, FvuConstants.PEF_2031, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            }*/
            else if (utilityLevel != 5 && tier1SelfContFlag && contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_SWAVALAMBAN) && Double.parseDouble(objReadSD.tierOneSelfContribution) != 0.00)
            {
            	//Added for Swavalamban
            	objReadSD.inValidContributionAmt = true;
            	listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_8, FvuConstants.PEF_5007, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            }

            /*else if (utilityLevel != 5 && objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_AO) && !objReadSD.tierOneGovtContribution.equals(objReadSD.tierOneSelfContribution))
            {
            	objReadSD.inValidContributionAmt = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_8, FvuConstants.PEF_3012, FvuConstants.RECTYPE_SDREC,ddoSerialNumberInSD, sdSerialNo, objReadSD.lineNo + "" , "-"));
            }*/
            else
            {
            	objPaoSubDtlbean.setTierOneSelfContribution(objReadSD.tierOneSelfContribution.trim());
            }// END OF CONTRIBUTION AMOUNT VALIDATION
             if (objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_KA) && Double.parseDouble(objReadSD.tierOneGovtContribution) > 0.00 && Double.parseDouble(objReadSD.tierOneSelfContribution) > 0.00
            		&& (Double.parseDouble(objReadSD.tierOneGovtContribution) != Double.parseDouble(objReadSD.tierOneSelfContribution)))
            {
            	objReadSD.inValidContributionAmt = true;
            	listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_7, FvuConstants.PEF_4026, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            	
            }

        
            /**
             * Validation of TIER-2 SELF CONTRIBUTION(Field No. 9 Of Subscriber Contribution Detail Record) This field
             * is NULL. (Validations to be added when this is mandatory) - Vijay Oct 25, 2007
             */
           // System.out.println("tierTwoSelfContributionOfSD :"+tierTwoSelfContributionOfSD);
            if(!objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_CORP)&&!objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_PRAOV_TTS)&&!objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_AOV_TTS)){
	            if (!tierTwoSelfContributionOfSD.equals(FvuConstants.FIELD_NULL) && !tierTwoSelfContributionOfSD.equals(FvuConstants.FIELD_SEPERATOR))
	            {
	                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[9], FvuConstants.PEF_4017, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
	            }
            }
            else if(objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_CORP) && !tierTwoSelfContributionOfSD.equals(FvuConstants.FIELD_NULL) && !tierTwoSelfContributionOfSD.equals(FvuConstants.FIELD_SEPERATOR))
            {
            	if (CommonValidation.checkTabSpaces(tierTwoSelfContributionOfSD))
                {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[21] , FvuConstants.PEF_4003, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
                }
                else if (tierTwoSelfContributionOfSD.trim().equals(""))
                {
                	listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[21] , FvuConstants.PEF_4002, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
                }
                else if (CommonValidation.isInt(tierTwoSelfContributionOfSD))
        		{
                	listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[21] , FvuConstants.PEF_4002, FvuConstants.RECTYPE_SDREC,ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "" , "-"));
        		}
          	  	else if (tierTwoSelfContributionOfSD.trim().length() != 17 || tierTwoSelfContributionOfSD.length() != 17)
                {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[21] , FvuConstants.PEF_4023, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
                }
          	  	else if (Long.parseLong(tierTwoSelfContributionOfSD.trim()) == 0)
        		{
          	  		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[21] , FvuConstants.PEF_4002, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
        		}
        		else if (!tierTwoSelfContributionOfSD.substring(0,2).equals(FvuConstants.TYPE_OF_REQUEST))
        		{
        			listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[21] , FvuConstants.PEF_4002, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
        		}
        		/**
        		 * added for CR # 15163 to check if format of Receipt No in proper INDIRECT MODEL 
        		 */
        		else if(!CommonValidation.validateAIN(tierTwoSelfContributionOfSD.substring(2, 9)))
        		{
        			listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[21] , FvuConstants.PEF_4002, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
        		}
        		/**
        		 * CR # 15163 ends here
        		 */
            }
            
            BigDecimal tierOneSDAmountGovt = null;
            BigDecimal tierOneSDAmountSelf = null;
            BigDecimal totalAmountInSDRecord = null;
           
            if (totalOfContributionsInSD.equals(FvuConstants.FIELD_NULL) || totalOfContributionsInSD.equals(FvuConstants.FIELD_SEPERATOR))
            {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[10], FvuConstants.PEF_4001, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            }
            else if (totalOfContributionsInSD.trim().length() > 21 || totalOfContributionsInSD.length() > 21)
            {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[10], FvuConstants.PEF_4005, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            }
            else if (CommonValidation.checkTabSpaces(totalOfContributionsInSD))
            {
            	listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[10], FvuConstants.PEF_4003, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            }
            else if (CommonValidation.isDecimalNumber(totalOfContributionsInSD))
            {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[10], FvuConstants.PEF_4002, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            }
            else if(totalOfContributionsInSD.trim().length()!= totalOfContributionsInSD.length())
            {
            	listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[10], FvuConstants.PEF_4003, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            }
            else if (new BigDecimal(totalOfContributionsInSD).compareTo(new BigDecimal(0.00))==0)
            {
            	listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[10], FvuConstants.PEF_2031, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            }
            else
            {
            	BigDecimal totalAmount = new BigDecimal(totalOfContributionsInSD);
            	if (objReadSD.inValidContributionAmt == false)
                {
                    tierOneSDAmountGovt = new BigDecimal(objReadSD.tierOneGovtContribution.trim());
                    tierOneSDAmountSelf = new BigDecimal(objReadSD.tierOneSelfContribution.trim());
                    totalAmountInSDRecord = tierOneSDAmountGovt.add(tierOneSDAmountSelf);
                    if (!totalAmount.equals(totalAmountInSDRecord))
                    {
                        listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[10], Integer.parseInt(objReadSD.sectorCategory + FvuConstants.PEF_4016), FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
                    }
                }
            }

            /**
             * Validation of CONTRIBUTION TYPE(Field No. 11 of Subscriber Contribution Detail Record) Value should be
             * 'R' for Regular and 'A' for Arrear and '0' Adhoc and UT1 for Unfreeze Yearly T1.
             */
            if (contributionType.equals(FvuConstants.FIELD_NULL) || contributionType.equals(FvuConstants.FIELD_SEPERATOR))
            {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[11], FvuConstants.PEF_4001, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            }
            else if (arrRegFlag && !contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_ARREAR) && !contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_REGULAR))
            {
            	listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[11], Integer.parseInt(objReadSD.sectorCategory + FvuConstants.PEF_4009), FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            }
            //else if (arrRegAdhUT1UT2Flag && !contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_ARREAR) && !contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_REGULAR) && !contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_ADHOC) && !contributionType.equals(FvuConstants.CONTR_TYPE_TIER1_YRLY_UNFREEZE) && !contributionType.equals(FvuConstants.CONTR_TYPE_TIER2_YRLY_UNFREEZE))
         // Added for CR - VPF-T2 Contribution for Corp
            else if (arrRegAdhUT1UT2Flag && !contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_ARREAR) && !contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_REGULAR) && !contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_ADHOC) && !contributionType.equals(FvuConstants.CONTR_TYPE_TIER1_YRLY_UNFREEZE) && !contributionType.equals(FvuConstants.CONTR_TYPE_TIER2_YRLY_UNFREEZE) && !contributionType.equals(FvuConstants.CONTR_TYPE_VOLUNTARY) && !contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_TIER2))
            {
            	listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[11], Integer.parseInt(objReadSD.sectorCategory + FvuConstants.PEF_4009), FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            }
            //Account unfreezing contribution amount chk CR :10771
            //********code changes added for addition of UM2  CR : 11579*****//
            else if(uosTier2Flag && !contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_UOS_TTS) && !contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_UOS) && !contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_TIER2) && !contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_SWAVALAMBAN) && !contributionType.equals(FvuConstants.CONTR_TYPE_TIER1_YRLY_UNFREEZE) && !contributionType.equals(FvuConstants.CONTR_TYPE_TIER2_YRLY_UNFREEZE) && !contributionType.equals(FvuConstants.CONTR_TYPE_MONTHLY1_UNFREEZE) && !contributionType.equals(FvuConstants.CONTR_TYPE_MONTHLY2_UNFREEZE) && !contributionType.equals(FvuConstants.CONTR_TYPE_VOLUNTARY))
            {
            	//Added for Swavalamban
            	//if(PAOFvu.uosvpfFlag.equalsIgnoreCase("N")){
            		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[11], Integer.parseInt(objReadSD.sectorCategory + FvuConstants.PEF_4009), FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            	/*}else if(PAOFvu.uosvpfFlag.equalsIgnoreCase("Y") && !contributionType.equals(FvuConstants.CONTR_TYPE_VOLUNTARY)){
            		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[11], Integer.parseInt(objReadSD.sectorCategory + FvuConstants.PEF_4069), FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            	}*/
            }
            //Added For TTS CG\SG .START
            else if(objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_PRAOV_TTS)||objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_AOV_TTS))
            {
            	if(!contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_UOS_TTS))
            		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[11], Integer.parseInt(objReadSD.sectorCategory + FvuConstants.PEF_5012), FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));	
            }
          //Added For TTS CG\SG .END
            //********code changes added for addition of UM2  CR : 11579 *****//
            if (contributionType.equals(FvuConstants.FIELD_NULL) || contributionType.equals(FvuConstants.FIELD_SEPERATOR))
            {
            	listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[11], FvuConstants.PEF_4001, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            }
            //CR 16816 : Added to remove validation for 0.00 contr amt for UT1 for Corp
            if (((objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_UOS) && contributionType.equals(FvuConstants.CONTR_TYPE_TIER1_YRLY_UNFREEZE)) || contributionType.equals(FvuConstants.CONTR_TYPE_TIER2_YRLY_UNFREEZE) || contributionType.equals(FvuConstants.CONTR_TYPE_MONTHLY1_UNFREEZE)|| contributionType.equals(FvuConstants.CONTR_TYPE_MONTHLY2_UNFREEZE)) && (Double.parseDouble(objReadSD.tierOneGovtContribution) != 0.00))
            {
            	objReadSD.inValidContributionAmt = true;
            	listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[17], Integer.parseInt(objReadSD.sectorCategory + FvuConstants.PEF_4027), FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            }
            //Added for CR 23214
            //Modified for CR-58405
            if (objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_AO) || objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_PRAO) || objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_KA) || objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_AO_UPS) || objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_PRAO_UPS))
            {
            	if(objReadSD.fileFlag.equals(FvuConstants.MONTHLY_FLAG) && !contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_REGULAR))
            	{
            		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[11], FvuConstants.PEF_4075, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            	}
            	if(objReadSD.fileFlag.equals(FvuConstants.ADHOC_FLAG) && !(contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_ARREAR) || contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_REGULAR)))
            	{
            		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[11], FvuConstants.PEF_4076, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            	}
            }
// Ended Account unfreezing contribution amount chk
            /**
             * Validation On PFM Fields For TTS .START */
         // Added for TTS CG\SG CR-34025
            if ((PFMForTTSFlag && contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_UOS_TTS))||objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_AOV_TTS)||objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_PRAOV_TTS))
            {
                if (contributionPFM.equals(FvuConstants.FIELD_NULL) || contributionPFM.equals(FvuConstants.FIELD_SEPERATOR))
                {
                	PFMinvalid = true;
                	listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_12, FvuConstants.PEF_4001, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
                }
            }
            if ((PFMForTTSFlag||objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_AOV_TTS)||objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_PRAOV_TTS)) && !contributionPFM.equals(FvuConstants.FIELD_NULL) && !contributionPFM.equals(FvuConstants.FIELD_SEPERATOR))
            {
            	if (contributionPFM.trim().length() != contributionPFM.length())
            	{
            		PFMinvalid = true;
            		listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_12, FvuConstants.PEF_4003, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            	}
            	 if (contributionPFM.trim().length() != 6 || contributionPFM.length() != 6)
            	{
            		PFMinvalid = true;
            		listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_12, FvuConstants.PEF_5009, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            	}
            	 if (!"PFM".equalsIgnoreCase(contributionPFM.substring(0, 3)))
            	{
            		PFMinvalid = true;
            		listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_12, FvuConstants.PEF_5010, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            	}

            }
            if(objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_UOS_TTS) && (contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_UOS_TTS) ))
            {
         	   if (!contributionYear.equals(FvuConstants.FIELD_NULL) && !contributionYear.equals(FvuConstants.FIELD_SEPERATOR) )
                {
         		  listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_13, FvuConstants.PEF_4017, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-")); 
         		  //Error message will be changes.Year must be null. 
                }
         	   
            }
            /**
             * Validation On PFM Fields For TTS .END */
            /**
             * Validation of MONTH OF CONTRIBUTION(Field No. 12 of Subscriber Contribution Detail Record) Value should
             * be numeric of length exactly equal to 2 digits. No leading amd trailing spaces should be specified.
             */
            if (monYearFlag && contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_REGULAR))
            {
                if (contributionmonth.equals(FvuConstants.FIELD_NULL) || contributionmonth.equals(FvuConstants.FIELD_SEPERATOR))
                {
                	invalidMonth = true;
                	listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_12, FvuConstants.PEF_4001, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
                }
            }
            if (monYearFlag && (contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_ARREAR)||contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_SWAVALAMBAN)))
            {
            	//Modified For Swavalamban
                if (contributionmonth.equals(FvuConstants.FIELD_NULL) || contributionmonth.equals(FvuConstants.FIELD_SEPERATOR))
                {
                    // Optional Field
                }
            }
           
           if(objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_UOS) && ( contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_UOS) || contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_TIER2)))
           {
        	   if (!contributionmonth.equals(FvuConstants.FIELD_NULL) && !contributionmonth.equals(FvuConstants.FIELD_SEPERATOR) )
               {
        		   invalidMonth = true;
        		   listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_12, FvuConstants.PEF_4017, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
        		  //Error message will be changes.Month must be null. 
               }
        	   
           }
            if (monYearFlag && !contributionmonth.equals(FvuConstants.FIELD_NULL) && !contributionmonth.equals(FvuConstants.FIELD_SEPERATOR))
            {
                if (contributionmonth.trim().length() != contributionmonth.length())
                {
                	invalidMonth = true;
                    listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_12, FvuConstants.PEF_4003, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
                }
                else if (contributionmonth.trim().length() != 2 || contributionmonth.length() != 2)
                {
                	invalidMonth = true;
                    listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_12, FvuConstants.PEF_4010, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
                }
                else if (CommonValidation.isInt(contributionmonth))
                {
                	invalidMonth = true;
                    listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_12, FvuConstants.PEF_4002, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
                }
                else if (Integer.parseInt(contributionmonth) < 1 || Integer.parseInt(contributionmonth) > 12)
                {
                	invalidMonth = true;
                    listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_12, FvuConstants.PEF_4019, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
                }
              //Added for CR 23214
              //Modified for CR-58405
                if ((objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_AO) || objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_PRAO) || objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_KA) || objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_AO_UPS) || objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_PRAO_UPS)) && objReadSD.fileFlag.equals(FvuConstants.MONTHLY_FLAG))
                {
                	if(!objReadSD.fileMonth.equals(contributionmonth))
                	{
                		invalidMonth = true;
                        listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_12, FvuConstants.PEF_4077, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
                	}
                }
            }
            //End of MONTH OF CONTRIBUTION Validation
            /**
             * Validation of YEAR OF CONTRIBUTION(Field No. 13 of Subscriber Contribution Detail Record) Value should be
             * numeric of length exactly equal to 4 digits. No leading amd trailing spaces should be specified.
             */
            if ( monYearFlag && (contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_REGULAR)||contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_SWAVALAMBAN)))
            {
                if (contributionYear.equals(FvuConstants.FIELD_NULL) || contributionYear.equals(FvuConstants.FIELD_SEPERATOR))
                {
                    listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_13, FvuConstants.PEF_4001, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
                }
            }
            if ( monYearFlag && contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_ARREAR))
            {
            	//Modified for Swavalamban
            	if (contributionYear.equals(FvuConstants.FIELD_NULL) || contributionYear.equals(FvuConstants.FIELD_SEPERATOR))
                {
                    // Optional Field
                }
            }
            if(objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_UOS) && (contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_UOS) || contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_TIER2)))
            {
         	   if (!contributionYear.equals(FvuConstants.FIELD_NULL) && !contributionYear.equals(FvuConstants.FIELD_SEPERATOR) )
                {
         		  listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_13, FvuConstants.PEF_4017, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-")); 
         		  //Error message will be changes.Year must be null. 
                }
         	   
            }
            if ( monYearFlag &&  !contributionYear.equals(FvuConstants.FIELD_NULL) && !contributionYear.equals(FvuConstants.FIELD_SEPERATOR))
            {		
        
            	if (contributionYear.trim().length() != contributionYear.length())
            	{
            		listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_13, FvuConstants.PEF_4003, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            	}
            	else if (contributionYear.trim().length() != 4 || contributionYear.length() != 4)
            	{
            		listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_13, FvuConstants.PEF_4011, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            	}
            	else if (CommonValidation.isInt(contributionYear))
            	{
            		listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_13, FvuConstants.PEF_4002, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            	}
            	else 
            	{
            		Calendar cal = new GregorianCalendar();
            		cal.setLenient(false);
            		int currentYear = cal.get(Calendar.YEAR);
            		int yearOfContribution = Integer.parseInt(contributionYear);
            		//CR 31537
            		int contUplodYear = 2003;
            		//rsona-31st March -removing check cant upload file having contr year less than four years 
            		//	int fourYearsBackFromCurrent = (currentYear - 4);
            		int currentMonth = cal.get(Calendar.MONTH);
            		
            		if(yearOfContribution == currentYear && (!invalidMonth) && !contributionmonth.equals(FvuConstants.FIELD_NULL) && !contributionmonth.equals(FvuConstants.FIELD_SEPERATOR))
            		{
            			int monthOfContribution = Integer.parseInt(contributionmonth);
            			if(monthOfContribution > (currentMonth + 1))
            			{
            				listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_12, FvuConstants.PEF_4022, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            			}
            		}		
            		else if (yearOfContribution < contUplodYear)
            		{
            			PAOContrErrorFileVO paoContrErrorVO=new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_13, FvuConstants.PEF_4015, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-");
            			paoContrErrorVO.setErrorCodeStr(" "+(contUplodYear));
            			listErrorVO.add(paoContrErrorVO);
            		}
            		/*else if (yearOfContribution < fourYearsBackFromCurrent)
            		{
            			listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_13, FvuConstants.PEF_4021, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            		}*/
            		else if (yearOfContribution > (currentYear))
            		{
            			listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_13, FvuConstants.PEF_4020, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            		}
            	}
            	//Added for CR 23214
            	//Modified for CR-58405
            	if ((objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_AO) || objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_PRAO) || objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_KA) || objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_AO_UPS) || objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_PRAO_UPS)) && objReadSD.fileFlag.equals(FvuConstants.MONTHLY_FLAG))
                {
                	if(!objReadSD.fileYear.equals(contributionYear))
                	{
                		listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_13, FvuConstants.PEF_4078, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
                	}
                }
            } // End of YEAR OF CONTRIBUTION Validation

            /**
             * Validation of REMARKS(Field No. 14 of Subscriber Contribution Detail Record) Value should be less than or
             * equal to 75 characters. No Tab spaces should be specified.
             */

            if (remarksFlag && contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_REGULAR))
            {
            	if (remarks.equals(FvuConstants.FIELD_NULL) || remarks.equals(FvuConstants.FIELD_SEPERATOR))
                {
                    // optional field
                }
                else if (CommonValidation.checkTabSpaces(remarks))
                {
                	listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_14 , FvuConstants.PEF_4003, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
                }
                else if (remarks.trim().length() > 75 || remarks.length() > 75)
                {
                	listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_14 , FvuConstants.PEF_4005, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
                }
                else if (remarks.trim().equals(""))
                {
                   listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_14 , FvuConstants.PEF_4002, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
                }
            }
            else if (remarksFlag && (contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_ARREAR)||contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_SWAVALAMBAN)))
            {
                if (remarks.equals(FvuConstants.FIELD_NULL) || remarks.equals(FvuConstants.FIELD_SEPERATOR))
                {
                    listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_14 , FvuConstants.PEF_4001, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
                }
                else if (CommonValidation.checkTabSpaces(remarks))
                {
                    listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_14 , FvuConstants.PEF_4003, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
                }
                else if (remarks.trim().length() > 75 || remarks.length() > 75)
                {
                    listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_14 , FvuConstants.PEF_4005, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
                }
                else if (remarks.trim().equals(""))
                {
                    listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_14 , FvuConstants.PEF_4002, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
                }
            }
            else if (objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_CORP)  && contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_ADHOC))
            {
                /*if (remarks.equals(FvuConstants.FIELD_NULL) || remarks.equals(FvuConstants.FIELD_SEPERATOR))
                {
                    listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_14 , FvuConstants.PEF_4001, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
                }
                else */
            	if (!(remarks.equals(FvuConstants.FIELD_NULL) || remarks.equals(FvuConstants.FIELD_SEPERATOR))){
	            	if (CommonValidation.checkTabSpaces(remarks))
	                {
	                    listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_14 , FvuConstants.PEF_4003, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
	                }
	                else if (remarks.trim().length() > 75 || remarks.length() > 75)
	                {
	                    listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_14 , FvuConstants.PEF_4005, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
	                }
            	}
                /*else if (remarks.trim().equals(""))
                {
                    listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_14 , FvuConstants.PEF_4002, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
                }*/
            }
            else if(objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_UOS) && (contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_UOS) || contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_TIER2) ))
            {
            	  /*if (remarks.equals(FvuConstants.FIELD_NULL) || remarks.equals(FvuConstants.FIELD_SEPERATOR))
                  {
                      listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_14 , FvuConstants.PEF_4001, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
                  }
            	  else */
            	if (!(remarks.equals(FvuConstants.FIELD_NULL) || remarks.equals(FvuConstants.FIELD_SEPERATOR))){
            		if (CommonValidation.checkTabSpaces(remarks))
	                  {
	                      listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_14 , FvuConstants.PEF_4003, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
	                  }
	                  /*else if (remarks.trim().equals(""))
	                  {
	                      listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_14 , FvuConstants.PEF_4002, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
	                  }*/
	                  else if (CommonValidation.isInt(remarks))
	          		  {
	          			  listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_14 , FvuConstants.PEF_4002, FvuConstants.RECTYPE_SDREC,ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "" , "-"));
	          		  }
	            	  else if (remarks.trim().length() != 17 || remarks.length() != 17)
	                  {
	                      listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_14 , FvuConstants.PEF_4023, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
	                  }
	            	  else if (Long.parseLong(remarks.trim()) == 0)
	          		  {
	          			  listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_14 , FvuConstants.PEF_4002, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
	          		  }
	          		  else if (!remarks.trim().equals("") && !remarks.substring(0,2).equals(FvuConstants.TYPE_OF_REQUEST))
	          		  {
	          			  listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_14 , FvuConstants.PEF_4002, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
	          		  }
	          		  else if(!objReadSD.invalidDdoCaretCount && !objReadSD.invalidTAN && !remarks.substring(2, 9).equals(objReadSD.ddoId))
	          		  {
	          			listErrorVO.add(new PAOContrErrorFileVO(objReadSD.PAO_SD_FIELD_14 , FvuConstants.PEF_4002, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
	          		  }
            	}
          		 
            }

            if (!objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_UOS) && contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_REGULAR) && !objReadSD.invalidDdoCaretCount && !objReadSD.invalidTAN)
            {
                String combineAll = objReadSD.ddoId + subscriberPRAN + " " + contributionType + " " + contributionmonth + " " + contributionYear;
                if (ddoIdPranContribMonthYearType.contains(combineAll))
                {
                	listErrorVO.add(new PAOContrErrorFileVO("-", FvuConstants.PEF_4014, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
                }
                else
                {
                	ddoIdPranContribMonthYearType.add(combineAll);
                }
            }
            //Added To TTS For 34025
            if(objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_UOS)  && ( contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_UOS_TTS) || contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_UOS) || contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_TIER2) || contributionType.equals(FvuConstants.CONTR_TYPE_VOLUNTARY)))
            {
            	String combineAckIdPranTiertype = remarks + subscriberPRAN + contributionType;
            	
            	if(ackIdPranTierType.contains(combineAckIdPranTiertype))
            	{
            		listErrorVO.add(new PAOContrErrorFileVO("-", FvuConstants.PEF_4024, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            	}
            	else
            	{
            		ackIdPranTierType.add(combineAckIdPranTiertype);
            	}
            }
            //Added For TTS of FTR-35479.START
            if((objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_UOS_TTS) || objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_PRAOV_TTS) || objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_AOV_TTS))  && (  contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_UOS_TTS)))
            {
            	String combinePranTiertypePFMID = subscriberPRAN + contributionType + contributionPFM;
            	if(!PranTiertypePFMID.contains(combinePranTiertypePFMID))
            	{
            		PranTiertypePFMID.add(combinePranTiertypePFMID);
            		if (countPRANForPFM.containsKey(subscriberPRAN))
        			{
        				if(countPRANForPFM.get(subscriberPRAN)>=3)
        				{
        					listErrorVO.add(new PAOContrErrorFileVO("-", FvuConstants.PEF_5014, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
        				}
        				else
        				{
        					countPRANForPFM.put(subscriberPRAN, countPRANForPFM.get(subscriberPRAN) + 1);
        				}
        			}
        			else {
        				countPRANForPFM.put(subscriberPRAN, 1);
        		    }
            		
            	}
            	
            }
          //Added For TTS of FTR-35479.START
//added for unfreezing accounts
            
//added for same PRAN and same contr type is not allowed
            //********code changes done for UM2 addition CR : 11579***********//
            if(objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_UOS) && (contributionType.equals(FvuConstants.CONTR_TYPE_TIER1_YRLY_UNFREEZE) || contributionType.equals(FvuConstants.CONTR_TYPE_TIER2_YRLY_UNFREEZE) || contributionType.equals(FvuConstants.CONTR_TYPE_MONTHLY1_UNFREEZE)|| contributionType.equals(FvuConstants.CONTR_TYPE_MONTHLY2_UNFREEZE)))
            {
            	String combinePranContrType = subscriberPRAN + contributionType;
            	if(pranContrType.contains(combinePranContrType))
            	{
            		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[11], FvuConstants.PEF_4028, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            	}
            	else
            	{
            		pranContrType.add(combinePranContrType);
            	}
            }
            //added for UT1/UT2 Direct/Indirect Corp
            if(objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_CORP) && (contributionType.equals(FvuConstants.CONTR_TYPE_TIER1_YRLY_UNFREEZE)|| contributionType.equals(FvuConstants.CONTR_TYPE_TIER2_YRLY_UNFREEZE)))
            {
            	String combinePranContrType = subscriberPRAN + contributionType;
            	if(pranContrType.contains(combinePranContrType))
            	{
            		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[11], FvuConstants.PEF_4028, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
            	}
            	else
            	{
            		pranContrType.add(combinePranContrType);
            	}
            }
//end
           
          
//added for different cotr types allowed together for same PRAN
            
            //************changes added for all the cases including U,T,UT1,UT2,UM1,UM2 for CR : 11579 for addition of UM2
            if(objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_UOS)){
		        if(contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_UOS))
		        {	
		        	if(pranListFreezeT1.containsKey(subscriberPRAN))
		        	{
		        		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[11], FvuConstants.PEF_4029, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
		        	}
		        	else if(pranListFreezeMon1.containsKey(subscriberPRAN))
		        	{
		        		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[11], FvuConstants.PEF_4030, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
		        	}
		        	else	
		        	{
		        		pranListT1.put(subscriberPRAN, FvuConstants.CONTRIBUTION_TYPE_UOS);
		        	}
		        }
		        else if(contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_TIER2))
		        {
		        	if(pranListFreezeT1.containsKey(subscriberPRAN))
		        	{
		        		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[11], FvuConstants.PEF_4031, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));     	    	
		        	}
		        	else if(pranListFreezeMon1.containsKey(subscriberPRAN))
		        	{
		        		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[11], FvuConstants.PEF_4032, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
		        	}
		        	else if(pranListFreezeMon2.containsKey(subscriberPRAN))
		        	{
		        		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[11], FvuConstants.PEF_4040, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
		        	}
		        	else if(pranListFreezeT2.containsKey(subscriberPRAN))
		        	{
		        		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[11], FvuConstants.PEF_4033, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
		        	}
		        	else	
		        	{
		        		pranListT2.put(subscriberPRAN, FvuConstants.CONTRIBUTION_TYPE_TIER2);
		        	}
		        }
		        else if(contributionType.equals(FvuConstants.CONTR_TYPE_TIER1_YRLY_UNFREEZE))
		        {
		        	if(pranListT1.containsKey(subscriberPRAN))
		        	{
		        		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[11], FvuConstants.PEF_4034, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));     	    	
		        	}
		        	else if(pranListT2.containsKey(subscriberPRAN))
		        	{
		        		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[11], FvuConstants.PEF_4035, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));     	    	
		        	}
		        	else if(pranListFreezeMon1.containsKey(subscriberPRAN))
		        	{
		        		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[11], FvuConstants.PEF_4036, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));     	    	
		        	}
		        	else if(pranListFreezeMon2.containsKey(subscriberPRAN))
		        	{
		        		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[11], FvuConstants.PEF_4041, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));     	    	
		        	}
		        	else	
		        	{
		        		pranListFreezeT1.put(subscriberPRAN, FvuConstants.CONTR_TYPE_TIER1_YRLY_UNFREEZE);
		        	}
		        }
		        else if(contributionType.equals(FvuConstants.CONTR_TYPE_TIER2_YRLY_UNFREEZE))
		        {
		        	if(pranListT2.containsKey(subscriberPRAN))
		        	{
		        		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[11], FvuConstants.PEF_4037, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));     	    	
		        	}
		        	else if(pranListFreezeMon1.containsKey(subscriberPRAN))
		        	{
		        		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[11], FvuConstants.PEF_4038, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));     	    	
		        	}
		        	else if(pranListFreezeMon2.containsKey(subscriberPRAN))
		        	{
		        		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[11], FvuConstants.PEF_4042, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));     	    	
		        	}
		        	else	
		        	{
		        		pranListFreezeT2.put(subscriberPRAN, FvuConstants.CONTR_TYPE_TIER2_YRLY_UNFREEZE);
		        	}
		        }
		        else if(contributionType.equals(FvuConstants.CONTR_TYPE_MONTHLY1_UNFREEZE))
		        {
		        	if(pranListT1.containsKey(subscriberPRAN))
		        	{
		        		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[11], FvuConstants.PEF_4044, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));     	    	
		        	}
		        	else if(pranListT2.containsKey(subscriberPRAN))
		        	{
		        		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[11], FvuConstants.PEF_4045, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));     	    	
		        	}
		        	else if(pranListFreezeT1.containsKey(subscriberPRAN))
		        	{
		        		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[11], FvuConstants.PEF_4046, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
		        	}
		        	else if(pranListFreezeT2.containsKey(subscriberPRAN))
		        	{
		        		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[11], FvuConstants.PEF_4047, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
		        	}
		        	else if(pranListFreezeMon2.containsKey(subscriberPRAN))
		        	{
		        		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[11], FvuConstants.PEF_4043, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
		        	}
		        	else	
		        	{
		        		pranListFreezeMon1.put(subscriberPRAN, FvuConstants.CONTR_TYPE_MONTHLY1_UNFREEZE);
		        	}
		        }
		        //*********added for UM2 case CR : 11579 ******//
		        else if(contributionType.equals(FvuConstants.CONTR_TYPE_MONTHLY2_UNFREEZE))
		        {
		        	if(pranListT2.containsKey(subscriberPRAN))
		        	{
		        		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[11], FvuConstants.PEF_4048, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));     	    	
		        	}
		        	else if(pranListFreezeT1.containsKey(subscriberPRAN))
		        	{
		        		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[11], FvuConstants.PEF_4049, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
		        	}
		        	else if(pranListFreezeT2.containsKey(subscriberPRAN))
		        	{
		        		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[11], FvuConstants.PEF_4050, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
		        	}
		        	else if(pranListFreezeMon1.containsKey(subscriberPRAN))
		        	{
		        		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[11], FvuConstants.PEF_4043, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
		        	}
		        	else	
		        	{
		        		pranListFreezeMon2.put(subscriberPRAN, FvuConstants.CONTR_TYPE_MONTHLY2_UNFREEZE);
		        	}
		        }
		        //********Added for Voluntary
		        else if(contributionType.equals(FvuConstants.CONTR_TYPE_VOLUNTARY)){
		        	if(pranListFreezeT1.containsKey(subscriberPRAN))
		        	{
		        		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[11], FvuConstants.PEF_4070, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));     	    	
		        	}
		        	else if(pranListFreezeT2.containsKey(subscriberPRAN))
		        	{
		        		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[11], FvuConstants.PEF_4071, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
		        	}
		        	else if(pranListFreezeMon1.containsKey(subscriberPRAN))
		        	{
		        		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[11], FvuConstants.PEF_4072, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
		        	}
		        	else if(pranListFreezeMon2.containsKey(subscriberPRAN))
		        	{
		        		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[11], FvuConstants.PEF_4073, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
		        	}
		        	else	
		        	{
		        		pranListVoluntary.put(subscriberPRAN, FvuConstants.CONTRIBUTION_TYPE_TIER2);
		        	}
		        }
        	}
            
//          Start - New Changes done for UT1/UT2 Dir/Indir Corp Pran
            //////////////Need to add new error codes
            if(objReadSD.uploadBy.equals(FvuConstants.UPLOADED_BY_CORP)){
            	if(contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_REGULAR))
	            {	
	            	if(pranListFreezeT1.containsKey(subscriberPRAN))
	            	{
	            		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[11], FvuConstants.PEF_4061, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
	            	}
	            	else	
	            	{
	            		pranListReg.put(subscriberPRAN, FvuConstants.CONTRIBUTION_TYPE_REGULAR);
	            	}
	            }
	            else if(contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_ARREAR))
	            {
	            	if(pranListFreezeT1.containsKey(subscriberPRAN))
	            	{
	            		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[11], FvuConstants.PEF_4062, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));     	    	
	            	}
	            	/*else if(pranListFreezeT2.containsKey(subscriberPRAN))
	            	{
	            		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[11], FvuConstants.PEF_4063, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
	            	}*/
	            	else	
	            	{
	            		pranListArr.put(subscriberPRAN, FvuConstants.CONTRIBUTION_TYPE_ARREAR);
	            	}
	            }
	            else if(contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_ADHOC))
	            {
	            	if(pranListFreezeT1.containsKey(subscriberPRAN))
	            	{
	            		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[11], FvuConstants.PEF_4064, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));     	    	
	            	}
	            	/*else if(pranListFreezeT2.containsKey(subscriberPRAN))
	            	{
	            		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[11], FvuConstants.PEF_4065, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
	            	}*/
	            	else	
	            	{
	            		pranListAdhoc.put(subscriberPRAN, FvuConstants.CONTRIBUTION_TYPE_ADHOC);
	            	}
	            }
	            else if(contributionType.equals(FvuConstants.CONTR_TYPE_TIER1_YRLY_UNFREEZE))
	            {
	            	if(pranListReg.containsKey(subscriberPRAN))
	            	{
	            		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[11], FvuConstants.PEF_4066, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));     	    	
	            	}
	            	else if(pranListArr.containsKey(subscriberPRAN))
	            	{
	            		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[11], FvuConstants.PEF_4067, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));     	    	
	            	}
	            	else if(pranListAdhoc.containsKey(subscriberPRAN))
	            	{
	            		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[11], FvuConstants.PEF_4068, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));     	    	
	            	}
	            	else	
	            	{
	            		pranListFreezeT1.put(subscriberPRAN, FvuConstants.CONTR_TYPE_TIER1_YRLY_UNFREEZE);
	            	}
	            }
	            else if(contributionType.equals(FvuConstants.CONTR_TYPE_TIER2_YRLY_UNFREEZE))
	            {
	            	/*if(pranListReg.containsKey(subscriberPRAN))
	            	{
	            		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[11], FvuConstants.PEF_4069, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));     	    	
	            	}
	            	else if(pranListArr.containsKey(subscriberPRAN))
	            	{
	            		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[11], FvuConstants.PEF_4070, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));     	    	
	            	}
	            	else if(pranListAdhoc.containsKey(subscriberPRAN))
	            	{
	            		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[11], FvuConstants.PEF_4071, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));     	    	
	            	}
	            	else	
	            	{
	            		pranListFreezeT2.put(subscriberPRAN, FvuConstants.CONTR_TYPE_TIER2_YRLY_UNFREEZE);
	            	}*/
	            	pranListFreezeT2.put(subscriberPRAN, FvuConstants.CONTR_TYPE_TIER2_YRLY_UNFREEZE);
	            }
            }
            //end
//end of account unfreeze
            
            //CR-59184 -Start
            //For Basic Salary Validation
           
	            if (objReadSD.basicSalary.equals(FvuConstants.FIELD_NULL) || objReadSD.basicSalary.equals(FvuConstants.FIELD_SEPERATOR))
	            {
	                objReadSD.inValidBasicSalary = true;
	                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[7], FvuConstants.PEF_4001, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
	            }
	            else if (new BigDecimal(objReadSD.basicSalary).compareTo(new BigDecimal(0.00))==0)
	            {
	            	listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[7], FvuConstants.PEF_2031, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
	            }
	            else if (objReadSD.basicSalary.trim().length() > 21 || objReadSD.basicSalary.length() > 21)
	            {
	                objReadSD.inValidBasicSalary = true;
	                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[7], FvuConstants.PEF_4005, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
	            }
	            else if (CommonValidation.checkTabSpaces(objReadSD.basicSalary))
	            {
	                objReadSD.inValidBasicSalary = true;
	                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[7], FvuConstants.PEF_4003, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
	            }
	            else if (CommonValidation.isDecimalNumber(objReadSD.basicSalary))
	            {
	                objReadSD.inValidBasicSalary = true;
	                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[7], FvuConstants.PEF_4002, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
	            }
	            else if (objReadSD.basicSalary.trim().length() != objReadSD.basicSalary.length())
	            {
	            	objReadSD.inValidBasicSalary = true;
	            	listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[7], FvuConstants.PEF_4003,  FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
	            }
	            
	            //For Dearness Allowance
	            if (objReadSD.dearnessAllow.equals(FvuConstants.FIELD_NULL) || objReadSD.dearnessAllow.equals(FvuConstants.FIELD_SEPERATOR))
	            {
	                objReadSD.inValidDearnessAllowance = true;
	                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[8], FvuConstants.PEF_4001, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
	            }
	            else if (objReadSD.dearnessAllow.trim().length() > 21 || objReadSD.dearnessAllow.length() > 21)
	            {
	                objReadSD.inValidDearnessAllowance = true;
	                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[8], FvuConstants.PEF_4005, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
	            }
	            else if (CommonValidation.checkTabSpaces(objReadSD.dearnessAllow))
	            {
	                objReadSD.inValidDearnessAllowance = true;
	                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[8], FvuConstants.PEF_4003, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
	            }
	            else if (CommonValidation.isDecimalNumber(objReadSD.dearnessAllow))
	            {
	                objReadSD.inValidDearnessAllowance = true;
	                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[8], FvuConstants.PEF_4002, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
	            }
	            else if (objReadSD.dearnessAllow.trim().length() != objReadSD.dearnessAllow.length())
	            {
	            	objReadSD.inValidDearnessAllowance = true;
	            	listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[8], FvuConstants.PEF_4003,  FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
	            }
	            
	            /**
	             * Validation of SALARY DISBURSEMENT DATE(Field No.6 Of File Header Record)
	             */
	        	
	        		if(objReadSD.salaryDate == FvuConstants.FIELD_NULL || objReadSD.salaryDate.equals(FvuConstants.FIELD_SEPERATOR))
	        		{
	        			  objReadSD.inValidSalaryDate = true;
	        			  listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[9], FvuConstants.PEF_4001, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
	        		}
	        		
	        		else if (CommonValidation.checkTabSpaces(objReadSD.salaryDate))
		            {
		            	objReadSD.inValidSalaryDate = true;
		                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[9], FvuConstants.PEF_2002,  FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
		            }
	        		
		            if (objReadSD.salaryDate.trim().length() != 8 || objReadSD.salaryDate.length() != 8)
		            {
		            	objReadSD.inValidSalaryDate = true;
		                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[9], FvuConstants.PEF_2019,  FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
		            }
		            
		            else if (CommonValidation.isInt(objReadSD.salaryDate))
		            {
		            	objReadSD.inValidSalaryDate = true;
		                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[9], FvuConstants.PEF_2003,  FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
		            }
		            else if (CommonValidation.isDate(objReadSD.salaryDate))
		            {
		            	objReadSD.inValidSalaryDate = true;
		            	listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[9], FvuConstants.PEF_2003,  FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
		            }
		            // End of SALARY DISBURSEMENT DATE Validation
		            
		            if(contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_REGULAR))
		            {   
			            BigDecimal basicAmtUps = new BigDecimal(objReadSD.basicSalary);
			            BigDecimal dearnessAllowanceAmtUps = new BigDecimal(objReadSD.dearnessAllow);
			        	BigDecimal totalAmt=new BigDecimal("0.00");
						 //double amt3=0.0;
						 BigDecimal amtPercentage=new BigDecimal("0.1"); //10% of basic/DA
						 			        						
						 totalAmt = (basicAmtUps.add(dearnessAllowanceAmtUps)).multiply(amtPercentage);
						 totalAmt = totalAmt.setScale(2, RoundingMode.HALF_UP);
			            //totalAmt.setScale(2, RoundingMode.FLOOR);
						 Double selfContUPS =  Double.parseDouble(objReadSD.tierOneSelfContribution.trim());
						 Double govtContUPS  = Double.parseDouble(objReadSD.tierOneGovtContribution.trim());
						 
						 Double totalAmtUPS = Double.parseDouble(totalAmt.toString());
						 
						/* Integer totalAmtUPSInt=totalAmtUPS.intValue(); 
						 Integer selfContUPSInt = selfContUPS.intValue();
						 Integer govtContUPSInt  = govtContUPS.intValue();
			           
						 //Comparing if amounts in both columns are equal  with only difference +-1
						 int differenceSelfUps = Math.abs(totalAmtUPSInt - selfContUPSInt);
						 
						 int differenceGovtUps = Math.abs(totalAmtUPSInt - govtContUPSInt);
	
						 if(differenceSelfUps > 1 || differenceSelfUps < 0)
						 {
							 // Both Contributions should be equal with difference +/- Re.1
							 listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[21], FvuConstants.PEF_5016,  FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
						 }
						 
						 if(differenceGovtUps > 1 || differenceGovtUps < 0 ){
							// Both Contributions should be equal with difference +/- Re.1
							 listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[20], FvuConstants.PEF_5016, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
						 }*/
						Double Difference = Math.abs(totalAmtUPS-selfContUPS);
						if(Difference >= 0 && Difference <=1){
							if(!selfContUPS.equals(govtContUPS)){
								listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[20], FvuConstants.PEF_5016, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
							}
							
						}else{
							listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[20], FvuConstants.PEF_5016, FvuConstants.RECTYPE_SDREC, ddoSerialNumberInSD, sdSerialNo,subscriberPRAN, objReadSD.lineNo + "", "-"));
						}
		            }
				//Modified for CR-58405 - Ends
        	
    }// End of sdFieldValidator method
    //Added For Revamp CR  ... 
        
        objReadSD.setComboList(combo);
        objReadSD.setPransList(pranList1);
    	objReadSD.setTotalContrAmtReg(totalContrAmtRegAmt);
    	objReadSD.setTotalContrAmtArr(totalContrAmtArrAmt);
    	objReadSD.setTotalContrAmtMisc(totalContrAmtMiscAmt);
    	objReadSD.setTotalContrAmtT1(totalContrAmtT1Amt);
    	objReadSD.setTotalContrAmtT2(totalContrAmtT2Amt);
    	objReadSD.setTotalContrAmtUM1(totalContrAmtUM1Amt);
    	objReadSD.setTotalContrAmtUM2(totalContrAmtUM2Amt);
    	objReadSD.setTotalContrAmtUT1(totalContrAmtUT1Amt);
    	objReadSD.setTotalContrAmtUT2(totalContrAmtUT2Amt);
    	objReadSD.setTotalContrAmtVPF(totalContrAmtVPFAmt);
    	objReadSD.setTotalContrAmtTTS(totalContrAmtTTSAmt);//Added For TTS
    	
    	objReadSD.setDuplicateCount(duplicateCount);
	    objReadSD.setWarnings(warnings);
	    	
    	//starts CR-16365 
    	//objReadSD.setUniquePranCount(dupMapSet.size());
    	objReadSD.setRecord_C(recordCountC);
    	objReadSD.setRecord_A(recordCountA);
    	objReadSD.setRecord_0(recordCount0);
    	objReadSD.setRecord_T1(recordCountT1);
    	objReadSD.setRecord_T2(recordCountT2);
    	objReadSD.setRecord_UT1(recordCountUT1);
    	objReadSD.setRecord_UT2(recordCountUT2);
    	objReadSD.setRecord_M1(recordCountUM1);
    	objReadSD.setRecord_M2(recordCountUM2);
    	objReadSD.setRecord_VPF(recordCountVPF);
    	objReadSD.setRecord_TTS(recordCountTTS);//Added For TTS
    	//ends
	    
    }    
} 

