
/** 
 *  Class: SubContrFileFormatValidator.java      
 */
package com.cra.pao.fvu;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

import com.cra.contr.common.util.CommonValidation;
import com.cra.contr.common.util.file.CRAFileReader;
import com.cra.pao.vo.PAOContrErrorFileVO;
import com.cra.pao.vo.PAOSubDetailVO;

import cra.standalone.paosubcontr.PAOFvu;

/**
 * This class contains methods that will invoke the validation of File Header,Batch Header, DDOHeader and Subscriber
 * Detail Records. The file is read line by line and based on the record types in each of the lines, the corresponding
 * record validation method is called.
 * 
 * @author TCS
 */

public class SubContrFileFormatValidator
{
    private int lineCnt = 0; // Same as "lineCount"
    private int lineCount = 0; // Logical counter incremented when each record is parsed to readFile() method.
    private BigDecimal govtContributionInBatch = null;
    private BigDecimal selfContributionInBatch = null;
    public String contributionType = null; 
    
    public String lineNo = null; // Line Number
    public String recType = null; // Record Type
    public String uploaderId = null; // Uploader ID
    public String typeOfUploadedFile = null; // Type of uploaded file
    public String totalCountOfDDO = null; // Count Of Total number of DDOs
    public String uploadBy = null;// Uploader Type
    public String batchNo = null; // Batch number
    public String totalCountOfSD = null; // Total Count of Subscriber Detail Records
    public String ddoSerialNo = null; // Serial Number of each DDO Header Record
    public String totalCountOfSubscribers = null; // Total Count of Subscribers in a File
    public String batchTotalGovtContrbutionOfDDO = null; // Total Govt Contribution Amount in Batch Header
    public String batchTotalSelfContrbutionOfDDO = null; // Total Self Contribution Amount in Batch Header
    public String totalGovtContributionInDDO = null; // Sum of all Government Contribution Amount in DDO Header Record
    public String totalSelfContributionInDDO = null; // Sum of all Self Contribution Amount in DDO Header Record
    public String tierOneGovtContribution = null; // Individual Mandatory Government Subscriber Contribution
    public String tierOneSelfContribution = null; // Individual Mandatory Self Subscriber Contribution
    public String totalOfTierOneTierTwo = null; // Total of Govt. and Self Contribution
    public BigDecimal govtContributionInDDO = null; // Total Govt Contribution in DDO
    public BigDecimal selfContributionInDDO = null; // Total Self Contribution in DDO
    public BigDecimal subscriberGovtContribution = null; // Subscriber Government Contribution Amount
    public BigDecimal subscriberSelfContribution = null; // Subscriber Self Contribution Amount
    public BigDecimal totalTierOneGovtAmt = new BigDecimal(0.0); // Sum of Govt Contribution in DDO
    public BigDecimal totalTierOneSelfAmt = new BigDecimal(0.0); // Sum of Self Contribution in DDO
    //public BigDecimal totalTierTwoSelfAmt =  new BigDecimal(0.0); //To display Tier-2 Contr Amt as seperate in O/P file
    public int totalNoOfSDRead = 0; // Initialize counter for Total Number of SD Records Read
    public int totalNoOfDDORead = 0; // Initialize counter for Total Number of DDO Records Read
    public String ddoId = null; // DDO ID(TAN)
    
    public String sectorCategory ="";
    public String RECTYPE_DDOREC =null;
    public String PAO_FH_FIELD_4 = null;
    public String PAO_BH_FIELD_5 = null;
    public String PAO_BH_FIELD_9 = null;
    public String PAO_BH_FIELD_11 = null;
    public String PAO_BH_FIELD_12 = null;
    public String  PAO_DDO_FIELD_4 = null;
    public String  PAO_DDO_FIELD_5 = null;
    public String  PAO_DDO_FIELD_7 = null;
    public String  PAO_DDO_FIELD_8 = null;
    public String  PAO_DDO_FIELD_10 = null;
    public String  PAO_SD_FIELD_4 = null;
    public String  PAO_SD_FIELD_7 = null;
    public String  PAO_SD_FIELD_8 = null;
    public String  PAO_SD_FIELD_12 = null;
    public String  PAO_SD_FIELD_13 = null;
    public String  PAO_SD_FIELD_14 = null;
    
    public boolean invalidTotalContributionInBatch = false; 
    public boolean inValidFhCaretCount = false;
    public boolean inValidBhCaretCount = false;
    public boolean invalidRecord = false;
    public boolean invalidDdoCaretCount = false;
    public boolean invalidSdCaretCount = false;
    public boolean inValidContributionAmt = false;
    public boolean invalidTotalContributionInDDO = false;
    public boolean invalidAIN = false;
    public boolean invalidTAN = false;
    public boolean invalidSubCount = false;
    public boolean invalidDDOCount = false;
    public boolean inValidfirstDDOSerialNo = false;
    public boolean invalidCaretPos = false;
    public StringBuffer controlSheetBuffer = new StringBuffer();
    PAOSubDetailVO objPaoSubDetailBean = new PAOSubDetailVO();
    //Added for Revamp CR
    public ArrayList<PAOSubDetailVO> pranListArr = new ArrayList<PAOSubDetailVO>();
    public HashMap<String,String> pranList = new HashMap<String,String>();
    private BigDecimal totalContrAmtReg= new BigDecimal(0.00);
    private BigDecimal totalContrAmtArr= new BigDecimal(0.00);
    private BigDecimal totalContrAmtMisc= new BigDecimal(0.00);
    private BigDecimal totalContrAmtT1= new BigDecimal(0.00);
    private BigDecimal totalContrAmtT2= new BigDecimal(0.00);
    private BigDecimal totalContrAmtUM1= new BigDecimal(0.00);
    private BigDecimal totalContrAmtUM2= new BigDecimal(0.00);
    private BigDecimal totalContrAmtUT1= new BigDecimal(0.00);
    private BigDecimal totalContrAmtUT2= new BigDecimal(0.00);
    private BigDecimal totalContrAmtVPF= new BigDecimal(0.00);
    private BigDecimal totalContrAmtVPFUPS= new BigDecimal(0.00);
    //Added For TTS .Start
    private BigDecimal totalContrAmtTTS= new BigDecimal(0.00);
    public BigDecimal getTotalContrAmtTTS() {
		return totalContrAmtTTS;
	}

	public void setTotalContrAmtTTS(BigDecimal totalContrAmtTTS) {
		this.totalContrAmtTTS = totalContrAmtTTS;
	}

	public int getRecord_TTS() {
		return record_TTS;
	}

	public void setRecord_TTS(int record_TTS) {
		this.record_TTS = record_TTS;
	}
	//Added For TTS .End
	public ArrayList<String> warnings = new ArrayList<String>();
    public ArrayList<String> comboList = new ArrayList<String>();
    public ArrayList<String> pransList = new ArrayList<String>();
    private int DuplicateCount = 0;
    int record_C=0;
    int record_0=0;
    int record_T1=0;
    int record_T2=0;
    int record_UT1=0;
    int record_UT2=0;
    int record_M1=0;
    int record_M2=0;
    int record_VPF=0;
    int record_VPFUPS=0;
    int record_TTS=0;//Added For TTS .Start
    //Added for CR 23214
    public String fileFlag = null;
    public String sdDate = null;
    public String fileMonth = null;
    public String fileYear = null;

	int uniquePranCount=0;
   
   /**
     * readFile method is used to read each and every line(record) of the file. This method is called from PAOPEFu class
     * which contains the main() method.
     * 
     * @param inputFileName -> Name of the input file
     * @param errorFileName -> Name of the error file generated
     * @param utilityLevel -> Utility level indicator 0 implies standalone FVU
     * @return void
     * 
     */
    public void readFile(String inputFileName, ArrayList<PAOContrErrorFileVO> listErrorVO, int utilityLevel)
    {
    	System.out.println("Start readFile");
        FileHeaderValidation objFHVal = new FileHeaderValidation();
        BatchValidation objBHVal = new BatchValidation();
        DDORecordValidation objDDOVal = new DDORecordValidation();
        SubContrRecordValidator objSDVal = new SubContrRecordValidator();
        
        boolean ddoRecordFound = false;
        boolean sdRecordFound = false;
        int totalSubscriberCount = 0;
        int sdCount = 0; // Count of SD records after validation
        try
        {
            CRAFileReader objCraFileReader = new CRAFileReader(inputFileName);
            ArrayList<String> fileData = objCraFileReader.getAllLinesInArrayList();
            //ArrayList<String[]> parsedValues = new ArrayList<String[]>(); // commented for Optimization by Binal Shah on 15 May 09
            String values = null;
            String[] data = null;
            boolean carretBol = false;
            String token = null;
            
            
            outerForLoop : for (int i = 0; i < fileData.size(); i++)
            {
                values = (String) fileData.get(i);
                lineCount++;
                
               // commented for Optimization by Binal Shah on 15 May 09
               
                /* parsedValues.add(CRAFileReader.getLineParsed(values, "\\^")); 
            
                for (int j = 0; j < parsedValues.size(); j++)
                {
                    data = parsedValues.get(i);
                    //System.out.println("parsedValues.get(i) ::::::"+parsedValues.get(i));
                }*/
               
                if(fileData.size() < 4)
                {
                	invalidRecord = true;
                    listErrorVO.add(new PAOContrErrorFileVO("-", FvuConstants.PEF_5006, "-", "-", "-","-","-" + "", "-"));
                    break;
                }
                else if (values.trim().length() == 0 )// Check for blank lines in the file
                {
                    invalidRecord = true;
                    listErrorVO.add(new PAOContrErrorFileVO("-", FvuConstants.PEF_5004, "-", "-", "-","-", "-" + "", "-"));
                    break;
                }
                else
                {
                    int localFieldCount = 1;
                    int recordCaretCount = 0;
                    StringTokenizer objTokenizer = new StringTokenizer(values, FvuConstants.FIELD_SEPERATOR, true);
                    while (objTokenizer.hasMoreTokens())
                    {
                        token = objTokenizer.nextToken();
                        if (token.equals(FvuConstants.FIELD_SEPERATOR))
                        {
                            if(localFieldCount == 1 )
                            {
                            	invalidCaretPos=true;
                            }
                            carretBol = true;
                            recordCaretCount++;
                        }
                        else
                        {
                            switch (localFieldCount)
                            {
                                case 1:
                                    lineNo = token;
                                    break;
                                case 2:
                                    recType = token;
                                    break;
                            }
                            localFieldCount++;
                        }
                    }
                    if(CommonValidation.isInt(lineNo))
                    {
                        invalidRecord = true;
                        listErrorVO.add(new PAOContrErrorFileVO("-", FvuConstants.PEF_5006, "-", "-", "-","-", "-" + "", "-"));
                        break outerForLoop;
                    }
                    if (invalidRecord == false && lineCount == 1 && recordCaretCount != 11)
                    {
                        inValidFhCaretCount = true;
                        listErrorVO.add(new PAOContrErrorFileVO("-", FvuConstants.PEF_1000, FvuConstants.RECTYPE_FHREC, "-", "-", "-",lineCount + "", "-"));
                        controlSheetBuffer.append("-" + FvuConstants.FIELD_SEPERATOR +"-" + FvuConstants.FIELD_SEPERATOR+"-"+FvuConstants.FIELD_SEPERATOR+"-"+FvuConstants.FIELD_SEPERATOR+"-"+FvuConstants.FIELD_SEPERATOR);
                    }
                    else if (invalidRecord == false && lineCount == 2 && recordCaretCount != 14)
                    {
                        inValidBhCaretCount = true;
                        listErrorVO.add(new PAOContrErrorFileVO("-", FvuConstants.PEF_2000, FvuConstants.RECTYPE_BHREC, "-", "-","-", lineCount + "", "-"));
                    }
                }
                if (lineCount == 1)
                {
                    // Call FILE HEADER Validation Method
                	
                	data =CRAFileReader.getLineParsed(values, "\\^");
                	objFHVal.fhFieldValidator(this, lineCount, data, listErrorVO , utilityLevel);
                	//Modified for CR-58405
                	if(uploadBy.equals(FvuConstants.UPLOADED_BY_AO) || uploadBy.equals(FvuConstants.UPLOADED_BY_PRAO) || uploadBy.equals(FvuConstants.UPLOADED_BY_KA) || uploadBy.equals(FvuConstants.UPLOADED_BY_AO_UPS) || uploadBy.equals(FvuConstants.UPLOADED_BY_PRAO_UPS) ){
                		//Commented and added for requirement change of CR 23214
                		/*sdDate = data[5];
                    	fileFlag = data[6];
                    	fileMonth = data[7];
                    	fileYear = data[8];*/
                		fileFlag = "A";
                	}
                    //objFHVal.fhFieldValidator(this, lineCount, data, listErrorVO);
                }
                else if (inValidFhCaretCount == false && lineCount != 1 && recType.equals(FvuConstants.FH_REC))
                {
                    invalidRecord = true;
                    listErrorVO.add(new PAOContrErrorFileVO("-", FvuConstants.PEF_5001, "-", "-", "-","-", lineCount + "", "-"));
                    break;
                }//Added TTS to CR-34025 and TTS CG\SG
                //Modified for CR-58405
                else if(uploadBy==null ||(!uploadBy.equals(FvuConstants.UPLOADED_BY_UOS)&&!uploadBy.equals(FvuConstants.UPLOADED_BY_UOS_TTS) && !uploadBy.equals(FvuConstants.UPLOADED_BY_AO) && !uploadBy.equals(FvuConstants.UPLOADED_BY_PRAO) && !uploadBy.equals(FvuConstants.UPLOADED_BY_KA) && !uploadBy.equals(FvuConstants.UPLOADED_BY_CORP)
                		&& !uploadBy.equals(FvuConstants.UPLOADED_BY_AOV) && !uploadBy.equals(FvuConstants.UPLOADED_BY_PRAOV)&& !uploadBy.equals(FvuConstants.UPLOADED_BY_AOV_TTS) && !uploadBy.equals(FvuConstants.UPLOADED_BY_PRAOV_TTS) && !uploadBy.equals(FvuConstants.UPLOADED_BY_AO_UPS) && !uploadBy.equals(FvuConstants.UPLOADED_BY_PRAO_UPS)))
                {
                	invalidRecord = true;
                	listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD[3], FvuConstants.PEF_1007, FvuConstants.RECTYPE_FHREC, "-", "-","-","1", "-"));
                	break;
                }
                else if (lineCount == 2)
                {
                    // Call BATCH HEADER Validation Method
                	//System.out.println("BH");
                	data =CRAFileReader.getLineParsed(values, "\\^");
                    objBHVal.bhFieldValidator(this, lineCount, data, listErrorVO , utilityLevel);
                }
                else if (inValidBhCaretCount == false && lineCount != 2 && recType.equals(FvuConstants.BH_REC))
                {
                    invalidRecord = true;
                    listErrorVO.add(new PAOContrErrorFileVO("-", FvuConstants.PEF_5002, "-", "-", "-","-", lineCount + "", "-"));
                    break;
                }
                else
                {
                    if (lineNo == FvuConstants.FIELD_NULL)
                    {
                        invalidRecord = true;
                        listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[1], FvuConstants.PEF_3001, "-", "-", "-","-", "-" + "", "-"));
                        break;
                    }
                    else if (CommonValidation.isInt(lineNo))
                    {
                        invalidRecord = true;
                        listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[1], FvuConstants.PEF_3002, "-", "-", "-","-", "-" + "", "-"));
                        break;
                    }
                    else if(invalidCaretPos)
                    {
						invalidRecord=true;
						listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[1], FvuConstants.PEF_3002, "-", "-", "-","-", "-" + "", "-"));
	                    break;
					}
                    else if (recType == FvuConstants.FIELD_NULL)
                    {
                        invalidRecord = true;
                        listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[2], FvuConstants.PEF_5003, "-", "-", "-","-", lineCount + "", "-"));
                        break;
                    }
                    else if ((lineCount - 1) == 2 && !recType.equals(FvuConstants.DDO_REC))
                    {
                        invalidRecord = true;
                        listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[2],Integer.parseInt(sectorCategory + FvuConstants.PEF_5005), "-", "-", "-","-", lineCount + "", "-"));
                        break;
                    }
                    else if (!recType.equals(FvuConstants.DDO_REC) && !recType.equals(FvuConstants.SD_REC))
                    {
                        invalidRecord = true;
                        listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[2], FvuConstants.PEF_5003, "-", "-", "-","-", lineCount + "", "-"));
                        break;
                    }
                    else if (recType.equals(FvuConstants.DDO_REC))
                    {
                        // Call DDO HEADER RECORD Validation Method
                    	//System.out.println("DH");
                        lineCnt = lineCount;
                        if (inValidContributionAmt == false && ddoRecordFound == false && sdRecordFound == true && invalidTotalContributionInDDO == false && invalidSubCount == false)
                        {
                            if (invalidDdoCaretCount == false)
                            {
                                //System.out.println("dh loop");
                               
                                	govtContributionInDDO = new BigDecimal(this.getDdoTierOneGovtContribution());
                                	selfContributionInDDO = new BigDecimal(this.getDdoTierOneSelfContribution());
                                	totalSubscriberCount = Integer.parseInt(this.getTotalSubscriberCount());
                                	//System.out.println("govtContributionInDDO :" +govtContributionInDDO);
                                //System.out.println("selfContributionInDDO :" +selfContributionInDDO);
                               // System.out.println("totalSubscriberCount :" +totalSubscriberCount);
                               // System.out.println("totalNoOfSDRead :"+ totalNoOfSDRead);
                               // System.out.println("subscriberGovtContribution :"+subscriberGovtContribution);
                                //System.out.println("subscriberSelfContribution :"+subscriberSelfContribution);
                                lineCnt = lineCount - totalNoOfSDRead - 1;
                                if (totalNoOfSDRead > totalSubscriberCount)
                                {
                                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[6], Integer.parseInt(sectorCategory + FvuConstants.PEF_3014), RECTYPE_DDOREC, "-", "-","-", lineCnt + "", "-"));
                                }
                                else if (totalNoOfSDRead < totalSubscriberCount)
                                {
                                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[6], Integer.parseInt(sectorCategory + FvuConstants.PEF_3013), RECTYPE_DDOREC, "-", "-", "-",lineCnt + "", "-"));
                                }
                                else
                                {
                                    if (!govtContributionInDDO.equals(subscriberGovtContribution))
                                    {
                                        listErrorVO.add(new PAOContrErrorFileVO(PAO_DDO_FIELD_7, Integer.parseInt(sectorCategory + FvuConstants.PEF_3015), RECTYPE_DDOREC, "-", "-", "-",lineCnt + "", "-"));
                                    }
                                    if (!selfContributionInDDO.equals(subscriberSelfContribution))
                                    {
                                        listErrorVO.add(new PAOContrErrorFileVO(PAO_DDO_FIELD_8, Integer.parseInt(sectorCategory + FvuConstants.PEF_3016), RECTYPE_DDOREC, "-", "-","-", lineCnt + "", "-"));
                                    }
                                }
                            }
                        }
                        ddoRecordFound = true;
                        sdRecordFound = false;
                        totalNoOfDDORead++;
                        objDDOVal.ddoFieldValidator(this, lineCount, values, listErrorVO , utilityLevel);
                        totalNoOfSDRead = 0;
                        govtContributionInDDO = new BigDecimal("0.0");
                        selfContributionInDDO = new BigDecimal("0.0");
                        subscriberGovtContribution = new BigDecimal("0.0");
                        subscriberSelfContribution = new BigDecimal("0.0");
                    }
                    else if ((lineCnt == lineCount - 1) && !recType.equals(FvuConstants.SD_REC))
                    {
                        listErrorVO.add(new PAOContrErrorFileVO("-", FvuConstants.PEF_5003, "-", "-", "-","-", lineCount + "", "-"));
                        break;
                    }
                    else if (recType.equals(FvuConstants.SD_REC))
                    {
                    	//System.out.println("SD");
                        totalNoOfSDRead++;
                        sdRecordFound = true;
                        ddoRecordFound = false;
                        // Call SUBSCRIBER DETAIL Validation Method
                        objSDVal.sdFieldValidator(this, lineCount, values, listErrorVO, objPaoSubDetailBean , utilityLevel);
                        if (invalidSdCaretCount == false && inValidContributionAmt == false)
                        {
                        	subscriberGovtContribution = subscriberGovtContribution.add(new BigDecimal(objPaoSubDetailBean.getTierOneGovtContribution()));
                            subscriberSelfContribution = subscriberSelfContribution.add(new BigDecimal(objPaoSubDetailBean.getTierOneSelfContribution()));
                            sdCount++;
//                          To display Tier-2 Contr Amt as seperate in O/P file
                           /* if(contributionType != null && contributionType.equals(FvuConstants.CONTRIBUTION_TYPE_TIER2))
                            {
                            	totalTierTwoSelfAmt = totalTierTwoSelfAmt.add(new BigDecimal(objPaoSubDetailBean.getTierOneSelfContribution()));
                            }*/
                        }
                    }
                }
            }
            //Added for Performance tuning against FTR 17310
            Set<String> set2 = new HashSet<String>();
            for(String yourInt : this.getComboList()){
            	if(!set2.add(yourInt)){
            		//dup.add(yourInt);
            		String abc1 = yourInt.substring(0,12);
            		warnings.add(abc1);
                }
            }
            
            //Added for Revamp CR
            controlSheetBuffer.append(this.getTotalContrAmtReg() + FvuConstants.FIELD_SEPERATOR);
            System.out.println("getTotalContrAmtReg ::::"+ this.getTotalContrAmtReg());
            controlSheetBuffer.append(this.getTotalContrAmtArr() + FvuConstants.FIELD_SEPERATOR);
            System.out.println("getTotalContrAmtArr ::::"+ this.getTotalContrAmtArr());
            controlSheetBuffer.append(this.getTotalContrAmtMisc() + FvuConstants.FIELD_SEPERATOR);
            System.out.println("getTotalContrAmtMisc ::::"+ this.getTotalContrAmtMisc());
            controlSheetBuffer.append(this.getTotalContrAmtT1() + FvuConstants.FIELD_SEPERATOR);
            System.out.println("getTotalContrAmtT1 ::::"+ this.getTotalContrAmtT1());
            controlSheetBuffer.append(this.getTotalContrAmtT2() + FvuConstants.FIELD_SEPERATOR);
            System.out.println("getTotalContrAmtT2 ::::" + this.getTotalContrAmtT2());
            controlSheetBuffer.append(this.getTotalContrAmtUM1() + FvuConstants.FIELD_SEPERATOR);
            System.out.println("getTotalContrAmtUM1 ::::" + this.getTotalContrAmtUM1());
            controlSheetBuffer.append(this.getTotalContrAmtUM2() + FvuConstants.FIELD_SEPERATOR);
            System.out.println("getTotalContrAmtUM2 ::::" + this.getTotalContrAmtUM2());
            controlSheetBuffer.append(this.getTotalContrAmtUT1() + FvuConstants.FIELD_SEPERATOR);
            System.out.println("getTotalContrAmtUT1 ::::" + this.getTotalContrAmtUT1());
            controlSheetBuffer.append(this.getTotalContrAmtUT2() + FvuConstants.FIELD_SEPERATOR);
            System.out.println("getTotalContrAmtUT2 ::::" + this.getTotalContrAmtUT2());
            //if(PAOFvu.uosvpfFlag.equalsIgnoreCase("Y")){
	            controlSheetBuffer.append(this.getTotalContrAmtVPF() + FvuConstants.FIELD_SEPERATOR);
	            System.out.println("getTotalContrAmtVPF ::::" + this.getTotalContrAmtVPF());
	        //start CR 60237
	            controlSheetBuffer.append(this.getTotalContrAmtVPFUPS() + FvuConstants.FIELD_SEPERATOR);
	            System.out.println("getTotalContrAmtVPFUPS ::::" + this.getTotalContrAmtVPFUPS());
	        //end CR 60237
	            
            //}
            String dupPrans = null;
            if(!warnings.isEmpty()){
            	dupPrans = warnings.get(0);
            	for(int i=1;i<warnings.size();i++){
            		dupPrans = dupPrans +" "+ warnings.get(i) + " ";
            	}
            }
            if(dupPrans != null)
            	if(dupPrans.length() > 12){
            		controlSheetBuffer.append("PRANs " + dupPrans + " have appeared more than once with same Contribution type in the file"+FvuConstants.FIELD_SEPERATOR);
            	}else{
            		controlSheetBuffer.append("PRAN " + dupPrans + " has appeared more than once with same Contribution type in the file"+FvuConstants.FIELD_SEPERATOR);
            	}
        	else
        		controlSheetBuffer.append("-"+FvuConstants.FIELD_SEPERATOR);
            
          //For Revamp CR-16365  Starts
            Set<String> set1 = new HashSet<String>(this.getPransList());
            controlSheetBuffer.append( set1.size()+FvuConstants.FIELD_SEPERATOR);
            
            if (invalidRecord == false && invalidSubCount == false && invalidDDOCount == false && invalidTotalContributionInDDO == false && inValidContributionAmt == false)
            {
            	if (invalidDdoCaretCount == false && totalGovtContributionInDDO!= null && totalSelfContributionInDDO!=null && totalCountOfSD!= null)
                {
            		
            		govtContributionInDDO = new BigDecimal(totalGovtContributionInDDO);
            		selfContributionInDDO = new BigDecimal(totalSelfContributionInDDO);
                    totalSubscriberCount = Integer.parseInt(this.getTotalSubscriberCount());
                    // System.out.println("govtContributionInDDO :" +govtContributionInDDO);
                  //  System.out.println("selfContributionInDDO :" +selfContributionInDDO);
                   // System.out.println("totalSubscriberCount :" +totalSubscriberCount);
                   // System.out.println("totalNoOfSDRead :"+ totalNoOfSDRead);
                   // System.out.println("subscriberGovtContribution :"+subscriberGovtContribution);
                    //System.out.println("subscriberSelfContribution :"+subscriberSelfContribution);
                    if (totalNoOfSDRead > totalSubscriberCount)
                    {
                        listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[6], Integer.parseInt(sectorCategory + FvuConstants.PEF_3014), RECTYPE_DDOREC, "-", "-","-", (lineCount - totalNoOfSDRead) + "", "-"));
                    }
                    else if (totalNoOfSDRead < totalSubscriberCount)
                    {
                        listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[6], Integer.parseInt(sectorCategory + FvuConstants.PEF_3013), RECTYPE_DDOREC, "-", "-", "-",(lineCount - totalNoOfSDRead) + "", "-"));
                    }
                    else
                    {
                    	 // Commented for CR - VPF-T2 Contribution for Corp    
                        /*if (!govtContributionInDDO.equals(subscriberGovtContribution))
                        {
                            listErrorVO.add(new PAOContrErrorFileVO(PAO_DDO_FIELD_7, Integer.parseInt(sectorCategory + FvuConstants.PEF_3015), RECTYPE_DDOREC, "-", "-","-", (lineCount - totalNoOfSDRead) + "", "-"));
                        }
                        if (!selfContributionInDDO.equals(subscriberSelfContribution))
                        {
                            listErrorVO.add(new PAOContrErrorFileVO(PAO_DDO_FIELD_8, Integer.parseInt(sectorCategory + FvuConstants.PEF_3016), RECTYPE_DDOREC, "-", "-","-", (lineCount - totalNoOfSDRead) + "", "-"));
                        }*/
                    }
                }  
                if (inValidFhCaretCount==false && inValidBhCaretCount == false && invalidDdoCaretCount == false &&  totalCountOfDDO != null)
                {
                    	//System.out.println("totalCountOfDDO :"+totalCountOfDDO);
                    	//System.out.println("totalNoOfDDORead :"+totalNoOfDDORead);
                      
                        
                    	// Checking the Number of DDO Records is less than count of DDO Records specified in Batch.
                    	if (totalNoOfDDORead < Integer.parseInt(totalCountOfDDO))
                        {
                            listErrorVO.add(new PAOContrErrorFileVO(PAO_BH_FIELD_9, Integer.parseInt(sectorCategory + FvuConstants.PEF_2020), FvuConstants.RECTYPE_BHREC, "-", "-","-", "2", "-"));
                        }
                        // Checking the Number of DDO Records is more than count of DDO Records specified in Batch.
                        else if (totalNoOfDDORead > Integer.parseInt(totalCountOfDDO))
                        {
                            listErrorVO.add(new PAOContrErrorFileVO(PAO_BH_FIELD_9, Integer.parseInt(sectorCategory + FvuConstants.PEF_2021), FvuConstants.RECTYPE_BHREC, "-", "-","-", "2", "-"));
                        }
                        else
                        {
                            /**
                             * Checking the sum of individual Tier-1 Contribution amounts in DDO Records are equal to the
                             * Total Tier-1 Contribution Amount in Batch for both Government and Self contributions.
                             */
                        	if (invalidTotalContributionInBatch == false)
                            {
                        		govtContributionInBatch = new BigDecimal(batchTotalGovtContrbutionOfDDO);
                        		selfContributionInBatch = new BigDecimal(batchTotalSelfContrbutionOfDDO);
                        		//System.out.println("govtContributionInBatch :"+govtContributionInBatch);
                        		//System.out.println("selfContributionInBatch :"+selfContributionInBatch);
                        		//System.out.println("totalTierOneGovtAmt :"+totalTierOneGovtAmt);
                        		//System.out.println("totalTierOneSelfAmt :"+totalTierOneSelfAmt);
                        		
                        		//&& !"T".equalsIgnoreCase(FvuConstants.UPLOADED_BY_UOS ) added for TTS 34025
                        		if(!uploadBy.equals(FvuConstants.UPLOADED_BY_UOS) && !uploadBy.equals(FvuConstants.UPLOADED_BY_UOS_TTS) ){
                                if (!totalTierOneGovtAmt.equals(govtContributionInBatch)  )
                                {
                                    listErrorVO.add(new PAOContrErrorFileVO(PAO_BH_FIELD_11, Integer.parseInt(sectorCategory + FvuConstants.PEF_2022), FvuConstants.RECTYPE_BHREC, "-", "-","-", "2", "-"));
                                }
                                if (!totalTierOneSelfAmt.equals(selfContributionInBatch) )
                                {
                                	listErrorVO.add(new PAOContrErrorFileVO(PAO_BH_FIELD_12, Integer.parseInt(sectorCategory + FvuConstants.PEF_2023), FvuConstants.RECTYPE_BHREC, "-", "-","-", "2", "-"));
                                }
                        		}
                            }
                        }
                        govtContributionInBatch = new BigDecimal("0.0");
                        selfContributionInBatch = new BigDecimal("0.0");
                       // System.out.println("totalCountOfSubscribers :"+totalCountOfSubscribers);
                       // System.out.println("sdCount :"+sdCount);
                       
                        if (sdCount < Integer.parseInt(totalCountOfSubscribers))
                        {
                        	listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[10], FvuConstants.PEF_2025, FvuConstants.RECTYPE_BHREC, "-", "-","-", "2", "-"));
                        }
                        else if (sdCount > Integer.parseInt(totalCountOfSubscribers))
                        {
                        	listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[10], FvuConstants.PEF_2030, FvuConstants.RECTYPE_BHREC, "-", "-","-", "2", "-"));
                        }
                        controlSheetBuffer.append(lineCount + FvuConstants.FIELD_SEPERATOR);
                        controlSheetBuffer.append(this.getTotalContrAmtTTS() + FvuConstants.FIELD_SEPERATOR);
                 } // end of if (invalidRecord == false)
            }
        }
        catch (FileNotFoundException fex)
        {
            System.out.println("File not found exception in readFile method in SubContrFileFormatValidator");
        }
        catch (IOException ioex)
        {
            System.out.println("IOException in readFile method in SubContrFileFormatValidator");
        }
        catch (Exception nfex)
        {
        	listErrorVO.add(new PAOContrErrorFileVO("-", FvuConstants.PEF_5008, "-", "-", "-","-", "-" + "", "Error"));
        }

    } // end of readFile() method

    public StringBuffer getControlSheetBuffer()
    {
        return controlSheetBuffer;
    }

    public void setControlSheetBuffer(StringBuffer buffer)
    {
        controlSheetBuffer = buffer;
    }

    public String getDdoTierOneGovtContribution()
    {
        return totalGovtContributionInDDO;
    }

    public String getDdoTierOneSelfContribution()
    {
        return totalSelfContributionInDDO;
    }

    public String getTotalSubscriberCount()
    {
        return totalCountOfSD;
    }

    public void setDdoTierOneGovtContribution(String ddoTierOneGovtAmt)
    {
        totalGovtContributionInDDO = ddoTierOneGovtAmt;
    }

    public void setDdoTierOneSelfContribution(String ddoTierOneSelfAmt)
    {
        totalSelfContributionInDDO = ddoTierOneSelfAmt;
    }

    public void setTotalSubscriberCount(String totalSubCount)
    {
        totalCountOfSD = totalSubCount;
    }

	public BigDecimal getTotalContrAmtArr() {
		return totalContrAmtArr;
	}

	public void setTotalContrAmtArr(BigDecimal totalContrAmtArr) {
		this.totalContrAmtArr = totalContrAmtArr;
	}

	public BigDecimal getTotalContrAmtReg() {
		return totalContrAmtReg;
	}

	public void setTotalContrAmtReg(BigDecimal totalContrAmtReg) {
		this.totalContrAmtReg = totalContrAmtReg;
	}

	public int getDuplicateCount() {
		return DuplicateCount;
	}

	public void setDuplicateCount(int duplicateCount) {
		DuplicateCount = duplicateCount;
	}

	public BigDecimal getTotalContrAmtMisc() {
		return totalContrAmtMisc;
	}

	public void setTotalContrAmtMisc(BigDecimal totalContrAmtMisc) {
		this.totalContrAmtMisc = totalContrAmtMisc;
	}

	public BigDecimal getTotalContrAmtT1() {
		return totalContrAmtT1;
	}

	public void setTotalContrAmtT1(BigDecimal totalContrAmtT1) {
		this.totalContrAmtT1 = totalContrAmtT1;
	}

	public BigDecimal getTotalContrAmtT2() {
		return totalContrAmtT2;
	}

	public void setTotalContrAmtT2(BigDecimal totalContrAmtT2) {
		this.totalContrAmtT2 = totalContrAmtT2;
	}

	public BigDecimal getTotalContrAmtUM1() {
		return totalContrAmtUM1;
	}

	public void setTotalContrAmtUM1(BigDecimal totalContrAmtUM1) {
		this.totalContrAmtUM1 = totalContrAmtUM1;
	}

	public BigDecimal getTotalContrAmtUM2() {
		return totalContrAmtUM2;
	}

	public void setTotalContrAmtUM2(BigDecimal totalContrAmtUM2) {
		this.totalContrAmtUM2 = totalContrAmtUM2;
	}

	public BigDecimal getTotalContrAmtUT1() {
		return totalContrAmtUT1;
	}

	public void setTotalContrAmtUT1(BigDecimal totalContrAmtUT1) {
		this.totalContrAmtUT1 = totalContrAmtUT1;
	}

	public BigDecimal getTotalContrAmtUT2() {
		return totalContrAmtUT2;
	}

	public void setTotalContrAmtUT2(BigDecimal totalContrAmtUT2) {
		this.totalContrAmtUT2 = totalContrAmtUT2;
	}
	
	public BigDecimal getTotalContrAmtVPF() {
		return totalContrAmtVPF;
	}

	public void setTotalContrAmtVPF(BigDecimal totalContrAmtVPF) {
		this.totalContrAmtVPF = totalContrAmtVPF;
	}

	public BigDecimal getTotalContrAmtVPFUPS() {
		return totalContrAmtVPFUPS;
	}

	public void setTotalContrAmtVPFUPS(BigDecimal totalContrAmtVPFUPS) {
		this.totalContrAmtVPFUPS = totalContrAmtVPFUPS;
	}
	public ArrayList<String> getWarnings() {
		return warnings;
	}

	public void setWarnings(ArrayList<String> warnings) {
		this.warnings = warnings;
	}
	 public int getRecord_C() {
			return record_C;
		}

		public void setRecord_C(int record_C) {
			this.record_C = record_C;
		}

		public int getRecord_T1() {
			return record_T1;
		}

		public void setRecord_T1(int record_T1) {
			this.record_T1 = record_T1;
		}

		public int getRecord_T2() {
			return record_T2;
		}

		public void setRecord_T2(int record_T2) {
			this.record_T2 = record_T2;
		}

		public int getRecord_UT1() {
			return record_UT1;
		}

		public void setRecord_UT1(int record_UT1) {
			this.record_UT1 = record_UT1;
		}

		public int getRecord_UT2() {
			return record_UT2;
		}

		public void setRecord_UT2(int record_UT2) {
			this.record_UT2 = record_UT2;
		}

		public int getRecord_M1() {
			return record_M1;
		}

		public void setRecord_M1(int record_M1) {
			this.record_M1 = record_M1;
		}

		public int getRecord_M2() {
			return record_M2;
		}

		public void setRecord_M2(int record_M2) {
			this.record_M2 = record_M2;
		}
		
		public int getRecord_VPF() {
			return record_VPF;
		}

		public void setRecord_VPF(int record_VPF) {
			this.record_VPF = record_VPF;
		}
		
		public int getRecord_VPFUPS() {
			return record_VPFUPS;
		}

		public void setRecord_VPFUPS(int record_VPFUPS) {
			this.record_VPFUPS = record_VPFUPS;
		}
		public int getUniquePranCount() {
			return uniquePranCount;
		}

		public void setUniquePranCount(int uniquePranCount) {
			this.uniquePranCount = uniquePranCount;
		}

		int record_A=0;
	    public int getRecord_A() {
			return record_A;
		}

		public void setRecord_A(int record_A) {
			this.record_A = record_A;
		}

		public int getRecord_0() {
			return record_0;
		}

		public void setRecord_0(int record_0) {
			this.record_0 = record_0;
		}
    
	    public ArrayList<String> getComboList() {
			return comboList;
		}
	
		public void setComboList(ArrayList<String> comboList) {
			this.comboList = comboList;
		}
		public ArrayList<String> getPransList() {
			return pransList;
		}
	
		public void setPransList(ArrayList<String> pransList) {
			this.pransList = pransList;
		}

} // End of PAOFormatValidator Class


