/** 
 *  Class: FileHeaderValidation.java      
 */
package com.cra.pao.fvu;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

import com.cra.contr.common.util.CommonValidation;
import com.cra.pao.vo.PAOContrErrorFileVO;

/**
 * This class contains methods that will validate the fields of File Header Record. It implemnts FvuConstantsInterface
 * for getting error descriptions for the corresponding error codes and for other constant values.
 * 
 * @author TCS
 */

public class FileHeaderValidation
{
    private String noOfBtchs = null; // Number Of Batches
    private String fhRecordHash = null; // File Header Record Hash
    private String fvuVersion = null; // FVU Version
    private String fvuFileLevelHash = null; // FVU File Level Hash
    private String samVersion = null; // SAM Version
    private String samFileLevelHash = null; // SAM File Level Hash
    private String scmVersion = null; // SCM Version
    private String scmFileLevelHash = null; // SCM File Level Hash
    private String filler = null; // SCM Version
    private String prn = null; // SCM File Level Hash
    private boolean upldByFlag = false;
    
    /**
     * *****************************************FILE HEADER VALIDATION STARTS***************************************
     */
    /**
     * fhFieldValidator method is called from SubContrFileFormatValidator.java to validate Line No.1 of a '.txt' file
     * which is the File header Record.
     * 
     * @param objReadFH (Object of SubContrFileFormatValidator class)
     * @param lineCountP (Logical line number for each line in the file)
     * @param fhRecord (The File Header Record is taken as a String, line no.1 of the file)
     * @param listErrorVO (Object of PAOContrErrorFileVO class)
     * 
     * @return void
     */
//  void fhFieldValidator(SubContrFileFormatValidator objReadFH, int lineCountP, String[] fhRecord, ArrayList<PAOContrErrorFileVO> listErrorVO )
    void fhFieldValidator(SubContrFileFormatValidator objReadFH, int lineCountP, String[] fhRecord, ArrayList<PAOContrErrorFileVO> listErrorVO ,int utilityLevel)
    {
    	System.out.println("inside FileHeaderValidation.java"+fhRecord.toString()+"line"+lineCountP);
    	if(fhRecord.length >= 3)
       {
    	   objReadFH.uploadBy = fhRecord[2];
       }
    	//          Decide Field will be PAO Reg. No./FC ID(4)  or Uploading entity's Reg. No.(4)
            if(objReadFH.uploadBy!=null && objReadFH.uploadBy.equals(FvuConstants.UPLOADED_BY_UOS))
            {
            	objReadFH.PAO_FH_FIELD_4 = FvuConstants.PAO_FH_FIELD[13];
            	objReadFH.sectorCategory ="2";
            	upldByFlag=true;
            }//Added For TTS to CR-34025 .START
            else if(objReadFH.uploadBy!=null && objReadFH.uploadBy.equals(FvuConstants.UPLOADED_BY_UOS_TTS))
            {
            	objReadFH.PAO_FH_FIELD_4 = FvuConstants.PAO_FH_FIELD[13];
            	objReadFH.sectorCategory ="2";
            	upldByFlag=true;
            }//Added For TTS to CR-34025 .END
          ////Modified For CR-58405
            else if(objReadFH.uploadBy!=null && (objReadFH.uploadBy.equals(FvuConstants.UPLOADED_BY_AO) || objReadFH.uploadBy.equals(FvuConstants.UPLOADED_BY_AOV) || objReadFH.uploadBy.equals(FvuConstants.UPLOADED_BY_AOV_TTS) || objReadFH.uploadBy.equals(FvuConstants.UPLOADED_BY_KA) || objReadFH.uploadBy.equals(FvuConstants.UPLOADED_BY_AO_UPS) ))//Modified for TTS CG/SG of CR-34025
            {
            	objReadFH.PAO_FH_FIELD_4 = FvuConstants.PAO_FH_FIELD[4];
            	objReadFH.sectorCategory ="0";
            	upldByFlag=true;
            }
          ////Modified For CR-58405
            else if(objReadFH.uploadBy!=null && objReadFH.uploadBy.equals(FvuConstants.UPLOADED_BY_PRAO) || objReadFH.uploadBy.equals(FvuConstants.UPLOADED_BY_PRAOV)|| objReadFH.uploadBy.equals(FvuConstants.UPLOADED_BY_PRAOV_TTS) || objReadFH.uploadBy.equals(FvuConstants.UPLOADED_BY_PRAO_UPS))//Modified for TTS CG/SG of CR-34025
            {
            	objReadFH.PAO_FH_FIELD_4 = FvuConstants.PAO_FH_FIELD[14];
            	objReadFH.sectorCategory ="1";
            	upldByFlag=true;
            }
            else if(objReadFH.uploadBy!=null && objReadFH.uploadBy.equals(FvuConstants.UPLOADED_BY_CORP))
            {
            	objReadFH.PAO_FH_FIELD_4 = FvuConstants.PAO_FH_FIELD[16];
            	objReadFH.sectorCategory ="4";
            	upldByFlag=true;
            }
            //System.out.println("Upload By :"+objReadFH.uploadBy);
            if (objReadFH.inValidFhCaretCount == false && upldByFlag)
            {
            	objReadFH.lineNo = fhRecord[0];
                objReadFH.recType = fhRecord[1];
                objReadFH.uploadBy = fhRecord[2];
                objReadFH.uploaderId = fhRecord[3];
                noOfBtchs = fhRecord[4];
                //Added for CR 23214
                //Modified for CR-58405
                if(objReadFH.uploadBy.equals(FvuConstants.UPLOADED_BY_PRAO) || objReadFH.uploadBy.equals(FvuConstants.UPLOADED_BY_AO) || objReadFH.uploadBy.equals(FvuConstants.UPLOADED_BY_KA) || objReadFH.uploadBy.equals(FvuConstants.UPLOADED_BY_AO_UPS) || objReadFH.uploadBy.equals(FvuConstants.UPLOADED_BY_PRAO_UPS)){
                	objReadFH.sdDate = fhRecord[5];
                	objReadFH.fileFlag = fhRecord[6];
                	objReadFH.fileMonth = fhRecord[7];
                	objReadFH.fileYear = fhRecord[8];
                }else{
	            	fhRecordHash = fhRecord[5];
	                fvuVersion = fhRecord[6];
	                fvuFileLevelHash = fhRecord[7];
	                filler = fhRecord[8];
                }
                prn = fhRecord[9];
                samVersion = fhRecord[10];
                samFileLevelHash = fhRecord[11];
            /**
             * Validation of LINE NUMBER(Field No.1 of File Header Record)
             * 
             * Line Number should be of length less than or equal to 9 digits. Line Number should not have leading and
             * trailing spaces. Line Number should not have spaces in between the number. Line Number should always be
             * '1' for File Header Record.
             */

            if (objReadFH.lineNo == FvuConstants.FIELD_NULL)
            {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD[1], FvuConstants.PEF_1001, "-", "-", "-","-", "-", "-"));
                objReadFH.lineNo = "-";
            }
            else if (objReadFH.lineNo.trim().length() > 9 || objReadFH.lineNo.length() > 9)
            {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD[1], FvuConstants.PEF_1005, "-", "-", "-","-", objReadFH.lineNo, "-"));
            }
            else if (objReadFH.lineNo.length() <= 9)
            {
                String fhLineNum = CommonValidation.trimInnerSpaces(objReadFH.lineNo);
                if (CommonValidation.isInt(fhLineNum))
                {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD[1], FvuConstants.PEF_1002, "-", "-", "-","-", objReadFH.lineNo, "-"));
                }
                else if (!fhLineNum.equals(objReadFH.lineNo))
                {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD[1], FvuConstants.PEF_1003, "-", "-", "-","-", objReadFH.lineNo, "-"));
                }
                else if (Integer.parseInt(objReadFH.lineNo.trim()) != lineCountP)
                {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD[1], FvuConstants.PEF_1004, "-", "-", "-","-", objReadFH.lineNo, "-"));
                }
            }
            else if (objReadFH.lineNo.trim().length() != objReadFH.lineNo.length())
            {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD[1], FvuConstants.PEF_1003, "-", "-", "-", "-",objReadFH.lineNo, "-"));
            } // End of LINE NUMBER Validation
            /**
             * Validation of RECORD TYPE(Field No.2 of File Header Record)
             * 
             * Record Type should be "FH" for File Header Record. Values other than "FH" are invalid.
             */
            if (objReadFH.recType == FvuConstants.FIELD_NULL)
            {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD[2], FvuConstants.PEF_1001, FvuConstants.RECTYPE_FHREC, "-", "-","-", objReadFH.lineNo, "-"));
            }
            else if (!objReadFH.recType.equals(FvuConstants.FH_REC))
            {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD[2], FvuConstants.PEF_1006, FvuConstants.RECTYPE_FHREC, "-", "-","-", objReadFH.lineNo, "-"));
            } // End of RECORD TYPE Validation
            /**
             * Validation of UPLOADER TYPE(Field No.3 of File Header Record)
             * 
             * Uploader Type should be "P" for PAO Upload and "F" for FC upload. Values other than "P" and "F" are
             * invalid.
             */
            if (objReadFH.uploadBy == FvuConstants.FIELD_NULL)
            {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD[3], FvuConstants.PEF_1001, FvuConstants.RECTYPE_FHREC, "-", "-","-", objReadFH.lineNo, "-"));
                objReadFH.controlSheetBuffer.append("-" + FvuConstants.FIELD_SEPERATOR);
            }
            else if (!upldByFlag)
            {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD[3], FvuConstants.PEF_1007, FvuConstants.RECTYPE_FHREC, "-", "-","-", objReadFH.lineNo, "-"));
                objReadFH.controlSheetBuffer.append("-" + FvuConstants.FIELD_SEPERATOR);
            }
            else
            {
                objReadFH.controlSheetBuffer.append(objReadFH.uploadBy + FvuConstants.FIELD_SEPERATOR);
            }// End of UPLOADER TYPE Validation

            /**
             * Validation of UPLOADER ID(Field No.4 of File Header Record)
             * 
             * If uploader type is "P", then ID should be 7-digit integer In case of 7-digit ID, the AIN should follow
             * check-digit validation. Check-digit: The 7-th digit of AIN should be mod 7 of first 6 digits.
             * 
             * If uploader type is "F", then ID should be 5-digit integer
             */
            if (objReadFH.uploaderId == FvuConstants.FIELD_NULL)
            {
                listErrorVO.add(new PAOContrErrorFileVO(objReadFH.PAO_FH_FIELD_4, FvuConstants.PEF_1001, FvuConstants.RECTYPE_FHREC, "-", "-","-", objReadFH.lineNo, "-"));
                objReadFH.invalidAIN = true;
            }
            else if (objReadFH.uploaderId.trim().length() != objReadFH.uploaderId.length())
            {
                listErrorVO.add(new PAOContrErrorFileVO(objReadFH.PAO_FH_FIELD_4, FvuConstants.PEF_1003, FvuConstants.RECTYPE_FHREC, "-", "-","-", objReadFH.lineNo, "-"));
                objReadFH.invalidAIN = true;
            }
            else if (objReadFH.uploadBy != FvuConstants.FIELD_NULL && objReadFH.uploaderId != FvuConstants.FIELD_NULL)
            {
                    if (objReadFH.uploaderId.trim().length() != 7 && objReadFH.uploaderId.length() != 7)
                    {
                        listErrorVO.add(new PAOContrErrorFileVO(objReadFH.PAO_FH_FIELD_4, FvuConstants.PEF_1008, FvuConstants.RECTYPE_FHREC, "-", "-","-", objReadFH.lineNo, "-"));
                        objReadFH.invalidAIN = true;
                    }
                    else if (CommonValidation.isInt(objReadFH.uploaderId))
                    {
                        listErrorVO.add(new PAOContrErrorFileVO(objReadFH.PAO_FH_FIELD_4, FvuConstants.PEF_1002, FvuConstants.RECTYPE_FHREC, "-", "-", "-",objReadFH.lineNo, "-"));
                        objReadFH.invalidAIN = true;
                    }
                    else if (objReadFH.uploaderId.startsWith("0"))
                    {
                        listErrorVO.add(new PAOContrErrorFileVO(objReadFH.PAO_FH_FIELD_4, FvuConstants.PEF_1002, FvuConstants.RECTYPE_FHREC, "-", "-","-", objReadFH.lineNo, "-"));
                        objReadFH.invalidAIN = true;
                    }
                    else if (CommonValidation.checkID(objReadFH.uploaderId))
                    {
                        listErrorVO.add(new PAOContrErrorFileVO(objReadFH.PAO_FH_FIELD_4, FvuConstants.PEF_1002, FvuConstants.RECTYPE_FHREC, "-", "-","-", objReadFH.lineNo, "-"));
                        objReadFH.invalidAIN = true;
                    }
                
            }
            // Uncomment when FC upload is done in the future - Added by Vijay December 07,2007
            /*
             * else if (objReadFH.uploadBy.equals(FvuConstants.UPLOADED_BY_FC)) { if
             * (objReadFH.uploaderId.trim().length() != 5 && objReadFH.uploaderId.length() != 5) { listErrorVO.add(new
             * PAOContrErrorFileVO(objReadFH.PAO_FH_FIELD_4, FvuConstants.PEF_1001, FvuConstants.RECTYPE_FHREC, "-",
             * "-", objReadFH.lineNo, "-")); } else if(CommonValidation.isInt(objReadFH.uploaderId)) {
             * listErrorVO.add(new PAOContrErrorFileVO(objReadFH.PAO_FH_FIELD_4, FvuConstants.PEF_1002,
             * FvuConstants.RECTYPE_FHREC, "-", "-", objReadFH.lineNo, "-")); } } // End of UPLOADER ID Validation
             */

            /**
             * Validation of NUMBER OF BATCHES(Field No.5 Of File Header Record)
             * 
             * Number Of Batches should be of length less than or equal to 9 digits. Number Of Batches should not have
             * leading and trailing spaces. Number Of Batches should not have spaces in between the number. Number Of
             * Batches should always have the value as '1'.
             */
            if (noOfBtchs == FvuConstants.FIELD_NULL)
            {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD[5], FvuConstants.PEF_1001, FvuConstants.RECTYPE_FHREC, "-", "-","-", objReadFH.lineNo, "-"));
                objReadFH.controlSheetBuffer.append("-" + FvuConstants.FIELD_SEPERATOR);
            }
            else if (noOfBtchs.length() > 9)
            {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD[5], FvuConstants.PEF_1005, FvuConstants.RECTYPE_FHREC, "-", "-","-", objReadFH.lineNo, "-"));
                objReadFH.controlSheetBuffer.append("-" + FvuConstants.FIELD_SEPERATOR);
            }
            else if (noOfBtchs.length() <= 9)
            {
                String numOfBatches = CommonValidation.trimInnerSpaces(noOfBtchs);
                if (CommonValidation.isInt(numOfBatches))
                {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD[5], FvuConstants.PEF_1002, FvuConstants.RECTYPE_FHREC, "-", "-","-", objReadFH.lineNo, "-"));
                    objReadFH.controlSheetBuffer.append("-" + FvuConstants.FIELD_SEPERATOR);
                }
                else if (!numOfBatches.equals(noOfBtchs))
                {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD[5], FvuConstants.PEF_1003, FvuConstants.RECTYPE_FHREC, "-", "-","-", objReadFH.lineNo, "-"));
                    objReadFH.controlSheetBuffer.append("-" + FvuConstants.FIELD_SEPERATOR);
                }
                else if (Integer.parseInt(noOfBtchs.trim()) != 1)
                {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD[5], FvuConstants.PEF_1010, FvuConstants.RECTYPE_FHREC, "-", "-","-", objReadFH.lineNo, "-"));
                    objReadFH.controlSheetBuffer.append("-" + FvuConstants.FIELD_SEPERATOR);
                }
                 
               else if (noOfBtchs.trim().length() != noOfBtchs.length())
                {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD[5], FvuConstants.PEF_1003, FvuConstants.RECTYPE_FHREC, "-", "-", "-",objReadFH.lineNo, "-"));
                    objReadFH.controlSheetBuffer.append("-" + FvuConstants.FIELD_SEPERATOR);
                }
               else
                {
                    objReadFH.controlSheetBuffer.append(noOfBtchs + FvuConstants.FIELD_SEPERATOR);
                }
            }// End of NUMBER OF BATCHES Validation
            /**
             * Add FVU version in ControlsheetBuffer
             * 
             */
            if (utilityLevel != 0)
            {
            	if (fvuVersion == FvuConstants.FIELD_NULL)
                {
                    objReadFH.controlSheetBuffer.append("0" + FvuConstants.FIELD_SEPERATOR);
                }
            	else
            	{
            		objReadFH.controlSheetBuffer.append(fvuVersion + FvuConstants.FIELD_SEPERATOR);	
            	}
            	
            }
            else
            {
            	objReadFH.controlSheetBuffer.append("-" + FvuConstants.FIELD_SEPERATOR);
            }
            /**
             * Add SAM version in ControlsheetBuffer
             * 
             */
            if (utilityLevel == 4)
            {
            	if (samVersion == FvuConstants.FIELD_NULL)
                {
                    objReadFH.controlSheetBuffer.append("0" + FvuConstants.FIELD_SEPERATOR);
                }
            	else
            	{
            		objReadFH.controlSheetBuffer.append(samVersion + FvuConstants.FIELD_SEPERATOR);
            	}
            	
            }
            else
            {
            	objReadFH.controlSheetBuffer.append("-" + FvuConstants.FIELD_SEPERATOR);
            }
            /**
             * Validation of PRN(Field No.10 Of File Header Record)
             * 
             */
           
            if (utilityLevel== 4)
            {
	            if (prn == FvuConstants.FIELD_NULL)
	            {
	                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD[10], FvuConstants.PEF_1001, FvuConstants.RECTYPE_FHREC, "-", "-","-", objReadFH.lineNo, "-"));
	                objReadFH.controlSheetBuffer.append("-" + FvuConstants.FIELD_SEPERATOR);
	            }
	            else if (prn.trim().length() != 15 || prn.length() != 15)
	            {
	                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD[10], FvuConstants.PEF_1020, FvuConstants.RECTYPE_FHREC, "-", "-","-", objReadFH.lineNo, "-"));
	                objReadFH.controlSheetBuffer.append("-" + FvuConstants.FIELD_SEPERATOR);
	            }
	            else if (CommonValidation.checkTabSpaces(prn))
	            {
	                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD[10], FvuConstants.PEF_1003, FvuConstants.RECTYPE_FHREC, "-", "-","-", objReadFH.lineNo, "-"));
	                objReadFH.controlSheetBuffer.append("-" + FvuConstants.FIELD_SEPERATOR);
	            }
	            else if (CommonValidation.isInt(prn))
	    		{
	            	listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD[10], FvuConstants.PEF_1002, FvuConstants.RECTYPE_FHREC, "-", "-", "-",objReadFH.lineNo, "-"));
	            	objReadFH.controlSheetBuffer.append("-" + FvuConstants.FIELD_SEPERATOR);
	    		}
	            else
	    		{
	            	objReadFH.controlSheetBuffer.append(prn + FvuConstants.FIELD_SEPERATOR);
	    		}
           }
            else
            {
            	objReadFH.controlSheetBuffer.append("-" + FvuConstants.FIELD_SEPERATOR);
            }
            
            //Added for CR 23214
            //Modified for CR-58405
            if(objReadFH.uploadBy.equals(FvuConstants.UPLOADED_BY_PRAO) || objReadFH.uploadBy.equals(FvuConstants.UPLOADED_BY_AO) || objReadFH.uploadBy.equals(FvuConstants.UPLOADED_BY_KA) || objReadFH.uploadBy.equals(FvuConstants.UPLOADED_BY_AO_UPS) || objReadFH.uploadBy.equals(FvuConstants.UPLOADED_BY_PRAO_UPS)){
            	/**
	             * Validation of SALARY DISBURSEMENT DATE(Field No.6 Of File Header Record)
	             */
            	//Commented for FTR 23569,23570
            	/*if (objReadFH.fileFlag != FvuConstants.FIELD_NULL && objReadFH.fileFlag.equals(FvuConstants.MONTHLY_FLAG)){ 
	            	if (objReadFH.sdDate == FvuConstants.FIELD_NULL)
	            	{
		                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD_GOVT[6], FvuConstants.PEF_1021, FvuConstants.RECTYPE_FHREC, "-", "-","-", objReadFH.lineNo, "-"));
		            }
            	}*/
            	//if(objReadFH.fileFlag.equals(FvuConstants.MONTHLY_FLAG) || (objReadFH.fileFlag.equals(FvuConstants.ADHOC_FLAG) && (!objReadFH.sdDate.equals(FvuConstants.FIELD_NULL) && !objReadFH.sdDate.equals(FvuConstants.FIELD_SEPERATOR)))){
            	if(objReadFH.sdDate == FvuConstants.FIELD_NULL || objReadFH.sdDate.equals(FvuConstants.FIELD_SEPERATOR)){
            	
            	}else{
		            if (objReadFH.sdDate.trim().length() != 8 || objReadFH.sdDate.length() != 8)
		            {
		                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD_GOVT[6], FvuConstants.PEF_2019, FvuConstants.RECTYPE_FHREC, "-", "-","-", objReadFH.lineNo, "-"));
		            }
		            else if (CommonValidation.checkTabSpaces(objReadFH.sdDate))
		            {
		                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD_GOVT[6], FvuConstants.PEF_2002, FvuConstants.RECTYPE_FHREC, "-", "-","-", objReadFH.lineNo, "-"));
		            }
		            else if (CommonValidation.isInt(objReadFH.sdDate))
		            {
		                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD_GOVT[6], FvuConstants.PEF_2003, FvuConstants.RECTYPE_FHREC, "-", "-","-", objReadFH.lineNo, "-"));
		            }
		            else if (CommonValidation.isDate(objReadFH.sdDate))
		            {
		                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD_GOVT[6], FvuConstants.PEF_2003, FvuConstants.RECTYPE_FHREC, "-", "-","-", objReadFH.lineNo, "-"));
		            }
		            else
		            {
		                String year = objReadFH.sdDate.substring(4, 8);
		                SimpleDateFormat sdf = new SimpleDateFormat("ddMMyyyy");
		                    Date dateFromFile = new Date();
		                    Date sysDate = new Date();
		                    try
		                    {
		                        dateFromFile = sdf.parse(objReadFH.sdDate);
		                        if (dateFromFile.compareTo(sysDate) > 0)
		                        {
		                            listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD_GOVT[6], FvuConstants.PEF_2035, FvuConstants.RECTYPE_FHREC, "-", "-","-", objReadFH.lineNo, "-"));
		                            objReadFH.sdDate = "-";
		                        }
		                    }
		                    catch (java.text.ParseException pe)
		                    {
		                        System.out.println("Parse Exception while Parsing date: " + pe.toString());
		                    }
		                    //objReadFH.controlSheetBuffer.append(objReadFH.sdDate + FvuConstants.FIELD_SEPERATOR);
		            } // End of SALARY DISBURSEMENT DATE Validation
            	}
            	/**
	             * Validation of FILE FLAG(Field No.7 Of File Header Record)
	             */
            	if (objReadFH.fileFlag == FvuConstants.FIELD_NULL)
	            {
	                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD_GOVT[7], FvuConstants.PEF_1001, FvuConstants.RECTYPE_FHREC, "-", "-","-", objReadFH.lineNo, "-"));
	            }
            	else if(!(objReadFH.fileFlag.equals(FvuConstants.MONTHLY_FLAG) || objReadFH.fileFlag.equals(FvuConstants.ADHOC_FLAG)))
            	{
            		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD_GOVT[7], FvuConstants.PEF_1022, FvuConstants.RECTYPE_FHREC, "-", "-","-", objReadFH.lineNo, "-"));
            	}
	            /**
	             * Validation of FILE MONTH(Field No.8 Of File Header Record)
	             */
            	if((objReadFH.fileFlag != FvuConstants.FIELD_NULL && objReadFH.fileFlag.equals(FvuConstants.MONTHLY_FLAG)) && (objReadFH.fileMonth==FvuConstants.FIELD_NULL || objReadFH.fileMonth.equals(FvuConstants.FIELD_SEPERATOR)))
            	{
            		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD_GOVT[8], FvuConstants.PEF_1023, FvuConstants.RECTYPE_FHREC, "-", "-","-", objReadFH.lineNo, "-"));
            	}
            	if((objReadFH.fileFlag != FvuConstants.FIELD_NULL && objReadFH.fileFlag.equals(FvuConstants.ADHOC_FLAG)) && (objReadFH.fileMonth != FvuConstants.FIELD_NULL))
            	{
            		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD_GOVT[8], FvuConstants.PEF_1026, FvuConstants.RECTYPE_FHREC, "-", "-","-", objReadFH.lineNo, "-"));
            	}
            	//if((!objReadFH.fileMonth.equals(FvuConstants.FIELD_NULL) && !objReadFH.fileMonth.equals(FvuConstants.FIELD_SEPERATOR))){
            	if(objReadFH.fileMonth == FvuConstants.FIELD_NULL || objReadFH.fileMonth.equals(FvuConstants.FIELD_SEPERATOR)){
                	
            	}else{
	            	if (objReadFH.fileMonth.trim().length() != objReadFH.fileMonth.length())
	                {
	                	listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD_GOVT[8], FvuConstants.PEF_4003, FvuConstants.RECTYPE_FHREC, "-", "-","-", objReadFH.lineNo + "", "-"));
	                }
	                else if (objReadFH.fileMonth.trim().length() != 2 || objReadFH.fileMonth.length() != 2)
	                {
	                	listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD_GOVT[8], FvuConstants.PEF_4010, FvuConstants.RECTYPE_FHREC, "-", "-","-", objReadFH.lineNo + "", "-"));
	                }
	                else if (CommonValidation.isInt(objReadFH.fileMonth))
	                {
	                	listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD_GOVT[8], FvuConstants.PEF_4002, FvuConstants.RECTYPE_FHREC, "-", "-","-", objReadFH.lineNo + "", "-"));
	                }
	                else if (Integer.parseInt(objReadFH.fileMonth) < 1 || Integer.parseInt(objReadFH.fileMonth) > 12)
	                {
	                	listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD_GOVT[8], FvuConstants.PEF_4019, FvuConstants.RECTYPE_FHREC, "-", "-","-", objReadFH.lineNo + "", "-"));
	                }
            	}
            	/**
	             * Validation of FILE YEAR(Field No.9 Of File Header Record)
	             */
            	if((objReadFH.fileFlag != FvuConstants.FIELD_NULL && objReadFH.fileFlag.equals(FvuConstants.MONTHLY_FLAG)) && (objReadFH.fileYear==FvuConstants.FIELD_NULL || objReadFH.fileYear.equals(FvuConstants.FIELD_SEPERATOR)))
            	{
            		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD_GOVT[9], FvuConstants.PEF_1024, FvuConstants.RECTYPE_FHREC, "-", "-","-", objReadFH.lineNo, "-"));
            	}
            	if((objReadFH.fileFlag != FvuConstants.FIELD_NULL && objReadFH.fileFlag.equals(FvuConstants.ADHOC_FLAG)) && (objReadFH.fileYear != FvuConstants.FIELD_NULL))
            	{
            		listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD_GOVT[9], FvuConstants.PEF_1027, FvuConstants.RECTYPE_FHREC, "-", "-","-", objReadFH.lineNo, "-"));
            	}
            	//if((!objReadFH.fileYear.equals(FvuConstants.FIELD_NULL) && !objReadFH.fileYear.equals(FvuConstants.FIELD_SEPERATOR))){
            	if(objReadFH.fileYear == FvuConstants.FIELD_NULL || objReadFH.fileYear.equals(FvuConstants.FIELD_SEPERATOR)){
                	
            	}else{
	            	if (objReadFH.fileYear.trim().length() != objReadFH.fileYear.length())
	                {
	                	listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD_GOVT[9], FvuConstants.PEF_4003, FvuConstants.RECTYPE_FHREC, "-", "-","-", objReadFH.lineNo + "", "-"));
	                }
	                else if (objReadFH.fileYear.trim().length() != 4 || objReadFH.fileYear.length() != 4)
	                {
	                	listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD_GOVT[9], FvuConstants.PEF_4011, FvuConstants.RECTYPE_FHREC, "-", "-","-", objReadFH.lineNo + "", "-"));
	                }
	                else if (CommonValidation.isInt(objReadFH.fileYear))
	                {
	                	listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD_GOVT[9], FvuConstants.PEF_4002, FvuConstants.RECTYPE_FHREC, "-", "-","-", objReadFH.lineNo + "", "-"));
	                }
	                Calendar cal = new GregorianCalendar();
	        		cal.setLenient(false);
	        		int currentYear = cal.get(Calendar.YEAR);
	        		int yearOfContribution = Integer.parseInt(objReadFH.fileYear);
	        		//CR 31537
            		int contUplodYear = 2003;
	        		//rsona-31st March -removing check cant upload file having contr year less than four years 
	        		//	int fourYearsBackFromCurrent = (currentYear - 4);
	        		int currentMonth = cal.get(Calendar.MONTH);
	        		
	        		if(yearOfContribution == currentYear && !objReadFH.fileMonth.equals(FvuConstants.FIELD_NULL) && !objReadFH.fileMonth.equals(FvuConstants.FIELD_SEPERATOR))
	        		{
	        			int monthOfContribution = Integer.parseInt(objReadFH.fileMonth);
	        			if(monthOfContribution > (currentMonth + 1))
	        			{
	        				listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD_GOVT[8], FvuConstants.PEF_4022, FvuConstants.RECTYPE_FHREC, "-", "-","-", objReadFH.lineNo + "", "-"));
	        			}
	        		}		
	        		else if (yearOfContribution < contUplodYear)
	        		{
	        			PAOContrErrorFileVO paoContrErrorVO=new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD_GOVT[9], FvuConstants.PEF_4015, FvuConstants.RECTYPE_FHREC, "-", "-","-", objReadFH.lineNo + "", "-");
	        			paoContrErrorVO.setErrorCodeStr(" "+contUplodYear);
	        			listErrorVO.add(paoContrErrorVO);
	        		}
	        		else if (yearOfContribution > (currentYear))
	        		{
	        			listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD_GOVT[9], FvuConstants.PEF_4020, FvuConstants.RECTYPE_FHREC, "-", "-","-", objReadFH.lineNo + "", "-"));
	        		}
            	}
            }
        }
        /******************************************FILE HEADER VALIDATION ENDS************************************* */
    }
} // End of fhFieldValidator method
