package com.cra.pao.fvu;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.StringTokenizer;
import com.cra.contr.common.util.CommonValidation;
import com.cra.pao.vo.PAOContrErrorFileVO;

import cra.standalone.paosubcontr.PAOFvu;

/**
 * This class contains methods that will validate the fields of DDO Header Record. It implemnts FvuConstantsInterface
 * for getting error descriptions for the corresponding error codes and for other constant values.
 * 
 * @author TCS
 */

public class DDORecordValidation
{
    private String tierTwoTotalSelfContributionOfSD = null; // Tier-2 Total Self Contribution Amount
    private int previousDDOSrNo = 0; // Initialize Serial No. of the previous SD Record in the same file

    public String totalCountOfSubscribers = null; // Total count of subscribers for the particular DDO
    public String totalGovtContributionAmount = null; // Tier-1 Total Govt Contribution Amount
    public String totalSelfContributionAmount = null; // Tier-1 Total Self Contribution Amount
    private boolean invalidDecimalNumberAtDdo = false;
    public String ddoRecordHash = null; // DDO Record Hash
    private boolean ddoTan_10_Flag=false;
    private boolean ddoTan_7_Flag=false;
    private boolean totGovtContrFlag=false;
    private boolean zeroselfContrFlag=false;
    private boolean selfContrFlag=false;
   
    /**
     * ddoFieldValidator method is called from SubContrFileFormatValidator.java to validate DDO Header Record.
     * 
     * @param objReadDH (Reference of SubContrFileFormatValidator class)
     * @param lineCountP (Logical line number for each line in the file)
     * @param ddoRecord (The DDO Header Record is taken as a String)
     * @param errStrBuff (Reference of ErrorStringBuffer class. A string buffer in which the errors are appended)
     * @param CommonValidation (Reference for using validation methods in CommonValidation class)
     * 
     * @return void
     */
    void ddoFieldValidator(SubContrFileFormatValidator objReadDH, int lineCountP, String ddoRecord, ArrayList<PAOContrErrorFileVO> listErrorVO ,int utilityLevel)
    {
        boolean fieldFound = false;
        boolean carretFound = false;
        
        int caretCounter = 0;
        int localFieldCountDDO = 1;
        objReadDH.lineNo = "";
        objReadDH.recType = "";
        StringTokenizer StrTokenizerDDO = new StringTokenizer(ddoRecord, FvuConstants.FIELD_SEPERATOR, true);
        while (StrTokenizerDDO.hasMoreTokens())
        {
            String value = StrTokenizerDDO.nextToken();
            fieldFound = false;
            if ((value.equals(FvuConstants.FIELD_SEPERATOR) && carretFound) || value.trim().length() == 0)
            {
                fieldFound = true;
            }
            if (value.equals(FvuConstants.FIELD_SEPERATOR))
            {
                carretFound = true;
                if (caretCounter == 0 && localFieldCountDDO == 1)
                {
                    objReadDH.lineNo = "";
                }
                caretCounter++;
            }
            else
            {
                carretFound = false;
                fieldFound = true;
            }
            if (localFieldCountDDO > 10)
            {
                break;
            }
            if (fieldFound == true)
            {
                switch (localFieldCountDDO)
                {
                    case 1:
                        objReadDH.lineNo = value;
                        break;
                    case 2:
                        objReadDH.recType = value;
                        break;
                    case 3:
                        objReadDH.batchNo = value;
                        break;
                    case 4:
                        objReadDH.ddoSerialNo = value;
                        break;
                    case 5:
                    	objReadDH.ddoId = value;
                        break;
                    case 6:
                        objReadDH.totalCountOfSD = value;
                        break;
                    case 7:
                        totalGovtContributionAmount = value;
                        break;
                    case 8:
                        totalSelfContributionAmount = value;
                        break;
                    case 9:
                        tierTwoTotalSelfContributionOfSD = value;
                        break;
                    case 10:
                        ddoRecordHash = value;
                        break;
                }
                localFieldCountDDO++;
            }
        }
        //Decide Record Type will be DDO Header Record  or POP-SP Header Record
//      Decide How the field name will be displayed on the basis of Upload By P / U
        if(objReadDH.uploadBy.equals(FvuConstants.UPLOADED_BY_UOS))
        {
        	objReadDH.RECTYPE_DDOREC = FvuConstants.RECTYPE_POPSPREC;
        	objReadDH.PAO_DDO_FIELD_4 = FvuConstants.PAO_DDO_FIELD[11];
        	objReadDH.PAO_DDO_FIELD_5 = FvuConstants.PAO_DDO_FIELD[12];
        	objReadDH.PAO_DDO_FIELD_7 = FvuConstants.PAO_DDO_FIELD[13];
        	objReadDH.PAO_DDO_FIELD_8 = FvuConstants.PAO_DDO_FIELD[14];
        	objReadDH.PAO_DDO_FIELD_10 = FvuConstants.PAO_DDO_FIELD[15];        	
        	ddoTan_7_Flag=true;
        	
        }//Added For TTS to CR-34025 .START
        else if(objReadDH.uploadBy.equals(FvuConstants.UPLOADED_BY_UOS_TTS))
        {
        	objReadDH.RECTYPE_DDOREC = FvuConstants.RECTYPE_POPSPREC;
        	objReadDH.PAO_DDO_FIELD_4 = FvuConstants.PAO_DDO_FIELD[11];
        	objReadDH.PAO_DDO_FIELD_5 = FvuConstants.PAO_DDO_FIELD[12];
        	objReadDH.PAO_DDO_FIELD_7 = FvuConstants.PAO_DDO_FIELD[13];
        	objReadDH.PAO_DDO_FIELD_8 = FvuConstants.PAO_DDO_FIELD[14];
        	objReadDH.PAO_DDO_FIELD_10 = FvuConstants.PAO_DDO_FIELD[15];        	
        	ddoTan_7_Flag=true;
        	
        }//Added For TTS to CR-34025 .END
        //Modified For CR-58405
        else if(objReadDH.uploadBy.equals(FvuConstants.UPLOADED_BY_AO) || objReadDH.uploadBy.equals(FvuConstants.UPLOADED_BY_AO_UPS))
        {
        	objReadDH.RECTYPE_DDOREC = FvuConstants.RECTYPE_DDOREC;
        	objReadDH.PAO_DDO_FIELD_4 = FvuConstants.PAO_DDO_FIELD[4];
        	objReadDH.PAO_DDO_FIELD_5 = FvuConstants.PAO_DDO_FIELD[5];
        	objReadDH.PAO_DDO_FIELD_7 = FvuConstants.PAO_DDO_FIELD[7];
        	objReadDH.PAO_DDO_FIELD_8 = FvuConstants.PAO_DDO_FIELD[8];
        	objReadDH.PAO_DDO_FIELD_10 = FvuConstants.PAO_DDO_FIELD[10];
        	ddoTan_10_Flag=true;
        	totGovtContrFlag=true;
        	zeroselfContrFlag=true;
        	selfContrFlag=true;
        }
         else if (objReadDH.uploadBy.equals(FvuConstants.UPLOADED_BY_KA) )
         {
         	objReadDH.RECTYPE_DDOREC = FvuConstants.RECTYPE_DDOREC;
         	objReadDH.PAO_DDO_FIELD_4 = FvuConstants.PAO_DDO_FIELD[4];
         	objReadDH.PAO_DDO_FIELD_5 = FvuConstants.PAO_DDO_FIELD[5];
         	objReadDH.PAO_DDO_FIELD_7 = FvuConstants.PAO_DDO_FIELD[7];
         	objReadDH.PAO_DDO_FIELD_8 = FvuConstants.PAO_DDO_FIELD[8];
         	objReadDH.PAO_DDO_FIELD_10 = FvuConstants.PAO_DDO_FIELD[10];
         	ddoTan_10_Flag=true;
         	
         }
      //Modified For CR-58405
        else if(objReadDH.uploadBy.equals(FvuConstants.UPLOADED_BY_PRAO)  || objReadDH.uploadBy.equals(FvuConstants.UPLOADED_BY_PRAO_UPS) )
        {
        	objReadDH.RECTYPE_DDOREC = FvuConstants.RECTYPE_DTOREC;
        	objReadDH.PAO_DDO_FIELD_4 = FvuConstants.PAO_DDO_FIELD[16];
        	objReadDH.PAO_DDO_FIELD_5 = FvuConstants.PAO_DDO_FIELD[17];
        	objReadDH.PAO_DDO_FIELD_7 = FvuConstants.PAO_DDO_FIELD[7];
        	objReadDH.PAO_DDO_FIELD_8 = FvuConstants.PAO_DDO_FIELD[8];
        	objReadDH.PAO_DDO_FIELD_10 = FvuConstants.PAO_DDO_FIELD[18];
        	ddoTan_7_Flag=true;
        	totGovtContrFlag=true;
        	zeroselfContrFlag=true;
        	selfContrFlag=true;
        }
        if(objReadDH.uploadBy.equals(FvuConstants.UPLOADED_BY_CORP))
        {
        	objReadDH.RECTYPE_DDOREC = FvuConstants.RECTYPE_CBOREC;
        	objReadDH.PAO_DDO_FIELD_4 = FvuConstants.PAO_DDO_FIELD[19];
        	objReadDH.PAO_DDO_FIELD_5 = FvuConstants.PAO_DDO_FIELD[20];
        	objReadDH.PAO_DDO_FIELD_7 = FvuConstants.PAO_DDO_FIELD[13];
        	objReadDH.PAO_DDO_FIELD_8 = FvuConstants.PAO_DDO_FIELD[14];
        	objReadDH.PAO_DDO_FIELD_10 = FvuConstants.PAO_DDO_FIELD[21];
        	ddoTan_7_Flag=true;
        }
        // Number of carets in the DDO Header Record must be exactly equal to 9.
        if (caretCounter != 9)
        {
            objReadDH.invalidDdoCaretCount = true;
            listErrorVO.add(new PAOContrErrorFileVO("-",Integer.parseInt(objReadDH.sectorCategory+FvuConstants.PEF_3000), objReadDH.RECTYPE_DDOREC, "-", "-","-", lineCountP + "", "-"));
            //return;
        }
       
        if (objReadDH.invalidDdoCaretCount == false)
        {
            /**
             * Validation of LINE NUMBER(Field No.1 of DDO Header Record) Line Number should not be NULL. Line Number
             * should be of length less than or equal to 9 digits. Line Number should not have leading and trailing
             * spaces. Line Number should not have spaces in between the number. Line Number should always be in
             * sequence.
             */
            if (objReadDH.lineNo.equals(FvuConstants.FIELD_NULL) || objReadDH.lineNo.equals(FvuConstants.FIELD_SEPERATOR))
            {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[1], Integer.parseInt(objReadDH.sectorCategory+FvuConstants.PEF_3000), objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", "-", "-"));
                objReadDH.lineNo = "-";
            }
            else if (objReadDH.lineNo.trim().length() > 9 || objReadDH.lineNo.length() > 9)
            {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[1], FvuConstants.PEF_3005, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
            }
            else if (objReadDH.lineNo.length() <= 9)
            {
                String bhLineNum = CommonValidation.trimInnerSpaces(objReadDH.lineNo);
                if (CommonValidation.isInt(bhLineNum))
                {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[1], FvuConstants.PEF_3002, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
                }
                else if (!bhLineNum.equals(objReadDH.lineNo))
                {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[1], FvuConstants.PEF_3003, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
                }
                else if (Integer.parseInt(objReadDH.lineNo.trim()) != lineCountP)
                {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[1], FvuConstants.PEF_3004, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
                }
            }
            else if (objReadDH.lineNo.trim().length() != objReadDH.lineNo.length())
            {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[1], FvuConstants.PEF_3003, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
            } // End of LINE NUMBER Validation
            /**
             * Validation of RECORD TYPE(Field No.2 of DDO Header Record) Record Type should not be NULL. Record Type
             * should be "DDO" for DDO Header Record. Values other than "DDO" are invalid.
             */
            if (objReadDH.recType.equals(FvuConstants.FIELD_NULL) || objReadDH.recType.equals(FvuConstants.FIELD_SEPERATOR))
            {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[2], FvuConstants.PEF_3001, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
            }
            else if (!objReadDH.recType.equals(FvuConstants.DDO_REC))
            {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[2], FvuConstants.PEF_3006, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
            } // End of RECORD TYPE Validation
            /**
             * Validation of BATCH NUMBER(Field No.3 of DDO Header Record) Batch Number should not be NULL. Batch Number
             * should be of length less than or equal to 9 digits. Batch Number should not have leading and trailing
             * spaces. Batch Number should not have spaces in between the number. Batch Number should always have the
             * value as '1'.
             */
            if (objReadDH.batchNo.equals(FvuConstants.FIELD_NULL) || objReadDH.batchNo.equals(FvuConstants.FIELD_SEPERATOR))
            {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[3], FvuConstants.PEF_3001, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
            }
            else if (objReadDH.batchNo.trim().length() > 9 || objReadDH.batchNo.length() > 9)
            {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[3], FvuConstants.PEF_3005, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
            }
            else if (objReadDH.batchNo.trim().length() != objReadDH.batchNo.length())
            {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[3], FvuConstants.PEF_3002, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
            }
            else if (CommonValidation.checkTabSpaces(objReadDH.batchNo))
            {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[3], FvuConstants.PEF_3002, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
            }
            else if (objReadDH.batchNo.length() <= 9)
            {
                String batchNumber = CommonValidation.trimInnerSpaces(objReadDH.batchNo);
                if (CommonValidation.isInt(batchNumber))
                {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[3], FvuConstants.PEF_3002, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
                }
                else if (!batchNumber.equals(objReadDH.batchNo))
                {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[3], FvuConstants.PEF_3003, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
                }
                else if (Integer.parseInt(objReadDH.batchNo.trim()) != 1)
                {
                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[3], FvuConstants.PEF_3007, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
                }
            }
            else if (objReadDH.batchNo.trim().length() != objReadDH.batchNo.length())
            {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[3], FvuConstants.PEF_3003, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
            } // End of BATCH NUMBER Validation
            /**
             * Validation of SERIAL NUMBER(Field No. 4 of DDO Header Record)
             * 
             * Serial Number is MANDATORY irrespective of the Statement Type. Serial number should be a numeric value of
             * length less than or equal to 9 digits. Serial Number should not be "0" (Zero). Serial Number should not
             * have negative or decimal values Serial Number must be in sequence. No leading and trailing spaces should
             * be specified.
             */
            if (objReadDH.ddoSerialNo.equals(FvuConstants.FIELD_NULL) || objReadDH.ddoSerialNo.equals(FvuConstants.FIELD_SEPERATOR))
            {
                objReadDH.inValidfirstDDOSerialNo = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_4, FvuConstants.PEF_3001, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
                previousDDOSrNo++;
            }
            else if (objReadDH.ddoSerialNo.trim().length() > 9 || objReadDH.ddoSerialNo.length() > 9)
            {
                objReadDH.inValidfirstDDOSerialNo = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_4, FvuConstants.PEF_3005, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
                previousDDOSrNo++;
            }
            else if (objReadDH.ddoSerialNo.trim().length() != objReadDH.ddoSerialNo.length())
            {
                objReadDH.inValidfirstDDOSerialNo = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_4, FvuConstants.PEF_3003, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
                previousDDOSrNo++;
            }
            else if (!CommonValidation.trimInnerSpaces(objReadDH.ddoSerialNo).equals(objReadDH.ddoSerialNo))
            {
                objReadDH.inValidfirstDDOSerialNo = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_4, FvuConstants.PEF_3003, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
                previousDDOSrNo++;
            }
            else if (CommonValidation.checkTabSpaces(objReadDH.ddoSerialNo))
            {
                objReadDH.inValidfirstDDOSerialNo = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_4, FvuConstants.PEF_3003, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
                previousDDOSrNo++;
            }
            else if (CommonValidation.isInt(objReadDH.ddoSerialNo))
            {
                objReadDH.inValidfirstDDOSerialNo = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_4, FvuConstants.PEF_3002, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
                previousDDOSrNo++;
            }
            else if (Integer.parseInt(objReadDH.ddoSerialNo.trim()) < 1)
            {
                objReadDH.inValidfirstDDOSerialNo = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_4, FvuConstants.PEF_3008, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
            }
            else if (objReadDH.totalNoOfDDORead == 1)
            {
                // To check the serial number is not "0" (Zero).
                if (Integer.parseInt(objReadDH.ddoSerialNo.trim()) != 1)
                {
                    objReadDH.inValidfirstDDOSerialNo = true;
                    listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_4, FvuConstants.PEF_3008, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
                }
                else
                {
                    previousDDOSrNo = Integer.parseInt(objReadDH.ddoSerialNo.trim());
                }
            }
            else if (objReadDH.totalNoOfDDORead > 1 && objReadDH.inValidfirstDDOSerialNo == false && objReadDH.invalidDdoCaretCount == false)
            {
                // To check the serial numbers are in sequence.
                if (Integer.parseInt(objReadDH.ddoSerialNo.trim()) != (previousDDOSrNo + 1))
                {
                    listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_4, FvuConstants.PEF_3004, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
                }
                else
                {
                    previousDDOSrNo = Integer.parseInt(objReadDH.ddoSerialNo.trim());
                }
            }// End of DDO SERIAL NUMBER Validation
            /**
             * Validation of DDO ID/TAN(Field No. 5 of DDO Header Record) This field is MANDATORY. TAN should be alpha
             * numeric and length exactly equal to 10 digits. No leading and trailing spaces should be specified. Should
             * follow RCC validation of TAN. 
             */
            if (objReadDH.ddoId.equals(FvuConstants.FIELD_NULL) || objReadDH.ddoId.equals(FvuConstants.FIELD_SEPERATOR))
            {
            	objReadDH.invalidTAN = true;
            	listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_5 , FvuConstants.PEF_3001, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
            }
            else if (objReadDH.ddoId.trim().length() != objReadDH.ddoId.length())
            {
            	objReadDH.invalidTAN = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_5 , FvuConstants.PEF_3003, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
            }
            else if(CommonValidation.checkTabSpaces(objReadDH.ddoId))
            {
            	objReadDH.invalidTAN = true;
            	listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_5 , FvuConstants.PEF_3003, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
            }
            
            //new changes done for WB Govt
            else if ( ddoTan_10_Flag && ((objReadDH.ddoId.trim().length() != 10 || objReadDH.ddoId.length() != 10))&& (objReadDH.ddoId.trim().length() != 7 || objReadDH.ddoId.length() != 7))
            {
            	objReadDH.invalidTAN = true;
               listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_5 , FvuConstants.PEF_3009, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
            }
            else if(ddoTan_7_Flag && (objReadDH.ddoId.trim().length() != 7 || objReadDH.ddoId.length() != 7))
            {
            	objReadDH.invalidTAN = true;
            	listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_5 , FvuConstants.PEF_1008, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-", "-",objReadDH.lineNo + "", "-"));
            }
            else if (objReadDH.ddoId.trim().length() == 10 || objReadDH.ddoId.length() == 10)
            {
                if (CommonValidation.isAlphaNum(objReadDH.ddoId) || CommonValidation.checkTan(objReadDH.ddoId))
                {
                	objReadDH.invalidTAN = true;
                    listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_5 , FvuConstants.PEF_3002, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
                }
            } 
            else if(objReadDH.ddoId.trim().length() == 7 || objReadDH.ddoId.length() == 7)
            {
            	if (CommonValidation.isInt(objReadDH.ddoId))
            	{
            		objReadDH.invalidTAN = true;
            		listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_5 , FvuConstants.PEF_3002, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
            	}
            	else if (CommonValidation.checkID(objReadDH.ddoId))
                {
            		objReadDH.invalidTAN = true;
                    listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_5 , FvuConstants.PEF_3002, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
                }
            }// End of DDO TAN Validation
            /**
             * Validation of TOTAL COUNT OF SD RECORDS(Field No. 6 Of DDO Header Record) This field is MANDATORY for
             * Regular statement & Correction. Count should be an integer value with length less than or equal to 9
             * digits. Count should not be "0" (Zero).
             */
            if (objReadDH.totalCountOfSD.equals(FvuConstants.FIELD_NULL) || objReadDH.totalCountOfSD.equals(FvuConstants.FIELD_SEPERATOR))
            {
                objReadDH.invalidSubCount = true;
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[6], FvuConstants.PEF_3001, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-",objReadDH.lineNo + "", "-"));
            }
            else if (objReadDH.totalCountOfSD.length() > 9 && objReadDH.totalCountOfSD.trim().length() > 9)
            {
                objReadDH.invalidSubCount = true;
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[6], FvuConstants.PEF_3005, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
            }
            else if (objReadDH.totalCountOfSD.trim().length() != objReadDH.totalCountOfSD.length())
            {
                objReadDH.invalidSubCount = true;
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[6], FvuConstants.PEF_3003, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
            }
            else if (CommonValidation.checkTabSpaces(objReadDH.totalCountOfSD))
            {
                objReadDH.invalidSubCount = true;
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[6], FvuConstants.PEF_3003, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
            }
            else if (CommonValidation.isInt(objReadDH.totalCountOfSD))
            {
                objReadDH.invalidSubCount = true;
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[6], FvuConstants.PEF_3002, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
            }
            else if (Integer.parseInt(objReadDH.totalCountOfSD.trim()) == 0)
            {
                objReadDH.invalidSubCount = true;
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[6], FvuConstants.PEF_3010, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
            }
            else
            {
                objReadDH.setTotalSubscriberCount(objReadDH.totalCountOfSD);
            }
            // End of COUNT OF SD RECORDS Validation
            /**
             * Validation of TIER-1 GOVERNMENT CONTRIBUTION AMOUNT(Field No. 7 Of DDO Header Record) This field is MANDATORY for Regular
             * statement & Correction Amount must have length less than or equal to 23 digits. Amount should be a
             * positive decimal value. Amount should be greater than or equal to 0.00 if Upload by 'P'.Blank spaces should not be specified between the numbers. No leading and trailing spaces should be
             * specified. No tab spaces should be specified.
             */
            if (totalGovtContributionAmount.equals(FvuConstants.FIELD_NULL) || totalGovtContributionAmount.equals(FvuConstants.FIELD_SEPERATOR))
            {
                objReadDH.invalidTotalContributionInDDO = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_7, FvuConstants.PEF_3001, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
            }
            else if (totalGovtContributionAmount.length() > 21)
            {
                objReadDH.invalidTotalContributionInDDO = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_7, FvuConstants.PEF_3005, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
            }
            else if(CommonValidation.checkTabSpaces(totalGovtContributionAmount))
            {
            	objReadDH.invalidTotalContributionInDDO = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_7, FvuConstants.PEF_3003, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
            }
            else if (CommonValidation.isDecimalNumber(totalGovtContributionAmount))
            {
            	objReadDH.invalidTotalContributionInDDO = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_7, FvuConstants.PEF_3002, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
            }
            else if (totalGovtContributionAmount.trim().length() != totalGovtContributionAmount.length())
            {
            	objReadDH.invalidTotalContributionInDDO = true;
            	listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_7, FvuConstants.PEF_3003, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
            }
            /*else if (utilityLevel != 5 && totGovtContrFlag && Double.parseDouble(totalGovtContributionAmount) == 0.00)
            {
            	objReadDH.invalidTotalContributionInDDO = true;
            	listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_7, FvuConstants.PEF_2031, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
            }*/
            else
            {
            	objReadDH.setDdoTierOneGovtContribution(totalGovtContributionAmount);
            	
            	if(objReadDH.totalTierOneGovtAmt != null )
            	{
            		objReadDH.totalTierOneGovtAmt = objReadDH.totalTierOneGovtAmt.add(new BigDecimal(totalGovtContributionAmount.trim()));
            		
            	}
            }
            /**Validation of TIER-1 SELF CONTRIBUTION AMOUNT(Field No. 8 Of DDO Header Record)This field is MANDATORY for Regular
             * statement & Correction Amount must have length less than or equal to 23 digits. Amount should be a
             * positive decimal value. Amount should be greater than 0.00.Blank spaces should not be specified between the numbers. No leading and trailing spaces should be
             * specified. No tab spaces should be specified.
             */
            if (totalSelfContributionAmount.equals(FvuConstants.FIELD_NULL) || totalSelfContributionAmount.equals(FvuConstants.FIELD_SEPERATOR))
            {
                objReadDH.invalidTotalContributionInDDO = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_8 , FvuConstants.PEF_3001, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
            }
            else if (totalSelfContributionAmount.length() > 21)
            {
                objReadDH.invalidTotalContributionInDDO = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_8 , FvuConstants.PEF_3005, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
            }
            else if(CommonValidation.checkTabSpaces(totalSelfContributionAmount))
            {
            	objReadDH.invalidTotalContributionInDDO = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_8, FvuConstants.PEF_3003, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
            }
            else if (CommonValidation.isDecimalNumber(totalSelfContributionAmount))
            {
            	objReadDH.invalidTotalContributionInDDO = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_8 , FvuConstants.PEF_3002, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
            }
            else if (totalSelfContributionAmount.trim().length() != totalSelfContributionAmount.length())
            {
            	objReadDH.invalidTotalContributionInDDO = true;
            	listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_8 , FvuConstants.PEF_3003, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
            }
           /* else if (utilityLevel != 5 && zeroselfContrFlag && Double.parseDouble(totalSelfContributionAmount) == 0.00)
            {
            	objReadDH.invalidTotalContributionInDDO = true;
            	listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_8 , FvuConstants.PEF_2031, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
            }*/
            //Added For 14% CR-39795
            else if (utilityLevel != 5 && selfContrFlag && !totalGovtContributionAmount.equals(totalSelfContributionAmount) && PAOFvu.unequalFlag.equalsIgnoreCase("N")&&"N".equalsIgnoreCase(PAOFvu.OSEqualFlag))
            {
               	//System.out.println("totalGovtContributionAmount: "+totalGovtContributionAmount);
            	objReadDH.invalidTotalContributionInDDO = true;
                listErrorVO.add(new PAOContrErrorFileVO(objReadDH.PAO_DDO_FIELD_8 , FvuConstants.PEF_3012, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
            }
            else
            {
            	objReadDH.setDdoTierOneSelfContribution(totalSelfContributionAmount);
            	if( objReadDH.totalTierOneSelfAmt != null)
            	{
            		objReadDH.totalTierOneSelfAmt = objReadDH.totalTierOneSelfAmt.add(new BigDecimal(totalSelfContributionAmount.trim()));
            	}
            	
            }
            /**
             * Validation of TIER-2 SELF CONTRIBUTION (Field No.9 of DDO HEADER Record)
             */
          //  System.out.println("tierTwoTotalSelfContributionOfSD :"+tierTwoTotalSelfContributionOfSD);
          //  System.out.println("ddoRecordHash :"+ddoRecordHash);
            if (tierTwoTotalSelfContributionOfSD != FvuConstants.FIELD_NULL && !tierTwoTotalSelfContributionOfSD.equals(FvuConstants.FIELD_SEPERATOR))
            {
                listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[9], FvuConstants.PEF_3017, objReadDH.RECTYPE_DDOREC, objReadDH.ddoSerialNo, "-","-", objReadDH.lineNo + "", "-"));
            }

        }
    }
}