package com.cra.contr.framework.vo;

import com.cra.contr.common.util.CRAConfigReader;
//import com.cra.common.util.CRAConstants;
//import com.cra.common.util.ObjectCacheManager;

//import java.util.HashMap;
//import javax.naming.NamingException;
//import com.cra.master.dto.ErrorMstDTO;

public abstract class BaseErrorFileVO extends BaseVO implements BaseOutputFileVO{

	protected String tagName = null;

	protected int errorCode;

	protected String errorDescription = null;

	protected String recordType = null;


	public BaseErrorFileVO(String tagName, int errorCode, String recordType) {
		super();
		this.tagName = tagName;
		this.errorCode = errorCode;
		this.recordType = recordType;
	}

	public BaseErrorFileVO() {
		super();
	}
	



	//CHANGED BY DEEPA: ERROR DESCRIPTION SHOULD NOT BE SET IMPLICITLY WHEN ERRORVO is being created. The Descritpion must be fetched just before the listof ErrorVOs is being printed in the ErrorFile
	/*private String fetchErrorDescriptionFromCache() {
		String desc = null;
		try {
			//HashMap map = ObjectCacheManager
				//	.getMasterData(CRAConstants.CACHE_ERROR_MASTER);
			//ErrorMstDTO dto = (ErrorMstDTO) map.get("" + this.errorCode);
			//if (dto != null)
			//	desc = dto.getErrorDescription();

		} catch (NamingException e) {
		}
		return desc;
	}
*/
	public BaseErrorFileVO(int errorCode) {
		this.errorCode = errorCode;
	}

	public int getErrorCode() {
		return errorCode;
	}

	public void setErrorCode(int errorCode) {
		this.errorCode = errorCode;
	}

	public String getErrorDescription() {
//		if (errorDescription == null) 
	//		errorDescription = fetchErrorDescriptionFromCache();  //if not avlbl in cache then read from cra-errorcodes_en.properties
		if (errorDescription == null) 
			errorDescription = CRAConfigReader.getErrorDescription(""+ this.errorCode);
		
		return errorDescription;
	}

	public String getRecordType() {
		return recordType;
	}

	public void setErrorDescription(String pDesc) {
		this.errorDescription = pDesc;
	}
	
	public void setRecordType(String recordType) {
		this.recordType = recordType;
	}

	public String getTagName() {
		return tagName;
	}

	public void setTagName(String tagName) {
		this.tagName = tagName;
	}
}
