package com.cra.contr.common.util.file;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

//import com.cra.common.util.CRALog;

public class CRAFileReader extends CRAFileOperations {

	private BufferedReader bufferedReader;

	/**
	 * Constructor takes file name with absolute path as an argument. The path should be start from root directory.
	 * @param absolutefileName
	 * @throws FileNotFoundException
	 */
	public CRAFileReader(String absolutefileName) throws FileNotFoundException {
		super(absolutefileName);
		bufferedReader = new BufferedReader(new FileReader(absolutefileName));
	}

	/**
	 * 
	 * @return Content of the next line in the file. If the end of the file is reached, it returns null.
	 * @throws IOException
	 */
	public String getLine() throws IOException {
		final String lineContent = bufferedReader.readLine();
		if (lineContent == null) {
			bufferedReader.close();
			return null;
		}
		return lineContent;
	}

	/**
	 * 
	 * @param regExpDelimiter This Delimiter should be given in regular expression. 
	 * 		For example, if ^ is the delimiter, then you should pass \\^ as the parameter
	 * @return Returns a String Array containing elements obtained after tokenizing the next line from the file. 
	 * 		The tokenizing is done using the regular expression of the delimiter provided as the input parameter to this method. 
	 * @throws IOException
	 */
	public String[] getLineAsArray(final String regExpDelimiter) throws IOException {

		final String lineContent = getLine();
		if (lineContent == null) {
			return null;
		}

		String[] lineAsArray = getLineParsed(lineContent, regExpDelimiter);

		return lineAsArray;
	}

	/**
	 * This method reads all the records starting from the point where it was stopped before. This method will convert every line to a String array. 
	 * Each String array contains the elements obtained by tokenizing the line using the input regular expression delimiter.
	 * @param regExpDelimiter
	 * @return returns an ArrayList of String arrays. Each String array representing a line in the file.
	 * @throws IOException
	 */
	public ArrayList<String[]> getAllLinesAsArrayInArrayList(final String regExpDelimiter) throws IOException {
		String tempStrArray[] = null;
		ArrayList<String[]> retArray = new ArrayList<String[]>();
		while ((tempStrArray = getLineAsArray(regExpDelimiter)) != null) {
			retArray.add(tempStrArray);
		}
		return retArray;
	}

	public ArrayList<String> getAllLinesInArrayList() throws IOException {
		bufferedReader = new BufferedReader(new FileReader(this.file));
		ArrayList<String> retArray = new ArrayList<String>();
		String tempStr = null;
		while ((tempStr = bufferedReader.readLine()) != null) {
			retArray.add(tempStr);
		}
		return retArray;
	}

	public static String[] getLineParsed(String lineToBeParsed, String regExpDelimiter) {

		String[] tempStr = lineToBeParsed.split(regExpDelimiter, lineToBeParsed.length());
		String[] lineAsArray = new String[tempStr.length];
		for (int i = 0; i < tempStr.length; i++) {
			lineAsArray[i] = (tempStr[i].length() == 0) ? null : tempStr[i];
		}

		return lineAsArray;
	}

	/**
	 * Read the whole file from the BEGINNING OF THE FILE and return the same in the form of String
	 * @return
	 * @throws IOException
	 */
	public String getFileContent() throws IOException {
		//CRALog.commonLog.info("Inside getFileContent()");
		long maximumBufferSize = CRAFileUtilConfig.getBUFFER_SIZE();
		//CRALog.commonLog.info("maximumBufferSize: " + maximumBufferSize);
		//CRALog.commonLog.info("file.length(): " + file.length());
		final long BufferSize = (file.length() > maximumBufferSize) ? maximumBufferSize  : file.length();
		//CRALog.commonLog.info("BufferSize: " + BufferSize);
		StringBuilder fileContent = new StringBuilder();
		BufferedInputStream buffStream = new BufferedInputStream(new FileInputStream(file), (int) BufferSize);
		byte temp[] = new byte[(int) BufferSize];
		int numLinesRead = -1;
		while ((numLinesRead = buffStream.read(temp)) != -1) {
			fileContent.append(new String(temp, 0, numLinesRead));
		}
		try {
			buffStream.close();
		} catch (Exception e) {

		}
		//CRALog.commonLog.info("End of getFileContent()");
		return fileContent.toString();
	}

	public byte[] getFileContentInBytes() throws IOException {

		final long BufferSize = file.length();
		BufferedInputStream buffStream = new BufferedInputStream(new FileInputStream(file), (int) BufferSize);
		byte temp[] = new byte[(int) BufferSize];

		buffStream.read(temp);
		buffStream.close();
		return temp;
	}

	public static void main(String a[]) {
		try {
			CRAFileReader r = new CRAFileReader("C:/test.txt");
			String content[] = null;
			int line = 0;
			while ((content = r.getLineAsArray("\\^")) != null) {
				line++;
				System.out.println("*************************************" + line + "**************************");
				for (int i = 0; i < content.length; i++) {
					System.out.println(content[i]);
				}
				System.out.println("*************************************" + line + "**************************");
			}

		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}
}
