package com.cra.contr.common.util.file;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;


public class CRABasicFileWriter extends CRAFileOperations {

	//private static HashMap<String, Object> configParameters = CRAFileUtilConfig.getConfigParameters();

	public CRABasicFileWriter(String absoluteFileName) {
		super(absoluteFileName);
	}

	/**
	 * 
	 * @param localAbsoluteFileName This is a destination file to be written with the content provided in the StringBuffer.
	 * @param fileContent The content which is to be written in to a file whose name is provided in the localAbsoluteFileName parameter
	 * @throws IOException 
	 * @throws IOException
	 */
	public static void writeFileLocal(final String absoluteFileNameLocal, final StringBuffer fileContent) throws IOException {
		File destFile = new File(absoluteFileNameLocal);
		if (!destFile.getParentFile().exists()) {
			destFile.getParentFile().mkdirs();
		}

		BufferedWriter buffWriter = null;
		try {
			if (!destFile.exists()) {
				destFile.createNewFile();
			}
			buffWriter = new BufferedWriter(new FileWriter(destFile));
			buffWriter.write(fileContent.toString());
		} catch (IOException e) {
			throw e;
		} finally {
			if (buffWriter != null) {
				buffWriter.flush();
				buffWriter.close();
			}
		}
	}

	public static void writeFileLocal(final String absoluteFileNameLocal, final byte[] fileContent) throws IOException {
		File destFile = new File(absoluteFileNameLocal);
		if (!destFile.getParentFile().exists()) {
			destFile.getParentFile().mkdirs();
		}

		BufferedWriter buffWriter = null;
		try {
			if (!destFile.exists()) {
				destFile.createNewFile();
			}
			buffWriter = new BufferedWriter(new FileWriter(destFile));
			buffWriter.write(fileContent.toString());
		} catch (IOException e) {
			throw e;
		} finally {
			if (buffWriter != null) {
				buffWriter.flush();
				buffWriter.close();
			}
		}
	}
	
	public static void writeFileLocal_OutputStream(final String absoluteFileNameLocal, final byte[] fileContent) throws IOException {
		File destFile = new File(absoluteFileNameLocal);
		if (!destFile.getParentFile().exists()) {
			destFile.getParentFile().mkdirs();
		}

		BufferedOutputStream buffOpStream = null;
		try{
		    if(!destFile.exists()){
			destFile.createNewFile();
		    }
		    buffOpStream = new BufferedOutputStream(new FileOutputStream(destFile));
		    buffOpStream.write(fileContent);
		} catch (IOException e) {
			throw e;
		} finally {
			if (buffOpStream != null) {
				buffOpStream.flush();
				buffOpStream.close();
			}
		}
	}
	
	
	/*public static void main(String fdafdsa[]){
	 CRAFileWriter cra = new CRAFileWriter("C:/test.txt");
	 long start = System.currentTimeMillis();
	 try {

	 CRAFileWriter.WriteFileRemote(new String[]{"C:\\Documents and Settings\\165130\\My Documents\\FTM Files\\17.txt"}, new String[]{"/nasmount/PAO/del.txt"});
	 } catch (IOException e) {
	 // TODO Auto-generated catch block
	 e.printStackTrace();
	 } catch (SystemException e) {
	 // TODO Auto-generated catch block
	 e.printStackTrace();
	 }
	 System.out.println("time taken: "+(System.currentTimeMillis() - start));

	 }*/
}
