package com.cra.contr.common.util.encrypt;
/*Note:For encrypting password :- 
 *while encrypting add spaces to make the length of pwd = 8 or multiples of 8...
 *encryption key shud have min length 8...
 */

import javax.crypto.*;
import javax.crypto.spec.*;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.*;
/**
 * 
 * Classname :PasswordEncryptDecrypt.java
 * 
 * Description :
 * 
 * @author TCS
 *
 * Date: Aug 9, 2007 3:20:40 PM
 *
 */
/*This class is used to encrypt and decrypt passwords used in CRA system. 
 * A seed is required to encrypt or decrypt. 
 * This seed should kept same across the CRA system.
 * 
 * This class uses DES algorithm
 */
public class PasswordEncryptDecrypt {

	public static String decrypt(String toBeDecrypted, String Seed) throws InvalidKeyException, InvalidKeySpecException, NoSuchAlgorithmException, IOException {
		
		byte[] dec = new sun.misc.BASE64Decoder().decodeBuffer(toBeDecrypted);
		
		int len = dec.length;
		//System.out.println("length: "+len);
		byte[] decrypted = new byte[len];
		
		SecretKey myKey = generateSecretKey(Seed);
		
		try {
			//generate the cipher object using DES algo
			Cipher c = Cipher.getInstance("DES/ECB/NoPadding");
			c.init(Cipher.DECRYPT_MODE, myKey);
			int bytecount = c.update(dec, 0, len, decrypted);
			c.doFinal();

		} catch (java.security.NoSuchAlgorithmException e) {
			System.out.println("NoSuchAlgorithmException " + e);
		} catch (javax.crypto.NoSuchPaddingException e) {
			System.out.println("NoSuchPaddingException " + e);
		} catch (java.security.InvalidKeyException e) {
			System.out.println("InvalidKeyException " + e);
		} catch (ShortBufferException e) {
			System.out.println("ShortBufferException " + e);
		} catch (IllegalStateException e) {
			System.out.println("IllegalStateException " + e);
		} catch (Exception e) {
			e.printStackTrace();
			System.out.println("Exception " + e);
		}
		String Base64Decoded = new String(decrypted, "UTF8");
		return (Base64Decoded.trim());
	}

	/**
	 * @param toBeEncrypt
	 * @param mykey
	 * @return
	 * @throws NoSuchAlgorithmException 
	 * @throws InvalidKeySpecException 
	 * @throws InvalidKeyException 
	 * @throws UnsupportedEncodingException 
	 */
	public static String encrypt(String Password, String Seed) throws InvalidKeyException, InvalidKeySpecException, NoSuchAlgorithmException, UnsupportedEncodingException {
		byte[] toBeEncrypt = Password.getBytes("UTF8");
		int len = toBeEncrypt.length;
		byte[] encrypted = new byte[len];

		SecretKey myKey = generateSecretKey(Seed);
		
		try {
			//generate a Cipher object
			Cipher itsocipher = Cipher.getInstance("DES/ECB/NoPadding");
			itsocipher.init(Cipher.ENCRYPT_MODE, myKey);
			int bytecount = itsocipher.update(toBeEncrypt, 0, len, encrypted);
			itsocipher.doFinal();

		} catch (java.security.NoSuchAlgorithmException e) {
			System.out.println("NoSuchAlgorithmException " + e);
		} catch (javax.crypto.NoSuchPaddingException e) {
			System.out.println("NoSuchPaddingException " + e);
		} catch (java.security.InvalidKeyException e) {
			System.out.println("InvalidKeyException " + e);
		} catch (ShortBufferException e) {
			System.out.println("ShortBufferException " + e);
		} catch (IllegalStateException e) {
			System.out.println("IllegalStateException " + e);
		} catch (Exception e) {
			e.printStackTrace();
			System.out.println("Exception " + e);
		}
		String Base64Encoded = new sun.misc.BASE64Encoder()
		.encode(encrypted);
		return (Base64Encoded);
	}
	private static SecretKey generateSecretKey(String Seed)
			throws InvalidKeyException, InvalidKeySpecException,
			NoSuchAlgorithmException {
		KeySpec keySpec = new DESKeySpec(Seed.getBytes());
		SecretKey key = SecretKeyFactory.getInstance("DES").generateSecret(
				keySpec);
		return key;
	}

	public static void main(String args[]) {
		try {
			String Password = "tata123$"; // Password should be padded with spaces to make its length equal to 8 or multiples of 8
			String Seed = "NPSCAN-CRA"; // This should contain minimum 8 characters. Seed is the key to decrypt the encrypted password.

			
			
			String Base64Encoded = encrypt(Password, Seed);
			
			System.out.println("length is : " + Base64Encoded.length());
			System.out.println("encrypted is :" + Base64Encoded);
			
			String toBeDecrypted = Base64Encoded;
			
			String Base64Decoded = decrypt(toBeDecrypted, Seed).trim();
			
			System.out.println("decrypted is :" + Base64Decoded);
			
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}