package com.cra.contr.common.util.encrypt;

public class NCRMod11Algorithm
{

	/**
	 * @param args
	 */
	public static void main(String[] args)
	{
		String pran = getNumberAppendedWithCheckDigit("1231231234");
		System.out.println("trsnId::::::"+pran);
		if(isValidNumber(pran))
		{
			System.out.println("Number is valid");
		}
		else
		{
			System.out.println("Number is invalid");
		}

	}
	
	public static boolean isValidNumber(String number)	
	{
		StringBuffer getString =new StringBuffer(number);		
		String firstCkDigit=getString.substring(2,3);		
		String secondCkDigit=getString.substring(4,5);		
		String originalCheckDigit=firstCkDigit.concat(secondCkDigit.toString());
		getString.replace(2, 3,"" );
		getString.replace(3, 4,"" );		
		getString.reverse();
		String checkDigit = calcCheckDigit(getString);		
		return(checkDigit.equals(originalCheckDigit));		
	}
	

	public static String getNumberAppendedWithCheckDigit(String Number)
	{		
		StringBuffer getString=new StringBuffer(Number);		
		getString.reverse();		
		String checkDigit = calcCheckDigit(getString);
		getString.reverse();
		
		String finalNo=getString.substring(0, 2).concat(checkDigit.substring(0,1)).concat(getString.substring(2,3)).concat(checkDigit.substring(1)).concat(getString.substring(3,getString.length()));
		
		return finalNo;
	}
	
	private static String calcCheckDigit(StringBuffer getString)
	{
		final StringBuffer mod11String=new StringBuffer("2345678923");
		int length=getString.length();
		int sum = 0,ckDigit = 0;
			
		for(int count=0;count<length;count++)
		{	
			sum =sum + ((getString.charAt(count)-'0') * (mod11String.charAt(count)-'0'));  	
		}		
		ckDigit=(11- (sum % 11))% 11;	
		
		String checkDigit=Integer.toString(ckDigit);
		if(checkDigit.charAt(0)=='0') 
		{
			checkDigit="00";
		}
		else if (checkDigit.length()==1 && checkDigit.charAt(0)!='0' )
		{
			checkDigit="0".concat(checkDigit);
		}
		return checkDigit;
    }


}