package com.cra.contr.common.util.encrypt;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;

import com.cra.contr.common.util.CRAConfigReader;
import com.cra.contr.common.util.CRAStringTokenizer;
import com.cra.pao.fvu.FvuConstants;

import cra.standalone.paosubcontr.PAOFvu;
 
/*
 ErrorVal	Remarks
 ------------------------
 0		Success (no errors)
 1		Input File not found
 2		Invalid Input File 
 (
 i. Empty record found 
 ii. At FVU file is having sam/scm info 
 iii. At svu uploadedby is not TFC and file is having sam/scm info
 )
 3		FVU Version is either Incorrect or NULL
 4		SAM Version is either Incorrect or NULL
 5		SCM Version is either Incorrect or NULL
 6		File Header Record Hash Code mismatch
 7		Record Level Hash Code mismatch
 8		Input File format Error 
 (	
 also if mismatch of number of in the input file.
 For a new file the last char in a record should be '^', 
 and for a file that is already hashed the last character should not be '^'
 )
 9		Mismatch of FVU File Level HashCode
 10		Mismatch of SAM File Level HashCode
 11		Mismatch of SCM File Level HashCode
 12		Unknown Error. Exception occured
 */
public class Hash
{
	private String fhString;
	private long fileLevelHC;
	private long fhHC;
	private long fvuFLH;
	private long samFLH;
	private long scmFLH;
	private long prn;
	private String filler = null;
	private String fvuVersion = null;
	private String samVersion = null;
	private String scmVersion = null;
	private int utilityLevel;
	private String inputFileName;
	private String outputFileName;
	private String recStr;
	private int fhFieldCount;
	private BufferedReader br = null;
	private int iErrCode;
	public final static int FVU = 0;
	public final static int SAM = 1;
	public final static int SCM = 2;
	public final static int CRA = 3;
	public final static int FC = 4;
	public final static int LEGACYDATA = 5;
	public final static int FVU_MIS = 6;
	public final static int MIS_UPLD = 7;
	private int recNo = 0;

	public int startProcessing(String inputFileName, String outputHashFile, int utilityLevel, int fhFieldCount)
	{
		this.inputFileName = inputFileName;
		this.outputFileName = outputHashFile;
		this.utilityLevel = utilityLevel;
		this.fhFieldCount = fhFieldCount;

		iErrCode = 0;
		try
		{
			File file = new File(inputFileName);
			if (file.exists() == false)
			{
				iErrCode = 1; // input file not found
				return iErrCode;
			}
			br = new BufferedReader(new FileReader(file));
			recStr = br.readLine();

			if (recStr == null || recStr.length() == 0)
			{
				iErrCode = 2; // empty record found
				return iErrCode;
			}
			tokenizeFileHeader();
			if (iErrCode == 2)
			{
				recNo = 1;
				return iErrCode; // Invalid input file
			}
			switch (utilityLevel)
			{
			case FVU:
				processFVU();
				break;
			case FVU_MIS:
				processFVUmis();
				break;
			case SAM :
				processSAM();
				break;
			case CRA:
				processCRA();
				break;
			case FC:
				processFC();
				break;
			case LEGACYDATA:
				processCRA();
				break;
			case MIS_UPLD:
				processFVUmis_FileHashed() ;
				break;
			}
			
		}
		catch (Exception e)
		{
			recNo = 1;
			iErrCode = 12; // unknown error. exception occured.
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (br != null)
					br.close();
			}
			catch (IOException e1)
			{
				e1.printStackTrace();
			}
		}
		return iErrCode;
	}

	// this method is called at FVU. If the file is not hashed then
	// processFVU_FileNotHashed is called. else processFVU_FileHashed is called.
	private boolean processFVU()
	{
		if (samVersion != null || samFLH > 0 || filler != null || prn > 0)
		{
			// In this case SAM version,SAM hash,SCM version,SCM hash
			// should not be present.
			recNo = 1;
			iErrCode = 2; // Invalid Input file
			return false;
		}
		if (fvuVersion == null && fvuFLH == 0 && fhHC == 0) 
		{
			return processFVU_FileNotHashed();
		}
		else
		{
			return processFVU_FileHashed();
		}
	}

	// this method is called at FVU for MIS. If the file is not hashed then
	// processFVU_FileNotHashed is called. else processFVU_FileHashed is called.
	private boolean processFVUmis()
	{
		//System.out.println("FVUVERSION and fvuFLH"+fvuVersion+"  &&& "+fvuFLH+"Filler--"+filler+"PRNNN"+prn+"and FHHC"+fhHC);
		if ( filler != null || prn > 0)
		{/*System.out.println("inside prn");
			recNo = 1;
			iErrCode = 2; // Invalid Input file
			return false;
		*/}
		if (fvuVersion == null && prn == 0 && fhHC == 0)
		{			
			return processFVUmis_FileNotHashed();
		}
		else
		{
			return processFVUmis_FileHashed();
		}

	}
 
	private boolean processFVUmis_FileHashed()
	{
		System.out.println("Inside MIS FVU file hashed");
		try
		{
			recNo = 1;
			long rlh;
			//System.out.println("fhString and fhHC"+fhString+" &&& "+fhHC+"and fvu file level hash in file"+prn);
			if (Boolean.valueOf(CRAConfigReader.getConfigVal("CRACENTRAL.FVU.IgnoreVersioning")).booleanValue() == false && Boolean.valueOf(CRAConfigReader.getConfigVal("CRACENTRAL.FVU.IgnoreRecordLevelHashing")).booleanValue() == false && fhHC != hashCode(fhString, true))
			{					
				iErrCode = 6; // File Header Hash Code mismatch
				return false;
			}

			// utility level check added to ignore version check for SAM and SCM

			if (utilityLevel == 6 || utilityLevel == 7)
			{
				if (Boolean.valueOf(CRAConfigReader.getConfigVal("CRACENTRAL.FVU.IgnoreVersioning")).booleanValue() == false && isValidFVUVersion_MIS(fvuVersion) == false)
				{
					iErrCode = 3; // Incorrect FVU Version
					return false;
				}
			}

			if (Boolean.valueOf(CRAConfigReader.getConfigVal("CRACENTRAL.FVU.IgnoreHashing")).booleanValue() == true)
				return true;

			//recStr = recStr.substring(0, recStr.lastIndexOf('^', recStr.lastIndexOf('^', recStr.lastIndexOf('^') - 1) - 1));
			recStr = recStr.substring(0, recStr.lastIndexOf('^')+1);			
			fileLevelHC = hashCode(recStr, true);


			if (Boolean.valueOf(CRAConfigReader.getConfigVal("CRACENTRAL.FVU.IgnoreRecordLevelHashing")).booleanValue() == false)
			{
				while ((recStr = br.readLine()) != null)
				{
					recNo++;
					if (recStr.charAt(recStr.length() - 1) == '^')				{
						iErrCode = 8; // Input File format Error
						return false;
					}
					try
					//	recStr.
					{/*//start

						String[] valueArray=recStr.split("\\^");
						if(valueArray[1].compareToIgnoreCase("RD")==0){
							//recStr = recStr.substring(0, recStr.lastIndexOf("^^", recStr.lastIndexOf('^') - 1));
						}
						System.out.println("recStr--"+recStr);
						
						rlh = Long.parseLong((recStr.substring(recStr.lastIndexOf('^')+1, recStr.length())).trim());
						System.out.println("rlh--"+rlh);
						
						recStr = recStr.substring(0, recStr.lastIndexOf('^'));
						System.out.println("hashcode of rlh"+hashCode(recStr, false));
						if(valueArray[1].compareToIgnoreCase("RD")==0){
							if(rlh != hashCode(recStr, false)){
								System.out.println("Inside iff 2");
								iErrCode = 7;
								// Record Level Hash Code mismatch at line: recNo
								return false;
							}

						}
						else if (rlh != hashCode(recStr, true))
						{
							iErrCode = 7;
							// Record Level Hash Code mismatch at line: recNo
							return false;
						}
						fileLevelHC += (recNo * rlh);
					//end */

						rlh = Long.parseLong((recStr.substring(recStr.lastIndexOf('^') + 1, recStr.length())).trim());
						recStr = recStr.substring(0, recStr.lastIndexOf('^'));												
						if (rlh != hashCode(recStr, true))
						{							
							iErrCode = 7;
							// Record Level Hash Code mismatch at line: recNo
							return false;
						}
						fileLevelHC += (recNo * rlh);
						
					}
					catch (NumberFormatException e)
					{
						e.printStackTrace();
						iErrCode = 6; // Input File format Error
						return false;
					}
				}
			}
			else
			{
				while ((recStr = br.readLine()) != null)
				{
					recNo++;
					recStr = recStr.substring(0, recStr.lastIndexOf('^'));
					fileLevelHC += (recNo * hashCode(recStr, true));
				}
			}		
			if (fileLevelHC != prn)
			{
				System.out.println("File Level HashCode of MIS File is incorrect");
				iErrCode = 9; // Mismatch of File Level HashCode
				return false;
			}
			return true;
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		return false;
	}


//	this method is called at SAM. If the file is hashed processFVU_FileHashed is called to verify hash.
	private boolean processSAM()
	{

		if (filler != null || prn > 0 || samVersion != null && samFLH > 0 || fvuVersion == null || fvuFLH == 0)
		{
			//in this case FVU version, FVU hash must be present and SAM version,SAM hash,SCM version,SCM hash 
			//should not be present.  
			recNo = 1;
			iErrCode = 2; //Invalid Input file
			return false;
		}

		if (samVersion == null && samFLH == 0)
		{
			return processFVU_FileHashed();
		}
		else
		{
			recNo = 1;
			iErrCode = 2; //Invalid Input file
			return false;
		}

	}

	// This method is called at CRA Central System.
	/*
	 * FH Record hash, FVU and SAM File hash codes are not verified FVU,SAM and
	 * SCM Versions are verified Record level hash verification is parameterized
	 * hashing and versioning verification are also parameterized
	 */
	private boolean processCRA()
	{
		boolean isTFC;
		long rlh;
		long recLevelHC;
		int k;
		long fvuFileLevelHC = 0;
		// long samFileLevelHC = 0;
		long scmFileLevelHC = 0;
		if (recStr.indexOf("^T^") != -1)
		{
			isTFC = true; // uploaded by is TFC
		}
		else
		{
			isTFC = false; // uploaded by is Filer
		}
		try
		{
			// if upload by is Filer and sam, scm details are present in the
			// file then reject the file...
			if (isTFC == false)
			{
				if (samVersion != null || samFLH > 0 || filler != null || prn > 0)
				{
					recNo = 1;
					iErrCode = 2; // Invalid File
					return false;
				}
			}
			else
			{
				if (scmVersion == null || scmFLH == 0)
				{
					recNo = 1;
					iErrCode = 2; // Invalid File
					return false;
				}
			}
			recNo = 1;

			if (isValidFVUVersion(fvuVersion) == false)
			{
				iErrCode = 3; // Incorrect FVU Version
				return false;
			}
			// if upload by is TFC then sam and scm details cannot be null

			if (isTFC == true)
			{
				/*if (isValidSAMVersion(samVersion) == false)
				{
					iErrCode = 4; //Incorrect SAM Version
					return false;
				}*/
				/*if (isValidSCMVersion(scmVersion) == false)
				{
					iErrCode = 5; //Incorrect SCM Version
					return false;
				}*/
			}

			k = recStr.lastIndexOf('^');
			recStr = recStr.substring(0, k);
			scmFileLevelHC = hashCode(recStr, true);
			k = recStr.lastIndexOf('^', k - 1);
			k = recStr.lastIndexOf('^', k - 1);
			recStr = recStr.substring(0, k);
			k = recStr.lastIndexOf('^', k - 1);
			k = recStr.lastIndexOf('^', k - 1);
			recStr = recStr.substring(0, k);

			fvuFileLevelHC = hashCode(recStr, true);
			fileLevelHC = 0;
			if (Boolean.valueOf(CRAConfigReader.getConfigVal("CRACENTRAL.FVU.IgnoreRecordLevelHashing")).booleanValue() == true)
			{
				while ((recStr = br.readLine()) != null)
				{
					recNo++;
					k = recStr.lastIndexOf('^');
					try
					{
						recLevelHC = Long.parseLong(recStr.substring(k + 1, recStr.length()));
					}
					catch (NumberFormatException e)
					{
						iErrCode = 6; // Input File format Error
						return false;
					}

					fileLevelHC += (recNo * recLevelHC);
				}
			}
			else
			{
				while ((recStr = br.readLine()) != null)
				{
					recNo++;
					k = recStr.lastIndexOf('^');
					try
					{
						recLevelHC = Long.parseLong(recStr.substring(k + 1, recStr.length()));

					}
					catch (NumberFormatException e)
					{
						iErrCode = 6; // Input File format Error
						return false;
					}

					recStr = recStr.substring(0, k);
					rlh = hashCode(recStr, true);
					if (rlh != recLevelHC)
					{
						iErrCode = 7;
						// mismatch of RecordLevel Hash Code at Record: recNo
						return false;
					}
					fileLevelHC += (recNo * recLevelHC);
				}
			}
			fvuFileLevelHC += fileLevelHC;
			if (isTFC == true)
			{
				scmFileLevelHC += fileLevelHC;
				// checking the details of scm
				if (scmFileLevelHC != scmFLH)
				{
					iErrCode = 11; // mismatch of SCM File Level HashCode
					return false;
				}
			}
			else
			{
				if (fvuFileLevelHC != fvuFLH)
				{
					iErrCode = 9; // mismatch of FVU File Level HashCode
					return false;
				}
			}
			return true;
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		return false;
	}

//	This method is called at CRA Central System when Upload By FC.
	/*
	 * FH Record hash, FVU and SAM File hash codes are not verified FVU,SAM and
	 * SCM Versions are verified Record level hash verification is parameterized
	 * hashing and versioning verification are also parameterized
	 */
	private boolean processFC()
	{
		if (samVersion == null || samFLH == 0 || fvuVersion == null || fvuFLH == 0 || filler != null || prn == 0)
		{
			/* This is a ELECTRONIC RETURN FILE. In this case SAM version,SAM hash, FVU version,
			 * FVU hash must be present and SCM version,SCM hash should not be present.
			 */
			recNo = 1;
			iErrCode = 2; //Invalid Input file
			return false;
		}
		else
		{
			return processSAM_FileHashed();
		}
	}

	private boolean processSAM_FileHashed()
	{

		long rlh;
		try
		{
			recNo = 1;

			if (isValidFVUVersion(fvuVersion) == false)
			{
				iErrCode = 3; // Incorrect FVU Version
				return false;
			}
			if (isValidSAMVersion(samVersion) == false)
			{
				iErrCode = 4; //Incorrect SAM Version
				return false;
			}


			if (Boolean.valueOf(CRAConfigReader.getConfigVal("CRACENTRAL.FVU.IgnoreHashing")).booleanValue() == true)
				return true;

			//recStr = recStr.substring(0, recStr.lastIndexOf('^', recStr.lastIndexOf('^', recStr.lastIndexOf('^') - 1) - 1));
			recStr = recStr.substring(0, recStr.lastIndexOf('^'));
			fileLevelHC = hashCode(recStr, true);
			if (Boolean.valueOf(CRAConfigReader.getConfigVal("CRACENTRAL.FVU.IgnoreRecordLevelHashing")).booleanValue() == false)
			{
				while ((recStr = br.readLine()) != null)
				{
					recNo++;
					if (recStr.charAt(recStr.length() - 1) == '^')
					{
						iErrCode = 8; //Input File format Error
						return false;
					}
					try
					{
						rlh = Long.parseLong((recStr.substring(recStr.lastIndexOf('^') + 1, recStr.length())).trim());
						recStr = recStr.substring(0, recStr.lastIndexOf('^'));
						if (rlh != hashCode(recStr, true))
						{
							iErrCode = 7; //Record Level Hash Code mismatch at line: recNo
							return false;
						}
						fileLevelHC += (recNo * rlh);
					}
					catch (NumberFormatException e)
					{
						iErrCode = 6; //Input File format Error
						return false;
					}
				}
			}
			else
			{
				while ((recStr = br.readLine()) != null)
				{
					recNo++;
					recStr = recStr.substring(0, recStr.lastIndexOf('^'));
					fileLevelHC += (recNo * hashCode(recStr, true));
				}
			}

			if (fileLevelHC != samFLH)
			{
				iErrCode = 10; //Mismatch of SAM Level HashCode
				return false;
			}
			return true;
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		return false;

	}

	private boolean processFVU_FileNotHashed()
	{
		long rlh = 0;
		recNo = 1;
		boolean retVal = true;
		BufferedWriter hf = null;
		RandomAccessFile raf = null;
		try
		{
			hf = new BufferedWriter(new FileWriter(outputFileName));
			recStr = getFileHeader(CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion"));
			//Added for CR 23214
			CRAStringTokenizer st2 = new CRAStringTokenizer(recStr, "^");
			String recType = st2.nextToken();
			recType = st2.nextToken();
			recType = st2.nextToken();
			hf.write(recStr);
			hf.write('^');
			fileLevelHC = hashCode(recStr, true);
			hf.write(get20digitHashCode(fileLevelHC));
			//Modified For CR-58405
			if(!recType.equals(FvuConstants.UPLOADED_BY_AO) && !recType.equals(FvuConstants.UPLOADED_BY_PRAO) && !recType.equals(FvuConstants.UPLOADED_BY_KA)  && !recType.equals(FvuConstants.UPLOADED_BY_AO_UPS)  && !recType.equals(FvuConstants.UPLOADED_BY_PRAO_UPS))
				hf.write("^^^^");
			hf.write('\n');
			if((recStr = br.readLine()) != null){
				recNo++;
				if (recStr.charAt(recStr.length() - 1) != '^')
				{
					iErrCode = 8; // Input File format Error
					retVal = false;
					return retVal;
				}
				String newBatchID = null;
				String oldBatchID = null;
				CRAStringTokenizer bh = new CRAStringTokenizer(recStr, "^");
				String recType1 = bh.nextToken();
				recType1 = bh.nextToken();
				if(recType1.equals(FvuConstants.BH_REC)){
					recType1 = bh.nextToken();
					recType1 = bh.nextToken();
					String AIN = bh.nextToken();
					recType1 = bh.nextToken();
					oldBatchID = bh.nextToken();
		            long time = System.currentTimeMillis();
		            String entity_ain = AIN;
		            String con = entity_ain + time;
		            newBatchID = con;
		            //Added For CR-34438 to set old batch id .START
		            newBatchID=oldBatchID;
		          //Added For CR-34438 to set old batch id .END
		            PAOFvu.batchId = newBatchID;
				}
				String BH=recStr.replace(oldBatchID, newBatchID); 
				hf.write(BH);
				rlh = hashCode(BH, false);
				fileLevelHC += (recNo * rlh);
				hf.write(get20digitHashCode(rlh));
				hf.write('\n');
			}
			while ((recStr = br.readLine()) != null)
			{
				recNo++;
				if (recStr.charAt(recStr.length() - 1) != '^')
				{
					iErrCode = 8; // Input File format Error
					retVal = false;
					break;
				}
				hf.write(recStr);
				rlh = hashCode(recStr, false);
				fileLevelHC += (recNo * rlh);
				hf.write(get20digitHashCode(rlh));
				hf.write('\n');
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}

		finally
		{
			try
			{
				if (hf != null)
				{
					hf.close();
					if (retVal == false)
					{
						File f = new File(outputFileName);
						f.delete();
					}
				}
			}
			catch (IOException e)
			{
				e.printStackTrace();
			}
		}
		if (retVal == true)
		{
			try
			{
				raf = new RandomAccessFile(outputFileName, "rw");
				raf.seek(fhString.length() + 3 + Integer.valueOf(CRAConfigReader.getConfigVal("CRACENTRAL.FVU.MaxHashCodeLength")).intValue() + fvuVersion.length());
				raf.writeBytes(get20digitHashCode(fileLevelHC));
			}
			catch (IOException e1)
			{
				e1.printStackTrace();
			}
			finally
			{
				if (raf != null)
				{
					try
					{
						raf.close();
					}
					catch (IOException e2)
					{
						e2.printStackTrace();
					}
				}
			}
		}
		return retVal;
	}


	private boolean processFVUmis_FileNotHashed()
	{
		System.out.println("Inside MIS FVU file not hashed");
		long rlh = 0;
		recNo = 1;
		boolean retVal = true;
		BufferedWriter hf = null;
		RandomAccessFile raf = null;
		try
		{
			hf = new BufferedWriter(new FileWriter(outputFileName));
			recStr = getFileHeader(CRAConfigReader.getConfigVal("MIS.FVU.FVUVersion"));
			recStr=recStr.concat("^^^");	
			hf.write(recStr);		
			fileLevelHC = hashCode(recStr, true);		
			hf.write(get20digitHashCode(fileLevelHC));
			//hf.write("^^");
			hf.write('\n');
		
			while ((recStr = br.readLine()) != null)
			{
				recNo++;
				if (recStr.charAt(recStr.length() - 1) != '^')
				{
					iErrCode = 8; // Input File format Error
					retVal = false;
					break;
				}
				String[] valueArray=recStr.split("\\^");
				if(valueArray[1].compareToIgnoreCase("RD")==0){
					if (recStr.charAt(recStr.length() - 1) != '^')
					{
						iErrCode = 8; // Input File format Error
						retVal = false;
						break;
					}
					//recStr=recStr.substring(0, recStr.lastIndexOf("^^^"));					
					hf.write(recStr);					
					//	hf.write('^');					
				}else{
					hf.write(recStr);
				}
				rlh = hashCode(recStr, false);
				fileLevelHC += (recNo * rlh);
				hf.write(get20digitHashCode(rlh));
				/*if(valueArray[1].compareToIgnoreCase("RD")==0){
					hf.write("^^");
				}*/
				hf.write('\n');
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}

		finally
		{
			try
			{
				if (hf != null)
				{
					hf.close();
					if (retVal == false)
					{
						File f = new File(outputFileName);
						f.delete();
					}
				}
			}
			catch (IOException e)
			{
				e.printStackTrace();
			}
		}
		if (retVal == true)
		{
			try
			{
				raf = new RandomAccessFile(outputFileName, "rw");
				raf.seek(fhString.length() + 5 + Integer.valueOf(CRAConfigReader.getConfigVal("CRACENTRAL.FVU.MaxHashCodeLength")).intValue() + fvuVersion.length());		
				raf.writeBytes(get20digitHashCode(fileLevelHC));
			}
			catch (IOException e1)
			{
				e1.printStackTrace();
			}
			finally
			{
				if (raf != null)
				{
					try
					{
						raf.close();
					}
					catch (IOException e2)
					{
						e2.printStackTrace();
					}
				}
			}
		}
		return retVal;
	}

	private boolean processFVU_FileHashed()
	{
		try
		{
			recNo = 1;
			long rlh;

			if (Boolean.valueOf(CRAConfigReader.getConfigVal("CRACENTRAL.FVU.IgnoreVersioning")).booleanValue() == false && Boolean.valueOf(CRAConfigReader.getConfigVal("CRACENTRAL.FVU.IgnoreRecordLevelHashing")).booleanValue() == false && fhHC != hashCode(fhString, true))
			{
				iErrCode = 6; // File Header Hash Code mismatch
				return false;
			}

			// utility level check added to ignore version check for SAM and SCM

			if (utilityLevel == 0 || utilityLevel == 3 || utilityLevel == 5)
			{
				if (Boolean.valueOf(CRAConfigReader.getConfigVal("CRACENTRAL.FVU.IgnoreVersioning")).booleanValue() == false && isValidFVUVersion(fvuVersion) == false)
				{
					iErrCode = 3; // Incorrect FVU Version
					return false;
				}
			}

			if (Boolean.valueOf(CRAConfigReader.getConfigVal("CRACENTRAL.FVU.IgnoreHashing")).booleanValue() == true)
				return true;

			recStr = recStr.substring(0, recStr.lastIndexOf('^', recStr.lastIndexOf('^', recStr.lastIndexOf('^', recStr.lastIndexOf('^', recStr.lastIndexOf('^') - 1) - 1) - 1) - 1));

			fileLevelHC = hashCode(recStr, true);


			if (Boolean.valueOf(CRAConfigReader.getConfigVal("CRACENTRAL.FVU.IgnoreRecordLevelHashing")).booleanValue() == false)
			{
				while ((recStr = br.readLine()) != null)
				{
					recNo++;
					if (recStr.charAt(recStr.length() - 1) == '^')
					{
						iErrCode = 8; // Input File format Error
						return false;
					}
					try
					{
						rlh = Long.parseLong((recStr.substring(recStr.lastIndexOf('^') + 1, recStr.length())).trim());
						recStr = recStr.substring(0, recStr.lastIndexOf('^'));
						if (rlh != hashCode(recStr, true))
						{
							iErrCode = 7;
							// Record Level Hash Code mismatch at line: recNo
							return false;
						}
						fileLevelHC += (recNo * rlh);
					}
					catch (NumberFormatException e)
					{
						iErrCode = 6; // Input File format Error
						return false;
					}
				}
			}
			else
			{
				while ((recStr = br.readLine()) != null)
				{
					recNo++;
					recStr = recStr.substring(0, recStr.lastIndexOf('^'));
					fileLevelHC += (recNo * hashCode(recStr, true));
				}
			}
			if (fileLevelHC != fvuFLH)
			{
				System.out.println("incorrect fileLevelHC" +fileLevelHC);
				iErrCode = 9; // Mismatch of File Level HashCode
				return false;
			}
			return true;
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		return false;
	}

	public long hashCode(String recStr, boolean includeCaret)
	{
		long hc = 0;
		int i = 0;
		for (; i < recStr.length(); i++)
		{
			hc += (((int) recStr.charAt(i)) * (i + 1));
		}
		if (includeCaret == true)
			hc += ((i + 1) * ((int) '^'));
		return hc;
	}

	public String get20digitHashCode(long hashCode)
	{
		String hashCodeStr = Long.toString(hashCode);
		StringBuffer sb = new StringBuffer();
		for (int i = hashCodeStr.length(); i < Integer.valueOf(CRAConfigReader.getConfigVal("CRACENTRAL.FVU.MaxHashCodeLength")).intValue(); i++)
			sb.append('0');
		sb.append(hashCodeStr);
		return sb.toString();
	}

	public String get15digitHashCode(long hashCode)
	{
		String hashCodeStr = Long.toString(hashCode);
		StringBuffer sb = new StringBuffer();
		for (int i = hashCodeStr.length(); i < Integer.valueOf(CRAConfigReader.getConfigVal("CRACENTRAL.FC.MaxHashCodeLength")).intValue(); i++)
			sb.append('0');
		sb.append(hashCodeStr);
		return sb.toString();
	}
	private String getFileHeader(String pfvuVersion)
	{
		
		StringBuffer sb = new StringBuffer(fhString);
		sb.append('^');
		sb.append(get20digitHashCode(hashCode(fhString, true)));
		sb.append('^');
		fvuVersion = pfvuVersion ;
		sb.append(fvuVersion);
		
		return sb.toString();
	}

	/*private boolean isValidFVUVersion(String fvu)
	{
		if (fvu == null)
			return false;

		if (CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion").trim().equals(fvu.trim()))
		{
			return true;
		}	
		return false;

	}*/

	private boolean isValidFVUVersion(String fvu)
	{
		String FVUversion = null;
		ArrayList<String> fvuVer = new ArrayList<String>();


		if (fvu == null)
			return false;

		FVUversion =CRAConfigReader.getConfigVal("AllowedVersions.of.FVUpaosubcontr.with.CentralSystem");
		System.out.println("FVUversion"+FVUversion);
		CRAStringTokenizer st = new CRAStringTokenizer(FVUversion, ",");
		String tokstr = st.nextToken();
		while (tokstr != null)
		{
			fvuVer.add(tokstr);
			tokstr = st.nextToken();
		}

		for (int i = 0; i <fvuVer.size(); i++)
		{
			if (fvuVer.get(i).trim().equals(fvu.trim()))
				return true;
		}
		return false;

	}

	private boolean isValidFVUVersion_MIS(String fvu)
	{
		String FVUversion = null;
		ArrayList<String> fvuVer = new ArrayList<String>();


		if (fvu == null)
			return false;

		FVUversion =CRAConfigReader.getConfigVal("AllowedVersions.of.craFVUmis.with.CentralSystem");
		CRAStringTokenizer st = new CRAStringTokenizer(FVUversion, ",");
		String tokstr = st.nextToken();
		while (tokstr != null)
		{
			fvuVer.add(tokstr);
			tokstr = st.nextToken();
		}

		for (int i = 0; i <fvuVer.size(); i++)
		{
			if (fvuVer.get(i).trim().equals(fvu.trim()))
				return true;
		}
		return false;

	}

	private boolean isValidSAMVersion(String sam)
	{
		String SAMversion = null;
		ArrayList<String> samVer = new ArrayList<String>();


		if (sam == null)
			return false;

		SAMversion =CRAConfigReader.getConfigVal("AllowedVersions.of.SAM.with.CentralSystem");
		//System.out.println("SAMversion "+SAMversion); 
		CRAStringTokenizer st = new CRAStringTokenizer(SAMversion, ",");
		String tokstr = st.nextToken();
		while (tokstr != null)
		{
			samVer.add(tokstr);
			tokstr = st.nextToken();
		}

		for (int i = 0; i <samVer.size(); i++)
		{
			//System.out.println("samVer.size()  "+samVer.size());
			if (samVer.get(i).trim().equals(sam.trim()))
				return true;

		}
		return false;
	}

	private void tokenizeFileHeader() throws Exception
	{
		StringBuffer sb = null;
		try
		{			
			CRAStringTokenizer st = new CRAStringTokenizer(recStr, "^");
			sb = new StringBuffer();
			String tokstr = st.nextToken();
			//Added for CR 23214
			CRAStringTokenizer st1 = new CRAStringTokenizer(recStr, "^");
			String recType = st1.nextToken();
			recType = st1.nextToken();
			recType = st1.nextToken();
			int tok = 0;
			int fhHCIndex = 0;
			//Modified For CR-58405
			if(recType.equals(FvuConstants.UPLOADED_BY_AO) || recType.equals(FvuConstants.UPLOADED_BY_PRAO) || recType.equals(FvuConstants.UPLOADED_BY_KA) || recType.equals(FvuConstants.UPLOADED_BY_AO_UPS) || recType.equals(FvuConstants.UPLOADED_BY_PRAO_UPS))
				fhHCIndex = 9 + 1;
			else{
				fhHCIndex = fhFieldCount + 1;
			}
			int fvuVersionIndex = fhHCIndex + 1;
			int fvuFLHIndex = fvuVersionIndex + 1;
			int fillerIndex = fvuFLHIndex + 1;
			int prnIndex = fillerIndex + 1;
			int samVersionIndex = prnIndex + 1;
			int samFLHIndex = samVersionIndex + 1;
			//int scmVersionIndex = samFLHIndex + 1;
			//int scmFLHIndex = scmVersionIndex + 1;
			while (tokstr != null)
			{
				tok++;
				if (tok < fhHCIndex)
				{
					sb.append(tokstr);
					//Modified For CR-58405
					if(recType.equals(FvuConstants.UPLOADED_BY_AO) || recType.equals(FvuConstants.UPLOADED_BY_PRAO) || recType.equals(FvuConstants.UPLOADED_BY_KA)  || recType.equals(FvuConstants.UPLOADED_BY_AO_UPS) || recType.equals(FvuConstants.UPLOADED_BY_PRAO_UPS)){
						if (tok != 9)
							sb.append('^');
					}else{
						if (tok != fhFieldCount)
							sb.append('^');
					}
					if (tok == 2)
					{
						if (!tokstr.equals("FH"))
						{
							iErrCode = 2;
							// throw new Exception("Invalid File");
							break;
						}
					}
				}
				else if (tok == fhHCIndex)
				{
					try
					{
						if (!tokstr.equals("") )
						{
							fhHC = Long.parseLong(tokstr);
						}
						}
					catch (NumberFormatException e)
					{	
						
						iErrCode = 2;
						break;
					}
				}
				else if (tok == fvuVersionIndex && tokstr.length() > 0)
				{ 
					fvuVersion = tokstr;
				}
				else if (tok == fvuFLHIndex)
				{
					try
					{
						if (!tokstr.equals("") )
						{							
						fvuFLH = Long.parseLong(tokstr);
						}
					}
					catch (NumberFormatException e)
					{
						System.out.println("file level hash incorrect");
						
						iErrCode = 2;
						break;
					}
				}
				else if (tok == fillerIndex && tokstr.length() > 0)
				{
					try
					{
						filler = tokstr;
						System.out.println("filler from file:" + filler);
					}
					catch (NumberFormatException e)
					{
					}
				}
				else if (tok == prnIndex)
				{
					try
					{
						if (!tokstr.equals("") )
						{
						prn = Long.parseLong(tokstr);
						System.out.println("prn from file:" + prn);
						}
					}
					catch (NumberFormatException e)
					{
						iErrCode = 2;
						break;
					}
				}
				else if (tok == samVersionIndex && tokstr.length() > 0)
				{
					samVersion = tokstr;
					System.out.println("samVersion from file:" + samVersion);
				}
				else if (tok == samFLHIndex)
				{
					try
					{
						if (!tokstr.equals("") ){
						samFLH = Long.parseLong(tokstr);
						System.out.println("samFLH from file :" + samFLH);
						}
					}
					catch (NumberFormatException e)
					{
						iErrCode = 2;
						break;
					}
				}
				/*else if (tok == scmVersionIndex && tokstr.length() > 0)
				{
					scmVersion = tokstr;
				}
				else if (tok == scmFLHIndex)
				{
					try
					{
						scmFLH = Long.parseLong(tokstr);
					}
					catch (NumberFormatException e)
					{
					}
				}*/
				tokstr = st.nextToken();
			}
		}
		catch (Exception e)
		{
			iErrCode = 2;
			e.printStackTrace();
		}
		finally
		{
			if (sb.length() > 0)
			{
				fhString = sb.toString();
			}
		}
	}

	public int getRecordNumber()
	{
		return recNo;
	}
}

