package com.cra.contr.common.util;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;

//import org.apache.log4j.Logger;

import com.cra.contr.common.util.file.CRABasicFileWriter;
import com.cra.contr.framework.vo.BaseErrorFileVO;
import com.cra.contr.framework.vo.BaseOutputFileVO;

public class HtmlFileGenerator {

    //protected final static Logger log=CRALog.commonLog;
 
    private final String []htmlFileContentSkeleton = {"<HTML>" +
    		"<HEAD><TITLE>{0}</TITLE></HEAD><STYLE type=\"text/css\"> .tdColumnDetails '{text-align: center;}' " +
    		".text '{COLOR : #000000;FONT-FAMILY : Verdana, Arial, Helvetica, sans-serif;FONT-SIZE : 10pt;FONT-WEIGHT : normal;}'" +
    		".tabledetails'{BACKGROUND-COLOR : #EEEECC;COLOR :  #000000;FONT-FAMILY : helvetica, serif, Arial;FONT-SIZE : 10pt;FONT-WEIGHT : bold;}' " +
    		".table '{BACKGROUND-COLOR : #006699;COLOR : white;FONT-FAMILY : helvetica, serif, Arial;FONT-SIZE : 10pt;FONT-WEIGHT : normal;}' " +
    		".H2'{FONT-WEIGHT: bold;FONT-SIZE: 12pt;MARGIN: 5px;COLOR: #006699;FONT-FAMILY: Arial, Helvetica, sans-serif;TEXT-ALIGN: center}'</STYLE>" +
    		"<BODY><p class=H2>{1}<!-- FIlE HEADING --></p><BR>" +
    		"<TABLE border=1 class=table>" +
    		"<!-- TABLE HEADER -->{2}" +
    		"<!-- TABLE BODY-->{3}</TABLE>" +
    		"<!-- LEGENDS -->{4}</BODY></HTML>" , "<HTML>" +
    		"<HEAD><TITLE>{0}</TITLE></HEAD><STYLE type=\"text/css\"> .tdColumnDetails '{text-align: center;}' " +
    		".text '{COLOR : #000000;FONT-FAMILY : Verdana, Arial, Helvetica, sans-serif;FONT-SIZE : 10pt;FONT-WEIGHT : normal;}'" +
    		".tabledetails'{BACKGROUND-COLOR : #EEEECC;COLOR :  #000000;FONT-FAMILY : helvetica, serif, Arial;FONT-SIZE : 10pt;FONT-WEIGHT : bold;}' " +
    		".table '{BACKGROUND-COLOR : #006699;COLOR : white;FONT-FAMILY : helvetica, serif, Arial;FONT-SIZE : 10pt;FONT-WEIGHT : normal;}' " +
    		".H2'{FONT-WEIGHT: bold;FONT-SIZE: 12pt;MARGIN: 5px;COLOR: #006699;FONT-FAMILY: Arial, Helvetica, sans-serif;TEXT-ALIGN: center}'</STYLE>" +
    		"<BODY><p class=H2>{1}<!-- FIlE HEADING --></p><BR>" +
    		"<Pclass=H3><CENTER>{5}</p><BR>"+
    		"<CENTER><TABLE border=1 class=table>" +
    		"<!-- TABLE HEADER -->{2}" +
    		"<!-- TABLE BODY-->{3}</TABLE></CENTER>" +
    		"<!-- LEGENDS -->{4}</BODY></HTML>"};

    public void generateHtmlErrorFile(ArrayList errorDataList, String htmlErrorFileTitle, String fileHeading, String tableHeaderString, String legends, String errorFileName) throws IOException {

	//log.debug("*********** Entering generateHtmlErrorFile*****************************");

	try {
	    StringBuffer tableBodyString = new StringBuffer();
	    BaseErrorFileVO errorFileVO = null;

	    for (int i = 0; i < errorDataList.size(); i++){
		errorFileVO = (BaseErrorFileVO)errorDataList.get(i);
		tableBodyString.append(errorFileVO.toHtml());
	    }
	    String fileContent = MessageFormat.format(htmlFileContentSkeleton[0], new Object[]{htmlErrorFileTitle, fileHeading, tableHeaderString, tableBodyString, legends});

	    CRABasicFileWriter.writeFileLocal(errorFileName, new StringBuffer(fileContent));

	    //log.debug("*********** Exiting generateHtmlErrorFile*****************************");

	} catch (IOException e) {
	    //log.error(" Exception in HtmlFileGenerator.java generateHtmlErrorFile Method : " , e);
	    throw e;
	}finally{
	    //log.info("*********** Exiting generateHtmlErrorFile*****************************");
	}
    }
    

    public void generateHtmlFile(ArrayList listOutputFileVO, String htmlFileTitle, String fileHeading, String tableHeaderString, String legends, String htmlFileName) throws IOException {

    	//log.debug("*********** Entering generateHtmlFile*****************************");

    	try {
    	    StringBuffer tableBodyString = new StringBuffer();
    	    BaseOutputFileVO outputFileVO = null;

    	    for (int i = 0; i < listOutputFileVO.size(); i++){
    	    	outputFileVO = (BaseOutputFileVO)listOutputFileVO.get(i);
    		tableBodyString.append(outputFileVO.toHtml());
    	    }
    	    String fileContent = MessageFormat.format(htmlFileContentSkeleton[0], new Object[]{htmlFileTitle, fileHeading, tableHeaderString, tableBodyString, legends});

    	    CRABasicFileWriter.writeFileLocal(htmlFileName, new StringBuffer(fileContent));

    	    //log.debug("*********** Exiting generateHtmlFile*****************************");

    	} catch (IOException e) {
    	    //log.error(" Exception in HtmlFileGenerator.java generateHtmlFile Method : " , e);
    	    throw e;
    	}finally{
    	    //log.info("*********** Exiting generateHtmlFile*****************************");
    	}
        }
    
    
    
    
    //New methods added for extra parameter subheading
    
    
    
    
    public void generateHtmlErrorFile(ArrayList errorDataList, String htmlErrorFileTitle, String fileHeading, String tableHeaderString, String legends, String errorFileName , String subHeading) throws IOException {

    	
    	try {
    	    StringBuffer tableBodyString = new StringBuffer();
    	    BaseErrorFileVO errorFileVO = null;

    	    for (int i = 0; i < errorDataList.size(); i++){
    		errorFileVO = (BaseErrorFileVO)errorDataList.get(i);
    		tableBodyString.append(errorFileVO.toHtml());
    	    }
    	    String fileContent = MessageFormat.format(htmlFileContentSkeleton[1], new Object[]{htmlErrorFileTitle, fileHeading, tableHeaderString, tableBodyString, legends,subHeading});

    	    CRABasicFileWriter.writeFileLocal(errorFileName, new StringBuffer(fileContent));

    	   

    	} catch (IOException e) {
    	    
    	    throw e;
    	}finally{
    	    
    	}
        }
        

        public void generateHtmlFile(ArrayList listOutputFileVO, String htmlFileTitle, String fileHeading, String tableHeaderString, String legends, String htmlFileName , String subHeading) throws IOException {

        	

        	try {
        	    StringBuffer tableBodyString = new StringBuffer();
        	    BaseOutputFileVO outputFileVO = null;

        	    for (int i = 0; i < listOutputFileVO.size(); i++){
        	    	outputFileVO = (BaseOutputFileVO)listOutputFileVO.get(i);
        		tableBodyString.append(outputFileVO.toHtml());
        	    }
        	    String fileContent = MessageFormat.format(htmlFileContentSkeleton[1], new Object[]{htmlFileTitle, fileHeading, tableHeaderString, tableBodyString, legends , subHeading});

        	    CRABasicFileWriter.writeFileLocal(htmlFileName, new StringBuffer(fileContent));

        	    
        	} catch (IOException e) {
        	    
        	    throw e;
        	}finally{
        	    
        	}
            }
        
    }
    
    
 // END OF CLASS HtmlFileGenerator.java