package com.cra.contr.common.util;

import java.io.File;
import java.util.*;


public class CommonValidation {
	//	VALIDATE STRING AS INTEGER
	/**
	 * This method performs validations on a field to check if the field is
	 * Integer or not.
	 *
	 * @param field-> String value passed by calling this method on the data to be validated.
	 * @return boolean
	 */
	public static boolean isInt(String field) {

		if (field.trim() == "" || field.trim().length() == 0) {
			return true;
		}
		for (int i = 0; i < field.length(); i++) {
			if (field.charAt(i) < 32 || field.charAt(i) > 127) {
				return true;
			}
		}
		try {
			Long.parseLong(field.trim());
		} catch (Exception e) {
			return true;
		}

		if (Long.parseLong(field.trim()) < 0) {
			return true;
		}
		return (false);
	}

	//	VALIDATE YEAR AS A LEAP YEAR
	private static boolean isLeap(int year) {

		return ((year % 4 == 0) && (year % 100 != 0 || year % 400 == 0));
	}

	protected static boolean checkValidation(int iYear, int iMonth, int iDay) {

		if ((iYear < 1200) || (iYear > 3099)) {
			return false;
		}
		if ((iDay < 1) || (iDay > 31) || (iMonth < 1) || (iMonth > 12)) {
			return false;
		}
		if (!isLeap(iYear) && (iMonth == 2) && (iDay > 28)) {
			return false;
		}
		if (isLeap(iYear) && (iMonth == 2) && (iDay > 29)) {
			return false;
		}
		if (((iMonth == 4) || (iMonth == 6) || (iMonth == 9) || (iMonth == 11))
				&& (iDay > 30)) {
			return false;
		}
		return true;
	}

	//	VALIDATE STRING AS DECIMAL
	static boolean isDecimal(String data, int Precision) {

		String field = data.trim();
		boolean error = false;
		if (field.trim() == "" || field.trim().length() == 0) {
			return true;
		}
		for (int i = 0; i < data.length(); i++) {
			if ((data.charAt(i) < 32 || data.charAt(i) > 127)) {
				return true;
			}
		}

		try {
			Double.parseDouble(field);
		} catch (Exception e) {
			error = true;
			return error;
		}

		int pointCounter = 0;
		int decimalPosition = 0;
		int length = field.length();
		for (int j = 0; j < length; j++) {
			if (!(Character.isDigit(field.charAt(j)))) {
				if (field.charAt(j) == '.') {
					pointCounter++;
					decimalPosition = j;
				} else {
					error = true;
				}
			}
		}
		if (field.charAt(0) == '.') {
			return true;
		}
		if (pointCounter == 0) {
			error = true;
		} else {
			if (Precision == (length - 1) - decimalPosition) {
				error = false;
			} else {
				error = true;
			}
		}
		if (pointCounter > 1) {
			error = true;
		}
		return error;
	}

	// VALIDATE STRING AS NULL
	/**
	 * This method checks if a field is having any value or not.
	 * @param text-> String value passed by calling this method on the data to be validated.
	 * @return boolean
	 */
	static boolean isFieldNull(String text) {

		if (text.trim() == "" || text.trim().length() == 0) {
			return true;
		}
		if (text.length() == 0) {
			return (true);
		} else {
			return (false);
		}
	}

	// VALIDATE DATE
	public static boolean isDate(String date1) //date in ddmmyyyy form
	{
		if (date1.trim() == "" || date1.trim().length() == 0
				|| date1.trim().length() != 8 || date1.length() != 8) {
			return true;
		}
		boolean errorDate;
		String dd = date1.substring(0, 2);
		String mm = date1.substring(2, 4);
		String yy = date1.substring(4, 8);
		try {
			if (checkValidation(Integer.parseInt(yy), Integer.parseInt(mm),
					Integer.parseInt(dd))) {
				errorDate = false;
			} else {
				errorDate = true;
			}
		} catch (Exception e) {
			errorDate = true;
		}
		return errorDate;
	}

	//	VALIDATE STRING AS ALPHANUMERIC
	public static boolean isAlphaNum(String data) {
		String field = data.trim();
		if (field.trim() == "" || field.trim().length() == 0) {
			return true;
		}
		for (int j = 0; j < field.length(); j++) {
			if (!Character.isLetterOrDigit(field.charAt(j))) {
				return true;
			}
		}
		return false;
	}

	//	VALIDATE STRING AS VALID CHARACTER STRING
	static boolean isValidCharString(String dataString) {
		if (dataString.trim() == "" || dataString.trim().length() == 0) {
			return true;
		}
		for (int i = 0; i < dataString.length(); i++) {
			if ((dataString.charAt(i) < 32 || dataString.charAt(i) > 127)) {
				return true;
			}
		}
		return false;
	}

	// VALIDATE CRR NUMBER
	static boolean isValidCrrNumber(String RRR_No) {
		try {
			Long.parseLong(RRR_No.trim());
		} catch (Exception e) {
			return true;
		}
		if (Long.parseLong(RRR_No.trim()) == 0) {
			return true;
		}
		long longRRR_No;
		long longRRR_No1;
		int intRRR_No1, intRRR_No2;
		longRRR_No = Long.parseLong(RRR_No);
		longRRR_No1 = longRRR_No / 10;
		intRRR_No2 = (int) (longRRR_No % 10);
		intRRR_No1 = (int) (longRRR_No1 % 7);
		if (intRRR_No1 == intRRR_No2) {
			return false;
		} else {
			return true;
		}
	}

	//	VALIDATE DECIMAL NUMBER
	/*
	 * To check if the Number is a VALID POSITIVE DECIMAL with 2 Decimal digits.
	 */
	public static boolean isDecimalNumber(String data) {
		String Field = data.trim();
		if (Field.trim() == "" || Field.trim().length() < 4
				|| Field.length() < 4) {
			return true;
		}
		for (int i = 0; i < data.length(); i++) {
			if ((data.charAt(i) < 32 || data.charAt(i) > 127)) {
				return true;
			}
		}
		try {
			Double.parseDouble(Field);
		} catch (Exception e) {
			return true;
		}
		if (Field.charAt(Field.length() - 3) != '.') {
			return true;
		}
		for (int localI = 0; localI < Field.length(); localI++) {
			if (!(Field.charAt(localI) > 47 && Field.charAt(localI) < 58)
					&& !(Field.charAt(localI) == 46)) {
				return true;
			}
			if ((Field.charAt(localI) == 46) && (localI == 0)) {
				return true;
			}
			if ((Field.charAt(localI) == 46)
					&& !((Field.length() - localI) == 3)) {
				return true;
			}
		}
		return false;
	}

	//	VALIDATING E-MAIL
	static boolean isValidEmail(String data) {
		String field = data.trim();
		if (isValidCharString(data)) {
			return true;
		}
		if (field.trim() == "" || field.trim().length() == 0) {
			return true;
		}
		for (int j = 0; j < field.length(); j++) {
			if (field.charAt(j) == ' ') {
				return true;
			}
		}
		if (field.charAt(0) == '@' || field.charAt(0) == '.') {
			return true;
		}
		if (field.charAt(field.length() - 1) == '@'
				|| field.charAt(field.length() - 1) == '.') {
			return true;
		}
		int localCount = 0;
		int dotPos = 0;
		int ratePos = 0;
		for (int j = 0; j < field.length(); j++) {
			if (field.charAt(j) == '@') {
				ratePos = j;
				if (field.charAt(j + 1) == '.') {
					return true;
				}
				localCount++;
				if (localCount > 1) {
					return true;
				}
			}
		}
		if (localCount == 0) {
			return true;
		}
		for (int x = 0; x < field.length(); x++) {
			if (field.charAt(x) == '.') {
				dotPos = x;
				if ((x + 1) != field.length()) {
					if (field.charAt(x + 1) == '.') {
						return true;
					}
				}
			}
		}
		if (dotPos < ratePos) {
			return true;
		}
		return false;
	}

	//	VALIDATE TAN
	/**
	 * A valid TAN should have the first 4 characters as alphabets, the next 5
	 * characters as numbers and the last character is the check digit alphabet
	 * of the previous 5 numbers. The check-digit is mod 7 of the 5 digits
	 * present.
	 *
	 * @parama tan -> TAN value from TD is passed as the parameter to this method.
	 * @return boolean
	 */
	public static boolean checkTan(String tan) {
		int checkBit;
		if (tan.trim().length() != 10) {
			return true;
		}
		String subtan = tan.substring(0, 3);
		String midSubtan = tan.substring(4, 9);
		String endSubtan = tan.substring(9, 10);
		int rccFlag = 0;
		for (int localR = 0; localR < CRAConstants.DDO_TAN_RCC.length; localR++) {
			if (subtan.equals(CRAConstants.DDO_TAN_RCC[localR])) {
				rccFlag = 1;
				break;
			}
		}
		if (rccFlag == 0) {
			return true;
		}
		for (int i = 0; i < 3; i++) {
			if (!(subtan.charAt(i) > 64 && subtan.charAt(i) < 91)) {
				return true;
			}
		}
		if (!Character.isLetterOrDigit(tan.charAt(3))) {
			return true;
		}
		if (Character.isLetter(tan.charAt(3))) {
			if (!(tan.charAt(3) > 64 && tan.charAt(3) < 91)) {
				return true;
			}
		}
		for (int i = 0; i < 5; i++) {
			if (!(midSubtan.charAt(i) > 47 && midSubtan.charAt(i) < 58)) {
				return true;
			}
		}
		checkBit = Integer.parseInt(midSubtan) % 7;
		if (checkBit == 0 && endSubtan.charAt(0) != 'A') {
			return true;
		} else if (checkBit == 1 && endSubtan.charAt(0) != 'B') {
			return true;
		} else if (checkBit == 2 && endSubtan.charAt(0) != 'C') {
			return true;
		} else if (checkBit == 3 && endSubtan.charAt(0) != 'D') {
			return true;
		} else if (checkBit == 4 && endSubtan.charAt(0) != 'E') {
			return true;
		} else if (checkBit == 5 && endSubtan.charAt(0) != 'F') {
			return true;
		} else if (checkBit == 6 && endSubtan.charAt(0) != 'G') {
			return true;
		}
		return false;
	}

	//	VALIDATE DATE IS A FUTURE DATE OR NOT
	static boolean isFutureDate(String date) {
		if (date.trim().length() != 8 || date.length() != 8) {
			return true;
		}
		Calendar cal1 = Calendar.getInstance();
		Calendar cal2 = new GregorianCalendar(Integer.parseInt(date.substring(
				4, 8)), Integer.parseInt(date.substring(2, 4)) - 1, Integer
				.parseInt(date.substring(0, 2)));
		if (cal1.before(cal2)) {
			return true;
		}
		return false;
	}

	//	VALIDATE CHECK DIGIT OF AIN
	/**
	 * This method validates the AIN. The 7-digit AIN is passed to this method.
	 * The first 6 digits of the AIN and the 7th digit is taken by using the
	 * substring method and stored seperately in two String variables. Both
	 * these strings are converted to Integer by using Integer.parseInt()
	 * method. Then, mod 7 of the first 6 dgits is taken and compared with the
	 * lastdigit and the mod value.
	 *
	 * @param id-> String value of the AIN
	 * @return boolean
	 */
	public static boolean checkID(String id) {
		String firstId = id.substring(0, 6);
		String lastId = id.substring(6, 7);
		int ain = Integer.parseInt(firstId);
		int lastDigitOfAin = Integer.parseInt(lastId);
		int modOfAin = ain % 7;
		if (lastDigitOfAin != modOfAin) {
			return true;
		}
		return false;
	}
	
	public static boolean validateAIN(String AIN)
	{
		 	
		boolean isValid = true;
		if(AIN.length()!=7 )
	    {
			isValid = false;
			return isValid;
	    }
			int ain=Integer.parseInt(AIN);
		 	System.out.println("PAO Reg. No."+ain);
	        int quo;
	        int div=ain/10; 
	        quo=div/7;
	        int rem=div-7*quo;
	        int mod=ain%10;
	        
	        if(rem!=mod)
	        {
	            
	        	isValid = false;
	        } 
	        return isValid;
	}

	//	CHECK TAB SPACES IN BETWEEN THE STRINGS
	public static boolean checkTabSpaces(String field) {
		for (int k = 0; k < field.length(); k++) {
			if (field.charAt(k) == 9) {
				return true;
			}
		}
		return false;
	}

	//	CHECK FOR BLANKSPACES IN BETWEEN THE FIELDS
	public static String trimInnerSpaces(String str) {
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < str.length(); i++) {
			if (str.charAt(i) != ' ') {
				sb.append(str.charAt(i));
			}
		}
		return sb.toString();
	}

	/**
	 * Name		:	CommonValidations
	 * Author		:	Prakash Sadhwani (TCS)
	 * Date		:	10/Oct/2007
	 */

	/**
	 * Name		:	isEmpty
	 * Input		:	string (Type String)
	 * Output		:	Boolean - true for empty string and false for non-empty string
	 */
	public static boolean isEmpty(String s) {
		try {
			if (s.length() == 0) {
				return true;
			} else {
				return false;
			}
		} catch (NullPointerException n) {
			return true;
		}
	}

	/**
	 * Name		:	checkMaxlength
	 * Input		:	1. string (Type String)
	 * 				2. maxlength (Type int)
	 * Output		:	Boolean - true if maxlength matches and false otherwise
	 */
	public static boolean checkMaxlength(String s, int maxlength) {
		if (!isEmpty(s))
			if (s.length() <= maxlength)
				return true;
			else
				return false;
		else
			return true;
	}

	public static boolean isDate_yyyymmdd(String date1) // date in yyyymmdd form
	{
		if (date1.trim() == "" || date1.trim().length() == 0
				|| date1.trim().length() != 8 || date1.length() != 8) {
			return true;
		}
		boolean errorDate;
		String yy = date1.substring(0, 4);
		String mm = date1.substring(4, 6);
		String dd = date1.substring(6, 8);
		try {
			if (checkValidation(Integer.parseInt(yy), Integer.parseInt(mm),
					Integer.parseInt(dd))) {
				errorDate = false;
			} else {
				errorDate = true;
			}
		} catch (Exception e) {
			errorDate = true;
		}
		return errorDate;
	}

	public static boolean checkFileName(File aDirectory, String filename)

	{
		boolean returnflag = true;

		// get a listing of all files in the directory
		String[] filesInDir = aDirectory.list();

		// sort the list of files (optional)
		// Arrays.sort(filesInDir);

		// have everything i need, just print it now
		for (int i = 0; i < filesInDir.length; i++) {
			//System.out.println("file: " + filesInDir[i]);
			if (filename.equals(filesInDir[i])) {
				returnflag = false;
			}

		}
		return returnflag;
	}

	public static boolean checkMandatory(String strFieldValue)
	{
		String field = strFieldValue.trim();
		if (field.trim() == "" || field.trim().length() == 0) {
			return false;
		}
		return true;
	}

	/**
	 * Name		:	checkMinlength
	 * Input		:	1. string (Type String)
	 * 				2. minlength (Type int)
	 * Output		:	Boolean - true if minlength matches and false otherwise
	 */
	public static boolean checkMinlength(String s, int minlength) {
		if (!isEmpty(s))
			if (s.length() >= minlength)
				return true;
			else
				return false;
		else
			return true;
	}

	public static boolean isDate_FormattedInput(String date1) //date in dd/mm/yyyy form
	{
		String dd = "";
		String mm = "";
		String yyyy = "";
		String date = "";
		StringTokenizer strTokenizer = new StringTokenizer(date1,"/");
		try {
			while (strTokenizer != null && strTokenizer.hasMoreTokens())
	        {
				dd = strTokenizer.nextToken().toString();
				mm = strTokenizer.nextToken().toString();
				yyyy = strTokenizer.nextToken().toString();
				date = dd+mm+yyyy;
		    }
			return !isDate(date);
		}
		catch (Exception e) {
			return false;
		}
	}
	 /**
     * This method is used while generating csv file. Suppose value of any field in csv file itself contains comma, 
     * then while opening that file in Excel, It will split that value in tho different cells.
     * To Resolve this Problem We can enclose the field containing commas in double quotes. This will ensure that 
     * when the CSV file is opened in an excel sheet, it opens correctly without splitting the value containing commas. 
     * However when you open this file in a WordPad or Notepad, the value will be displayed with double quotes.
     * In this method you have to pass the array of strings. String values which you think can hold comma values.
     * This method will enclose the value of that field with double quotes if that value contains comma.
     * @param String[] commaStrings
     
     */
    public  void convertCommaStringstoDoubleQuotes(String[] commaStrings)
    {
 	for(int i=0;i<commaStrings.length;i++)
 	{
 		if(commaStrings[i]!= null && commaStrings[i].contains(","))
 		{
 			commaStrings[i]= '"' + commaStrings[i] + '"';
 			
 		}
 		
 	}
    }
} // END OF CLASS CommonValidation.java