package com.cra.contr.common.util;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

//import org.apache.log4j.Logger;

/**
 * 
 * Classname :CRAConfigReader.java
 * 
 * @author TCS
 * 
 */
public class CRAConfigReader {

    //private static Logger log = Logger.getLogger("CommonLogging");

    private static final String PROPERTIES_SWITCH = "/resources/cra-switch-contr.properties";
    private static final String PROPERTIES_GENERAL = "/resources/general-config-contr.properties";
    
    private static final String PROPERTIES_ERRORCODES = "/resources/ApplicationResources-contr.properties" ;     //cra-errorcodes_en.properties";

    private static final String CRA_CONFIG_COMMON = "/resources/cra-config.properties";
    private static final String NPSCAN_CONFIG_COMMON = "/resources/npscan-config.properties";
    
    private static final String CRA_CONFIG = "/resources/cra-config-";
    private static final String NPSCAN_CONFIG = "/resources/npscan-config-";

    private static final String CRA_CLIENT = "/resources/cra-client-contr-";		//these are for any non-secure properties that can be easily packaged with standalone utilities for deploying on Client machines. These properties must NOT contain any secured information
    private static final String NPSCAN_CLIENT = "/resources/npscan-client-contr-";

    public static HashMap<String, String> configPropMap = new HashMap<String, String>();
    public static HashMap<String, String> errorCodePropMap = new HashMap<String, String>();    
    
    private static String currentDeployment = "dev" ;
    
    static {
        ////log.info("starting to Load CRAConfig PROPERTIES..");
        Properties prop = new Properties();
        try {
            prop.load(CRAConfigReader.class
                    .getResourceAsStream(PROPERTIES_SWITCH));
            //log.info("loaded SWITCH properties .." + PROPERTIES_SWITCH);
            
            Enumeration enumSwtich = prop.keys();
            while (enumSwtich.hasMoreElements()) {
                String key = (String) enumSwtich.nextElement();
                if (key.equals("cra.current.deployment")) {
                	currentDeployment = (String) prop.get(key) ;
                }
                configPropMap.put(key, (String)prop.get(key));
            }            
            //log.info("cra.current.deployment=" + currentDeployment);
            
            Enumeration ee = null;
            try {
	            //Load the General properties
	            prop.load(CRAConfigReader.class.getResourceAsStream(PROPERTIES_GENERAL));
	            ee = prop.keys();
	            while (ee.hasMoreElements()) {
	                String key = (String) ee.nextElement();
	                configPropMap.put(key, (String)prop.get(key));
	            }
            } catch (Exception e) {
                //log.error("Exception occured while trying to load GENERAL PROPERTIES. Continuing with loading further properties" ,e);
            }

    		String systemName = configPropMap.get("SYNC.SYSTEM_NAME");
    		//log.info("in CRAConfigReader.. systemName="+systemName);
    		

    		try {
	            //Load the SYTEM-specific properties    		
	    		if ((systemName!=null) && systemName.equals("NPSCAN") ) {
	                prop.load(CRAConfigReader.class.getResourceAsStream(NPSCAN_CONFIG_COMMON));    			
	    		} else {
	                prop.load(CRAConfigReader.class.getResourceAsStream(CRA_CONFIG_COMMON));
	    		}
	    		//log.info("loaded the SYSTEM specific properties..");
	    		ee = prop.keys();    		
	            while (ee.hasMoreElements()) {
	                String key = (String) ee.nextElement();
	                configPropMap.put(key, (String)prop.get(key));
	            }
            } catch (Exception e) {
                //log.error("Exception occured while trying to load CONFIG PROPERTIES. Continuing with loading further properties" ,e);
            }

            try {
	            //Load the SYTEM-specific ENVIRONMENT-specific properties - IF ANY DUPLICATES BETWEEN THE SYSTEM-SPECIFIC & SYSTEM-ENVIRONMENT-SPECIFIC, THEN THE LATEST ADDED KEY WILL BE CONSIDERED           
	    		if ((systemName!=null) && systemName.equals("NPSCAN") ) {
	                prop.load(CRAConfigReader.class.getResourceAsStream(NPSCAN_CONFIG+currentDeployment+".properties"));    			
	    		} else {
	                prop.load(CRAConfigReader.class.getResourceAsStream(CRA_CONFIG+currentDeployment+".properties"));
	    		}
	    		////log.info("loaded the environment specific properties..");
	    		ee = prop.keys();    		
	            while (ee.hasMoreElements()) {
	                String key = (String) ee.nextElement();
	                configPropMap.put(key, (String)prop.get(key));
	            }
            } catch (Exception e) {
                //log.error("Exception occured while trying to load EVIRONMENT SPECIFIC CONFIG PROPERTIES. Continuing with loading further properties" ,e);
            }


            try {
	            //Load the SYTEM-specific ENVIRONMENT-specific CLIENT properties - IF ANY DUPLICATES, THEN THE LATEST ADDED KEY WILL BE CONSIDERED           
	    		if ((systemName!=null) && systemName.equals("NPSCAN") ) {
	                prop.load(CRAConfigReader.class.getResourceAsStream(NPSCAN_CLIENT+currentDeployment+".properties"));    			
	    		} else {
	                prop.load(CRAConfigReader.class.getResourceAsStream(CRA_CLIENT+currentDeployment+".properties"));
	    		}
	    		//log.info("loaded the environment specific CLIENT properties..");
	    		ee = prop.keys();    		
	            while (ee.hasMoreElements()) {
	                String key = (String) ee.nextElement();
	                configPropMap.put(key, (String)prop.get(key));
	            }
            } catch (Exception e) {
                //log.error("Exception occured while trying to load ENV-SPECIFIC CLIENT PROPERTIES. Continuing with loading further properties" ,e);
            }

            
            try {
	            //Load the General ErrorCodes properties            
	            //log.info("loading General ErrorCodes properties ..");
	            prop.load(CRAConfigReader.class.getResourceAsStream(PROPERTIES_ERRORCODES));
	            ee = prop.keys();
	            while (ee.hasMoreElements()) {
	                String key = (String) ee.nextElement();
	                errorCodePropMap.put(key, (String)prop.get(key));
	            }
            } catch (Exception e) {
                //log.error("Exception occured while trying to load ERROR PROPERTIES." ,e);
            }

	            
            //log.info("Completed loading CRA configuration properties..");
        } catch (IOException e) {
            //log.error("IOException: Failure in loading CRA configuration properties: " ,e);
        } finally {
            prop.clear();
        }

    }

    /**
     * 
     * Methodname getConfigMap - This method takes a module name as input and
     * gives the module specific configuration details in the HashMap. But the
     * configuration details in the properties file (FTM.properties) for a
     * module must be prefixed with the module name and an "_" (underscore)
     * 
     * @param fileType -
     *            file type is same as the module name
     * 
     * @return HashMap - This HashMap contains the configuration details
     *         specific to the module requested for.
     */
    public static HashMap getFTMConfigMap(String fileType) {
        HashMap<String, String> fHM = new HashMap<String, String>();
        Set set = configPropMap.keySet();
        Iterator iter = set.iterator();
        String moduleKey = "FTM."+ fileType ;
        while (iter.hasNext()) {
            String key = (String) iter.next();
            if (key.startsWith(moduleKey)) {
                String val = (String) configPropMap.get(key);
                try {
                    if (val != null)
                        fHM.put(key.substring(moduleKey.length() + 1), val);
                } catch (StringIndexOutOfBoundsException e) {
                }
            }
        }
        return fHM;
    }
    
    
    public static String getConfigVal(String key) {
    	return configPropMap.get(key);
    }

    public static String getErrorDescription(String errorCode) {
    	return errorCodePropMap.get(errorCode);
    }
}
