/*
 * Decompiled with CFR 0.152.
 */
package cra.standalone.paosubcontr.util;

import com.cra.common.util.CRAConfigReader;
import com.cra.common.util.file.CRABasicFileWriter;
import com.cra.pao.fvu.SubContrFileFormatValidator;
import com.cra.pao.vo.PAOFileStatisticsVO;
import cra.standalone.paosubcontr.PAOFvu;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;

public class SubContrOutputFileGenerator {
    Calendar cal = new GregorianCalendar();
    String tab = "^";

    public void generateControlSheetReport(SubContrFileFormatValidator obj_FrmValidator, String controlSheetFileName, String fileName, String FVUVersion) {
        try {
            ArrayList statisticDataList = this.parseString(obj_FrmValidator.getControlSheetBuffer().toString(), "\n");
            Object[] statisticDataArray = statisticDataList.toArray();
            obj_FrmValidator.setControlSheetBuffer(new StringBuffer());
            PAOFileStatisticsVO fStatistics = new PAOFileStatisticsVO();
            fStatistics = this.getStatisticFileDetail((String)statisticDataArray[0], "^", fStatistics);
            this.createStatisticFile(obj_FrmValidator, fStatistics, controlSheetFileName, fileName, FVUVersion);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ArrayList parseString(String toParse, String Seperator) {
        ArrayList<Object> aList = new ArrayList<Object>();
        StringTokenizer parsed = new StringTokenizer(toParse, Seperator);
        while (parsed.hasMoreTokens()) {
            aList.add(parsed.nextElement());
        }
        return aList;
    }

    private PAOFileStatisticsVO getStatisticFileDetail(String StringToParse, String Seperator, PAOFileStatisticsVO fStatistics) {
        System.out.println("CSS ::" + StringToParse);
        StringTokenizer batch = new StringTokenizer(StringToParse, Seperator);
        int counter = 0;
        while (batch.hasMoreTokens()) {
            String token = batch.nextToken();
            if (counter == 0) {
                fStatistics.setUploadedBy(token.trim());
            } else if (counter == 1) {
                fStatistics.setNumberOfBatches(token.trim());
            } else if (counter == 2) {
                token = CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion");
                fStatistics.setFvuVersion(token.trim());
            } else if (counter == 5) {
                fStatistics.setTypeOfUploadedFile(token.trim());
            } else if (counter == 6) {
                fStatistics.setAIN(token.trim());
            } else if (counter == 7) {
                fStatistics.setFpuFileCreatedDate(token.trim());
            } else if (counter == 8) {
                fStatistics.setBatchId(token.trim());
            } else if (counter == 9) {
                fStatistics.setTransactionId(token.trim());
            } else if (counter == 10) {
                fStatistics.setCountOfDDORecords(token.trim());
            } else if (counter == 11) {
                fStatistics.setCountOfSubDetailRecords(token.trim());
            } else if (counter == 12) {
                fStatistics.setTierOneTotalGovtContribution(token);
            } else if (counter == 13) {
                fStatistics.setTierOneTotalSelfContribution(token);
            } else if (counter == 14) {
                fStatistics.setTotalAmountDepositedInBank(token);
            } else if (counter == 15) {
                fStatistics.setTotalRegularContr(token);
            } else if (counter == 16) {
                fStatistics.setTotalArrearContr(token);
            } else if (counter == 17) {
                fStatistics.setTotalAdhocContr(token);
            } else if (counter == 18) {
                fStatistics.setTotalGovtContr(token);
            } else if (counter == 19) {
                fStatistics.setTotalSwavContr(token);
            } else if (counter == 20) {
                fStatistics.setWarnings(token);
            } else if (counter == 21) {
                fStatistics.setUniqueCount(token);
            } else if (counter == 22) {
                fStatistics.setLineNumber(token);
            }
            ++counter;
        }
        return fStatistics;
    }

    private void createStatisticFile(SubContrFileFormatValidator obj_FrmValidator, PAOFileStatisticsVO fStatistics, String ctrlSheetFileName, String fileName, String FVUVersion) {
        try {
            StringBuilder toReturn = new StringBuilder();
            toReturn.append("<HTML>");
            toReturn.append("<HEAD>");
            toReturn.append("<TITLE>SUBSCRIBER CONTRIBUTION FILE</TITLE>");
            toReturn.append("</HEAD>");
            toReturn.append("<STYLE>p.dotted {border-width:1; border-style:dashed;border-bottom-style:none;border-right-style:none;border-left-style:none}</STYLE>");
            toReturn.append("<BODY>");
            toReturn.append("<CENTER>");
            toReturn.append("<TABLE BORDER=1 WIDTH=75% BORDERCOLOR=\"000000\" CELLSPACING=0 CELLPADDING=0 style='border-collapse: collapse; border: none; mso-border-alt: solid windowtext .5pt; mso-padding-alt: 0in 5.4pt 0in 5.4pt'>");
            toReturn.append("<TR><TD ALIGN=CENTER>");
            toReturn.append("<CENTER>");
            toReturn.append("<TABLE BORDER=0 WIDTH=100% BORDERCOLOR=\"000000\" CELLSPACING=0 CELLPADDING=0 style='border-collapse: collapse; border: none; mso-border-alt: solid windowtext .5pt; mso-padding-alt: 0in 5.4pt 0in 5.4pt'>");
            toReturn.append("<TR><TD ALIGN=CENTER>");
            toReturn.append("<CENTER>");
            toReturn.append("<TABLE ALIGN=CENTER BORDER=0 WIDTH=100% BORDERCOLOR=\"000000\" CELLSPACING=0 CELLPADDING=0 style='border-collapse: collapse; border: none; mso-border-alt: solid windowtext .5pt; mso-padding-alt: 0in 5.4pt 0in 5.4pt'>");
            toReturn.append("<TR><TD ALIGN=CENTER>");
            toReturn.append("<H2>SUBSCRIBER CONTRIBUTION FILE CONTROL SHEET*</H2>");
            toReturn.append("</TD></TR>");
            toReturn.append("</TABLE>");
            toReturn.append("</CENTER>");
            toReturn.append("</TD></TR>");
            toReturn.append("<TR><TD>");
            toReturn.append("<TABLE BORDER=0 WIDTH=100% BORDERCOLOR=\"000000\" CELLSPACING=0 CELLPADDING=0 style='border-collapse: collapse; border: none; mso-border-alt: solid windowtext .5pt; mso-padding-alt: 0in 5.4pt 0in 5.4pt'>");
            toReturn.append("<TR><TD WIDTH=55%>");
            toReturn.append("<TABLE BORDER=0 WIDTH=100% BORDERCOLOR=\"000000\" CELLSPACING=0 CELLPADDING=3 style='border-collapse: collapse; border: none; mso-border-alt: solid windowtext .5pt; mso-padding-alt: 0in 5.4pt 0in 5.4pt'>");
            toReturn.append("<TR><TD ALIGN=LEFT WIDTH=55%>&nbsp; &nbsp; Batch ID : </TD><TD ALIGN=LEFT>&nbsp;&nbsp;" + fStatistics.getBatchId() + "</TD></TR>");
            toReturn.append("<TR>");
            if (fStatistics.getUploadedBy().equals("X") || fStatistics.getUploadedBy().equals("Y")) {
                toReturn.append("<TD ALIGN=LEFT>&nbsp; &nbsp; NL-OO/NL-AO Reg. No. </TD>");
            }
            toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;" + fStatistics.getAIN() + "</TD></TR>");
            toReturn.append("<TR>");
            if (fStatistics.getUploadedBy().equals("X") || fStatistics.getUploadedBy().equals("Y")) {
                toReturn.append("<TD ALIGN=LEFT>&nbsp; &nbsp; Number of NL-AO/NL-CC's :</TD>");
            }
            toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;" + fStatistics.getCountOfDDORecords() + "</TD>");
            toReturn.append("</TR>");
            toReturn.append("</TABLE>");
            toReturn.append("</TD>");
            toReturn.append("<TD ALIGN=LEFT WIDTH=45%>");
            toReturn.append("<TABLE BORDER=0 WIDTH=100% BORDERCOLOR=\"000000\" CELLSPACING=0 CELLPADDING=3 style='border-collapse: collapse; border: none; mso-border-alt: solid windowtext .5pt; mso-padding-alt: 0in 5.4pt 0in 5.4pt'>");
            toReturn.append("<TR><TD WIDTH=55%>");
            toReturn.append("<TR><TD WIDTH=55%>");
            toReturn.append("<TR><TD WIDTH=55%>");
            toReturn.append("<TR><TD ALIGN=LEFT WIDTH=50%>Contribution File Type : </TD>");
            if (fStatistics.getTypeOfUploadedFile().equals("R")) {
                toReturn.append("<TD ALIGN=LEFT WIDTH=50%>Original</TD>");
            } else {
                toReturn.append("<TD ALIGN=LEFT WIDTH=50%>Correction</TD>");
            }
            toReturn.append("</TR>");
            toReturn.append("<TR><TD ALIGN=LEFT WIDTH=50%>Transaction ID : </TD><TD ALIGN=LEFT WIDTH=50%>" + fStatistics.getTransactionId() + "</TD>");
            toReturn.append("</TR>");
            toReturn.append("<TR><TD ALIGN=LEFT WIDTH=50%>Subscriber record count : </TD><TD ALIGN=LEFT WIDTH=50%>" + fStatistics.getCountOfSubDetailRecords() + "</TD>");
            toReturn.append("</TR>");
            toReturn.append("<TR><TD ALIGN=LEFT WIDTH=50%>Count of unique subscribers : </TD><TD ALIGN=LEFT WIDTH=50%>" + fStatistics.getUniqueCount() + "</TD>");
            toReturn.append("</TABLE>");
            toReturn.append("</TD>");
            toReturn.append("</TR>");
            toReturn.append("</TABLE>");
            toReturn.append("</TD></TR>");
            toReturn.append("<TR><TD></TD></TR>");
            toReturn.append("<TR><TD>");
            toReturn.append("<TABLE BORDER=0 WIDTH=55% BORDERCOLOR=\"000000\" CELLSPACING=0 CELLPADDING=3 style='border-collapse: collapse; border: none; mso-border-alt: solid windowtext .5pt; mso-padding-alt: 0in 5.4pt 0in 5.4pt'>");
            toReturn.append("<TR><TD ALIGN=LEFT WIDTH=50%><B>&nbsp; &nbsp; Contribution Types</B></TD><TD ALIGN=LEFT><B>Records</B></TD><TD ALIGN=LEFT><B>&nbsp; &nbsp; Total Amount</B></TD>");
            if (PAOFvu.FYFlag.equalsIgnoreCase("N")) {
                toReturn.append("<TR><TD ALIGN=LEFT WIDTH=55%>&nbsp; &nbsp; Regular Contribution :</TD>");
                toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;" + obj_FrmValidator.getRecord_C() + "</TD>");
                toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;" + fStatistics.getTotalRegularContr() + "</TD>");
                toReturn.append("</TR>");
                toReturn.append("<TR><TD ALIGN=LEFT WIDTH=55%>&nbsp; &nbsp; Arrears Contribution :</TD>");
                toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;" + obj_FrmValidator.getRecord_A() + "</TD>");
                toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;" + fStatistics.getTotalArrearContr() + "</TD>");
                toReturn.append("</TR>");
                toReturn.append("<TR><TD ALIGN=LEFT WIDTH=55%>&nbsp; &nbsp; Self Contribution :</TD>");
                toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;" + obj_FrmValidator.getRecord_0() + "</TD>");
                toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;" + fStatistics.getTotalAdhocContr() + "</TD>");
                toReturn.append("</TR>");
                toReturn.append("<TR><TD ALIGN=LEFT WIDTH=55%>&nbsp; &nbsp; Govt-Schemes Contribution :</TD>");
                toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;" + obj_FrmValidator.getRecord_G() + "</TD>");
                toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;" + fStatistics.getTotalGovtContr() + "</TD>");
                toReturn.append("</TR>");
            } else if (PAOFvu.FYFlag.equalsIgnoreCase("Y")) {
                toReturn.append("<TR><TD ALIGN=LEFT WIDTH=55%>&nbsp; &nbsp; Self Contribution :</TD>");
                toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;" + obj_FrmValidator.getRecord_0() + "</TD>");
                toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;" + fStatistics.getTotalAdhocContr() + "</TD>");
                toReturn.append("</TR>");
                toReturn.append("<TR><TD ALIGN=LEFT WIDTH=55%>&nbsp; &nbsp; Swavalamban Contribution :</TD>");
                toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;" + obj_FrmValidator.getRecord_Sw() + "</TD>");
                toReturn.append("<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;" + fStatistics.getTotalSwavContr() + "</TD>");
                toReturn.append("</TR>");
            }
            toReturn.append("</TABLE>");
            toReturn.append("</TD></TR>");
            toReturn.append("<TR><TD></TD></TR>");
            toReturn.append("<TR><TD ALIGN=CENTER>");
            toReturn.append("<CENTER>");
            toReturn.append("<TABLE BORDER=1 WIDTH=80% BORDERCOLOR=\"000000\" CELLSPACING=0 CELLPADDING=5 style='border-collapse: collapse; border: none; mso-border-alt: solid windowtext .5pt; mso-padding-alt: 0in 5.4pt 0in 5.4pt'>");
            toReturn.append("<TR>");
            toReturn.append("<TH WIDTH=70%>Contribution Source</TH><TH WIDTH=30%>Amount</TH> ");
            toReturn.append("</TR><TR>");
            toReturn.append("<TD>Total Co-Contribution</TD>");
            toReturn.append("<TD>" + fStatistics.getTierOneTotalGovtContribution() + "</TD></TR>");
            toReturn.append("<TR><TD>Total Subscriber's Contribution</TD>");
            toReturn.append("<TD>" + fStatistics.getTierOneTotalSelfContribution() + "</TD></TR>");
            toReturn.append("<TR><TD><B>Total Contribution</B></TD><TD>" + fStatistics.getTotalAmountInBank() + "</TD></TR>");
            toReturn.append("</TABLE>");
            toReturn.append("</CENTER>");
            toReturn.append("</TD></TR>");
            toReturn.append("<TR><TD>&nbsp;</TD></TR>");
            if (!fStatistics.getWarnings().equals("-")) {
                toReturn.append("<TR><TD>&nbsp; &nbsp;&nbsp;Warning : " + fStatistics.getWarnings() + "</TD></TR>");
            }
            toReturn.append("<TR><TD height=20>");
            toReturn.append("<p class=dotted>");
            toReturn.append("<TABLE BORDER=0 WIDTH=100% BORDERCOLOR=\"000000\" CELLSPACING=0 CELLPADDING=0 style='border-collapse: collapse; border: none; mso-border-alt: solid windowtext .5pt; mso-padding-alt: 0in 5.4pt 0in 5.4pt'>");
            toReturn.append("<TR height=8%><TD width=60%></TD><TD width=40%></TD></TR>");
            toReturn.append("<TR><TD width=60%>");
            toReturn.append("<TABLE BORDER=0 WIDTH=100% BORDERCOLOR=\"000000\" CELLSPACING=0 CELLPADDING=0 style='border-collapse: collapse; border: none; mso-border-alt: solid windowtext .5pt; mso-padding-alt: 0in 5.4pt 0in 5.4pt'>");
            toReturn.append("<TR><TD width=37%>");
            toReturn.append("<FONT size=2>&nbsp; &nbsp; &nbsp; Date of File Generation :</FONT>");
            String dateFromFile = fStatistics.getFpuFileCreatedDate();
            Date dateFmt = new SimpleDateFormat("ddMMyyy").parse(dateFromFile);
            String displayDate = new SimpleDateFormat("dd-MMM-yyyy").format(dateFmt);
            toReturn.append("</TD><TD><FONT size=2>" + displayDate + "</FONT></TD></TR>");
            toReturn.append("<TR><TD width=37% height=20 align='top'>");
            toReturn.append("<FONT size=2>&nbsp; &nbsp; &nbsp; Input File Path :</FONT>");
            toReturn.append("</TD>");
            toReturn.append("<TD><FONT size=2>" + fileName + "</FONT></TD></TR>");
            toReturn.append("<TR><TD width=37% height=20>");
            toReturn.append("<FONT size=2>&nbsp; &nbsp; &nbsp; FVU Version :</FONT>");
            toReturn.append("</TD>");
            toReturn.append("<TD><FONT size=2>" + FVUVersion + "</FONT></TD></TR>");
            toReturn.append("<TR><TD  colspan=2 height=20>");
            toReturn.append("<FONT size=2>&nbsp; &nbsp; &nbsp; <I><U>Note</U>: Transaction ID will be available for correction file only.</I></FONT>");
            toReturn.append("</TD></TR>");
            toReturn.append("</TABLE>");
            toReturn.append("</TD><TD WIDTH=40%>");
            toReturn.append("<TABLE BORDER=0 WIDTH=100% BORDERCOLOR=\"000000\" CELLSPACING=4 CELLPADDING=4 style='border-collapse: collapse; border: none; mso-border-alt: solid windowtext .5pt; mso-padding-alt: 0in 5.4pt 0in 5.4pt'>");
            toReturn.append("<TR><TD align=right valign=bottom>");
            toReturn.append("<TABLE BORDER=1 WIDTH=100% BORDERCOLOR=\"000000\" CELLSPACING=0 CELLPADDING=2 style='border-collapse: collapse; border: none; mso-border-alt: solid windowtext .5pt; mso-padding-alt: 0in 5.4pt 0in 5.4pt'>");
            toReturn.append("<TR><TD><FONT size=2>* CONTROL SHEET helps in reconciling the subscriber data contained in the Contribution file. Please check the Control Totals to reconcile the contribution data to be uploaded.</FONT>");
            toReturn.append("</TD></TR></TABLE></TD></TR></TABLE></TD></TR></TABLE></p></TD></TR></TABLE></CENTER></TD></TR></TABLE></CENTER></BODY></HTML>");
            CRABasicFileWriter.writeFileLocal(ctrlSheetFileName, new StringBuffer(toReturn.toString()));
            toReturn = new StringBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

