/*
 * Decompiled with CFR 0.152.
 */
package cra.standalone.paosubcontr;

import com.cra.common.util.CRAConfigReader;
import com.cra.common.util.HtmlFileGenerator;
import com.cra.common.util.encrypt.Hash;
import com.cra.common.util.file.CRABasicFileWriter;
import com.cra.pao.fvu.SubContrFileFormatValidator;
import com.cra.pao.vo.PAOContrErrorFileVO;
import cra.standalone.paosubcontr.util.SubContrOutputFileGenerator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.filechooser.FileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PAOFvu
extends JFrame {
    private static final long serialVersionUID;
    public final int utilityLevel = 0;
    static final int fhFieldCount = 5;
    private JPanel jContentPane = null;
    private JLabel jLabel = null;
    private JLabel jLabel1 = null;
    private JTextField txtInputFileName = null;
    private JTextField txtErrorFilePath = null;
    private JButton btnValidate = null;
    private JButton btnExit = null;
    private JButton btnHelp = null;
    private JButton btnbrowseInputFileName = null;
    private JButton btnbrowseErrorFilePath = null;
    private JTextPane jHelpTextPane = null;
    public String file;
    public static String FYFlag;
    private String previousSorurceFileFolder = "";
    private String previousOutputFileFolder = "";
    final String errorMsg_01 = "Input File Name with Path or \n Error/Upload and Control Sheet Report File Path not chosen";
    final String errorMsg_02 = "Invalid Input File Name. Length of Input File Name cannot be more than 24 characters (including extension).";
    final String errorMsg_03 = "Invalid Input File Name";
    final String errorMsg_04 = "Invalid File Name.\n  :  /  ?  >  <  *  \"  |  \\  ^  _ or Space, not allowed in File Name.";
    final String errorMsg_05 = "Error/Upload and Control Sheet Report File Path does not exist or \n File Name specified along with path.";
    final String errorMsg_06 = "Invalid Input File extension. File extension should be '.txt'";

    static {
        String FinYearFlag;
        serialVersionUID = "cra.standalone.paosubcontr.PAOFvu".hashCode();
        FYFlag = FinYearFlag = CRAConfigReader.getConfigVal("FinancialYear.flag");
    }

    public static void main(String[] args) {
        System.out.println("start Time :: " + System.currentTimeMillis());
        if (args.length == 5) {
            Hash hashObj;
            int hashCode;
            String inFileNameSAM = args[0];
            String errorFileNameSAM = args[1];
            String outFileNameSAM = args[2];
            String utilityLevelSamScm = args[3];
            String samScmFvuVersion = args[4];
            File f1 = new File(inFileNameSAM);
            File f2 = new File(outFileNameSAM);
            int utilityLevelInt = Integer.parseInt(utilityLevelSamScm.trim());
            StringBuffer FH_obj_StringBuffer = new StringBuffer();
            ArrayList<PAOContrErrorFileVO> listErrorVO = new ArrayList<PAOContrErrorFileVO>();
            if (!(utilityLevelInt != 1 && utilityLevelInt != 2 || samScmFvuVersion.equals(CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion")))) {
                listErrorVO.add(new PAOContrErrorFileVO("-", 201019, "File Header Record", "-", "-", "-", "1", "-"));
                FH_obj_StringBuffer = PAOFvu.convertArrayListtoBuffer(listErrorVO);
                try {
                    CRABasicFileWriter.writeFileLocal(errorFileNameSAM, FH_obj_StringBuffer);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                System.exit(0);
            }
            if ((hashCode = (hashObj = new Hash()).startProcessing(inFileNameSAM, outFileNameSAM, utilityLevelInt, 5)) != 0) {
                int lineNumber = hashObj.getRecordNumber();
                if (hashCode == 3) {
                    listErrorVO.add(new PAOContrErrorFileVO("-", 201012, "File Header Record", "-", "-", "-", "1", "-"));
                } else if (hashCode == 4) {
                    listErrorVO.add(new PAOContrErrorFileVO("-", 201013, "File Header Record", "-", "-", "-", "1", "-"));
                } else if (hashCode == 5) {
                    listErrorVO.add(new PAOContrErrorFileVO("-", 201014, "File Header Record", "-", "-", "-", "1", "-"));
                } else if (hashCode == 9) {
                    listErrorVO.add(new PAOContrErrorFileVO("-", 201015, "File Header Record", "-", "-", "-", "1", "-"));
                } else if (hashCode == 10) {
                    listErrorVO.add(new PAOContrErrorFileVO("-", 201016, "File Header Record", "-", "-", "-", "1", "-"));
                } else if (hashCode == 11) {
                    listErrorVO.add(new PAOContrErrorFileVO("-", 201017, "File Header Record", "-", "-", "-", "1", "-"));
                } else {
                    listErrorVO.add(new PAOContrErrorFileVO("-", 201018, "-", "-", "-", "-", String.valueOf(lineNumber), "-"));
                }
                try {
                    FH_obj_StringBuffer = PAOFvu.convertArrayListtoBuffer(listErrorVO);
                    CRABasicFileWriter.writeFileLocal(errorFileNameSAM, FH_obj_StringBuffer);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else if (hashCode == 0) {
                SubContrFileFormatValidator obj_FormValidator = new SubContrFileFormatValidator();
                try {
                    obj_FormValidator.readFile(inFileNameSAM, listErrorVO, utilityLevelInt);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                if (listErrorVO.size() == 0) {
                    try {
                        String dataRecord = null;
                        String samScmString = obj_FormValidator.getControlSheetBuffer().toString();
                        StringBuffer samScmStringBuffer = PAOFvu.getRAWData(samScmString, "^");
                        String samScmDataFlNm = String.valueOf(outFileNameSAM) + ".raw";
                        CRABasicFileWriter.writeFileLocal(samScmDataFlNm, samScmStringBuffer);
                        BufferedReader brRead = new BufferedReader(new FileReader(inFileNameSAM));
                        PrintWriter outWrite = new PrintWriter(new BufferedWriter(new FileWriter(outFileNameSAM, true)));
                        while ((dataRecord = brRead.readLine()) != null) {
                            System.out.println("Writing Duplicate records");
                        }
                        outWrite.flush();
                        outWrite.close();
                        brRead.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    f1.renameTo(f2);
                    System.out.println("finished listErrorVO is zero");
                } else {
                    try {
                        FH_obj_StringBuffer = PAOFvu.convertArrayListtoBuffer(listErrorVO);
                        CRABasicFileWriter.writeFileLocal(errorFileNameSAM, FH_obj_StringBuffer);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        } else if (args.length == 0) {
            PAOFvu f = new PAOFvu();
            f.setVisible(true);
        }
    }

    public PAOFvu() {
        this.initialize();
    }

    private static StringBuffer getRAWData(String StringToParse, String Seperator) {
        StringBuilder rawDataBuffer = new StringBuilder();
        StringTokenizer rawData = new StringTokenizer(StringToParse, Seperator);
        int counter = 0;
        while (rawData.hasMoreTokens()) {
            String token = rawData.nextToken();
            if (counter == 0) {
                rawDataBuffer.append(String.valueOf(token.trim()) + "^");
            } else if (counter == 1) {
                rawDataBuffer.append(String.valueOf(token.trim()) + "^");
            } else if (counter == 5) {
                rawDataBuffer.append(String.valueOf(token.trim()) + "^");
            } else if (counter == 6) {
                rawDataBuffer.append(String.valueOf(token.trim()) + "^");
            } else if (counter == 7) {
                rawDataBuffer.append(String.valueOf(token.trim()) + "^");
            } else if (counter == 8) {
                rawDataBuffer.append(String.valueOf(token.trim()) + "^");
            } else if (counter == 9) {
                rawDataBuffer.append(String.valueOf(token.trim()) + "^");
            } else if (counter == 10) {
                rawDataBuffer.append(String.valueOf(token.trim()) + "^");
            } else if (counter == 11) {
                rawDataBuffer.append(String.valueOf(token.trim()) + "^");
            } else if (counter == 12) {
                rawDataBuffer.append(String.valueOf(token.trim()) + "^");
            } else if (counter == 13) {
                rawDataBuffer.append(String.valueOf(token.trim()) + "^");
            } else if (counter == 14) {
                rawDataBuffer.append(String.valueOf(token.trim()) + "^");
            }
            ++counter;
        }
        return new StringBuffer(rawDataBuffer.toString());
    }

    private static StringBuffer convertArrayListtoBuffer(ArrayList<PAOContrErrorFileVO> listErrorVO) {
        StringBuffer errorBuffer = new StringBuffer();
        String tagName = null;
        String ErrorDescription = null;
        String recordType = null;
        String serialNumberInDDO = null;
        String serialNumber = null;
        String lineNumber = null;
        int i = 0;
        while (i < listErrorVO.size()) {
            tagName = listErrorVO.get(i).getTagName();
            String errorCode = new Integer(listErrorVO.get(i).getErrorCode()).toString();
            ErrorDescription = listErrorVO.get(i).getErrorDescription();
            recordType = listErrorVO.get(i).getRecordType();
            serialNumberInDDO = listErrorVO.get(i).getSerialNumberInDDO();
            serialNumber = listErrorVO.get(i).getSerialNumber();
            lineNumber = listErrorVO.get(i).getLineNumber();
            errorBuffer.append(String.valueOf(tagName) + "^" + errorCode + "^" + ErrorDescription + "^" + recordType + "^" + serialNumberInDDO + "^" + serialNumber + "^" + lineNumber);
            errorBuffer.append("\n");
            ++i;
        }
        return errorBuffer;
    }

    private void initialize() {
        this.setSize(600, 180);
        this.setLocation(250, 250);
        this.setContentPane(this.getJContentPane());
        this.setTitle("NPS-Lite Subscriber Contribution File Validation Utility - Version " + CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion"));
        System.out.println(CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion"));
        this.setResizable(false);
        this.btnValidate.setEnabled(false);
        this.setDefaultCloseOperation(3);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/cra/standalone/paosubcontr/nsdl-logo.jpg")));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            GridBagConstraints consGridBagConstraints14 = new GridBagConstraints();
            GridBagConstraints consGridBagConstraints15 = new GridBagConstraints();
            GridBagConstraints consGridBagConstraints16 = new GridBagConstraints();
            GridBagConstraints consGridBagConstraints12 = new GridBagConstraints();
            GridBagConstraints consGridBagConstraints17 = new GridBagConstraints();
            GridBagConstraints consGridBagConstraints38 = new GridBagConstraints();
            GridBagConstraints consGridBagConstraints18 = new GridBagConstraints();
            GridBagConstraints consGridBagConstraints39 = new GridBagConstraints();
            GridBagConstraints consGridBagConstraints40 = new GridBagConstraints();
            GridBagConstraints consGridBagConstraints41 = new GridBagConstraints();
            GridBagConstraints consGridBagConstraints42 = new GridBagConstraints();
            GridBagConstraints consGridBagConstraints43 = new GridBagConstraints();
            GridBagConstraints consGridBagConstraints45 = new GridBagConstraints();
            GridBagConstraints consGridBagConstraints44 = new GridBagConstraints();
            GridBagConstraints consGridBagConstraints1 = new GridBagConstraints();
            consGridBagConstraints1.gridy = 2;
            consGridBagConstraints1.gridx = 3;
            consGridBagConstraints1.gridwidth = 1;
            consGridBagConstraints1.insets = new Insets(6, 7, 10, 10);
            consGridBagConstraints45.insets = new Insets(6, 5, 10, 100);
            consGridBagConstraints45.gridy = 2;
            consGridBagConstraints45.gridx = 2;
            consGridBagConstraints17.gridy = 8;
            consGridBagConstraints17.gridx = 0;
            consGridBagConstraints17.gridheight = 2;
            consGridBagConstraints14.gridy = 2;
            consGridBagConstraints14.gridx = 0;
            consGridBagConstraints18.gridy = 8;
            consGridBagConstraints18.gridx = 1;
            consGridBagConstraints15.fill = 1;
            consGridBagConstraints15.weightx = 1.0;
            consGridBagConstraints15.gridy = 1;
            consGridBagConstraints15.gridx = 1;
            consGridBagConstraints16.fill = 1;
            consGridBagConstraints16.weightx = 1.0;
            consGridBagConstraints16.gridy = 2;
            consGridBagConstraints16.gridx = 1;
            consGridBagConstraints43.insets = new Insets(8, 7, 4, 10);
            consGridBagConstraints43.gridy = 1;
            consGridBagConstraints43.gridx = 3;
            consGridBagConstraints43.anchor = 13;
            consGridBagConstraints12.gridy = 1;
            consGridBagConstraints12.gridx = 0;
            consGridBagConstraints12.anchor = 11;
            consGridBagConstraints12.fill = 1;
            consGridBagConstraints14.fill = 1;
            consGridBagConstraints42.insets = new Insets(11, 7, 7, 3);
            consGridBagConstraints42.fill = 2;
            consGridBagConstraints42.weightx = 1.0;
            consGridBagConstraints42.gridwidth = 2;
            consGridBagConstraints42.gridy = 1;
            consGridBagConstraints42.gridx = 1;
            consGridBagConstraints39.insets = new Insets(11, 7, 7, 3);
            consGridBagConstraints39.fill = 2;
            consGridBagConstraints39.weightx = 1.0;
            consGridBagConstraints39.gridwidth = 2;
            consGridBagConstraints39.gridy = 0;
            consGridBagConstraints39.gridx = 1;
            consGridBagConstraints40.insets = new Insets(8, 7, 4, 10);
            consGridBagConstraints40.gridy = 0;
            consGridBagConstraints40.gridx = 3;
            consGridBagConstraints40.anchor = 13;
            consGridBagConstraints38.insets = new Insets(13, 10, 9, 3);
            consGridBagConstraints38.gridy = 0;
            consGridBagConstraints38.gridx = 0;
            consGridBagConstraints38.anchor = 17;
            consGridBagConstraints38.fill = 0;
            consGridBagConstraints45.gridwidth = 2;
            consGridBagConstraints44.insets = new Insets(6, 121, 12, 5);
            consGridBagConstraints44.gridwidth = 2;
            consGridBagConstraints44.gridy = 2;
            consGridBagConstraints44.gridx = 0;
            consGridBagConstraints41.insets = new Insets(13, 10, 9, 3);
            consGridBagConstraints41.gridy = 1;
            consGridBagConstraints41.gridx = 0;
            consGridBagConstraints41.anchor = 17;
            consGridBagConstraints41.fill = 0;
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getJLabel(), consGridBagConstraints38);
            this.jContentPane.add((Component)this.getTxtInputFileName(), consGridBagConstraints39);
            this.jContentPane.add((Component)this.getBtnbrowseInputFileName(), consGridBagConstraints40);
            this.jContentPane.add((Component)this.getJLabel1(), consGridBagConstraints41);
            this.jContentPane.add((Component)this.getTxtErrorFilePath(), consGridBagConstraints42);
            this.jContentPane.add((Component)this.getBtnbrowseErrorFilePath(), consGridBagConstraints43);
            this.jContentPane.add((Component)this.getBtnValidate(), consGridBagConstraints45);
            this.jContentPane.add((Component)this.getBtnExit(), consGridBagConstraints1);
            this.jContentPane.add((Component)this.getBtnHelp(), consGridBagConstraints44);
        }
        return this.jContentPane;
    }

    private JLabel getJLabel() {
        if (this.jLabel == null) {
            this.jLabel = new JLabel();
            this.jLabel.setText("Input File Name with Path");
        }
        return this.jLabel;
    }

    private JLabel getJLabel1() {
        if (this.jLabel1 == null) {
            this.jLabel1 = new JLabel();
            this.jLabel1.setText("Error/Upload & Control Sheet Report File Path");
        }
        return this.jLabel1;
    }

    private JTextField getTxtInputFileName() {
        if (this.txtInputFileName == null) {
            this.txtInputFileName = new JTextField();
            this.txtInputFileName.setPreferredSize(new Dimension(150, 19));
            this.txtInputFileName.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent arg0) {
                }

                public void focusLost(FocusEvent arg0) {
                    String inputFilePath = PAOFvu.this.txtInputFileName.getText().trim();
                    String errorFilePath = PAOFvu.this.txtErrorFilePath.getText().trim();
                    if (inputFilePath.length() != 0 && errorFilePath.length() != 0) {
                        PAOFvu.this.btnValidate.setEnabled(true);
                    }
                }
            });
        }
        return this.txtInputFileName;
    }

    private JTextField getTxtErrorFilePath() {
        if (this.txtErrorFilePath == null) {
            this.txtErrorFilePath = new JTextField();
            this.txtErrorFilePath.setPreferredSize(new Dimension(150, 19));
            this.txtErrorFilePath.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent arg0) {
                }

                public void focusLost(FocusEvent arg0) {
                    String inputFilePath = PAOFvu.this.txtInputFileName.getText().trim();
                    String errorFilePath = PAOFvu.this.txtErrorFilePath.getText().trim();
                    if (errorFilePath.length() != 0 && inputFilePath.length() != 0) {
                        PAOFvu.this.btnValidate.setEnabled(true);
                    }
                }
            });
        }
        return this.txtErrorFilePath;
    }

    private JButton getBtnValidate() {
        if (this.btnValidate == null) {
            this.btnValidate = new JButton();
            this.btnValidate.setText("Validate");
            this.btnValidate.setToolTipText("VALIDATE FILE");
            this.btnValidate.setPreferredSize(new Dimension(84, 25));
            this.btnValidate.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        SubContrFileFormatValidator obj_FormValidator = new SubContrFileFormatValidator();
                        HtmlFileGenerator obj_FileGenerator = new HtmlFileGenerator();
                        String inFileName = PAOFvu.this.txtInputFileName.getText().trim();
                        String errorFileName = PAOFvu.this.txtErrorFilePath.getText().trim();
                        String hashFileName = null;
                        String controlSheetFileName = null;
                        String htmlErrorFileName = null;
                        File addrFile = new File(inFileName);
                        String filePath = addrFile.getAbsolutePath();
                        String fileName = addrFile.getName();
                        String fileSeparator = System.getProperty("file.separator");
                        ArrayList<PAOContrErrorFileVO> listErrorVO = new ArrayList<PAOContrErrorFileVO>();
                        int errorCode = PAOFvu.this.checkFileFolderName(fileName);
                        File errorDir = new File(errorFileName);
                        if (errorFileName.length() == 0) {
                            errorCode = 8;
                        }
                        if (errorCode == 0) {
                            int i = inFileName.length() - 1;
                            while (i > -1) {
                                char ch = inFileName.charAt(i);
                                if (ch == '.') break;
                                --i;
                            }
                            if (i > 0) {
                                int j = i;
                                while (j > -1) {
                                    if (String.valueOf(inFileName.charAt(j)).equals(fileSeparator)) break;
                                    --j;
                                }
                                hashFileName = String.valueOf(errorFileName) + fileSeparator + inFileName.substring(j + 1, i) + ".fvu";
                                htmlErrorFileName = String.valueOf(errorFileName) + fileSeparator + inFileName.substring(j + 1, i) + "err.html";
                                controlSheetFileName = String.valueOf(errorFileName) + fileSeparator + inFileName.substring(j + 1, i) + ".html";
                            } else {
                                int j = inFileName.length() - 1;
                                while (j > -1) {
                                    if (String.valueOf(inFileName.charAt(j)).equals(fileSeparator)) break;
                                    --j;
                                }
                                hashFileName = String.valueOf(errorFileName) + fileSeparator + inFileName.substring(j + 1, inFileName.length()) + ".fvu";
                                htmlErrorFileName = String.valueOf(errorFileName) + fileSeparator + inFileName.substring(j + 1, inFileName.length()) + "err.html";
                                controlSheetFileName = String.valueOf(errorFileName) + fileSeparator + inFileName.substring(j + 1, inFileName.length()) + ".html";
                            }
                            if (!errorDir.isDirectory()) {
                                JOptionPane.showMessageDialog(PAOFvu.this.jContentPane, "Error/Upload and Control Sheet Report File Path does not exist or \n File Name specified along with path.");
                                PAOFvu.this.txtErrorFilePath.setText("");
                            } else if (addrFile.exists() && addrFile.length() > 0L) {
                                obj_FormValidator.readFile(inFileName, listErrorVO, 0);
                                if (listErrorVO.size() == 0) {
                                    Hash hash = new Hash();
                                    int hashError = hash.startProcessing(inFileName, hashFileName, 0, 5);
                                    if (hashError == 0) {
                                        SubContrOutputFileGenerator obj_FileGeneratorRep = new SubContrOutputFileGenerator();
                                        String hashFileLocation = hashFileName.substring(0, hashFileName.lastIndexOf(fileSeparator));
                                        obj_FileGeneratorRep.generateControlSheetReport(obj_FormValidator, controlSheetFileName, filePath, CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion"));
                                        JOptionPane.showMessageDialog(PAOFvu.this.jContentPane, "File Validation Successful.\r\nUpload File,Control Sheet Report generated at \r\n" + hashFileLocation);
                                        System.out.println("End time : " + System.currentTimeMillis());
                                    } else if (hashError != 0) {
                                        int lineNumber = hash.getRecordNumber();
                                        if (hashError == 3) {
                                            listErrorVO.add(new PAOContrErrorFileVO("-", 201012, "File Header Record", "-", "-", "-", "1", "-"));
                                        } else if (hashError == 4) {
                                            listErrorVO.add(new PAOContrErrorFileVO("-", 201013, "File Header Record", "-", "-", "-", "1", "-"));
                                        } else if (hashError == 5) {
                                            listErrorVO.add(new PAOContrErrorFileVO("-", 201014, "File Header Record", "-", "-", "-", "1", "-"));
                                        } else if (hashError == 9) {
                                            listErrorVO.add(new PAOContrErrorFileVO("-", 201015, "File Header Record", "-", "-", "-", "1", "-"));
                                        } else if (hashError == 10) {
                                            listErrorVO.add(new PAOContrErrorFileVO("-", 201016, "File Header Record", "-", "-", "-", "1", "-"));
                                        } else if (hashError == 11) {
                                            listErrorVO.add(new PAOContrErrorFileVO("-", 201017, "File Header Record", "-", "-", "-", "1", "-"));
                                        } else {
                                            listErrorVO.add(new PAOContrErrorFileVO("-", 201018, "-", "-", "-", "-", String.valueOf(lineNumber), "-"));
                                        }
                                        if (obj_FormValidator.uploadBy != null && obj_FormValidator.uploadBy.equals("U")) {
                                            obj_FileGenerator.generateHtmlErrorFile(listErrorVO, "", "SUBSCRIBER CONTRIBUTION ERROR FILE", "<TR class=tdColumnDetails><TD WIDTH=70 VALIGN=top ><B>Line No</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Record Type</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Field Name & No.*</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>POP-SP Serial No.</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>    Subscriber Contribution Serial No.   </B></CENTER></TD> <TD WIDTH=85 VALIGN=top><B> PRAN </B></CENTER></TD> <TD WIDTH=130 VALIGN=top><B>    Error Code   </B></CENTER></TD><TD WIDTH=450 VALIGN=top><B>Error Description</B></CENTER></TD><TD WIDTH=130 VALIGN=top><B>Error / Warning</B></CENTER></TD></TR>", "<TABLE class=text><TR><TD>* Field Name & No. is as per the file format</TD></TR><TR><TD>FVU Version : " + CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion") + "</TD></TR><TR><TD> Input File Name : " + inFileName + "</TD></TR></TABLE>", htmlErrorFileName);
                                        } else if (obj_FormValidator.uploadBy != null && obj_FormValidator.uploadBy.equals("P")) {
                                            obj_FileGenerator.generateHtmlErrorFile(listErrorVO, "", "SUBSCRIBER CONTRIBUTION ERROR FILE", "<TR class=tdColumnDetails><TD WIDTH=70 VALIGN=top ><B>Line No</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Record Type</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Field Name & No.*</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>NL-CC Serial No.</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>    Subscriber Contribution Serial No.   </B></CENTER></TD> <TD WIDTH=85 VALIGN=top><B> PRAN </B></CENTER></TD> <TD WIDTH=130 VALIGN=top><B>    Error Code   </B></CENTER></TD><TD WIDTH=450 VALIGN=top><B>Error Description</B></CENTER></TD><TD WIDTH=130 VALIGN=top><B>Error / Warning</B></CENTER></TD></TR>", "<TABLE class=text><TR><TD>* Field Name & No. is as per the file format</TD></TR><TR><TD>FVU Version : " + CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion") + "</TD></TR><TR><TD> Input File Name : " + inFileName + "</TD></TR></TABLE>", htmlErrorFileName);
                                        } else if (obj_FormValidator.uploadBy != null && obj_FormValidator.uploadBy.equals("O")) {
                                            obj_FileGenerator.generateHtmlErrorFile(listErrorVO, "", "SUBSCRIBER CONTRIBUTION ERROR FILE", "<TR class=tdColumnDetails><TD WIDTH=70 VALIGN=top ><B>Line No</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Record Type</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Field Name & No.*</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>NL-OO Serial No.</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>    Subscriber Contribution Serial No.   </B></CENTER></TD> <TD WIDTH=85 VALIGN=top><B> PRAN </B></CENTER></TD> <TD WIDTH=130 VALIGN=top><B>    Error Code   </B></CENTER></TD><TD WIDTH=450 VALIGN=top><B>Error Description</B></CENTER></TD><TD WIDTH=130 VALIGN=top><B>Error / Warning</B></CENTER></TD></TR>", "<TABLE class=text><TR><TD>* Field Name & No. is as per the file format</TD></TR><TR><TD>FVU Version : " + CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion") + "</TD></TR><TR><TD> Input File Name : " + inFileName + "</TD></TR></TABLE>", htmlErrorFileName);
                                        } else if (obj_FormValidator.uploadBy != null && obj_FormValidator.uploadBy.equals("X") && obj_FormValidator.uploadBy.equals("Y")) {
                                            obj_FileGenerator.generateHtmlErrorFile(listErrorVO, "", "SUBSCRIBER CONTRIBUTION ERROR FILE", "<TR class=tdColumnDetails><TD WIDTH=70 VALIGN=top ><B>Line No</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Record Type</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Field Name & No.*</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>NL-OO/NL-CC Serial No.</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>    Subscriber Contribution Serial No.   </B></CENTER></TD> <TD WIDTH=85 VALIGN=top><B> PRAN </B></CENTER></TD> <TD WIDTH=130 VALIGN=top><B>    Error Code   </B></CENTER></TD><TD WIDTH=450 VALIGN=top><B>Error Description</B></CENTER></TD><TD WIDTH=130 VALIGN=top><B>Error / Warning</B></CENTER></TD></TR>", "<TABLE class=text><TR><TD>* Field Name & No. is as per the file format</TD></TR><TR><TD>FVU Version : " + CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion") + "</TD></TR><TR><TD> Input File Name : " + inFileName + "</TD></TR></TABLE>", htmlErrorFileName);
                                        } else {
                                            obj_FileGenerator.generateHtmlErrorFile(listErrorVO, "", "SUBSCRIBER CONTRIBUTION ERROR FILE", "<TR class=tdColumnDetails><TD WIDTH=70 VALIGN=top ><B>Line No</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Record Type</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Field Name & No.*</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>NL-OO/NL-CC/POP-SP Serial No.</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>    Subscriber Contribution Serial No.   </B></CENTER></TD> <TD WIDTH=85 VALIGN=top><B> PRAN </B></CENTER></TD> <TD WIDTH=130 VALIGN=top><B>    Error Code   </B></CENTER></TD><TD WIDTH=450 VALIGN=top><B>Error Description</B></CENTER></TD><TD WIDTH=130 VALIGN=top><B>Error / Warning</B></CENTER></TD></TR>", "<TABLE class=text><TR><TD>* Field Name & No. is as per the file format</TD></TR><TR><TD>FVU Version : " + CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion") + "</TD></TR><TR><TD> Input File Name : " + inFileName + "</TD></TR></TABLE>", htmlErrorFileName);
                                        }
                                        JOptionPane.showMessageDialog(PAOFvu.this.jContentPane, "Errors Found during Validation.\r\nHTML Error File Generated\r\nOpen " + htmlErrorFileName + " for details");
                                    }
                                } else {
                                    if (obj_FormValidator.uploadBy != null && obj_FormValidator.uploadBy.equals("U")) {
                                        obj_FileGenerator.generateHtmlErrorFile(listErrorVO, "", "SUBSCRIBER CONTRIBUTION ERROR FILE", "<TR class=tdColumnDetails><TD WIDTH=70 VALIGN=top ><B>Line No</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Record Type</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Field Name & No.*</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>POP-SP Serial No.</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>    Subscriber Contribution Serial No.   </B></CENTER></TD> <TD WIDTH=85 VALIGN=top><B> PRAN </B></CENTER></TD> <TD WIDTH=130 VALIGN=top><B>    Error Code   </B></CENTER></TD><TD WIDTH=450 VALIGN=top><B>Error Description</B></CENTER></TD><TD WIDTH=130 VALIGN=top><B>Error / Warning</B></CENTER></TD></TR>", "<TABLE class=text><TR><TD>* Field Name & No. is as per the file format</TD></TR><TR><TD>FVU Version : " + CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion") + "</TD></TR><TR><TD> Input File Name : " + inFileName + "</TD></TR></TABLE>", htmlErrorFileName);
                                    } else if (obj_FormValidator.uploadBy != null && obj_FormValidator.uploadBy.equals("P")) {
                                        obj_FileGenerator.generateHtmlErrorFile(listErrorVO, "", "SUBSCRIBER CONTRIBUTION ERROR FILE", "<TR class=tdColumnDetails><TD WIDTH=70 VALIGN=top ><B>Line No</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Record Type</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Field Name & No.*</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>NL-CC Serial No.</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>    Subscriber Contribution Serial No.   </B></CENTER></TD> <TD WIDTH=85 VALIGN=top><B> PRAN </B></CENTER></TD> <TD WIDTH=130 VALIGN=top><B>    Error Code   </B></CENTER></TD><TD WIDTH=450 VALIGN=top><B>Error Description</B></CENTER></TD><TD WIDTH=130 VALIGN=top><B>Error / Warning</B></CENTER></TD></TR>", "<TABLE class=text><TR><TD>* Field Name & No. is as per the file format</TD></TR><TR><TD>FVU Version : " + CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion") + "</TD></TR><TR><TD> Input File Name : " + inFileName + "</TD></TR></TABLE>", htmlErrorFileName);
                                    } else if (obj_FormValidator.uploadBy != null && obj_FormValidator.uploadBy.equals("O")) {
                                        obj_FileGenerator.generateHtmlErrorFile(listErrorVO, "", "SUBSCRIBER CONTRIBUTION ERROR FILE", "<TR class=tdColumnDetails><TD WIDTH=70 VALIGN=top ><B>Line No</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Record Type</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Field Name & No.*</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>NL-OO Serial No.</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>    Subscriber Contribution Serial No.   </B></CENTER></TD> <TD WIDTH=85 VALIGN=top><B> PRAN </B></CENTER></TD> <TD WIDTH=130 VALIGN=top><B>    Error Code   </B></CENTER></TD><TD WIDTH=450 VALIGN=top><B>Error Description</B></CENTER></TD><TD WIDTH=130 VALIGN=top><B>Error / Warning</B></CENTER></TD></TR>", "<TABLE class=text><TR><TD>* Field Name & No. is as per the file format</TD></TR><TR><TD>FVU Version : " + CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion") + "</TD></TR><TR><TD> Input File Name : " + inFileName + "</TD></TR></TABLE>", htmlErrorFileName);
                                    } else if (obj_FormValidator.uploadBy != null && (obj_FormValidator.uploadBy.equals("X") || obj_FormValidator.uploadBy.equals("Y"))) {
                                        obj_FileGenerator.generateHtmlErrorFile(listErrorVO, "", "SUBSCRIBER CONTRIBUTION ERROR FILE", "<TR class=tdColumnDetails><TD WIDTH=70 VALIGN=top ><B>Line No</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Record Type</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Field Name & No.*</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>NL-OO/NL-CC Serial No.</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>    Subscriber Contribution Serial No.   </B></CENTER></TD> <TD WIDTH=85 VALIGN=top><B> PRAN </B></CENTER></TD> <TD WIDTH=130 VALIGN=top><B>    Error Code   </B></CENTER></TD><TD WIDTH=450 VALIGN=top><B>Error Description</B></CENTER></TD><TD WIDTH=130 VALIGN=top><B>Error / Warning</B></CENTER></TD></TR>", "<TABLE class=text><TR><TD>* Field Name & No. is as per the file format</TD></TR><TR><TD>FVU Version : " + CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion") + "</TD></TR><TR><TD> Input File Name : " + inFileName + "</TD></TR></TABLE>", htmlErrorFileName);
                                    } else {
                                        obj_FileGenerator.generateHtmlErrorFile(listErrorVO, "", "SUBSCRIBER CONTRIBUTION ERROR FILE", "<TR class=tdColumnDetails><TD WIDTH=70 VALIGN=top ><B>Line No</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Record Type</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Field Name & No.*</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>NL-OO/NL-CC/POP-SP Serial No.</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>    Subscriber Contribution Serial No.   </B></CENTER></TD> <TD WIDTH=85 VALIGN=top><B> PRAN </B></CENTER></TD> <TD WIDTH=130 VALIGN=top><B>    Error Code   </B></CENTER></TD><TD WIDTH=450 VALIGN=top><B>Error Description</B></CENTER></TD><TD WIDTH=130 VALIGN=top><B>Error / Warning</B></CENTER></TD></TR>", "<TABLE class=text><TR><TD>* Field Name & No. is as per the file format</TD></TR><TR><TD>FVU Version : " + CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion") + "</TD></TR><TR><TD> Input File Name : " + inFileName + "</TD></TR></TABLE>", htmlErrorFileName);
                                    }
                                    JOptionPane.showMessageDialog(PAOFvu.this.jContentPane, "Errors Found during Validation.\r\nHTML Error File Generated\r\nOpen " + htmlErrorFileName + " for details");
                                }
                                PAOFvu.this.txtInputFileName.setText("");
                                PAOFvu.this.txtErrorFilePath.setText("");
                                PAOFvu.this.btnValidate.setEnabled(false);
                            } else {
                                listErrorVO.add(new PAOContrErrorFileVO("-", 201011, "File Header Record", "-", "-", "-", "1", "-"));
                                obj_FileGenerator.generateHtmlErrorFile(listErrorVO, "", "SUBSCRIBER CONTRIBUTION ERROR FILE", "<TR class=tdColumnDetails><TD WIDTH=70 VALIGN=top ><B>Line No</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Record Type</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>Field Name & No.*</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>NL-CC/POP-SP/NL-OO Serial No.</B></CENTER></TD><TD WIDTH=85 VALIGN=top><B>    Subscriber Contribution Serial No.   </B></CENTER></TD> <TD WIDTH=85 VALIGN=top><B> PRAN </B></CENTER></TD> <TD WIDTH=130 VALIGN=top><B>    Error Code   </B></CENTER></TD><TD WIDTH=450 VALIGN=top><B>Error Description</B></CENTER></TD><TD WIDTH=130 VALIGN=top><B>Error / Warning</B></CENTER></TD></TR>", "<TABLE class=text><TR><TD>* Field Name & No. is as per the file format</TD></TR><TR><TD>FVU Version : " + CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion") + "</TD></TR><TR><TD> Input File Name : " + inFileName + "</TD></TR></TABLE>", htmlErrorFileName);
                                JOptionPane.showMessageDialog(PAOFvu.this.jContentPane, "Errors Found during Validation.\r\nHTML Error File Generated\r\nOpen " + htmlErrorFileName + " for details");
                                PAOFvu.this.txtInputFileName.setText("");
                                PAOFvu.this.txtErrorFilePath.setText("");
                                PAOFvu.this.btnValidate.setEnabled(false);
                            }
                        } else {
                            if (errorCode == 1 || errorCode == 8) {
                                JOptionPane.showMessageDialog(PAOFvu.this.jContentPane, "Input File Name with Path or \n Error/Upload and Control Sheet Report File Path not chosen");
                            } else if (errorCode == 2) {
                                JOptionPane.showMessageDialog(PAOFvu.this.jContentPane, "Invalid Input File Name. Length of Input File Name cannot be more than 24 characters (including extension).");
                            } else if (errorCode == 3) {
                                JOptionPane.showMessageDialog(PAOFvu.this.jContentPane, "Invalid Input File Name");
                            } else if (errorCode == 5) {
                                JOptionPane.showMessageDialog(PAOFvu.this.jContentPane, "Invalid File Name.\n  :  /  ?  >  <  *  \"  |  \\  ^  _ or Space, not allowed in File Name.");
                            } else if (errorCode == 6) {
                                JOptionPane.showMessageDialog(PAOFvu.this.jContentPane, "Invalid Input File extension. File extension should be '.txt'");
                            }
                            PAOFvu.this.txtInputFileName.setText("");
                            PAOFvu.this.txtErrorFilePath.setText("");
                            PAOFvu.this.btnValidate.setEnabled(false);
                        }
                    }
                    catch (Exception o) {
                        o.printStackTrace();
                    }
                }
            });
        }
        return this.btnValidate;
    }

    private JButton getBtnExit() {
        if (this.btnExit == null) {
            this.btnExit = new JButton();
            this.btnExit.setText("Exit");
            this.btnExit.setToolTipText("CLOSE THE PROGRAM");
            this.btnExit.setPreferredSize(new Dimension(84, 25));
            this.btnExit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    System.exit(0);
                }
            });
        }
        return this.btnExit;
    }

    private JButton getBtnbrowseInputFileName() {
        if (this.btnbrowseInputFileName == null) {
            this.btnbrowseInputFileName = new JButton();
            this.btnbrowseInputFileName.setText("Browse");
            this.btnbrowseInputFileName.setToolTipText("CHOOSE A FILE FOR VALIDATION");
            this.btnbrowseInputFileName.setPreferredSize(new Dimension(84, 25));
            try {
                this.btnbrowseInputFileName.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        JFileChooser jf = new JFileChooser();
                        jf.addChoosableFileFilter(new TextFileFilter());
                        if (PAOFvu.this.previousSorurceFileFolder.trim().length() == 0) {
                            jf.setCurrentDirectory(jf.getCurrentDirectory());
                        } else {
                            File currentFile = new File(PAOFvu.this.previousSorurceFileFolder.trim());
                            jf.setCurrentDirectory(currentFile);
                        }
                        jf.setDialogTitle("Open Input File Name");
                        int result = jf.showOpenDialog(((JButton)e.getSource()).getParent().getParent().getParent().getParent());
                        if (result != 1 && result != -1) {
                            PAOFvu.this.txtInputFileName.setText(jf.getSelectedFile().getPath());
                            PAOFvu.this.file = jf.getSelectedFile().getPath();
                            PAOFvu.this.previousSorurceFileFolder = jf.getSelectedFile().getPath();
                            if (PAOFvu.this.txtErrorFilePath.getText().length() != 0 && PAOFvu.this.txtInputFileName.getText().length() != 0) {
                                PAOFvu.this.btnValidate.setEnabled(true);
                            }
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.btnbrowseInputFileName;
    }

    private JButton getBtnbrowseErrorFilePath() {
        if (this.btnbrowseErrorFilePath == null) {
            this.btnbrowseErrorFilePath = new JButton();
            this.btnbrowseErrorFilePath.setText("Browse");
            this.btnbrowseErrorFilePath.setToolTipText("CHOOSE A FOLDER TO SAVE OUTPUT FILE");
            this.btnbrowseErrorFilePath.setPreferredSize(new Dimension(84, 25));
            this.btnbrowseErrorFilePath.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFileChooser jf = new JFileChooser();
                    jf.setFileSelectionMode(1);
                    if (PAOFvu.this.previousOutputFileFolder.trim().length() == 0) {
                        jf.setCurrentDirectory(jf.getCurrentDirectory());
                    } else {
                        File currentFile = new File(PAOFvu.this.previousOutputFileFolder.trim());
                        jf.setCurrentDirectory(currentFile);
                    }
                    jf.setDialogTitle("Select Folder to save Output File");
                    jf.setApproveButtonToolTipText("CHOOSE A FOLDER TO SAVE OUTPUT FILE");
                    int result = jf.showOpenDialog(((JButton)e.getSource()).getParent().getParent().getParent().getParent());
                    if (result != 1 && result != -1) {
                        PAOFvu.this.txtErrorFilePath.setText(jf.getSelectedFile().getPath());
                        PAOFvu.this.previousOutputFileFolder = jf.getSelectedFile().getPath();
                        if (PAOFvu.this.txtErrorFilePath.getText().length() != 0 && PAOFvu.this.txtInputFileName.getText().length() != 0) {
                            PAOFvu.this.btnValidate.setEnabled(true);
                        }
                    }
                }
            });
        }
        return this.btnbrowseErrorFilePath;
    }

    private int checkFileFolderName(String testName) {
        String subName;
        if (testName.length() == 0) {
            return 1;
        }
        if (testName.length() <= 3) {
            return 3;
        }
        if (testName.length() > 24) {
            return 2;
        }
        if (testName.trim().length() >= 5 && ((subName = testName.substring(0, 4)).equalsIgnoreCase("COM1.") || subName.equalsIgnoreCase("COM2.") || subName.equalsIgnoreCase("COM3.") || subName.equalsIgnoreCase("COM4.") || subName.equalsIgnoreCase("COM5.") || subName.equalsIgnoreCase("COM6.") || subName.equalsIgnoreCase("COM7.") || subName.equalsIgnoreCase("COM8.") || subName.equalsIgnoreCase("COM9.") || subName.equalsIgnoreCase("LTP1.") || subName.equalsIgnoreCase("LTP2.") || subName.equalsIgnoreCase("LTP3.") || subName.equalsIgnoreCase("LTP4.") || subName.equalsIgnoreCase("LTP5.") || subName.equalsIgnoreCase("LTP6.") || subName.equalsIgnoreCase("LTP7.") || subName.equalsIgnoreCase("LTP8.") || subName.equalsIgnoreCase("LTP9."))) {
            return 3;
        }
        if (testName.trim().length() >= 4 && (testName.substring(0, 3).equalsIgnoreCase("NUL.") || testName.substring(0, 3).equalsIgnoreCase("CON."))) {
            return 3;
        }
        int localI = 0;
        while (localI < testName.length()) {
            if (testName.charAt(localI) == '/' || testName.charAt(localI) == ':' || testName.charAt(localI) == '*' || testName.charAt(localI) == '?' || testName.charAt(localI) == '\"' || testName.charAt(localI) == '<' || testName.charAt(localI) == '>' || testName.charAt(localI) == '|' || testName.charAt(localI) == '\\' || testName.charAt(localI) == ' ' || testName.charAt(localI) == '_' || testName.charAt(localI) == '^') {
                return 5;
            }
            ++localI;
        }
        int alphaDigit = 3;
        int localY = 0;
        while (localY < testName.length()) {
            if (Character.isLetterOrDigit(testName.charAt(localY))) {
                alphaDigit = 0;
                break;
            }
            ++localY;
        }
        if (alphaDigit == 3) {
            return 3;
        }
        if (!testName.trim().endsWith(".txt") && !testName.trim().endsWith(".TXT")) {
            return 6;
        }
        return 0;
    }

    private JButton getBtnHelp() {
        if (this.btnHelp == null) {
            this.btnHelp = new JButton();
            this.btnHelp.setPreferredSize(new Dimension(84, 25));
            this.btnHelp.setActionCommand("Help");
            this.btnHelp.setText("Help");
            this.btnHelp.setToolTipText("OPEN HELP FILE");
            this.btnHelp.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PAOFvu.this.btnHelp.setEnabled(false);
                    PAOFvu.this.jHelpTextPane = new JTextPane();
                    PAOFvu.this.jHelpTextPane.setEditable(false);
                    try {
                        PAOFvu.this.jHelpTextPane.setPage(this.getClass().getResource("/cra/standalone/paosubcontr/help.txt"));
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    JScrollPane objScrollPane = new JScrollPane(PAOFvu.this.jHelpTextPane, 22, 30);
                    PAOFvu.this.jHelpTextPane.setVisible(true);
                    String title = "FVU - Help";
                    Frame helpFrame = new Frame(title);
                    JScrollPane comp = new JScrollPane();
                    helpFrame.add((Component)comp, "Center");
                    int width = 600;
                    int height = 350;
                    helpFrame.setSize(width, height);
                    helpFrame.add(objScrollPane);
                    helpFrame.setLocation(0, 0);
                    helpFrame.setVisible(true);
                    helpFrame.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/cra/standalone/paosubcontr/nsdl-logo.jpg")));
                    helpFrame.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent evt) {
                            Frame helpFrame = (Frame)evt.getSource();
                            helpFrame.setVisible(false);
                            helpFrame.dispose();
                            PAOFvu.this.btnHelp.setEnabled(true);
                        }
                    });
                }
            });
        }
        return this.btnHelp;
    }

    class TextFileFilter
    extends FileFilter {
        TextFileFilter() {
        }

        public boolean accept(File file) {
            String filename = file.getName();
            return filename.endsWith(".txt");
        }

        public String getDescription() {
            return "*.txt";
        }
    }
}

