/*
 * Decompiled with CFR 0.152.
 */
package com.cra.pao.fvu;

import com.cra.common.util.CommonValidation;
import com.cra.common.util.file.CRAFileReader;
import com.cra.pao.fvu.BatchValidation;
import com.cra.pao.fvu.DDORecordValidation;
import com.cra.pao.fvu.FileHeaderValidation;
import com.cra.pao.fvu.FvuConstants;
import com.cra.pao.fvu.SubContrRecordValidator;
import com.cra.pao.vo.PAOContrErrorFileVO;
import com.cra.pao.vo.PAOSubDetailVO;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubContrFileFormatValidator {
    private int lineCnt = 0;
    private int lineCount = 0;
    private BigDecimal govtContributionInBatch = null;
    private BigDecimal selfContributionInBatch = null;
    public String lineNo = null;
    public String recType = null;
    public String uploaderId = null;
    public String typeOfUploadedFile = null;
    public String totalCountOfDDO = null;
    public String uploadBy = null;
    public String batchNo = null;
    public String totalCountOfSD = null;
    public String ddoSerialNo = null;
    public String totalCountOfSubscribers = null;
    public String batchTotalGovtContrbutionOfDDO = null;
    public String batchTotalSelfContrbutionOfDDO = null;
    public String totalGovtContributionInDDO = null;
    public String totalSelfContributionInDDO = null;
    public String tierOneGovtContribution = null;
    public String tierOneSelfContribution = null;
    public String totalOfTierOneTierTwo = null;
    public BigDecimal govtContributionInDDO = null;
    public BigDecimal selfContributionInDDO = null;
    public BigDecimal subscriberGovtContribution = null;
    public BigDecimal subscriberSelfContribution = null;
    public BigDecimal totalTierOneGovtAmt = new BigDecimal(0.0);
    public BigDecimal totalTierOneSelfAmt = new BigDecimal(0.0);
    public int totalNoOfSDRead = 0;
    public int totalNoOfDDORead = 0;
    public String ddoId = null;
    public String sectorCategory = "";
    public String RECTYPE_DDOREC = null;
    public String PAO_FH_FIELD_4 = null;
    public String PAO_BH_FIELD_5 = null;
    public String PAO_BH_FIELD_9 = null;
    public String PAO_BH_FIELD_11 = null;
    public String PAO_BH_FIELD_12 = null;
    public String PAO_DDO_FIELD_4 = null;
    public String PAO_DDO_FIELD_5 = null;
    public String PAO_DDO_FIELD_7 = null;
    public String PAO_DDO_FIELD_8 = null;
    public String PAO_DDO_FIELD_10 = null;
    public String PAO_SD_FIELD_4 = null;
    public String PAO_SD_FIELD_7 = null;
    public String PAO_SD_FIELD_8 = null;
    public String PAO_SD_FIELD_12 = null;
    public String PAO_SD_FIELD_13 = null;
    public String PAO_SD_FIELD_14 = null;
    public String PAO_SD_FIELD_15 = null;
    public boolean invalidTotalContributionInBatch = false;
    public boolean inValidFhCaretCount = false;
    public boolean inValidBhCaretCount = false;
    public boolean invalidRecord = false;
    public boolean invalidDdoCaretCount = false;
    public boolean invalidSdCaretCount = false;
    public boolean inValidContributionAmt = false;
    public boolean invalidTotalContributionInDDO = false;
    public boolean invalidAIN = false;
    public boolean invalidTAN = false;
    public boolean invalidSubCount = false;
    public boolean invalidDDOCount = false;
    public boolean inValidfirstDDOSerialNo = false;
    public boolean invalidCaretPos = false;
    public StringBuffer controlSheetBuffer = new StringBuffer();
    PAOSubDetailVO objPaoSubDetailBean = new PAOSubDetailVO();
    public ArrayList<PAOSubDetailVO> pranListArr = new ArrayList();
    public HashMap<String, String> pranList = new HashMap();
    private BigDecimal totalContrAmtReg = new BigDecimal(0.0);
    private BigDecimal totalContrAmtArr = new BigDecimal(0.0);
    private BigDecimal totalContrAmtAdhoc = new BigDecimal(0.0);
    private BigDecimal totalContrAmtGovt = new BigDecimal(0.0);
    private BigDecimal totalContrAmtSwav = new BigDecimal(0.0);
    public ArrayList<String> warnings = new ArrayList();
    private int DuplicateCount = 0;
    ArrayList<String> comboList = new ArrayList();
    ArrayList<String> pransList = new ArrayList();
    int uniquePranCount = 0;
    int record_C = 0;
    int record_A = 0;
    int record_0 = 0;
    int record_G = 0;
    int record_Sw = 0;

    public void readFile(String inputFileName, ArrayList<PAOContrErrorFileVO> listErrorVO, int utilityLevel) {
        FileHeaderValidation objFHVal = new FileHeaderValidation();
        BatchValidation objBHVal = new BatchValidation();
        DDORecordValidation objDDOVal = new DDORecordValidation();
        SubContrRecordValidator objSDVal = new SubContrRecordValidator();
        boolean ddoRecordFound = false;
        boolean sdRecordFound = false;
        int totalSubscriberCount = 0;
        int sdCount = 0;
        try {
            CRAFileReader objCraFileReader = new CRAFileReader(inputFileName);
            ArrayList<String> fileData = objCraFileReader.getAllLinesInArrayList();
            String values = null;
            String[] data = null;
            boolean carretBol = false;
            String token = null;
            int i = 0;
            while (i < fileData.size()) {
                values = fileData.get(i);
                ++this.lineCount;
                if (fileData.size() < 4) {
                    this.invalidRecord = true;
                    listErrorVO.add(new PAOContrErrorFileVO("-", 205006, "-", "-", "-", "-", "-", "-"));
                    break;
                }
                if (values.trim().length() == 0) {
                    this.invalidRecord = true;
                    listErrorVO.add(new PAOContrErrorFileVO("-", 205004, "-", "-", "-", "-", "-", "-"));
                    break;
                }
                int localFieldCount = 1;
                int recordCaretCount = 0;
                StringTokenizer objTokenizer = new StringTokenizer(values, "^", true);
                while (objTokenizer.hasMoreTokens()) {
                    token = objTokenizer.nextToken();
                    if (token.equals("^")) {
                        if (localFieldCount == 1) {
                            this.invalidCaretPos = true;
                        }
                        carretBol = true;
                        ++recordCaretCount;
                        continue;
                    }
                    switch (localFieldCount) {
                        case 1: {
                            this.lineNo = token;
                            break;
                        }
                        case 2: {
                            this.recType = token;
                        }
                    }
                    ++localFieldCount;
                }
                if (CommonValidation.isInt(this.lineNo)) {
                    this.invalidRecord = true;
                    listErrorVO.add(new PAOContrErrorFileVO("-", 205006, "-", "-", "-", "-", "-", "-"));
                    break;
                }
                if (!this.invalidRecord && this.lineCount == 1 && recordCaretCount != 11) {
                    this.inValidFhCaretCount = true;
                    listErrorVO.add(new PAOContrErrorFileVO("-", 201000, "File Header Record", "-", "-", "-", String.valueOf(this.lineCount), "-"));
                    this.controlSheetBuffer.append("-^-^-^-^-^");
                } else if (!this.invalidRecord && this.lineCount == 2 && recordCaretCount != 14) {
                    this.inValidBhCaretCount = true;
                    listErrorVO.add(new PAOContrErrorFileVO("-", 202000, "Batch Header Record", "-", "-", "-", String.valueOf(this.lineCount), "-"));
                }
                if (this.lineCount == 1) {
                    data = CRAFileReader.getLineParsed(values, "\\^");
                    objFHVal.fhFieldValidator(this, this.lineCount, data, listErrorVO, utilityLevel);
                } else {
                    if (!this.inValidFhCaretCount && this.lineCount != 1 && this.recType.equals("FH")) {
                        this.invalidRecord = true;
                        listErrorVO.add(new PAOContrErrorFileVO("-", 205001, "-", "-", "-", "-", String.valueOf(this.lineCount), "-"));
                        break;
                    }
                    if (this.uploadBy == null || !this.uploadBy.equals("X") && !this.uploadBy.equals("Y")) {
                        this.invalidRecord = true;
                        listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_FH_FIELD[3], 201007, "File Header Record", "-", "-", "-", "1", "-"));
                        break;
                    }
                    if (this.lineCount == 2) {
                        data = CRAFileReader.getLineParsed(values, "\\^");
                        objBHVal.bhFieldValidator(this, this.lineCount, data, listErrorVO, utilityLevel);
                    } else {
                        if (!this.inValidBhCaretCount && this.lineCount != 2 && this.recType.equals("BH")) {
                            this.invalidRecord = true;
                            listErrorVO.add(new PAOContrErrorFileVO("-", 205002, "-", "-", "-", "-", String.valueOf(this.lineCount), "-"));
                            break;
                        }
                        if (this.lineNo == FvuConstants.FIELD_NULL) {
                            this.invalidRecord = true;
                            listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[1], 203001, "-", "-", "-", "-", "-", "-"));
                            break;
                        }
                        if (CommonValidation.isInt(this.lineNo)) {
                            this.invalidRecord = true;
                            listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[1], 203002, "-", "-", "-", "-", "-", "-"));
                            break;
                        }
                        if (this.invalidCaretPos) {
                            this.invalidRecord = true;
                            listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[1], 203002, "-", "-", "-", "-", "-", "-"));
                            break;
                        }
                        if (this.recType == FvuConstants.FIELD_NULL) {
                            this.invalidRecord = true;
                            listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[2], 205003, "-", "-", "-", "-", String.valueOf(this.lineCount), "-"));
                            break;
                        }
                        if (this.lineCount - 1 == 2 && !this.recType.equals("DH")) {
                            this.invalidRecord = true;
                            listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[2], Integer.parseInt(String.valueOf(this.sectorCategory) + 205005), "-", "-", "-", "-", String.valueOf(this.lineCount), "-"));
                            break;
                        }
                        if (!this.recType.equals("DH") && !this.recType.equals("SD")) {
                            this.invalidRecord = true;
                            listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_SD_FIELD[2], 205003, "-", "-", "-", "-", String.valueOf(this.lineCount), "-"));
                            break;
                        }
                        if (this.recType.equals("DH")) {
                            this.lineCnt = this.lineCount;
                            if (!(this.inValidContributionAmt || ddoRecordFound || !sdRecordFound || this.invalidTotalContributionInDDO || this.invalidSubCount || this.invalidDdoCaretCount)) {
                                this.govtContributionInDDO = new BigDecimal(this.getDdoTierOneGovtContribution());
                                this.selfContributionInDDO = new BigDecimal(this.getDdoTierOneSelfContribution());
                                totalSubscriberCount = Integer.parseInt(this.getTotalSubscriberCount());
                                this.lineCnt = this.lineCount - this.totalNoOfSDRead - 1;
                                if (this.totalNoOfSDRead > totalSubscriberCount) {
                                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[6], Integer.parseInt(String.valueOf(this.sectorCategory) + 203014), this.RECTYPE_DDOREC, "-", "-", "-", String.valueOf(this.lineCnt), "-"));
                                } else if (this.totalNoOfSDRead < totalSubscriberCount) {
                                    listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[6], Integer.parseInt(String.valueOf(this.sectorCategory) + 203013), this.RECTYPE_DDOREC, "-", "-", "-", String.valueOf(this.lineCnt), "-"));
                                } else {
                                    if (!this.govtContributionInDDO.equals(this.subscriberGovtContribution)) {
                                        listErrorVO.add(new PAOContrErrorFileVO(this.PAO_DDO_FIELD_7, Integer.parseInt(String.valueOf(this.sectorCategory) + 203015), this.RECTYPE_DDOREC, "-", "-", "-", String.valueOf(this.lineCnt), "-"));
                                    }
                                    if (!this.selfContributionInDDO.equals(this.subscriberSelfContribution)) {
                                        listErrorVO.add(new PAOContrErrorFileVO(this.PAO_DDO_FIELD_8, Integer.parseInt(String.valueOf(this.sectorCategory) + 203016), this.RECTYPE_DDOREC, "-", "-", "-", String.valueOf(this.lineCnt), "-"));
                                    }
                                }
                            }
                            ddoRecordFound = true;
                            sdRecordFound = false;
                            ++this.totalNoOfDDORead;
                            objDDOVal.ddoFieldValidator(this, this.lineCount, values, listErrorVO, utilityLevel);
                            this.totalNoOfSDRead = 0;
                            this.govtContributionInDDO = new BigDecimal("0.0");
                            this.selfContributionInDDO = new BigDecimal("0.0");
                            this.subscriberGovtContribution = new BigDecimal("0.0");
                            this.subscriberSelfContribution = new BigDecimal("0.0");
                        } else {
                            if (this.lineCnt == this.lineCount - 1 && !this.recType.equals("SD")) {
                                listErrorVO.add(new PAOContrErrorFileVO("-", 205003, "-", "-", "-", "-", String.valueOf(this.lineCount), "-"));
                                break;
                            }
                            if (this.recType.equals("SD")) {
                                ++this.totalNoOfSDRead;
                                sdRecordFound = true;
                                ddoRecordFound = false;
                                objSDVal.sdFieldValidator(this, this.lineCount, values, listErrorVO, this.objPaoSubDetailBean, utilityLevel);
                                if (!this.invalidSdCaretCount && !this.inValidContributionAmt) {
                                    this.subscriberGovtContribution = this.subscriberGovtContribution.add(new BigDecimal(this.objPaoSubDetailBean.getTierOneGovtContribution()));
                                    this.subscriberSelfContribution = this.subscriberSelfContribution.add(new BigDecimal(this.objPaoSubDetailBean.getTierOneSelfContribution()));
                                    ++sdCount;
                                }
                            }
                        }
                    }
                }
                ++i;
            }
            HashSet<String> set2 = new HashSet<String>();
            for (String yourInt : this.getComboList()) {
                if (set2.add(yourInt)) continue;
                String abc1 = yourInt.substring(0, 12);
                this.warnings.add(abc1);
            }
            HashSet<String> set = new HashSet<String>();
            set.addAll(this.warnings);
            this.warnings = new ArrayList(set);
            this.controlSheetBuffer.append(this.getTotalContrAmtReg() + "^");
            System.out.println("getTotalContrAmtReg ::::" + this.getTotalContrAmtReg());
            this.controlSheetBuffer.append(this.getTotalContrAmtArr() + "^");
            System.out.println("getTotalContrAmtArr ::::" + this.getTotalContrAmtArr());
            this.controlSheetBuffer.append(this.getTotalContrAmtAdhoc() + "^");
            System.out.println("getTotalContrAmtself ::::" + this.getTotalContrAmtAdhoc());
            this.controlSheetBuffer.append(this.getTotalContrAmtGovt() + "^");
            System.out.println("getTotalContrAmtGovt ::::" + this.getTotalContrAmtGovt());
            this.controlSheetBuffer.append(this.getTotalContrAmtSwav() + "^");
            System.out.println("getTotalContrAmtSwav ::::" + this.getTotalContrAmtSwav());
            String dupPrans = null;
            if (!this.warnings.isEmpty()) {
                dupPrans = this.warnings.get(0);
                int i2 = 1;
                while (i2 < this.warnings.size()) {
                    dupPrans = String.valueOf(dupPrans) + " " + this.warnings.get(i2) + " ";
                    ++i2;
                }
            }
            if (dupPrans != null) {
                if (dupPrans.length() > 12) {
                    this.controlSheetBuffer.append("PRANs " + dupPrans + " have appeared more than once with same Contribution type in the file" + "^");
                } else {
                    this.controlSheetBuffer.append("PRAN " + dupPrans + " has appeared more than once with same Contribution type in the file" + "^");
                }
            } else {
                this.controlSheetBuffer.append("-^");
            }
            HashSet<String> set1 = new HashSet<String>(this.getPransList());
            this.controlSheetBuffer.append(String.valueOf(set1.size()) + "^");
            if (!(this.invalidRecord || this.invalidSubCount || this.invalidDDOCount || this.invalidTotalContributionInDDO || this.inValidContributionAmt)) {
                if (!this.invalidDdoCaretCount && this.totalGovtContributionInDDO != null && this.totalSelfContributionInDDO != null && this.totalCountOfSD != null) {
                    this.govtContributionInDDO = new BigDecimal(this.totalGovtContributionInDDO);
                    this.selfContributionInDDO = new BigDecimal(this.totalSelfContributionInDDO);
                    totalSubscriberCount = Integer.parseInt(this.getTotalSubscriberCount());
                    if (this.totalNoOfSDRead > totalSubscriberCount) {
                        listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[6], Integer.parseInt(String.valueOf(this.sectorCategory) + 203014), this.RECTYPE_DDOREC, "-", "-", "-", String.valueOf(this.lineCount - this.totalNoOfSDRead), "-"));
                    } else if (this.totalNoOfSDRead < totalSubscriberCount) {
                        listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_DDO_FIELD[6], Integer.parseInt(String.valueOf(this.sectorCategory) + 203013), this.RECTYPE_DDOREC, "-", "-", "-", String.valueOf(this.lineCount - this.totalNoOfSDRead), "-"));
                    } else {
                        if (!this.govtContributionInDDO.equals(this.subscriberGovtContribution)) {
                            listErrorVO.add(new PAOContrErrorFileVO(this.PAO_DDO_FIELD_7, Integer.parseInt(String.valueOf(this.sectorCategory) + 203015), this.RECTYPE_DDOREC, "-", "-", "-", String.valueOf(this.lineCount - this.totalNoOfSDRead), "-"));
                        }
                        if (!this.selfContributionInDDO.equals(this.subscriberSelfContribution)) {
                            listErrorVO.add(new PAOContrErrorFileVO(this.PAO_DDO_FIELD_8, Integer.parseInt(String.valueOf(this.sectorCategory) + 203016), this.RECTYPE_DDOREC, "-", "-", "-", String.valueOf(this.lineCount - this.totalNoOfSDRead), "-"));
                        }
                    }
                }
                if (!(this.inValidFhCaretCount || this.inValidBhCaretCount || this.invalidDdoCaretCount || this.totalCountOfDDO == null)) {
                    if (this.totalNoOfDDORead < Integer.parseInt(this.totalCountOfDDO)) {
                        listErrorVO.add(new PAOContrErrorFileVO(this.PAO_BH_FIELD_9, Integer.parseInt(String.valueOf(this.sectorCategory) + 202020), "Batch Header Record", "-", "-", "-", "2", "-"));
                    } else if (this.totalNoOfDDORead > Integer.parseInt(this.totalCountOfDDO)) {
                        listErrorVO.add(new PAOContrErrorFileVO(this.PAO_BH_FIELD_9, Integer.parseInt(String.valueOf(this.sectorCategory) + 202021), "Batch Header Record", "-", "-", "-", "2", "-"));
                    } else if (!this.invalidTotalContributionInBatch) {
                        this.govtContributionInBatch = new BigDecimal(this.batchTotalGovtContrbutionOfDDO);
                        this.selfContributionInBatch = new BigDecimal(this.batchTotalSelfContrbutionOfDDO);
                        if (!this.totalTierOneGovtAmt.equals(this.govtContributionInBatch)) {
                            listErrorVO.add(new PAOContrErrorFileVO(this.PAO_BH_FIELD_11, Integer.parseInt(String.valueOf(this.sectorCategory) + 202022), "Batch Header Record", "-", "-", "-", "2", "-"));
                        }
                        if (!this.totalTierOneSelfAmt.equals(this.selfContributionInBatch)) {
                            listErrorVO.add(new PAOContrErrorFileVO(this.PAO_BH_FIELD_12, Integer.parseInt(String.valueOf(this.sectorCategory) + 202023), "Batch Header Record", "-", "-", "-", "2", "-"));
                        }
                    }
                    this.govtContributionInBatch = new BigDecimal("0.0");
                    this.selfContributionInBatch = new BigDecimal("0.0");
                    if (sdCount < Integer.parseInt(this.totalCountOfSubscribers)) {
                        listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[10], 202025, "Batch Header Record", "-", "-", "-", "2", "-"));
                    } else if (sdCount > Integer.parseInt(this.totalCountOfSubscribers)) {
                        listErrorVO.add(new PAOContrErrorFileVO(FvuConstants.PAO_BH_FIELD[10], 202030, "Batch Header Record", "-", "-", "-", "2", "-"));
                    }
                    this.controlSheetBuffer.append(String.valueOf(this.lineCount) + "^");
                }
            }
        }
        catch (FileNotFoundException fex) {
            System.out.println("File not found exception in readFile method in SubContrFileFormatValidator");
        }
        catch (IOException ioex) {
            System.out.println("IOException in readFile method in SubContrFileFormatValidator");
        }
    }

    public StringBuffer getControlSheetBuffer() {
        return this.controlSheetBuffer;
    }

    public void setControlSheetBuffer(StringBuffer buffer) {
        this.controlSheetBuffer = buffer;
    }

    public String getDdoTierOneGovtContribution() {
        return this.totalGovtContributionInDDO;
    }

    public String getDdoTierOneSelfContribution() {
        return this.totalSelfContributionInDDO;
    }

    public String getTotalSubscriberCount() {
        return this.totalCountOfSD;
    }

    public void setDdoTierOneGovtContribution(String ddoTierOneGovtAmt) {
        this.totalGovtContributionInDDO = ddoTierOneGovtAmt;
    }

    public void setDdoTierOneSelfContribution(String ddoTierOneSelfAmt) {
        this.totalSelfContributionInDDO = ddoTierOneSelfAmt;
    }

    public void setTotalSubscriberCount(String totalSubCount) {
        this.totalCountOfSD = totalSubCount;
    }

    public BigDecimal getTotalContrAmtArr() {
        return this.totalContrAmtArr;
    }

    public void setTotalContrAmtArr(BigDecimal totalContrAmtArr) {
        this.totalContrAmtArr = totalContrAmtArr;
    }

    public BigDecimal getTotalContrAmtReg() {
        return this.totalContrAmtReg;
    }

    public void setTotalContrAmtReg(BigDecimal totalContrAmtReg) {
        this.totalContrAmtReg = totalContrAmtReg;
    }

    public BigDecimal getTotalContrAmtGovt() {
        return this.totalContrAmtGovt;
    }

    public void setTotalContrAmtGovt(BigDecimal totalContrAmtGovt) {
        this.totalContrAmtGovt = totalContrAmtGovt;
    }

    public BigDecimal getTotalContrAmtAdhoc() {
        return this.totalContrAmtAdhoc;
    }

    public void setTotalContrAmtAdhoc(BigDecimal totalContrAmtAdhoc) {
        this.totalContrAmtAdhoc = totalContrAmtAdhoc;
    }

    public BigDecimal getTotalContrAmtSwav() {
        return this.totalContrAmtSwav;
    }

    public void setTotalContrAmtSwav(BigDecimal totalContrAmtSwav) {
        this.totalContrAmtSwav = totalContrAmtSwav;
    }

    public ArrayList<String> getWarnings() {
        return this.warnings;
    }

    public void setWarnings(ArrayList<String> warnings) {
        this.warnings = warnings;
    }

    public int getUniquePranCount() {
        return this.uniquePranCount;
    }

    public void setUniquePranCount(int uniquePranCount) {
        this.uniquePranCount = uniquePranCount;
    }

    public int getRecord_C() {
        return this.record_C;
    }

    public void setRecord_C(int record_C) {
        this.record_C = record_C;
    }

    public int getRecord_A() {
        return this.record_A;
    }

    public void setRecord_A(int record_A) {
        this.record_A = record_A;
    }

    public int getRecord_0() {
        return this.record_0;
    }

    public void setRecord_0(int record_0) {
        this.record_0 = record_0;
    }

    public int getRecord_G() {
        return this.record_G;
    }

    public void setRecord_G(int record_G) {
        this.record_G = record_G;
    }

    public int getRecord_Sw() {
        return this.record_Sw;
    }

    public void setRecord_Sw(int record_Sw) {
        this.record_Sw = record_Sw;
    }

    public ArrayList<String> getComboList() {
        return this.comboList;
    }

    public void setComboList(ArrayList<String> comboList) {
        this.comboList = comboList;
    }

    public ArrayList<String> getPransList() {
        return this.pransList;
    }

    public void setPransList(ArrayList<String> pransList) {
        this.pransList = pransList;
    }
}

