/*
 * Decompiled with CFR 0.152.
 */
package com.cra.common.util.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class CRAFileOperations {
    protected File file;
    protected static final String forwardSlash = "/";
    protected static final String backwardSlash = "\\";

    public CRAFileOperations(String absoluteFileName) {
        this.file = new File(absoluteFileName);
    }

    public boolean exists() {
        return this.file.exists();
    }

    public long getFileSize() {
        return this.file.length();
    }

    public boolean createNewFile() throws IOException {
        if (!this.file.getParentFile().exists()) {
            this.file.getParentFile().mkdirs();
        }
        return this.file.createNewFile();
    }

    public boolean deleteFile() {
        return this.file.delete();
    }

    public static void copyToFile(String sourceFile, String destFile) throws IOException {
        int len;
        byte[] buffer = new byte[4096];
        FileInputStream in = new FileInputStream(sourceFile);
        FileOutputStream out = new FileOutputStream(destFile);
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
        out.close();
        in.close();
    }

    public String[] getFileNameList() {
        return this.file.list();
    }

    public static String getFileName(String absoluteFileName) {
        int index2;
        if (absoluteFileName == null) {
            return null;
        }
        int index1 = absoluteFileName.lastIndexOf(forwardSlash);
        int lastFileSeparatorIndex = index1 > (index2 = absoluteFileName.lastIndexOf(backwardSlash)) ? index1 : index2;
        return absoluteFileName.substring(lastFileSeparatorIndex + 1, absoluteFileName.length());
    }

    public static String getDirName(String absoluteFileName) {
        int index2;
        int index1 = absoluteFileName.lastIndexOf(forwardSlash);
        int lastFileSeparatorIndex = index1 > (index2 = absoluteFileName.lastIndexOf(backwardSlash)) ? index1 : index2;
        String filePath = absoluteFileName.substring(0, lastFileSeparatorIndex + 1);
        return filePath;
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public static String getFileExtension(String fileName) {
        int lastIndex = fileName.lastIndexOf(".");
        return fileName.substring(lastIndex, fileName.length());
    }

    public static String getFileNameWithOutExtension(String fileName) {
        String rFileName = CRAFileOperations.getFileName(fileName);
        int lastIndex = rFileName.lastIndexOf(".");
        return rFileName.substring(0, lastIndex);
    }

    public void renameTo(String dest) {
        this.file.renameTo(new File(dest));
    }
}

