/*
 * Decompiled with CFR 0.152.
 */
package com.cra.common.util.encrypt;

import com.cra.common.util.CRAConfigReader;
import com.cra.common.util.CRAStringTokenizer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public class Hash {
    private String fhString;
    private long fileLevelHC;
    private long fhHC;
    private long fvuFLH;
    private long samFLH;
    private long scmFLH;
    private long prn;
    private String filler = null;
    private String fvuVersion = null;
    private String samVersion = null;
    private String scmVersion = null;
    private int utilityLevel;
    private String inputFileName;
    private String outputFileName;
    private String recStr;
    private int fhFieldCount;
    private BufferedReader br = null;
    private int iErrCode;
    public static final int FVU = 0;
    public static final int SAM = 1;
    public static final int SCM = 2;
    public static final int CRA = 3;
    public static final int FC = 4;
    public static final int LEGACYDATA = 5;
    public static final int FVU_MIS = 6;
    public static final int MIS_UPLD = 7;
    private int recNo = 0;

    public int startProcessing(String inputFileName, String outputHashFile, int utilityLevel, int fhFieldCount) {
        block35: {
            block34: {
                File file;
                block33: {
                    this.inputFileName = inputFileName;
                    this.outputFileName = outputHashFile;
                    this.utilityLevel = utilityLevel;
                    this.fhFieldCount = fhFieldCount;
                    this.iErrCode = 0;
                    file = new File(inputFileName);
                    if (file.exists()) break block33;
                    int n = this.iErrCode = 1;
                    try {
                        if (this.br != null) {
                            this.br.close();
                        }
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    return n;
                }
                this.br = new BufferedReader(new FileReader(file));
                this.recStr = this.br.readLine();
                if (this.recStr != null && this.recStr.length() != 0) break block34;
                int n = this.iErrCode = 2;
                try {
                    if (this.br != null) {
                        this.br.close();
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                return n;
            }
            this.tokenizeFileHeader();
            if (this.iErrCode != 2) break block35;
            this.recNo = 1;
            int n = this.iErrCode;
            try {
                if (this.br != null) {
                    this.br.close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return n;
        }
        try {
            try {
                switch (utilityLevel) {
                    case 0: {
                        this.processFVU();
                        break;
                    }
                    case 6: {
                        this.processFVUmis();
                        break;
                    }
                    case 1: {
                        this.processSAM();
                        break;
                    }
                    case 3: {
                        this.processCRA();
                        break;
                    }
                    case 4: {
                        this.processFC();
                        break;
                    }
                    case 5: {
                        this.processCRA();
                        break;
                    }
                    case 7: {
                        this.processFVUmis_FileHashed();
                    }
                }
            }
            catch (Exception e) {
                this.recNo = 1;
                this.iErrCode = 12;
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            try {
                if (this.br != null) {
                    this.br.close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        return this.iErrCode;
    }

    private boolean processFVU() {
        if (this.samVersion != null || this.samFLH > 0L || this.filler != null || this.prn > 0L) {
            this.recNo = 1;
            this.iErrCode = 2;
            return false;
        }
        if (this.fvuVersion == null && this.fvuFLH == 0L && this.fhHC == 0L) {
            return this.processFVU_FileNotHashed();
        }
        return this.processFVU_FileHashed();
    }

    private boolean processFVUmis() {
        if (this.filler == null) {
            // empty if block
        }
        if (this.fvuVersion == null && this.prn == 0L && this.fhHC == 0L) {
            return this.processFVUmis_FileNotHashed();
        }
        return this.processFVUmis_FileHashed();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processFVUmis_FileHashed() {
        System.out.println("Inside MIS FVU file hashed");
        try {
            this.recNo = 1;
            if (!Boolean.valueOf(CRAConfigReader.getConfigVal("CRACENTRAL.FVU.IgnoreVersioning")).booleanValue() && !Boolean.valueOf(CRAConfigReader.getConfigVal("CRACENTRAL.FVU.IgnoreRecordLevelHashing")).booleanValue() && this.fhHC != this.hashCode(this.fhString, true)) {
                this.iErrCode = 6;
                return false;
            }
            if (!(this.utilityLevel != 6 && this.utilityLevel != 7 || Boolean.valueOf(CRAConfigReader.getConfigVal("CRACENTRAL.FVU.IgnoreVersioning")).booleanValue() || this.isValidFVUVersion_MIS(this.fvuVersion))) {
                this.iErrCode = 3;
                return false;
            }
            if (Boolean.valueOf(CRAConfigReader.getConfigVal("CRACENTRAL.FVU.IgnoreHashing")).booleanValue()) {
                return true;
            }
            this.recStr = this.recStr.substring(0, this.recStr.lastIndexOf(94) + 1);
            this.fileLevelHC = this.hashCode(this.recStr, true);
            if (!Boolean.valueOf(CRAConfigReader.getConfigVal("CRACENTRAL.FVU.IgnoreRecordLevelHashing")).booleanValue()) {
                while ((this.recStr = this.br.readLine()) != null) {
                    ++this.recNo;
                    if (this.recStr.charAt(this.recStr.length() - 1) == '^') {
                        this.iErrCode = 8;
                        return false;
                    }
                    try {
                        rlh = Long.parseLong(this.recStr.substring(this.recStr.lastIndexOf(94) + 1, this.recStr.length()).trim());
                        this.recStr = this.recStr.substring(0, this.recStr.lastIndexOf(94));
                        if (rlh != this.hashCode(this.recStr, true)) {
                            this.iErrCode = 7;
                            return false;
                        }
                        this.fileLevelHC += (long)this.recNo * rlh;
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                        this.iErrCode = 6;
                        return false;
                    }
                }
            }
            ** GOTO lbl40
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
lbl-1000:
        // 1 sources

        {
            ++this.recNo;
            this.recStr = this.recStr.substring(0, this.recStr.lastIndexOf(94));
            this.fileLevelHC += (long)this.recNo * this.hashCode(this.recStr, true);
lbl40:
            // 2 sources

            ** while ((this.recStr = this.br.readLine()) != null)
        }
lbl41:
        // 2 sources

        if (this.fileLevelHC != this.prn) {
            System.out.println("File Level HashCode of MIS File is incorrect");
            this.iErrCode = 9;
            return false;
        }
        return true;
    }

    private boolean processSAM() {
        if (this.filler != null || this.prn > 0L || this.samVersion != null && this.samFLH > 0L || this.fvuVersion == null || this.fvuFLH == 0L) {
            this.recNo = 1;
            this.iErrCode = 2;
            return false;
        }
        if (this.samVersion == null && this.samFLH == 0L) {
            return this.processFVU_FileHashed();
        }
        this.recNo = 1;
        this.iErrCode = 2;
        return false;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processCRA() {
        fvuFileLevelHC = 0L;
        scmFileLevelHC = 0L;
        isTFC = this.recStr.indexOf("^T^") != -1;
        try {
            if (!isTFC) {
                if (this.samVersion != null || this.samFLH > 0L || this.filler != null || this.prn > 0L) {
                    this.recNo = 1;
                    this.iErrCode = 2;
                    return false;
                }
            } else if (this.scmVersion == null || this.scmFLH == 0L) {
                this.recNo = 1;
                this.iErrCode = 2;
                return false;
            }
            this.recNo = 1;
            if (!this.isValidFVUVersion(this.fvuVersion)) {
                this.iErrCode = 3;
                return false;
            }
            k = this.recStr.lastIndexOf(94);
            this.recStr = this.recStr.substring(0, k);
            scmFileLevelHC = this.hashCode(this.recStr, true);
            k = this.recStr.lastIndexOf(94, k - 1);
            k = this.recStr.lastIndexOf(94, k - 1);
            this.recStr = this.recStr.substring(0, k);
            k = this.recStr.lastIndexOf(94, k - 1);
            k = this.recStr.lastIndexOf(94, k - 1);
            this.recStr = this.recStr.substring(0, k);
            fvuFileLevelHC = this.hashCode(this.recStr, true);
            this.fileLevelHC = 0L;
            if (Boolean.valueOf(CRAConfigReader.getConfigVal("CRACENTRAL.FVU.IgnoreRecordLevelHashing")).booleanValue()) {
                while ((this.recStr = this.br.readLine()) != null) {
                    ++this.recNo;
                    k = this.recStr.lastIndexOf(94);
                    try {
                        recLevelHC = Long.parseLong(this.recStr.substring(k + 1, this.recStr.length()));
                    }
                    catch (NumberFormatException e) {
                        this.iErrCode = 6;
                        return false;
                    }
                    this.fileLevelHC += (long)this.recNo * recLevelHC;
                }
            }
            ** GOTO lbl61
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
lbl-1000:
        // 1 sources

        {
            ++this.recNo;
            k = this.recStr.lastIndexOf(94);
            try {
                recLevelHC = Long.parseLong(this.recStr.substring(k + 1, this.recStr.length()));
            }
            catch (NumberFormatException e) {
                this.iErrCode = 6;
                return false;
            }
            this.recStr = this.recStr.substring(0, k);
            rlh = this.hashCode(this.recStr, true);
            if (rlh != recLevelHC) {
                this.iErrCode = 7;
                return false;
            }
            this.fileLevelHC += (long)this.recNo * recLevelHC;
lbl61:
            // 2 sources

            ** while ((this.recStr = this.br.readLine()) != null)
        }
lbl62:
        // 2 sources

        fvuFileLevelHC += this.fileLevelHC;
        if (isTFC) {
            if ((scmFileLevelHC += this.fileLevelHC) == this.scmFLH) return true;
            this.iErrCode = 11;
            return false;
        } else {
            if (fvuFileLevelHC == this.fvuFLH) return true;
            this.iErrCode = 9;
            return false;
        }
    }

    private boolean processFC() {
        if (this.samVersion == null || this.samFLH == 0L || this.fvuVersion == null || this.fvuFLH == 0L || this.filler != null || this.prn == 0L) {
            this.recNo = 1;
            this.iErrCode = 2;
            return false;
        }
        return this.processSAM_FileHashed();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processSAM_FileHashed() {
        try {
            this.recNo = 1;
            if (!this.isValidFVUVersion(this.fvuVersion)) {
                this.iErrCode = 3;
                return false;
            }
            if (!this.isValidSAMVersion(this.samVersion)) {
                this.iErrCode = 4;
                return false;
            }
            if (Boolean.valueOf(CRAConfigReader.getConfigVal("CRACENTRAL.FVU.IgnoreHashing")).booleanValue()) {
                return true;
            }
            this.recStr = this.recStr.substring(0, this.recStr.lastIndexOf(94));
            this.fileLevelHC = this.hashCode(this.recStr, true);
            if (!Boolean.valueOf(CRAConfigReader.getConfigVal("CRACENTRAL.FVU.IgnoreRecordLevelHashing")).booleanValue()) {
                while ((this.recStr = this.br.readLine()) != null) {
                    ++this.recNo;
                    if (this.recStr.charAt(this.recStr.length() - 1) == '^') {
                        this.iErrCode = 8;
                        return false;
                    }
                    try {
                        rlh = Long.parseLong(this.recStr.substring(this.recStr.lastIndexOf(94) + 1, this.recStr.length()).trim());
                        this.recStr = this.recStr.substring(0, this.recStr.lastIndexOf(94));
                        if (rlh != this.hashCode(this.recStr, true)) {
                            this.iErrCode = 7;
                            return false;
                        }
                        this.fileLevelHC += (long)this.recNo * rlh;
                    }
                    catch (NumberFormatException e) {
                        this.iErrCode = 6;
                        return false;
                    }
                }
            }
            ** GOTO lbl38
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
lbl-1000:
        // 1 sources

        {
            ++this.recNo;
            this.recStr = this.recStr.substring(0, this.recStr.lastIndexOf(94));
            this.fileLevelHC += (long)this.recNo * this.hashCode(this.recStr, true);
lbl38:
            // 2 sources

            ** while ((this.recStr = this.br.readLine()) != null)
        }
lbl39:
        // 2 sources

        if (this.fileLevelHC != this.samFLH) {
            this.iErrCode = 10;
            return false;
        }
        return true;
    }

    private boolean processFVU_FileNotHashed() {
        long rlh = 0L;
        this.recNo = 1;
        boolean retVal = true;
        BufferedWriter hf = null;
        RandomAccessFile raf = null;
        try {
            try {
                hf = new BufferedWriter(new FileWriter(this.outputFileName));
                this.recStr = this.getFileHeader(CRAConfigReader.getConfigVal("CRACENTRAL.FVU.FVUVersion"));
                hf.write(this.recStr);
                hf.write(94);
                this.fileLevelHC = this.hashCode(this.recStr, true);
                hf.write(this.get20digitHashCode(this.fileLevelHC));
                hf.write("^^^^");
                hf.write(10);
                while ((this.recStr = this.br.readLine()) != null) {
                    ++this.recNo;
                    if (this.recStr.charAt(this.recStr.length() - 1) != '^') {
                        this.iErrCode = 8;
                        retVal = false;
                        break;
                    }
                    hf.write(this.recStr);
                    rlh = this.hashCode(this.recStr, false);
                    this.fileLevelHC += (long)this.recNo * rlh;
                    hf.write(this.get20digitHashCode(rlh));
                    hf.write(10);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                if (hf != null) {
                    hf.close();
                    if (!retVal) {
                        File e = new File(this.outputFileName);
                        e.delete();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (retVal) {
            try {
                try {
                    raf = new RandomAccessFile(this.outputFileName, "rw");
                    raf.seek(this.fhString.length() + 3 + Integer.valueOf(CRAConfigReader.getConfigVal("CRACENTRAL.FVU.MaxHashCodeLength")) + this.fvuVersion.length());
                    raf.writeBytes(this.get20digitHashCode(this.fileLevelHC));
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            finally {
                if (raf != null) {
                    try {
                        raf.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
        }
        return retVal;
    }

    private boolean processFVUmis_FileNotHashed() {
        System.out.println("Inside MIS FVU file not hashed");
        long rlh = 0L;
        this.recNo = 1;
        boolean retVal = true;
        BufferedWriter hf = null;
        RandomAccessFile raf = null;
        try {
            try {
                hf = new BufferedWriter(new FileWriter(this.outputFileName));
                this.recStr = this.getFileHeader(CRAConfigReader.getConfigVal("MIS.FVU.FVUVersion"));
                this.recStr = this.recStr.concat("^^^");
                hf.write(this.recStr);
                this.fileLevelHC = this.hashCode(this.recStr, true);
                hf.write(this.get20digitHashCode(this.fileLevelHC));
                hf.write(10);
                while ((this.recStr = this.br.readLine()) != null) {
                    ++this.recNo;
                    if (this.recStr.charAt(this.recStr.length() - 1) != '^') {
                        this.iErrCode = 8;
                        retVal = false;
                        break;
                    }
                    String[] valueArray = this.recStr.split("\\^");
                    if (valueArray[1].compareToIgnoreCase("RD") == 0) {
                        if (this.recStr.charAt(this.recStr.length() - 1) != '^') {
                            this.iErrCode = 8;
                            retVal = false;
                            break;
                        }
                        hf.write(this.recStr);
                    } else {
                        hf.write(this.recStr);
                    }
                    rlh = this.hashCode(this.recStr, false);
                    this.fileLevelHC += (long)this.recNo * rlh;
                    hf.write(this.get20digitHashCode(rlh));
                    hf.write(10);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                if (hf != null) {
                    hf.close();
                    if (!retVal) {
                        File e = new File(this.outputFileName);
                        e.delete();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (retVal) {
            try {
                try {
                    raf = new RandomAccessFile(this.outputFileName, "rw");
                    raf.seek(this.fhString.length() + 5 + Integer.valueOf(CRAConfigReader.getConfigVal("CRACENTRAL.FVU.MaxHashCodeLength")) + this.fvuVersion.length());
                    raf.writeBytes(this.get20digitHashCode(this.fileLevelHC));
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            finally {
                if (raf != null) {
                    try {
                        raf.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
        }
        return retVal;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processFVU_FileHashed() {
        try {
            this.recNo = 1;
            if (!Boolean.valueOf(CRAConfigReader.getConfigVal("CRACENTRAL.FVU.IgnoreVersioning")).booleanValue() && !Boolean.valueOf(CRAConfigReader.getConfigVal("CRACENTRAL.FVU.IgnoreRecordLevelHashing")).booleanValue() && this.fhHC != this.hashCode(this.fhString, true)) {
                this.iErrCode = 6;
                return false;
            }
            if (!(this.utilityLevel != 0 && this.utilityLevel != 3 && this.utilityLevel != 5 || Boolean.valueOf(CRAConfigReader.getConfigVal("CRACENTRAL.FVU.IgnoreVersioning")).booleanValue() || this.isValidFVUVersion(this.fvuVersion))) {
                this.iErrCode = 3;
                return false;
            }
            if (Boolean.valueOf(CRAConfigReader.getConfigVal("CRACENTRAL.FVU.IgnoreHashing")).booleanValue()) {
                return true;
            }
            this.recStr = this.recStr.substring(0, this.recStr.lastIndexOf(94, this.recStr.lastIndexOf(94, this.recStr.lastIndexOf(94, this.recStr.lastIndexOf(94, this.recStr.lastIndexOf(94) - 1) - 1) - 1) - 1));
            System.out.println("recStr.." + this.recStr);
            this.fileLevelHC = this.hashCode(this.recStr, true);
            if (!Boolean.valueOf(CRAConfigReader.getConfigVal("CRACENTRAL.FVU.IgnoreRecordLevelHashing")).booleanValue()) {
                while ((this.recStr = this.br.readLine()) != null) {
                    ++this.recNo;
                    if (this.recStr.charAt(this.recStr.length() - 1) == '^') {
                        this.iErrCode = 8;
                        return false;
                    }
                    try {
                        rlh = Long.parseLong(this.recStr.substring(this.recStr.lastIndexOf(94) + 1, this.recStr.length()).trim());
                        this.recStr = this.recStr.substring(0, this.recStr.lastIndexOf(94));
                        if (rlh != this.hashCode(this.recStr, true)) {
                            this.iErrCode = 7;
                            return false;
                        }
                        this.fileLevelHC += (long)this.recNo * rlh;
                    }
                    catch (NumberFormatException e) {
                        this.iErrCode = 6;
                        return false;
                    }
                }
            }
            ** GOTO lbl39
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
lbl-1000:
        // 1 sources

        {
            ++this.recNo;
            this.recStr = this.recStr.substring(0, this.recStr.lastIndexOf(94));
            this.fileLevelHC += (long)this.recNo * this.hashCode(this.recStr, true);
lbl39:
            // 2 sources

            ** while ((this.recStr = this.br.readLine()) != null)
        }
lbl40:
        // 2 sources

        if (this.fileLevelHC != this.fvuFLH) {
            System.out.println("incorrect fileLevelHC" + this.fileLevelHC);
            this.iErrCode = 9;
            return false;
        }
        return true;
    }

    public long hashCode(String recStr, boolean includeCaret) {
        long hc = 0L;
        int i = 0;
        while (i < recStr.length()) {
            hc += (long)(recStr.charAt(i) * (i + 1));
            ++i;
        }
        if (includeCaret) {
            hc += (long)((i + 1) * 94);
        }
        return hc;
    }

    public String get20digitHashCode(long hashCode) {
        String hashCodeStr = Long.toString(hashCode);
        StringBuffer sb = new StringBuffer();
        int i = hashCodeStr.length();
        while (i < Integer.valueOf(CRAConfigReader.getConfigVal("CRACENTRAL.FVU.MaxHashCodeLength"))) {
            sb.append('0');
            ++i;
        }
        sb.append(hashCodeStr);
        return sb.toString();
    }

    public String get15digitHashCode(long hashCode) {
        String hashCodeStr = Long.toString(hashCode);
        StringBuffer sb = new StringBuffer();
        int i = hashCodeStr.length();
        while (i < Integer.valueOf(CRAConfigReader.getConfigVal("CRACENTRAL.FC.MaxHashCodeLength"))) {
            sb.append('0');
            ++i;
        }
        sb.append(hashCodeStr);
        return sb.toString();
    }

    private String getFileHeader(String pfvuVersion) {
        StringBuffer sb = new StringBuffer(this.fhString);
        sb.append('^');
        sb.append(this.get20digitHashCode(this.hashCode(this.fhString, true)));
        sb.append('^');
        this.fvuVersion = pfvuVersion;
        sb.append(this.fvuVersion);
        return sb.toString();
    }

    private boolean isValidFVUVersion(String fvu) {
        String FVUversion = null;
        ArrayList<String> fvuVer = new ArrayList<String>();
        if (fvu == null) {
            return false;
        }
        FVUversion = CRAConfigReader.getConfigVal("AllowedVersions.of.FVUpaosubcontr.with.CentralSystem");
        CRAStringTokenizer st = new CRAStringTokenizer(FVUversion, ",");
        String tokstr = st.nextToken();
        while (tokstr != null) {
            fvuVer.add(tokstr);
            tokstr = st.nextToken();
        }
        int i = 0;
        while (i < fvuVer.size()) {
            if (((String)fvuVer.get(i)).trim().equals(fvu.trim())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isValidFVUVersion_MIS(String fvu) {
        String FVUversion = null;
        ArrayList<String> fvuVer = new ArrayList<String>();
        if (fvu == null) {
            return false;
        }
        FVUversion = CRAConfigReader.getConfigVal("AllowedVersions.of.craFVUmis.with.CentralSystem");
        CRAStringTokenizer st = new CRAStringTokenizer(FVUversion, ",");
        String tokstr = st.nextToken();
        while (tokstr != null) {
            fvuVer.add(tokstr);
            tokstr = st.nextToken();
        }
        int i = 0;
        while (i < fvuVer.size()) {
            if (((String)fvuVer.get(i)).trim().equals(fvu.trim())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isValidSAMVersion(String sam) {
        String SAMversion = null;
        ArrayList<String> samVer = new ArrayList<String>();
        if (sam == null) {
            return false;
        }
        SAMversion = CRAConfigReader.getConfigVal("AllowedVersions.of.SAM.with.CentralSystem");
        CRAStringTokenizer st = new CRAStringTokenizer(SAMversion, ",");
        String tokstr = st.nextToken();
        while (tokstr != null) {
            samVer.add(tokstr);
            tokstr = st.nextToken();
        }
        int i = 0;
        while (i < samVer.size()) {
            if (((String)samVer.get(i)).trim().equals(sam.trim())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void tokenizeFileHeader() throws Exception {
        StringBuffer sb = null;
        try {
            try {
                CRAStringTokenizer st = new CRAStringTokenizer(this.recStr, "^");
                sb = new StringBuffer();
                String tokstr = st.nextToken();
                int tok = 0;
                int fhHCIndex = this.fhFieldCount + 1;
                int fvuVersionIndex = fhHCIndex + 1;
                int fvuFLHIndex = fvuVersionIndex + 1;
                int fillerIndex = fvuFLHIndex + 1;
                int prnIndex = fillerIndex + 1;
                int samVersionIndex = prnIndex + 1;
                int samFLHIndex = samVersionIndex + 1;
                while (tokstr != null) {
                    block32: {
                        if (++tok < fhHCIndex) {
                            sb.append(tokstr);
                            if (tok != this.fhFieldCount) {
                                sb.append('^');
                            }
                            if (tok == 2 && !tokstr.equals("FH")) {
                                this.iErrCode = 2;
                                break;
                            }
                        } else {
                            if (tok == fhHCIndex) {
                                try {
                                    if (tokstr.equals("")) break block32;
                                    this.fhHC = Long.parseLong(tokstr);
                                    break block32;
                                }
                                catch (NumberFormatException e) {
                                    this.iErrCode = 2;
                                    break;
                                }
                            }
                            if (tok == fvuVersionIndex && tokstr.length() > 0) {
                                this.fvuVersion = tokstr;
                            } else {
                                if (tok == fvuFLHIndex) {
                                    try {
                                        if (tokstr.equals("")) break block32;
                                        this.fvuFLH = Long.parseLong(tokstr);
                                        break block32;
                                    }
                                    catch (NumberFormatException e) {
                                        System.out.println("file level hash incorrect");
                                        this.iErrCode = 2;
                                        break;
                                    }
                                }
                                if (tok == fillerIndex && tokstr.length() > 0) {
                                    try {
                                        this.filler = tokstr;
                                        System.out.println("filler from file:" + this.filler);
                                    }
                                    catch (NumberFormatException e) {}
                                } else {
                                    if (tok == prnIndex) {
                                        try {
                                            if (tokstr.equals("")) break block32;
                                            this.prn = Long.parseLong(tokstr);
                                            System.out.println("prn from file:" + this.prn);
                                            break block32;
                                        }
                                        catch (NumberFormatException e) {
                                            this.iErrCode = 2;
                                            break;
                                        }
                                    }
                                    if (tok == samVersionIndex && tokstr.length() > 0) {
                                        this.samVersion = tokstr;
                                        System.out.println("samVersion from file:" + this.samVersion);
                                    } else if (tok == samFLHIndex) {
                                        try {
                                            if (tokstr.equals("")) break block32;
                                            this.samFLH = Long.parseLong(tokstr);
                                            System.out.println("samFLH from file :" + this.samFLH);
                                        }
                                        catch (NumberFormatException e) {
                                            this.iErrCode = 2;
                                            break;
                                        }
                                    }
                                }
                            }
                        }
                    }
                    tokstr = st.nextToken();
                }
            }
            catch (Exception e) {
                this.iErrCode = 2;
                e.printStackTrace();
            }
        }
        finally {
            if (sb.length() > 0) {
                this.fhString = sb.toString();
            }
        }
    }

    public int getRecordNumber() {
        return this.recNo;
    }
}

