/*
 * Decompiled with CFR 0.152.
 */
package cra.standalone.paosubcontr.celleditor;

import cra.standalone.paosubcontr.FPU;
import cra.standalone.paosubcontr.util.FPUConstants;
import cra.standalone.paosubcontr.util.FpuUtil;
import java.math.BigDecimal;

public class SubCellPasteValidations {
    public static boolean Validate_Field(Object tabval, int tabrow, int tabcol) {
        switch (tabcol) {
            case 1: {
                if (FPU.user.equals(FPUConstants.CRALITE_SECTOR_PAO)) {
                    return SubCellPasteValidations.validatecell_TANTD(tabval, tabrow, tabcol);
                }
                return SubCellPasteValidations.validatecell_AIN(tabval, tabrow, tabcol);
            }
            case 2: {
                return SubCellPasteValidations.validatecell_PRAN(tabval, tabrow, tabcol);
            }
            case 3: {
                return SubCellPasteValidations.validatecell_NameTD(tabval, tabrow, tabcol);
            }
            case 4: {
                return SubCellPasteValidations.validatecell_contrType(tabval, tabrow, tabcol);
            }
            case 5: {
                return SubCellPasteValidations.validatecell_contAmt(tabval, tabrow, tabcol);
            }
            case 6: {
                return SubCellPasteValidations.validatecell_contAmt(tabval, tabrow, tabcol);
            }
            case 7: {
                return SubCellPasteValidations.validatecell_payMonth(tabval, tabrow, tabcol);
            }
            case 8: {
                return SubCellPasteValidations.validatecell_payYear(tabval, tabrow, tabcol);
            }
            case 9: {
                return SubCellPasteValidations.validatecell_Arrearremarks(tabval, tabrow, tabcol);
            }
            case 10: {
                return SubCellPasteValidations.validatecell_remarks(tabval, tabrow, tabcol);
            }
        }
        return true;
    }

    public static boolean validatecell_TANTD(Object tabval, int tabrow, int tabcol) {
        String tan = "";
        boolean gStatusTAN = true;
        if (tabval == null) {
            return false;
        }
        tan = tabval.toString().trim();
        gStatusTAN = FPU.fpu.panelSubDet.checkTan(tan);
        if (gStatusTAN) {
            SubCellPasteValidations.errPaste("Invalid NL-AO", tabrow, tabcol);
            return false;
        }
        FPU.fpu.setNoErrorAt(tabrow, tabcol);
        return true;
    }

    private static boolean validatecell_AIN(Object tabval, int tabrow, int tabcol) {
        String AIN = tabval.toString().trim();
        boolean isValid = true;
        if (AIN.length() != 7) {
            isValid = false;
            SubCellPasteValidations.errPaste("Invalid NL-AO Reg. No.", tabrow, tabcol);
            return isValid;
        }
        try {
            int ain = Integer.parseInt(AIN);
            System.out.println("NL-AO Reg. No." + ain);
            int div = ain / 10;
            int quo = div / 7;
            int rem = div - 7 * quo;
            int mod = ain % 10;
            if (rem != mod) {
                SubCellPasteValidations.errPaste("Invalid NL-AO Reg. No.", tabrow, tabcol);
                isValid = false;
            }
        }
        catch (NumberFormatException ne) {
            SubCellPasteValidations.errPaste("Invalid NL-AO Reg. No.", tabrow, tabcol);
            isValid = false;
            return false;
        }
        return isValid;
    }

    public static boolean validatecell_PRAN(Object tabval, int tabrow, int tabcol) {
        String pran = "";
        boolean gStatusPRAN = true;
        if (tabval == null) {
            SubCellPasteValidations.errPaste("PRAN must Not be NULL", tabrow, tabcol);
            return false;
        }
        pran = tabval.toString().trim();
        gStatusPRAN = FPU.fpu.panelSubDet.checkPRAN(pran);
        if (!gStatusPRAN) {
            SubCellPasteValidations.errPaste("Invalid PRAN", tabrow, tabcol);
            return false;
        }
        FPU.fpu.setNoErrorAt(tabrow, tabcol);
        return true;
    }

    public static boolean validatecell_NameTD(Object tabval, int tabrow, int tabcol) {
        String Name = "";
        boolean gStatus = true;
        if (tabval != null) {
            Name = tabval.toString().trim();
        } else if (Name.length() >= 30) {
            String str = tabval.toString().substring(0, 30);
            tabval = str;
        }
        FPU.fpu.setNoErrorAt(tabrow, tabcol);
        return true;
    }

    public static boolean validatecell_TaxAmountTD(Object tabval, int tabrow, int tabcol) {
        boolean gStatus = true;
        boolean gtaxAmt = true;
        String taxAmtTD = "";
        if (tabval != null) {
            taxAmtTD = tabval.toString().trim();
        }
        if (tabval == null || tabval.toString().trim().equals("")) {
            SubCellPasteValidations.errPaste("Tax Amount must Not be NULL", tabrow, tabcol);
            return false;
        }
        gtaxAmt = FpuUtil.isInt(taxAmtTD);
        if (!gtaxAmt) {
            SubCellPasteValidations.errPaste("Invalid Tax Amount", tabrow, tabcol);
            return false;
        }
        if (taxAmtTD.length() >= 13) {
            SubCellPasteValidations.errPaste("Length of Tax Amount should be less than or equal to 12", tabrow, tabcol);
            return false;
        }
        if (taxAmtTD.indexOf(".") != -1) {
            SubCellPasteValidations.errPaste("Tax amount should not be decimal value ", tabrow, tabcol);
            return false;
        }
        FPU.fpu.setNoErrorAt(tabrow, tabcol);
        return true;
    }

    public static boolean validatecell_contAmt(Object tabval, int tabrow, int tabcol) {
        boolean gContAmt = true;
        String contAmt = "";
        String contrType = FPU.fpu.panelSubDet.model.getValueAt(tabrow, 4).toString();
        if (tabval != null) {
            contAmt = tabval.toString().trim();
        }
        if ((tabval == null || tabval.toString().trim().equals("")) && tabcol == 5 && contrType.equals(FPUConstants.strContType[4])) {
            SubCellPasteValidations.errPaste("Co-Contribution Amount must not NULL ", tabrow, tabcol);
            return false;
        }
        gContAmt = FPU.fpu.panelSubDet.isCorrectAmt(contAmt);
        System.out.println("gContAmt" + gContAmt);
        if (!gContAmt) {
            SubCellPasteValidations.errPaste("Invalid Cont. Amount", tabrow, tabcol);
            return false;
        }
        if (contAmt.length() > 21) {
            FPU.getMessage("Contribution Amount should not exceed 20 digits(including 2 digits after decimal point)");
            return false;
        }
        if (tabval != null) {
            BigDecimal amount2;
            BigDecimal amount1;
            contAmt = tabval.toString().trim();
            if (contAmt.toString().trim().equals("")) {
                contAmt = "0.00";
            }
            if ((amount1 = new BigDecimal(contAmt)).compareTo(amount2 = new BigDecimal("0.00")) == 0 && tabcol == 5 && contrType.equals(FPUConstants.strContType[4])) {
                SubCellPasteValidations.errPaste("Co-Contribution should be greater than 0.00 ", tabrow, tabcol);
                return false;
            }
        }
        try {
            if (contAmt.length() > 18) {
                SubCellPasteValidations.errPaste("Invalid contribution", tabrow, tabcol);
                return false;
            }
        }
        catch (Exception e) {
            return true;
        }
        return true;
    }

    public static boolean validatecell_contrType(Object tabval, int tabrow, int tabcol) {
        if (tabval == null || tabval.toString().trim().equals(FPUConstants.strContType[0])) {
            SubCellPasteValidations.errPaste("Invalid Contribution Type", tabrow, tabcol);
            return false;
        }
        if (FPU.FYFlag.equalsIgnoreCase("N")) {
            int i = 0;
            while (i < FPUConstants.strContType.length) {
                if (tabval.toString().trim().equalsIgnoreCase(FPUConstants.strContType[i])) {
                    tabval = FPUConstants.strContType[i];
                    FPUConstants.tabContType = (String)tabval;
                    return true;
                }
                ++i;
            }
        } else if (FPU.FYFlag.equalsIgnoreCase("Y")) {
            int i = 0;
            while (i < FPUConstants.strContTypeFY.length) {
                if (tabval.toString().trim().equalsIgnoreCase(FPUConstants.strContTypeFY[i])) {
                    tabval = FPUConstants.strContTypeFY[i];
                    FPUConstants.tabContType = (String)tabval;
                    return true;
                }
                ++i;
            }
        }
        SubCellPasteValidations.errPaste("Invalid Contribution Type", tabrow, tabcol);
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean validatecell_payMonth(Object tabval, int tabrow, int tabcol) {
        if (FPU.FYFlag.equalsIgnoreCase("N")) {
            System.out.println("For N");
            if (tabval == null || tabval.toString().trim().equals("--Select--")) {
                SubCellPasteValidations.errPaste("Invalid Month of Payment", tabrow, tabcol);
                return false;
            }
            int i = 0;
            while (i < FPUConstants.strPayMonth.length) {
                if (tabval.toString().trim().equalsIgnoreCase(FPUConstants.strPayMonth[i])) {
                    tabval = FPUConstants.strPayMonth[i];
                    return true;
                }
                ++i;
            }
        } else if (FPU.FYFlag.equalsIgnoreCase("Y")) {
            System.out.println("For Y");
            if (tabval.toString().trim().equals("--Select--")) return true;
            System.out.println("inside if" + tabval.toString().trim() + "1234");
            if (tabval == null) return true;
            if (tabval.toString().trim().equals("")) return true;
            int i = 0;
            while (i < FPUConstants.strPayMonth.length) {
                if (tabval.toString().trim().equalsIgnoreCase(FPUConstants.strPayMonth[i])) {
                    tabval = FPUConstants.strPayMonth[i];
                    return true;
                }
                ++i;
            }
        }
        SubCellPasteValidations.errPaste("Invalid Month of Payment", tabrow, tabcol);
        return false;
    }

    public static boolean validatecell_payYear(Object tabval, int tabrow, int tabcol) {
        if (tabval == null || tabval.toString().trim().equals("--Select--")) {
            SubCellPasteValidations.errPaste("Invalid Year of Payment", tabrow, tabcol);
            return false;
        }
        if (FPU.FYFlag.equalsIgnoreCase("N")) {
            int i = 0;
            while (i < FPUConstants.strPayYear.length) {
                if (tabval.toString().trim().equalsIgnoreCase(FPUConstants.strPayYear[i])) {
                    tabval = FPUConstants.strPayYear[i];
                    return true;
                }
                ++i;
            }
        } else if (FPU.FYFlag.equalsIgnoreCase("Y")) {
            int i = 0;
            while (i < FPUConstants.strPayYearFY.length) {
                if (tabval.toString().trim().equalsIgnoreCase(FPUConstants.strPayYearFY[i])) {
                    tabval = FPUConstants.strPayYearFY[i];
                    return true;
                }
                ++i;
            }
        }
        SubCellPasteValidations.errPaste("Invalid Year of Payment", tabrow, tabcol);
        return false;
    }

    public static boolean validatecell_Arrearremarks(Object tabval, int tabrow, int tabcol) {
        if ("REGULAR".equalsIgnoreCase(FPUConstants.tabContType) || "SELF-CONTRIBUTION".equalsIgnoreCase(FPUConstants.tabContType) || "GOVT-SCHEMES".equalsIgnoreCase(FPUConstants.tabContType) || "SWAVALAMBAN".equalsIgnoreCase(FPUConstants.tabContType)) {
            return true;
        }
        if (tabval == null || tabval.toString().trim().equals("--Select--")) {
            SubCellPasteValidations.errPaste("Invalid Arrear Remark ", tabrow, tabcol);
            return false;
        }
        int i = 0;
        while (i < FPUConstants.strArrearsRemark.length) {
            if (tabval.toString().trim().equalsIgnoreCase(FPUConstants.strArrearsRemark[i])) {
                tabval = FPUConstants.strArrearsRemark[i].toString();
                return true;
            }
            ++i;
        }
        SubCellPasteValidations.errPaste("Invalid Arrear Remark ", tabrow, tabcol);
        return false;
    }

    public static boolean validatecell_remarks(Object tabval, int tabrow, int tabcol) {
        String str = "";
        str = (String)FPU.fpu.panelSubDet.model.getValueAt(tabrow, 4);
        return str == null || !str.equals(FPUConstants.strContType[2]) || !str.equals(FPUConstants.strArrearsRemark[8]) || tabval != null || !tabval.toString().trim().equals("");
    }

    public static void errPaste(String msg, int tabrow, int tabcol) {
        String message = String.valueOf(msg) + " at row : " + (tabrow + 1) + " and col : " + tabcol;
        FPU.getMessage(message);
    }
}

