/*
 * Decompiled with CFR 0.152.
 */
package cra.standalone.paosubcontr.util;

import com.cra.common.util.encrypt.Hash;
import com.cra.common.util.encrypt.NCRMod11Algorithm;
import cra.standalone.paosubcontr.FPU;
import cra.standalone.paosubcontr.util.FPUConstants;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FpuUtil {
    static Hashtable htStateCodeName = new Hashtable();
    static Hashtable htStateNameCode = new Hashtable();

    private FpuUtil() {
    }

    public static String getMonthCode(String monthName) {
        if ((monthName = monthName.toUpperCase()).equals("JANUARY")) {
            return "01";
        }
        if (monthName.equals("FEBRUARY")) {
            return "02";
        }
        if (monthName.equals("MARCH")) {
            return "03";
        }
        if (monthName.equals("APRIL")) {
            return "04";
        }
        if (monthName.equals("MAY")) {
            return "05";
        }
        if (monthName.equals("JUNE")) {
            return "06";
        }
        if (monthName.equals("JULY")) {
            return "07";
        }
        if (monthName.equals("AUGUST")) {
            return "08";
        }
        if (monthName.equals("SEPTEMBER")) {
            return "09";
        }
        if (monthName.equals("OCTOBER")) {
            return "10";
        }
        if (monthName.equals("NOVEMBER")) {
            return "11";
        }
        if (monthName.equals("DECEMBER")) {
            return "12";
        }
        return "";
    }

    public static boolean isInt(String field) {
        if (field.trim() == "" || field.trim().length() == 0) {
            return false;
        }
        int i = 0;
        while (i < field.length()) {
            if (field.charAt(i) <= '/' || field.charAt(i) >= ':') {
                return false;
            }
            ++i;
        }
        try {
            Long.parseLong(field.trim());
        }
        catch (Exception e) {
            return false;
        }
        return Long.parseLong(field.trim()) >= 0L;
    }

    public static int checkCaretCount(String str) {
        int caretPos = 0;
        int caretCount = 0;
        int lastCaretPos = str.lastIndexOf("^");
        while (caretPos < lastCaretPos) {
            caretPos = str.indexOf("^", caretPos + 1);
            ++caretCount;
        }
        return caretCount;
    }

    public static String[] tokeniseDH(String strDH) {
        String[] DH = new String[11];
        int i = 0;
        int caretPos = 0;
        int nxtCaretPos = 0;
        int lastCaretPos = strDH.lastIndexOf("^");
        while (caretPos < lastCaretPos) {
            nxtCaretPos = strDH.indexOf("^", caretPos + 1);
            DH[i] = strDH.substring(caretPos + 1, nxtCaretPos);
            caretPos = nxtCaretPos;
            ++i;
        }
        DH[i] = strDH.substring(lastCaretPos + 1, strDH.length());
        return DH;
    }

    public static String[] tokeniseBH(String strBH) {
        String[] BH = new String[20];
        int i = 0;
        int caretPos = 0;
        int nxtCaretPos = 0;
        int lastCaretPos = strBH.lastIndexOf("^");
        while (caretPos < lastCaretPos) {
            nxtCaretPos = strBH.indexOf("^", caretPos + 1);
            BH[i] = strBH.substring(caretPos + 1, nxtCaretPos);
            caretPos = nxtCaretPos;
            ++i;
        }
        BH[i] = strBH.substring(lastCaretPos + 1, strBH.length());
        return BH;
    }

    public static String[] tokeniseFH(String strFH) {
        String[] FHReg = new String[17];
        int i = 0;
        int caretPos = 0;
        int nxtCaretPos = 0;
        int lastCaretPos = strFH.lastIndexOf("^");
        while (caretPos < lastCaretPos) {
            nxtCaretPos = strFH.indexOf("^", caretPos + 1);
            FHReg[i] = strFH.substring(caretPos + 1, nxtCaretPos);
            caretPos = nxtCaretPos;
            ++i;
        }
        FHReg[i] = strFH.substring(lastCaretPos + 1, strFH.length());
        return FHReg;
    }

    public static String[] tokeniseSD(String strSD) {
        String[] SD = new String[18];
        int i = 0;
        int caretPos = 0;
        int nxtCaretPos = 0;
        int lastCaretPos = strSD.lastIndexOf("^");
        while (caretPos < lastCaretPos) {
            nxtCaretPos = strSD.indexOf("^", caretPos + 1);
            SD[i] = strSD.substring(caretPos + 1, nxtCaretPos);
            caretPos = nxtCaretPos;
            ++i;
        }
        SD[i] = strSD.substring(lastCaretPos + 1, strSD.length());
        return SD;
    }

    public static long getHashofLine(String str) {
        long lineHash = 0L;
        try {
            Hash hash = new Hash();
            lineHash = hash.hashCode(str, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
        return lineHash;
    }

    public static long getFileHash(String fileName) {
        long fileHash = 0L;
        long LineNum = 0L;
        String str = "";
        long hashPerLine = 0L;
        try {
            BufferedReader in = new BufferedReader(new FileReader(fileName));
            Hash hash = new Hash();
            while ((str = in.readLine()) != null) {
                hashPerLine = hash.hashCode(str, false);
                fileHash += ++LineNum * hashPerLine;
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1L;
        }
        return fileHash;
    }

    public static boolean chkFileHash(File fileName) {
        long fileHash = 0L;
        String LngFileHash = "";
        boolean chkFile = false;
        long fileLength = 0L;
        String hashFromFile = "";
        String NameOfFile = fileName.getAbsolutePath();
        fileHash = FpuUtil.getFileHash(NameOfFile);
        LngFileHash = String.valueOf(fileHash).trim();
        try {
            RandomAccessFile raf = new RandomAccessFile(fileName, "rw");
            fileLength = raf.length();
            raf.seek(fileLength - 21L);
            hashFromFile = raf.readLine();
            return hashFromFile.trim().equals(LngFileHash);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void hashSavedFile(String filepath) {
        try {
            RandomAccessFile raf;
            if (!filepath.endsWith(".fpu")) {
                filepath = String.valueOf(filepath) + ".fpu";
                raf = new RandomAccessFile(filepath, "rw");
            } else {
                raf = new RandomAccessFile(filepath, "rw");
            }
            long fileLength = 0L;
            long hashForLine = 0L;
            long LineNum = 0L;
            long S_fileHash = 0L;
            Hash hash = new Hash();
            String str = null;
            while ((str = raf.readLine()) != null) {
                ++LineNum;
                hashForLine = FpuUtil.getHashofLine(str);
                S_fileHash += hashForLine;
            }
            fileLength = raf.length();
            raf.seek(fileLength);
            raf.writeBytes(hash.get20digitHashCode(S_fileHash));
            raf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean ReadHashFromImportedFile(String filepath) {
        try {
            RandomAccessFile raf = new RandomAccessFile(filepath, "rw");
            long fileLength = 0L;
            long hashForLine = 0L;
            long LineNum = 0L;
            long S_fileHash = 0L;
            String hashOfFile = "";
            String CalculatedHash = "";
            Hash hash = new Hash();
            String getFileHeader = "";
            String HashofImportedFile = "";
            int posOfCarat = 0;
            String typOfHeader = "";
            int caretPos = 0;
            int nxtCaretPos = 0;
            int caretCount = 0;
            String str = null;
            while ((str = raf.readLine()) != null) {
                ++LineNum;
                caretPos = 0;
                nxtCaretPos = 0;
                typOfHeader = str.substring((caretPos = str.indexOf("^", caretPos + 1)) + 1, nxtCaretPos = str.indexOf("^", caretPos + 1));
                if (typOfHeader.equals("FH")) {
                    caretPos = 0;
                    nxtCaretPos = 0;
                    caretCount = 0;
                    while (caretCount != 9) {
                        ++caretCount;
                        caretPos = str.indexOf("^", caretPos + 1);
                    }
                    nxtCaretPos = str.indexOf("^", caretPos + 1);
                    str = str.substring(0, caretPos + 1);
                } else {
                    str = str.substring(0, str.lastIndexOf("^") + 1);
                }
                hashForLine = FpuUtil.getHashofLine(str);
                S_fileHash += hashForLine * LineNum;
            }
            CalculatedHash = hash.get20digitHashCode(S_fileHash);
            raf.close();
            raf = new RandomAccessFile(filepath, "r");
            getFileHeader = raf.readLine();
            raf.close();
            posOfCarat = getFileHeader.lastIndexOf("^^^^");
            HashofImportedFile = getFileHeader.substring(posOfCarat - 20, posOfCarat);
            return HashofImportedFile.trim().equals(CalculatedHash.trim());
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean validateHashFromOpenFile(String filepath) {
        try {
            RandomAccessFile raf = new RandomAccessFile(filepath, "rw");
            long fileLength = 0L;
            long hashForLine = 0L;
            long LineNum = 0L;
            long S_fileHash = 0L;
            String hashOfFile = "";
            String CalculatedHash = "";
            Hash hash = new Hash();
            String str = null;
            while ((str = raf.readLine()) != null) {
                System.out.println("LineNum" + ++LineNum);
                hashForLine = FpuUtil.getHashofLine(str);
                System.out.println("str" + str);
                System.out.println("inside while hashForLine" + hashForLine);
                System.out.println("inside while S_fileHash " + (S_fileHash += hashForLine));
            }
            fileLength = raf.length();
            System.out.println("fileLength" + fileLength);
            raf.seek(fileLength - 20L);
            hashOfFile = raf.readLine();
            System.out.println("hashOfFile" + hashOfFile);
            hashForLine = FpuUtil.getHashofLine(hashOfFile);
            System.out.println("hashForLine" + hashForLine);
            System.out.println("S_fileHash" + (S_fileHash -= hashForLine));
            CalculatedHash = hash.get20digitHashCode(S_fileHash);
            System.out.println("CalculatedHash " + CalculatedHash);
            raf.close();
            return hashOfFile.trim().equals(CalculatedHash.trim());
        }
        catch (Exception e) {
            return false;
        }
    }

    public static ArrayList<String> validateFieldsInFPFile(String filepath) {
        System.out.println("in validateFieldsInFPFile");
        String str = null;
        ArrayList<String> errList = new ArrayList<String>();
        try {
            RandomAccessFile raf = new RandomAccessFile(filepath, "rw");
            int count = 0;
            while ((str = raf.readLine()) != null) {
                ++count;
                String[] values = str.split("\\^");
                System.out.println("Line length ::" + str.length());
                if (str.length() == 0) {
                    System.out.println("Blank LINE");
                    errList.add("Line No." + count + " is blank. Blank lines are not allowed.");
                    continue;
                }
                if (values.length < 10) {
                    System.out.println("the value of length is " + values.length);
                    errList.add("Line No. " + count + " is invalid. Not enough data in the line");
                    continue;
                }
                System.out.println("not Blank");
                if (!values[1].equals("SD")) {
                    errList.add("Record Type field should SD at Line No." + count);
                }
                if (FPU.user.equalsIgnoreCase(FPUConstants.CRALITE_SECTOR_PRAO)) {
                    Long ain = 0L;
                    System.out.println("values[2] ::" + values[2]);
                    if (values[2].matches("[0-9]")) {
                        System.out.println("inside if" + values[2]);
                        ain = Long.parseLong(values[2]);
                        System.out.println("ain inside" + ain);
                    }
                    Long div = ain / 10L;
                    Long quo = div / 7L;
                    Long rem = div - 7L * quo;
                    System.out.println("rem" + rem);
                    Long mod = ain % 10L;
                    System.out.println("ain" + ain);
                    System.out.println("mod" + mod);
                    if (values[2].length() != 7) {
                        errList.add("NL-AO Reg. No. should be of 7 digit at Line No." + count);
                    } else if (rem != mod) {
                        errList.add("Please enter a valid NL-AO Reg. No.");
                    }
                } else if (FPU.user.equalsIgnoreCase(FPUConstants.CRALITE_SECTOR_PAO)) {
                    if (values[2].length() != 10) {
                        errList.add("NL-AO Reg. No. should be of 10 digit at Line No." + count);
                    } else if (FPU.fpu.panelSubDet.checkTan(values[2])) {
                        errList.add("Invalid NL-AO Reg. No. at Line No." + count);
                    }
                }
                if (values[3].length() != 12) {
                    errList.add("Invalid PRAN : Length should be 12 characters at Line No." + count);
                } else if (!NCRMod11Algorithm.isValidNumber(values[3])) {
                    errList.add("Invalid PRAN at Line No. " + count);
                }
                if (values[4].equals("^")) {
                    errList.add("Subcriber name should not contain special characters and digits. at Line No. " + count);
                }
                if (values[5].length() > 18 || values[6].length() > 18) {
                    errList.add("Contribution Amount should not exceed 20 digits(including 2 digits after decimal point) at Line No. " + count);
                } else if (!FPU.fpu.panelSubDet.isCorrectAmt(values[5]) && !FPU.fpu.panelSubDet.isCorrectAmt(values[6])) {
                    errList.add("Contribution amount should not contain alphabets. at Line No. " + count);
                }
                if (FPU.FYFlag.equalsIgnoreCase("N")) {
                    if (!(values[7].equalsIgnoreCase("Regular") || values[7].equalsIgnoreCase("Arrears") || values[7].equalsIgnoreCase("Self-Contribution") || values[7].equalsIgnoreCase("Govt-Schemes"))) {
                        errList.add("Contribution type should be either Regular or Arrears os Self-contribution or Govt. Schemes. at Line No. " + count);
                    }
                    if (!values[8].matches("[a-zA-Z]+")) {
                        errList.add("Month entered should not be numeric. at Line No. " + count);
                    }
                    if (values[9].matches("[0-9]+")) continue;
                    errList.add("Year entered should not be alphabetic. at Line No. " + count);
                    continue;
                }
                if (!FPU.FYFlag.equalsIgnoreCase("Y")) continue;
                if (!values[7].equalsIgnoreCase("Self-Contribution") && !values[7].equalsIgnoreCase("SWAVALAMBAN")) {
                    errList.add("Contribution type should be either Self-contribution or Swavalamban at Line No. " + count);
                }
                if (values[8].equalsIgnoreCase("--Select--") || values[8].matches("[a-zA-Z]+")) continue;
                errList.add("Month entered should not be numeric. at Line No. " + count);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return errList;
    }

    public static String replaceFirst(String baseStr, String subStrOfBaseStr, String repalcement) {
        String subStr_begin = "";
        String subStr_middle = "";
        String subStr_end = "";
        String newStr = "";
        if (baseStr.indexOf(subStrOfBaseStr) >= 0) {
            int pos = baseStr.indexOf(subStrOfBaseStr);
            int last_pos = pos + subStrOfBaseStr.length();
            subStr_begin = baseStr.substring(0, pos);
            subStr_middle = repalcement;
            subStr_end = baseStr.substring(last_pos, baseStr.length());
            newStr = String.valueOf(subStr_begin) + subStr_middle + subStr_end;
            return newStr;
        }
        return baseStr;
    }

    public static void setClipboard(String str) {
        StringSelection ss = new StringSelection(str);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, null);
    }

    public static String getClipboard() {
        Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        try {
            if (t != null && t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String text = (String)t.getTransferData(DataFlavor.stringFlavor);
                System.out.println("Text in getClipBoard(): " + text);
                return text;
            }
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean validateAIN(String AIN) {
        boolean isValid = true;
        if (AIN.length() != 7) {
            isValid = false;
            return isValid;
        }
        int ain = Integer.parseInt(AIN);
        if (ain == 0) {
            isValid = false;
            return isValid;
        }
        System.out.println("PAO Reg. No." + ain);
        int div = ain / 10;
        int quo = div / 7;
        int rem = div - 7 * quo;
        int mod = ain % 10;
        if (rem != mod) {
            isValid = false;
        }
        return isValid;
    }
}

