/*
 * Decompiled with CFR 0.152.
 */
package cra.standalone.paosubcontr.celleditor;

import cra.standalone.paosubcontr.FPU;
import cra.standalone.paosubcontr.util.CheckLengthOnly;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

public class SubTableCellEditorTAN
extends AbstractCellEditor
implements TableCellEditor {
    private JComponent component = new JTextField();
    private int rowTable = 0;
    private int colTable = 0;

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex) {
        ((JTextField)this.component).setDocument(new CheckLengthOnly(10));
        if (value == null) {
            ((JTextField)this.component).setText(null);
        } else {
            ((JTextField)this.component).setText((String)value);
        }
        this.rowTable = rowIndex;
        this.colTable = vColIndex;
        return this.component;
    }

    public Object getCellEditorValue() {
        String returnObj = ((JTextField)this.component).getText().toUpperCase();
        if (((JTextField)this.component).getText().toString().trim().equalsIgnoreCase("tan")) {
            returnObj = null;
        } else if (((JTextField)this.component).getText().toString().trim().length() != 7 && ((JTextField)this.component).getText().toString().trim().length() != 10) {
            FPU.getMessage("Invalid NL-AO / NL CC Reg. No  : Length should be 7 or 10 characters");
            FPU.fpu.setErrorAt(this.rowTable, this.colTable);
            returnObj = null;
        }
        if (((JTextField)this.component).getText().toString().trim().length() == 10 && FPU.fpu.panelSubDet.checkTan(((JTextField)this.component).getText().toString().trim())) {
            FPU.getMessage("Invalid NL-CC Reg. No");
            FPU.fpu.setErrorAt(this.rowTable, this.colTable);
            returnObj = null;
        }
        if (((JTextField)this.component).getText().toString().trim().length() == 7) {
            String AIN = ((JTextField)this.component).getText().toString().trim();
            try {
                int ain = Integer.parseInt(AIN);
                int div = ain / 10;
                int quo = div / 7;
                int rem = div - 7 * quo;
                int mod = ain % 10;
                if (rem != mod) {
                    FPU.getMessage("Please enter a valid NL-AO Reg. No.");
                    FPU.fpu.setErrorAt(this.rowTable, this.colTable);
                    returnObj = null;
                }
            }
            catch (NumberFormatException ne) {
                FPU.getMessage("NL-AO Reg. No. should be Integer of Length 7");
                FPU.fpu.setErrorAt(this.rowTable, this.colTable);
                returnObj = null;
            }
        }
        FPU.fpu.setNoErrorAt(this.rowTable, this.colTable);
        return returnObj;
    }

    public boolean isCellEditable(EventObject evt) {
        boolean isCellEditable = true;
        if (evt instanceof MouseEvent) {
            int clickCount = 2;
            isCellEditable = ((MouseEvent)evt).getClickCount() >= clickCount;
        }
        return isCellEditable;
    }
}

